/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.helper;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.mail.AuthenticationFailedException;
import javax.mail.Authenticator;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.IssueType;
import kd.imc.bdm.common.enums.CacheKeyEnum;
import kd.imc.bdm.common.helper.BdmConditionMatchHelper;
import kd.imc.bdm.common.helper.InvoiceFileUrlInfoHelper;
import kd.imc.bdm.common.model.InvoiceFileUrlInfo;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.sdk.annotation.SdkDeprecated;

public class MailSettingHelper {
    private static Map<String, String> showMap = new HashMap<String, String>();
    private static final Log LOGGER = LogFactory.getLog(MailSettingHelper.class);
    public static String[] defaultMultiFields = new String[]{"enteridentity", "uploaddate", "buyername", "salername", "number", "originalinvoicecode", "originalinvoiceno"};
    private static final String[] ctrlStrategy;

    private MailSettingHelper() {
    }

    public static StringBuilder setRichTextTable(String html) {
        StringBuilder sb = new StringBuilder(html.replace("<h1>", "<h1 style=\"font-size: 18px;color: #333;margin-top: 30px;margin-left: 28px;\">").replace("<p>", "<p style=\"font-size: 14px;color: #333;font-family: '\u5fae\u8f6f\u96c5\u9ed1';margin: 0;line-height: 26px;text-indent: 2em;\">"));
        int tableIndex = sb.indexOf("<table");
        while (tableIndex != -1) {
            sb.replace(tableIndex, sb.indexOf(">", tableIndex) + 1, "<table style=\" width: 670px;height: 100px;background: #ECF2F8;padding: 10px;margin: 15px 0px 15px 0px ;border: thick double #ADC5DE;\">");
            tableIndex = sb.indexOf("<table", tableIndex + 1);
        }
        return sb;
    }

    public static String getShowTemplate(String text) {
        return MailSettingHelper.setRichTextTable(MailSettingHelper.replacePlaceholder(text)).toString();
    }

    public static String replacePlaceholder(String text) {
        if (null == text) {
            return "";
        }
        StringBuilder sb = new StringBuilder(text);
        for (Map.Entry<String, String> entry : showMap.entrySet()) {
            String field = String.format("[&%s&]", entry.getKey());
            int index = sb.indexOf(field);
            if (index != -1) {
                sb.replace(index, index + field.length(), entry.getValue());
            }
            if ((index = sb.indexOf(field = String.format("[&amp;%s&amp;]", entry.getKey()))) == -1) continue;
            sb.replace(index, index + field.length(), entry.getValue());
        }
        return sb.toString();
    }

    @SdkDeprecated
    public static String replacePlaceholder(String text, DynamicObject invoice, Boolean isTitle) {
        StringBuilder sb = new StringBuilder(text);
        Map<String, String> selectMap = MailSettingHelper.getSelectMap();
        for (Map.Entry<String, String> entry : selectMap.entrySet()) {
            String field = String.format("[&%s&]", entry.getValue());
            int index = sb.indexOf(field);
            if (index == -1) {
                field = String.format("[&amp;%s&amp;]", entry.getValue());
                index = sb.indexOf(field);
            }
            while (index != -1) {
                Object value = invoice.get(entry.getKey());
                if (null == value) {
                    value = "";
                }
                value = MailSettingHelper.optimiseValue(entry.getKey(), value);
                if (("fileurl".equals(entry.getKey()) || "snapshoturl".equals(entry.getKey())) && StringUtils.isBlank((Object)value)) {
                    LOGGER.info("InvoiceFileUrlInfoHelper\u83b7\u53d6\u6587\u4ef6\u4e0b\u8f7d\u5730\u5740");
                    InvoiceFileUrlInfo fileUrlInfo = InvoiceFileUrlInfoHelper.getFileUrlInfoByInvoice(invoice);
                    invoice.set("fileurl", (Object)fileUrlInfo.getFileUrl());
                    invoice.set("snapshoturl", (Object)fileUrlInfo.getSnapshotUrl());
                    value = invoice.get(entry.getKey());
                }
                if (entry.getValue().equals("JPG\u6587\u4ef6\u4e0b\u8f7d\u5730\u5740") || entry.getValue().equals("ofd\u6587\u4ef6\u4e0b\u8f7d\u5730\u5740") || InvoiceUtils.isAllEInvoice(invoice.getString("invoicetype")) && entry.getValue().equals("pdf\u6587\u4ef6\u4e0b\u8f7d\u5730\u5740")) {
                    value = String.format("<a style=\"color: #3078EC;\" href=\"%s\">%s</a>", value, value);
                }
                if (InvoiceUtils.isAllEInvoice(invoice.getString("invoicetype")) && entry.getValue().equals("xml\u6587\u4ef6\u4e0b\u8f7d\u5730\u5740")) {
                    value = String.format("<a style=\"color: #3078EC;\" href=\"%s\">%s</a>", value, value);
                }
                if (entry.getValue().equals("\u6e05\u5355\u6807\u8bc6")) {
                    Object object = value = value.equals("1") ? "\u6709\u6e05\u5355" : "\u65e0\u6e05\u5355";
                }
                if (value.getClass().equals(Date.class) || value.getClass().equals(Timestamp.class)) {
                    value = DateUtils.format(invoice.getDate(entry.getKey()), "yyyy-MM-dd");
                } else if (value.getClass().equals(BigDecimal.class)) {
                    value = String.format("%.2f", new BigDecimal(value.toString()).stripTrailingZeros());
                }
                sb = sb.replace(index, index + field.length(), String.valueOf(value));
                index = sb.indexOf(field);
            }
        }
        if (!isTitle.booleanValue()) {
            sb = MailSettingHelper.setRichTextTable(sb.toString());
            sb.insert(0, "<div style=\"width: 800px;margin: 0 auto;\">");
            sb.append("</div>");
        }
        return sb.toString();
    }

    private static Object optimiseValue(String key, Object value) {
        if ("invoicetype".equals(key)) {
            return InvoiceType.getDescription((String)value);
        }
        if ("issuetime".equals(key)) {
            return DateUtils.format((Date)value);
        }
        if ("issuetype".equals(key)) {
            if (IssueType.BLUE_INVOICE.getTypeCode().equals(value)) {
                return "\u84dd\u7968";
            }
            return "\u7ea2\u7968";
        }
        if ("inventorymark".equals(key)) {
            if ("1".equals(value)) {
                return "\u6709\u6e05\u5355";
            }
            return "\u65e0\u6e05\u5355";
        }
        if (String.valueOf(key).contains("amount")) {
            return ((BigDecimal)value).setScale(2, RoundingMode.HALF_UP).toPlainString();
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).stripTrailingZeros().toPlainString();
        }
        return value;
    }

    public static Session getEmailSession(final DynamicObject email) {
        int port = email.getInt("port");
        String serverAddress = email.getString("serveraddress");
        Properties properties = new Properties();
        properties.setProperty("mail.smtp.host", serverAddress);
        properties.put("mail.smtp.auth", "true");
        if (email.getBoolean("ssl")) {
            if ("smtp.office365.com".equals(email.getString("serveraddress"))) {
                properties.setProperty("mail.smtp.starttls.enable", "true");
                properties.setProperty("mail.smtp.starttls.required", "false");
            } else {
                properties.setProperty("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
                properties.setProperty("mail.smtp.socketFactory.fallback", "false");
                properties.setProperty("mail.smtp.socketFactory.port", String.valueOf(port));
            }
        }
        if ("1".equals(ImcConfigUtil.getValue("useOffice365", "useOffice365"))) {
            properties.setProperty("mail.smtp.starttls.enable", "true");
            properties.setProperty("mail.smtp.starttls.required", "false");
        }
        properties.setProperty("mail.smtp.port", String.valueOf(port));
        MailSettingHelper.setSendMailTimeOut(properties);
        MailSettingHelper.addProxy(properties);
        MailSettingHelper.addExtProperties(properties, serverAddress);
        if ("1".equals(ImcConfigUtil.getValue("bdm_mail", "use_old_auth"))) {
            return Session.getInstance((Properties)properties);
        }
        Authenticator authenticator = new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(email.getString("username"), email.getString("password"));
            }
        };
        return Session.getInstance((Properties)properties, (Authenticator)authenticator);
    }

    public static void setSendMailTimeOut(Properties props) {
        props.setProperty("mail.smtp.connectiontimeout", "40000");
        props.setProperty("mail.smtp.timeout", "40000");
        props.setProperty("mail.smtp.writetimeout", "40000");
    }

    public static void addProxy(Properties properties) {
        String hostProxy = ImcConfigUtil.getValue(CacheKeyEnum.EMAIL_SOCKS_HOST_PROXY);
        String portProxy = ImcConfigUtil.getValue(CacheKeyEnum.EMAIL_SOCKS_PORT_PROXY);
        String httpHostProxy = ImcConfigUtil.getValue(CacheKeyEnum.EMAIL_SOCKS_HTTP_HOST_PROXY);
        String httpPortProxy = ImcConfigUtil.getValue(CacheKeyEnum.EMAIL_SOCKS_HTTP_PORT_PROXY);
        if ("2".equals(ImcConfigUtil.getValue("mailProxyType", "mailProxyType"))) {
            if (StringUtils.isNotBlank((CharSequence)httpHostProxy) && StringUtils.isNotBlank((CharSequence)httpPortProxy)) {
                LOGGER.info("proxySession2");
                properties.setProperty("mail.smtp.proxy.host", httpHostProxy);
                properties.setProperty("mail.smtp.proxy.port", httpPortProxy);
            }
        } else if ("1".equals(ImcConfigUtil.getValue("mailProxyType", "mailProxyType"))) {
            if (StringUtils.isNotBlank((CharSequence)hostProxy) && StringUtils.isNotBlank((CharSequence)portProxy)) {
                LOGGER.info("proxySession1");
                properties.setProperty("proxySet", "true");
                properties.setProperty("socksProxyHost", hostProxy);
                properties.setProperty("socksProxyPort", portProxy);
            }
        } else if ("3".equals(ImcConfigUtil.getValue("mailProxyType", "mailProxyType")) && StringUtils.isNotBlank((CharSequence)httpHostProxy) && StringUtils.isNotBlank((CharSequence)httpPortProxy)) {
            LOGGER.info("proxySession3");
            properties.setProperty("mail.smtp.host", httpHostProxy);
            properties.setProperty("mail.smtp.port", httpPortProxy);
        }
    }

    public static void addExtProperties(Properties properties, String serverAddress) {
        String config;
        Map<String, String> requestHeader = ImcConfigUtil.getValue("bdm_mail_param");
        if (!CollectionUtils.isEmpty(requestHeader) && !StringUtils.isEmpty((CharSequence)(config = requestHeader.get(serverAddress)))) {
            JSONObject json = JSONObject.parseObject((String)config);
            for (Map.Entry entry : json.entrySet()) {
                if ("".equals(entry.getValue())) {
                    properties.remove(entry.getKey());
                    continue;
                }
                if (entry.getValue() == null) continue;
                properties.setProperty((String)entry.getKey(), entry.getValue().toString());
            }
        }
    }

    public static String testMailServer(DynamicObject email) {
        Session session = MailSettingHelper.getEmailSession(email);
        try {
            Transport transport = session.getTransport("smtp");
            transport.connect(email.getString("username"), email.getString("password"));
            transport.close();
        }
        catch (AuthenticationFailedException e) {
            LOGGER.error("\u7528\u6237\u9a8c\u8bc1\u5931\u8d25", (Throwable)e);
            return "\u7528\u6237\u9a8c\u8bc1\u5931\u8d25";
        }
        catch (MessagingException e) {
            LOGGER.error("\u65e0\u6cd5\u8fde\u63a5\u5230\u670d\u52a1\u5668", (Throwable)e);
            return "\u65e0\u6cd5\u8fde\u63a5\u5230\u670d\u52a1\u5668";
        }
        return "";
    }

    public static String generateContentTable(String fields, List<DynamicObject> invoices, Map<String, String> map) {
        String[] fieldArray = fields.split(",");
        StringBuilder tableBuilder = new StringBuilder();
        tableBuilder.append("<div class=\"tableCont\" style=\"width: 100%;overflow:scroll hidden;border: 1px solid #999;\">");
        tableBuilder.append("<table style=\"border: 1px solid #999;border-collapse: collapse;margin: 0;\">");
        tableBuilder.append("<thead style=\"border-bottom: 1px solid #666;background-color: #eaeaea;\">");
        tableBuilder.append("<tr>");
        for (String s : fieldArray) {
            tableBuilder.append("<th style=\"min-width: 160px;padding: 5px 0;color: #212121;border: 1px solid;flex-shrink: 0;\">");
            tableBuilder.append(map.get(s));
            tableBuilder.append("</th>");
        }
        tableBuilder.append("</tr>");
        tableBuilder.append("</thead>");
        tableBuilder.append("<tbody>");
        for (DynamicObject invoice : invoices) {
            tableBuilder.append("<tr>");
            for (String s : fieldArray) {
                tableBuilder.append("<td style=\"min-width: 160px;text-align: center;padding: 5px 0;color: #333;border: 1px solid;flex-shrink: 0;font-size:14px\">");
                Object value = invoice.get(s);
                if (null == value) {
                    value = "";
                }
                value = MailSettingHelper.optimiseValue(s, value);
                tableBuilder.append(value);
                tableBuilder.append("</td>");
            }
            tableBuilder.append("</tr>");
        }
        tableBuilder.append("</tbody>");
        tableBuilder.append("</table>");
        tableBuilder.append("</div>");
        return tableBuilder.toString();
    }

    public static String generateDefaultContent(List<DynamicObject> invoices) {
        StringBuilder tableBuilder = new StringBuilder();
        tableBuilder.append("<html lang=\"en\">\n    <head>\n        <meta charset=\"UTF-8\" />\n        <meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge\"/>\n        <meta name=\"viewport\" content=\"maximum-scale=1.0,minimum-scale=1.0,user-scalable=0,width=device-width,initial-scale=1.0\"/>\n        <style type=\"text/css\">\n            *{margin: 0;padding: 0;}\n            body { width: 100%;background: #f8f8f8;padding: 0;margin: 0; }\n            p { margin: 0; padding: 0; }\n            .container {min-width: 1200px;margin: 0 auto;background: #f8f8f8; padding: 20px 5%; box-sizing: border-box;}\n            .header {background: #5582f3;font-size: 14px;color: #d9d9d9;padding: 13px 150px;box-sizing: border-box;}\n            .header img {height: 24px;width: auto;vertical-align: middle;}\n            .content {width: 100%;margin: 0 auto; padding: 0 150px;box-sizing: border-box;}\n            .content .linkCont {width: 100%;position: relative;}\n            .content .linkCont .link_txt {width: 600px;}\n            .content .linkCont .imgIcon {width: 120px;height: auto;font-size: 12px;color: #999;position: absolute;right: 10px;top: 10px;}\n            .content .linkCont .imgIcon img {width: 120px;height: 120px;}\n            .nav {font-size: 16px;font-weight: 600;color: #212121;margin-top: 40px;margin-bottom: 12px;}\n            .tips {font-size: 14px;font-weight: 400;color: #212121;margin-bottom: 4px;}\n            .title {font-size: 18px;font-weight: 600;color: #212121;}\n            .box {\n            background: #f2f6ff;\n            padding: 16px 24px;\n            margin-top: 8px;\n            margin-bottom: 40px;\n            border-radius: 8px;\n            -webkit-border-radius: 8px;\n            position: relative;\n            }\n            .box .box_title {font-size: 14px;font-weight: bold;margin-bottom: 10px;}\n            .box .box-cont {color: #666;margin-bottom: 10px;font-size: 16px;}\n            .box .box_tips {font-size: 16px;line-height: 26px;color: #666;}\n            .link {margin-top: 16px;}\n            .link .link_title {font-size: 14px;font-weight: bold;}\n            .link .link_name {cursor: pointer;color: #3598ff;font-size: 16px;display: inline-block;width:850px}\n            .link .link_name:hover {color: #86d9f0;}\n            .box .box-txt {margin-left: 5px;color: #212121;}\n            .second_title {color: #212121;font-weight: bold;}\n            .table {\n            width: 100%;\n            font-size: 14px;\n            line-height: 1.5;\n            border-top: 1px solid #d9d9d9;\n            border-left: 1px solid #d9d9d9;\n            border-right: 1px solid #d9d9d9;\n            margin-top: 8px;\n            margin-left: 13px;\n            margin-right: 18px;\n            }\n            .last-table {\n            width: 100% !important;\n            margin-left: 0 !important;\n            }\n            .table th {\n            width: 50%;\n            height: 38px;\n            text-align: left;\n            padding-left: 12px;\n            font-size: 14px;\n            color: #212121;\n            font-weight: 400;\n            border-bottom: 1px solid #d9d9d9;\n            }\n            .table-title {\n            background: #f2f2f2;\n            }\n            .table-title:last-child {\n            border-left: 1px solid #d9d9d9;;\n            }\n        </style>\n    </head>\n    <body>\n        <div class='container'>\n            <div class=\"contentTxt\" style=\"background: #fff;width: 1200px;margin: 0 auto;\">\n                <div class='header'>\n                    <img src=\"https://img.piaozone.com/static/gallery/img/digital/pic_logo.png\" alt=\"slogan\" />\n                    <span style=\"display: inline-block;margin: 0 10px; width:1px;height: 12px;background-color: #d9d9d9;\"></span>\n                    <span style=\"color:#fff\">\u7528\u79d1\u6280\u52a9\u529b\u7eff\u8272\u8d22\u7a0e\u65b0\u65f6\u4ee3</span>\n                </div>\n                <div class='content'>\n                    <p class='nav'>\u5c0a\u656c\u7684\u7528\u6237, \u60a8\u597d</p>\n                    \n                    <p class='tips'>\u60a8\u7533\u8bf7\u7684\u53d1\u7968\u6587\u4ef6\u5df2\u7ecf\u751f\u6210\uff0c\u53d1\u7968\u4fe1\u606f\u5982\u4e0b\u6240\u793a:</p>\n                    <table class='table last-table' cellspacing='0'>\n                        <thead>\n                            <tr>\n                                <th class='table-title' style=\"width:30px\">#</th>\n                                <th class='table-title' style=\"width:180px\">\u53d1\u7968\u62ac\u5934</th>\n                                <th class='table-title' style=\"width:100px\">\u5f00\u7968\u91d1\u989d</th>\n                                <th class='table-title' style=\"width:100px\">\u53d1\u7968\u4ee3\u7801</th>\n                                <th class='table-title' style=\"width:90px\">\u53d1\u7968\u53f7\u7801</th>\n                                <th class='table-title' style=\"width:120px\">\u5f00\u7968\u65f6\u95f4</th>\n                            </tr>\n                            ");
        for (int i = 0; i < invoices.size(); ++i) {
            DynamicObject invoice = invoices.get(i);
            tableBuilder.append("<tr>");
            tableBuilder.append("<th style=\"width:30px\">").append(i + 1).append("</th>");
            tableBuilder.append("<th style=\"width:180px\">").append(invoice.get("buyername")).append("</th>");
            tableBuilder.append("<th style=\"width:90px\">").append(MailSettingHelper.optimiseValue("invoiceamount", invoice.get("invoiceamount"))).append("</th>");
            tableBuilder.append("<th style=\"width:100px\">").append(invoice.get("invoicecode")).append("</th>");
            tableBuilder.append("<th style=\"width:100px\">").append(invoice.get("invoiceno")).append("</th>");
            tableBuilder.append("<th style=\"width:120px\">").append(MailSettingHelper.optimiseValue("issuetime", invoice.get("issuetime"))).append("</th>");
            tableBuilder.append("<tr>");
        }
        tableBuilder.append("                </thead>\n            </table>\n            <p class='tips'>\u60a8\u7533\u8bf7\u7684\u53d1\u7968\u6587\u4ef6\u5df2\u7ecf\u751f\u6210\uff0c\u53d1\u7968\u4fe1\u606f\u5982\u4e0b\u6240\u793a:</p>\n        <div class=\"linkCont\">\n            <div class=\"link_txt\">\n                <p class=\"second_title\" style=\"margin-top:40px;margin-bottom: 8px;\">\u8bf7\u70b9\u51fb\u4e0b\u9762\u7684\u5730\u5740\uff08\u6709\u6548\u671f\u4e09\u4e2a\u6708\uff09\u4e0b\u8f7d\u9700\u8981\u7684\u683c\u5f0f\uff0c\u4ee5\u4fbf\u4f5c\u4e3a\u60a8\u7ef4\u6743\u51ed\u8bc1\u548c\u62a5\u9500\u51ed\u8bc1</p>\n                <span class=\"tips\">\u5982\u70b9\u51fb\u65e0\u6548\uff0c\u8bf7\u590d\u5236\u94fe\u63a5\u5730\u5740\u5230\u6d4f\u89c8\u5668\u4e2d\u6253\u5f00</span>\n                <div class=\"link\">\n                    <a class=\"link_name\" href='[&amp;zip\u6587\u4ef6\u4e0b\u8f7d\u5730\u5740&amp;]' target=\"_blank\">[&amp;zip\u6587\u4ef6\u4e0b\u8f7d\u5730\u5740&amp;]</a>\n                </div>\n            </div>\n        </div>\n\n        <div class='box' style=\"margin-top:80px\">\n            <p class=\"box_title\">\u6e29\u99a8\u63d0\u793a</p>\n            <p class=\"box_tips\">OFD\u7248\u5f0f\u6587\u4ef6\u7535\u5b50\u53d1\u7968\uff0c\u9700\u589e\u503c\u7a0e\u7535\u5b50\u53d1\u7968OFD\u9605\u8bfb\u5668\u624d\u80fd\u6253\u5f00\uff0c\u70b9\u51fb\u4e0b\u65b9\u94fe\u63a5\u4e0b\u8f7d\u9605\u8bfb\u5668\uff1a</p>\n            <a class=\"box_tips\" href=\"https://guangdong.chinatax.gov.cn/gdsw/mmsw_xzfw/2022-11/23/content_bceb9b78d80e46a89d0b41a9abdf469e.shtml\" target=\"_blank\">https://guangdong.chinatax.gov.cn/gdsw/mmsw_xzfw/2022-11/23/content_bceb9b78d80e46a89d0b41a9abdf469e.shtml</a>\n        </div>\n    </div>\n    <table\n            class=\"footer\"\n            style=\"background: #2a395d;padding-top: 32px;height: 170px;padding: 24px 148px;box-sizing: border-box;width: 100%;\"\n    >\n        <tbody>\n            <tr>\n                <td>\n                    <a href=\"https://www.kdfpy.com\"><img src= \"https://img.piaozone.com/static/gallery/img/digital/banner.png\" alt=\"banner\"></a>\n                </td>\n            </tr>\n        </tbody>\n    </table>\n</div>\n        </div>\n        </body>\n        </html>");
        return tableBuilder.toString();
    }

    public static String replacceKey2Value(String emailBody, String key, String uploadZipFileUrl) {
        if ((emailBody = emailBody.replace(key, uploadZipFileUrl)).contains(key)) {
            return MailSettingHelper.replacceKey2Value(emailBody, key, uploadZipFileUrl);
        }
        return emailBody;
    }

    public static String makeRedMailContent(DynamicObject emailObject, List<DynamicObject> redConfirmBills, Boolean isCustom) {
        if (!isCustom.booleanValue()) {
            return MailSettingHelper.buildRedMailContent(redConfirmBills, defaultMultiFields, false);
        }
        if (redConfirmBills.size() == 1) {
            String[] itemfields = null;
            if (StringUtils.isNotEmpty((CharSequence)emailObject.getString("itemmultifields"))) {
                itemfields = emailObject.getString("itemmultifields").split(",");
            }
            return MailSettingHelper.buildRedMailContent(redConfirmBills, null, itemfields, false, true, MailSettingHelper.replaceMailBody(redConfirmBills.get(0), emailObject.getString("mailbody_tag"), Boolean.TRUE));
        }
        if (redConfirmBills.size() > 1) {
            String[] fields = emailObject.getString("multifields").split(",");
            return MailSettingHelper.buildRedMailContent(redConfirmBills, fields, null, false, true, MailSettingHelper.replaceMailBody(redConfirmBills.get(0), emailObject.getString("multimailbody_tag"), Boolean.TRUE));
        }
        return "";
    }

    public static String buildRedMailContent(List<DynamicObject> redConfirmBills, String[] multiFields, boolean virtual) {
        return MailSettingHelper.buildRedMailContent(redConfirmBills, multiFields, null, virtual, false, "");
    }

    private static String buildRedMailContent(List<DynamicObject> redConfirmBills, String[] multiFields, String[] itemsMultiFields, boolean virtual, boolean isCustom, String text) {
        Map<String, String> redConfirmMap = MailSettingHelper.getRedConfirmMap();
        Map<String, String> redCornfirmItemMap = MailSettingHelper.getRedConfirmItemMap();
        StringBuilder pageBuilder = new StringBuilder();
        pageBuilder.append("<!DOCTYPE html>\n<html lang=\"en\">\n<head>\n    <meta charset=\"UTF-8\" />\n    <meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge,chrome=1\" />\n    <meta name=\"renderer\" content=\"webkit\" />\n    <meta name=\"viewport\" content=\"width=device-width,initial-scale=1,minimum-scale=1,maximum-scale=1,user-scalable=no\" />\n    <style type=\"text/css\">        * {\n            margin: 0;\n            padding: 0;\n        }\n\n        body {\n            width: 100%;\n            background: #f8f8f8;\n            padding: 0;\n            margin: 0;\n        }\n\n        p {\n            margin: 0;\n            padding: 0;\n        }\n\n        .container {\n            max-width: 1800px;\n            margin: 0 auto;\n            background: #f8f8f8;\n            padding: 20px 5%;\n            box-sizing: border-box;\n        }\n\n        .contentTxt {\n            background: #fff;\n            margin: 0 auto;\n        }\n\n        .header {\n            display: flex;\n            align-items: center;\n            height: 30px;\n            padding: 12px 20px;\n            color: #d9d9d9;\n            font-size: 14px;\n            background: #5582f3;\n        }\n\n        .heaer-line {\n            display: inline-block;\n            margin: 0 6px;\n            width:1px;\n            height: 12px;\n            background-color: #d9d9d9;\n        }\n\n        .heaer-text {\n            padding-bottom: 4px;\n            font-size: 12px;\n        }\n\n        .content {\n            width: 100%;\n            margin: 0 auto;\n            padding: 0 20px;\n            box-sizing: border-box;\n        }\n\n        .content .nav {\n            margin-top: 40px;\n            margin-bottom: 12px;\n            font-size: 16px;\n            font-weight: bold;\n            color: #212121;\n        }\n\n        .content .box {\n            padding: 16px 24px;\n            margin-top: 8px;\n            margin-bottom: 40px;\n            font-size: 14px;\n            background: #f2f6ff;\n            border-radius: 8px;\n            -webkit-border-radius: 8px;\n        }\n\n        .content .box .box-cont {\n            display: flex;\n            padding-top: 6px;\n        }\n\n        .content .box .box-cont .label {\n            width: 80px;\n        }\n\n        .content .box .box-cont .text {\n            flex-grow: 1;\n            width: 170px;\n            word-wrap: break-word;\n            overflow-wrap: break-word;\n            white-space: normal;\n            color:#212121\n        }\n\n        .linkCont {\n            width: 100%;\n           \n        }\n\n        .link-txt {\n\n        }\n\n        .second-title {\n            margin-top:40px;\n            margin-bottom: 8px;\n            color: #212121;\n            font-weight: bold;\n        }\n\n        .tips {\n            font-size: 14px;\n            font-weight: 400;\n            color: #212121;\n            margin-bottom: 4px;\n        }\n\n        .link {\n            margin-top: 16px;\n            \n        }\n\n        .link .link-title {\n            font-size: 14px;\n            font-weight: bold;\n        }\n\n        .link .link-name {\n            cursor: pointer;\n            color: #3598ff;\n            font-size: 16px;\n            display: inline-block;\n\n            width: 100%;\n            word-wrap: break-word;\n            overflow-wrap: break-word;\n            white-space: normal;\n        }\n\n        .link .link-name:hover {\n            color: #86d9f0;\n        }\n\n        .box .box-title {\n            font-size: 14px;\n            font-weight: bold;\n            margin-bottom: 10px;\n        }\n\n        .box .box-tips {\n            width: 100%;\n            word-wrap: break-word;\n            overflow-wrap: break-word;\n            white-space: normal;\n\n            font-size: 16px;\n            line-height: 26px;\n            color: #666;\n        }\n\n        .footer {\n            display: flex;\n            align-items: center;\n            justify-content: center;\n            min-height: 40px;\n            padding: 20px 20px;\n            background: #2a395d;\n        }\n\n        .footer a {\n            width: 100%;\n        }\n\n        .footer img {\n            width: 80%;\n        }\n\n        table {\n            width: 100%;\n            border-collapse: collapse;\n            margin-top: 20px;\n            margin-bottom: 50px;\n            overflow-x: auto;\n        }\n        th, td {\n            min-width: 40px;\n            border: 1px solid #ddd;\n            padding: 12px;\n            text-align: center;\n        }\n        th {\n            min-width: 120px;\n            background-color: #f2f2f2;\n        }\n    </style>\n</head>\n<body>\n    <div class='container'>\n");
        if (!isCustom) {
            pageBuilder.append("<div class=\"contentTxt\">            <div class='header' \n                style=\"display: flex;\n                align-items: center;\n                height: 30px;\n                padding: 12px 0px;\n                color: #d9d9d9;\n                font-size: 14px;\n                background: #5582f3;\"\n            >                <span style=\"display: inline-block;width: 14px\"></span>\n                <img src=\"https://img.piaozone.com/static/gallery/img/digital/pic_logo.png\" alt=\"slogan\" style=\"display: inline-block;\"/>\n                <span class=\"heaer-line\" style=\"display: inline-block;\n                margin: 0 4px;\n                width:1px;\n                height: 12px;\n                background-color: #d9d9d9;\"></span>\n                <span class=\"heaer-text\" style=\"color:#fff\">").append(ResManager.loadKDString((String)"\u7528\u79d1\u6280\u52a9\u529b\u7eff\u8272\u8d22\u7a0e\u65b0\u65f6\u4ee3", (String)"MailSettingHelper_12", (String)"imc-bdm-common", (Object[])new Object[0])).append("</span>\n            </div>\n            <div class='content'>\n");
            pageBuilder.append("                <p class='nav'>").append(ResManager.loadKDString((String)"\u5c0a\u656c\u7684\u7528\u6237, \u60a8\u597d", (String)"MailSettingHelper_13", (String)"imc-bdm-common", (Object[])new Object[0])).append("</p>\n").append("                <p class='tips'>").append(ResManager.loadKDString((String)"\u8bf7\u53ca\u65f6\u5904\u7406\u5982\u4e0b\u786e\u8ba4\u5355\uff0c\u8d85\u8fc772\u5c0f\u65f6\u672a\u5904\u7406\uff0c\u7ea2\u5b57\u786e\u8ba4\u5355\u5c06\u5931\u6548", (String)"MailSettingHelper_14", (String)"imc-bdm-common", (Object[])new Object[0])).append("</p>\n");
        } else {
            pageBuilder.append("                <pre>").append(text).append("                </pre>");
        }
        if (virtual) {
            pageBuilder.append("            <table>\n").append("                <thead>\n").append("                    <tr>\n").append("                        <th>").append(redConfirmMap.get("enteridentity")).append("</th>\n                        <th>").append(redConfirmMap.get("uploaddate")).append("</th>\n                        <th>").append(redConfirmMap.get("buyername")).append("</th>\n                        <th>").append(redConfirmMap.get("salername")).append("</th>\n                        <th>").append(redConfirmMap.get("number")).append("</th>\n                        <th>").append(redConfirmMap.get("originalinvoicecode")).append("</th>\n                        <th>").append(redConfirmMap.get("originalinvoiceno")).append("</th>\n                    </tr>\n                </thead>\n");
            for (int i = 0; i < 5; ++i) {
                pageBuilder.append("                <tbody>\n                    <tr>\n                        <td></td>\n                        <td></td>\n                        <td></td>\n                        <td></td>\n                        <td></td>\n                        <td></td>\n                        <td></td>\n                    </tr>\n                </tbody>");
            }
            pageBuilder.append("            </table>\n");
        } else if (itemsMultiFields != null && itemsMultiFields.length > 0) {
            pageBuilder.append("                <div style=\"width: 100%; overflow-x: auto;\">\n").append("                    <table>\n").append("                        <thead>\n").append("                            <tr>\n").append("                                <th style=\"min-width: 40px\">").append(ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"MailSettingHelper_23", (String)"imc-bdm-common", (Object[])new Object[0])).append("</th>\n");
            for (String itemMultiField : itemsMultiFields) {
                pageBuilder.append("                                <th>").append(redCornfirmItemMap.get(itemMultiField)).append("</th>\n");
            }
            pageBuilder.append("                            </tr>\n                        </thead>\n                        <tbody>\n");
            DynamicObjectCollection redConfiremItems = redConfirmBills.get(0).getDynamicObjectCollection("items");
            for (int i = 0; i < redConfiremItems.size(); ++i) {
                pageBuilder.append("                            <tr>\n                                <td>").append(i + 1).append("</td>\n");
                block42: for (String itemMultiField : itemsMultiFields) {
                    String value = "";
                    switch (itemMultiField) {
                        case "amount": 
                        case "taxamount": 
                        case "tax": {
                            value = ((DynamicObject)redConfiremItems.get(i)).getBigDecimal(itemMultiField).setScale(2, RoundingMode.HALF_UP).toPlainString();
                            pageBuilder.append("                                <td>").append(value).append("</td>\n");
                            continue block42;
                        }
                        case "num": 
                        case "unitprice": 
                        case "taxunitprice": {
                            value = new BigDecimal(((DynamicObject)redConfiremItems.get(i)).getBigDecimal(itemMultiField).stripTrailingZeros().toString()).toPlainString();
                            pageBuilder.append("                                <td>").append(value).append("</td>\n");
                            continue block42;
                        }
                        default: {
                            pageBuilder.append("                        <td>").append(((DynamicObject)redConfiremItems.get(i)).getString(itemMultiField)).append("</td>\n");
                        }
                    }
                }
                pageBuilder.append("                            </tr>\n");
            }
            pageBuilder.append("                        </tbody>\n                    </table>\n");
        } else if (multiFields != null) {
            pageBuilder.append("                <div style=\"width: 100%; overflow-x: auto;\">\n").append("                    <table>\n").append("                        <thead>\n").append("                            <tr>\n").append("                                <th style=\"min-width: 40px\">").append(ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"MailSettingHelper_23", (String)"imc-bdm-common", (Object[])new Object[0])).append("</th>\n");
            for (String multiField : multiFields) {
                pageBuilder.append("                                <th>").append(redConfirmMap.get(multiField)).append("</th>\n");
            }
            pageBuilder.append("                            </tr>\n                        </thead>\n                        <tbody>\n");
            for (int i = 0; i < redConfirmBills.size(); ++i) {
                pageBuilder.append("                            <tr>\n                                <td>").append(i + 1).append("</td>\n");
                block45: for (String multiField : multiFields) {
                    String value = "";
                    switch (multiField) {
                        case "enteridentity": {
                            value = redConfirmBills.get(i).getString(multiField).equals("0") ? ResManager.loadKDString((String)"\u9500\u65b9\u5f55\u5165", (String)"MailSettingHelper_15", (String)"imc-bdm-common", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8d2d\u65b9\u5f55\u5165", (String)"MailSettingHelper_16", (String)"imc-bdm-common", (Object[])new Object[0]);
                            pageBuilder.append("                                <td>").append(value).append("</td>\n");
                            continue block45;
                        }
                        case "redreason": {
                            String redReason;
                            switch (redReason = redConfirmBills.get(i).getString(multiField)) {
                                case "01": {
                                    redReason = ResManager.loadKDString((String)"\u5f00\u7968\u6709\u8bef", (String)"MailSettingHelper_20", (String)"imc-bdm-common", (Object[])new Object[0]);
                                    break;
                                }
                                case "02": {
                                    redReason = ResManager.loadKDString((String)"\u9500\u8d27\u9000\u56de", (String)"MailSettingHelper_19", (String)"imc-bdm-common", (Object[])new Object[0]);
                                    break;
                                }
                                case "03": {
                                    redReason = ResManager.loadKDString((String)"\u670d\u52a1\u4e2d\u6b62", (String)"MailSettingHelper_21", (String)"imc-bdm-common", (Object[])new Object[0]);
                                    break;
                                }
                                case "04": {
                                    redReason = ResManager.loadKDString((String)"\u9500\u552e\u6298\u8ba9", (String)"MailSettingHelper_22", (String)"imc-bdm-common", (Object[])new Object[0]);
                                }
                            }
                            pageBuilder.append("                                <td>").append(redReason).append("</td>\n");
                            continue block45;
                        }
                        case "totaltax": 
                        case "invoiceamount": 
                        case "totalamount": {
                            value = redConfirmBills.get(i).getBigDecimal(multiField).setScale(2, RoundingMode.HALF_UP).toPlainString();
                            pageBuilder.append("                                <td>").append(value).append("</td>\n");
                            continue block45;
                        }
                        case "uploaddate": 
                        case "originalissuetime": {
                            value = DateUtils.format(redConfirmBills.get(i).getDate(multiField), "yyyy-MM-dd HH:mm:ss");
                            pageBuilder.append("                                <td>").append(value).append("</td>\n");
                            continue block45;
                        }
                        default: {
                            pageBuilder.append("                        <td>").append(redConfirmBills.get(i).getString(multiField)).append("</td>\n");
                        }
                    }
                }
                pageBuilder.append("                            </tr>\n");
            }
            pageBuilder.append("                        </tbody>\n                    </table>\n");
        }
        if (!isCustom) {
            pageBuilder.append("                </div>\n            </div>\n            <div class=\"footer\"\n                style=\"display: flex;\n                align-items: center;\n                justify-content: center;\n                min-height: 40px;\n                padding: 20px 14px;\n                background: #2a395d;\">\n                <a href=\"https://www.kdfpy.com\"><img\n                    src=\"https://img.piaozone.com/static/gallery/img/digital/banner.png\"\n                    alt=\"banner\" /></a>\n            </div>        </div>\n    </div>\n</body>\n</html>");
        }
        return pageBuilder.toString();
    }

    public static String replaceMailBody(DynamicObject redConfirmBill, String text, boolean isHTML) {
        String leftSign = isHTML ? "[&amp;" : "[&";
        String rightSign = isHTML ? "&amp;]" : "&]";
        Map<String, String> redConfirmMap = MailSettingHelper.getRedConfirmMap();
        block25: for (Map.Entry<String, String> entry : redConfirmMap.entrySet()) {
            if (redConfirmBill.get(entry.getKey()) == null) continue;
            switch (entry.getKey()) {
                case "uploaddate": 
                case "originalissuetime": {
                    text = text.replace(leftSign + entry.getValue() + rightSign, DateUtils.format(redConfirmBill.getDate(entry.getKey()), "yyyy-MM-dd HH:mm:ss"));
                    continue block25;
                }
                case "redreason": {
                    String redReason;
                    switch (redReason = redConfirmBill.getString(entry.getKey())) {
                        case "01": {
                            text = text.replace(leftSign + entry.getValue() + rightSign, ResManager.loadKDString((String)"\u5f00\u7968\u6709\u8bef", (String)"MailSettingHelper_20", (String)"imc-bdm-common", (Object[])new Object[0]));
                            break;
                        }
                        case "02": {
                            text = text.replace(leftSign + entry.getValue() + rightSign, ResManager.loadKDString((String)"\u9500\u8d27\u9000\u56de", (String)"MailSettingHelper_19", (String)"imc-bdm-common", (Object[])new Object[0]));
                            break;
                        }
                        case "03": {
                            text = text.replace(leftSign + entry.getValue() + rightSign, ResManager.loadKDString((String)"\u670d\u52a1\u4e2d\u6b62", (String)"MailSettingHelper_21", (String)"imc-bdm-common", (Object[])new Object[0]));
                            break;
                        }
                        case "04": {
                            text = text.replace(leftSign + entry.getValue() + rightSign, ResManager.loadKDString((String)"\u9500\u552e\u6298\u8ba9", (String)"MailSettingHelper_22", (String)"imc-bdm-common", (Object[])new Object[0]));
                        }
                    }
                    continue block25;
                }
                case "totalamount": 
                case "totaltax": 
                case "invoiceamount": {
                    text = text.replace(leftSign + entry.getValue() + rightSign, redConfirmBill.getBigDecimal(entry.getKey()).setScale(2, RoundingMode.HALF_UP).toPlainString());
                    continue block25;
                }
            }
            text = text.replace(leftSign + entry.getValue() + rightSign, redConfirmBill.getString(entry.getKey()));
        }
        boolean enterId = redConfirmBill.getString("enteridentity").equals("0");
        String lrf = ResManager.loadKDString((String)"\u5f55\u5165\u65b9", (String)"MailSettingHelper_17", (String)"imc-bdm-common", (Object[])new Object[0]);
        String xflr = ResManager.loadKDString((String)"\u9500\u65b9\u5f55\u5165", (String)"MailSettingHelper_15", (String)"imc-bdm-common", (Object[])new Object[0]);
        String gflr = ResManager.loadKDString((String)"\u8d2d\u65b9\u5f55\u5165", (String)"MailSettingHelper_16", (String)"imc-bdm-common", (Object[])new Object[0]);
        String lrfmc = ResManager.loadKDString((String)"\u5f55\u5165\u65b9\u540d\u79f0", (String)"MailSettingHelper_18", (String)"imc-bdm-common", (Object[])new Object[0]);
        text = text.replace(leftSign + lrf + rightSign, enterId ? xflr : gflr);
        text = text.replace(leftSign + lrfmc + rightSign, enterId ? redConfirmBill.getString("salername") : redConfirmBill.getString("buyername"));
        return text;
    }

    public static DynamicObject getSettingByCtrlStrategy(String formId, QFilter qFilter) {
        for (int i = 0; i < ctrlStrategy.length; ++i) {
            QFilter filter = new QFilter("ctrlstrategy", "=", (Object)ctrlStrategy[i]);
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)formId, (String)PropertieUtil.getAllPropertiesSplitByComma(formId, true), (QFilter[])filter.and(qFilter).toArray());
            if (dynamicObjects.length != 0) {
                return dynamicObjects[0];
            }
            if (i != ctrlStrategy.length - 1) continue;
            return null;
        }
        return null;
    }

    public static DynamicObject getSettingByCtrlStrategy(String formId, QFilter qFilter, DynamicObject invoiceOrRedConfirm) {
        for (int i = 0; i < ctrlStrategy.length; ++i) {
            DynamicObject dynamicObject = MailSettingHelper.getSettingByCtrlStrategy(ctrlStrategy[i], formId, qFilter, invoiceOrRedConfirm);
            if (dynamicObject == null) continue;
            return dynamicObject;
        }
        return null;
    }

    private static DynamicObject getSettingByCtrlStrategy(String ctrl, String formId, QFilter qFilter, DynamicObject invoiceOrRedConfirm) {
        QFilter filter = new QFilter("ctrlstrategy", "=", (Object)ctrl);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)formId, (String)PropertieUtil.getAllPropertiesSplitByComma(formId, true), (QFilter[])filter.and(qFilter).toArray());
        if (dynamicObjects.length != 0) {
            DynamicObject noFilterDO = null;
            for (DynamicObject object : dynamicObjects) {
                if (StringUtils.isNotEmpty((CharSequence)object.getString("filter_tag"))) {
                    if (!BdmConditionMatchHelper.verify(object.getString("filter_tag"), invoiceOrRedConfirm)) continue;
                    return object;
                }
                noFilterDO = object;
            }
            return noFilterDO;
        }
        return null;
    }

    public static Map<String, String> getRedConfirmItemMap() {
        HashMap<String, String> redConfirmItemMap = new HashMap<String, String>(1);
        redConfirmItemMap.put("goodsname", ResManager.loadKDString((String)"\u5546\u54c1\u540d\u79f0", (String)"MailSettingHelper_24", (String)"imc-bdm-common", (Object[])new Object[0]));
        redConfirmItemMap.put("specification", ResManager.loadKDString((String)"\u89c4\u683c\u578b\u53f7", (String)"MailSettingHelper_25", (String)"imc-bdm-common", (Object[])new Object[0]));
        redConfirmItemMap.put("unit", ResManager.loadKDString((String)"\u5355\u4f4d", (String)"MailSettingHelper_26", (String)"imc-bdm-common", (Object[])new Object[0]));
        redConfirmItemMap.put("num", ResManager.loadKDString((String)"\u6570\u91cf", (String)"MailSettingHelper_27", (String)"imc-bdm-common", (Object[])new Object[0]));
        redConfirmItemMap.put("taxrate", ResManager.loadKDString((String)"\u7a0e\u7387", (String)"MailSettingHelper_28", (String)"imc-bdm-common", (Object[])new Object[0]));
        redConfirmItemMap.put("unitprice", ResManager.loadKDString((String)"\u5355\u4ef7", (String)"MailSettingHelper_29", (String)"imc-bdm-common", (Object[])new Object[0]));
        redConfirmItemMap.put("taxunitprice", ResManager.loadKDString((String)"\u542b\u7a0e\u5355\u4ef7", (String)"MailSettingHelper_30", (String)"imc-bdm-common", (Object[])new Object[0]));
        redConfirmItemMap.put("amount", ResManager.loadKDString((String)"\u4e0d\u542b\u7a0e\u91d1\u989d", (String)"MailSettingHelper_31", (String)"imc-bdm-common", (Object[])new Object[0]));
        redConfirmItemMap.put("taxamount", ResManager.loadKDString((String)"\u542b\u7a0e\u91d1\u989d", (String)"MailSettingHelper_32", (String)"imc-bdm-common", (Object[])new Object[0]));
        redConfirmItemMap.put("tax", ResManager.loadKDString((String)"\u7a0e\u989d", (String)"MailSettingHelper_33", (String)"imc-bdm-common", (Object[])new Object[0]));
        redConfirmItemMap.put("goodscode", ResManager.loadKDString((String)"\u7a0e\u6536\u5206\u7c7b\u7f16\u7801", (String)"MailSettingHelper_34", (String)"imc-bdm-common", (Object[])new Object[0]));
        redConfirmItemMap.put("zzstsgl", ResManager.loadKDString((String)"\u4f18\u60e0\u653f\u7b56\u5185\u5bb9", (String)"MailSettingHelper_35", (String)"imc-bdm-common", (Object[])new Object[0]));
        redConfirmItemMap.put("goodsid", ResManager.loadKDString((String)"\u5546\u54c1\u7f16\u7801", (String)"MailSettingHelper_36", (String)"imc-bdm-common", (Object[])new Object[0]));
        redConfirmItemMap.put("originseq", ResManager.loadKDString((String)"\u539f\u84dd\u7968\u5e8f\u53f7", (String)"MailSettingHelper_37", (String)"imc-bdm-common", (Object[])new Object[0]));
        try {
            String mailExtraFiled = ImcConfigUtil.getValue("sim_config", "sim_mail_reditemfield_config");
            if (StringUtils.isNotBlank((CharSequence)mailExtraFiled)) {
                ArrayList<String> fileds = new ArrayList<String>(Arrays.asList(mailExtraFiled.split(",")));
                EntityType itemsEntityType = (EntityType)EntityMetadataCache.getDataEntityType((String)"sim_red_confirm_bill").getAllEntities().get("items");
                List<IDataEntityProperty> properties = itemsEntityType.getProperties().stream().filter(property -> fileds.contains(property.getName())).collect(Collectors.toList());
                MailSettingHelper.putExtraPropertyToMap(properties, redConfirmItemMap);
            }
        }
        catch (Exception e1) {
            LOGGER.error("redconfirmmail item extra filed add error" + e1);
        }
        return redConfirmItemMap;
    }

    public static Map<String, String> getRedConfirmMap() {
        HashMap<String, String> redConfirmMap = new HashMap<String, String>(1);
        redConfirmMap.put("enteridentity", ResManager.loadKDString((String)"\u5f55\u5165\u65b9\u8eab\u4efd", (String)"MailSettingHelper_0", (String)"imc-bdm-common", (Object[])new Object[0]));
        redConfirmMap.put("uploaddate", ResManager.loadKDString((String)"\u7533\u8bf7\u65e5\u671f", (String)"MailSettingHelper_1", (String)"imc-bdm-common", (Object[])new Object[0]));
        redConfirmMap.put("buyername", ResManager.loadKDString((String)"\u8d2d\u4e70\u65b9\u540d\u79f0", (String)"MailSettingHelper_2", (String)"imc-bdm-common", (Object[])new Object[0]));
        redConfirmMap.put("number", ResManager.loadKDString((String)"\u7ea2\u5b57\u786e\u8ba4\u5355\u7f16\u53f7", (String)"MailSettingHelper_3", (String)"imc-bdm-common", (Object[])new Object[0]));
        redConfirmMap.put("originalinvoicecode", ResManager.loadKDString((String)"\u539f\u84dd\u7968\u4ee3\u7801", (String)"MailSettingHelper_4", (String)"imc-bdm-common", (Object[])new Object[0]));
        redConfirmMap.put("originalinvoiceno", ResManager.loadKDString((String)"\u539f\u84dd\u7968\u53f7\u7801", (String)"MailSettingHelper_5", (String)"imc-bdm-common", (Object[])new Object[0]));
        redConfirmMap.put("totalamount", ResManager.loadKDString((String)"\u542b\u7a0e\u91d1\u989d", (String)"MailSettingHelper_6", (String)"imc-bdm-common", (Object[])new Object[0]));
        redConfirmMap.put("invoiceamount", ResManager.loadKDString((String)"\u4e0d\u542b\u7a0e\u91d1\u989d", (String)"MailSettingHelper_7", (String)"imc-bdm-common", (Object[])new Object[0]));
        redConfirmMap.put("totaltax", ResManager.loadKDString((String)"\u7a0e\u989d", (String)"MailSettingHelper_8", (String)"imc-bdm-common", (Object[])new Object[0]));
        redConfirmMap.put("redreason", ResManager.loadKDString((String)"\u7ea2\u51b2\u539f\u56e0", (String)"MailSettingHelper_9", (String)"imc-bdm-common", (Object[])new Object[0]));
        redConfirmMap.put("originalissuetime", ResManager.loadKDString((String)"\u539f\u84dd\u7968\u5f00\u7968\u65e5\u671f", (String)"MailSettingHelper_10", (String)"imc-bdm-common", (Object[])new Object[0]));
        redConfirmMap.put("salername", ResManager.loadKDString((String)"\u9500\u552e\u65b9\u540d\u79f0", (String)"MailSettingHelper_11", (String)"imc-bdm-common", (Object[])new Object[0]));
        try {
            String mailExtraFiled = ImcConfigUtil.getValue("sim_config", "sim_mail_redconfirmfield_config");
            if (StringUtils.isNotBlank((CharSequence)mailExtraFiled)) {
                ArrayList<String> fileds = new ArrayList<String>(Arrays.asList(mailExtraFiled.split(",")));
                MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"sim_red_confirm_bill");
                List<IDataEntityProperty> properties = mainEntityType.getProperties().stream().filter(property -> fileds.contains(property.getName())).collect(Collectors.toList());
                MailSettingHelper.putExtraPropertyToMap(properties, redConfirmMap);
            }
        }
        catch (Exception e1) {
            LOGGER.error("redconfirmmail extra filed add error" + e1);
        }
        return redConfirmMap;
    }

    public static Map<String, String> getSelectMap() {
        HashMap<String, String> selectMap = new HashMap<String, String>(1);
        selectMap.put("invoicecode", "\u53d1\u7968\u4ee3\u7801");
        selectMap.put("invoiceno", "\u53d1\u7968\u53f7\u7801");
        selectMap.put("issuetime", "\u5f00\u7968\u65e5\u671f");
        selectMap.put("buyername", "\u8d2d\u65b9\u540d\u79f0");
        selectMap.put("buyertaxno", "\u8d2d\u65b9\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7");
        selectMap.put("buyeraddr", "\u8d2d\u65b9\u5730\u5740\u7535\u8bdd");
        selectMap.put("buyerbank", "\u8d2d\u65b9\u5f00\u6237\u884c\u53ca\u8d26\u53f7");
        selectMap.put("buyerphone", "\u8d2d\u65b9\u624b\u673a");
        selectMap.put("buyeremail", "\u8d2d\u65b9\u90ae\u7bb1");
        selectMap.put("salername", "\u9500\u65b9\u540d\u79f0");
        selectMap.put("salertaxno", "\u9500\u65b9\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7");
        selectMap.put("saleraddr", "\u9500\u65b9\u5730\u5740\u7535\u8bdd");
        selectMap.put("salerbank", "\u9500\u65b9\u5f00\u6237\u884c\u53ca\u8d26\u53f7");
        selectMap.put("issuetype", "\u5f00\u7968\u7c7b\u578b");
        selectMap.put("inventorymark", "\u6e05\u5355\u6807\u8bc6");
        selectMap.put("invoiceamount", "\u5408\u8ba1\u91d1\u989d");
        selectMap.put("totaltax", "\u5408\u8ba1\u7a0e\u989d");
        selectMap.put("billno", "\u5355\u636e\u7f16\u53f7");
        selectMap.put("totalamount", "\u4ef7\u7a0e\u5408\u8ba1");
        selectMap.put("fileurl", "ofd\u6587\u4ef6\u4e0b\u8f7d\u5730\u5740");
        selectMap.put("pdffileurl", "pdf\u6587\u4ef6\u4e0b\u8f7d\u5730\u5740");
        selectMap.put("snapshoturl", "JPG\u6587\u4ef6\u4e0b\u8f7d\u5730\u5740");
        selectMap.put("xmlfileurl", "xml\u6587\u4ef6\u4e0b\u8f7d\u5730\u5740");
        selectMap.put("invoicetype", "\u53d1\u7968\u7c7b\u578b");
        try {
            String mailExtraFiled = ImcConfigUtil.getValue("sim_config", "sim_mail_field_config");
            if (StringUtils.isNotBlank((CharSequence)mailExtraFiled)) {
                ArrayList<String> fileds = new ArrayList<String>(Arrays.asList(mailExtraFiled.split(",")));
                MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"sim_vatinvoice");
                List<IDataEntityProperty> properties = entityType.getProperties().stream().filter(property -> fileds.contains(property.getName())).collect(Collectors.toList());
                MailSettingHelper.putExtraPropertyToMap(properties, selectMap);
            }
        }
        catch (Exception e1) {
            LOGGER.error("mail extra filed add error" + e1);
        }
        return selectMap;
    }

    private static void putExtraPropertyToMap(List<IDataEntityProperty> properties, Map<String, String> selectMap) {
        for (IDataEntityProperty property : properties) {
            if (null == property.getDisplayName() || property instanceof EntryProp) continue;
            selectMap.put(property.getName(), property.getDisplayName().getLocaleValue());
        }
    }

    static {
        showMap.put("\u53d1\u7968\u4ee3\u7801", "044031611111");
        showMap.put("\u53d1\u7968\u53f7\u7801", "10003634");
        showMap.put("\u8d2d\u65b9\u540d\u79f0", "\u82cd\u7a79\u53d1\u7968\u4e91");
        showMap.put("\u8d2d\u65b9\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7", "888888888888888");
        showMap.put("\u8d2d\u65b9\u5730\u5740\u7535\u8bdd", "\u5357\u5c71\u91d1\u8776\u8f6f\u4ef6\u56ed");
        showMap.put("\u8d2d\u65b9\u5f00\u6237\u884c\u53ca\u8d26\u53f7", "\u6df1\u5733\u62db\u5546\u94f6\u884c\u4e0a\u6b65\u652f\u884c6666777788889999");
        showMap.put("\u8d2d\u65b9\u624b\u673a", "176999888789");
        showMap.put("\u8d2d\u65b9\u90ae\u7bb1", "cqfpy@Kingdee.com");
        showMap.put("\u9500\u65b9\u540d\u79f0", "\u822a\u4fe1\u57f9\u8bad\u4f01\u4e1a");
        showMap.put("\u9500\u65b9\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7", "12321321312312");
        showMap.put("\u9500\u65b9\u5730\u5740\u7535\u8bdd", "\u6df1\u5733\u798f\u7530\u7f8e\u666f123456789012");
        showMap.put("\u9500\u65b9\u5f00\u6237\u884c\u53ca\u8d26\u53f7", "\u6df1\u5733\u62db\u5546\u94f6\u884c\u6885\u6797\u652f\u884c1111222233334444");
        showMap.put("\u5f00\u7968\u7c7b\u578b", "\u84dd\u7968");
        showMap.put("\u6e05\u5355\u6807\u8bc6", "\u6709\u6e05\u5355");
        showMap.put("\u5408\u8ba1\u91d1\u989d", "1600.00");
        showMap.put("\u5408\u8ba1\u7a0e\u989d", "144.00");
        showMap.put("\u5355\u636e\u7f16\u53f7", "123456789");
        showMap.put("\u4ef7\u7a0e\u5408\u8ba1", "1744.00");
        showMap.put("ofd\u6587\u4ef6\u4e0b\u8f7d\u5730\u5740", "<a style=\"color: #3078EC;/*untrans*/\" href=\"http://www.piaozone.com\">https://api-dev.piaozone.com/test/m5/ismc/down/pdf/440301999999020/d1b0631710f44cc2ba948ff14a744176</a>");
        showMap.put("pdf\u6587\u4ef6\u4e0b\u8f7d\u5730\u5740", "<a style=\"color: #3078EC;/*untrans*/\" href=\"http://www.piaozone.com\">https://api-dev.piaozone.com/test/m5/ismc/down/pdf/440301999999020/d1b0631710f44cc2ba948ff14a744176</a>");
        showMap.put("JPG\u6587\u4ef6\u4e0b\u8f7d\u5730\u5740", "<a style=\"color: #3078EC;/*untrans*/\" href=\"http://www.piaozone.com\">https://api-dev.piaozone.com/test/m5/ismc/down/pdf/440301999999020/d1b0631710f44cc2ba948ff14a744176</a>");
        showMap.put("\u5f00\u7968\u65e5\u671f", "2021-01-01");
        ctrlStrategy = new String[]{"7", "2", "1", "6", "5"};
    }
}

