/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.IssueType;
import kd.imc.bdm.common.dto.BillRelationDTO;
import kd.imc.bdm.common.dto.InvoiceMatchVo;
import kd.imc.bdm.common.dto.RelationProcessDTO;
import kd.imc.bdm.common.dto.Relations;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.ImcBaseDataHelper;
import kd.imc.bdm.common.helper.RedConfirmHelper;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.sdk.annotation.SdkDeprecated;

public class RelationHelper {
    private static final String SIM_BILL_RELATION_FIELDS = "id,sbillid,sdetailid,tbillid,tdetailid,amount,tax,num,sbillno,ttable";
    private static final Log LOGGER = LogFactory.getLog(RelationHelper.class);

    public static DynamicObject[] getRelationByInvoice(DynamicObject invoice) {
        DynamicObject[] array = new DynamicObject[]{};
        if (!"4".equals(invoice.getString("buyertype"))) {
            return array;
        }
        if (RelationHelper.isRedConfirmInvoice(invoice)) {
            DynamicObject redConfirm = RelationHelper.getRedConfirmByInvoice(invoice);
            array = RelationHelper.getRelationsByTBillId(redConfirm.getPkValue());
        } else if (RelationHelper.isNotRedInfoInvoice(invoice)) {
            array = BusinessDataServiceHelper.load((String)"sim_bill_inv_relation", (String)SIM_BILL_RELATION_FIELDS, (QFilter[])new QFilter("tbillid", "=", invoice.getPkValue()).and("isdelete", "!=", (Object)"Y").toArray());
        } else {
            DynamicObject redInfoByInvoice = RelationHelper.getRedInfoByInvoice(invoice);
            array = RelationHelper.getRelationsByTBillId(redInfoByInvoice.getPkValue());
        }
        return array;
    }

    public static Set<Object> getTbillIdsByRelations(DynamicObject[] relations) {
        return Arrays.stream(relations).map(o -> o.getLong("tbillid")).collect(Collectors.toSet());
    }

    public static List<DynamicObject> getInvoicesByRelations(DynamicObject[] relations, Object orgId) {
        DynamicObject[] array;
        QFilter filter;
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        if (relations.length == 0) {
            return list;
        }
        String ttable = relations[0].getString("ttable");
        Set<Object> tBillIds = RelationHelper.getTbillIdsByRelations(relations);
        DynamicObject[] invoices = new DynamicObject[]{};
        if ("sim_vatinvoice".equals(ttable)) {
            invoices = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma("sim_vatinvoice"), (QFilter[])new QFilter("id", "in", (Object)tBillIds.toArray()).toArray());
        }
        if ("sim_red_info".equals(ttable)) {
            DynamicObject[] redInfos = BusinessDataServiceHelper.load((String)"sim_red_info", (String)PropertieUtil.getAllPropertiesSplitByComma("sim_red_info"), (QFilter[])new QFilter("id", "in", (Object)tBillIds.toArray()).toArray());
            filter = null;
            for (DynamicObject redInfo : redInfos) {
                filter = filter == null ? new QFilter("infocode", "=", (Object)redInfo.getString("infocode")).and("orgid", "=", orgId) : filter.or(new QFilter("infocode", "=", (Object)redInfo.getString("infocode")).and("orgid", "=", orgId));
            }
            array = null == filter ? null : filter.toArray();
            invoices = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma("sim_vatinvoice"), (QFilter[])array);
        }
        if ("sim_red_confirm_bill".equals(ttable)) {
            DynamicObject[] redConfirms = BusinessDataServiceHelper.load((String)"sim_red_confirm_bill", (String)PropertieUtil.getAllPropertiesSplitByComma("sim_red_confirm_bill"), (QFilter[])new QFilter("id", "in", (Object)tBillIds.toArray()).toArray());
            filter = null;
            for (DynamicObject redConfirm : redConfirms) {
                filter = filter == null ? new QFilter("infocode", "=", (Object)redConfirm.getString("number")).and("orgid", "=", orgId) : filter.or(new QFilter("infocode", "=", (Object)redConfirm.getString("number")).and("orgid", "=", orgId));
            }
            array = null == filter ? null : filter.toArray();
            invoices = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma("sim_vatinvoice"), (QFilter[])array);
        }
        Collections.addAll(list, invoices);
        return list;
    }

    public static RelationProcessDTO getProcess(DynamicObject[] relations) {
        HashSet<Object> tBillIdSet = new HashSet<Object>();
        HashSet<Object> sBillIdSet = new HashSet<Object>();
        RelationProcessDTO result = new RelationProcessDTO(tBillIdSet, sBillIdSet);
        for (DynamicObject relation : relations) {
            tBillIdSet.add(relation.get("tbillid"));
            sBillIdSet.add(relation.get("sbillid"));
        }
        return result;
    }

    public static boolean isRedConfirmInvoice(DynamicObject invoice) {
        String issueType = invoice.getString("issuetype");
        String invoiceType = invoice.getString("invoicetype");
        return IssueType.RED_INVOICE.getTypeCode().equals(issueType) && (InvoiceUtils.isAllEInvoice(invoiceType) || AllEleAuthHelper.isElePaper(invoice.getString("iselepaper")));
    }

    public static DynamicObject[] getOriBillByInvoice(DynamicObject invoice) {
        Long tBillPk;
        List<BillRelationDTO> relations;
        Set billPkSet;
        boolean isFromMatchBill = RelationHelper.isInvoiceFromRedMatchBill(invoice);
        if (isFromMatchBill && (billPkSet = (relations = RelationHelper.getMatchInvRelation(tBillPk = RelationHelper.getRedTBillId(invoice))).stream().map(o -> o.gettBillId()).collect(Collectors.toSet())).size() > 0) {
            return BusinessDataServiceHelper.load((String)"sim_original_bill", (String)PropertieUtil.getAllPropertiesSplitByComma("sim_original_bill", true), (QFilter[])new QFilter("id", "in", billPkSet).toArray());
        }
        DynamicObject[] relations2 = RelationHelper.getRelationByInvoice(invoice);
        Long[] billIdArray = RelationHelper.getSBillIdSet(relations2);
        if (billIdArray.length > 0) {
            return BusinessDataServiceHelper.load((String)"sim_original_bill", (String)PropertieUtil.getAllPropertiesSplitByComma("sim_original_bill", true), (QFilter[])new QFilter("id", "in", (Object)billIdArray).toArray());
        }
        return new DynamicObject[0];
    }

    public static DynamicObject[] getBillsByRedInfoPk(Object redInfoPk) {
        DynamicObject[] relations = RelationHelper.getRelationsByTBillIdWithoutDelete(redInfoPk);
        Long[] sBillIds = RelationHelper.getSBillIdSet(relations);
        return BusinessDataServiceHelper.load((String)"sim_original_bill", (String)PropertieUtil.getAllPropertiesSplitByComma("sim_original_bill"), (QFilter[])new QFilter("id", "in", (Object)sBillIds).toArray());
    }

    public static DynamicObject[] getBillsByRedConfirmPk(Object redConfirmPk) {
        DynamicObject[] relations = RelationHelper.getRelationsByTBillId(redConfirmPk);
        Long[] sBillIds = RelationHelper.getSBillIdSet(relations);
        return BusinessDataServiceHelper.load((String)"sim_original_bill", (String)PropertieUtil.getAllPropertiesSplitByComma("sim_original_bill"), (QFilter[])new QFilter("id", "in", (Object)sBillIds).toArray());
    }

    public static Long[] getSBillIdSet(DynamicObject[] relations) {
        HashSet<Long> set = new HashSet<Long>();
        for (DynamicObject relation : relations) {
            set.add(relation.getLong("sbillid"));
        }
        return set.toArray(new Long[0]);
    }

    public static DynamicObject getRedInfoByInvoice(DynamicObject invoice) {
        String infoCode = invoice.getString("infocode");
        long orgId = DynamicObjectUtil.getDynamicObjectLongValue(invoice.get("orgid"));
        QFilter filter = new QFilter("infocode", "=", (Object)infoCode).and("org", "=", (Object)orgId);
        return BusinessDataServiceHelper.loadSingle((String)"sim_red_info", (String)PropertieUtil.getAllPropertiesSplitByComma("sim_red_info", true), (QFilter[])filter.toArray());
    }

    public static DynamicObject getRedConfirmByInvoice(DynamicObject invoice) {
        QFilter filter = new QFilter("number", "=", (Object)invoice.getString("infocode"));
        Object org = invoice.get("orgid");
        Long orgPk = org instanceof DynamicObject ? Long.valueOf(((DynamicObject)org).getLong("id")) : (Long)org;
        filter = filter.and(ImcBaseDataHelper.getRedConfirmFilter(orgPk));
        return BusinessDataServiceHelper.loadSingle((String)"sim_red_confirm_bill", (String)PropertieUtil.getAllPropertiesSplitByComma("sim_red_confirm_bill", true), (QFilter[])filter.toArray());
    }

    private static boolean isNotRedInfoInvoice(DynamicObject invoice) {
        String issueType = invoice.getString("issuetype");
        return !InvoiceUtils.isSpecialInvoice(invoice.getString("invoicetype")) || !IssueType.RED_INVOICE.getTypeCode().equals(issueType);
    }

    public static DynamicObject[] getRelationsByTBillId(Object invoiceId) {
        return BusinessDataServiceHelper.load((String)"sim_bill_inv_relation", (String)PropertieUtil.getAllPropertiesSplitByComma("sim_bill_inv_relation"), (QFilter[])new QFilter("tbillid", "=", invoiceId).toArray());
    }

    public static DynamicObject[] getRelationsByTBillIdWithoutDelete(Object invoiceId) {
        return BusinessDataServiceHelper.load((String)"sim_bill_inv_relation", (String)PropertieUtil.getAllPropertiesSplitByComma("sim_bill_inv_relation"), (QFilter[])new QFilter("tbillid", "=", invoiceId).and(RelationHelper.relationBaseFilter()).toArray());
    }

    public static DynamicObject[] getRelationsBySBillIdWithoutDelete(Long[] billPks) {
        return BusinessDataServiceHelper.load((String)"sim_bill_inv_relation", (String)PropertieUtil.getAllPropertiesSplitByComma("sim_bill_inv_relation"), (QFilter[])new QFilter("sbillid", "in", (Object)billPks).and(RelationHelper.relationBaseFilter()).toArray());
    }

    public static QFilter relationBaseFilter() {
        return new QFilter("isdelete", "!=", (Object)"Y");
    }

    private static DynamicObject[] getRelationsBySBillId(Object billId) {
        return BusinessDataServiceHelper.load((String)"sim_bill_inv_relation", (String)PropertieUtil.getAllPropertiesSplitByComma("sim_bill_inv_relation"), (QFilter[])new QFilter("sbillid", "=", billId).and(RelationHelper.relationBaseFilter()).toArray());
    }

    private static Object[] getTbillNos(Object billId) {
        DynamicObject[] relations = RelationHelper.getRelationsBySBillId(billId);
        HashSet<Object> list = new HashSet<Object>();
        for (DynamicObject relation : relations) {
            list.add(relation.get("tbillno"));
        }
        return list.toArray(new Object[0]);
    }

    private static Object[] getTbillPk(Object billId, boolean isIncludeDelete) {
        DynamicObject[] relations = RelationHelper.getRelationsBySBillId(billId);
        ArrayList<Object> list = new ArrayList<Object>();
        for (DynamicObject relation : relations) {
            String isDelete;
            if (!isIncludeDelete && "Y".equalsIgnoreCase(isDelete = relation.getString("isdelete"))) continue;
            list.add(relation.get("tbillid"));
        }
        return list.toArray(new Object[0]);
    }

    public static boolean isRedInvoice(DynamicObject invoice) {
        return IssueType.RED_INVOICE.getTypeCode().equals(invoice.getString("issuetype"));
    }

    public static DynamicObject[] getOriBlueInvoiceRelation(DynamicObject redInvoice) {
        QFilter blueInvoiceFilter = InvoiceUtils.getInvoiceFilter(redInvoice.getString("originalinvoicecode"), redInvoice.getString("originalinvoiceno"));
        DynamicObject[] blueInvoice = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma("sim_vatinvoice"), (QFilter[])blueInvoiceFilter.toArray());
        if (blueInvoice.length > 0) {
            return RelationHelper.getRelationByInvoice(blueInvoice[0]);
        }
        return new DynamicObject[0];
    }

    public static Relations countRelation(DynamicObject[] relations, boolean isReverse) {
        HashMap<Object, BillRelationDTO> billPkRelation = new HashMap<Object, BillRelationDTO>();
        ArrayList<Long> sBillPks = new ArrayList<Long>();
        for (DynamicObject relation : relations) {
            BillRelationDTO billRelation;
            Object sBillId = relation.get("sbillid");
            String oriBillNo = relation.getString("sbillno");
            if (billPkRelation.containsKey(sBillId)) {
                billRelation = (BillRelationDTO)billPkRelation.get(sBillId);
            } else {
                billRelation = new BillRelationDTO();
                billRelation.setNum(BigDecimal.ZERO);
                billRelation.setAmount(BigDecimal.ZERO);
                billRelation.setTax(BigDecimal.ZERO);
                billRelation.settBillId((Long)sBillId);
                billRelation.settBillNo(oriBillNo);
                billPkRelation.put(sBillId, billRelation);
                sBillPks.add((Long)sBillId);
            }
            if (isReverse) {
                billRelation.setTax(billRelation.getTax().subtract(relation.getBigDecimal("tax")));
                billRelation.setAmount(billRelation.getAmount().subtract(relation.getBigDecimal("amount")));
                continue;
            }
            billRelation.setTax(billRelation.getTax().add(relation.getBigDecimal("tax")));
            billRelation.setAmount(billRelation.getAmount().add(relation.getBigDecimal("amount")));
        }
        Relations relation = new Relations();
        relation.setRelationDTOS(new ArrayList(billPkRelation.values()));
        relation.settBillPks(sBillPks);
        return relation;
    }

    public static DynamicObject[] queryRelateWaitInvoice(DynamicObject bill) {
        String issueType = "1".equals(bill.getString("billproperties")) ? IssueType.BLUE_INVOICE.getTypeCode() : IssueType.RED_INVOICE.getTypeCode();
        String invoiceType = bill.getString("invoicetype");
        Object[] tBillPk = RelationHelper.getTbillPk(bill.getPkValue(), true);
        if (InvoiceUtils.isRedInfoInvoice(issueType, invoiceType)) {
            Object[] tBillNos = RelationHelper.getTbillNos(bill.getPkValue());
            QFilter invoiceFilter = new QFilter("billno", "in", (Object)tBillNos).and("issuestatus", "!=", (Object)IssueStatusEnum.ok.getCode());
            return BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma("sim_vatinvoice"), (QFilter[])invoiceFilter.toArray());
        }
        return BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma("sim_vatinvoice", true), (QFilter[])new QFilter("id", "in", (Object)tBillPk).and("issuestatus", "!=", (Object)IssueStatusEnum.ok.getCode()).toArray());
    }

    public static Set<Long> queryTbillIds(DynamicObject[] bills) {
        Set<Long> billPk = Arrays.stream(bills).map(o -> o.getLong("id")).collect(Collectors.toSet());
        return RelationHelper.queryTbillIdsByBillIds(billPk);
    }

    public static Set<Long> queryTbillIdsByBillIds(Set<Long> billPk) {
        DynamicObject[] relations;
        HashSet<Long> result = new HashSet<Long>();
        for (DynamicObject relation : relations = BusinessDataServiceHelper.load((String)"sim_bill_inv_relation", (String)PropertieUtil.getAllPropertiesSplitByComma("sim_bill_inv_relation"), (QFilter[])new QFilter("sbillid", "in", (Object)billPk.toArray(new Object[0])).toArray())) {
            result.add(relation.getLong("tbillid"));
        }
        return result;
    }

    public static DynamicObject[] queryReopenBills(DynamicObject bill) {
        QFilter filter = new QFilter("sbillid", "=", bill.getPkValue());
        DynamicObject[] billRelations = BusinessDataServiceHelper.load((String)"sim_bill_relation", (String)"tbillid", (QFilter[])filter.toArray());
        if (billRelations.length > 0) {
            return BusinessDataServiceHelper.load((String)"sim_original_bill", (String)String.join((CharSequence)",", "invoicetype", "billproperties"), (QFilter[])new QFilter("id", "=", billRelations[0].get("tbillid")).toArray());
        }
        return new DynamicObject[0];
    }

    public static DynamicObject[] loadInvoiceByRelation(DynamicObject[] relationObjs) {
        List invIdList = Stream.of(relationObjs).map(o -> o.getLong("tbillid")).distinct().collect(Collectors.toList());
        return BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma("sim_vatinvoice", true), (QFilter[])new QFilter("id", "in", invIdList).toArray());
    }

    @SdkDeprecated
    public static DynamicObject[] loadInvoiceByBills(DynamicObject[] originalBills) {
        List billPks = Arrays.stream(originalBills).map(o -> o.getLong("id")).collect(Collectors.toList());
        DynamicObject[] relations = BusinessDataServiceHelper.load((String)"sim_bill_inv_relation", (String)PropertieUtil.getAllPropertiesSplitByComma("sim_bill_inv_relation"), (QFilter[])new QFilter("sbillid", "in", (Object)billPks.toArray()).toArray());
        Set invoiceBillNos = Arrays.stream(relations).map(o -> o.getString("tbillno")).collect(Collectors.toSet());
        return BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)"invoicestatus,remainredamount", (QFilter[])new QFilter("billno", "in", (Object)invoiceBillNos.toArray()).toArray());
    }

    public static Long getRedTBillId(DynamicObject invoice) {
        String invoiceType = invoice.getString("invoicetype");
        String issueType = invoice.getString("issuetype");
        String infoCode = invoice.getString("infocode");
        Object org = invoice.get("orgid");
        Long orgPk = org instanceof Long ? (Long)org : (Long)invoice.getDynamicObject("orgid").getPkValue();
        if (InvoiceUtils.isAllEInvoice(invoiceType)) {
            DynamicObject redConfirm = RedConfirmHelper.loadConfirmBill(infoCode, orgPk);
            if (null == redConfirm) {
                return null;
            }
            return redConfirm.getLong("id");
        }
        if (InvoiceUtils.isRedInfoInvoice(issueType, invoiceType)) {
            QFilter filter = new QFilter("infocode", "=", (Object)infoCode).and("org", "=", (Object)orgPk);
            DynamicObject[] array = BusinessDataServiceHelper.load((String)"sim_red_info", (String)"id", (QFilter[])filter.toArray());
            if (array.length > 0) {
                return array[0].getLong("id");
            }
            return null;
        }
        return invoice.getLong("id");
    }

    public static List<BillRelationDTO> getMatchInvRelation(Long tBillPk) {
        QFilter filter = new QFilter("tbillid", "=", (Object)tBillPk);
        DynamicObject[] relations = BusinessDataServiceHelper.load((String)"sim_match_inv_relation", (String)PropertieUtil.getAllPropertiesSplitByComma("sim_match_inv_relation", true), (QFilter[])filter.toArray());
        if (relations.length == 0) {
            return new ArrayList<BillRelationDTO>();
        }
        Long sBillPk = relations[0].getLong("sbillid");
        filter = new QFilter("tbillid", "=", (Object)sBillPk);
        DynamicObject[] matchBillRelations = BusinessDataServiceHelper.load((String)"sim_matchbill_relation", (String)PropertieUtil.getAllPropertiesSplitByComma("sim_matchbill_relation", true), (QFilter[])filter.toArray());
        if (matchBillRelations.length == 0) {
            return new ArrayList<BillRelationDTO>();
        }
        Set matchBillDetailIdSet = Arrays.stream(relations).map(o -> o.getLong("sdetailid")).collect(Collectors.toSet());
        ArrayList<BillRelationDTO> result = new ArrayList<BillRelationDTO>();
        HashSet<Long> relateBillIdSet = new HashSet<Long>();
        for (DynamicObject matchBillRelation : matchBillRelations) {
            Long originalBillId;
            if (!matchBillDetailIdSet.contains(matchBillRelation.getLong("tdetailid")) || relateBillIdSet.contains(originalBillId = Long.valueOf(matchBillRelation.getLong("sbillid")))) continue;
            relateBillIdSet.add(originalBillId);
            BillRelationDTO newRelation = new BillRelationDTO();
            newRelation.settBillId(originalBillId);
            result.add(newRelation);
        }
        return result;
    }

    public static InvoiceMatchVo getInvoiceMatchVo(DynamicObject invoice) {
        InvoiceMatchVo matchVo = new InvoiceMatchVo();
        boolean isFromMatch = RelationHelper.isInvoiceFromRedMatchBill(invoice);
        matchVo.setFromRedMatchBill(isFromMatch);
        if (!isFromMatch) {
            return matchVo;
        }
        Long redTBillId = RelationHelper.getRedTBillId(invoice);
        List<BillRelationDTO> matchInvRelation = RelationHelper.getMatchInvRelation(redTBillId);
        Set billPks = matchInvRelation.stream().map(o -> o.gettBillId()).collect(Collectors.toSet());
        if (billPks.size() == 0) {
            LOGGER.error("\u5224\u65ad\u4e3a\u5339\u914d\u5355\uff0c\u6ca1\u6709\u67e5\u5230\u5173\u8054\u5173\u7cfb[\u5f02\u5e38\u60c5\u51b5]");
            matchVo.setFromRedMatchBill(false);
            return matchVo;
        }
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)"sim_original_bill", (String)PropertieUtil.getAllPropertiesSplitByComma("sim_original_bill", true), (QFilter[])new QFilter("id", "in", billPks).toArray());
        if (bills.length == 0) {
            LOGGER.error("\u6839\u636e\u5339\u914d\u5173\u7cfb\uff0c\u6ca1\u6709\u67e5\u5230\u5173\u8054\u5f00\u7968\u7533\u8bf7\u5355[\u5f02\u5e38\u60c5\u51b5]");
            matchVo.setFromRedMatchBill(false);
            return matchVo;
        }
        matchVo.setRedBills(Arrays.stream(bills).collect(Collectors.toList()));
        return matchVo;
    }

    public static boolean isInvoiceFromRedMatchBill(DynamicObject invoice) {
        DynamicObject redConfirm;
        QFilter filter;
        DynamicObject[] array;
        String issueType = invoice.getString("issuetype");
        if (IssueType.BLUE_INVOICE.getTypeCode().equals(issueType)) {
            return false;
        }
        if ("10".equals(invoice.getString("contraststatus"))) {
            return true;
        }
        String invoiceType = invoice.getString("invoicetype");
        String infoCode = invoice.getString("infocode");
        Object org = invoice.get("orgid");
        long orgPk = org instanceof DynamicObject ? ((DynamicObject)org).getLong("id") : ((Long)org).longValue();
        if (InvoiceUtils.isRedInfoInvoice(issueType, invoiceType) && (array = BusinessDataServiceHelper.load((String)"sim_red_info", (String)"id,infosource", (QFilter[])(filter = new QFilter("infocode", "=", (Object)infoCode).and("org", "=", (Object)orgPk)).toArray())).length > 0) {
            return "10".equals(array[0].getString("infosource"));
        }
        if (InvoiceUtils.isRedConfirmInvoice(issueType, invoiceType) && null != (redConfirm = RedConfirmHelper.loadConfirmBill(infoCode, orgPk))) {
            return "10".equals(redConfirm.getString("source"));
        }
        return false;
    }

    public static Set<Long> getRedMatchBlueTBillIds(Set<Long> billPks) {
        QFilter filter = new QFilter("sbillid", "in", billPks);
        DynamicObject[] matchBillRelations = BusinessDataServiceHelper.load((String)"sim_matchbill_relation", (String)PropertieUtil.getAllPropertiesSplitByComma("sim_matchbill_relation", true), (QFilter[])filter.toArray());
        if (matchBillRelations.length == 0) {
            return new HashSet<Long>();
        }
        Set matchBillPk = Arrays.stream(matchBillRelations).map(o -> o.getLong("tbillid")).collect(Collectors.toSet());
        filter = new QFilter("sbillid", "in", matchBillPk);
        DynamicObject[] relations = BusinessDataServiceHelper.load((String)"sim_match_inv_relation", (String)PropertieUtil.getAllPropertiesSplitByComma("sim_match_inv_relation", true), (QFilter[])filter.toArray());
        if (relations.length == 0) {
            return new HashSet<Long>();
        }
        Set<Long> tPks = Arrays.stream(relations).map(o -> o.getLong("tbillid")).collect(Collectors.toSet());
        return tPks;
    }

    public static String getSystemSourceFromBuyerDownloadRedInfo(DynamicObject invoiceDynamicObject) {
        DynamicObject[] redInfos;
        String invoiceType = invoiceDynamicObject.getString("invoicetype");
        String issueType = invoiceDynamicObject.getString("issuetype");
        if (!InvoiceUtils.isRedInfoInvoice(issueType, invoiceType)) {
            return null;
        }
        String infoCode = invoiceDynamicObject.getString("infocode");
        QFilter filter = new QFilter("infocode", "=", (Object)infoCode).and("salertaxno", "=", (Object)invoiceDynamicObject.getString("salertaxno"));
        for (DynamicObject redInfo : redInfos = BusinessDataServiceHelper.load((String)"sim_red_info", (String)"infosource,systemsource", (QFilter[])filter.toArray())) {
            String systemSource = redInfo.getString("systemsource");
            if ("2".equals(redInfo.getString("infosource")) || !StringUtils.isNotBlank((CharSequence)systemSource)) continue;
            return systemSource;
        }
        return null;
    }

    public static List<BillRelationDTO> getRelationFromTuiShuiTuiHuoZhengMing(DynamicObject invoice) {
        ArrayList<BillRelationDTO> result = new ArrayList<BillRelationDTO>();
        LOGGER.info("getRelationFromTuiShuiTuiHuoZhengMing");
        try {
            String issueType = invoice.getString("issuetype");
            String invoiceType = invoice.getString("invoicetype");
            if (!InvoiceUtils.isRedInfoInvoice(issueType, invoiceType)) {
                return result;
            }
            String infoCode = invoice.getString("infocode");
            QFilter filter = new QFilter("infocode", "=", (Object)infoCode).and("salertaxno", "=", (Object)invoice.getString("salertaxno")).and("infosource", "!=", (Object)"2");
            DynamicObject[] redInfos = BusinessDataServiceHelper.load((String)"sim_red_info", (String)PropertieUtil.getAllPropertiesSplitByComma("sim_red_info", true), (QFilter[])filter.toArray());
            if (redInfos.length == 0) {
                return result;
            }
            String tuiShuiTuiHuoPk = redInfos[0].getString("gj23_tuishuituihuoid");
            String tsthBillKey = "gj23_tuishuituihuo";
            String mergeBillNoFieldKey = "gj23_mergeorder_tag";
            if (StringUtils.isNotBlank((CharSequence)tuiShuiTuiHuoPk)) {
                DynamicObject[] bills;
                DynamicObject[] array = BusinessDataServiceHelper.load((String)tsthBillKey, (String)mergeBillNoFieldKey, (QFilter[])new QFilter("id", "=", (Object)Long.parseLong(tuiShuiTuiHuoPk)).toArray());
                if (array.length == 0) {
                    return result;
                }
                String billNos = array[0].getString(mergeBillNoFieldKey);
                if (StringUtils.isBlank((CharSequence)billNos)) {
                    return result;
                }
                String[] billNoArray = billNos.split(",");
                long orgPk = DynamicObjectUtil.getDynamicObjectLongValue(invoice.getDynamicObject("orgid"));
                QFilter oriBillFilter = new QFilter("orgid", "=", (Object)orgPk).and("billno", "in", (Object)billNoArray);
                for (DynamicObject bill : bills = BusinessDataServiceHelper.load((String)"sim_original_bill", (String)"id,billno,orgid,invoiceamount,totaltax", (QFilter[])oriBillFilter.toArray())) {
                    BillRelationDTO newRelation = new BillRelationDTO();
                    long billPk = bill.getLong("id");
                    newRelation.settBillId(Long.valueOf(billPk));
                    newRelation.settBillNo(bill.getString("billno"));
                    newRelation.setAmount(bill.getBigDecimal("invoiceamount"));
                    newRelation.setTax(bill.getBigDecimal("totaltax"));
                    result.add(newRelation);
                }
            }
            return result;
        }
        catch (Exception e) {
            LOGGER.error("getRelationFromTuiShuiTuiHuoZhengMing" + e.getMessage(), (Throwable)e);
            return result;
        }
    }

    public static DynamicObject[] loadRedConfirmByRelation(DynamicObject[] relationObjs) {
        List invIdList = Stream.of(relationObjs).map(o -> o.getLong("tbillid")).distinct().collect(Collectors.toList());
        return BusinessDataServiceHelper.load((String)"sim_red_confirm_bill", (String)PropertieUtil.getAllPropertiesSplitByComma("sim_red_confirm_bill", true), (QFilter[])new QFilter("id", "in", invIdList).toArray());
    }
}

