/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.invoicecallback.impl;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.IssueType;
import kd.imc.bdm.common.constant.OpenApiCallbackInterfaceCodeEnum;
import kd.imc.bdm.common.dto.CallbackLogVo;
import kd.imc.bdm.common.enums.CallBackLogTypeEnum;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.helper.IssuePolicyHelper;
import kd.imc.bdm.common.helper.OrgHelper;
import kd.imc.bdm.common.helper.callback.ApiCallBackHelper;
import kd.imc.bdm.common.helper.callback.SendCallBackHelper;
import kd.imc.bdm.common.invoicecallback.AbstractInvoiceCallBackServiceImpl;
import kd.imc.bdm.common.invoicecallback.impl.InvoiceCallBackServiceImpl;
import kd.imc.bdm.common.openapi.BizControlVo;
import kd.imc.bdm.common.openapi.CallbackResponseVo;
import kd.imc.bdm.common.openapi.InvoiceVo;
import kd.imc.bdm.common.util.CallbackHelperUtil;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.InvoiceQueryUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class InvoiceAllCallbackServiceImpl
extends AbstractInvoiceCallBackServiceImpl {
    public boolean support(CallbackLogVo callbackLogVo) {
        String businessSystemCode = callbackLogVo.getBusinessSystemCode();
        return CallBackLogTypeEnum.allCallback.getValue().equals(callbackLogVo.getCallbackType()) && businessSystemCode.startsWith("3std1") && CallbackHelperUtil.getBusinessSystemByCode(businessSystemCode) != null;
    }

    public CallbackResponseVo callBack(CallbackLogVo callbackLogVo, DynamicObject bill) {
        List<DynamicObject> invoices = this.queryBillAllInvoice(bill, callbackLogVo);
        if (OpenApiCallbackInterfaceCodeEnum.INVOICE_OPEN.getCode().equals(callbackLogVo.getBusinessType()) && "2".equals(bill.getString("validstate"))) {
            return this.sendMsg2BuisnessSystem(bill, invoices, callbackLogVo);
        }
        if (this.checkInvoiceAllIssueOrRed(bill, callbackLogVo, invoices)) {
            return this.sendMsg2BuisnessSystem(bill, invoices, callbackLogVo);
        }
        return null;
    }

    private boolean checkInvoiceAllIssueOrRed(DynamicObject bill, CallbackLogVo callbackLogVo, List<DynamicObject> invoices) {
        ArrayList<DynamicObject> redInvoice = new ArrayList<DynamicObject>(invoices.size());
        for (DynamicObject invoiceObj : invoices) {
            if (OpenApiCallbackInterfaceCodeEnum.INVOICE_OPEN.getCode().equals(callbackLogVo.getBusinessType()) || OpenApiCallbackInterfaceCodeEnum.INVOICE_CANCEL.getCode().equals(callbackLogVo.getBusinessType())) {
                if (OpenApiCallbackInterfaceCodeEnum.INVOICE_OPEN.getCode().equals(callbackLogVo.getBusinessType())) {
                    ImmutableSet immutableSet = ImmutableSet.of((Object)IssueStatusEnum.ok.getCode(), (Object)IssueStatusEnum.failed.getCode());
                    if (immutableSet.contains((Object)invoiceObj.getString("issuestatus"))) continue;
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info(String.format("%s\u5b58\u5728\u6ca1\u6709\u5f00\u7968\u7ed3\u675f\u7684\u53d1\u7968", bill.getString("billno")));
                    }
                    return false;
                }
                if ("6".equals(invoiceObj.getString("invoicestatus"))) continue;
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info(String.format("%s\u5b58\u5728\u6ca1\u6709\u4f5c\u5e9f\u6210\u529f\u7684\u53d1\u7968", bill.getString("billno")));
                }
                return false;
            }
            QFilter qFilter = new QFilter("orgid", "=", (Object)DynamicObjectUtil.getDynamicObjectLongValue(invoiceObj.get("orgid"))).and("originalinvoicecode", "=", (Object)invoiceObj.getString("invoicecode")).and("originalinvoiceno", "=", (Object)invoiceObj.getString("invoiceno"));
            DynamicObject redObj = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma("sim_vatinvoice", true), (QFilter[])qFilter.toArray());
            if (redObj == null) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info(String.format("%s\u5b58\u5728\u6ca1\u6709\u7ea2\u51b2\u7684\u53d1\u7968", bill.getString("billno")));
                }
                return false;
            }
            redInvoice.add(redObj);
        }
        if (CollectionUtils.isNotEmpty(redInvoice)) {
            invoices.clear();
            invoices.addAll(redInvoice);
        }
        return true;
    }

    private CallbackResponseVo sendMsg2BuisnessSystem(DynamicObject bill, List<DynamicObject> invoices, CallbackLogVo callbackLogVo) {
        ArrayList<InvoiceVo> invoiceVoList = new ArrayList<InvoiceVo>(invoices.size());
        boolean isIssue = OpenApiCallbackInterfaceCodeEnum.INVOICE_OPEN.getCode().equals(callbackLogVo.getBusinessType()) || OpenApiCallbackInterfaceCodeEnum.INVOICE_RED.getCode().equals(callbackLogVo.getBusinessType()) || OpenApiCallbackInterfaceCodeEnum.ALLE_INVOICE_OPEN.getCode().equals(callbackLogVo.getBusinessType());
        for (DynamicObject invoice : invoices) {
            if (isIssue && InvoiceUtils.isAllEInvoice(invoice.getString("invoicetype")) && !InvoiceCallBackServiceImpl.checkFileExists(invoice.getDate("issuetime"), invoice.getString("invoiceno"))) {
                this.updateCallbackLogFileNotCreate(callbackLogVo);
                return null;
            }
            InvoiceVo invoiceVo = ApiCallBackHelper.invoiceDynamicConvert2InvoiceVo(invoice, callbackLogVo.getBusinessType());
            invoiceVo.setBillNo(bill.getString("billno"));
            invoiceVoList.add(invoiceVo);
        }
        DynamicObject callbackLog = BusinessDataServiceHelper.loadSingle((Object)callbackLogVo.getId(), (String)"invsm_callback_log");
        BizControlVo bizControlVo = IssuePolicyHelper.getBizControlVo((DynamicObject)invoices.get(0));
        boolean allIssueSuccess = invoiceVoList.stream().allMatch(inv -> StringUtils.isNotBlank((CharSequence)inv.getInvoiceNum()));
        return SendCallBackHelper.sendCallBackHttpRequest((String)(allIssueSuccess ? null : callbackLogVo.getCallbackMessage()), (DynamicObject)callbackLog, (String)JSONObject.toJSONString(invoiceVoList), (boolean)false, (BizControlVo)bizControlVo);
    }

    private List<DynamicObject> queryBillAllInvoice(DynamicObject bill, CallbackLogVo callbackLogVo) {
        DynamicObject[] relations = BusinessDataServiceHelper.load((String)"sim_bill_inv_relation", (String)"tbillid", (QFilter[])new QFilter("sbillid", "=", bill.getPkValue()).toArray());
        List invIdList = Stream.of(relations).map(o -> o.getLong("tbillid")).distinct().collect(Collectors.toList());
        if (OpenApiCallbackInterfaceCodeEnum.INVOICE_OPEN.getCode().equals(callbackLogVo.getBusinessType()) || OpenApiCallbackInterfaceCodeEnum.ALLE_INVOICE_OPEN.getCode().equals(callbackLogVo.getBusinessType())) {
            DynamicObject[] redInfos;
            if (InvoiceUtils.isAllEInvoice(callbackLogVo.getInvoiceType()) && IssueType.RED_INVOICE.getTypeCode().equals(callbackLogVo.getIssueType())) {
                DynamicObject[] redConfirms = BusinessDataServiceHelper.load((String)"sim_red_confirm_bill", (String)String.join((CharSequence)",", "issuestatus", "invoiceno", "salertaxno", "uploaddate", "orderno"), (QFilter[])new QFilter("id", "in", invIdList).toArray());
                if (redConfirms.length != 0) {
                    invIdList.clear();
                    for (DynamicObject redConfirm : redConfirms) {
                        String issueStatus = redConfirm.getString("issuestatus");
                        if ("0".equals(issueStatus)) {
                            QFilter qFilter = InvoiceQueryUtil.getInvoiceByCodeAndNo("", redConfirm.getString("invoiceno"));
                            DynamicObject invoiceObj = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)"", (QFilter[])qFilter.toArray());
                            invIdList.add((Long)invoiceObj.getPkValue());
                            continue;
                        }
                        if (!IssueStatusEnum.failed.getCode().equals(issueStatus)) continue;
                        QFilter orgFilter = new QFilter("orgid", "in", (Object)new OrgHelper().getOrgIdsByTaxNo(redConfirm.getString("salertaxno")));
                        Date uploadDate = redConfirm.getDate("uploaddate");
                        if (uploadDate != null) {
                            orgFilter.and("createtime", ">=", (Object)redConfirm.getDate("uploaddate"));
                        }
                        orgFilter.and("orderno", "=", (Object)redConfirm.getString("orderno"));
                        DynamicObject invoiceObj = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)"", (QFilter[])orgFilter.toArray());
                        invIdList.add((Long)invoiceObj.getPkValue());
                    }
                }
            } else if (InvoiceUtils.isSpecialInvoice(callbackLogVo.getInvoiceType()) && IssueType.RED_INVOICE.getTypeCode().equals(callbackLogVo.getIssueType()) && (redInfos = BusinessDataServiceHelper.load((String)"sim_red_info", (String)String.join((CharSequence)",", "status", "invoicecode", "invoiceno"), (QFilter[])new QFilter("id", "in", invIdList).toArray())).length != 0) {
                invIdList.clear();
                for (DynamicObject redInfo : redInfos) {
                    if (!"4".equals(redInfo.getString("status"))) continue;
                    QFilter qFilter = InvoiceQueryUtil.getInvoiceByCodeAndNo(redInfo.getString("invoicecode"), redInfo.getString("invoiceno"));
                    DynamicObject invoiceObj = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)"", (QFilter[])qFilter.toArray());
                    invIdList.add((Long)invoiceObj.getPkValue());
                }
            }
        }
        DynamicObject[] inovices = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma("sim_vatinvoice", true), (QFilter[])new QFilter("id", "in", invIdList).toArray());
        return Arrays.stream(inovices).collect(Collectors.toList());
    }
}

