/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.message.send;

import com.alibaba.fastjson.JSONObject;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.message.model.MsgRequest;
import kd.imc.bdm.common.message.model.MsgResponse;
import kd.imc.bdm.common.message.util.IsmcToken;
import kd.imc.bdm.common.util.AES128;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.HttpUtil;
import kd.imc.bdm.common.util.ImcConfigUtil;

public class MessageSendService {
    private static final Log LOGGER = LogFactory.getLog(MessageSendService.class);
    public static final int READ_TIMEOUT = 180000;

    public static MsgResponse send(MsgRequest request) {
        int readTime = MessageSendService.getReadTime();
        return MessageSendService.send(request, null, "", readTime, readTime);
    }

    public static MsgResponse send(MsgRequest request, IsmcToken ismcToken, String url, int connectionTimeout, int readTimeout) {
        request.setTenantId(RequestContext.get().getTenantId());
        request.setImcAccountId(RequestContext.get().getAccountId());
        MsgResponse msgResponse = new MsgResponse();
        try {
            String respStr;
            if (null == ismcToken) {
                ismcToken = new IsmcToken();
            }
            MessageSendService.setRequestData(request, ismcToken);
            String reqStr = SerializationUtils.toJsonString((Object)request);
            if ("imc_deploy_private".equals(ismcToken.getConfig("bdm_ismc_config_deploy"))) {
                respStr = (String)DispatchServiceHelper.invokeBizService((String)"ismc", (String)"dim", (String)"MessageReceive", (String)"messageReceive", (Object[])new Object[]{reqStr});
            } else {
                if (StringUtils.isBlank((CharSequence)url)) {
                    url = ismcToken.getRequestUrl("/kapi/app/dim/msgreceive?access_token=" + ismcToken.getToken());
                }
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("\u8bf7\u6c42\u7a0e\u63a7\u7cfb\u7edf\u4e91 url === " + url);
                }
                respStr = HttpUtil.doPostJson(url, ismcToken.getProxy(), null, reqStr, connectionTimeout, readTimeout);
            }
            if (StringUtils.isBlank((CharSequence)respStr)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u6c42\u7a0e\u63a7\u7cfb\u7edf\u4e91\uff0c\u8fd4\u56de\u4e3a\u7a7a", (String)"MessageSendService_1", (String)"imc-bdm-common", (Object[])new Object[0]));
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(request.getMsgType() + "respStr:" + respStr);
            }
            JSONObject json = JSONObject.parseObject((String)respStr);
            msgResponse.setErrorCode(json.getString("errorCode"));
            String message = json.getString("message");
            msgResponse.setErrorMsg(message);
            String respData = json.getString("data");
            msgResponse.setRespData(respData);
            try {
                if (String.valueOf(message).contains("\u8bf7\u52ff\u91cd\u590d\u4f5c\u5e9f")) {
                    msgResponse.setErrorCode(ErrorType.SUCCESS.getCode());
                    msgResponse.setErrorMsg(ErrorType.SUCCESS.getName());
                    msgResponse.setRespData(ResManager.loadKDString((String)"\u53d1\u7968\u5df2\u4f5c\u5e9f", (String)"MessageSendService_3", (String)"imc-bdm-common", (Object[])new Object[0]));
                } else {
                    respData = AES128.decrypt(respData, MessageSendService.getEncrypt(ismcToken));
                    LOGGER.info(String.format("%s Response ErrorCode:%s", request.getMsgType(), json.getString("errorCode")));
                    msgResponse.setRespData(respData);
                }
            }
            catch (Exception e) {
                LOGGER.error(request.getMsgType() + " \u6d88\u606f\u89e3\u5bc6\u5931\u8d25");
                throw new MsgException(e, ResManager.loadKDString((String)"\u6d88\u606f\u89e3\u5bc6\u5931\u8d25", (String)"MessageSendService_6", (String)"imc-bdm-common", (Object[])new Object[0]));
            }
        }
        catch (SocketTimeoutException e) {
            msgResponse.setErrorCode(ErrorType.FAIL.getCode());
            msgResponse.setErrorMsg(ResManager.loadKDString((String)"\u8bf7\u6c42\u7a0e\u63a7\u8bbe\u5907\u8d85\u65f6\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"MessageSendService_11", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        catch (MsgException e) {
            LOGGER.error(e.toString(), (Throwable)e);
            msgResponse.setErrorCode(e.getErrorCode());
            msgResponse.setErrorMsg(e.getErrorMsg());
        }
        catch (Exception e) {
            LOGGER.error(request.getMsgId() + "\u53d1\u9001\u5f02\u5e38" + e.getMessage(), (Throwable)e);
            msgResponse.setErrorCode(ErrorType.FAIL.getCode());
            msgResponse.setErrorMsg(String.format(ResManager.loadKDString((String)"\u53d1\u9001\u5f02\u5e38:%s", (String)"MessageSendService_12", (String)"imc-bdm-common", (Object[])new Object[0]), e.getMessage()));
        }
        return msgResponse;
    }

    private static void setRequestData(MsgRequest request, IsmcToken ismcToken) {
        String reqDataStr = null;
        try {
            if (request.getReqData() != null) {
                reqDataStr = request.getReqData() instanceof String ? request.getReqData().toString() : SerializationUtils.toJsonString((Object)request.getReqData());
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(request.getMsgType() + "Request:" + reqDataStr);
            }
            reqDataStr = AES128.encrypt(reqDataStr, MessageSendService.getEncrypt(ismcToken));
        }
        catch (Exception e) {
            throw new MsgException(e, ResManager.loadKDString((String)"\u6d88\u606f\u52a0\u5bc6\u5931\u8d25", (String)"MessageSendService_10", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        request.setReqData((Object)reqDataStr);
    }

    private static String getEncrypt(IsmcToken ismcToken) {
        String key_en_crypt = ismcToken.getConfig("bdm_ismc_config_encryptkey");
        if (StringUtils.isEmpty((CharSequence)key_en_crypt)) {
            key_en_crypt = "!!king?DeE|12345";
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("\u8bf7\u6c42\u7a0e\u63a7\u7cfb\u7edf\u4e91 encryptkey === " + key_en_crypt);
        }
        return key_en_crypt;
    }

    private static int getReadTime() {
        int readTime = 180000;
        try {
            String configValue = ImcConfigUtil.getValue("dim_read_time", "dim_read_time");
            if (org.apache.commons.lang.StringUtils.isBlank((String)configValue)) {
                configValue = String.valueOf(180000);
                HashMap<String, String> map = new HashMap<String, String>(1);
                map.put("dim_read_time", String.valueOf(180000));
                String cacheStr = SerializationUtils.toJsonString(map);
                CacheHelper.put("dim_read_time", cacheStr, 18000);
            }
            readTime = Integer.parseInt(configValue);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return readTime;
    }
}

