/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.allele.AllEleInterfaceTypeEnum;
import kd.imc.bdm.common.dto.allele.AllEleAddOrUpdateAccountDTO;
import kd.imc.bdm.common.dto.allele.AllEleAddOrUpdateAccountResponseDTO;
import kd.imc.bdm.common.dto.allele.AllEleBatchAddOrUpdateAccountDTO;
import kd.imc.bdm.common.dto.allele.AllEleBatchAddOrUpdateAccountQueryDTO;
import kd.imc.bdm.common.dto.allele.AllEleResponseDTO;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.AllEleServiceHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.SystemParameterHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.PropertieUtil;

public class AllEleAccountSyncServiceImpl {
    private static final Set<String> systemSourceSet = new HashSet<String>(Arrays.asList("1", "2", "3", "4", "5"));
    private static final Set<String> accountTypeSet = new HashSet<String>(Arrays.asList("1", "2", "3", "4"));
    private static final Set<String> loginTypeSet = new HashSet<String>(Arrays.asList("1", "2", "3", "0"));
    private static final Set<String> loginRoleSet = new HashSet<String>(Arrays.asList("01", "02", "03", "05", "07", "08", "09", "10", "11", "12"));
    private static final Log LOGGER = LogFactory.getLog(AllEleAccountSyncServiceImpl.class);

    public JSONObject syncAccount(JSONObject inputJson) {
        LOGGER.info("syncAccountParam:" + inputJson);
        JSONObject result = new JSONObject();
        ArrayList<AllEleAddOrUpdateAccountDTO> accountList = new ArrayList<AllEleAddOrUpdateAccountDTO>();
        JSONObject baseCheckResult = this.baseCheckParam(inputJson, result, accountList);
        if (baseCheckResult != null) {
            return baseCheckResult;
        }
        HashMap<DynamicObject, List<AllEleAddOrUpdateAccountDTO>> groupMap = new HashMap<DynamicObject, List<AllEleAddOrUpdateAccountDTO>>();
        JSONObject checkResult = this.checkAndFillInputAccountList(result, accountList, groupMap);
        if (checkResult != null) {
            return checkResult;
        }
        HashMap<String, List> batchNoDtos = new HashMap<String, List>();
        for (Map.Entry dbAccountListAccountEntry : groupMap.entrySet()) {
            List accountDtos = (List)dbAccountListAccountEntry.getValue();
            AllEleResponseDTO<AllEleAddOrUpdateAccountResponseDTO> response = this.addOrUpdateAccount2Aws(accountDtos);
            if (response.getSuccess().booleanValue()) {
                batchNoDtos.put(((AllEleAddOrUpdateAccountResponseDTO)response.getData()).getBatchNo(), accountDtos);
                continue;
            }
            result.put("errcode", (Object)ErrorType.FAIL.getCode());
            result.put("description", (Object)response.getDescription());
            return result;
        }
        Throwable throwable = null;
        try (TXHandle tx = TX.requiresNew();){
            ArrayList<DynamicObject> syncInfos = new ArrayList<DynamicObject>(groupMap.size());
            ArrayList<JSONObject> batchNos = new ArrayList<JSONObject>(accountList.size());
            for (Map.Entry entry : batchNoDtos.entrySet()) {
                String batchNo = (String)entry.getKey();
                List accountDtos = (List)entry.getValue();
                DynamicObject syncInfo = BusinessDataServiceHelper.newDynamicObject((String)"invsm_botp_callback_log");
                syncInfo.set("createtime", (Object)new Date());
                syncInfo.set("business", (Object)"5");
                syncInfo.set("param_tag", (Object)JSONObject.toJSONString((Object)accountDtos));
                syncInfo.set("invoiceno", (Object)batchNo);
                syncInfos.add(syncInfo);
                JSONObject data = new JSONObject();
                data.put("batchNo", (Object)batchNo);
                batchNos.add(data);
            }
            if (syncInfos.size() > 0) {
                ImcSaveServiceHelper.save(syncInfos);
            }
            result.put("errcode", (Object)ErrorType.SUCCESS.getCode());
            result.put("description", (Object)ErrorType.SUCCESS.getName());
            result.put("data", batchNos);
            JSONObject jSONObject = result;
            return jSONObject;
        }
        catch (Exception e) {
            tx.markRollback();
            LOGGER.error("\u4fdd\u5b58\u5931\u8d25" + e.getMessage(), (Throwable)e);
            result.put("errcode", (Object)ErrorType.FAIL.getCode());
            result.put("description", (Object)ResManager.loadKDString((String)"\u66f4\u65b0\u6570\u7535\u8d26\u53f7\u5931\u8d25", (String)"AllEleAccountSyncServiceImpl_0", (String)"imc-bdm-common", (Object[])new Object[0]));
            JSONObject jSONObject = result;
            return jSONObject;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
    }

    public JSONObject querySyncResult(JSONObject inputJson) {
        DynamicObject[] logs;
        LOGGER.info("querySyncResultAccountParam:" + inputJson);
        JSONObject result = new JSONObject();
        JSONObject jsonObject = this.checkEmpty(inputJson, result);
        if (jsonObject != null) {
            return jsonObject;
        }
        String batchNo = inputJson.getString("batchNo");
        if (StringUtils.isBlank((CharSequence)batchNo)) {
            result.put("errcode", (Object)ErrorType.EMPTY_PARAM.getCode());
            result.put("description", (Object)ResManager.loadKDString((String)"batchNo\u4e3a\u7a7a\u8bf7\u68c0\u67e5", (String)"AllEleAccountSyncServiceImpl_1", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        if ((logs = BusinessDataServiceHelper.load((String)"invsm_botp_callback_log", (String)PropertieUtil.getAllPropertiesSplitByComma("invsm_botp_callback_log", true), (QFilter[])new QFilter("invoiceno", "=", (Object)batchNo).toArray())).length == 0) {
            result.put("errcode", (Object)ErrorType.EMPTY_PARAM.getCode());
            result.put("description", (Object)ResManager.loadKDString((String)"\u8be5\u6279\u6b21\u540c\u6b65\u6570\u636e\u5df2\u8fc7\u671f\u6216\u6279\u6b21\u53f7\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u540c\u6b65", (String)"AllEleAccountSyncServiceImpl_2", (String)"imc-bdm-common", (Object[])new Object[0]));
            return result;
        }
        DynamicObject log = logs[0];
        String syncParam = log.getString("param_tag");
        List syncParamList = JSONObject.parseArray((String)syncParam, AllEleAddOrUpdateAccountDTO.class);
        AllEleResponseDTO response = new AllEleResponseDTO();
        AllEleAddOrUpdateAccountResponseDTO addResponse = new AllEleAddOrUpdateAccountResponseDTO();
        addResponse.setBatchNo(batchNo);
        response.setData((Object)addResponse);
        AllEleResponseDTO<JSONArray> syncResult = this.queryAddOrUpDateResponse(syncParamList, (AllEleResponseDTO<AllEleAddOrUpdateAccountResponseDTO>)response);
        long orgId = RequestContext.get().getOrgId();
        if (0L == orgId) {
            DynamicObject[] orgs = BusinessDataServiceHelper.load((String)"bdm_org", (String)"id", null, (String)"id desc", (int)1);
            orgId = orgs[0].getLong("id");
        }
        String syncConfig = SystemParameterHelper.getBdmParameter(orgId, "syncaccountway");
        LOGGER.info("TempLogsyncConfig:" + syncConfig);
        if (!"1".equals(syncConfig)) {
            this.fillResultFromQueryResult(result, syncResult);
            return result;
        }
        try {
            this.updateDBAccount(syncParamList, syncResult);
            this.fillResultFromQueryResult(result, syncResult);
            return result;
        }
        catch (Exception e) {
            LOGGER.error("updateDBAccountFail:" + e.getMessage(), (Throwable)e);
            result.put("errcode", (Object)ErrorType.FAIL.getCode());
            result.put("description", (Object)ResManager.loadKDString((String)"\u67e5\u8be2\u540c\u6b65\u6570\u7535\u8d26\u53f7\u7ed3\u679c\u5f02\u5e38", (String)"AllEleAccountSyncServiceImpl_3", (String)"imc-bdm-common", (Object[])new Object[0]));
            return result;
        }
    }

    private void fillResultFromQueryResult(JSONObject result, AllEleResponseDTO<JSONArray> syncResult) {
        result.put("errcode", (Object)syncResult.getErrcode());
        result.put("description", (Object)syncResult.getDescription());
        result.put("data", syncResult.getData());
    }

    private void updateDBAccount(List<AllEleAddOrUpdateAccountDTO> syncParamList, AllEleResponseDTO<JSONArray> syncResult) {
        HashSet<String> taxNoSet = new HashSet<String>(syncParamList.size());
        for (AllEleAddOrUpdateAccountDTO dto : syncParamList) {
            taxNoSet.add(dto.getTaxNo());
        }
        JSONArray data = (JSONArray)syncResult.getData();
        Set successTaxNoAccountSet = data.stream().filter(o -> "1".equals(((JSONObject)o).getString("status"))).map(o -> ((JSONObject)o).getString("taxNo") + ((JSONObject)o).getString("account")).collect(Collectors.toSet());
        LOGGER.info("successTaxNoAccountSet:" + JSONObject.toJSONString(successTaxNoAccountSet));
        DynamicObject[] dbAccounts = BusinessDataServiceHelper.load((String)"bdm_einvoice_account", (String)PropertieUtil.getAllPropertiesSplitByComma("bdm_einvoice_account", true), (QFilter[])new QFilter("taxno", "in", taxNoSet).toArray());
        Map<String, DynamicObject> dbTaxNoAccountMap = Arrays.stream(dbAccounts).collect(Collectors.toMap(o -> o.getString("taxno"), o -> o, (v1, v2) -> v2));
        for (AllEleAddOrUpdateAccountDTO accountDTO : syncParamList) {
            LOGGER.info("accountDTO:" + JSONObject.toJSONString((Object)accountDTO));
            if (!successTaxNoAccountSet.contains(accountDTO.getTaxNo() + accountDTO.getAccount())) {
                LOGGER.info("not contains");
                continue;
            }
            DynamicObject dbAccount = dbTaxNoAccountMap.get(accountDTO.getTaxNo());
            if (dbAccount == null) {
                LOGGER.info("db not contains");
                continue;
            }
            DynamicObjectCollection accountItems = dbAccount.getDynamicObjectCollection("entryentity");
            boolean isContainsAccount = false;
            for (DynamicObject accountItem : accountItems) {
                String dbAccountNumber = accountItem.getString("account");
                if (!Objects.equals(dbAccountNumber, accountDTO.getAccount())) continue;
                LOGGER.info("db account equals ");
                isContainsAccount = true;
                this.updateAccount(accountDTO, accountItem);
            }
            if (!isContainsAccount) {
                LOGGER.info("add new Item");
                LOGGER.info("accountDTO:" + JSONObject.toJSONString((Object)accountDTO));
                this.addNewAccount(accountDTO, accountItems);
            }
            dbAccount.set("modifytime", (Object)new Date());
        }
        ImcSaveServiceHelper.save(new ArrayList<DynamicObject>(dbTaxNoAccountMap.values()));
    }

    private void updateAccount(AllEleAddOrUpdateAccountDTO accountDTO, DynamicObject accountItem) {
        if (StringUtils.isBlank((CharSequence)accountItem.getString("accounttype"))) {
            accountItem.set("accounttype", (Object)accountDTO.getDefaultAccountType());
        }
        if ("3".equals(accountDTO.getDefaultAccountType()) && "3".equals(accountItem.getString("accounttype")) && StringUtils.isBlank((CharSequence)accountItem.getString("defaultbusiness"))) {
            accountItem.set("defaultbusiness", (Object)accountDTO.getDefaultAccountType());
        } else {
            if (AllEleAuthHelper.isOutputBusiness(accountDTO.getDefaultAccountType()) && AllEleAuthHelper.isOutputBusiness(accountItem.getString("accounttype")) && StringUtils.isBlank((CharSequence)accountItem.getString("defaultbusiness"))) {
                accountItem.set("defaultbusiness", (Object)"1");
            }
            if (AllEleAuthHelper.isInputBusiness(accountDTO.getDefaultAccountType()) && AllEleAuthHelper.isInputBusiness(accountItem.getString("accounttype")) && StringUtils.isBlank((CharSequence)accountItem.getString("defaultbusiness"))) {
                accountItem.set("defaultbusiness", (Object)"2");
            }
        }
        if (StringUtils.isBlank((CharSequence)accountItem.getString("logintype"))) {
            accountItem.set("logintype", (Object)"1");
        }
    }

    private void addNewAccount(AllEleAddOrUpdateAccountDTO accountDTO, DynamicObjectCollection accountItems) {
        DynamicObject newAccount = accountItems.addNew();
        newAccount.set("account", (Object)accountDTO.getAccount());
        newAccount.set("isenable", (Object)"1");
        newAccount.set("accounttype", (Object)accountDTO.getDefaultAccountType());
        newAccount.set("channeltype", (Object)"1");
        newAccount.set("logintype", (Object)"1");
        newAccount.set("isdefault", (Object)"0");
        newAccount.set("defaultbusiness", (Object)accountDTO.getDefaultAccountType());
        if ("4".equals(accountDTO.getDefaultAccountType())) {
            newAccount.set("defaultbusiness", null);
        }
        newAccount.set("loginstatus", (Object)"0");
        newAccount.set("authstatus", (Object)"0");
    }

    private JSONObject baseCheckParam(JSONObject inputJson, JSONObject result, List<AllEleAddOrUpdateAccountDTO> accountList) {
        JSONObject result1 = this.checkEmpty(inputJson, result);
        if (result1 != null) {
            return result1;
        }
        if (null == inputJson.getString("accountList")) {
            result.put("errcode", (Object)ErrorType.EMPTY_PARAM.getCode());
            result.put("description", (Object)ResManager.loadKDString((String)"accountList\u4e3a\u7a7a\u8bf7\u68c0\u67e5", (String)"AllEleAccountSyncServiceImpl_5", (String)"imc-bdm-common", (Object[])new Object[0]));
            return result;
        }
        try {
            List list = JSONObject.parseArray((String)inputJson.getString("accountList"), AllEleAddOrUpdateAccountDTO.class);
            accountList.addAll(list);
        }
        catch (Exception e) {
            result.put("errcode", (Object)ErrorType.EMPTY_PARAM.getCode());
            result.put("description", (Object)ResManager.loadKDString((String)"accountList\u4f20\u5165\u6709\u8bef\u8bf7\u68c0\u67e5", (String)"AllEleAccountSyncServiceImpl_4", (String)"imc-bdm-common", (Object[])new Object[0]));
            return result;
        }
        if (accountList.size() == 0) {
            result.put("errcode", (Object)ErrorType.EMPTY_PARAM.getCode());
            result.put("description", (Object)ResManager.loadKDString((String)"accountList\u4e3a\u7a7a\u8bf7\u68c0\u67e5", (String)"AllEleAccountSyncServiceImpl_5", (String)"imc-bdm-common", (Object[])new Object[0]));
            return result;
        }
        return null;
    }

    private JSONObject checkEmpty(JSONObject inputJson, JSONObject result) {
        if (null == inputJson) {
            result.put("errcode", (Object)ErrorType.EMPTY_PARAM.getCode());
            result.put("", (Object)ErrorType.EMPTY_PARAM.getName());
            return result;
        }
        return null;
    }

    public AllEleResponseDTO<AllEleAddOrUpdateAccountResponseDTO> addOrUpdateAccount2Aws(List<AllEleAddOrUpdateAccountDTO> accountList) {
        AllEleBatchAddOrUpdateAccountDTO updateAccountDTO = new AllEleBatchAddOrUpdateAccountDTO();
        updateAccountDTO.setList(accountList);
        updateAccountDTO.setAccount(accountList.get(0).getAccount());
        updateAccountDTO.setHistorySync(true);
        updateAccountDTO.setRequest_path(AllEleInterfaceTypeEnum.ADD_OR_UPDATE_ACCOUNT.getRequestPath());
        return AllEleServiceHelper.doPost(accountList.get(0).getTaxNo(), updateAccountDTO, AllEleAddOrUpdateAccountResponseDTO.class);
    }

    public AllEleResponseDTO<JSONArray> queryAddOrUpDateResponse(List<AllEleAddOrUpdateAccountDTO> accountList, AllEleResponseDTO<AllEleAddOrUpdateAccountResponseDTO> response) {
        AllEleBatchAddOrUpdateAccountQueryDTO queryDTO = new AllEleBatchAddOrUpdateAccountQueryDTO();
        queryDTO.setBatchNo(((AllEleAddOrUpdateAccountResponseDTO)response.getData()).getBatchNo());
        queryDTO.setAccount(accountList.get(0).getAccount());
        queryDTO.setRequest_path(AllEleInterfaceTypeEnum.ASYNC_ACCOUNT_QUERY.getRequestPath());
        return AllEleServiceHelper.doPost(accountList.get(0).getTaxNo(), queryDTO, JSONArray.class);
    }

    private JSONObject checkAndFillInputAccountList(JSONObject result, List<AllEleAddOrUpdateAccountDTO> accountList, Map<DynamicObject, List<AllEleAddOrUpdateAccountDTO>> groupMap) {
        StringBuilder errorMsgBuilder = new StringBuilder();
        HashSet<String> taxNoSet = new HashSet<String>(accountList.size());
        HashMap<String, ArrayList<AllEleAddOrUpdateAccountDTO>> taxNoDtoMap = new HashMap<String, ArrayList<AllEleAddOrUpdateAccountDTO>>();
        if (accountList.size() > 100) {
            result.put("errcode", (Object)ErrorType.FAIL.getCode());
            result.put("description", (Object)ResManager.loadKDString((String)"accountList\u4e2d\u4e0d\u80fd\u8d85\u8fc7100\u6761\u6570\u636e", (String)"AllEleAccountSyncServiceImpl_6", (String)"imc-bdm-common", (Object[])new Object[0]));
            return result;
        }
        HashSet<Integer> indexSet = new HashSet<Integer>(accountList.size());
        HashSet<String> taxNoAccountSet = new HashSet<String>(accountList.size());
        for (int i = 0; i < accountList.size(); ++i) {
            AllEleAddOrUpdateAccountDTO accountDto = accountList.get(i);
            JSONObject checkResult = this.checkEmptyAndEnum(result, errorMsgBuilder, i, accountDto);
            if (checkResult != null) {
                return checkResult;
            }
            if (indexSet.contains(accountDto.getIndex())) {
                result.put("errcode", (Object)ErrorType.FAIL.getCode());
                result.put("description", (Object)ResManager.loadKDString((String)"accountList\u4e2dindex\u4e0d\u80fd\u91cd\u590d", (String)"AllEleAccountSyncServiceImpl_21", (String)"imc-bdm-common", (Object[])new Object[0]));
                return result;
            }
            String key = accountDto.getTaxNo() + accountDto.getAccount();
            if (taxNoAccountSet.contains(key)) {
                result.put("errcode", (Object)ErrorType.FAIL.getCode());
                result.put("description", (Object)String.format(ResManager.loadKDString((String)"\u7a0e\u53f7:%1$s\u6570\u7535\u8d26\u53f7\uff1a%2$s\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5", (String)"AllEleAccountSyncServiceImpl_22", (String)"imc-bdm-common", (Object[])new Object[0]), accountDto.getTaxNo(), accountDto.getAccount()));
                return result;
            }
            taxNoAccountSet.add(key);
            indexSet.add(accountDto.getIndex());
            taxNoSet.add(accountDto.getTaxNo());
            ArrayList<AllEleAddOrUpdateAccountDTO> taxNoDtos = (ArrayList<AllEleAddOrUpdateAccountDTO>)taxNoDtoMap.get(accountDto.getTaxNo());
            if (null == taxNoDtos) {
                taxNoDtos = new ArrayList<AllEleAddOrUpdateAccountDTO>(accountList.size());
                taxNoDtos.add(accountDto);
                taxNoDtoMap.put(accountDto.getTaxNo(), taxNoDtos);
                continue;
            }
            taxNoDtos.add(accountDto);
        }
        DynamicObject[] accounts = BusinessDataServiceHelper.load((String)"bdm_einvoice_account", (String)PropertieUtil.getAllPropertiesSplitByComma("bdm_einvoice_account", true), (QFilter[])new QFilter("taxno", "in", taxNoSet).toArray());
        Map<String, DynamicObject> dbTaxNoAccountMap = Arrays.stream(accounts).collect(Collectors.toMap(o -> o.getString("taxno"), o -> o, (v1, v2) -> v2));
        for (String s : taxNoSet) {
            if (dbTaxNoAccountMap.containsKey(s) && !StringUtils.isBlank((CharSequence)dbTaxNoAccountMap.get(s).getString("clientid"))) continue;
            result.put("errcode", (Object)ErrorType.FAIL.getCode());
            result.put("description", (Object)String.format(ResManager.loadKDString((String)"\u540c\u6b65\u5931\u8d25\uff0c\u8bf7\u5148\u5230\u201c\u53d1\u7968\u4e91->\u57fa\u7840\u8d44\u6599->\u6570\u7535\u914d\u7f6e\u201d\u83dc\u5355\uff0c\u70b9\u51fb\u201c\u5347\u7ea7\u6570\u7535\u7968\u201d\u6309\u94ae\u751f\u6210\u5bf9\u5e94\u7a0e\u53f7%s\u7684\u6570\u7535\u914d\u7f6e\u3002", (String)"AllEleAccountSyncServiceImpl_7", (String)"imc-bdm-common", (Object[])new Object[0]), s));
            return result;
        }
        HashMap<String, DynamicObject> clientIdAccountMap = new HashMap<String, DynamicObject>();
        HashMap clientIdInputDtoMap = new HashMap();
        for (Map.Entry entry : taxNoDtoMap.entrySet()) {
            String key = (String)entry.getKey();
            List inputAccountList = (List)entry.getValue();
            DynamicObject dbAccount = dbTaxNoAccountMap.get(key);
            DynamicObjectCollection accountItems = dbAccount.getDynamicObjectCollection("entryentity");
            for (DynamicObject accountItem : accountItems) {
                String account = accountItem.getString("account");
                for (AllEleAddOrUpdateAccountDTO accountDTO : inputAccountList) {
                    String inputAccount = accountDTO.getAccount();
                    if (!Objects.equals(account, inputAccount) || !accountDTO.getDefaultAccountType().equals("4")) continue;
                    accountDTO.setDefaultAccountType(accountItem.getString("defaultbusiness"));
                }
            }
            for (AllEleAddOrUpdateAccountDTO dto : inputAccountList) {
                if (!dto.getDefaultAccountType().equals("4")) continue;
                dto.setDefaultAccountType("3");
            }
            clientIdAccountMap.put(dbAccount.getString("clientid"), dbAccount);
            ArrayList allEleAddOrUpdateAccountDTOS = (ArrayList)clientIdInputDtoMap.get(dbAccount.getString("clientid"));
            if (null == allEleAddOrUpdateAccountDTOS) {
                allEleAddOrUpdateAccountDTOS = new ArrayList(inputAccountList);
                clientIdInputDtoMap.put(dbAccount.getString("clientid"), allEleAddOrUpdateAccountDTOS);
                continue;
            }
            allEleAddOrUpdateAccountDTOS.addAll(inputAccountList);
        }
        for (Map.Entry entry : clientIdAccountMap.entrySet()) {
            DynamicObject dbAccount = (DynamicObject)entry.getValue();
            String clientId = (String)entry.getKey();
            groupMap.put(dbAccount, (List<AllEleAddOrUpdateAccountDTO>)clientIdInputDtoMap.get(clientId));
        }
        return null;
    }

    private JSONObject checkEmptyAndEnum(JSONObject result, StringBuilder errorMsgBuilder, int i, AllEleAddOrUpdateAccountDTO accountDto) {
        Set<String> provinceSet;
        Integer index;
        if (StringUtils.isBlank((CharSequence)accountDto.getAccount())) {
            result.put("errcode", (Object)ErrorType.FAIL.getCode());
            errorMsgBuilder.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u6761\u8d26\u53f7\u4fe1\u606f\u4e2d\u7535\u5b50\u7a0e\u5c40\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"AllEleAccountSyncServiceImpl_8", (String)"imc-bdm-common", (Object[])new Object[0]), i + 1)).append(";");
        }
        if (null == (index = accountDto.getIndex())) {
            result.put("errcode", (Object)ErrorType.FAIL.getCode());
            errorMsgBuilder.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u6761\u8d26\u53f7\u4fe1\u606f\u4e2d\u5e8f\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"AllEleAccountSyncServiceImpl_20", (String)"imc-bdm-common", (Object[])new Object[0]), i + 1)).append(";");
        }
        if (StringUtils.isBlank((CharSequence)accountDto.getPassword())) {
            result.put("errcode", (Object)ErrorType.FAIL.getCode());
            errorMsgBuilder.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u6761\u8d26\u53f7\u4fe1\u606f\u4e2d\u7535\u5b50\u7a0e\u5c40\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a", (String)"AllEleAccountSyncServiceImpl_9", (String)"imc-bdm-common", (Object[])new Object[0]), i + 1)).append(";");
        }
        if (StringUtils.isBlank((CharSequence)accountDto.getLoginType())) {
            result.put("errcode", (Object)ErrorType.FAIL.getCode());
            errorMsgBuilder.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u6761\u8d26\u53f7\u4fe1\u606f\u4e2d\u767b\u5f55\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (String)"AllEleAccountSyncServiceImpl_10", (String)"imc-bdm-common", (Object[])new Object[0]), i + 1)).append(";");
        }
        if (!loginTypeSet.contains(accountDto.getLoginType())) {
            result.put("errcode", (Object)ErrorType.FAIL.getCode());
            errorMsgBuilder.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u6761\u8d26\u53f7\u4fe1\u606f\u4e2d\u767b\u5f55\u7c7b\u578b\u6709\u8bef", (String)"AllEleAccountSyncServiceImpl_11", (String)"imc-bdm-common", (Object[])new Object[0]), i + 1)).append(";");
        }
        if (StringUtils.isBlank((CharSequence)accountDto.getEtaxRoleType())) {
            result.put("errcode", (Object)ErrorType.FAIL.getCode());
            errorMsgBuilder.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u6761\u8d26\u53f7\u4fe1\u606f\u4e2d\u7535\u5b50\u7a0e\u5c40\u89d2\u8272\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (String)"AllEleAccountSyncServiceImpl_12", (String)"imc-bdm-common", (Object[])new Object[0]), i + 1)).append(";");
        }
        if (StringUtils.isNotBlank((CharSequence)accountDto.getSourceSystem()) && !systemSourceSet.contains(accountDto.getSourceSystem())) {
            result.put("errcode", (Object)ErrorType.FAIL.getCode());
            errorMsgBuilder.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u6761\u8d26\u53f7\u4fe1\u606f\u4e2d\u6765\u6e90\u7cfb\u7edf\u6709\u8bef", (String)"AllEleAccountSyncServiceImpl_13", (String)"imc-bdm-common", (Object[])new Object[0]), i + 1)).append(";");
        }
        if (StringUtils.isBlank((CharSequence)accountDto.getCityName())) {
            result.put("errcode", (Object)ErrorType.FAIL.getCode());
            errorMsgBuilder.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u6761\u8d26\u53f7\u4fe1\u606f\u4e2d\u7a0e\u5c40\u57ce\u5e02\u4e0d\u80fd\u4e3a\u7a7a", (String)"AllEleAccountSyncServiceImpl_14", (String)"imc-bdm-common", (Object[])new Object[0]), i + 1)).append(";");
        }
        if ((provinceSet = ImcConfigUtil.getConfigStringArray("AllEleAccountSync", "provinceName")).size() > 0 && !provinceSet.contains(accountDto.getCityName())) {
            result.put("errcode", (Object)ErrorType.FAIL.getCode());
            errorMsgBuilder.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u6761\u8d26\u53f7\u4fe1\u606f\u4e2d\u7a0e\u5c40\u57ce\u5e02\u6709\u8bef", (String)"AllEleAccountSyncServiceImpl_15", (String)"imc-bdm-common", (Object[])new Object[0]), i + 1)).append(";");
        }
        if (StringUtils.isNotBlank((CharSequence)accountDto.getDefaultAccountType()) && !accountTypeSet.contains(accountDto.getDefaultAccountType())) {
            result.put("errcode", (Object)ErrorType.FAIL.getCode());
            errorMsgBuilder.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u6761\u8d26\u53f7\u4fe1\u606f\u4e2d\u9ed8\u8ba4\u8d26\u53f7\u7c7b\u578b\u6709\u8bef", (String)"AllEleAccountSyncServiceImpl_16", (String)"imc-bdm-common", (Object[])new Object[0]), i + 1)).append(";");
        }
        if (StringUtils.isBlank((CharSequence)accountDto.getEtaxRoleType())) {
            result.put("errcode", (Object)ErrorType.FAIL.getCode());
            errorMsgBuilder.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u6761\u8d26\u53f7\u4fe1\u606f\u4e2d\u7535\u5b50\u7a0e\u5c40\u767b\u5f55\u89d2\u8272\u4e0d\u80fd\u4e3a\u7a7a", (String)"AllEleAccountSyncServiceImpl_17", (String)"imc-bdm-common", (Object[])new Object[0]), i + 1)).append(";");
        }
        if (!loginRoleSet.contains(accountDto.getEtaxRoleType())) {
            result.put("errcode", (Object)ErrorType.FAIL.getCode());
            errorMsgBuilder.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u6761\u8d26\u53f7\u4fe1\u606f\u4e2d\u7535\u5b50\u7a0e\u5c40\u767b\u5f55\u89d2\u8272\u6709\u8bef", (String)"AllEleAccountSyncServiceImpl_18", (String)"imc-bdm-common", (Object[])new Object[0]), i + 1)).append(";");
        }
        if (StringUtils.isBlank((CharSequence)accountDto.getTaxNo())) {
            result.put("errcode", (Object)ErrorType.FAIL.getCode());
            errorMsgBuilder.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u6761\u8d26\u53f7\u4fe1\u606f\u4e2d\u7a0e\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"AllEleAccountSyncServiceImpl_19", (String)"imc-bdm-common", (Object[])new Object[0]), i + 1)).append(";");
        }
        if (!ErrorType.SUCCESS.getCode().equals(result.get((Object)"errcode")) && StringUtils.isNotBlank((Object)result.get((Object)"errcode"))) {
            result.put("description", (Object)errorMsgBuilder.toString());
            return result;
        }
        return null;
    }
}

