/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.TaxRate;
import kd.imc.bdm.common.constant.table.EnterPriseBaseInfoConstant;
import kd.imc.bdm.common.dto.GoodsInfoDTO;
import kd.imc.bdm.common.dto.QueryGoodsInfoProcessDTO;
import kd.imc.bdm.common.helper.ImcBaseDataHelper;
import kd.imc.bdm.common.helper.cache.TaxClassCodeCheckHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.model.MsgRequest;
import kd.imc.bdm.common.message.model.MsgResponse;
import kd.imc.bdm.common.message.send.MessageSendService;
import kd.imc.bdm.common.message.util.IsmcToken;
import kd.imc.bdm.common.model.CompanyInfo;
import kd.imc.bdm.common.model.GoodsInfo;
import kd.imc.bdm.common.model.GoodsInfoResponse;
import kd.imc.bdm.common.model.GoodsInfoRuquest;
import kd.imc.bdm.common.service.AwsFpyService;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.HttpUtil;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.TaxRateUtil;
import kd.imc.bdm.common.util.UUID;
import org.apache.commons.lang3.StringUtils;

public class OpenInvoiceService {
    private static final Log LOGGER = LogFactory.getLog(OpenInvoiceService.class);
    public static final String AWS_ACCESS_TOKEN = "accessToken_aws_";
    public static final String TAXRATE_FIVE_START = "3050100";

    public List<CompanyInfo> queryCompany(String name) {
        ArrayList<CompanyInfo> listCompany = new ArrayList<CompanyInfo>();
        MsgRequest request = new MsgRequest();
        request.setMsgType("ExternalApi");
        request.setMsgId(UUID.next());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("title", name);
        request.setReqData(map);
        MsgResponse msgResponse = MessageSendService.send(request);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("\u62ac\u5934\u67e5\u8be2\u7ed3\u679c\uff1a" + JSONObject.toJSONString((Object)msgResponse));
        }
        if (ErrorType.SUCCESS.getCode().equalsIgnoreCase(msgResponse.getErrorCode())) {
            JSONArray jsonArray = JSONArray.parseArray((String)msgResponse.getRespData());
            for (Object o : jsonArray) {
                JSONObject jsonObject = (JSONObject)o;
                CompanyInfo info = new CompanyInfo();
                String tel = jsonObject.getString("tel");
                String address = jsonObject.getString("address");
                info.setTaxNo(jsonObject.getString("creditCode"));
                info.setName(jsonObject.getString("name"));
                info.setPhone(null == tel ? "" : tel);
                info.setAddress(null == address ? "" : address);
                listCompany.add(info);
            }
        }
        return listCompany;
    }

    public GoodsInfoResponse queryGoodsInfoByFpyAndEpInfoRule(GoodsInfoRuquest inputInfo) {
        if (StringUtils.isNotBlank((CharSequence)inputInfo.getTaxRate())) {
            inputInfo.setTaxRate(TaxRateUtil.convertTaxRate(inputInfo.getTaxRate()));
        }
        LOGGER.info("tempLog00:" + SerializationUtils.toJsonString((Object)inputInfo));
        GoodsInfoResponse response = new GoodsInfoResponse();
        try {
            String errorMsg = this.checkParam(inputInfo);
            if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
                return response.fail(errorMsg);
            }
            ArrayList<GoodsInfo> result = new ArrayList<GoodsInfo>();
            QueryGoodsInfoProcessDTO processDTO = this.generateProcessDTO(inputInfo.getOrgNumber());
            DynamicObject correctObj = this.queryCorrctObj(processDTO, inputInfo);
            if (null != correctObj) {
                this.generateGoodInfoFromCorrectInfo(inputInfo, result, correctObj);
                response.setGoodsFromUserConfig(true);
                return response.success(this.replaceTaxRate(result));
            }
            List<GoodsInfo> smartGoodsInfos = this.queryGoodsInfoByFpyFromCahce(inputInfo.getGoodsName());
            List<GoodsInfo> smartMatchResult = this.replaceTaxRate(smartGoodsInfos);
            String smartGoodsInfoStr = JSONObject.toJSONString(smartMatchResult);
            if (null == processDTO.getOrgId()) {
                return response.success(smartMatchResult, smartGoodsInfoStr);
            }
            this.replaceTaxRateBySmallScale(processDTO, smartMatchResult);
            List<GoodsInfo> matchResult = this.matchGoodsInfo(inputInfo, smartMatchResult, processDTO);
            this.compareReplaceTaxRate(matchResult, processDTO);
            return response.success(this.replaceTaxRate(matchResult), smartGoodsInfoStr, processDTO.isMatchSuccess());
        }
        catch (Exception e) {
            LOGGER.error("queryGoodsInfoByFpyAndEpInfoRuleError:" + e.getMessage(), (Throwable)e);
            return response.fail(e.getMessage());
        }
    }

    private List<GoodsInfo> queryGoodsInfoByFpyFromCahce(String goodsName) {
        String cacheKey = "queryGoodsInfoByFpyCahce" + goodsName;
        String checheValue = CacheHelper.get(cacheKey);
        if (StringUtils.isNotBlank((CharSequence)checheValue)) {
            return JSONObject.parseArray((String)checheValue, GoodsInfo.class);
        }
        List<GoodsInfo> goodsInfos = this.queryGoodsInfoByFpy(goodsName);
        if (goodsInfos.size() > 0) {
            CacheHelper.put(cacheKey, JSONObject.toJSONString(goodsInfos), 60);
        }
        return goodsInfos;
    }

    private List<GoodsInfo> replaceTaxRate(List<GoodsInfo> result) {
        for (GoodsInfo goodsInfo : result) {
            String taxRate = goodsInfo.getTaxRate();
            String convertTaxRate = TaxRateUtil.convertTaxRate(taxRate);
            goodsInfo.setTaxRate(convertTaxRate);
        }
        return result;
    }

    private String checkParam(GoodsInfoRuquest inputInfo) {
        if (StringUtils.isBlank((CharSequence)inputInfo.getGoodsName())) {
            return ResManager.loadKDString((String)"\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (String)"OpenInvoiceService_10", (String)"imc-bdm-common", (Object[])new Object[0]);
        }
        if (StringUtils.isNotBlank((CharSequence)inputInfo.getTaxRate()) && !TaxRate.isStandardTaxRateStr(inputInfo.getTaxRate())) {
            return String.format(ResManager.loadKDString((String)"\u4f20\u5165\u7a0e\u7387\u683c\u5f0f\u6709\u8bef\uff0c\u7a0e\u7387\u683c\u5f0f\u4e3a:%s", (String)"OpenInvoiceService_11", (String)"imc-bdm-common", (Object[])new Object[0]), TaxRate.standardTaxRateDescription());
        }
        return null;
    }

    private void compareReplaceTaxRate(List<GoodsInfo> matchResult, QueryGoodsInfoProcessDTO processDTO) {
        if (!processDTO.isConfigUseSmallScalePolicy()) {
            return;
        }
        BigDecimal rateValue = new BigDecimal(TaxRate.ONE_PERCENT.getRateValue());
        for (GoodsInfo goodsInfo : matchResult) {
            String taxRate = goodsInfo.getTaxRate();
            if (!StringUtils.isNotBlank((CharSequence)taxRate) || new BigDecimal(taxRate).compareTo(rateValue) <= 0) continue;
            goodsInfo.setTaxRate(TaxRate.ONE_PERCENT.getRateValue());
            goodsInfo.setZzstsgl("");
        }
    }

    private List<GoodsInfo> matchGoodsInfo(GoodsInfoRuquest inputInfo, List<GoodsInfo> smartMatchResult, QueryGoodsInfoProcessDTO processDTO) {
        Iterator<GoodsInfo> iterator;
        DynamicObject zzstsglRule = processDTO.getZzstsglRule();
        processDTO.setMatchSuccess(true);
        if (processDTO.isSmallScaleEpInfo() && (iterator = smartMatchResult.iterator()).hasNext()) {
            GoodsInfo smartGoodsInfo = iterator.next();
            DynamicObject policyRule = null;
            boolean isMeetZZSTSGLRuleCondition = false;
            if (null != zzstsglRule) {
                policyRule = this.isSmartGoodsInfoMeetZZSTSGL(smartGoodsInfo, zzstsglRule, null);
            }
            boolean bl = isMeetZZSTSGLRuleCondition = null != policyRule;
            if (isMeetZZSTSGLRuleCondition) {
                String zzstsgl = StringUtils.isBlank((CharSequence)policyRule.getString("policycontants")) ? "" : policyRule.getString("policycontants");
                return this.generateGoodsInfoList(smartGoodsInfo, policyRule.getString("taxrate"), zzstsgl, inputInfo);
            }
            return this.generateGoodsInfoList(smartGoodsInfo, smartGoodsInfo.getTaxRate(), "", inputInfo);
        }
        if (StringUtils.isNotBlank((CharSequence)inputInfo.getTaxRate())) {
            for (GoodsInfo smartGoodsInfo : smartMatchResult) {
                boolean isInputTaxRateMeet;
                DynamicObject policyRule = null;
                boolean isMeetZZSTSGLRuleCondition = false;
                if (this.isTaxRateEquals(smartGoodsInfo.getTaxRate(), inputInfo.getTaxRate())) {
                    if (null != zzstsglRule) {
                        policyRule = this.isSmartGoodsInfoMeetZZSTSGL(smartGoodsInfo, zzstsglRule, inputInfo.getTaxRate());
                        boolean bl = isMeetZZSTSGLRuleCondition = null != policyRule;
                    }
                    if (isMeetZZSTSGLRuleCondition) {
                        isInputTaxRateMeet = Objects.equals(inputInfo.getTaxRate(), policyRule.getString("taxrate"));
                        if (isInputTaxRateMeet) {
                            return this.generateGoodsInfoList(smartGoodsInfo, inputInfo.getTaxRate(), this.getRuleItemZZSTSGL(smartGoodsInfo, policyRule), inputInfo);
                        }
                        return this.generateGoodsInfoList(smartGoodsInfo, inputInfo.getTaxRate(), "", inputInfo);
                    }
                    return this.generateGoodsInfoList(smartGoodsInfo, inputInfo.getTaxRate(), "", inputInfo);
                }
                if (null != zzstsglRule) {
                    policyRule = this.isSmartGoodsInfoMeetZZSTSGL(smartGoodsInfo, zzstsglRule, inputInfo.getTaxRate());
                    boolean bl = isMeetZZSTSGLRuleCondition = null != policyRule;
                }
                if (!isMeetZZSTSGLRuleCondition || !(isInputTaxRateMeet = Objects.equals(inputInfo.getTaxRate(), policyRule.getString("taxrate")))) continue;
                return this.generateGoodsInfoList(smartGoodsInfo, inputInfo.getTaxRate(), this.getRuleItemZZSTSGL(smartGoodsInfo, policyRule), inputInfo);
            }
        } else {
            boolean isMeetZZSTSGLRuleCondition = false;
            DynamicObject policyRule = null;
            if (null != zzstsglRule) {
                policyRule = this.isSmartGoodsInfoMeetZZSTSGL(smartMatchResult.get(0), zzstsglRule, null);
                boolean bl = isMeetZZSTSGLRuleCondition = null != policyRule;
            }
            if (isMeetZZSTSGLRuleCondition) {
                String taxRate = policyRule.getString("taxrate");
                return this.generateGoodsInfoList(smartMatchResult.get(0), taxRate, this.getRuleItemZZSTSGL(smartMatchResult.get(0), policyRule), inputInfo);
            }
            return this.generateGoodsInfoList(smartMatchResult.get(0), smartMatchResult.get(0).getTaxRate(), "", inputInfo);
        }
        processDTO.setMatchSuccess(false);
        return smartMatchResult;
    }

    private QueryGoodsInfoProcessDTO generateProcessDTO(String orgNumber) {
        QueryGoodsInfoProcessDTO process = new QueryGoodsInfoProcessDTO();
        if (StringUtils.isBlank((CharSequence)orgNumber)) {
            return process;
        }
        DynamicObject[] orgs = BusinessDataServiceHelper.load((String)"bdm_org", (String)"id,epinfo", (QFilter[])new QFilter("number", "=", (Object)orgNumber).toArray());
        if (orgs.length == 0) {
            return process;
        }
        process.setOrgId(orgs[0].getLong("id"));
        DynamicObject epInfo = orgs[0].getDynamicObject("epinfo");
        if (null != epInfo) {
            long epInfoPk = DynamicObjectUtil.getDynamicObjectLongValue(orgs[0].get("epinfo"));
            QFilter filter = new QFilter("epinfo", "=", (Object)epInfoPk).and("enable", "=", (Object)true);
            DynamicObject[] array = BusinessDataServiceHelper.load((String)"bdm_issue_rule", (String)PropertieUtil.getAllPropertiesSplitByComma("bdm_issue_rule", true), (QFilter[])filter.toArray());
            if (array.length > 0) {
                process.setSmallScaleEpInfo("2".equals(array[0].getString("companyproperty")));
                process.setZzstsglRule(array[0]);
                DynamicObjectCollection items = array[0].getDynamicObjectCollection("items");
                for (DynamicObject item : items) {
                    if (!"1".equals(item.getString("policytype")) || !"0".equals(item.getString("policyrule"))) continue;
                    process.setConfigUseSmallScalePolicy(true);
                }
            } else {
                DynamicObject[] epInfos = BusinessDataServiceHelper.load((String)"bdm_enterprise_baseinfo", (String)"company_property", (QFilter[])new QFilter("id", "=", (Object)epInfoPk).toArray());
                process.setSmallScaleEpInfo(false);
                if (epInfos.length > 0) {
                    boolean isSmallScale = String.valueOf(EnterPriseBaseInfoConstant.CompanyProperty.SMALL_SCALE_TAXATION.getPropertyCode()).equals(epInfos[0].getString("company_property"));
                    process.setSmallScaleEpInfo(isSmallScale);
                }
            }
        }
        return process;
    }

    private String getMeetZZSTSGLTaxRate(GoodsInfo smartGoodsInfo, DynamicObject zzstsglRule) {
        DynamicObjectCollection conditions = zzstsglRule.getDynamicObjectCollection("items");
        for (DynamicObject condition : conditions) {
            String conditionZZSTSGL = condition.getString("policycontants");
            if (StringUtils.isNotBlank((CharSequence)conditionZZSTSGL) && Objects.equals(conditionZZSTSGL, smartGoodsInfo.getZzstsgl())) {
                return condition.getString("taxrate");
            }
            if (!"2".equals(zzstsglRule.getString("companyproperty")) || !TaxRate.ONE_PERCENT.getRateValue().equals(smartGoodsInfo.getTaxRate())) continue;
            return condition.getString("taxrate");
        }
        return "";
    }

    private void replaceTaxRateBySmallScale(QueryGoodsInfoProcessDTO processDTO, List<GoodsInfo> smartMatchResult) {
        if (processDTO.isSmallScaleEpInfo()) {
            for (GoodsInfo goodsInfo : smartMatchResult) {
                if (String.valueOf(goodsInfo.getGoodsCode()).startsWith(TAXRATE_FIVE_START)) {
                    goodsInfo.setTaxRate(TaxRate.FIVE_PERCENT.getRateValue());
                    continue;
                }
                goodsInfo.setTaxRate(TaxRate.THREE_PERCENT.getRateValue());
            }
        }
    }

    private boolean isInputTaxRateMeetRuleTaxRate(String taxRate, DynamicObject zzstsglRule) {
        DynamicObjectCollection conditions = zzstsglRule.getDynamicObjectCollection("items");
        for (DynamicObject condition : conditions) {
            if (!Objects.equals(condition.getString("taxrate"), taxRate)) continue;
            return true;
        }
        return false;
    }

    private List<GoodsInfo> generateGoodsInfoList(GoodsInfo smartGoodsInfo, String taxRate, String zzstsgl, GoodsInfoRuquest inputInfo) {
        GoodsInfo goodsInfo = new GoodsInfo();
        goodsInfo.setTaxRate(taxRate);
        goodsInfo.setZzstsgl(zzstsgl);
        goodsInfo.setGoodsName(inputInfo.getGoodsName());
        goodsInfo.setGoodsCode(smartGoodsInfo.getGoodsCode());
        goodsInfo.setShortName(smartGoodsInfo.getShortName());
        ArrayList<GoodsInfo> goodsInfos = new ArrayList<GoodsInfo>();
        goodsInfos.add(goodsInfo);
        return goodsInfos;
    }

    private DynamicObject isSmartGoodsInfoMeetZZSTSGL(GoodsInfo smartGoodsInfo, DynamicObject zzstsglRule, String inputTaxRate) {
        DynamicObjectCollection conditions = zzstsglRule.getDynamicObjectCollection("items");
        ArrayList<DynamicObject> allMatchedConditions = new ArrayList<DynamicObject>();
        for (DynamicObject condition : conditions) {
            String smartZzstsgls = smartGoodsInfo.getZzstsgl();
            String conditionZZSTSGL = condition.getString("policycontants");
            String taxRate = condition.getString("taxrate");
            if (null != inputTaxRate && !Objects.equals(taxRate, inputTaxRate)) continue;
            if (StringUtils.isNotBlank((CharSequence)smartZzstsgls)) {
                String[] zzstsglArray;
                for (String s : zzstsglArray = smartZzstsgls.split("\u3001")) {
                    if (!StringUtils.isNotBlank((CharSequence)conditionZZSTSGL) || !Objects.equals(conditionZZSTSGL, s)) continue;
                    allMatchedConditions.add(condition);
                }
            }
            if (!StringUtils.isBlank((CharSequence)conditionZZSTSGL) || !StringUtils.isBlank((CharSequence)smartGoodsInfo.getZzstsgl()) || !"2".equals(zzstsglRule.getString("companyproperty")) || !TaxRate.ONE_PERCENT.getRateValue().equals(smartGoodsInfo.getTaxRate())) continue;
            allMatchedConditions.add(condition);
        }
        if (allMatchedConditions.size() > 0) {
            String smallTaxRate = null;
            DynamicObject smallCondition = null;
            for (DynamicObject condition : allMatchedConditions) {
                if (null == smallTaxRate) {
                    smallTaxRate = condition.getString("taxrate");
                    smallCondition = condition;
                }
                if (new BigDecimal(smallTaxRate).compareTo(new BigDecimal(condition.getString("taxrate"))) <= 0) continue;
                smallTaxRate = condition.getString("taxrate");
                smallCondition = condition;
            }
            return smallCondition;
        }
        return null;
    }

    private String getRuleItemZZSTSGL(GoodsInfo smartGoodsInfo, DynamicObject condition) {
        String smartZzstsgls = smartGoodsInfo.getZzstsgl();
        String conditionZZSTSGL = condition.getString("policycontants");
        if (StringUtils.isNotBlank((CharSequence)smartZzstsgls)) {
            String[] zzstsglArray;
            for (String s : zzstsglArray = smartZzstsgls.split("\u3001")) {
                if (!StringUtils.isNotBlank((CharSequence)conditionZZSTSGL) || !Objects.equals(conditionZZSTSGL, s)) continue;
                return s;
            }
        }
        return "";
    }

    private DynamicObject queryEpInfoZzstsglRule(String orgNumber) {
        DynamicObject[] orgs = BusinessDataServiceHelper.load((String)"bdm_org", (String)"id,epinfo", (QFilter[])new QFilter("number", "=", (Object)orgNumber).toArray());
        if (orgs.length == 0) {
            return null;
        }
        long epInfoPk = DynamicObjectUtil.getDynamicObjectLongValue(orgs[0].get("epinfo"));
        if (0L == epInfoPk) {
            return null;
        }
        QFilter filter = new QFilter("epinfo", "=", (Object)epInfoPk);
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bdm_issue_rule", (String)PropertieUtil.getAllPropertiesSplitByComma("bdm_issue_rule", true), (QFilter[])filter.toArray());
    }

    private boolean isTaxRateEquals(String taxRate, String anotherTaxRate) {
        if (StringUtils.isNotBlank((CharSequence)taxRate) && StringUtils.isNotBlank((CharSequence)anotherTaxRate)) {
            try {
                return new BigDecimal(taxRate).compareTo(new BigDecimal(anotherTaxRate)) == 0;
            }
            catch (Exception e) {
                LOGGER.error("isTaxRateEqualsError:" + e.getMessage(), (Throwable)e);
            }
        }
        return false;
    }

    private void generateGoodInfoFromCorrectInfo(GoodsInfoRuquest inputInfo, List<GoodsInfo> result, DynamicObject correctObj) {
        GoodsInfo matchGoodsInfo = new GoodsInfo();
        matchGoodsInfo.setGoodsName(inputInfo.getGoodsName());
        matchGoodsInfo.setGoodsCode(correctObj.getDynamicObject("taxclasscode").getString("mergecode"));
        matchGoodsInfo.setTaxRate(correctObj.getString("taxrate"));
        matchGoodsInfo.setZzstsgl(correctObj.getString("zzstsgl"));
        result.add(matchGoodsInfo);
    }

    private DynamicObject queryCorrctObj(QueryGoodsInfoProcessDTO processDTO, GoodsInfoRuquest inputInfo) {
        DynamicObject[] goodsInfos;
        if (null == processDTO.getOrgId()) {
            return null;
        }
        String spbm = inputInfo.getSpbm();
        String goodsName = inputInfo.getGoodsName();
        String fields = "name,goodscode,taxclasscode,taxrate,taxpremark,zzstsgl,isallepinfo,items.epinfo";
        QFilter filter = ImcBaseDataHelper.getManualGoodsFilter(processDTO.getOrgId());
        filter = StringUtils.isNotBlank((CharSequence)spbm) ? filter.and("goodscode", "=", (Object)spbm).and("name", "=", (Object)goodsName) : filter.and("name", "=", (Object)goodsName);
        if (StringUtils.isNotBlank((CharSequence)inputInfo.getTaxRate())) {
            filter = filter.and("taxrate", "=", (Object)inputInfo.getTaxRate());
        }
        if ((goodsInfos = BusinessDataServiceHelper.load((String)"bdm_manual_set_goods", (String)fields, (QFilter[])filter.toArray())).length == 0) {
            return null;
        }
        return goodsInfos[0];
    }

    public List<GoodsInfo> queryGoodsInfoByFpy(String goodsName) {
        String response;
        if ("1".equals(ImcConfigUtil.getValue("mockQueryGoodsInfo", "mockQueryGoodsInfo"))) {
            ArrayList<GoodsInfo> goodsInfos = new ArrayList<GoodsInfo>();
            GoodsInfo matchedGoodsInfo1 = new GoodsInfo();
            matchedGoodsInfo1.setGoodsCode("1010101030000000000");
            matchedGoodsInfo1.setGoodsName(goodsName);
            matchedGoodsInfo1.setShortName("cococola");
            matchedGoodsInfo1.setVersionNum("38");
            matchedGoodsInfo1.setZzstsgl("\u514d\u7a0e");
            matchedGoodsInfo1.setGoodsDesc("cococola");
            matchedGoodsInfo1.setTaxRate("0%");
            goodsInfos.add(matchedGoodsInfo1);
            GoodsInfo matchedGoodsInfo2 = new GoodsInfo();
            matchedGoodsInfo2.setGoodsCode("1010104020000000000");
            matchedGoodsInfo2.setGoodsName(goodsName);
            matchedGoodsInfo2.setShortName("cococola");
            matchedGoodsInfo2.setVersionNum("38");
            matchedGoodsInfo2.setZzstsgl("");
            matchedGoodsInfo2.setGoodsDesc("cococola");
            matchedGoodsInfo2.setTaxRate("9%");
            goodsInfos.add(matchedGoodsInfo2);
            return goodsInfos;
        }
        ArrayList<GoodsInfo> list = new ArrayList<GoodsInfo>(8);
        if (StringUtils.isEmpty((CharSequence)goodsName)) {
            return list;
        }
        String accessToken = OpenInvoiceService.getAccessToken();
        if (StringUtils.isEmpty((CharSequence)accessToken)) {
            return list;
        }
        StringBuilder urlBuilder = new StringBuilder(AwsFpyService.newInstance().getBaseUrl());
        urlBuilder.append("/ai/knowledge/match/goodName");
        urlBuilder.append('?').append("access_token=").append(accessToken);
        JSONObject requestJson = new JSONObject();
        requestJson.put("name", (Object)goodsName);
        HashMap<String, String> headers = new HashMap<String, String>(1);
        headers.put("client-platform", "common");
        LOGGER.info("\u667a\u80fd\u8d4b\u7801\u8bf7\u6c42\u7684\u53c2\u6570\u4e3a\uff1a{}", (Object)requestJson.toJSONString());
        try {
            response = HttpUtil.doPostJson(urlBuilder.toString(), headers, requestJson.toJSONString(), 5000, 5000);
        }
        catch (Exception e) {
            LOGGER.error("\u8bf7\u6c42\u667a\u80fd\u8d4b\u7801\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u8bc6\u522b\u63a5\u53e3\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5...", (Throwable)e);
            return list;
        }
        if (StringUtils.isEmpty((CharSequence)response)) {
            LOGGER.error("\u8bf7\u6c42\u667a\u80fd\u8d4b\u7801\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u8bc6\u522b\u63a5\u53e3\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5...response\u8fd4\u56de\u4e3a\u7a7a");
            return list;
        }
        LOGGER.info("url\u4e3a\uff1a{}, \u8fd4\u56de\u7684response\u4fe1\u606f\u4e3a\uff1a{}", (Object)urlBuilder.toString(), (Object)response);
        JSONObject resultJson = JSONObject.parseObject((String)response);
        if (!ErrorType.SUCCESS.getCode().equals(resultJson.getString("errcode"))) {
            LOGGER.error("\u8bf7\u6c42\u667a\u80fd\u8d4b\u7801\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u8bc6\u522b\u63a5\u53e3\u9519\u8bef\uff0c\u8fd4\u56de\u5f02\u5e38\u9519\u8bef\u7801\uff1a{}", (Object)response);
            OpenInvoiceService.clearCache(resultJson);
            return list;
        }
        if (!response.contains("data")) {
            return list;
        }
        List dataList = JSONArray.parseArray((String)resultJson.getString("data"), GoodsInfoDTO.class);
        if (dataList == null || dataList.isEmpty()) {
            return list;
        }
        dataList.forEach(entity -> {
            GoodsInfo info = new GoodsInfo();
            info.setGoodsCode(entity.getGoodsCode());
            info.setGoodsName(entity.getGoodsName());
            info.setShortName(entity.getGoodsSimpleName());
            info.setGoodsDesc("");
            info.setGoodsKey(entity.getGoodsSimpleCode());
            info.setAvailableState(entity.getAvailableState());
            info.setZzstsgl(entity.getVatException());
            info.setVersionNum("");
            info.setTaxRate(entity.getTaxRate());
            list.add(info);
        });
        LOGGER.info("\u667a\u80fd\u8d4b\u7801\u683c\u5f0f\u5316\u7684\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString(list));
        return list;
    }

    private static void clearCache(JSONObject jsonObject) {
        String errCode = jsonObject.getString("errcode");
        String description = jsonObject.getString("description");
        if ("1999".equals(errCode) && ResManager.loadKDString((String)"token\u5df2\u7ecf\u5931\u6548", (String)"OpenInvoiceService_7", (String)"imc-bdm-common", (Object[])new Object[0]).equals(description)) {
            CacheHelper.remove(AWS_ACCESS_TOKEN);
        }
    }

    public static String getAccessToken() {
        String accessTokenCache = CacheHelper.get(AWS_ACCESS_TOKEN);
        if (StringUtils.isNotBlank((CharSequence)accessTokenCache)) {
            return accessTokenCache;
        }
        Map<String, String> map = ImcConfigUtil.getValue("dim_imc_config_fpy");
        String clientId = ImcConfigUtil.getValue(map, "clientid", "dim_imc_config_fpy_clientid");
        String clientsecret = ImcConfigUtil.getValue(map, "clientsecret", "dim_imc_config_fpy_clientsecret");
        AwsFpyService awsFpyService = AwsFpyService.newInstance();
        String accessToken = null;
        try {
            accessToken = awsFpyService.getAccessToken(clientId, clientsecret);
            CacheHelper.put(AWS_ACCESS_TOKEN, accessToken, 86400);
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6aws\u7684token\u5931\u8d25\u4e86...", (Throwable)e);
        }
        return accessToken;
    }

    public static BigDecimal stringToTaxRate(String taxRate) {
        if (StringUtils.isEmpty((CharSequence)taxRate)) {
            return null;
        }
        if (taxRate.indexOf(37) > 0) {
            return new BigDecimal(taxRate.replace("%", "")).divide(new BigDecimal(100), 2, 4);
        }
        return new BigDecimal(taxRate);
    }

    public static Map<String, String> getConfig() {
        String str = CacheHelper.get("dim_sync_config");
        if (StringUtils.isEmpty((CharSequence)str)) {
            MsgRequest msgRequest = new MsgRequest();
            msgRequest.setMsgId(UUID.randomUUID());
            msgRequest.setMsgType("ImcGetParam");
            msgRequest.setReqData((Object)"request");
            MsgResponse response = MessageSendService.send(msgRequest);
            if ("0000".equals(response.getErrorCode())) {
                String respData = response.getRespData();
                CacheHelper.put("dim_sync_config", respData, 14400);
                return (Map)SerializationUtils.fromJsonString((String)respData, Map.class);
            }
            throw new KDBizException(response.getErrorMsg());
        }
        return (Map)SerializationUtils.fromJsonString((String)str, Map.class);
    }

    public List<GoodsInfo> queryGoodsInfoByName(String s, IsmcToken ismcToken, String ismcUrl) {
        return null;
    }

    public List<GoodsInfo> queryTaxRate(GoodsInfoRuquest inputInfo) {
        String taxClassCode = inputInfo.getTaxClassCode();
        ArrayList<GoodsInfo> goodsInfos = new ArrayList<GoodsInfo>();
        DynamicObject taxCode = TaxClassCodeCheckHelper.geTaxCode(taxClassCode);
        if (null == taxCode) {
            return goodsInfos;
        }
        QueryGoodsInfoProcessDTO processDTO = this.generateProcessDTO(inputInfo.getOrgNumber());
        BigDecimal taxRate = taxCode.getBigDecimal("taxrate");
        String zzstsgls = taxCode.getString("vatspecialmanagement");
        String[] zzstsglArray = null;
        if (StringUtils.isNotBlank((CharSequence)zzstsgls)) {
            zzstsglArray = zzstsgls.split("\u3001");
        }
        String standardTaxRate = TaxRate.getRateStr(taxRate);
        if (processDTO.isSmallScaleEpInfo()) {
            standardTaxRate = taxClassCode.startsWith(TAXRATE_FIVE_START) ? TaxRate.FIVE_PERCENT.getRateValue() : TaxRate.THREE_PERCENT.getRateValue();
        }
        GoodsInfo standardGoodsInfo = new GoodsInfo(standardTaxRate, "");
        if (processDTO.getZzstsglRule() != null) {
            DynamicObject rule = processDTO.getZzstsglRule();
            List<DynamicObject> ruleItems = this.matchZzstsglRule(zzstsglArray, rule);
            for (DynamicObject ruleItem : ruleItems) {
                String zzstsgl = StringUtils.isBlank((CharSequence)ruleItem.getString("policycontants")) ? "" : ruleItem.getString("policycontants");
                String ruleTaxRate = ruleItem.getString("taxrate");
                goodsInfos.add(new GoodsInfo(ruleTaxRate, zzstsgl));
            }
        }
        if (goodsInfos.size() > 0) {
            return this.filterSmallTaxRate(goodsInfos);
        }
        goodsInfos.add(standardGoodsInfo);
        return goodsInfos;
    }

    private List<GoodsInfo> filterSmallTaxRate(List<GoodsInfo> goodsInfos) {
        ArrayList<GoodsInfo> result = new ArrayList<GoodsInfo>();
        BigDecimal smallestTaxRate = null;
        for (GoodsInfo goodsInfo : goodsInfos) {
            String taxRate = goodsInfo.getTaxRate();
            BigDecimal taxRateValue = new BigDecimal(taxRate);
            if (null == smallestTaxRate) {
                smallestTaxRate = new BigDecimal(goodsInfo.getTaxRate());
                result.add(goodsInfo);
                continue;
            }
            if (smallestTaxRate.compareTo(taxRateValue) == 0) {
                result.add(goodsInfo);
                continue;
            }
            if (smallestTaxRate.compareTo(taxRateValue) <= 0) continue;
            result.clear();
            result.add(goodsInfo);
        }
        return result;
    }

    private List<DynamicObject> matchZzstsglRule(String[] zzstsglArray, DynamicObject rule) {
        DynamicObjectCollection conditions = rule.getDynamicObjectCollection("items");
        ArrayList<DynamicObject> matchedRuleItems = new ArrayList<DynamicObject>();
        if (zzstsglArray == null) {
            for (DynamicObject condition : conditions) {
                String policyType = condition.getString("policytype");
                if (!"1".equals(policyType)) continue;
                matchedRuleItems.add(condition);
                return matchedRuleItems;
            }
            return matchedRuleItems;
        }
        for (DynamicObject condition : conditions) {
            String zzstsgl = condition.getString("policycontants");
            for (String s : zzstsglArray) {
                if (!Objects.equals(zzstsgl, s)) continue;
                matchedRuleItems.add(condition);
            }
            if (!"1".equals(condition.getString("policytype"))) continue;
            matchedRuleItems.add(condition);
        }
        return matchedRuleItems;
    }
}

