/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.util;

import java.io.IOException;
import java.io.Reader;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.sdk.annotation.SdkDeprecated;
import oracle.sql.CLOB;

public class DBUtils {
    private static final String DBKEY = "imc";

    public static List<Map<String, Object>> query(String sql) {
        return DBUtils.query(DBKEY, sql);
    }

    public static List<Map<String, Object>> query(String dbKey, String sql, Object[] params) {
        return (List)DB.query((DBRoute)DBRoute.of((String)dbKey), (String)sql, (Object[])params, rs -> {
            ArrayList list1 = new ArrayList(8);
            ResultSetMetaData rsmd = rs.getMetaData();
            int columnCount = rsmd.getColumnCount();
            while (rs.next()) {
                HashMap<String, Object> hm = new HashMap<String, Object>(8);
                for (int i = 0; i < columnCount; ++i) {
                    String columnName = rsmd.getColumnName(i + 1);
                    Object columnValue = rs.getObject(columnName);
                    if (columnValue instanceof CLOB) {
                        hm.put(columnName.toUpperCase(), DBUtils.readOracleClob((CLOB)columnValue));
                        continue;
                    }
                    hm.put(columnName.toUpperCase(), columnValue);
                }
                list1.add(hm);
            }
            return list1;
        });
    }

    public static List<Map<String, Object>> query(String dbKey, String sql) {
        return DBUtils.query(dbKey, sql, null);
    }

    private static String readOracleClob(CLOB clob) throws SQLException {
        int len;
        Reader reader = clob.getCharacterStream();
        StringBuilder buff = new StringBuilder();
        int blockSize = 1024;
        char[] block = new char[blockSize];
        do {
            try {
                len = reader.read(block);
                if (len <= 0) continue;
                buff.append(block, 0, len);
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
        } while (len == blockSize);
        return buff.toString();
    }

    public static boolean execute(String sql) {
        return DB.execute((DBRoute)DBRoute.of((String)DBKEY), (String)sql);
    }

    @SdkDeprecated
    public static String getQueryFields(String ... args) {
        StringBuilder queryFields = new StringBuilder();
        for (String arg : args) {
            queryFields.append(arg);
            queryFields.append(',');
        }
        return queryFields.subSequence(0, queryFields.length() - 1).toString();
    }
}

