/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.util;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.constant.InvoiceTypeNewEnum;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.helper.BillArchiveHelper;
import kd.imc.bdm.common.helper.bill.BillHelper;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.openapi.FindOrderOpenVo;
import kd.imc.bdm.common.openapi.InvoiceDetailVo;
import kd.imc.bdm.common.openapi.OrderDetailVo;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import org.apache.commons.lang3.ObjectUtils;

public class InvoiceQueryUtil {
    private static final Log LOGGER = LogFactory.getLog(InvoiceQueryUtil.class);
    private static final String originalBillField = String.join((CharSequence)",", "id", "billno", "splitormergeflag", "maintaxdeviation");

    public static Map<String, List<OrderDetailVo>> queryInvoiceDataByBillNosForApi(String batchNo, String billno) {
        QFilter qFilter = new QFilter("batchbelong", "=", (Object)batchNo);
        if (!QueryServiceHelper.exists((String)"sim_original_bill", (QFilter[])new QFilter[]{qFilter})) {
            throw new MsgException(ApiErrCodeEnum.BATCH_NO_NOT_EXIST.getCode(), ResManager.loadKDString((String)"\u5355\u636e\u6279\u6b21\u53f7\u4e0d\u5b58\u5728", (String)"InvoiceQueryUtil_1", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        if (StringUtils.isNotBlank((CharSequence)billno)) {
            QFilter billNoQFilter = new QFilter("billno", "=", (Object)billno);
            if (!QueryServiceHelper.exists((String)"sim_original_bill", (QFilter[])new QFilter[]{billNoQFilter})) {
                throw new MsgException(ApiErrCodeEnum.NILL_NO_NOT_EXIST.getCode(), ResManager.loadKDString((String)"\u5f00\u7968\u7533\u8bf7\u5355\u53f7\u4e0d\u5b58\u5728", (String)"InvoiceQueryUtil_2", (String)"imc-bdm-common", (Object[])new Object[0]));
            }
            qFilter = qFilter.and(billNoQFilter);
        }
        DynamicObject[] billArr = BusinessDataServiceHelper.load((String)"sim_original_bill", (String)originalBillField, (QFilter[])qFilter.toArray());
        Map<Long, DynamicObject> originalBillMap = Stream.of(billArr).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        Map<String, DynamicObject> originalBillNoMap = Stream.of(billArr).collect(Collectors.toMap(k -> k.getString("billno"), v -> v));
        DynamicObject[] relations = InvoiceQueryUtil.getRelations(billArr);
        Map invIdToBillIdMap = Stream.of(relations).collect(Collectors.groupingBy(k -> k.getLong("tbillid"), TreeMap::new, Collectors.mapping(v -> v.getLong("sbillid"), Collectors.toSet())));
        Map billIdToInvIdMap = Stream.of(relations).collect(Collectors.groupingBy(k -> k.getLong("sbillid"), TreeMap::new, Collectors.mapping(v -> v.getLong("tbillid"), Collectors.toSet())));
        HashSet<String> inputOriginalBillNoSet = new HashSet<String>(originalBillMap.size());
        inputOriginalBillNoSet.addAll(originalBillNoMap.keySet());
        List<OrderDetailVo> voList = InvoiceQueryUtil.getAllInvoiceByBillNos(inputOriginalBillNoSet, invIdToBillIdMap, originalBillMap, billIdToInvIdMap, relations);
        Map<String, List<OrderDetailVo>> billNoOrderList = voList.stream().collect(Collectors.groupingBy(OrderDetailVo::getBillNo));
        Set<Map.Entry<String, List<OrderDetailVo>>> billEntries = billNoOrderList.entrySet();
        for (Map.Entry<String, List<OrderDetailVo>> billEntry : billEntries) {
            String billNo = billEntry.getKey();
            if (!inputOriginalBillNoSet.contains(billNo)) {
                billNoOrderList.put(billNo, null);
                continue;
            }
            BigDecimal originalTaxDiff = originalBillNoMap.get(billNo).getBigDecimal("maintaxdeviation");
            List<OrderDetailVo> orderDetailList = billEntry.getValue();
            int orderDetailSize = orderDetailList.size();
            BigDecimal diff = originalTaxDiff.divide(new BigDecimal(orderDetailSize), 2, 1);
            for (int i = 0; i < orderDetailList.size(); ++i) {
                OrderDetailVo detail = orderDetailList.get(i);
                detail.setInvoiceType(InvoiceTypeNewEnum.getInvoiceTypeNewCode(detail.getInvoiceType()));
                if (i != orderDetailSize - 1) {
                    detail.setMergeDifferTaxAmount(diff);
                    originalTaxDiff = originalTaxDiff.subtract(diff);
                } else {
                    detail.setMergeDifferTaxAmount(originalTaxDiff);
                }
                List<InvoiceDetailVo> goods = detail.getGoods();
                boolean startZero = goods.stream().anyMatch(good -> good.getSeq() == 0);
                int inx = 1;
                for (InvoiceDetailVo good2 : goods) {
                    if (!startZero) {
                        good2.setSeq(good2.getSeq() - 1);
                    }
                    good2.setTaxFlag(detail.getTaxFlag());
                    good2.setPrice(InvoiceQueryUtil.stripTrailingZeros(good2.getPrice()));
                    good2.setIncludeTaxPrice(InvoiceQueryUtil.stripTrailingZeros(good2.getIncludeTaxPrice()));
                    good2.setQuantity(InvoiceQueryUtil.stripTrailingZeros(good2.getQuantity()));
                    good2.setDetailRowNo(inx++);
                }
            }
        }
        HashMap<String, List<OrderDetailVo>> originalBillInvoiceMap = new HashMap<String, List<OrderDetailVo>>(originalBillNoMap.size());
        InvoiceQueryUtil.dealOtherIssueInvoiceMethod(originalBillInvoiceMap, billNoOrderList, originalBillNoMap);
        return originalBillInvoiceMap;
    }

    private static void dealOtherIssueInvoiceMethod(Map<String, List<OrderDetailVo>> originalBillInvoiceMap, Map<String, List<OrderDetailVo>> billNoOrderListMap, Map<String, DynamicObject> originalBillNoMap) {
        for (Map.Entry<String, DynamicObject> entryObject : originalBillNoMap.entrySet()) {
            String billNo = entryObject.getKey();
            if (billNoOrderListMap.containsKey(billNo)) {
                originalBillInvoiceMap.put(billNo, billNoOrderListMap.get(billNo));
                continue;
            }
            originalBillInvoiceMap.put(billNo, new ArrayList(16));
        }
    }

    public static Map<String, List<OrderDetailVo>> queryInvoiceDataByBillNosForApi(FindOrderOpenVo vo) {
        HashSet inputOriginalBillNoSet = Sets.newHashSet((Object[])vo.getSerialNo().split(","));
        DynamicObject[] billArr = InvoiceQueryUtil.queryOriginalBill(vo);
        Map<Long, DynamicObject> originalBillMap = Stream.of(billArr).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        Map<String, DynamicObject> originalBillNoMap = Stream.of(billArr).collect(Collectors.toMap(k -> k.getString("billno"), v -> v));
        DynamicObject[] relations = InvoiceQueryUtil.getRelations(billArr);
        Map invIdToBillIdMap = Stream.of(relations).collect(Collectors.groupingBy(k -> k.getLong("tbillid"), TreeMap::new, Collectors.mapping(v -> v.getLong("sbillid"), Collectors.toSet())));
        Map billIdToInvIdMap = Stream.of(relations).collect(Collectors.groupingBy(k -> k.getLong("sbillid"), TreeMap::new, Collectors.mapping(v -> v.getLong("tbillid"), Collectors.toSet())));
        List<OrderDetailVo> voList = InvoiceQueryUtil.getAllInvoiceByBillNos(inputOriginalBillNoSet, invIdToBillIdMap, originalBillMap, billIdToInvIdMap, relations);
        Map<String, List<OrderDetailVo>> billNoOrderList = voList.stream().collect(Collectors.groupingBy(OrderDetailVo::getBillNo));
        Set<Map.Entry<String, List<OrderDetailVo>>> billEntries = billNoOrderList.entrySet();
        for (Map.Entry<String, List<OrderDetailVo>> billEntry : billEntries) {
            String billNo = billEntry.getKey();
            if (!inputOriginalBillNoSet.contains(billNo)) {
                billNoOrderList.put(billNo, null);
                continue;
            }
            BigDecimal originalTaxDiff = originalBillNoMap.get(billNo).getBigDecimal("maintaxdeviation");
            List<OrderDetailVo> orderDetailList = billEntry.getValue();
            int orderDetailSize = orderDetailList.size();
            BigDecimal diff = originalTaxDiff.divide(new BigDecimal(orderDetailSize), 2, 1);
            for (int i = 0; i < orderDetailList.size(); ++i) {
                OrderDetailVo detail = orderDetailList.get(i);
                if (i != orderDetailSize - 1) {
                    detail.setMergeDifferTaxAmount(diff);
                    originalTaxDiff = originalTaxDiff.subtract(diff);
                } else {
                    detail.setMergeDifferTaxAmount(originalTaxDiff);
                }
                List<InvoiceDetailVo> goods = detail.getGoods();
                boolean startZero = goods.stream().anyMatch(good -> good.getSeq() == 0);
                int inx = 1;
                for (InvoiceDetailVo good2 : goods) {
                    if (!startZero) {
                        good2.setSeq(good2.getSeq() - 1);
                    }
                    good2.setTaxFlag(detail.getTaxFlag());
                    good2.setPrice(InvoiceQueryUtil.stripTrailingZeros(good2.getPrice()));
                    good2.setIncludeTaxPrice(InvoiceQueryUtil.stripTrailingZeros(good2.getIncludeTaxPrice()));
                    good2.setQuantity(InvoiceQueryUtil.stripTrailingZeros(good2.getQuantity()));
                    good2.setDetailRowNo(inx++);
                }
            }
        }
        return billNoOrderList;
    }

    private static DynamicObject[] queryOriginalBill(FindOrderOpenVo vo) {
        String tEntityKey;
        DynamicObject[] billArr;
        HashSet inputOriginalBillNoSet = Sets.newHashSet((Object[])vo.getSerialNo().split(","));
        String sellerTaxpayerId = vo.getSellerTaxpayerId();
        for (DynamicObject obj : billArr = InvoiceQueryUtil.queryBill(inputOriginalBillNoSet, sellerTaxpayerId)) {
            inputOriginalBillNoSet.remove(obj.getString("billno"));
        }
        if (!inputOriginalBillNoSet.isEmpty() && StringUtils.isNotEmpty((CharSequence)(tEntityKey = BillArchiveHelper.getArchiveEnetity((String)"sim_original_bill")))) {
            DynamicObject[] billArr2;
            int count;
            DynamicObjectCollection collect = QueryServiceHelper.query((String)tEntityKey, (String)"id", (QFilter[])new QFilter("billno", "in", (Object)inputOriginalBillNoSet.toArray()).and("salertaxno", "=", (Object)vo.getSellerTaxpayerId()).toArray());
            ArrayList copyList = new ArrayList(collect.size());
            collect.forEach(o -> copyList.add(o.getLong("id")));
            if (!copyList.isEmpty() && (count = BillArchiveHelper.revoke((String)"sim_original_bill", (String)tEntityKey, copyList)) > 0 && (billArr2 = InvoiceQueryUtil.queryBill(inputOriginalBillNoSet, sellerTaxpayerId)) != null && billArr2.length > 0) {
                List<DynamicObject> list2 = Arrays.stream(billArr2).collect(Collectors.toList());
                if (billArr != null && billArr.length > 0) {
                    List list1 = Arrays.stream(billArr).collect(Collectors.toList());
                    list2.addAll(list1);
                }
                return list2.toArray(new DynamicObject[0]);
            }
        }
        return billArr;
    }

    private static DynamicObject[] queryBill(Set<String> inputOriginalBillNoSet, String sellerTaxpayerId) {
        DynamicObject[] billArr = BusinessDataServiceHelper.load((String)"sim_original_bill", (String)originalBillField, (QFilter[])new QFilter("billno", "in", (Object)inputOriginalBillNoSet.toArray()).and("salertaxno", "=", (Object)sellerTaxpayerId).toArray());
        return billArr;
    }

    private static String stripTrailingZeros(String str) {
        try {
            if (StringUtils.isBlank((CharSequence)str)) {
                return "";
            }
            return new BigDecimal(str).stripTrailingZeros().toPlainString();
        }
        catch (Exception e) {
            return str;
        }
    }

    public static Map<String, List<OrderDetailVo>> getInvoiceDataByOriginalBillNo(FindOrderOpenVo vo) {
        HashSet inputOriginalBillNoSet = Sets.newHashSet((Object[])vo.getSerialNo().split(","));
        DynamicObject[] billArr = BusinessDataServiceHelper.load((String)"sim_original_bill", (String)originalBillField, (QFilter[])new QFilter("billno", "in", (Object)inputOriginalBillNoSet.toArray()).and("salertaxno", "=", (Object)vo.getSellerTaxpayerId()).toArray());
        Map<Long, DynamicObject> originalBillMap = Stream.of(billArr).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        Map<String, DynamicObject> originalBillNoMap = Stream.of(billArr).collect(Collectors.toMap(k -> k.getString("billno"), v -> v));
        DynamicObject[] relations = InvoiceQueryUtil.getRelations(billArr);
        Map invIdToBillIdMap = Stream.of(relations).collect(Collectors.groupingBy(k -> k.getLong("tbillid"), TreeMap::new, Collectors.mapping(v -> v.getLong("sbillid"), Collectors.toSet())));
        Map billIdToInvIdMap = Stream.of(relations).collect(Collectors.groupingBy(k -> k.getLong("sbillid"), TreeMap::new, Collectors.mapping(v -> v.getLong("tbillid"), Collectors.toSet())));
        List<OrderDetailVo> voList = InvoiceQueryUtil.findSimRedInfo(invIdToBillIdMap, originalBillMap, billIdToInvIdMap);
        InvoiceQueryUtil.findRedConfirmVatInvoice(invIdToBillIdMap, billIdToInvIdMap);
        voList.addAll(InvoiceQueryUtil.findSimVatInvoice(invIdToBillIdMap, originalBillMap, billIdToInvIdMap));
        Map<String, List<OrderDetailVo>> billNoOrderList = voList.stream().collect(Collectors.groupingBy(OrderDetailVo::getBillNo));
        Set<Map.Entry<String, List<OrderDetailVo>>> billEntries = billNoOrderList.entrySet();
        for (Map.Entry<String, List<OrderDetailVo>> billEntry : billEntries) {
            String billNo = billEntry.getKey();
            if (!inputOriginalBillNoSet.contains(billNo)) {
                billNoOrderList.put(billNo, null);
                continue;
            }
            BigDecimal originalTaxDiff = originalBillNoMap.get(billNo).getBigDecimal("maintaxdeviation");
            List<OrderDetailVo> orderDetailList = billEntry.getValue();
            int orderDetailSize = orderDetailList.size();
            BigDecimal diff = originalTaxDiff.divide(new BigDecimal(orderDetailSize), 2, 1);
            for (int i = 0; i < orderDetailList.size(); ++i) {
                OrderDetailVo detail = orderDetailList.get(i);
                if (i != orderDetailSize - 1) {
                    detail.setMergeDifferTaxAmount(diff);
                    originalTaxDiff = originalTaxDiff.subtract(diff);
                    continue;
                }
                detail.setMergeDifferTaxAmount(originalTaxDiff);
            }
        }
        return billNoOrderList;
    }

    private static void findRedConfirmVatInvoice(Map<Long, Set<Long>> invIdToBillIdMap, Map<Long, Set<Long>> billIdToInvIdMap) {
        DynamicObject[] objs;
        QFilter filter = new QFilter("id", "in", invIdToBillIdMap.keySet());
        for (DynamicObject obj : objs = BusinessDataServiceHelper.load((String)"sim_red_confirm_bill", (String)PropertieUtil.getAllPropertiesSplitByComma("sim_red_confirm_bill", true), (QFilter[])filter.toArray())) {
            Set<Long> removeBillIds = invIdToBillIdMap.remove(obj.getLong("id"));
            QFilter qFilter = new QFilter("orgid", "=", (Object)DynamicObjectUtil.getDynamicObjectLongValue(obj.get("org"))).and("infocode", "=", (Object)obj.getString("number"));
            DynamicObject invoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)"", (QFilter[])qFilter.toArray());
            invIdToBillIdMap.put(invoice.getLong("id"), removeBillIds);
            for (Long removeBillId : removeBillIds) {
                Set<Long> invoiceIds = billIdToInvIdMap.get(removeBillId);
                if (!invoiceIds.remove(obj.getLong("id"))) continue;
                invoiceIds.add(invoice.getLong("id"));
            }
        }
    }

    private static List<OrderDetailVo> getAllInvoiceByBillNos(Set<String> billNos, Map<Long, Set<Long>> invIdToBillIdMap, Map<Long, DynamicObject> originalBillMap, Map<Long, Set<Long>> billIdToInvIdMap, DynamicObject[] relations) {
        DynamicObject[] originalBills = BusinessDataServiceHelper.load((String)"sim_original_bill", (String)String.join((CharSequence)",", "billsourcetype", "invoicecode", "invoiceno"), (QFilter[])new QFilter("billno", "in", billNos).toArray());
        ArrayList<DynamicObject> invalidBills = new ArrayList<DynamicObject>(originalBills.length);
        ArrayList<DynamicObject> validBills = new ArrayList<DynamicObject>(originalBills.length);
        for (DynamicObject originalBill : originalBills) {
            if ("C".equals(originalBill.getString("billsourcetype"))) {
                invalidBills.add(originalBill);
                continue;
            }
            validBills.add(originalBill);
        }
        ArrayList<OrderDetailVo> allInvoiceByBillNos = new ArrayList<OrderDetailVo>();
        allInvoiceByBillNos.addAll(InvoiceQueryUtil.getInvoiceByInvalidBills(invIdToBillIdMap, originalBillMap, billIdToInvIdMap, invalidBills));
        allInvoiceByBillNos.addAll(InvoiceQueryUtil.getInvoiceByValidBill(invIdToBillIdMap, originalBillMap, billIdToInvIdMap, validBills, relations));
        return allInvoiceByBillNos;
    }

    private static List<OrderDetailVo> getInvoiceByValidBill(Map<Long, Set<Long>> invIdToBillIdMap, Map<Long, DynamicObject> originalBillMap, Map<Long, Set<Long>> billIdToInvIdMap, List<DynamicObject> validBills, DynamicObject[] relations) {
        ArrayList<OrderDetailVo> allInvoiceByBillNos = new ArrayList<OrderDetailVo>();
        if (!CollectionUtils.isEmpty(validBills)) {
            Object[] billIds = validBills.stream().map(DataEntityBase::getPkValue).toArray();
            List list = Arrays.stream(relations).filter(relation -> StringUtils.isNotBlank((CharSequence)relation.getString("tbillno"))).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(list)) {
                DynamicObject[] invoiceList;
                Map sBillNoMapByTBillNo = Stream.of(relations).collect(Collectors.groupingBy(k -> k.get("tbillno"), TreeMap::new, Collectors.mapping(v -> v.get("sbillno"), Collectors.toSet())));
                List<String> tBillNos = list.stream().map(o -> o.getString("tbillno")).distinct().collect(Collectors.toList());
                for (DynamicObject invoice : invoiceList = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma("sim_vatinvoice", true), (QFilter[])new QFilter("billno", "in", tBillNos).toArray())) {
                    allInvoiceByBillNos.add(InvoiceQueryUtil.assembleInvoiceByVatInvoice(invoice, invIdToBillIdMap, originalBillMap, billIdToInvIdMap, sBillNoMapByTBillNo));
                }
                List<OrderDetailVo> orderDetailVos = InvoiceQueryUtil.queryInvoiceByRedInfo(invIdToBillIdMap, originalBillMap, billIdToInvIdMap, sBillNoMapByTBillNo, tBillNos);
                for (OrderDetailVo orderDetailVo : orderDetailVos) {
                    boolean exist = allInvoiceByBillNos.stream().anyMatch(a -> String.format("%s_%s", a.getInvoiceCode(), a.getInvoiceNumber()).equals(String.format("%s_%s", orderDetailVo.getInvoiceCode(), orderDetailVo.getInvoiceNumber())));
                    if (exist) continue;
                    allInvoiceByBillNos.add(orderDetailVo);
                }
            }
            allInvoiceByBillNos.addAll(InvoiceQueryUtil.getInvoiceByBillAddInvoice(billIds, invIdToBillIdMap, originalBillMap, billIdToInvIdMap));
        }
        return allInvoiceByBillNos;
    }

    private static List<OrderDetailVo> queryInvoiceByRedInfo(Map<Long, Set<Long>> invIdToBillIdMap, Map<Long, DynamicObject> originalBillMap, Map<Long, Set<Long>> billIdToInvIdMap, Map<Object, Set<Object>> sBillNoMapByTBillNo, List<String> tBillNos) {
        DynamicObject[] redInfos;
        ArrayList<OrderDetailVo> allInvoiceByBillNos = new ArrayList<OrderDetailVo>();
        for (DynamicObject redInfo : redInfos = BusinessDataServiceHelper.load((String)"sim_red_info", (String)PropertieUtil.getAllPropertiesSplitByComma("sim_red_info", true), (QFilter[])new QFilter("billno", "in", tBillNos).toArray())) {
            if ("4".equals(redInfo.getString("status"))) {
                DynamicObject[] invoices;
                for (DynamicObject invoice : invoices = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma("sim_vatinvoice", true), (QFilter[])InvoiceQueryUtil.getInvoiceByCodeAndNo(redInfo.getString("invoicecode"), redInfo.getString("invoiceno")).toArray())) {
                    allInvoiceByBillNos.add(InvoiceQueryUtil.assembleInvoiceByVatInvoice(invoice, invIdToBillIdMap, originalBillMap, billIdToInvIdMap, sBillNoMapByTBillNo));
                }
                continue;
            }
            if (StringUtils.isBlank((CharSequence)redInfo.getString("infocode"))) {
                allInvoiceByBillNos.addAll(InvoiceQueryUtil.getInvoiceByRedInfo(redInfo, invIdToBillIdMap, originalBillMap, billIdToInvIdMap));
                continue;
            }
            DynamicObject invoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma("sim_vatinvoice", true), (QFilter[])new QFilter("infocode", "=", (Object)redInfo.getString("infocode")).and("invoicestatus", "!=", (Object)"6").toArray());
            if (invoice == null) {
                allInvoiceByBillNos.addAll(InvoiceQueryUtil.getInvoiceByRedInfo(redInfo, invIdToBillIdMap, originalBillMap, billIdToInvIdMap));
                continue;
            }
            allInvoiceByBillNos.add(InvoiceQueryUtil.assembleInvoiceByVatInvoice(invoice, invIdToBillIdMap, originalBillMap, billIdToInvIdMap, sBillNoMapByTBillNo));
        }
        return allInvoiceByBillNos;
    }

    private static List<OrderDetailVo> getInvoiceByInvalidBills(Map<Long, Set<Long>> invIdToBillIdMap, Map<Long, DynamicObject> originalBillMap, Map<Long, Set<Long>> billIdToInvIdMap, List<DynamicObject> invalidBills) {
        ArrayList<OrderDetailVo> result = new ArrayList<OrderDetailVo>();
        if (!CollectionUtils.isEmpty(invalidBills)) {
            QFilter qFilter = InvoiceQueryUtil.createFilterByInvoiceNos(invalidBills);
            DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma("sim_vatinvoice", true), (QFilter[])qFilter.toArray());
            if (null != invoices && 0 < invoices.length) {
                for (DynamicObject invoice : invoices) {
                    result.add(InvoiceQueryUtil.assembleInvoiceByVatInvoice(invoice, invIdToBillIdMap, originalBillMap, billIdToInvIdMap, new HashMap<Object, Set<Object>>()));
                }
            }
        }
        return result;
    }

    public static QFilter createFilterByInvoiceNos(List<DynamicObject> bills) {
        QFilter qFilter = new QFilter("invoicecode", "=", (Object)"-1").and("invoiceno", "=", (Object)"-1");
        for (DynamicObject bill : bills) {
            QFilter q = new QFilter("invoicecode", "=", bill.get("invoicecode")).and("invoiceno", "=", bill.get("invoiceno"));
            qFilter.or(q);
        }
        return qFilter;
    }

    private static List<OrderDetailVo> getInvoiceByBillAddInvoice(Object[] billIds, Map<Long, Set<Long>> invIdToBillIdMap, Map<Long, DynamicObject> originalBillMap, Map<Long, Set<Long>> billIdToInvIdMap) {
        ArrayList<OrderDetailVo> result = new ArrayList<OrderDetailVo>();
        QFilter addfilter = new QFilter("originalbillid", "in", (Object)billIds).and(BillHelper.notCancelFilter());
        DynamicObject[] billAddInvoices = BusinessDataServiceHelper.load((String)"sim_bill_add_invoice", (String)PropertieUtil.getAllPropertiesSplitByComma("sim_bill_add_invoice", false), (QFilter[])addfilter.toArray());
        if (billAddInvoices != null && billAddInvoices.length > 0) {
            Map billNoMapByInvoiceNo = Stream.of(billAddInvoices).collect(Collectors.groupingBy(k -> String.format("%s_%s", k.get("invoicecode"), k.get("invoiceno")), TreeMap::new, Collectors.mapping(v -> v.get("billno"), Collectors.toSet())));
            QFilter defaultFilter = new QFilter("invoicecode", "=", (Object)"-1").and("invoiceno", "=", (Object)"-1");
            for (DynamicObject billAddInvoice : billAddInvoices) {
                QFilter qFilter = new QFilter("invoicecode", "=", (Object)billAddInvoice.getString("invoicecode")).and(new QFilter("invoiceno", "=", (Object)billAddInvoice.getString("invoiceno")));
                defaultFilter.or(qFilter);
            }
            DynamicObject[] invoiceByEdit = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma("sim_vatinvoice", true), (QFilter[])defaultFilter.toArray());
            if (invoiceByEdit != null && 0 < invoiceByEdit.length) {
                for (DynamicObject invoice : invoiceByEdit) {
                    result.add(InvoiceQueryUtil.assembleInvoiceByVatInvoice(invoice, invIdToBillIdMap, originalBillMap, billIdToInvIdMap, billNoMapByInvoiceNo));
                }
            }
        }
        return result;
    }

    private static OrderDetailVo assembleInvoiceByVatInvoice(DynamicObject invoice, Map<Long, Set<Long>> invIdToBillIdMap, Map<Long, DynamicObject> originalBillMap, Map<Long, Set<Long>> billIdToInvIdMap, Map<Object, Set<Object>> sBillNoMapByTBillNo) {
        Set<Object> codeSet;
        Set<Object> billNoSet;
        DynamicObject bill;
        OrderDetailVo vo = DynamicObjectUtil.dynamicObject2Bean(OrderDetailVo.class, invoice);
        DynamicObjectCollection items = invoice.getDynamicObjectCollection("items");
        vo.setGoods(new ArrayList<InvoiceDetailVo>(items.size()));
        items.forEach(o -> vo.getGoods().add(DynamicObjectUtil.dynamicObject2Bean(InvoiceDetailVo.class, o)));
        vo.setOrgName(invoice.getDynamicObject("orgid").getString("name"));
        String invoiceBillNo = invoice.getString("billno");
        vo.setSerialNo(invoiceBillNo);
        vo.setInvoiceStatus(invoice.getInt("invoicestatus"));
        String invoiceCodeAndNo = String.format("%s_%s", invoice.get("invoicecode"), invoice.get("invoiceno"));
        long invoiceId = invoice.getLong("id");
        Set<Long> billIdSet = invIdToBillIdMap.get(invoiceId);
        if (!CollectionUtils.isEmpty(billIdSet) && (bill = originalBillMap.get(billIdSet.toArray(new Long[0])[0])) != null) {
            vo.setSplitOrMergeFlag(InvoiceQueryUtil.getSplitOrMergeFlag(billIdToInvIdMap, bill));
            vo.setBillNo(bill.getString("billno"));
        }
        if (!CollectionUtils.isEmpty(billNoSet = sBillNoMapByTBillNo.get(invoiceBillNo))) {
            vo.setBillNo(billNoSet.toArray(new Object[0])[0].toString());
        }
        if (!CollectionUtils.isEmpty(codeSet = sBillNoMapByTBillNo.get(invoiceCodeAndNo))) {
            vo.setBillNo(codeSet.toArray(new Object[0])[0].toString());
        }
        vo.setResult(invoice.getString("result"));
        return vo;
    }

    public static List<OrderDetailVo> getInvoiceByRedInfo(DynamicObject redInfo, Map<Long, Set<Long>> invIdToBillIdMap, Map<Long, DynamicObject> originalBillMap, Map<Long, Set<Long>> billIdToInvIdMap) {
        OrderDetailVo vo = DynamicObjectUtil.dynamicObject2Bean(OrderDetailVo.class, redInfo);
        String selectField = String.join((CharSequence)",", "invoicecode", "invoiceno", "invoicestatus", "orgid");
        String invoiceCode = redInfo.getString("invoicecode");
        String invoiceNo = redInfo.getString("invoiceno");
        ArrayList<OrderDetailVo> result = new ArrayList<OrderDetailVo>();
        if (StringUtils.isBlank((CharSequence)invoiceCode) || StringUtils.isBlank((CharSequence)invoiceNo)) {
            QFilter qFilter = new QFilter("infocode", "=", (Object)redInfo.getString("infocode")).and("orgid", "=", (Object)DynamicObjectUtil.getDynamicObjectLongValue(redInfo.get("org"))).and("issuestatus", "=", (Object)IssueStatusEnum.ok.getCode()).and("invoicestatus", "=", (Object)"6");
            DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)selectField, (QFilter[])qFilter.toArray());
            if (invoices != null && 0 < invoices.length) {
                for (DynamicObject invoice : invoices) {
                    OrderDetailVo clone = (OrderDetailVo)ObjectUtils.clone((Object)vo);
                    clone.setInvoiceStatus(Integer.parseInt("6"));
                    clone.setInvoiceCode(invoice.getString("invoicecode"));
                    clone.setInvoiceNumber(invoice.getString("invoiceno"));
                    result.add(clone);
                }
            }
        } else {
            result.add(vo);
        }
        result.forEach(a -> InvoiceQueryUtil.createInvoiceDetailByRedInfo(a, redInfo, invIdToBillIdMap, originalBillMap, billIdToInvIdMap));
        return result;
    }

    public static void createInvoiceDetailByRedInfo(OrderDetailVo orderDetailVo, DynamicObject redInfo, Map<Long, Set<Long>> invIdToBillIdMap, Map<Long, DynamicObject> originalBillMap, Map<Long, Set<Long>> billIdToInvIdMap) {
        orderDetailVo.setSerialNo(redInfo.getString("billno"));
        orderDetailVo.setInvoiceSource("3");
        orderDetailVo.setBuyerProperty(0);
        orderDetailVo.setInvoiceProperty(1);
        orderDetailVo.setCanRedAmount(BigDecimal.ZERO);
        orderDetailVo.setOrgName(redInfo.getDynamicObject("org").getString("name"));
        orderDetailVo.setIssueStatus("2");
        DynamicObject bill = originalBillMap.get(invIdToBillIdMap.get(redInfo.getLong("id")).toArray(new Long[0])[0]);
        orderDetailVo.setBillNo(bill.getString("billno"));
        orderDetailVo.setSplitOrMergeFlag(InvoiceQueryUtil.getSplitOrMergeFlag(billIdToInvIdMap, bill));
        DynamicObjectCollection items = redInfo.getDynamicObjectCollection("items");
        orderDetailVo.setGoods(new ArrayList<InvoiceDetailVo>(items.size()));
        items.forEach(o -> orderDetailVo.getGoods().add(DynamicObjectUtil.dynamicObject2Bean(InvoiceDetailVo.class, o)));
    }

    public static QFilter getInvoiceByCodeAndNo(String invoiceCode, String invoiceNo) {
        QFilter qFilter = new QFilter("invoiceno", "=", (Object)invoiceNo);
        qFilter.and("invoicecode", "=", (Object)invoiceCode);
        return qFilter;
    }

    public static DynamicObject[] getRelations(DynamicObject[] inputOriginalBillArray) {
        QFilter filter = new QFilter("sbillid", "in", (Object)Arrays.stream(inputOriginalBillArray).map(DataEntityBase::getPkValue).toArray());
        return BusinessDataServiceHelper.load((String)"sim_bill_inv_relation", (String)PropertieUtil.getAllPropertiesSplitByComma("sim_bill_inv_relation"), (QFilter[])filter.toArray());
    }

    private static List<OrderDetailVo> findSimRedInfo(Map<Long, Set<Long>> invIdToBillIdMap, Map<Long, DynamicObject> originalBillMap, Map<Long, Set<Long>> billIdToInvIdMap) {
        QFilter filter = new QFilter("id", "in", invIdToBillIdMap.keySet());
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)"sim_red_info", (String)PropertieUtil.getAllPropertiesSplitByComma("sim_red_info", true), (QFilter[])filter.toArray());
        ArrayList<OrderDetailVo> voList = new ArrayList<OrderDetailVo>(objs.length);
        for (DynamicObject obj : objs) {
            OrderDetailVo vo = DynamicObjectUtil.dynamicObject2Bean(OrderDetailVo.class, obj);
            String invoiceCode = obj.getString("invoicecode");
            String invoiceNo = obj.getString("invoiceno");
            if (StringUtils.isBlank((CharSequence)invoiceCode) || StringUtils.isBlank((CharSequence)invoiceNo)) {
                QFilter qFilter = new QFilter("infocode", "=", (Object)obj.getString("infocode")).and("orgid", "=", (Object)DynamicObjectUtil.getDynamicObjectLongValue(obj.get("org"))).and("issuestatus", "=", (Object)IssueStatusEnum.ok.getCode()).and("invoicestatus", "=", (Object)"6");
                DynamicObject invoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)String.join((CharSequence)",", "invoicecode", "invoiceno", "invoicestatus", "orgid"), (QFilter[])qFilter.toArray());
                if (invoice == null) continue;
                vo.setInvoiceStatus(Integer.parseInt("6"));
                vo.setInvoiceCode(invoice.getString("invoicecode"));
                vo.setInvoiceNumber(invoice.getString("invoiceno"));
            }
            InvoiceQueryUtil.createInvoiceDetailByRedInfo(vo, obj, invIdToBillIdMap, originalBillMap, billIdToInvIdMap);
            voList.add(vo);
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("BillInvoiceQuery-Api-RedInfo:" + JSON.toJSONString(voList));
        }
        return voList;
    }

    private static List<OrderDetailVo> findSimVatInvoice(Map<Long, Set<Long>> invIdToBillIdMap, Map<Long, DynamicObject> originalBillMap, Map<Long, Set<Long>> billIdToInvIdMap) {
        QFilter filter = new QFilter("id", "in", invIdToBillIdMap.keySet());
        DynamicObject[] invoiceList = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma("sim_vatinvoice", true), (QFilter[])filter.toArray());
        ArrayList<OrderDetailVo> voList = new ArrayList<OrderDetailVo>(invoiceList.length);
        for (DynamicObject invoice : invoiceList) {
            OrderDetailVo vo = DynamicObjectUtil.dynamicObject2Bean(OrderDetailVo.class, invoice);
            DynamicObjectCollection items = invoice.getDynamicObjectCollection("items");
            vo.setGoods(new ArrayList<InvoiceDetailVo>(items.size()));
            items.forEach(o -> vo.getGoods().add(DynamicObjectUtil.dynamicObject2Bean(InvoiceDetailVo.class, o)));
            vo.setOrgName(invoice.getDynamicObject("orgid").getString("name"));
            vo.setSerialNo(invoice.getString("billno"));
            vo.setInvoiceStatus(invoice.getInt("invoicestatus"));
            DynamicObject bill = originalBillMap.get(invIdToBillIdMap.get(invoice.getLong("id")).toArray(new Long[0])[0]);
            vo.setSplitOrMergeFlag(InvoiceQueryUtil.getSplitOrMergeFlag(billIdToInvIdMap, bill));
            vo.setBillNo(bill.getString("billno"));
            voList.add(vo);
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("BillInvoiceQuery-Api-VatInvoice:" + JSON.toJSONString(voList));
        }
        return voList;
    }

    private static String getSplitOrMergeFlag(Map<Long, Set<Long>> billIdToInvIdMap, DynamicObject bill) {
        String splitOrMergeFlag = bill.getString("splitormergeflag");
        Set<Long> invoiceIdSet = billIdToInvIdMap.get(bill.getLong("id"));
        if (CollectionUtils.isEmpty(invoiceIdSet)) {
            return splitOrMergeFlag;
        }
        if ("2".equals(splitOrMergeFlag) && invoiceIdSet.size() > 1) {
            return "3";
        }
        if ("0".equals(splitOrMergeFlag) && invoiceIdSet.size() > 1) {
            return "1";
        }
        return splitOrMergeFlag;
    }

    public static List<DynamicObject> getInvoiceByRelationTableSBillId(List<Long> billIdList) {
        QFilter rFilter = new QFilter("sbillid", "in", billIdList);
        DynamicObject[] rInvObjs = BusinessDataServiceHelper.load((String)"sim_bill_inv_relation", (String)String.join((CharSequence)",", "tbillid", "sbillno", "ttable"), (QFilter[])rFilter.toArray());
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(rInvObjs.length);
        HashMap<Long, Long> map = new HashMap<Long, Long>();
        for (DynamicObject rInvObj : rInvObjs) {
            if (map.containsKey(rInvObj.getLong("tbillid"))) continue;
            map.put(rInvObj.getLong("tbillid"), rInvObj.getLong("tbillid"));
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)rInvObj.getLong("tbillid"), (String)rInvObj.getString("ttable"));
            dynamicObject.set("billno", (Object)rInvObj.getString("sbillno"));
            list.add(dynamicObject);
        }
        return list;
    }
}

