/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.util;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.dto.GoodsInfoItemVo;
import kd.imc.bdm.common.dto.GoodsInfoVo;
import kd.imc.bdm.common.helper.ImcBaseDataHelper;
import kd.imc.bdm.common.helper.OrgHelper;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.MaterialInfoUtil;

public class MaterialInfoUtil2 {
    private static final Log LOGGER = LogFactory.getLog(MaterialInfoUtil.class);
    private static ThreadLocal<MaterialInfoUtil2> materialInfoUtilThreadLocal = new ThreadLocal();
    private Map<String, Set<String>> materialNameMap;
    private Map<String, Set<String>> materialCodeMap;
    private Map<String, Set<GoodsInfoVo>> materialMap;
    private Map<String, Set<String>> materialTypeNameMap;
    private Map<String, Set<String>> materialTypeCodeMap;
    private Map<String, Set<GoodsInfoVo>> materialTypeMap;
    private Map<String, Set<GoodsInfoVo>> expenseItemlMap;

    public static Set<GoodsInfoVo> getGoodsByMaterType(String code, String name) {
        return MaterialInfoUtil2.getGoodsByMaterType(code, name, false);
    }

    public static Set<GoodsInfoVo> getGoodsByMaterType(String code, String name, boolean isLogDetail) {
        MaterialInfoUtil2 miUtil;
        if (isLogDetail) {
            LOGGER.info(String.format("MaterialInfoUtil getGoodsByMaterType code:%s,name:%s", code, name));
        }
        if ((miUtil = materialInfoUtilThreadLocal.get()) == null) {
            return Sets.newHashSet();
        }
        if (isLogDetail) {
            LOGGER.info(String.format("keySet is null code:%s,name:%s", code, name));
        }
        if (StringUtils.isNotBlank((CharSequence)code) && StringUtils.isNotBlank((CharSequence)name)) {
            HashSet set = miUtil.materialTypeMap.get(code + "&" + name);
            return set != null ? set : Sets.newHashSet();
        }
        Set<String> keySet = null;
        if (StringUtils.isNotBlank((CharSequence)code)) {
            keySet = miUtil.materialTypeCodeMap.get(code);
            if (isLogDetail) {
                LOGGER.info(String.format("materialTypeCodeMap:%s", SerializationUtils.toJsonString(miUtil.materialTypeCodeMap)));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)name)) {
            if (isLogDetail) {
                LOGGER.info(String.format("materialTypeNameMap:%s", SerializationUtils.toJsonString(miUtil.materialTypeNameMap)));
            }
            keySet = miUtil.materialTypeNameMap.get(name);
        }
        if (keySet == null) {
            if (isLogDetail) {
                LOGGER.info(String.format("keySet is null code:%s,name:%s, materialTypeNameMap:%s", code, name, miUtil.materialTypeNameMap));
            }
            return Sets.newHashSet();
        }
        HashSet goodsSet = Sets.newHashSet();
        for (String key : keySet) {
            if (isLogDetail) {
                LOGGER.info(String.format("materialTypeMap:%s", miUtil.materialTypeMap));
            }
            goodsSet.addAll((Collection)miUtil.materialTypeMap.get(key));
        }
        return goodsSet;
    }

    public static Set<GoodsInfoVo> getGoodsByExpenseItem(String code, String name, boolean isLogDetail) {
        MaterialInfoUtil2 miUtil;
        if (isLogDetail) {
            LOGGER.info(String.format("getGoodsByExpenseItem code%s name\uff1a%s", code, name));
        }
        if ((miUtil = materialInfoUtilThreadLocal.get()) == null) {
            return Sets.newHashSet();
        }
        if (StringUtils.isBlank((CharSequence)code) || StringUtils.isBlank((CharSequence)name)) {
            if (isLogDetail) {
                LOGGER.info("\u8d39\u7528\u9879\u76ee\u540d\u79f0\u6216\u8005\u7f16\u7801\u4e3a\u7a7a\uff0c\u4e0d\u8fdb\u884c\u5339\u914d");
            }
            return Sets.newHashSetWithExpectedSize((int)0);
        }
        HashSet set = miUtil.expenseItemlMap.get(code + "&" + name);
        return set != null ? set : Sets.newHashSet();
    }

    public static Set<GoodsInfoVo> getGoodsByExpenseItem(String code, String name) {
        return MaterialInfoUtil2.getGoodsByExpenseItem(code, name, false);
    }

    public static Set<GoodsInfoVo> getGoodsByMater(String code, String name) {
        MaterialInfoUtil2 miUtil = materialInfoUtilThreadLocal.get();
        if (miUtil == null) {
            return Sets.newHashSet();
        }
        if (StringUtils.isNotBlank((CharSequence)code) && StringUtils.isNotBlank((CharSequence)name)) {
            HashSet set = miUtil.materialMap.get(code + "&" + name);
            return set != null ? set : Sets.newHashSet();
        }
        Set<String> keySet = null;
        if (StringUtils.isNotBlank((CharSequence)code)) {
            keySet = miUtil.materialCodeMap.get(code);
        }
        if (StringUtils.isNotBlank((CharSequence)name)) {
            keySet = miUtil.materialNameMap.get(name);
        }
        if (keySet == null) {
            return Sets.newHashSet();
        }
        HashSet goodsSet = Sets.newHashSet();
        for (String key : keySet) {
            goodsSet.addAll((Collection)miUtil.materialMap.get(key));
        }
        return goodsSet;
    }

    public static void getInstance(long orgId, Set<String> nameSet, Set<String> codeSet, Set<String> typeSet, boolean isBotp) {
        MaterialInfoUtil2.getInstance(orgId, nameSet, codeSet, typeSet, isBotp, Sets.newHashSet(), Sets.newHashSet());
    }

    public static void getInstance(long orgId, Set<String> nameSet, Set<String> codeSet, Set<String> typeSet, boolean isBotp, Set<Long> materialIdSet, Set<Long> expenseIdSet) {
        if (nameSet.isEmpty() && codeSet.isEmpty() && typeSet.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5546\u54c1\u540d\u79f0\u548c\u7f16\u7801\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a", (String)"MaterialInfoUtil_0", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        LOGGER.info(String.format("MaterialInfoUtil getInstance orgId:%s nameSet\uff1a%s codeSet:%s", orgId, nameSet, codeSet));
        MaterialInfoUtil2 miUtil = new MaterialInfoUtil2(codeSet.size() + nameSet.size());
        HashSet materialTypeSet = Sets.newHashSet();
        if (!CollectionUtils.isEmpty(typeSet)) {
            materialTypeSet.addAll(typeSet);
        }
        if (!CollectionUtils.isEmpty(nameSet)) {
            materialTypeSet.addAll(nameSet);
        }
        QFilter orgFilter = ImcBaseDataHelper.getGoodsInfoFilter(orgId);
        Map<Object, DynamicObject> goodPkMap = MaterialInfoUtil2.queryGoodsInfoMap(nameSet, codeSet, orgFilter, materialIdSet, expenseIdSet);
        for (Map.Entry<Object, DynamicObject> entry : goodPkMap.entrySet()) {
            DynamicObject good = entry.getValue();
            DynamicObjectCollection goodsItemList = good.getDynamicObjectCollection("bdm_goods_info_item");
            GoodsInfoVo voBody = MaterialInfoUtil2.generateMaterialVoBody(good);
            ArrayList<GoodsInfoItemVo> usedItems = new ArrayList<GoodsInfoItemVo>();
            voBody.setUsedItems(usedItems);
            for (DynamicObject goodsItem : goodsItemList) {
                String code = goodsItem.getString("material_no".concat(".number"));
                String name = goodsItem.getString("material_no".concat(".name"));
                DynamicObject expense = goodsItem.getDynamicObject("expenseitem");
                String expenseName = null;
                String expenseNumber = null;
                if (null != expense) {
                    expenseName = goodsItem.getDynamicObject("expenseitem").getLocaleString("name").getLocaleValue_zh_CN();
                    expenseNumber = goodsItem.getDynamicObject("expenseitem").getString("number");
                }
                if (!nameSet.contains(name) && !nameSet.contains(expenseName) && !codeSet.contains(code) && !codeSet.contains(expenseNumber)) continue;
                GoodsInfoItemVo itemVo = MaterialInfoUtil2.generateMaterialItem(goodsItem);
                usedItems.add(itemVo);
                String key = code + "&" + name;
                Set<Object> materialSet = !miUtil.materialMap.containsKey(key) ? Sets.newHashSet() : miUtil.materialMap.get(key);
                materialSet.add(voBody);
                miUtil.materialMap.put(key, materialSet);
                Set<Object> materialCodeSet = !miUtil.materialCodeMap.containsKey(code) ? Sets.newHashSet() : miUtil.materialCodeMap.get(code);
                materialCodeSet.add(key);
                miUtil.materialCodeMap.put(code, materialCodeSet);
                Set<Object> materialNameSet = !miUtil.materialNameMap.containsKey(name) ? Sets.newHashSet() : miUtil.materialNameMap.get(name);
                materialNameSet.add(key);
                miUtil.materialNameMap.put(name, materialNameSet);
                MaterialInfoUtil2.initExpenseItemMap(voBody, goodsItem, miUtil);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)materialTypeSet)) {
            MaterialInfoUtil2.initMaterialTypeNameSet(miUtil, orgFilter.copy(), materialTypeSet, isBotp);
        }
        materialInfoUtilThreadLocal.set(miUtil);
    }

    private static Map<Object, DynamicObject> queryGoodsInfoMap(Set<String> nameSet, Set<String> codeSet, QFilter orgFilter) {
        return MaterialInfoUtil2.queryGoodsInfoMap(nameSet, codeSet, orgFilter, Sets.newHashSet(), Sets.newHashSet());
    }

    private static Map<Object, DynamicObject> queryGoodsInfoMap(Set<String> nameSet, Set<String> codeSet, QFilter orgFilter, Set<Long> materialIdSet, Set<Long> expenseIdSet) {
        String queryFields = MaterialInfoUtil2.getQueryField();
        String itemKey = "bdm_goods_info_item.";
        HashSet goodsInfoPks = new HashSet();
        boolean isUseOriginalWay = "1".equals(ImcConfigUtil.getValue("useOriginalQuery", "useOriginalQuery"));
        boolean bl = isUseOriginalWay = isUseOriginalWay || materialIdSet.size() == 0 && expenseIdSet.size() == 0;
        if (isUseOriginalWay) {
            Map tempMap;
            QFilter qFilter;
            if (!CollectionUtils.isEmpty(nameSet)) {
                qFilter = orgFilter.copy().and(OrgHelper.getIdFilter(nameSet, itemKey + "material_name"));
                tempMap = BusinessDataServiceHelper.loadFromCache((String)"bdm_goods_info", (String)"id", (QFilter[])qFilter.toArray());
                Collections.addAll(goodsInfoPks, tempMap.keySet().toArray(new Object[0]));
                qFilter = orgFilter.copy().and(OrgHelper.getIdFilter(nameSet, itemKey + "expenseitem".concat(".name")));
                tempMap = BusinessDataServiceHelper.loadFromCache((String)"bdm_goods_info", (String)"id", (QFilter[])qFilter.toArray());
                Collections.addAll(goodsInfoPks, tempMap.keySet().toArray(new Object[0]));
            }
            if (!CollectionUtils.isEmpty(codeSet)) {
                qFilter = orgFilter.copy().and(OrgHelper.getIdFilter(codeSet, itemKey + "material_no".concat(".number")));
                tempMap = BusinessDataServiceHelper.loadFromCache((String)"bdm_goods_info", (String)"id", (QFilter[])qFilter.toArray());
                Collections.addAll(goodsInfoPks, tempMap.keySet().toArray(new Object[0]));
                qFilter = orgFilter.copy().and(OrgHelper.getIdFilter(codeSet, itemKey + "expenseitem".concat(".number")));
                tempMap = BusinessDataServiceHelper.loadFromCache((String)"bdm_goods_info", (String)"id", (QFilter[])qFilter.toArray());
                Collections.addAll(goodsInfoPks, tempMap.keySet().toArray(new Object[0]));
            }
        } else {
            Map tempMap;
            QFilter qFilter;
            if (!CollectionUtils.isEmpty(materialIdSet)) {
                qFilter = orgFilter.copy().and(OrgHelper.getIdFilter(materialIdSet, itemKey + "material_no"));
                tempMap = BusinessDataServiceHelper.loadFromCache((String)"bdm_goods_info", (String)"id", (QFilter[])qFilter.toArray());
                Collections.addAll(goodsInfoPks, tempMap.keySet().toArray(new Object[0]));
            }
            if (!CollectionUtils.isEmpty(expenseIdSet)) {
                qFilter = orgFilter.copy().and(OrgHelper.getIdFilter(expenseIdSet, itemKey + "expenseitem"));
                tempMap = BusinessDataServiceHelper.loadFromCache((String)"bdm_goods_info", (String)"id", (QFilter[])qFilter.toArray());
                Collections.addAll(goodsInfoPks, tempMap.keySet().toArray(new Object[0]));
            }
        }
        return BusinessDataServiceHelper.loadFromCache((String)"bdm_goods_info", (String)queryFields, (QFilter[])new QFilter("id", "in", goodsInfoPks).toArray());
    }

    private static GoodsInfoItemVo generateMaterialItem(DynamicObject goodsItem) {
        GoodsInfoItemVo itemVo = DynamicObjectUtil.dynamicObject2Bean(GoodsInfoItemVo.class, goodsItem);
        itemVo.setMaterial(goodsItem.getDynamicObject("material_no"));
        itemVo.setExpenseItem(goodsItem.getDynamicObject("expenseitem"));
        itemVo.setBaseUnit(goodsItem.getDynamicObject("baseunit"));
        return itemVo;
    }

    private static GoodsInfoVo generateMaterialVoBody(DynamicObject good) {
        GoodsInfoVo materialVo = DynamicObjectUtil.dynamicObject2Bean(GoodsInfoVo.class, good);
        materialVo.setGroup(good.getDynamicObject("group"));
        if (null != good.getDynamicObject("taxcode")) {
            materialVo.setTaxCode(good.getDynamicObject("taxcode"));
        }
        return materialVo;
    }

    private MaterialInfoUtil2(int initializeSize) {
        this.materialNameMap = Maps.newLinkedHashMapWithExpectedSize((int)initializeSize);
        this.materialCodeMap = Maps.newLinkedHashMapWithExpectedSize((int)initializeSize);
        this.materialMap = Maps.newLinkedHashMapWithExpectedSize((int)initializeSize);
        this.materialTypeNameMap = Maps.newLinkedHashMapWithExpectedSize((int)10);
        this.materialTypeMap = Maps.newLinkedHashMapWithExpectedSize((int)10);
        this.materialTypeCodeMap = Maps.newLinkedHashMapWithExpectedSize((int)10);
        this.expenseItemlMap = Maps.newLinkedHashMapWithExpectedSize((int)initializeSize);
    }

    private static String getQueryField() {
        String fields = "id,number,name,specifications,unit,taxcode,privilegeflag,privilegetype,taxrate,price,isinclusive,priority,group,lbsv_system_code,filter,filter_tag,ctrlstrategy,";
        String itemFields = "bdm_goods_info_item.sourcetype,bdm_goods_info_item.material_no,bdm_goods_info_item.materialtype,bdm_goods_info_item.expenseitem,bdm_goods_info_item.material_name,bdm_goods_info_item.modelnum_code,bdm_goods_info_item.material_modelnum,bdm_goods_info_item.modelnum_unit,bdm_goods_info_item.modelnum_rate,bdm_goods_info_item.baseunit";
        return fields + itemFields;
    }

    private static void initExpenseItemMap(GoodsInfoVo good, DynamicObject goodsItem, MaterialInfoUtil2 miUtil) {
        if ("5".equals(goodsItem.getString("sourcetype"))) {
            String code = goodsItem.getString("expenseitem".concat(".number"));
            String name = goodsItem.getString("expenseitem".concat(".name"));
            String key = code + "&" + name;
            Set<Object> expenseItemGoodsInfo = !miUtil.expenseItemlMap.containsKey(key) ? Sets.newHashSet() : miUtil.expenseItemlMap.get(key);
            expenseItemGoodsInfo.add(good);
            miUtil.expenseItemlMap.put(key, expenseItemGoodsInfo);
        }
    }

    private static void initMaterialTypeNameSet(MaterialInfoUtil2 miUtil, QFilter orgFilter, Set<String> materialTypeSet, boolean isBotp) {
        QFilter qFilter = OrgHelper.getIdFilter(materialTypeSet, "bdm_goods_info_item.materialtype.number").or(OrgHelper.getIdFilter(materialTypeSet, "bdm_goods_info_item.materialtype.name"));
        String queryFields = MaterialInfoUtil2.getQueryField();
        Map goodsInfoPkMap = BusinessDataServiceHelper.loadFromCache((String)"bdm_goods_info", (String)"id", (QFilter[])orgFilter.and(qFilter).toArray());
        Set goodsInfoPkSet = goodsInfoPkMap.keySet();
        Map goodsByTypesMap = BusinessDataServiceHelper.loadFromCache((String)"bdm_goods_info", (String)queryFields, (QFilter[])new QFilter("id", "in", goodsInfoPkSet).toArray());
        LOGGER.info(String.format("MaterialInfoUtil getInstance goodsByTypes.length=%s", goodsByTypesMap.size()));
        for (Map.Entry entry : goodsByTypesMap.entrySet()) {
            DynamicObject goodByType = (DynamicObject)entry.getValue();
            DynamicObjectCollection infoItems = goodByType.getDynamicObjectCollection("bdm_goods_info_item");
            GoodsInfoVo goodsInfoVoBody = MaterialInfoUtil2.generateMaterialVoBody(goodByType);
            ArrayList usedItemVos = new ArrayList();
            goodsInfoVoBody.setUsedItems(usedItemVos);
            for (DynamicObject infoItem : infoItems) {
                if (!infoItem.getString("sourcetype").equals("1")) continue;
                String code = infoItem.getString("materialtype.number");
                String name = infoItem.getString("materialtype.name");
                if (!materialTypeSet.contains(code) && !materialTypeSet.contains(name)) continue;
                GoodsInfoItemVo usedItemVo = MaterialInfoUtil2.generateMaterialItem(infoItem);
                String key = code + "&" + name;
                Set<Object> goodSet = !miUtil.materialTypeMap.containsKey(key) ? Sets.newHashSet() : miUtil.materialTypeMap.get(key);
                goodSet.add(goodsInfoVoBody);
                miUtil.materialTypeMap.put(key, goodSet);
                Set<Object> materialTypeCodeSet = !miUtil.materialTypeCodeMap.containsKey(code) ? Sets.newHashSet() : miUtil.materialTypeCodeMap.get(code);
                materialTypeCodeSet.add(key);
                miUtil.materialTypeCodeMap.put(code, materialTypeCodeSet);
                if (isBotp) continue;
                Set<Object> materialTypeNameSet = !miUtil.materialTypeNameMap.containsKey(name) ? Sets.newHashSet() : miUtil.materialTypeNameMap.get(name);
                materialTypeNameSet.add(key);
                miUtil.materialTypeNameMap.put(name, materialTypeNameSet);
            }
        }
    }
}

