/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.util;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.TextProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.imc.bdm.common.util.DBUtils;
import org.apache.commons.collections.CollectionUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class MetadataUtil {
    private static final Log logger = LogFactory.getLog(MetadataUtil.class);

    public static Boolean exists(String entityId) {
        if (StringUtils.isEmpty((CharSequence)entityId)) {
            return Boolean.FALSE;
        }
        try {
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
            return mainEntityType != null;
        }
        catch (Exception exception) {
            return Boolean.FALSE;
        }
    }

    public static List<String> getIsvEntityItems(String entityId) {
        HashSet<String> fieldList = new HashSet<String>(4);
        try {
            String sql = "select fnumber, fdata from T_META_ENTITYDESIGN T1 where fmasterid = '" + MetadataDao.getIdByNumber((String)entityId, (MetaCategory)MetaCategory.Entity) + "' and fenabled = '1' and ftype = '2'";
            List<Map<String, Object>> list = DBUtils.query(DBRoute.meta.getRouteKey(), sql);
            if (CollectionUtils.isEmpty(list)) {
                return new ArrayList<String>(1);
            }
            for (Map<String, Object> mao : list) {
                String data = (String)mao.get("FDATA");
                Document documents = DocumentHelper.parseText((String)data);
                Element entityMetadata = documents.getRootElement();
                Element items = entityMetadata.element("Items");
                List itemList = items.elements();
                for (Element item : itemList) {
                    String key;
                    if ("BillEntity".equals(item.getName()) || "BaseEntity".equals(item.getName()) || !StringUtils.isNotBlank((CharSequence)(key = item.elementText("Key")))) continue;
                    fieldList.add(key);
                }
            }
        }
        catch (Exception e) {
            logger.info("\u83b7\u53d6\u6269\u5c55\u5b57\u6bb5\u5931\u8d25{},{}", (Object)entityId, (Object)e.getMessage());
        }
        logger.info("\u83b7\u53d6\u5230\u7684\u6269\u5c55\u5b57\u6bb5 {}", (Object)String.join((CharSequence)",", fieldList));
        return new ArrayList<String>(fieldList);
    }

    public static Map<String, Map<String, Object>> getFieldMap(String entityId) {
        HashMap<String, Map<String, Object>> typeMap = new HashMap<String, Map<String, Object>>(16);
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
        if (mainEntityType != null) {
            DataEntityPropertyCollection mainPros = mainEntityType.getProperties();
            MetadataUtil.setFiledMap(mainPros, typeMap, mainEntityType);
        }
        return typeMap;
    }

    private static void setFiledMap(DataEntityPropertyCollection propertyCollection, Map<String, Map<String, Object>> typeMap, MainEntityType mainEntityType) {
        for (IDataEntityProperty property : propertyCollection) {
            HashMap<String, Object> filedMap = new HashMap<String, Object>(8);
            String fieldKey = property.getName();
            if ("id".equals(fieldKey) || "modifytime".equals(fieldKey)) continue;
            filedMap.put("fieldKey", property.getName());
            if (property.getDisplayName() != null) {
                filedMap.put("fieldName", property.getDisplayName().getLocaleValue());
            }
            if (property instanceof TextProp) {
                filedMap.put("required", ((TextProp)property).isMustInput());
                filedMap.put("fieldType", "input");
            } else if (property instanceof DateTimeProp) {
                DateTimeProp pop = (DateTimeProp)property;
                pop.createFilterFields(mainEntityType);
                DateFormat format = ((DateTimeProp)property).getDateFormat();
                filedMap.put("bizControl", format);
                filedMap.put("required", pop.isMustInput());
                filedMap.put("fieldType", pop.getFilterControlType());
            } else if (property instanceof DecimalProp) {
                DecimalProp decProp = (DecimalProp)property;
                filedMap.put("bizControl", new DecimalFormat(MetadataUtil.getFormatByScale(decProp.getScale())));
                filedMap.put("required", decProp.isMustInput());
                filedMap.put("fieldType", decProp.getFilterControlType());
            } else if (property instanceof EntryProp) {
                EntryProp entryProp = (EntryProp)property;
                DynamicObjectType dynamicObjectType = entryProp.getDynamicCollectionItemPropertyType();
                if (dynamicObjectType != null) {
                    DataEntityPropertyCollection properties = dynamicObjectType.getProperties();
                    MetadataUtil.setFiledMap(properties, typeMap, mainEntityType);
                }
            } else if (property instanceof LongProp) {
                LongProp longProp = (LongProp)property;
                filedMap.put("isRefId", longProp.isRefId());
                filedMap.put("required", longProp.isMustInput());
                filedMap.put("fieldType", longProp.getFilterControlType());
                filedMap.put("fieldValue", longProp.getDefValue());
            } else if (property instanceof BasedataProp) {
                BasedataProp basedataProp = (BasedataProp)property;
                filedMap.put("required", basedataProp.isMustInput());
                filedMap.put("fieldType", "input");
                filedMap.put("fieldValue", basedataProp.getDefValue());
            } else if (property instanceof BooleanProp) {
                BooleanProp booleanProp = (BooleanProp)property;
                filedMap.put("required", booleanProp.isMustInput());
                filedMap.put("fieldType", "radio");
            } else {
                ComboProp comboProp = (ComboProp)property;
                List comboItems = comboProp.getComboItems();
                if (comboItems != null) {
                    LinkedHashMap<String, String> items = new LinkedHashMap<String, String>(8);
                    for (ValueMapItem item : comboItems) {
                        LocaleString local = item.getName();
                        if (local == null) continue;
                        items.put(local.getLocaleValue(), item.getValue());
                    }
                    filedMap.put("fieldValue", items);
                    filedMap.put("fieldType", "checkbox");
                    if (comboProp.isComboValueCheck()) {
                        filedMap.put("fieldType", "radio");
                    }
                }
            }
            filedMap.put("helpText", null);
            typeMap.put(property.getName(), filedMap);
        }
    }

    public static String getFormatByScale(int scale) {
        return scale < 1 ? "#####0" : "#####0.00";
    }
}

