/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.HttpClientUtils;
import kd.imc.bdm.common.constant.VatInvoicePushRecord;
import kd.imc.bdm.common.constant.table.MailSettingConstant;
import kd.imc.bdm.common.dto.MultiSendResponseDTO;
import kd.imc.bdm.common.dto.SendStatusDTO;
import kd.imc.bdm.common.dto.aws.AwsConfigDTO;
import kd.imc.bdm.common.ek.EkServiceFactory;
import kd.imc.bdm.common.ek.service.SmsService;
import kd.imc.bdm.common.enums.CacheKeyEnum;
import kd.imc.bdm.common.enums.PushStatusEnum;
import kd.imc.bdm.common.enums.SmsBillStatusEnum;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.DeviceHelper;
import kd.imc.bdm.common.helper.DownLoadCenterHelper;
import kd.imc.bdm.common.helper.ImcBaseDataHelper;
import kd.imc.bdm.common.helper.ImcLicenseServiceHelper;
import kd.imc.bdm.common.helper.InvoiceFileUrlInfoHelper;
import kd.imc.bdm.common.helper.MailSettingHelper;
import kd.imc.bdm.common.helper.MsgSendAuthHelper;
import kd.imc.bdm.common.helper.SchemeHelper;
import kd.imc.bdm.common.helper.UnitTestHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.message.model.MsgResponse;
import kd.imc.bdm.common.model.InvoiceFileUrlInfo;
import kd.imc.bdm.common.service.AwsFpyService;
import kd.imc.bdm.common.service.PushFailMsgEmailService;
import kd.imc.bdm.common.util.AES128;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.HttpUtil;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.MD5;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.RandomString;
import kd.imc.bdm.common.util.RegexUtil;
import kd.imc.bdm.common.util.TaxUtils;
import kd.sdk.annotation.SdkDeprecated;

public class SendMsgEmailService {
    private static final Log LOGGER = LogFactory.getLog(SendMsgEmailService.class);
    private static final String TOKEN_URL = "base/oauth/token";
    private static final String SMS_URL = "m5/ismc/bill/send/sms?access_token=";
    private static final String EMAIL_URL = "m5/ismc/bill/send/email?access_token=";
    private static final String CACHE_KEY = "SmsEmailService_Token";
    private static final String SEND_INVOICE_DOWNLOAD_EMAIL = "m5/bill/invoice/email/and/message/send/invoicedownloadurl?access_token=";
    private static final String[] fields = new String[]{"orderno", "salertaxno", "salername", "buyername", "issuetime", "totalamount", "invoiceamount", "issuesource", "totaltax", "invoicecode", "invoiceno", "invoicetype"};
    private static final String INVOICE_URL = "invoiceurl";
    private static final String JPG_URL = "jpgurl";
    private static final String XML_URL = "xmlurl";
    private static final String PDF_URL = "pdfurl";
    private static final String OFD_URL = "ofdurl";
    public static final String DEFULT_CODE = "11886";

    @Deprecated
    public static String sendMultiMsg(DynamicObject invoiceDynamicObject, String phone, String email) {
        return SendMsgEmailService.sendMultiMsgJson(invoiceDynamicObject, phone, email).getString("pushStatus");
    }

    public static JSONObject sendMultiMsgJson(DynamicObject invoiceDynamicObject, String phone, String email) {
        return SendMsgEmailService.sendMultiMsgJson(invoiceDynamicObject, phone, email, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject sendMultiMsgJson(DynamicObject invoiceDynamicObject, String phone, String email, String batchPushFlag) {
        String pushStatus = "";
        JSONObject json = new JSONObject();
        try {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("sendPhone_" + invoiceDynamicObject.getString("invoiceno"));
                LOGGER.info("sendPhone_ " + phone + ", email " + email + "-1\u4ee3\u8868\uff1a\u586b\u5165\u7684\u4fe1\u606f\u4e3a\u7a7a\uff0c4\u4ee3\u8868\u672a\u5f00\u901a\u77ed\u4fe1\u6743\u9650\uff0c0\uff1a\u4ee3\u8868\u6210\u529f\uff0c1\uff1a\u4ee3\u8868\u5931\u8d25\uff0cx:\u4ee3\u8868\u90e8\u5206\u6210\u529f");
            }
            MultiSendResponseDTO phoneResponse = SendMsgEmailService.sendMultiPhone(invoiceDynamicObject, phone);
            MultiSendResponseDTO emailResponse = SendMsgEmailService.sendMultiEmail(invoiceDynamicObject, phone, email);
            LOGGER.info(String.format("\u77ed\u4fe1\u53d1\u9001\u7ed3\u679c\uff1a%s,\u90ae\u4ef6\u53d1\u9001\u7ed3\u679c\uff1a%s", JSONObject.toJSONString((Object)phoneResponse), JSONObject.toJSONString((Object)emailResponse)));
            pushStatus = StringUtils.isNotEmpty((CharSequence)batchPushFlag) && "1".equals(batchPushFlag) ? PushStatusEnum.underway.getCode() : SendMsgEmailService.getPushStatus(phoneResponse, emailResponse, json);
        }
        catch (MsgException e) {
            try {
                LOGGER.error("sendMsg_\u5f00\u7968\u63a8\u9001\u77ed\u4fe1\u90ae\u4ef6\u5931\u8d25", (Throwable)e);
                pushStatus = PushStatusEnum.failed.getCode();
                json.put("pushStatus", (Object)pushStatus);
            }
            catch (Throwable throwable) {
                invoiceDynamicObject.set("pushstatus", (Object)pushStatus);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{invoiceDynamicObject});
                throw throwable;
            }
            invoiceDynamicObject.set("pushstatus", (Object)pushStatus);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{invoiceDynamicObject});
        }
        invoiceDynamicObject.set("pushstatus", (Object)pushStatus);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{invoiceDynamicObject});
        return json;
    }

    public static String getPushStatus(MultiSendResponseDTO phoneRespnse, MultiSendResponseDTO emailResponse, JSONObject json) {
        String pushStatus;
        String flag;
        String phoneFlag = phoneRespnse == null ? "-1" : phoneRespnse.getFlag();
        String emailFlag = emailResponse == null ? "-1" : emailResponse.getFlag();
        switch (flag = phoneFlag + emailFlag) {
            case "00": 
            case "40": 
            case "-10": 
            case "0-1": {
                pushStatus = PushStatusEnum.success.getCode();
                break;
            }
            case "11": 
            case "-11": 
            case "41": 
            case "1-1": {
                pushStatus = PushStatusEnum.failed.getCode();
                break;
            }
            case "4-1": 
            case "-1-1": {
                pushStatus = PushStatusEnum.none.getCode();
                break;
            }
            default: {
                pushStatus = PushStatusEnum.part_success.getCode();
            }
        }
        json.put("pushStatus", (Object)pushStatus);
        if (null != emailResponse) {
            json.put("emailErrorMsg", (Object)emailResponse.getErrorMsg());
        }
        if (null != phoneRespnse) {
            json.put("phoneErrorMsg", (Object)phoneRespnse.getErrorMsg());
        }
        return pushStatus;
    }

    public static MultiSendResponseDTO sendMultiEmail(DynamicObject invoice, String phone, String email) {
        MultiSendResponseDTO sendResponse = new MultiSendResponseDTO();
        ArrayList<SendStatusDTO> statusList = new ArrayList<SendStatusDTO>();
        sendResponse.setPhonesStatus(statusList);
        String emailFlag = "-1";
        try {
            if (!StringUtils.isEmpty((CharSequence)email)) {
                String[] split;
                for (String emailSplit : split = email.split(";")) {
                    MsgResponse response = SendMsgEmailService.emailOneDefaultOrBySelf(invoice, emailSplit);
                    String oneEmailFlag = "1";
                    if (null != response) {
                        LOGGER.info(String.format("emailResponse:%s", JSONObject.toJSONString((Object)response)));
                        String string = oneEmailFlag = "0000".equals(response.getErrorCode()) ? "0" : "1";
                        if (!ErrorType.SUCCESS.getCode().equals(response.getErrorCode())) {
                            sendResponse.setErrorMsg(response.getErrorMsg());
                        }
                    }
                    if (emailFlag.equals("-1")) {
                        emailFlag = oneEmailFlag;
                    }
                    if (!emailFlag.equals(oneEmailFlag)) {
                        emailFlag = "x";
                    }
                    statusList.add(new SendStatusDTO(emailSplit, emailFlag));
                }
                invoice.set("pushtype", (Object)"1");
            }
            if (!StringUtils.isEmpty((CharSequence)email) && !StringUtils.isEmpty((CharSequence)phone)) {
                invoice.set("pushtype", (Object)"2");
            }
        }
        catch (Exception e) {
            LOGGER.error("\u53d1\u9001\u90ae\u4ef6\u5931\u8d25", (Throwable)e);
            throw new MsgException(e, ResManager.loadKDString((String)"\u53d1\u9001\u90ae\u4ef6\u5931\u8d25", (String)"SendMsgEmailService_148", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        sendResponse.setFlag(emailFlag);
        return sendResponse;
    }

    public static MultiSendResponseDTO sendMultiPhone(DynamicObject dObject, String phone) {
        MultiSendResponseDTO status = new MultiSendResponseDTO();
        ArrayList<SendStatusDTO> statusList = new ArrayList<SendStatusDTO>();
        status.setPhonesStatus(statusList);
        String phoneFlag = "-1";
        try {
            if (!StringUtils.isEmpty((CharSequence)phone)) {
                boolean isEkSms = EkServiceFactory.getSmsService() != null;
                boolean msgSendAuthByTaxNo = MsgSendAuthHelper.msgSendAuthByOrgId((Long)DynamicObjectUtil.getDynamicObjectLongValue(dObject.get("orgid")));
                LOGGER.info(String.format("sendPhone \u662f\u5426\u5f00\u542f\u77ed\u4fe1\u6743\u9650%s", msgSendAuthByTaxNo));
                int invoiceMsgAuth = ImcLicenseServiceHelper.getInvoiceMsgAuth();
                LOGGER.info(String.format("sendPhone \u662f\u5426\u5f00\u542f\u77ed\u4fe1\u8bb8\u53ef\u6743\u9650%s", invoiceMsgAuth));
                if (isEkSms || msgSendAuthByTaxNo && invoiceMsgAuth > 0) {
                    String[] phoneArray;
                    for (String onePhone : phoneArray = phone.split(";")) {
                        MsgResponse response = SendMsgEmailService.sendOneSms(dObject, onePhone);
                        String onePhoneFlag = "1";
                        if (null != response) {
                            onePhoneFlag = "0000".equals(response.getErrorCode()) ? "0" : "1";
                            LOGGER.info(String.format("phoneResponse:%s", JSONObject.toJSONString((Object)response)));
                        }
                        statusList.add(new SendStatusDTO(onePhone, onePhoneFlag));
                        if (phoneFlag.equals("-1")) {
                            phoneFlag = onePhoneFlag;
                        }
                        if (phoneFlag.equals(onePhoneFlag)) continue;
                        phoneFlag = "x";
                    }
                } else {
                    phoneFlag = "4";
                }
                dObject.set("pushtype", (Object)"0");
            }
        }
        catch (Exception e) {
            LOGGER.error("\u53d1\u9001\u77ed\u4fe1\u5931\u8d25", (Throwable)e);
            throw new MsgException(e, ResManager.loadKDString((String)"\u53d1\u9001\u77ed\u4fe1\u5931\u8d25", (String)"SendMsgEmailService_151", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        status.setFlag(phoneFlag);
        return status;
    }

    public static MsgResponse sendOneSms(DynamicObject invoice, String phone) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("sendSms-" + phone);
        }
        if (phone == null) {
            phone = invoice.getString("buyerphone");
        }
        MsgResponse response = new MsgResponse();
        DynamicObject pushRecord = VatInvoicePushRecord.getPushRecord(invoice);
        DynamicObjectCollection phoneEntryEntity = pushRecord.getDynamicObjectCollection("entryentity1");
        DynamicObject phoneEntry = phoneEntryEntity.addNew();
        phoneEntry.set("phone", (Object)VatInvoicePushRecord.getCutString(50, phone));
        phoneEntry.set("ppushtime", (Object)new Date());
        try {
            HashMap<String, Object> reqData = new HashMap<String, Object>();
            if (!RegexUtil.isMobile(phone)) {
                throw new Exception(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u7f16\u53f7\uff1a%1$s\u624b\u673a\u53f7\u7801\u4e0d\u6b63\u786e\uff1a%2$s", (String)"SendMsgEmailService_192", (String)"imc-bdm-common", (Object[])new Object[0]), invoice.getString("invoiceno"), phone));
            }
            SmsService smsService = EkServiceFactory.getSmsService();
            if (smsService != null) {
                response = smsService.sendSms(invoice, phone);
            } else {
                String smsCode = SendMsgEmailService.getSmsCode(invoice);
                reqData.put("phone", phone);
                reqData.put("smsCode", smsCode);
                InvoiceFileUrlInfo fileUrlInfo = InvoiceFileUrlInfoHelper.getFileUrlInfoByInvoice(invoice);
                HashMap<String, Object> data = new HashMap<String, Object>();
                String invoiceUrl = SendMsgEmailService.getFileType(invoice, fileUrlInfo);
                data.put(INVOICE_URL, invoiceUrl);
                data.put(JPG_URL, fileUrlInfo.getSnapshotUrl());
                if (InvoiceUtils.isAllEInvoice(invoice.getString("invoicetype"))) {
                    if (StringUtils.isEmpty((CharSequence)fileUrlInfo.getXmlUrl()) || StringUtils.isEmpty((CharSequence)fileUrlInfo.getPdfUrl()) || StringUtils.isEmpty((CharSequence)fileUrlInfo.getFileUrl())) {
                        throw new MsgException("0006", ResManager.loadKDString((String)"\u77ed\u4fe1\u53d1\u9001\u5931\u8d25,\u7248\u5f0f\u6587\u4ef6\u751f\u6210\u4e0d\u5b8c\u6574", (String)"SendMsgEmailService_213", (String)"imc-bdm-common", (Object[])new Object[0]));
                    }
                    data.put(XML_URL, fileUrlInfo.getXmlUrl());
                    data.put(PDF_URL, fileUrlInfo.getPdfUrl());
                    data.put(OFD_URL, fileUrlInfo.getFileUrl());
                }
                for (String key : fields) {
                    Object value = invoice.get(key);
                    if ("issuetime".equals(key) && value instanceof Date) {
                        Date date = (Date)value;
                        data.put(key, DateUtils.format(date));
                        continue;
                    }
                    if ("issuesource".equalsIgnoreCase(key)) {
                        if (value.equals("0") || value.equals("3") || value.equals("12")) {
                            data.put("filetype", "ofd");
                            continue;
                        }
                        if (!value.equals("1") && !value.equals("2")) continue;
                        data.put("filetype", "pdf");
                        continue;
                    }
                    data.put(key, value);
                }
                reqData.put("data", data);
                reqData.put("salertaxno", invoice.getString("salertaxno"));
                response = SendMsgEmailService.doPost(SMS_URL, reqData, phone);
            }
        }
        catch (MsgException e) {
            LOGGER.error("sendSmsFailed " + e.getErrorMsg());
            response.setErrorCode(e.getErrorCode());
            response.setErrorMsg(e.getErrorMsg());
        }
        catch (Exception e) {
            LOGGER.error("sendSmsFailed ", (Throwable)e);
            response.setErrorCode("0005");
            response.setErrorMsg(ResManager.loadKDString((String)"\u77ed\u4fe1\u53d1\u9001\u5931\u8d25", (String)"SendMsgEmailService_211", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        PushFailMsgEmailService.saveFailMsgEmail(response, invoice, phone, "sms");
        if (ErrorType.SUCCESS.getCode().equals(response.getErrorCode())) {
            phoneEntry.set("ppushstatus", (Object)"Y");
        } else {
            phoneEntry.set("ppushstatus", (Object)"N");
            phoneEntry.set("preason", (Object)(response.getErrorMsg().length() > 150 ? response.getErrorMsg().substring(0, 150) : response.getErrorMsg()));
        }
        if (StringUtils.isEmpty((CharSequence)invoice.getString("buyerphone"))) {
            invoice.set("buyerphone", (Object)phone);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{pushRecord});
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{invoice});
        return response;
    }

    private static String getFileType(DynamicObject invoice, InvoiceFileUrlInfo fileUrlInfo) {
        String invoiceUrl = fileUrlInfo.getFileUrl();
        if (InvoiceUtils.isAllEInvoice(invoice.getString("invoicetype"))) {
            DynamicObject epInfo = BusinessDataServiceHelper.loadSingle((String)"bdm_enterprise_baseinfo", (String)"", (QFilter[])new QFilter("number", "=", (Object)invoice.getString("salertaxno")).toArray());
            QFilter filter = new QFilter("epinfo", "=", epInfo.getPkValue());
            DynamicObject msgSettingDO = BusinessDataServiceHelper.loadSingle((String)"bdm_send_epinfo_setting", (String)PropertieUtil.getAllPropertiesSplitByComma("bdm_send_epinfo_setting"), (QFilter[])filter.toArray());
            if (msgSettingDO != null) {
                String fileType = msgSettingDO.getString("fileType");
                if ("0".equals(fileType)) {
                    invoiceUrl = fileUrlInfo.getPdfUrl();
                } else if ("2".equals(fileType)) {
                    invoiceUrl = fileUrlInfo.getXmlUrl();
                } else if ("3".equals(fileType)) {
                    invoiceUrl = fileUrlInfo.getSnapshotUrl();
                } else if (StringUtils.isEmpty((CharSequence)fileType)) {
                    invoiceUrl = fileUrlInfo.getPdfUrl();
                }
            }
        }
        return invoiceUrl;
    }

    public static String getSmsCode(DynamicObject invoice) {
        QFilter qFilter = new QFilter("billstatus", "=", (Object)String.valueOf(SmsBillStatusEnum.AUDIT_SUCCESS.getStatus()));
        qFilter.and("status", "=", (Object)"1");
        DynamicObject[] smsSettings = BusinessDataServiceHelper.load((String)"bdm_sms_setting", (String)"id,billno,filtertag,priority,dxnrid", (QFilter[])qFilter.toArray());
        if (0 == smsSettings.length) {
            return DEFULT_CODE;
        }
        List smsSettingList = Arrays.stream(smsSettings).sorted(Comparator.nullsLast(Comparator.comparing(e -> e.getInt("priority")))).collect(Collectors.toList());
        for (DynamicObject smsSetting : smsSettingList) {
            String filterTag = smsSetting.getString("filtertag");
            Object invoicePkValue = invoice.getPkValue();
            QFilter filter = new QFilter("id", "=", invoicePkValue);
            filter.and(SchemeHelper.getQFilerByTag(filterTag, "sim_vatinvoice"));
            DynamicObject invoiceId = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)"id", (QFilter[])filter.toArray());
            if (null == invoiceId) continue;
            return smsSetting.getString("dxnrid");
        }
        return DEFULT_CODE;
    }

    private static DynamicObject getEpInfoOrg(DynamicObject invoice) {
        DynamicObject epInfoByOrg = invoice.get("orgid") instanceof DynamicObject ? TaxUtils.getOrgDynamicObject(invoice.getDynamicObject("orgid").getLong("id")) : TaxUtils.getOrgDynamicObject(invoice.getLong("orgid"));
        return epInfoByOrg;
    }

    @SdkDeprecated
    public static String matchMailSettingByInvoice(DynamicObject invoice) {
        QFilter[] enableFilters;
        if ("sim_vatinvoice_vehicles".equals(invoice.getDataEntityType().getName())) {
            return null;
        }
        DynamicObject epInfoByOrg = SendMsgEmailService.getEpInfoOrg(invoice);
        DynamicObject epBaseInfo = epInfoByOrg.getDynamicObject("epinfo");
        if (null == epBaseInfo) {
            LOGGER.info(String.format("\u53d1\u7968\u4ee3\u7801:%s,\u53d1\u7968\u53f7\u7801:%s,\u672a\u627e\u5230\u5f00\u7968\u4f01\u4e1a\u4fe1\u606f", invoice.getString("invoicecode"), invoice.getString("invoiceno")));
            return null;
        }
        String allPropertiesSplitByComma = PropertieUtil.getAllPropertiesSplitByComma("bdm_mail", true);
        DynamicObject[] enableMailSettings = BusinessDataServiceHelper.load((String)"bdm_mail", (String)allPropertiesSplitByComma, (QFilter[])(enableFilters = new QFilter("enable", "=", (Object)MailSettingConstant.Status.ENABLE.getValue()).toArray()));
        if (null == enableMailSettings || 0 == enableMailSettings.length) {
            LOGGER.info(String.format("\u53d1\u7968\u4ee3\u7801:%s,\u53d1\u7968\u53f7\u7801:%s,\u672a\u627e\u5230\u542f\u7528\u72b6\u6001\u7684\u90ae\u4ef6\u8bbe\u7f6e", invoice.getString("invoicecode"), invoice.getString("invoiceno")));
            return null;
        }
        long orgId = epInfoByOrg.getLong("id");
        DynamicObject mailTemplateSetting = SendMsgEmailService.getMailTemplateSetting(orgId, invoice);
        if (mailTemplateSetting == null) {
            LOGGER.info(String.format("\u53d1\u7968\u4ee3\u7801:%s,\u53d1\u7968\u53f7\u7801:%s,\u672a\u5339\u914d\u5230\u542f\u7528\u72b6\u6001\u7684\u90ae\u4ef6\u8bbe\u7f6e", invoice.getString("invoicecode"), invoice.getString("invoiceno")));
            return null;
        }
        String mailSettingId = mailTemplateSetting.getString("id");
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(String.format("\u53d1\u7968\u4ee3\u7801:%s,\u53d1\u7968\u53f7\u7801:%s,\u91cd\u53d1\u81ea\u5b9a\u4e49\u90ae\u7bb1bdm_mail_settings\u2014\u2014id:%s", invoice.getString("invoicecode"), invoice.getString("invoiceno"), mailSettingId));
        }
        return mailSettingId;
    }

    private static DynamicObject getMailTemplateSetting(Long orgId, DynamicObject invoice) {
        QFilter qFilter = ImcBaseDataHelper.getBdmMailFilter(orgId).and("number", "!=", (Object)"YZYXSZ01_s");
        DynamicObject dynamicObject = MailSettingHelper.getSettingByCtrlStrategy("bdm_mail", qFilter, invoice);
        if (dynamicObject != null) {
            return dynamicObject;
        }
        return SendMsgEmailService.queryDefaultSetting();
    }

    private static DynamicObject queryDefaultSetting() {
        return BusinessDataServiceHelper.loadSingle((String)"bdm_mail", (String)PropertieUtil.getAllPropertiesSplitByComma("bdm_mail", true), (QFilter[])new QFilter("enable", "=", (Object)MailSettingConstant.Status.ENABLE.getValue()).and("number", "=", (Object)"YZYXSZ01_s").toArray());
    }

    public static MsgResponse emailMultiDefaultOrBySelf(DynamicObject invoice, String email) {
        String[] split = email.split(";");
        MsgResponse response = null;
        String emailFlag = "-1";
        for (String emailSplit : split) {
            response = SendMsgEmailService.emailOneDefaultOrBySelf(invoice, emailSplit);
            String oneEmailFlag = "1";
            if (null != response) {
                LOGGER.info(String.format("emailResponse:%s", JSONObject.toJSONString((Object)response)));
                String string = oneEmailFlag = "0000".equals(response.getErrorCode()) ? "0" : "1";
            }
            if (emailFlag.equals("-1")) {
                emailFlag = oneEmailFlag;
            }
            if (emailFlag.equals(oneEmailFlag)) continue;
            emailFlag = "x";
        }
        if ("x".equals(emailFlag)) {
            return new MsgResponse(ErrorType.FAIL.getCode(), ResManager.loadKDString((String)"\u90e8\u5206\u63a8\u9001\u6210\u529f", (String)"SendMsgEmailService_158", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        return response;
    }

    public static MsgResponse emailOneDefaultOrBySelf(DynamicObject invoice, String email) {
        DynamicObject emailObject;
        String mailSettingId = SendMsgEmailService.matchMailSettingByInvoice(invoice);
        MsgResponse msgResponse = null;
        Map<String, String> attachedMap = SendMsgEmailService.initAttachedMap(invoice);
        DynamicObject pushRecord = VatInvoicePushRecord.getPushRecord(invoice);
        DynamicObjectCollection emailEntryEntity = pushRecord.getDynamicObjectCollection("entryentity");
        DynamicObject emailEntry = emailEntryEntity.addNew();
        emailEntry.set("email", (Object)VatInvoicePushRecord.getCutString(50, email));
        emailEntry.set("epushtime", (Object)new Date());
        if (null != mailSettingId && (emailObject = BusinessDataServiceHelper.loadSingle((Object)mailSettingId, (String)"bdm_mail")) != null) {
            boolean isSendAttachement = emailObject.getBoolean("attachementsend");
            if (MailSettingConstant.SendInvoiceOption.CUSTOM_MAIL.getValue().equals(emailObject.getString("sendinvoiceoption"))) {
                if (InvoiceUtils.isAllEInvoice(invoice.getString("invoicetype")) && StringUtils.isEmpty((CharSequence)invoice.getString("pdffileurl"))) {
                    msgResponse = new MsgResponse();
                    msgResponse.setErrorCode("0006");
                    msgResponse.setErrorMsg(ResManager.loadKDString((String)"\u90ae\u4ef6\u53d1\u9001\u5931\u8d25,\u7248\u5f0f\u6587\u4ef6\u751f\u6210\u4e0d\u5b8c\u6574", (String)"SendMsgEmailService_212", (String)"imc-bdm-common", (Object[])new Object[0]));
                } else {
                    String content;
                    String template = emailObject.getString("mailtempoption");
                    emailEntry.set("epushtemplate", (Object)template);
                    String emailTitle = ResManager.loadKDString((String)"\u3010\u91d1\u8776\u53d1\u7968\u4e91\u3011\u60a8\u7533\u8bf7\u7684\u53d1\u7968\u6570\u636e\u5df2\u9001\u8fbe", (String)"SendMsgEmailService_159", (String)"imc-bdm-common", (Object[])new Object[0]);
                    if (MailSettingConstant.MailTempOption.DEFAULT_STYLE.getValue().equals(template)) {
                        content = SendMsgEmailService.makeHtmlTemp(invoice);
                    } else {
                        emailTitle = MailSettingHelper.replacePlaceholder(emailObject.getString("mailtitle"), invoice, Boolean.TRUE);
                        content = MailSettingHelper.replacePlaceholder(emailObject.getString("mailbody_tag"), invoice, Boolean.FALSE);
                    }
                    msgResponse = isSendAttachement ? SendMsgEmailService.sendAttachementEmailBySelf(email, emailTitle, content, attachedMap, emailObject) : SendMsgEmailService.sendEmailBySelf(content, email, emailObject, emailTitle);
                    if (msgResponse == null) {
                        LOGGER.info("\u672a\u5339\u914d\u5230\u90ae\u6a21\u7248");
                    }
                }
            } else {
                emailEntry.set("epushtemplate", (Object)"2");
                msgResponse = SendMsgEmailService.sendEmail(invoice, email, SendMsgEmailService.getMailLinkFormat(invoice, emailObject), isSendAttachement);
            }
        }
        if (InvoiceUtils.isAllEVehicleOrAllEUsedCar(invoice.getString("invoicetype"))) {
            emailEntry.set("epushtemplate", (Object)"2");
            msgResponse = SendMsgEmailService.sendEmail(invoice, email, ",jpgurl,ofdurl,pdfurl,xmlurl,", false);
        }
        if (msgResponse == null) {
            msgResponse = new MsgResponse();
            msgResponse.setErrorMsg(ResManager.loadKDString((String)"\u6240\u9009\u53d1\u7968\u7ec4\u7ec7\u4e0b\u672a\u627e\u5230\u5339\u914d\u7684\u90ae\u7bb1\u8bbe\u7f6e", (String)"SendMsgEmailService_161", (String)"imc-bdm-common", (Object[])new Object[0]));
            msgResponse.setErrorCode("0005");
        }
        PushFailMsgEmailService.saveFailMsgEmail(msgResponse, invoice, email, "email");
        if (ErrorType.SUCCESS.getCode().equals(msgResponse.getErrorCode())) {
            emailEntry.set("epushstatus", (Object)"Y");
        } else {
            emailEntry.set("epushstatus", (Object)"N");
            emailEntry.set("ereason", (Object)(msgResponse.getErrorMsg().length() > 150 ? msgResponse.getErrorMsg().substring(0, 150) : msgResponse.getErrorMsg()));
        }
        if (StringUtils.isEmpty((CharSequence)invoice.getString("buyeremail"))) {
            invoice.set("buyeremail", (Object)email);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{pushRecord});
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{invoice});
        return msgResponse;
    }

    public static MsgResponse redConfirmBillEmailOneDefaultOrBySelf(List<DynamicObject> redConfirmBills, String email, String mailSettingId, String emailTitle) {
        String isCusEmail;
        MsgResponse msgResponse = null;
        DynamicObject emailObject = BusinessDataServiceHelper.loadSingle((Object)mailSettingId, (String)"bdm_mail_redconfirm");
        if (emailObject != null && (isCusEmail = emailObject.getString("sendinvoiceoption")).equals(MailSettingConstant.SendInvoiceOption.CUSTOM_MAIL.getValue())) {
            String template = emailObject.getString("mailtempoption");
            if (template.equals(MailSettingConstant.MailTempOption.DEFAULT_STYLE.getValue())) {
                String mailTempDataBase = MailSettingHelper.makeRedMailContent(emailObject, redConfirmBills, Boolean.FALSE);
                msgResponse = SendMsgEmailService.sendEmailBySelf(mailTempDataBase, email, emailObject, emailTitle);
            } else if (template.equals(MailSettingConstant.MailTempOption.CUSTOM_STYLE.getValue())) {
                String mailTempDataBase = MailSettingHelper.makeRedMailContent(emailObject, redConfirmBills, Boolean.TRUE);
                if (redConfirmBills.size() == 1) {
                    emailTitle = emailObject.getString("mailtitle");
                } else if (redConfirmBills.size() >= 1) {
                    emailTitle = emailObject.getString("multimailtitle");
                }
                emailTitle = MailSettingHelper.replaceMailBody(redConfirmBills.get(0), emailTitle, Boolean.FALSE);
                msgResponse = SendMsgEmailService.sendEmailBySelf(mailTempDataBase, email, emailObject, emailTitle);
            }
            if (msgResponse == null) {
                LOGGER.info("\u672a\u5339\u914d\u5230\u90ae\u6a21\u7248");
            }
        }
        return msgResponse;
    }

    private static Map<String, String> initAttachedMap(DynamicObject invoice) {
        HashMap<String, String> attachedMap = new HashMap<String, String>();
        if (InvoiceUtils.isAllEInvoice(invoice.getString("invoicetype"))) {
            if (StringUtils.isNotEmpty((CharSequence)invoice.getString("xmlfileurl"))) {
                attachedMap.put(invoice.getString("xmlfileurl"), SendMsgEmailService.getFileName(invoice, ".zip"));
            }
            if (StringUtils.isNotEmpty((CharSequence)invoice.getString("pdffileurl"))) {
                attachedMap.put(invoice.getString("pdffileurl"), SendMsgEmailService.getFileName(invoice, ".pdf"));
            }
            if (StringUtils.isNotEmpty((CharSequence)invoice.getString("fileurl"))) {
                attachedMap.put(invoice.getString("fileurl"), SendMsgEmailService.getFileName(invoice, ".ofd"));
            }
        } else if (DeviceHelper.isOfdDevice(invoice.getString("issuesource"))) {
            if (StringUtils.isNotEmpty((CharSequence)invoice.getString("fileurl"))) {
                attachedMap.put(invoice.getString("fileurl"), SendMsgEmailService.getFileName(invoice, ".ofd"));
            }
        } else if (StringUtils.isNotEmpty((CharSequence)invoice.getString("fileurl"))) {
            attachedMap.put(invoice.getString("fileurl"), SendMsgEmailService.getFileName(invoice, ".pdf"));
        }
        return attachedMap;
    }

    public static String getFileName(DynamicObject invoice, String fileSuffix) {
        StringBuilder fileName = new StringBuilder("dzfp_");
        fileName.append(invoice.getString("invoiceno")).append("_");
        fileName.append(invoice.getString("buyername")).append("_");
        fileName.append(invoice.getBigDecimal("totalamount").setScale(2, RoundingMode.HALF_UP)).append("_");
        fileName.append(DateUtils.format(invoice.getDate("issuetime"), "yyyyMMddHHmmss"));
        return fileName.append(fileSuffix).toString();
    }

    private static String getMailLinkFormat(DynamicObject invoice, DynamicObject emailObject) {
        if (!(InvoiceUtils.isAllEVehicleOrAllEUsedCar(invoice.getString("invoicetype")) || InvoiceUtils.isAllEInvoice(invoice.getString("invoicetype")) && !AllEleAuthHelper.isElePaper(invoice.get("iselepaper")))) {
            return null;
        }
        String template = emailObject.getString("mailtempoption");
        if (!MailSettingConstant.MailTempOption.DEFAULT_STYLE.getValue().equals(template)) {
            return null;
        }
        if (!DynamicObjectUtil.checkDynamicObjectHasField(emailObject, "maillinkformat")) {
            return null;
        }
        return emailObject.getString("maillinkformat");
    }

    public static MsgResponse sendEmailBySelf(String content, String email, DynamicObject emailObject, String emailTitle) {
        LOGGER.info("sendEmail_sendEmailBySelf_" + email);
        if ("1".equals(ImcConfigUtil.getValue("sendOutLook", "sendOutLook"))) {
            return SendMsgEmailService.sendOutlook(content, email, emailObject, emailTitle);
        }
        if (emailObject.getBoolean("modernauth")) {
            return SendMsgEmailService.sendEmailByModernAuth(email, emailTitle, content, null);
        }
        MsgResponse response = new MsgResponse();
        try {
            String clientname = StringUtils.isBlank((CharSequence)emailObject.getString("clientname")) ? "\u91d1\u8776\u4e91" : emailObject.getString("clientname");
            Session emailSession = MailSettingHelper.getEmailSession(emailObject);
            MimeMessage message = SendMsgEmailService.createMimeMessage(emailSession, emailObject.getString("sendemail"), email, content, emailTitle, clientname);
            Transport.send((Message)message);
            response.setErrorCode("0000");
            response.setErrorMsg(ResManager.loadKDString((String)"\u90ae\u4ef6\u53d1\u9001\u6210\u529f", (String)"SendMsgEmailService_163", (String)"imc-bdm-common", (Object[])new Object[0]));
            LOGGER.info("sendEmail_sendEmailBySelf_success");
        }
        catch (MsgException e) {
            LOGGER.error("sendEmail_sendEmailBySelf_MsgException", (Object)e.getErrorMsg());
            response.setErrorCode(e.getErrorCode());
            response.setErrorMsg(e.getErrorMsg());
        }
        catch (Exception e) {
            LOGGER.error("sendEmail_sendEmailBySelf_\u5931\u8d25 ", (Throwable)e);
            response.setErrorCode("0005");
            response.setErrorMsg(ResManager.loadKDString((String)"\u90ae\u4ef6\u53d1\u9001\u5931\u8d25", (String)"SendMsgEmailService_165", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        return response;
    }

    public static MimeMessage createMimeMessage(Session session, String sendMail, String receiveMail, String content, String emailTitle, String clientname) throws Exception {
        MimeMessage message = new MimeMessage(session);
        message.setFrom((Address)new InternetAddress(sendMail, clientname, "UTF-8"));
        message.setRecipient(MimeMessage.RecipientType.TO, (Address)new InternetAddress(receiveMail, "\u6211", "UTF-8"));
        message.setSubject(emailTitle, "UTF-8");
        message.setContent((Object)content, "text/html;charset=UTF-8");
        message.setSentDate(new Date());
        message.saveChanges();
        return message;
    }

    public static MsgResponse sendEmail(DynamicObject invoice, String email, String mailLinkFormat, boolean isSendAttachement) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("sendEmail_" + email);
        }
        if (email == null) {
            email = invoice.getString("buyeremail");
        }
        MsgResponse response = new MsgResponse();
        try {
            HashMap<String, Object> reqData = new HashMap<String, Object>();
            reqData.put("templateType", "ismc");
            reqData.put("email", email);
            reqData.put("data", SendMsgEmailService.getDataMapByInvoice(invoice, mailLinkFormat, isSendAttachement));
            response = SendMsgEmailService.doPost(EMAIL_URL, reqData, email);
        }
        catch (MsgException e) {
            LOGGER.error("sendEmail_\u90ae\u4ef6\u53d1\u9001\u5931\u8d25", (Throwable)e);
            response.setErrorCode(e.getErrorCode());
            response.setErrorMsg(e.getErrorMsg());
        }
        catch (Exception e) {
            LOGGER.error("sendEmail_\u90ae\u4ef6\u53d1\u9001\u5931\u8d25", (Throwable)e);
            response.setErrorCode("0005");
            response.setErrorMsg(ResManager.loadKDString((String)"\u90ae\u4ef6\u53d1\u9001\u5931\u8d25", (String)"SendMsgEmailService_210", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        return response;
    }

    private static Map<String, Object> getDataMapByInvoice(DynamicObject invoice, String mailLinkFormat, boolean isSendAttachement) {
        boolean isAllEInvoice;
        InvoiceFileUrlInfo fileUrlInfo = InvoiceFileUrlInfoHelper.getFileUrlInfoByInvoice(invoice);
        HashMap<String, Object> data = new HashMap<String, Object>();
        boolean bl = isAllEInvoice = InvoiceUtils.isAllEInvoice(invoice.getString("invoicetype")) || InvoiceUtils.isAllEVehicleOrAllEUsedCar(invoice.getString("invoicetype"));
        if (isAllEInvoice && InvoiceUtils.isAllEInvoice(invoice.getString("invoicetype")) && (StringUtils.isEmpty((CharSequence)fileUrlInfo.getXmlUrl()) || StringUtils.isEmpty((CharSequence)fileUrlInfo.getPdfUrl()) || StringUtils.isEmpty((CharSequence)fileUrlInfo.getFileUrl()))) {
            throw new MsgException("0006", ResManager.loadKDString((String)"\u90ae\u4ef6\u53d1\u9001\u5931\u8d25,\u7248\u5f0f\u6587\u4ef6\u751f\u6210\u4e0d\u5b8c\u6574", (String)"SendMsgEmailService_212", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        data.put(INVOICE_URL, fileUrlInfo.getFileUrl());
        data.put(JPG_URL, fileUrlInfo.getSnapshotUrl());
        data.put(XML_URL, fileUrlInfo.getXmlUrl());
        data.put(PDF_URL, fileUrlInfo.getPdfUrl());
        if (isSendAttachement) {
            data.put("attachedFlag", "Y");
        }
        for (String key : fields) {
            Object value = invoice.get(key);
            if (InvoiceUtils.isUsedCarInvoice(invoice.getString("invoicetype"))) {
                value = SendMsgEmailService.convertValue(invoice, key, value);
            }
            if ("totalamount".equals(key) || "invoiceamount".equals(key) || "totaltax".equals(key)) {
                value = ((BigDecimal)value).setScale(2, RoundingMode.HALF_UP);
            }
            if ("issuetime".equals(key) && value instanceof Date) {
                Date date = (Date)value;
                data.put(key, DateUtils.format(date));
                continue;
            }
            if ("issuesource".equalsIgnoreCase(key)) {
                if (InvoiceUtils.isAllEInvoice(invoice.getString("invoicetype")) || InvoiceUtils.isAllEVehicleOrAllEUsedCar(invoice.getString("invoicetype"))) {
                    data.put("filetype", "ofd");
                    data.put(OFD_URL, fileUrlInfo.getFileUrl());
                    data.remove(INVOICE_URL);
                    continue;
                }
                if (DeviceHelper.isOfdDevice(String.valueOf(value))) {
                    data.put("filetype", "ofd");
                    data.put(OFD_URL, fileUrlInfo.getFileUrl());
                    continue;
                }
                data.put("filetype", "pdf");
                data.put(PDF_URL, fileUrlInfo.getFileUrl());
                continue;
            }
            data.put(key, value);
        }
        SendMsgEmailService.removeUrlByMailLinkFormat(data, mailLinkFormat);
        return data;
    }

    private static Object convertValue(DynamicObject invoice, String key, Object inputValue) {
        switch (key) {
            case "salertaxno": {
                return invoice.getString("issuetaxno");
            }
            case "salername": {
                return invoice.getString("issuename");
            }
            case "buyername": {
                if ("0".equals(invoice.getString("issueway"))) {
                    return invoice.getString("buyername");
                }
                return invoice.getString("salername");
            }
        }
        return inputValue;
    }

    private static void removeUrlByMailLinkFormat(Map<String, Object> data, String mailLinkFormat) {
        if (mailLinkFormat != null && data != null) {
            if (!mailLinkFormat.contains(PDF_URL)) {
                data.remove(PDF_URL);
            }
            if (!mailLinkFormat.contains(OFD_URL)) {
                data.remove(OFD_URL);
            }
            if (!mailLinkFormat.contains(XML_URL)) {
                data.remove(XML_URL);
            }
            if (!mailLinkFormat.contains(JPG_URL)) {
                data.remove(JPG_URL);
            }
        }
    }

    private static MsgResponse doPost(String url, Map<String, Object> data, String phone) throws Exception {
        String result;
        JSONObject json;
        AwsConfigDTO awsConfig = AwsFpyService.getAwsConfigByTaxNo(data.get("salertaxno"));
        String token = SendMsgEmailService.getToken(awsConfig, data);
        if (null == token) {
            LOGGER.info("sendMsg_\u83b7\u53d6token\u5931\u8d25");
            throw new MsgException("0002", ResManager.loadKDString((String)"\u83b7\u53d6token\u5931\u8d25", (String)"SendMsgEmailService_169", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        String reqUrl = SendMsgEmailService.getUrl(awsConfig.getUrl(), url) + token;
        String content = SerializationUtils.toJsonString(data);
        String encryptKey = awsConfig.getEncryptKey();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(String.format("sendMsg_request_%s, %s, %s", phone, reqUrl, content));
        }
        String body = AES128.ecbEncrypt(content, encryptKey);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("sendMsg_body:" + reqUrl + "  " + body);
        }
        if (UnitTestHelper.isUnitTest()) {
            json = new JSONObject();
            json.put("errcode", (Object)ErrorType.SUCCESS.getCode());
            result = json.toJSONString();
        } else {
            result = HttpUtil.doPostJson(reqUrl, awsConfig.getProxyUrl(), null, body, 15000, 15000);
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(String.format("sendMsg_result_%s, %s", phone, result));
        }
        json = JSONObject.parseObject((String)result);
        MsgResponse response = new MsgResponse();
        response.setErrorCode(json.getString("errcode"));
        response.setErrorMsg(json.getString("description"));
        return response;
    }

    private static String getToken(AwsConfigDTO awsConfig, Map<String, Object> data) {
        Object taxNo = data.get("salertaxno");
        String token = CacheHelper.get(CACHE_KEY + taxNo);
        if (StringUtils.isNotBlank((CharSequence)token)) {
            return token;
        }
        try {
            Long time = System.currentTimeMillis();
            String url = awsConfig.getUrl();
            LOGGER.info("\u83b7\u53d6AWS\u53d1\u7968\u4e91token-" + url);
            String clientId = awsConfig.getClientId();
            String clientSecret = awsConfig.getClientSecret();
            LOGGER.info(String.format("clientid:%s,clientsecret:%s", clientId, clientSecret));
            String sign = MD5.md5Hex(clientId + clientSecret + time).toLowerCase();
            HashMap<String, String> paraMap = new HashMap<String, String>();
            paraMap.put("client_id", clientId);
            paraMap.put("sign", sign);
            paraMap.put("timestamp", String.valueOf(time));
            String reqBody = SerializationUtils.toJsonString(paraMap);
            HashMap<String, String> header = new HashMap<String, String>();
            header.put("Content-Type", "application/json;charset=UTF-8");
            String result = HttpClientUtils.postjson((String)SendMsgEmailService.getUrl(url, TOKEN_URL), header, (String)reqBody, (int)10000, (int)15000);
            LOGGER.info("\u83b7\u53d6AWS\u53d1\u7968\u4e91token-response" + result);
            JSONObject json = JSONObject.parseObject((String)result);
            if (json != null && "0000".equals(json.getString("errcode"))) {
                token = json.getString("access_token");
                CacheHelper.put(CACHE_KEY + taxNo, token, 300);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6AWS\u53d1\u7968\u4e91token\u5931\u8d25", (Throwable)e);
        }
        return token;
    }

    private static String getUrl(String baseUrl, String url) {
        if (baseUrl.endsWith("/")) {
            return baseUrl + url;
        }
        return baseUrl + "/" + url;
    }

    public static void sendEmailZip(String email, String uploadZipFileUrl, ArrayList<DynamicObject> dynamicObjects, boolean isSendAttachement) throws Exception {
        SendMsgEmailService.sendEmailZip(email, uploadZipFileUrl, dynamicObjects, isSendAttachement, null);
    }

    public static void sendEmailZip(String email, String uploadZipFileUrl, ArrayList<DynamicObject> dynamicObjects, boolean isSendAttachement, DynamicObject[] pushRecords) throws Exception {
        Map<String, String> awsConfigMap = ImcConfigUtil.getValue("dim_imc_config_fpy");
        String clientId = ImcConfigUtil.getValue(awsConfigMap, "clientid", "dim_imc_config_fpy_clientid");
        String clientSecret = ImcConfigUtil.getValue(awsConfigMap, "clientsecret", "dim_imc_config_fpy_clientsecret");
        String encryptKey = ImcConfigUtil.getValue(awsConfigMap, "encryptkey", "dim_imc_config_fpy_encryptkey");
        if (StringUtils.isBlank((CharSequence)clientId) || StringUtils.isBlank((CharSequence)clientSecret)) {
            LOGGER.info("\u83b7\u53d6aws\u8bb8\u53ef\u6570\u91cf\u672a\u914d\u7f6e\u8fde\u63a5\u4fe1\u606f" + SerializationUtils.toJsonString(awsConfigMap));
        }
        AwsFpyService awsFpyService = AwsFpyService.newInstance();
        String accessToken = awsFpyService.getAccessToken(clientId, clientSecret);
        String baseUrl = awsFpyService.getBaseUrl();
        String proxy = awsFpyService.getProxy();
        String url = SendMsgEmailService.getUrl(baseUrl, SEND_INVOICE_DOWNLOAD_EMAIL) + accessToken;
        HashMap<String, String> headers = new HashMap<String, String>();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("zipFileUrl", (Object)uploadZipFileUrl);
        jsonObject.put("email", (Object)email);
        if (isSendAttachement) {
            jsonObject.put("attachedFlag", (Object)"Y");
        }
        JSONArray jsonArray = new JSONArray();
        for (DynamicObject invoiceDO : dynamicObjects) {
            JSONObject invoiceJson = new JSONObject();
            invoiceJson.put("invoiceamount", (Object)invoiceDO.getBigDecimal("invoiceamount").stripTrailingZeros());
            invoiceJson.put("totalamount", (Object)invoiceDO.getBigDecimal("totalamount").stripTrailingZeros());
            invoiceJson.put("salername", (Object)invoiceDO.getString("salername"));
            invoiceJson.put("salertaxno", (Object)invoiceDO.getString("salertaxno"));
            invoiceJson.put("invoiceno", (Object)invoiceDO.getString("invoiceno"));
            invoiceJson.put("invoicecode", (Object)invoiceDO.getString("invoicecode"));
            invoiceJson.put("buyername", (Object)invoiceDO.getString("buyername"));
            invoiceJson.put("issuetime", (Object)DateUtils.format(invoiceDO.getDate("issuetime"), "yyyy-MM-dd"));
            jsonArray.add((Object)invoiceJson);
        }
        jsonObject.put("invoiceData", (Object)jsonArray);
        String reqBody = AES128.ecbEncrypt(jsonObject.toJSONString(), encryptKey);
        String s = HttpUtil.doPostJson(url, proxy, headers, reqBody);
        LOGGER.info("sendResult:" + s);
        if (StringUtils.isBlank((CharSequence)s)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53d1\u9001\u90ae\u4ef6\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a", (String)"SendMsgEmailService_174", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        JSONObject result = JSONObject.parseObject((String)s);
        SendMsgEmailService.savePushRecords(pushRecords, ErrorType.SUCCESS.getCode().equals(result.get((Object)"errcode")), result.getString("description"));
        if (!ErrorType.SUCCESS.getCode().equals(result.get((Object)"errcode"))) {
            throw new KDBizException(result.getString("description"));
        }
    }

    public static void savePushRecords(DynamicObject[] pushRecords, boolean isSuccess, String message) {
        if (pushRecords.length == 0) {
            return;
        }
        for (DynamicObject pushRecord : pushRecords) {
            DynamicObjectCollection emailEntryEntity = pushRecord.getDynamicObjectCollection("entryentity");
            DynamicObject emailEntry = (DynamicObject)emailEntryEntity.get(emailEntryEntity.size() - 1);
            emailEntry.set("epushstatus", (Object)(isSuccess ? "Y" : "N"));
            if (isSuccess) continue;
            emailEntry.set("ereason", (Object)message);
        }
        SaveServiceHelper.save((DynamicObject[])pushRecords);
    }

    public static MsgResponse sendAttachementEmailBySelf(final String reciverEmail, String title, String content, Map<String, String> attachedMap, DynamicObject emailObject) {
        if (emailObject.getBoolean("modernauth")) {
            return SendMsgEmailService.sendEmailByModernAuth(reciverEmail, title, content, attachedMap);
        }
        if ("1".equals(ImcConfigUtil.getValue("sendOutLook", "sendOutLook"))) {
            return SendMsgEmailService.sendOutlookWithAttachment(content, reciverEmail, emailObject, title, attachedMap);
        }
        MsgResponse response = new MsgResponse();
        Session emailSession = SendMsgEmailService.getSession(emailObject);
        MimeMessage message = new MimeMessage(emailSession){

            protected void updateMessageID() throws MessagingException {
                String customMessageID = '<' + RandomString.nextString(20, true, true) + '.' + reciverEmail + '>';
                LOGGER.info("\u751f\u6210\u7684messageId\u4e3a" + customMessageID);
                this.setHeader("Message-ID", customMessageID);
            }
        };
        try {
            String clientname = StringUtils.isBlank((CharSequence)emailObject.getString("clientname")) ? "\u91d1\u8776\u4e91" : emailObject.getString("clientname");
            InternetAddress from = new InternetAddress(emailObject.getString("sendemail"), clientname);
            message.setFrom((Address)from);
            String[] reciverEmailArray = reciverEmail.split(";");
            InternetAddress[] adds = new InternetAddress[reciverEmailArray.length];
            for (int i = 0; i < reciverEmailArray.length; ++i) {
                adds[i] = new InternetAddress(reciverEmailArray[i]);
            }
            message.setRecipients(Message.RecipientType.TO, (Address[])adds);
            message.setSentDate(new Date());
            message.setSubject(title, "UTF-8");
            SendMsgEmailService.setAttachement(message, content, attachedMap);
            Transport.send((Message)message);
            response.setErrorCode("0000");
            response.setErrorMsg(ResManager.loadKDString((String)"\u90ae\u4ef6\u53d1\u9001\u6210\u529f", (String)"SendMsgEmailService_163", (String)"imc-bdm-common", (Object[])new Object[0]));
            LOGGER.info("sendEmail_sendEmailBySelf_success");
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            response.setErrorCode("0005");
            response.setErrorMsg(ResManager.loadKDString((String)"\u90ae\u4ef6\u53d1\u9001\u5931\u8d25", (String)"SendMsgEmailService_165", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        return response;
    }

    private static MsgResponse sendEmailByModernAuth(String reciverEmail, String title, String content, Map<String, String> attachedMap) {
        MsgResponse response = new MsgResponse();
        try {
            HashMap<String, Object> reqData = new HashMap<String, Object>();
            reqData.put("templateType", "ModernAuth");
            reqData.put("email", reciverEmail);
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("emailTitle", title);
            data.put("content", content);
            if (attachedMap != null) {
                for (Map.Entry<String, String> entry : attachedMap.entrySet()) {
                    String key = entry.getKey();
                    String value = entry.getValue();
                    if (!value.contains("pdf") && !value.contains("\u53d1\u7968\u538b\u7f29\u5305")) continue;
                    data.put("fileName", value);
                    data.put("pdfUrl", key);
                }
            }
            data.put("tenantId", ImcConfigUtil.getValue(CacheKeyEnum.MAIL_AUTH_TENANT));
            reqData.put("data", data);
            response = SendMsgEmailService.doPost(EMAIL_URL, reqData, reciverEmail);
        }
        catch (MsgException e) {
            LOGGER.error("sendEmail_\u90ae\u4ef6\u53d1\u9001\u5931\u8d25", (Throwable)e);
            response.setErrorCode(e.getErrorCode());
            response.setErrorMsg(e.getErrorMsg());
        }
        catch (Exception e) {
            LOGGER.error("sendEmail_\u90ae\u4ef6\u53d1\u9001\u5931\u8d25", (Throwable)e);
            response.setErrorCode("0005");
            response.setErrorMsg(ResManager.loadKDString((String)"\u90ae\u4ef6\u53d1\u9001\u5931\u8d25", (String)"SendMsgEmailService_210", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        return response;
    }

    private static Session getSession(DynamicObject emailObject) {
        final Properties properties = new Properties();
        String address = emailObject.getString("serveraddress");
        Object port = emailObject.get("port");
        String userName = emailObject.getString("username");
        String passwd = emailObject.getString("password");
        LOGGER.info(String.format("host:%s,port:%s,password:%s,username:%s", address, port, passwd, userName));
        properties.setProperty("mail.smtp.auth", "true");
        properties.setProperty("mail.smtp.host", address);
        properties.setProperty("mail.smtp.port", String.valueOf(port));
        properties.setProperty("mail.user", userName);
        properties.setProperty("mail.password", passwd);
        boolean ssl = emailObject.getBoolean("ssl");
        if (ssl) {
            properties.setProperty("mail.smtp.ssl.enable", "true");
        } else {
            properties.setProperty("mail.smtp.ssl.enable", "false");
            properties.setProperty("mail.smtp.starttls.enable", "false");
            properties.setProperty("mail.smtp.socketFactory.fallback", "false");
            properties.setProperty("mail.smtp.socketFactory.port", String.valueOf(port));
        }
        MailSettingHelper.setSendMailTimeOut(properties);
        MailSettingHelper.addProxy(properties);
        MailSettingHelper.addExtProperties(properties, address);
        Authenticator authenticator = new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                String userName = properties.getProperty("mail.user");
                String password = properties.getProperty("mail.password");
                return new PasswordAuthentication(userName, password);
            }
        };
        return Session.getInstance((Properties)properties, (Authenticator)authenticator);
    }

    public static MsgResponse sendOutlook(String content, String email, DynamicObject emailObject, String emailTitle) {
        return SendMsgEmailService.sendOutlookWithAttachment(content, email, emailObject, emailTitle, null);
    }

    public static MsgResponse sendOutlookWithAttachment(String content, String email, final DynamicObject emailObject, String emailTitle, Map<String, String> attachedMap) {
        MsgResponse response = new MsgResponse();
        try {
            Properties props = new Properties();
            props.setProperty("mail.smtp.auth", "true");
            props.setProperty("mail.smtp.starttls.enable", "true");
            props.setProperty("mail.smtp.host", emailObject.getString("serveraddress"));
            props.setProperty("mail.smtp.port", String.valueOf(emailObject.get("port")));
            MailSettingHelper.setSendMailTimeOut(props);
            Session session = Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(emailObject.getString("username"), emailObject.getString("password"));
                }
            });
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)new InternetAddress(emailObject.getString("sendemail")));
            message.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)email));
            message.setSubject(emailTitle, "UTF-8");
            if (attachedMap != null) {
                SendMsgEmailService.setAttachement(message, content, attachedMap);
            } else {
                message.setContent((Object)content, "text/html;charset=UTF-8");
            }
            Transport.send((Message)message);
            response.setErrorCode("0000");
            response.setErrorMsg(ResManager.loadKDString((String)"\u90ae\u4ef6\u53d1\u9001\u6210\u529f", (String)"SendMsgEmailService_163", (String)"imc-bdm-common", (Object[])new Object[0]));
            LOGGER.info("sendOutLookSuccess");
        }
        catch (Exception e) {
            LOGGER.error("sendOutlookError:" + e.getMessage(), (Throwable)e);
            response.setErrorCode("0005");
            response.setErrorMsg(ResManager.loadKDString((String)"\u90ae\u4ef6\u53d1\u9001\u5931\u8d25", (String)"SendMsgEmailService_165", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        return response;
    }

    private static void setAttachement(MimeMessage message, String content, Map<String, String> attachedMap) throws Exception {
        MimeBodyPart messageBodyPart = new MimeBodyPart();
        messageBodyPart.setContent((Object)content, "text/html;charset=utf-8");
        MimeMultipart multipart = new MimeMultipart();
        multipart.addBodyPart((BodyPart)messageBodyPart);
        for (Map.Entry<String, String> entry : attachedMap.entrySet()) {
            MimeBodyPart attachmentBody = new MimeBodyPart();
            attachmentBody.setHeader("Content-Disposition", "attachment; filename=\"" + MimeUtility.encodeText((String)entry.getValue()) + "\"");
            attachmentBody.setHeader("Content-Transfer-Encoding", "base64");
            attachmentBody.setHeader("Content-Type", "application/octet-stream");
            attachmentBody.setContent((Object)SendMsgEmailService.getFileBytes(entry.getKey()), "application/octet-stream");
            multipart.addBodyPart((BodyPart)attachmentBody);
        }
        message.setContent((Multipart)multipart);
    }

    private static byte[] getFileBytes(String fileUrl) throws Exception {
        try (InputStream in = null;){
            in = fileUrl.startsWith("http") ? DownLoadCenterHelper.getInputStream(fileUrl) : DownLoadCenterHelper.getLocalInputStream(fileUrl);
            byte[] byArray = DownLoadCenterHelper.inputStreamToByteArray(in);
            return byArray;
        }
    }

    private static String makeHtmlTemp(DynamicObject invoiceDO) {
        String invoiceCodeDiv = "";
        if (!StringUtils.isEmpty((CharSequence)invoiceDO.getString("invoicecode"))) {
            String s = ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801\uff1a", (String)"SendMsgEmailService_193", (String)"imc-bdm-common", (Object[])new Object[0]);
            invoiceCodeDiv = "              <tr class=\"box-cont\">\n                        <td style=\"width:80px\">" + s + "</td>\n                        <td style=\"color:#212121\">" + invoiceDO.getString("invoicecode") + "</td>\n                    </tr>\n\n";
        }
        String urlDiv = "";
        String s1 = ResManager.loadKDString((String)"PDF\u7248\u5f0f\u4e0b\u8f7d\uff1a", (String)"SendMsgEmailService_194", (String)"imc-bdm-common", (Object[])new Object[0]);
        String s2 = ResManager.loadKDString((String)"OFD\u7248\u5f0f\u4e0b\u8f7d\uff1a", (String)"SendMsgEmailService_195", (String)"imc-bdm-common", (Object[])new Object[0]);
        String s3 = ResManager.loadKDString((String)"XML\u7248\u5f0f\u4e0b\u8f7d\uff1a", (String)"SendMsgEmailService_196", (String)"imc-bdm-common", (Object[])new Object[0]);
        String s4 = ResManager.loadKDString((String)"\u7528\u79d1\u6280\u52a9\u529b\u7eff\u8272\u8d22\u7a0e\u65b0\u65f6\u4ee3", (String)"SendMsgEmailService_197", (String)"imc-bdm-common", (Object[])new Object[0]);
        String s5 = ResManager.loadKDString((String)"\u5c0a\u656c\u7684\u7528\u6237, \u60a8\u597d", (String)"SendMsgEmailService_198", (String)"imc-bdm-common", (Object[])new Object[0]);
        String s6 = ResManager.loadKDString((String)"\u60a8\u5f00\u5177\u7684\u53d1\u7968\u7248\u5f0f\u6587\u4ef6\u5df2\u7ecf\u751f\u6210\uff0c\u53d1\u7968\u4fe1\u606f\u5982\u4e0b\u6240\u793a:", (String)"SendMsgEmailService_199", (String)"imc-bdm-common", (Object[])new Object[0]);
        String s7 = ResManager.loadKDString((String)"\u53d1\u7968\u62ac\u5934\uff1a", (String)"SendMsgEmailService_200", (String)"imc-bdm-common", (Object[])new Object[0]);
        String s8 = ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801\uff1a", (String)"SendMsgEmailService_201", (String)"imc-bdm-common", (Object[])new Object[0]);
        String s9 = ResManager.loadKDString((String)"\u5f00\u7968\u65f6\u95f4\uff1a", (String)"SendMsgEmailService_202", (String)"imc-bdm-common", (Object[])new Object[0]);
        String s10 = ResManager.loadKDString((String)"\u5f00\u7968\u91d1\u989d\uff1a", (String)"SendMsgEmailService_203", (String)"imc-bdm-common", (Object[])new Object[0]);
        String s11 = ResManager.loadKDString((String)"\u8bf7\u70b9\u51fb\u4e0b\u9762\u7684\u5730\u5740\u4e0b\u8f7d\u9700\u8981\u7684\u683c\u5f0f\uff0c\u4ee5\u4fbf\u4f5c\u4e3a\u60a8\u7ef4\u6743\u51ed\u8bc1\u548c\u62a5\u9500\u51ed\u8bc1", (String)"SendMsgEmailService_204", (String)"imc-bdm-common", (Object[])new Object[0]);
        String s12 = ResManager.loadKDString((String)"\u5982\u70b9\u51fb\u65e0\u6548\uff0c\u8bf7\u590d\u5236\u94fe\u63a5\u5730\u5740\u5230\u6d4f\u89c8\u5668\u4e2d\u6253\u5f00", (String)"SendMsgEmailService_205", (String)"imc-bdm-common", (Object[])new Object[0]);
        String s13 = ResManager.loadKDString((String)"\u53d1\u7968\u56fe\u7247\u4e0b\u8f7d\uff1a", (String)"SendMsgEmailService_206", (String)"imc-bdm-common", (Object[])new Object[0]);
        String s14 = ResManager.loadKDString((String)"\u5fae\u4fe1\u626b\u4e00\u626b\u9886\u53d6\u53d1\u7968", (String)"SendMsgEmailService_207", (String)"imc-bdm-common", (Object[])new Object[0]);
        String s15 = ResManager.loadKDString((String)"\u6e29\u99a8\u63d0\u793a", (String)"SendMsgEmailService_208", (String)"imc-bdm-common", (Object[])new Object[0]);
        String s16 = ResManager.loadKDString((String)"OFD\u7248\u5f0f\u6587\u4ef6\u7535\u5b50\u53d1\u7968\uff0c\u9700\u589e\u503c\u7a0e\u7535\u5b50\u53d1\u7968OFD\u9605\u8bfb\u5668\u624d\u80fd\u6253\u5f00\uff0c\u70b9\u51fb\u4e0b\u65b9\u94fe\u63a5\u4e0b\u8f7d\u9605\u8bfb\u5668\uff1a", (String)"SendMsgEmailService_209", (String)"imc-bdm-common", (Object[])new Object[0]);
        urlDiv = InvoiceUtils.isAllEInvoice(invoiceDO.getString("invoicetype")) ? "                <div class=\"link\">\n                    <p class=\"link_title\" class='box-product-item'>" + s1 + "</p>\n                    <a class=\\\"link_name\\\" href=" + invoiceDO.getString("pdffileurl") + " target=\\\"_blank\\\">" + invoiceDO.getString("pdffileurl") + "</a>\n                </div>\n                <div class=\"link\">\n                    <p class=\"link_title\" class='box-product-item'>" + s2 + "</p>\n                    <a class=\\\"link_name\\\" href=" + invoiceDO.getString("fileurl") + " target=\\\"_blank\\\">" + invoiceDO.getString("fileurl") + "</a>\n                </div>\n                <div class=\"link\">\n                    <p class=\"link_title\" class='box-product-item'>" + s3 + "</p>\n                    <a class=\\\"link_name\\\" href=" + invoiceDO.getString("xmlfileurl") + " target=\\\"_blank\\\">" + invoiceDO.getString("xmlfileurl") + "</a>\n                </div>\n" : "                <div class=\"link\">\n                    <p class=\"link_title\" class='box-product-item'>" + s1 + "</p>\n                    <a class=\\\"link_name\\\" href=" + invoiceDO.getString("fileurl") + " target=\\\"_blank\\\">" + invoiceDO.getString("fileurl") + "</a>\n                </div>\n";
        return "<html lang=\"en\">\n    <head>\n        <meta charset=\"UTF-8\" />\n        <meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge\"/>\n        <meta name=\"viewport\" content=\"maximum-scale=1.0,minimum-scale=1.0,user-scalable=0,width=device-width,initial-scale=1.0\"/>\n        <style type=\"text/css\">\n            *{margin: 0;padding: 0;}\n            body { width: 100%;background: #f8f8f8;padding: 0;margin: 0; }\n            p { margin: 0; padding: 0; }\n            .container {width: 90%; min-width: 1200px;margin: 0 auto;background: #fff;}\n            .header {background: #5582f3;font-size: 14px;color: #d9d9d9;padding: 13px 150px;box-sizing: border-box;}\n            .header img {height: 24px;width: auto;vertical-align: middle;}\n            .content {width: 100%;margin: 0 auto; padding: 0 150px;box-sizing: border-box;}\n            .content .linkCont {width: 100%;position: relative;}\n            .content .linkCont .link_txt {width: 600px;}\n            .content .linkCont .imgIcon {width: 120px;height: auto;font-size: 12px;color: #999;position: absolute;right: 10px;top: 10px;}\n            .content .linkCont .imgIcon img {width: 120px;height: 120px;}\n            .nav {font-size: 16px;font-weight: 600;color: #212121;margin-top: 40px;margin-bottom: 12px;}\n            .tips {font-size: 14px;font-weight: 400;color: #212121;margin-bottom: 4px;}\n            .title {font-size: 18px;font-weight: 600;color: #212121;}\n            .box {\n            background: #f2f6ff;\n            padding: 16px 24px;\n            margin-top: 8px;\n            margin-bottom: 40px;\n            border-radius: 8px;\n            -webkit-border-radius: 8px;\n            position: relative;\n            }\n            .box .box_title {font-size: 14px;font-weight: bold;margin-bottom: 10px;}\n            .box .box-cont {color: #666;margin-bottom: 10px;font-size: 16px;}\n            .box .box_tips {font-size: 16px;line-height: 26px;color: #666;}\n            .link {margin-top: 16px;}\n            .link .link_title {font-size: 14px;font-weight: bold;}\n            .link .link_name {cursor: pointer;color: #3598ff;font-size: 16px;}\n            .link .link_name:hover {color: #86d9f0;}\n            .box .box-txt {margin-left: 5px;color: #212121;}\n            .second_title {color: #212121;font-weight: bold;}\n        </style>\n    </head>\n    <body>\n        <div class='container'>\n            <div class='header'>\n                <img src=\"https://img.piaozone.com/static/gallery/img/digital/pic_logo.png\" alt=\"slogan\" />\n                <span style=\"display: inline-block;margin: 0 10px; width:1px;height: 12px;background-color: #d9d9d9;\"></span>\n                <span>" + s4 + "</span>\n            </div>\n            <div class='content'>\n                <p class='nav'>" + s5 + "</p>\n                <p class='tips'>" + s6 + "</p>\n                <table class=\"box\" style=\"width:100%;background: #f2f6ff;padding: 16px 24px;margin-top: 8px;margin-bottom: 40px;border-radius: 8px;-webkit-border-radius: 8px;position: relative;\">\n                    <tr class=\"box-cont\">\n                        <td style=\"width:80px\">" + s7 + "</td>\n                        <td style=\"color:#212121\">" + invoiceDO.getString("buyername") + "</td>\n                    </tr>\n" + invoiceCodeDiv + "                <tr class=\"box-cont\">\n                    <td style=\"width:80px\">" + s8 + "</td>\n                    <td style=\"color:#212121\">" + invoiceDO.getString("invoiceno") + "</td>\n                </tr>\n                <tr class=\"box-cont\">\n                    <td style=\"width:80px\">" + s9 + "</td>\n                    <td style=\"color:#212121\">" + DateUtils.format(invoiceDO.getDate("issuetime"), "yyyy-MM-dd") + "</td>\n                </tr>\n                <tr class=\"box-cont\">\n                    <td style=\"width:80px\">" + s10 + "</td>\n                    <td style=\"color:#212121\">" + invoiceDO.getBigDecimal("totalamount").setScale(2, RoundingMode.HALF_UP).toPlainString() + "</td>\n                </tr>\n            </table>\n            <div class=\"linkCont\">\n                <div class=\"link_txt\">\n                    <p class=\"second_title\" style=\"margin-top:40px;margin-bottom: 8px;\">" + s11 + "</p>\n                    <span class=\"tips\">" + s12 + "</span>\n                    <div class=\"link\">\n                        <p class=\"link_title\" class='box-product-item'>" + s13 + "</p>\n                        <a class=\"link_name\" href=" + invoiceDO.getString("snapshoturl") + " target=\"_blank\">" + invoiceDO.getString("snapshoturl") + "</a>\n                    </div>\n" + urlDiv + "</div>\n    <div class=\"imgIcon\" style=\"display: none;\">\n    <img src= \"https://img.piaozone.com/static/gallery/img/digital/get_invoices.png\" alt=\"\u53d6\u7968\">n    <p>" + s14 + "</p>\n    </div>\n</div>\n<div class='box' style=\"margin-top:24px\">\n<p class=\"box_title\">" + s15 + "</p>\n<p class=\"box_tips\">" + s16 + "</p>\n<a class=\"box_tips\" href=\"https://guangdong.chinatax.gov.cn/gdsw/mmsw_xzfw/2022-11/23/content_bceb9b78d80e46a89d0b41a9abdf469e.shtml\" target=\"_blank\">https://guangdong.chinatax.gov.cn/gdsw/mmsw_xzfw/2022-11/23/content_bceb9b78d80e46a89d0b41a9abdf469e.shtml</a>\n</div>\n</div>\n<table\nclass=\"footer\"\nstyle=\"background: #2a395d;padding-top: 32px;height: 170px;padding: 24px 150px;box-sizing: border-box;width: 100%;\">\n<div style='${ofdDisplay!\"\"}'>\n<tbody>\n    <tr>\n        <td>\n            <a href=\"https://www.kdfpy.com\"><img src= \"https://img-sit.piaozone.com/static/gallery/img/digital/banner.png\" alt=\"banner\"></a>\n        </td>\n    </tr>\n</tbody>\n</div>\n</table>\n</div>\n</body>\n</html>";
    }
}

