/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.util;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.bdm.common.constant.EnterpriseQualificationEnum;
import kd.imc.bdm.common.constant.PermissionEnum;
import kd.imc.bdm.common.constant.ShowTipsConstant;
import kd.imc.bdm.common.dto.SaleAddrAndPayeeDTO;
import kd.imc.bdm.common.helper.EquipmentHelper;
import kd.imc.bdm.common.model.SaleInfo;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.sdk.annotation.SdkDeprecated;
import org.apache.commons.collections.CollectionUtils;

public class TaxUtils {
    private static final Log logger = LogFactory.getLog(TaxUtils.class);
    private static final Set<String> tobaccoMarkSet = Sets.newHashSet((Object[])new String[]{EnterpriseQualificationEnum.TOBACCO_PRODUCE.getCode(), EnterpriseQualificationEnum.TOBACCO_WHOLESALE.getCode()});
    private static final Set<String> OIL_TYPES = Sets.newHashSet((Object[])new String[]{EnterpriseQualificationEnum.OIL_WHOLESALE.getCode(), EnterpriseQualificationEnum.OIL_STORAGE.getCode(), EnterpriseQualificationEnum.CRUDE_OIL_STORAGE.getCode(), EnterpriseQualificationEnum.CRUDE_OIL_SALE.getCode()});

    public static DynamicObject getOrgDynamicObject(Long orgId) {
        QFilter qFilter = new QFilter("id", "=", (Object)orgId);
        return TaxUtils.getOrgDynamicObject(qFilter);
    }

    public static DynamicObject getOrgDynamicObjectByOrgNumber(String orgNumber) {
        QFilter qFilter = new QFilter("number", "=", (Object)orgNumber);
        return TaxUtils.getOrgDynamicObject(qFilter);
    }

    public static DynamicObject getOrgDynamicObjectByTaxNo(String taxNo) {
        QFilter filter = new QFilter("epinfo.number", "=", (Object)taxNo);
        filter.and("enterprisemainorg", "=", (Object)"1");
        DynamicObject orgDynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"bdm_org", (String)PropertieUtil.getAllPropertiesSplitByComma("bdm_org"), (QFilter[])filter.toArray());
        if (orgDynamicObject == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7a0e\u53f7\u672a\u5173\u8054\u7ec4\u7ec7", (String)"TaxUtils_0", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        return orgDynamicObject;
    }

    private static DynamicObject getOrgDynamicObject(QFilter qFilter) {
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)"bdm_org", (String)PropertieUtil.getAllPropertiesSplitByComma("bdm_org"), (QFilter[])qFilter.toArray());
        if (obj == null) {
            throw new KDBizException(ShowTipsConstant.getORG_NOT_IMPORT());
        }
        return obj;
    }

    public static DynamicObject getEpInfoByOrg(Long orgId) {
        DynamicObject orgObj = TaxUtils.getOrgDynamicObject(orgId);
        return TaxUtils.getEpInfoByOrg(orgObj);
    }

    public static DynamicObject getEpInfoByOrg(DynamicObject orgObj) {
        DynamicObject epInfo;
        DynamicObject epBaseInfo = orgObj.getDynamicObject("epinfo");
        if (epBaseInfo != null && (epInfo = BusinessDataServiceHelper.loadSingle((String)"bdm_enterprise_info", (String)"id", (QFilter[])new QFilter("epinfo", "=", epBaseInfo.getPkValue()).toArray())) != null) {
            return BusinessDataServiceHelper.loadSingle((Object)epInfo.getPkValue(), (String)"bdm_enterprise_info");
        }
        return null;
    }

    @SdkDeprecated
    public static SaleInfo getSaleInfoByOrg(Long orgId) {
        DynamicObject orgObj = TaxUtils.getOrgDynamicObject(orgId);
        try {
            return TaxUtils.getSaleInfoByOrgDynamicObject(orgObj);
        }
        catch (KDBizException e) {
            throw new KDBizException(e.getMessage());
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u4f01\u4e1a\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            throw new KDBizException(ShowTipsConstant.getORG_UNBIND_ENTERPRISE());
        }
    }

    public static String getCurrentOrgTaxNo() {
        Long orgId = RequestContext.get().getOrgId();
        DynamicObject orgObj = BusinessDataServiceHelper.loadSingle((String)"bdm_org", (String)PropertieUtil.getAllPropertiesSplitByComma("bdm_org"), (QFilter[])new QFilter("id", "=", (Object)orgId).toArray());
        DynamicObject epinfo = orgObj.getDynamicObject("epinfo");
        if (epinfo == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u7528\u6237\u7ed1\u5b9a\u7684\u4f01\u4e1a\u7a0e\u53f7\uff0c\u8bf7\u786e\u8ba4\u7ec4\u7ec7\u5df2\u7ed1\u5b9a\u4f01\u4e1a\uff01", (String)"TaxUtils_1", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        return epinfo.getString("number");
    }

    public static SaleInfo getSaleInfoByOrg() {
        return TaxUtils.getSaleInfoByOrg(RequestContext.get().getOrgId());
    }

    public static SaleInfo getSaleInfoByOrgDynamicObject(DynamicObject orgDynamicObject) {
        DynamicObject epBaseInfo = orgDynamicObject.getDynamicObject("epinfo");
        if (epBaseInfo == null) {
            throw new KDBizException(ShowTipsConstant.getORG_UNBIND_ENTERPRISE());
        }
        return TaxUtils.warpSaleInfoData(orgDynamicObject, epBaseInfo);
    }

    private static SaleInfo warpSaleInfoData(DynamicObject orgDynamicObject, DynamicObject epBaseInfo) {
        SaleInfo saleInfo = new SaleInfo();
        String taxNo = epBaseInfo.getString("number");
        saleInfo.setSaleTaxNo(taxNo);
        saleInfo.setSaleName(epBaseInfo.getString("name"));
        String defaultDev = orgDynamicObject.getString("defaultdev");
        if (EquipmentHelper.isEnable(taxNo, defaultDev)) {
            saleInfo.setDefaultDev(defaultDev);
            saleInfo.setDefaultTerminal(orgDynamicObject.getString("defaultterminal"));
        }
        saleInfo.setOrgId(orgDynamicObject.getLong("id"));
        QFilter qFilter = new QFilter("epinfo", "=", epBaseInfo.getPkValue()).and("authstate", "=", (Object)"1").and("servergroup", "=", (Object)PermissionEnum.ISSUE_INVOICE_SERVICE.getPermissionNo());
        if (!QueryServiceHelper.exists((String)"bdm_invoice_permission", (QFilter[])qFilter.toArray())) {
            throw new KDBizException(String.format(ShowTipsConstant.getTAXNO_UN_AUTH(), taxNo));
        }
        String devListTag = orgDynamicObject.getString("devlist_tag");
        if (!kd.bos.orm.util.StringUtils.isEmpty((Object)devListTag)) {
            String[] split = devListTag.split(",");
            List<Long> bindDevList = Stream.of(split).filter(StringUtils::isNotBlank).map(Long::valueOf).collect(Collectors.toList());
            saleInfo.setDevNoList(bindDevList);
        }
        return saleInfo;
    }

    public static SaleInfo getSaleInfoByTaxNo(String taxNo) {
        return TaxUtils.getSaleInfoByTaxNoAndOrgCode(taxNo, null);
    }

    public static SaleInfo getSaleInfoByTaxNoAndOrgCode(String taxNo, String orgCode) {
        QFilter[] filter = kd.bos.orm.util.StringUtils.isEmpty((Object)orgCode) ? new QFilter("epinfo.number", "=", (Object)taxNo).and("enterprisemainorg", "=", (Object)"1").toArray() : new QFilter("epinfo.number", "=", (Object)taxNo).and("number", "=", (Object)orgCode).toArray();
        DynamicObject orgDO = BusinessDataServiceHelper.loadSingle((String)"bdm_org", (String)String.join((CharSequence)",", "id", "defaultdev", "devlist_tag", "defaultterminal", "epinfo.name", "epinfo.number"), (QFilter[])filter);
        if (orgDO == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7a0e\u53f7%s\u4e0d\u5b58\u5728", (String)"TaxUtils_2", (String)"imc-bdm-common", (Object[])new Object[0]), taxNo));
        }
        SaleInfo saleInfo = TaxUtils.warpSaleInfoData(orgDO, orgDO.getDynamicObject("epinfo"));
        DynamicObject saleAddrBankByOrg = TaxUtils.getSaleAddrBankByOrg(saleInfo);
        if (saleAddrBankByOrg != null) {
            saleInfo.setSaleAddrAndPhone(saleAddrBankByOrg.getString("invoiceaddr"));
            saleInfo.setSaleBankAndBankAcc(saleAddrBankByOrg.getString("openuserbank"));
        }
        return saleInfo;
    }

    public static DynamicObject getSaleAddrBankByOrg(SaleInfo saleInfo) {
        QFilter qFilter = new QFilter("ischeck", "=", (Object)"1");
        qFilter.and("taxno", "=", (Object)saleInfo.getSaleTaxNo());
        return BusinessDataServiceHelper.loadSingle((String)"sim_invoice_setting", (String)String.join((CharSequence)",", "id", "invoiceaddr", "openuserbank"), (QFilter[])qFilter.toArray());
    }

    public static DynamicObject[] getSaleAddrBankArrByOrg(SaleInfo saleInfo) {
        QFilter qFilter = new QFilter("taxno", "=", (Object)saleInfo.getSaleTaxNo());
        return BusinessDataServiceHelper.load((String)"sim_invoice_setting", (String)String.join((CharSequence)",", "id", "invoiceaddr", "openuserbank", "filter_tag", "ischeck"), (QFilter[])qFilter.toArray());
    }

    public static DynamicObject getPayeeByOrg(SaleInfo saleInfo) {
        QFilter qFilter = new QFilter("drawerid", "=", (Object)RequestContext.get().getUserId());
        qFilter.and("taxno", "=", (Object)saleInfo.getSaleTaxNo());
        return BusinessDataServiceHelper.loadSingle((String)"sim_drawer_setting", (String)"payee,reviewer", (QFilter[])qFilter.toArray());
    }

    public static DynamicObject getEnterpriseDynamicObjectByOrg(Long orgId) {
        DynamicObject orgObj = TaxUtils.getOrgDynamicObject(orgId);
        DynamicObject epInfo = orgObj.getDynamicObject("epinfo");
        if (epInfo == null) {
            throw new KDBizException(ShowTipsConstant.getORG_UNBIND_ENTERPRISE());
        }
        return epInfo;
    }

    public static SaleAddrAndPayeeDTO getDefaultAddrAndPayee(SaleInfo saleInfo) {
        if (saleInfo == null) {
            saleInfo = TaxUtils.getSaleInfoByOrg();
        }
        DynamicObject invoiceSettingObj = TaxUtils.getSaleAddrBankByOrg(saleInfo);
        String invoiceAddr = "";
        String openuserbank = "";
        if (invoiceSettingObj != null) {
            invoiceAddr = invoiceSettingObj.getString("invoiceaddr");
            openuserbank = invoiceSettingObj.getString("openuserbank");
        }
        return new SaleAddrAndPayeeDTO(saleInfo.getSaleName(), saleInfo.getSaleTaxNo(), openuserbank, invoiceAddr);
    }

    public static boolean isTobaccoEnterprise(Long orgId) {
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)"bdm_org", (String)PropertieUtil.getAllPropertiesSplitByComma("bdm_org"), (QFilter[])new QFilter("id", "=", (Object)orgId).toArray());
        if (obj == null) {
            return false;
        }
        return TaxUtils.isTobaccoEnterprise(obj.getString("epinfo.number"));
    }

    public static boolean isOilEnterprise(Long orgId) {
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)"bdm_org", (String)PropertieUtil.getAllPropertiesSplitByComma("bdm_org"), (QFilter[])new QFilter("id", "=", (Object)orgId).toArray());
        if (obj == null) {
            return false;
        }
        return TaxUtils.isOilEnterpriseByTaxNo(obj.getString("epinfo.number"));
    }

    public static boolean isTobaccoEnterprise(DynamicObject epBaseInfo) {
        DynamicObject epInfoDynamicObject = TaxUtils.getEpInfoDynamicObject(epBaseInfo);
        if (epInfoDynamicObject != null) {
            String tobaccoMark = epInfoDynamicObject.getString("tobaccomark");
            if (EnterpriseQualificationEnum.TOBACCO_PRODUCE.getCode().equals(tobaccoMark) || EnterpriseQualificationEnum.TOBACCO_WHOLESALE.getCode().equals(tobaccoMark)) {
                Date endDate = epInfoDynamicObject.getDate("tobaccoexpireendtime");
                Date startDate = epInfoDynamicObject.getDate("tobaccoexpirestarttime");
                int compareEndDate = DateUtils.compare(endDate, new Date());
                int compareStartDate = DateUtils.compare(startDate, new Date());
                return compareEndDate > 0 && compareStartDate <= 0;
            }
        }
        return false;
    }

    private static DynamicObject getEpInfoDynamicObject(DynamicObject epBaseInfo) {
        if (epBaseInfo == null) {
            return null;
        }
        DynamicObject epInfo = BusinessDataServiceHelper.loadSingle((String)"bdm_enterprise_info", (String)"id", (QFilter[])new QFilter("epinfo", "=", epBaseInfo.getPkValue()).toArray());
        if (epInfo == null) {
            return null;
        }
        return BusinessDataServiceHelper.loadSingle((Object)epInfo.getPkValue(), (String)"bdm_enterprise_info");
    }

    public static boolean isTobaccoEnterprise(String taxNo) {
        DynamicObject epBaseInfo = BusinessDataServiceHelper.loadSingle((String)"bdm_enterprise_baseinfo", (String)"id", (QFilter[])new QFilter("number", "=", (Object)taxNo).toArray());
        return TaxUtils.isTobaccoEnterprise(epBaseInfo);
    }

    public static boolean isTobaccoGoods(String taxGoodsCode) {
        return taxGoodsCode.startsWith("10304020");
    }

    public static boolean isTobaccoMark(String tobaccoMark) {
        return tobaccoMarkSet.contains(tobaccoMark);
    }

    public static boolean isPurchaseEnterpriseByTaxNo(String taxNo) {
        DynamicObject epBaseInfo = BusinessDataServiceHelper.loadSingle((String)"bdm_enterprise_baseinfo", (String)"id", (QFilter[])new QFilter("number", "=", (Object)taxNo).toArray());
        DynamicObject epInfoDynamicObject = TaxUtils.getEpInfoDynamicObject(epBaseInfo);
        if (epInfoDynamicObject != null) {
            return TaxUtils.isPurchaseEnterprise(epInfoDynamicObject.getString("tobaccomark"));
        }
        return false;
    }

    public static boolean isOilEnterpriseByTaxNo(String taxNo) {
        DynamicObject epBaseInfo = BusinessDataServiceHelper.loadSingle((String)"bdm_enterprise_baseinfo", (String)"id", (QFilter[])new QFilter("number", "=", (Object)taxNo).toArray());
        DynamicObject epInfoDynamicObject = TaxUtils.getEpInfoDynamicObject(epBaseInfo);
        if (null != epInfoDynamicObject) {
            return TaxUtils.isOilEnterprise(epInfoDynamicObject.getString("tobaccomark"));
        }
        return false;
    }

    public static boolean isPurchaseEnterprise(String tobaccoMark) {
        return EnterpriseQualificationEnum.PURCHASE.getCode().equals(tobaccoMark);
    }

    public static boolean isOilEnterprise(String tobaccoMark) {
        return OIL_TYPES.contains(tobaccoMark);
    }

    public static boolean isPurchaseInvoice(String specialType) {
        return "02".equals(specialType);
    }

    public static DynamicObject queryOrgByTaxNo(String taxNo, String name) {
        QFilter filter = new QFilter("epinfo.number", "=", (Object)taxNo);
        filter.and("name", "=", (Object)name);
        DynamicObjectCollection orgs = QueryServiceHelper.query((String)"bdm_org", (String)String.join((CharSequence)",", "id", "number"), (QFilter[])filter.toArray());
        if (orgs.size() > 1) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7a0e\u53f7\uff1a%s \u5bf9\u5e94\u7ec4\u7ec7\u4e0d\u552f\u4e00", (String)"TaxUtils_3", (String)"imc-bdm-common", (Object[])new Object[0]), taxNo));
        }
        if (CollectionUtils.isEmpty((Collection)orgs)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7a0e\u53f7\uff1a%s \u7ec4\u7ec7\u4e0d\u5b58\u5728", (String)"TaxUtils_4", (String)"imc-bdm-common", (Object[])new Object[0]), taxNo));
        }
        return (DynamicObject)orgs.get(0);
    }

    public static Map<Long, SaleInfo> getOrgPkSaleInfoMap(List<Long> orgPks) {
        DynamicObject[] permissions;
        HashMap<Long, SaleInfo> result = new HashMap<Long, SaleInfo>(orgPks.size());
        if (CollectionUtils.isEmpty(orgPks)) {
            return result;
        }
        QFilter filter = new QFilter("id", "in", orgPks);
        String orgFields = "defaultdev,epinfo,defaultterminal,devlist_tag";
        DynamicObject[] orgs = BusinessDataServiceHelper.load((String)"bdm_org", (String)orgFields, (QFilter[])filter.toArray());
        HashSet<Object> epInfoPkSet = new HashSet<Object>();
        HashMap<Object, DynamicObject> epPkObjMap = new HashMap<Object, DynamicObject>();
        HashMap<Object, DynamicObject> epPkOrgMap = new HashMap<Object, DynamicObject>();
        for (DynamicObject org : orgs) {
            DynamicObject epBaseInfo = org.getDynamicObject("epinfo");
            if (epBaseInfo == null) continue;
            epInfoPkSet.add(epBaseInfo.getPkValue());
            epPkObjMap.put(epBaseInfo.getPkValue(), epBaseInfo);
            epPkOrgMap.put(epBaseInfo.getPkValue(), org);
        }
        QFilter epFilter = new QFilter("epinfo", "in", epInfoPkSet);
        String permissionFields = "epinfo,authstate,servergroup";
        for (DynamicObject permission : permissions = BusinessDataServiceHelper.load((String)"bdm_invoice_permission", (String)permissionFields, (QFilter[])epFilter.toArray())) {
            String authState = permission.getString("authstate");
            String serverGroup = permission.getString("servergroup");
            DynamicObject epInfo = permission.getDynamicObject("epinfo");
            if (!"1".equals(authState) || !PermissionEnum.ISSUE_INVOICE_SERVICE.getPermissionNo().equals(serverGroup)) continue;
            Object pk = epInfo.getPkValue();
            DynamicObject orgEpInfo = (DynamicObject)epPkObjMap.get(pk);
            SaleInfo saleInfo = new SaleInfo();
            String taxNo = orgEpInfo.getString("number");
            saleInfo.setSaleTaxNo(taxNo);
            saleInfo.setSaleName(orgEpInfo.getString("name"));
            DynamicObject orgDynamicObject = (DynamicObject)epPkOrgMap.get(pk);
            String defaultDev = orgDynamicObject.getString("defaultdev");
            if (EquipmentHelper.isEnable(taxNo, defaultDev)) {
                saleInfo.setDefaultDev(defaultDev);
                saleInfo.setDefaultTerminal(orgDynamicObject.getString("defaultterminal"));
            }
            saleInfo.setOrgId(orgDynamicObject.getLong("id"));
            String devListTag = orgDynamicObject.getString("devlist_tag");
            if (!kd.bos.orm.util.StringUtils.isEmpty((Object)devListTag)) {
                String[] split = devListTag.split(",");
                List<Long> bindDevList = Stream.of(split).filter(StringUtils::isNotBlank).map(Long::valueOf).collect(Collectors.toList());
                saleInfo.setDevNoList(bindDevList);
            }
            result.put(orgDynamicObject.getLong("id"), saleInfo);
        }
        return result;
    }

    public static boolean isEnterpriseAuth(Object epInfoId) {
        QFilter filter = new QFilter("authstate", "=", (Object)"1").and("servergroup", "=", (Object)"0");
        filter.and("epinfo", "=", epInfoId);
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)"bdm_invoice_permission", (String)"epinfo", (QFilter[])filter.toArray());
        return objs.length > 0;
    }
}

