/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.invsm.formplugin.callback;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.imc.bdm.common.constant.ImcPermItemEnum;
import kd.imc.bdm.common.dto.CallbackLogVo;
import kd.imc.bdm.common.enums.CallBackLogTypeEnum;
import kd.imc.bdm.common.helper.BotpHelper;
import kd.imc.bdm.common.helper.PermissionHelper;
import kd.imc.bdm.common.helper.callback.SendCallBackHelper;
import kd.imc.bdm.common.util.CallbackHelperUtil;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.ViewUtil;

public class InvCallbackLogListPlugin
extends AbstractListPlugin {
    private static final Log LOGGER = LogFactory.getLog(InvCallbackLogListPlugin.class);

    public void itemClick(ItemClickEvent evt) {
        if (evt.getItemKey().equals("btn_callback")) {
            PermissionHelper.checkPermission((AbstractFormPlugin)this, (ImcPermItemEnum)ImcPermItemEnum.IMC_INVSM_CALLBACK);
            ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
            this.callBack(rows);
        }
    }

    public void setFilter(SetFilterEvent e) {
        List filter = e.getCustomQFilters();
        QFilter sysFilter = new QFilter("targetsystem", "!=", (Object)"originalbill");
        filter.add(sysFilter);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        if ("invoiceno".equals(args.getFieldName())) {
            Object invoiceId;
            args.setCancel(true);
            Object selId = ((IListView)this.getView()).getFocusRowPkId();
            DynamicObject callbackObj = BusinessDataServiceHelper.loadSingle((String)"invsm_callback_log", (String)String.join((CharSequence)",", "business_fid", "callbacktype", "invoicecode", "invoiceno", "invoicetype"), (QFilter[])new QFilter("id", "=", selId).toArray());
            if (callbackObj == null) {
                return;
            }
            if (InvoiceUtils.isVehicleInvoice((String)callbackObj.getString("invoicetype"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u673a\u52a8\u8f66\u9500\u552e\u7edf\u4e00\u53d1\u7968\u4e0d\u652f\u6301\u67e5\u770b\u3002", (String)"InvCallbackLogListPlugin_4", (String)"imc-invsm-formplugin", (Object[])new Object[0]));
                return;
            }
            if (InvoiceUtils.isUsedCarInvoice((Object)callbackObj.getString("invoicetype"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e8c\u624b\u8f66\u9500\u552e\u7edf\u4e00\u53d1\u7968\u4e0d\u652f\u6301\u67e5\u770b\u3002", (String)"InvCallbackLogListPlugin_5", (String)"imc-invsm-formplugin", (Object[])new Object[0]));
                return;
            }
            QFilter invoiceFilter = new QFilter("invoicecode", "=", (Object)callbackObj.getString("invoicecode")).and("invoiceno", "=", (Object)callbackObj.getString("invoiceno"));
            if ("bill".equals(callbackObj.getString("callbacktype"))) {
                DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)"", (QFilter[])invoiceFilter.toArray());
                invoiceId = obj.getPkValue();
            } else {
                invoiceId = callbackObj.get("business_fid");
            }
            HashMap map = Maps.newHashMapWithExpectedSize((int)1);
            map.put("id", invoiceId);
            ViewUtil.openDialog((AbstractFormPlugin)this, (Map)map, (String)"sim_invoice_show", null);
        }
    }

    private void callBack(ListSelectedRowCollection rows) {
        QFilter filter;
        if (rows.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"InvCallbackLogListPlugin_1", (String)"imc-invsm-formplugin", (Object[])new Object[0]));
            return;
        }
        Object[] callbackPks = rows.getPrimaryKeyValues();
        String selFields = PropertieUtil.getAllPropertiesSplitByComma((String)"invsm_callback_log", (boolean)true);
        DynamicObject[] callbackLogs = BusinessDataServiceHelper.load((String)"invsm_callback_log", (String)selFields, (QFilter[])(filter = new QFilter("id", "in", (Object)callbackPks)).toArray());
        if (null == callbackLogs || callbackLogs.length <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5217\u8868\u6570\u636e\u5df2\u66f4\u65b0\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5\u3002", (String)"InvCallbackLogListPlugin_2", (String)"imc-invsm-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        ArrayList<DynamicObject> callbackDyList = new ArrayList<DynamicObject>();
        for (DynamicObject callbackLog2 : callbackLogs) {
            if ("0".equals(callbackLog2.getString("callback_status"))) {
                ImmutableSet set = ImmutableSet.of((Object)"KINGDEE_FI", (Object)"AR_FINARBILL", (Object)"AR_BUSBILL");
                if (set.contains((Object)callbackLog2.getString("business_system_code"))) continue;
                callbackDyList.add(callbackLog2);
                continue;
            }
            callbackDyList.add(callbackLog2);
        }
        ArrayList<CallbackLogVo> callbackLogList = new ArrayList<CallbackLogVo>(callbackDyList.size());
        for (DynamicObject callBackLogDynamicObject : callbackDyList) {
            if (CallBackLogTypeEnum.invoiceError.getValue().equals(callBackLogDynamicObject.getString("callbacktype")) || CallBackLogTypeEnum.billError.getValue().equals(callBackLogDynamicObject.getString("callbacktype"))) {
                SendCallBackHelper.handlerErrorCallBackTask((DynamicObject)callBackLogDynamicObject);
                continue;
            }
            CallbackLogVo callbackVo = (CallbackLogVo)DynamicObjectUtil.dynamicObject2Bean(CallbackLogVo.class, (DynamicObject)callBackLogDynamicObject);
            callbackLogList.add(callbackVo);
        }
        if (callbackLogList.size() > 0) {
            this.writeBack2Original(callbackLogList);
            callbackLogList.forEach(callbackLog -> CallbackHelperUtil.callbackHandler((String)JSON.toJSONString((Object)callbackLog), (int)2));
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"InvCallbackLogListPlugin_3", (String)"imc-invsm-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
        IListView listView = (IListView)this.getView();
        listView.clearSelection();
        listView.refresh();
    }

    private void writeBack2Original(List<CallbackLogVo> callbackLogList) {
        try {
            DynamicObject[] invoices;
            QFilter filter = null;
            for (CallbackLogVo vo : callbackLogList) {
                if (!BotpHelper.isFromAr((Object)vo.getBusinessSystemCode())) continue;
                String invoiceCode = vo.getInvoiceCode();
                String invoiceNo = vo.getInvoiceNo();
                if (null == filter) {
                    filter = new QFilter("invoiceno", "=", (Object)invoiceNo);
                    filter = filter.and("invoicecode", "=", (Object)invoiceCode);
                    continue;
                }
                QFilter invoiceNoFilter = new QFilter("invoiceno", "=", (Object)invoiceNo);
                if (StringUtils.isBlank((CharSequence)invoiceCode)) {
                    invoiceNoFilter = invoiceNoFilter.and("invoicecode", "=", (Object)invoiceCode);
                }
                filter.or(invoiceNoFilter);
            }
            if (filter == null) {
                return;
            }
            String fields = String.join((CharSequence)",", "issuewritebackstatus", "abolishwritebackstatus", "invoicestatus");
            for (DynamicObject invoice : invoices = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)fields, (QFilter[])filter.toArray())) {
                if ("0".equals(invoice.getString("issuewritebackstatus"))) {
                    DispatchServiceHelper.invokeBizService((String)"imc", (String)"sim", (String)"InvoiceWriteBack2OriginalBillServiceImpl", (String)"writeBack", (Object[])new Object[]{invoice.getPkValue()});
                }
                String abolishWriteBackStatus = invoice.getString("abolishwritebackstatus");
                String invoiceStatus = invoice.getString("invoicestatus");
                if (!"6".equals(invoiceStatus) || !"2".equals(abolishWriteBackStatus)) continue;
                DispatchServiceHelper.invokeBizService((String)"imc", (String)"sim", (String)"InvoiceCancelWriteBack2OriginalBillServiceImpl", (String)"writeBack", (Object[])new Object[]{invoice.getPkValue()});
            }
        }
        catch (Exception e) {
            LOGGER.error("writeBackOriginalBillError:" + e.getMessage(), (Throwable)e);
        }
    }
}

