/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.invsm.formplugin.config;

import com.google.common.collect.ImmutableSet;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.constant.ImcPermItemEnum;
import kd.imc.bdm.common.helper.PermissionHelper;
import kd.imc.bdm.common.util.ModelUtil;

public class APPAccessConfigNewPagePlugin
extends AbstractFormPlugin {
    public static final ImmutableSet<String> notAllowSys = new ImmutableSet.Builder().add((Object)"IMAC_QR").add((Object)"KINGDEECLOUD").add((Object)"EAS").add((Object)"XKQJ").add((Object)"KINGDEE_FI").add((Object)"CQOMS").add((Object)"PMGT_BILL").add((Object)"REPC_BILL").add((Object)"OCPOS_SALEORDER").add((Object)"OCPOS_SALEORDER_RETURN").add((Object)"AR_FINARBILL").add((Object)"AR_BUSBILL").add((Object)"XK_BUSINESS_FPY").build();

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (null == customParams) {
            return;
        }
        Object configId = customParams.get("pkId");
        if (configId == null || StringUtils.isBlank((CharSequence)configId.toString())) {
            return;
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"invsm_app_access_config", (String)"id", (QFilter[])new QFilter("id", "=", configId).toArray());
        if (dynamicObject == null) {
            return;
        }
        dynamicObject = BusinessDataServiceHelper.loadSingle((Object)dynamicObject.getPkValue(), (String)"invsm_app_access_config");
        ModelUtil.setModelValueFromDynamicObject((DynamicObject)dynamicObject, (AbstractFormPlugin)this);
        this.getView().setEnable(Boolean.FALSE, new String[]{"code"});
    }

    public void registerListener(EventObject e) {
        Button button = (Button)this.getView().getControl("btn_save");
        button.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        if ("btn_save".equals(control.getKey())) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            String msg = this.checkParams(customParams);
            if (StringUtils.isNotBlank((CharSequence)msg)) {
                throw new KDBizException(msg);
            }
            this.saveConfig();
            this.getView().close();
        }
    }

    private String checkParams(Map<String, Object> customParams) {
        String msg;
        String encryptionType = (String)this.getModel().getValue("encryption_type");
        String aesPwds = (String)this.getModel().getValue("aes_pwds");
        if ("0".equals(encryptionType)) {
            if (StringUtils.isBlank((CharSequence)aesPwds)) {
                return ResManager.loadKDString((String)"\u6570\u636e\u52a0\u5bc6\u7b56\u7565\u4e3aAES+BASE64,\u8bf7\u8f93\u5165AES\u52a0\u5bc6\u79d8\u94a5", (String)"APPAccessConfigNewPagePlugin_0", (String)"imc-invsm-formplugin", (Object[])new Object[0]);
            }
            String regxStr = "^[a-zA-Z0-9]{16}$";
            if (!aesPwds.matches(regxStr)) {
                return ResManager.loadKDString((String)"AES\u79d8\u94a5\u53ea\u80fd\u662f16\u4f4d\u6570\u5b57\u3001\u5b57\u6bcd\u7684\u7ec4\u5408", (String)"APPAccessConfigNewPagePlugin_1", (String)"imc-invsm-formplugin", (Object[])new Object[0]);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(msg = this.checkUrl("callback_url", "callback_url_two", "callback_url_thr")))) {
            return msg;
        }
        String code = (String)this.getModel().getValue("code");
        QFilter qFilter = new QFilter("code", "=", (Object)code);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"invsm_app_access_config", (String)"id", (QFilter[])qFilter.toArray());
        if (customParams.isEmpty() && !collection.isEmpty()) {
            return String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u7cfb\u7edf\u7f16\u7801:\u3010%s\u3011\u5df2\u5b58\u5728,\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0", (String)"APPAccessConfigNewPagePlugin_4", (String)"imc-invsm-formplugin", (Object[])new Object[0]), code);
        }
        return "";
    }

    private String checkUrl(String ... urlFields) {
        String urlRegx = "^https?://(www)?([-A-Za-z0-9]+.){1,4}[-A-Za-z0-9]+.*";
        String ipRegx = "^https?://[0-9]{1,3}(.[0-9]{1,3}){3}.*";
        for (String urlFieldName : urlFields) {
            String callBackUrl = (String)this.getModel().getValue(urlFieldName);
            if (!StringUtils.isNotBlank((CharSequence)callBackUrl) || callBackUrl.matches(urlRegx) || callBackUrl.matches(ipRegx)) continue;
            String[] str = callBackUrl.split(",");
            if (str.length >= 4) {
                return "";
            }
            TextEdit trol = (TextEdit)this.getControl(urlFieldName);
            return String.format(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6b63\u786e\u7684%1$s:http(s)://***", (String)"APPAccessConfigNewPagePlugin_6", (String)"imc-invsm-formplugin", (Object[])new Object[0]), trol.getProperty().getDisplayName().getLocaleValue());
        }
        return "";
    }

    private void saveConfig() {
        DynamicObject config;
        String system = (String)this.getModel().getValue("code");
        if (notAllowSys.contains((Object)system)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u7cfb\u7edf\u7f16\u7801", (String)"APPAccessConfigNewPagePlugin_5", (String)"imc-invsm-formplugin", (Object[])new Object[0]));
        }
        Map map = this.getView().getFormShowParameter().getCustomParams();
        Object pkId = map.get("pkId");
        if (StringUtils.isBlank(pkId)) {
            PermissionHelper.checkPermission((String)"invsm", (String)"invsm_app_access_config", (ImcPermItemEnum)ImcPermItemEnum.ITEM_NEW);
            config = BusinessDataServiceHelper.newDynamicObject((String)"invsm_app_access_config");
            config.set("creater", (Object)RequestContext.get().getUserId());
            config.set("create_time", (Object)new Date());
            config.set("is_valid", (Object)"1");
        } else {
            PermissionHelper.checkPermission((String)"invsm", (String)"invsm_app_access_config", (ImcPermItemEnum)ImcPermItemEnum.ITEM_EDIT);
            config = BusinessDataServiceHelper.loadSingle(pkId, (String)"invsm_app_access_config");
            config.set("modifier", (Object)RequestContext.get().getUserId());
            config.set("modify_time", (Object)new Date());
        }
        String encryptionType = (String)this.getModel().getValue("encryption_type");
        String aesPwds = "0".equals(encryptionType) ? (String)this.getModel().getValue("aes_pwds") : "";
        config.set("code", (Object)system);
        config.set("name", this.getModel().getValue("name"));
        config.set("encryption_type", (Object)encryptionType);
        config.set("aes_pwds", (Object)aesPwds);
        config.set("callback_url", this.getModel().getValue("callback_url"));
        config.set("callback_url_two", this.getModel().getValue("callback_url_two"));
        config.set("callback_url_thr", this.getModel().getValue("callback_url_thr"));
        config.set("remark", this.getModel().getValue("remark"));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{config});
    }
}

