/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.invsm.formplugin.config;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.imc.bdm.common.constant.ImcPermItemEnum;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.PermissionHelper;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.message.model.MsgResponse;
import kd.imc.bdm.common.message.send.SendMsg2Imac;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.RegexUtil;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.invsm.common.helper.ParamConfigHelper;

public class ParamConfigEditPlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(ParamConfigEditPlugin.class);
    private static final String ISMC_NOT_NEED_AUTH = "0";
    private static final String ISMC_NEED_AUTH = "1";
    public static final String CONFIG_TYPE_BDM_ISMC_CONFIG_MOVE = "bdm_ismc_config_move";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        this.loadData();
    }

    public void itemClick(ItemClickEvent evt) {
        switch (evt.getItemKey()) {
            case "btn_init": {
                PermissionHelper.checkPermission((AbstractFormPlugin)this, (ImcPermItemEnum)ImcPermItemEnum.IMC_INIT);
                this.registerIsmc();
                break;
            }
            case "btn_un_init": {
                this.unInit(0);
                break;
            }
            case "btn_init_move": {
                PermissionHelper.checkPermission((AbstractFormPlugin)this, (ImcPermItemEnum)ImcPermItemEnum.IMC_INIT);
                this.registerImac();
                break;
            }
            case "btn_uninit_move": {
                this.unInit(1);
            }
        }
    }

    private void unInit(int type) {
        ConfirmCallBackListener confirmCallBacks;
        Map configParams;
        long userId = Long.parseLong(RequestContext.get().getUserId());
        if (!PermissionServiceHelper.isSuperUser((long)userId) && !PermissionServiceHelper.isAdminUser((long)userId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u65e0\u6743\u9650\u64cd\u4f5c\uff0c\u53ea\u6709\u5168\u529f\u80fd\u7528\u6237\u6216\u7ba1\u7406\u5458\u624d\u80fd\u53cd\u521d\u59cb\u5316\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"ParamConfigEditPlugin_0", (String)"imc-invsm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (type == 0) {
            configParams = ImcConfigUtil.getValue((String)"bdm_ismc_config");
            confirmCallBacks = new ConfirmCallBackListener("btn_un_inittip");
        } else {
            configParams = ImcConfigUtil.getValue((String)CONFIG_TYPE_BDM_ISMC_CONFIG_MOVE);
            confirmCallBacks = new ConfirmCallBackListener("btn_uninit_move_tip");
        }
        if (CollectionUtils.isEmpty((Map)configParams)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u521d\u59cb\u5316\uff0c\u4e0d\u80fd\u8fdb\u884c\u53cd\u521d\u59cb\u5316\u64cd\u4f5c", (String)"ParamConfigEditPlugin_1", (String)"imc-invsm-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"ParamConfigEditPlugin_2", (String)"imc-invsm-formplugin", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u7ee7\u7eed\u64cd\u4f5c", (String)"ParamConfigEditPlugin_3", (String)"imc-invsm-formplugin", (Object[])new Object[0]));
        this.getView().showConfirm(ResManager.loadKDString((String)"\u53cd\u521d\u59cb\u5316\u64cd\u4f5c\u540e\u5c06\u56de\u5230\u51fa\u5382\u8bbe\u7f6e\uff0c\u672a\u521d\u59cb\u5316\u4e4b\u524d\u5219\u65e0\u6cd5\u7ee7\u7eed\u4efb\u4f55\u5f00\u7968\u64cd\u4f5c\u3002\u8bf7\u8c28\u614e\u4f7f\u7528\uff01", (String)"ParamConfigEditPlugin_4", (String)"imc-invsm-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks, btnNameMaps);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if ("deploy".equals(e.getProperty().getName())) {
            String deployType = (String)e.getChangeSet()[0].getNewValue();
            if (StringUtils.isBlank((CharSequence)deployType)) {
                this.getModel().setValue("url", (Object)"");
                this.getModel().setValue("accountid", (Object)"");
                this.getView().setEnable(Boolean.TRUE, new String[]{"url", "accountid", "url_proxy"});
                return;
            }
            if (!"imc_deploy_private".equals(deployType)) {
                this.setDeployValue(deployType, "url", "accountid", "url_proxy");
                return;
            }
            try {
                JSONObject jsonData;
                this.getView().setEnable(Boolean.FALSE, new String[]{"url", "accountid", "url_proxy"});
                this.getModel().setValue("url", (Object)RequestContext.get().getClientFullContextPath());
                this.getModel().setValue("accountid", (Object)RequestContext.get().getAccountId());
                String responseStr = (String)DispatchServiceHelper.invokeBizService((String)"ismc", (String)"dim", (String)"TenantRegister", (String)"checkDeploy", (Object[])new Object[]{""});
                if (log.isInfoEnabled()) {
                    log.info(responseStr);
                }
                if ("0000".equals((jsonData = JSONObject.parseObject((String)responseStr)).getString("errorCode"))) {
                    return;
                }
                this.openNoDeploy();
            }
            catch (Exception ex) {
                log.error(ex.getMessage(), (Throwable)ex);
                this.openNoDeploy();
            }
        } else if ("deploy_imac".equals(e.getProperty().getName())) {
            String deployType = (String)e.getChangeSet()[0].getNewValue();
            if (StringUtils.isBlank((CharSequence)deployType)) {
                this.getModel().setValue("move_cloud_url", (Object)"");
                this.getModel().setValue("move_cloud_accountid", (Object)"");
                return;
            }
            if (!"imc_deploy_private".equals(deployType)) {
                this.setDeployValue(deployType, "move_cloud_url", "move_cloud_accountid", "move_cloud_url_proxy");
            }
        }
    }

    private void openNoDeploy() {
        this.getModel().setValue("url", (Object)"");
        this.getModel().setValue("accountid", (Object)"");
        ViewUtil.openNormalConfirm((AbstractFormPlugin)this, (String)ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u5f53\u524d\u73af\u5883\u672a\u90e8\u7f72\u7a0e\u63a7\u7cfb\u7edf\u4e91\uff0c\u8bf7\u5148\u90e8\u7f72\u7a0e\u63a7\u7cfb\u7edf\u4e91\u518d\u8fdb\u884c\u521d\u59cb\u5316\uff0c\u6216\u9009\u62e9\u5176\u4ed6\u90e8\u7f72\u65b9\u5f0f\u3002", (String)"ParamConfigEditPlugin_5", (String)"imc-invsm-formplugin", (Object[])new Object[0]), (String)"deploy");
    }

    private void setDeployValue(String deployType, String urlKey, String accountIdKey, String proxyKey) {
        if ("url".equals(urlKey)) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"url", "accountid", "url_proxy"});
        }
        QFilter filter = new QFilter("config_type", "=", (Object)deployType);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"invsm_param_configuration", (String)String.join((CharSequence)",", "config_key", "config_value"), (QFilter[])filter.toArray());
        for (DynamicObject paramConfig : collection) {
            if ((deployType + "_url").equals(paramConfig.getString("config_key"))) {
                this.getModel().setValue(urlKey, (Object)paramConfig.getString("config_value"));
            }
            if ((deployType + "_accountid").equals(paramConfig.getString("config_key"))) {
                this.getModel().setValue(accountIdKey, (Object)paramConfig.getString("config_value"));
            }
            if (!(deployType + "_proxy").equals(paramConfig.getString("config_key"))) continue;
            this.getModel().setValue(proxyKey, (Object)paramConfig.getString("config_value"));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (messageBoxClosedEvent.getResult() != MessageBoxResult.Yes) {
            return;
        }
        switch (messageBoxClosedEvent.getCallBackId()) {
            case "btn_un_inittip": {
                ViewUtil.openNormalConfirm((AbstractFormPlugin)this, (String)ResManager.loadKDString((String)"\u786e\u8ba4\u53cd\u521d\u59cb\u5316\u64cd\u4f5c\uff1f", (String)"ParamConfigEditPlugin_6", (String)"imc-invsm-formplugin", (Object[])new Object[0]), (String)"btn_un_init");
                break;
            }
            case "btn_uninit_move_tip": {
                ViewUtil.openNormalConfirm((AbstractFormPlugin)this, (String)ResManager.loadKDString((String)"\u786e\u8ba4\u53cd\u521d\u59cb\u5316\u64cd\u4f5c\uff1f", (String)"ParamConfigEditPlugin_6", (String)"imc-invsm-formplugin", (Object[])new Object[0]), (String)"btn_un_init_move");
                break;
            }
            case "btn_un_init": {
                this.unInitExecute(0);
                break;
            }
            case "btn_un_init_move": {
                this.unInitExecute(1);
                break;
            }
            case "forceUninit": {
                long userId = Long.parseLong(RequestContext.get().getUserId());
                if (!PermissionServiceHelper.isSuperUser((long)userId) && !PermissionServiceHelper.isAdminUser((long)userId)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u65e0\u6743\u9650\u64cd\u4f5c\uff0c\u53ea\u6709\u5168\u529f\u80fd\u7528\u6237\u6216\u7ba1\u7406\u5458\u624d\u80fd\u53cd\u521d\u59cb\u5316\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"ParamConfigEditPlugin_0", (String)"imc-invsm-formplugin", (Object[])new Object[0]));
                    return;
                }
                ParamConfigHelper.removeIsmcSetup();
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53cd\u521d\u59cb\u5316\u6210\u529f", (String)"ParamConfigEditPlugin_7", (String)"imc-invsm-formplugin", (Object[])new Object[0]));
                this.getView().invokeOperation("refresh");
                break;
            }
            case "forceUninitMove": {
                this.forceUninitMove();
            }
        }
    }

    private void forceUninitMove() {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        if (!PermissionServiceHelper.isSuperUser((long)userId) && !PermissionServiceHelper.isAdminUser((long)userId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u65e0\u6743\u9650\u64cd\u4f5c\uff0c\u53ea\u6709\u5168\u529f\u80fd\u7528\u6237\u6216\u7ba1\u7406\u5458\u624d\u80fd\u53cd\u521d\u59cb\u5316\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"ParamConfigEditPlugin_0", (String)"imc-invsm-formplugin", (Object[])new Object[0]));
            return;
        }
        ParamConfigHelper.removeImacSetUp();
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53cd\u521d\u59cb\u5316\u6210\u529f", (String)"ParamConfigEditPlugin_7", (String)"imc-invsm-formplugin", (Object[])new Object[0]));
        this.getView().invokeOperation("refresh");
    }

    private void unInitExecute(int type) {
        try {
            long userId = Long.parseLong(RequestContext.get().getUserId());
            if (!PermissionServiceHelper.isSuperUser((long)userId) && !PermissionServiceHelper.isAdminUser((long)userId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u65e0\u6743\u9650\u64cd\u4f5c\uff0c\u53ea\u6709\u5168\u529f\u80fd\u7528\u6237\u6216\u7ba1\u7406\u5458\u624d\u80fd\u53cd\u521d\u59cb\u5316\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"ParamConfigEditPlugin_0", (String)"imc-invsm-formplugin", (Object[])new Object[0]));
                return;
            }
            boolean success = type == 0 ? ParamConfigHelper.unInit((AbstractFormPlugin)this) : ParamConfigHelper.unInitMove((AbstractFormPlugin)this);
            if (success) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53cd\u521d\u59cb\u5316\u6210\u529f", (String)"ParamConfigEditPlugin_7", (String)"imc-invsm-formplugin", (Object[])new Object[0]));
                this.getView().invokeOperation("refresh");
            }
        }
        catch (Exception e) {
            if (e instanceof MsgException) {
                MsgException msgException = (MsgException)e;
                this.getView().showErrorNotification(msgException.getErrorMsg());
            }
            this.getView().showErrorNotification(e.getMessage());
        }
    }

    private void registerIsmc() {
        Object ismcneedauth = this.getModel().getValue("ismcneedauth");
        if (ISMC_NOT_NEED_AUTH.equals(ismcneedauth)) {
            ImcConfigUtil.removeCache((String)"bdm_ismc_config");
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7a0e\u63a7\u7cfb\u7edf\u4e91\u5df2\u521d\u59cb\u5316,\u8bf7\u52ff\u91cd\u590d\u521d\u59cb\u5316", (String)"ParamConfigEditPlugin_8", (String)"imc-invsm-formplugin", (Object[])new Object[0]));
            return;
        }
        String ismcUrl = (String)this.getModel().getValue("url");
        if (StringUtils.isBlank((CharSequence)ismcUrl)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7a0e\u63a7\u7cfb\u7edf\u4e91\u5730\u5740\u5fc5\u586b", (String)"ParamConfigEditPlugin_9", (String)"imc-invsm-formplugin", (Object[])new Object[0]));
            return;
        }
        Object accountid = this.getModel().getValue("accountid");
        if (StringUtils.isBlank((Object)accountid)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7a0e\u63a7\u7cfb\u7edf\u4e91\u6570\u636e\u4e2d\u5fc3\u5fc5\u586b", (String)"ParamConfigEditPlugin_10", (String)"imc-invsm-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        while (ismcUrl.endsWith("/")) {
            ismcUrl = ismcUrl.substring(0, ismcUrl.length() - 1);
        }
        params.put("bdm_ismc_config_deploy", (String)this.getModel().getValue("deploy"));
        params.put("bdm_ismc_config_url", ismcUrl);
        params.put("bdm_ismc_config_url_proxy", (String)this.getModel().getValue("url_proxy"));
        params.put("bdm_ismc_config_accountid", String.valueOf(accountid));
        if (log.isInfoEnabled()) {
            log.info(String.format("\u521d\u59cb\u5316\u53c2\u6570\uff1a%s", JSONObject.toJSONString(params)));
        }
        try {
            ParamConfigHelper.initIsmcAuthInfo(params);
        }
        catch (MsgException e) {
            log.error("\u521d\u59cb\u5316\u5931\u8d25" + e.getErrorCode(), (Throwable)e);
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u5931\u8d25\uff1a%s", (String)"ParamConfigEditPlugin_21", (String)"imc-invsm-formplugin", (Object[])new Object[0]), e.getMessage()));
            return;
        }
        catch (Exception e) {
            log.error("\u521d\u59cb\u5316\u5931\u8d25" + e.getMessage(), (Throwable)e);
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u5931\u8d25\uff1a%s", (String)"ParamConfigEditPlugin_21", (String)"imc-invsm-formplugin", (Object[])new Object[0]), e.getMessage()));
            return;
        }
        this.loadData();
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"ParamConfigEditPlugin_12", (String)"imc-invsm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
        this.getModel().setValue("ismcneedauth", (Object)ISMC_NOT_NEED_AUTH);
    }

    private void registerImac() {
        Object ismcneedauth = this.getModel().getValue("move_cloud_ismcneedauth");
        if (ISMC_NOT_NEED_AUTH.equals(ismcneedauth)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u79fb\u52a8\u4e91\u5df2\u521d\u59cb\u5316,\u8bf7\u52ff\u91cd\u590d\u521d\u59cb\u5316", (String)"ParamConfigEditPlugin_13", (String)"imc-invsm-formplugin", (Object[])new Object[0]));
            return;
        }
        String moveCloudUrl = (String)this.getModel().getValue("move_cloud_url");
        if (StringUtils.isBlank((CharSequence)moveCloudUrl)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u79fb\u52a8\u4e91\u5730\u5740\u5fc5\u586b", (String)"ParamConfigEditPlugin_14", (String)"imc-invsm-formplugin", (Object[])new Object[0]));
            return;
        }
        Object moveCloudAccountid = this.getModel().getValue("move_cloud_accountid");
        if (StringUtils.isBlank((Object)moveCloudAccountid)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u79fb\u52a8\u4e91\u6570\u636e\u4e2d\u5fc3\u5fc5\u586b", (String)"ParamConfigEditPlugin_15", (String)"imc-invsm-formplugin", (Object[])new Object[0]));
            return;
        }
        String moveCloudTenantName = (String)this.getModel().getValue("move_cloud_tenantname");
        if (StringUtils.isBlank((CharSequence)moveCloudTenantName)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u79df\u6237\u540d\u79f0\u5fc5\u586b", (String)"ParamConfigEditPlugin_16", (String)"imc-invsm-formplugin", (Object[])new Object[0]));
            return;
        }
        String moveOpen3app = (String)this.getModel().getValue("move_cloud_open3app");
        if (StringUtils.isBlank((CharSequence)moveOpen3app)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7b2c\u4e09\u65b9\u5e94\u7528\u5fc5\u586b", (String)"ParamConfigEditPlugin_17", (String)"imc-invsm-formplugin", (Object[])new Object[0]));
            return;
        }
        String move_open3app_pwd = (String)this.getModel().getValue("move_cloud_open3app_pwd");
        if (StringUtils.isBlank((CharSequence)move_open3app_pwd)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7b2c\u4e09\u65b9\u5e94\u7528\u5bc6\u7801\u5fc5\u586b", (String)"ParamConfigEditPlugin_18", (String)"imc-invsm-formplugin", (Object[])new Object[0]));
            return;
        }
        String move_user = (String)this.getModel().getValue("move_cloud_open3app_user");
        if (StringUtils.isBlank((CharSequence)move_user)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u767b\u5f55\u624b\u673a\u53f7\u5fc5\u586b", (String)"ParamConfigEditPlugin_19", (String)"imc-invsm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!RegexUtil.isMobile((String)move_user)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u624b\u673a\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e", (String)"ParamConfigEditPlugin_20", (String)"imc-invsm-formplugin", (Object[])new Object[0]));
            return;
        }
        ImcConfigUtil.removeCache((String)CONFIG_TYPE_BDM_ISMC_CONFIG_MOVE);
        while (moveCloudUrl.endsWith("/")) {
            moveCloudUrl = moveCloudUrl.substring(0, moveCloudUrl.length() - 1);
        }
        String move_cloud_proxy = (String)this.getModel().getValue("move_cloud_url_proxy");
        HashMap<String, String> paramMap = new HashMap<String, String>(5);
        paramMap.put("bdm_ismc_config_move_cloud_url", moveCloudUrl);
        paramMap.put("bdm_ismc_config_move_cloud_accountid", String.valueOf(moveCloudAccountid));
        paramMap.put("bdm_ismc_config_move_cloud_appid", "imacWebService");
        paramMap.put("bdm_ismc_config_move_cloud_appsecuret", "123456");
        paramMap.put("bdm_ismc_config_move_cloud_user", "imac");
        paramMap.put("bdm_ismc_config_move_cloud_tenantname", moveCloudTenantName);
        paramMap.put("bdm_ismc_config_move_cloud_open3app", moveOpen3app);
        paramMap.put("bdm_ismc_config_move_cloud_open3app_pwd", move_open3app_pwd);
        paramMap.put("bdm_ismc_config_move_cloud_open3app_user", move_user);
        paramMap.put("bdm_ismc_config_move_cloud_url_proxy", move_cloud_proxy);
        CacheHelper.put((String)CONFIG_TYPE_BDM_ISMC_CONFIG_MOVE, (String)SerializationUtils.toJsonString(paramMap), (int)3600);
        MsgResponse resp = SendMsg2Imac.registerImc(paramMap);
        if (!"0000".equals(resp.getErrorCode())) {
            ImcConfigUtil.removeCache((String)CONFIG_TYPE_BDM_ISMC_CONFIG_MOVE);
            ImcConfigUtil.putCache((String)CONFIG_TYPE_BDM_ISMC_CONFIG_MOVE);
            this.getView().showTipNotification(resp.getErrorMsg());
            return;
        }
        JSONObject jsonObject = JSON.parseObject((String)resp.getRespData());
        paramMap.put("bdm_ismc_config_move_cloud_public_key", jsonObject.getString("publicKey"));
        CacheHelper.put((String)CONFIG_TYPE_BDM_ISMC_CONFIG_MOVE, (String)SerializationUtils.toJsonString(paramMap), (int)3600);
        QFilter filter = new QFilter("config_type", "=", (Object)CONFIG_TYPE_BDM_ISMC_CONFIG_MOVE);
        DeleteServiceHelper.delete((String)"invsm_param_configuration", (QFilter[])new QFilter[]{filter});
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(paramMap.size());
        for (Map.Entry entry : paramMap.entrySet()) {
            DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)"invsm_param_configuration");
            object.set("config_type", (Object)CONFIG_TYPE_BDM_ISMC_CONFIG_MOVE);
            object.set("config_key", entry.getKey());
            object.set("config_value", entry.getValue());
            list.add(object);
        }
        ImcSaveServiceHelper.save(list);
        if (log.isInfoEnabled()) {
            log.info("\u914d\u7f6e\u4fee\u6539\uff1a" + SerializationUtils.toJsonString(paramMap));
        }
        this.loadData();
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"ParamConfigEditPlugin_12", (String)"imc-invsm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
        this.getModel().setValue("move_cloud_ismcneedauth", (Object)ISMC_NOT_NEED_AUTH);
    }

    private void loadData() {
        LinkedList<String> configList = new LinkedList<String>();
        configList.add("bdm_ismc_config");
        configList.add(CONFIG_TYPE_BDM_ISMC_CONFIG_MOVE);
        this.getModel().setValue("imcappid", (Object)RequestContext.get().getTenantId());
        QFilter filter = new QFilter("config_type", "in", configList);
        DynamicObjectCollection list = QueryServiceHelper.query((String)"invsm_param_configuration", (String)"config_key,config_value", (QFilter[])new QFilter[]{filter});
        int length = ((String)configList.get(0)).length() + 1;
        boolean bdmIsmcConfigUrlExist = false;
        boolean bdmIsmcConfigAccountIdExist = false;
        boolean moveCouldConfigUrlExist = false;
        boolean moveCouldConfigAccountIdExist = false;
        for (DynamicObject object : list) {
            String type = object.getString("config_key");
            String value = object.getString("config_value");
            if ("bdm_ismc_config_url".equals(type) && StringUtils.isNotEmpty((CharSequence)value)) {
                bdmIsmcConfigUrlExist = true;
            }
            if ("bdm_ismc_config_accountid".equals(type) && StringUtils.isNotEmpty((CharSequence)value)) {
                bdmIsmcConfigAccountIdExist = true;
            }
            if ("bdm_ismc_config_move_cloud_url".equals(type) && StringUtils.isNotEmpty((CharSequence)value)) {
                moveCouldConfigUrlExist = true;
            }
            if ("bdm_ismc_config_move_cloud_accountid".equals(type) && StringUtils.isNotEmpty((CharSequence)value)) {
                moveCouldConfigAccountIdExist = true;
            }
            String controlKey = type.substring(length);
            Control control = this.getView().getControl(controlKey);
            if (control == null) continue;
            this.getModel().setValue(controlKey, (Object)value);
        }
        if (bdmIsmcConfigAccountIdExist && bdmIsmcConfigUrlExist) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"url", "accountid", "url_proxy"});
            this.getModel().setValue("ismcneedauth", (Object)ISMC_NOT_NEED_AUTH);
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"url", "accountid", "url_proxy"});
            this.getModel().setValue("ismcneedauth", (Object)ISMC_NEED_AUTH);
        }
        if (moveCouldConfigAccountIdExist && moveCouldConfigUrlExist) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"move_cloud_url", "move_cloud_accountid", "move_cloud_url_proxy"});
            this.getModel().setValue("move_cloud_ismcneedauth", (Object)ISMC_NOT_NEED_AUTH);
        } else {
            this.getModel().setValue("move_cloud_ismcneedauth", (Object)ISMC_NEED_AUTH);
        }
    }
}

