/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.constant;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.invoice.deduction.SelectAccountService;
import kd.imc.rim.common.invoice.model.SelectLog;
import kd.imc.rim.common.invoice.query.InvoiceQueryService;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.TenantUtils;
import kd.imc.rim.common.utils.UUID;

public class RecordedConstant {
    public static final String RIM_RECORDED = "rim_recorded";
    public static final String CACHE_RECORDED_KEY_TAX_NO = "recorded_taxno";
    public static final String CACHE_RECORDED_LOGIN_TAX_NO = "recorded_login_taxno";
    public static final String CACHE_OPERATION_RESULT = "operation_result";
    public static final String CACHE_RECORDED_TITLE = "recorded_title";
    public static final String RECORDED_ETAX_CALLBACK = "recorded_etax_callback";
    private static Log logger = LogFactory.getLog(RecordedConstant.class);
    public static final String OPERATE_TYPE = "operateType";
    public static final String NEXT_ENTRY_MARK_STATUS = "nextEntryMarkStatus";
    public static final String TAX_RECORDED_STATUS = "tax_recorded_status";
    public static final String TAX_RECORDED_STATUS_empty = " ";
    public static final String TAX_RECORDED_STATUS_01 = "01";
    public static final String TAX_RECORDED_STATUS_11 = "11";
    public static final String TAX_RECORDED_STATUS_02 = "02";
    public static final String TAX_RECORDED_STATUS_03 = "03";
    public static final String TAX_RECORDED_STATUS_06 = "06";
    public static final String TAX_RECORDED_PURPOSE = "tax_recorded_purpose";
    public static final String TAX_RECORDED_PURPOSE_02 = "02";
    public static final String TAX_RECORDED_PURPOSE_03 = "03";
    public static final String TAX_RECORDED_TIME = "tax_recorded_time";
    public static final String TAX_RECORDED_PERIOD = "tax_recorded_period";
    public static final String TAX_OPERATE_UPDATE_TYPE = "update_type";
    public static final String UPDATE_TYPE_TIME = "update_time";
    public static final String UPDATE_TYPE_PURPOSE = "update_purpose";
    public static final String UPDATE_TYPE_TIME_PURPOSE = "update_time_purpose";
    public static final String AUTO_RECORD_TIME_TYPE_1 = "1";
    public static final String AUTO_RECORD_TIME_TYPE_2 = "2";
    private static final String DATE_FORMAT_REGEX_PERIOD = "^\\d{4}(0[1-9]|1[0-2])$";
    private static final String DATE_FORMAT_REGEX_TIME = "^\\d{4}(0[1-9]|1[0-2])(0[1-9]|[12]\\d|3[01])$";
    public static final String RECORDED_QUERY_FEILDS = "id,serial_no,invoice_type,invoice_code,invoice_no,invoice_date,invoice_amount,total_tax_amount,total_amount,effective_tax_amount,buyer_tax_no,org,invoice_status,saler_name,saler_tax_no,invoice_risk_level,electronic_no,createtime,account_time,tax_recorded_status,tax_recorded_purpose,tax_recorded_time,tax_recorded_period,account_date";

    public static String[] getRecordedStatus() {
        return new String[]{TAX_RECORDED_STATUS_11, "02", "03", TAX_RECORDED_STATUS_06};
    }

    public static String[] getNotRecordedStatus() {
        return new String[]{TAX_RECORDED_STATUS_empty, TAX_RECORDED_STATUS_01};
    }

    public static JSONObject createRecordedParamNew(DynamicObjectCollection invoiceCollection, String opereateType, String billType, DynamicObject autoRecordedConfig) {
        if (null != invoiceCollection && invoiceCollection.size() > 0) {
            JSONArray invoices = new JSONArray();
            for (DynamicObject dynamicObject : invoiceCollection) {
                JSONObject recordedParam = RecordedConstant.createRecordedSingle(dynamicObject, opereateType, null, autoRecordedConfig);
                if (recordedParam == null) continue;
                invoices.add((Object)recordedParam);
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)invoices)) {
                JSONObject cache = new JSONObject();
                for (int i = 0; i < invoices.size(); ++i) {
                    JSONObject recordedConfig;
                    JSONObject invoice = invoices.getJSONObject(i);
                    if (invoice == null) continue;
                    String taxNo = invoice.getString("buyerTaxNo");
                    if (null == taxNo) {
                        invoice.put("buyerTaxNo", (Object)"");
                    }
                    if (kd.imc.rim.common.utils.StringUtils.isBlank((CharSequence)(recordedConfig = (JSONObject)cache.getOrDefault((Object)taxNo, (Object)new JSONObject())).getString("billType"))) {
                        recordedConfig.put("billType", (Object)billType);
                    }
                    JSONArray invoicesArray = (JSONArray)recordedConfig.getOrDefault((Object)"invoices", (Object)new JSONArray());
                    invoicesArray.add((Object)invoice);
                    recordedConfig.put("invoices", (Object)invoicesArray);
                    recordedConfig.put("opereateType", (Object)opereateType);
                    cache.put(taxNo, (Object)recordedConfig);
                }
                return cache;
            }
        }
        return null;
    }

    public static JSONObject createRecordedSingle(DynamicObject invoice, String opereateType, JSONObject requestParam, DynamicObject autoRecordedConfig) {
        String recordedTime = requestParam != null ? requestParam.getString("recordedTime") : null;
        String recordedPeriod = requestParam != null ? requestParam.getString("recordedPeriod") : null;
        String nextEntryMarkStatusApi = requestParam != null ? requestParam.getString(NEXT_ENTRY_MARK_STATUS) : null;
        String autoRecordTimeType = null;
        if (autoRecordedConfig != null) {
            String taxRecordedPurposeAuto = autoRecordedConfig.getString(TAX_RECORDED_PURPOSE);
            nextEntryMarkStatusApi = kd.imc.rim.common.utils.StringUtils.isNotBlank((CharSequence)taxRecordedPurposeAuto) ? taxRecordedPurposeAuto : "02";
            String taxRecordedTimeAuto = autoRecordedConfig.getString(TAX_RECORDED_TIME);
            autoRecordTimeType = kd.imc.rim.common.utils.StringUtils.isNotBlank((CharSequence)taxRecordedTimeAuto) ? taxRecordedTimeAuto : AUTO_RECORD_TIME_TYPE_1;
        }
        JSONObject param = new JSONObject();
        try {
            param.put("id", invoice.get("id"));
            param.put("serialNo", (Object)invoice.getString("serial_no"));
            param.put("org", (Object)DynamicObjectUtil.getDynamicObjectLongValue(invoice.get("org")));
            if (kd.imc.rim.common.utils.StringUtils.isBlank((CharSequence)invoice.getString("buyer_tax_no"))) {
                param.put("buyerTaxNo", (Object)"");
            } else {
                param.put("buyerTaxNo", (Object)invoice.getString("buyer_tax_no"));
            }
            param.put("salerName", (Object)invoice.getString("saler_name"));
            param.put("salerTaxNo", (Object)invoice.getString("saler_tax_no"));
            Long invoiceType = DynamicObjectUtil.getDynamicObjectLongValue(invoice.get("invoice_type"));
            param.put("invoiceType", (Object)Integer.valueOf(InputInvoiceTypeEnum.getAwsType(invoiceType)));
            param.put("invoiceCode", (Object)invoice.getString("invoice_code"));
            param.put("etaxInvoiceNo", (Object)invoice.getString("electronic_no"));
            param.put("invoiceNo", (Object)invoice.getString("invoice_no"));
            param.put("invoiceDate", (Object)DateUtils.format(invoice.getDate("invoice_date"), "yyyy-MM-dd HH:mm:ss"));
            String invoiceAmount = "0.00";
            String totalTaxAmount = "0.00";
            if (null != invoice.get("invoice_amount") && BigDecimalUtil.ZERO.compareTo(BigDecimalUtil.transDecimal(invoice.get("invoice_amount"))) != 0) {
                invoiceAmount = String.valueOf(BigDecimalUtil.transDecimal(invoice.get("invoice_amount")).setScale(2, RoundingMode.HALF_UP));
            }
            if (null != invoice.get("total_tax_amount") && BigDecimalUtil.ZERO.compareTo(BigDecimalUtil.transDecimal(invoice.get("total_tax_amount"))) != 0) {
                totalTaxAmount = String.valueOf(BigDecimalUtil.transDecimal(invoice.get("total_tax_amount")).setScale(2, RoundingMode.HALF_UP));
            }
            param.put("invoiceAmount", (Object)invoiceAmount);
            param.put("totalTaxAmount", (Object)totalTaxAmount);
            param.put("invoiceStatus", (Object)(kd.imc.rim.common.utils.StringUtils.isNotBlank((CharSequence)invoice.getString("invoice_status")) ? Integer.parseInt(invoice.getString("invoice_status")) : 0));
            param.put("invoiceRiskLevel", (Object)RecordedConstant.convertInvoiceRiskLevel(invoice.getString("invoice_risk_level")));
            if (invoice.getDate(TAX_RECORDED_TIME) != null) {
                param.put("taxRecordedTime", (Object)DateUtils.format(invoice.getDate(TAX_RECORDED_TIME), "yyyy-MM-dd"));
            }
            if (invoice.getDate(TAX_RECORDED_PERIOD) != null) {
                param.put("taxRecordedPeriod", (Object)DateUtils.format(invoice.getDate(TAX_RECORDED_PERIOD), "yyyyMM"));
            }
            String preTaxRecordedStatus = invoice.getString(TAX_RECORDED_STATUS);
            if (kd.imc.rim.common.utils.StringUtils.isBlank((CharSequence)invoice.getString(TAX_RECORDED_STATUS))) {
                preTaxRecordedStatus = TAX_RECORDED_STATUS_01;
            }
            param.put("hasRecorded", (Object)(TAX_RECORDED_STATUS_01.equals(preTaxRecordedStatus) ? "0" : AUTO_RECORD_TIME_TYPE_1));
            if (kd.imc.rim.common.utils.StringUtils.isNotBlank((CharSequence)recordedTime)) {
                try {
                    if (Pattern.matches(DATE_FORMAT_REGEX_TIME, recordedTime)) {
                        if (TAX_RECORDED_STATUS_01.equals(preTaxRecordedStatus) || TAX_RECORDED_STATUS_06.equals(preTaxRecordedStatus)) {
                            param.put("taxRecordedTime", (Object)DateUtils.format(DateUtils.stringToDate(recordedTime, "yyyyMMdd"), "yyyy-MM-dd"));
                        }
                    } else {
                        param.put("dateRegError", (Object)AUTO_RECORD_TIME_TYPE_1);
                    }
                }
                catch (Exception e) {
                    param.put("dateRegError", (Object)AUTO_RECORD_TIME_TYPE_1);
                }
            }
            if (kd.imc.rim.common.utils.StringUtils.isNotBlank((CharSequence)recordedPeriod)) {
                if (Pattern.matches(DATE_FORMAT_REGEX_PERIOD, recordedPeriod)) {
                    if (TAX_RECORDED_STATUS_01.equals(preTaxRecordedStatus) || TAX_RECORDED_STATUS_06.equals(preTaxRecordedStatus)) {
                        param.put("taxRecordedPeriod", (Object)recordedPeriod);
                    }
                } else {
                    param.put("dateRegError", (Object)AUTO_RECORD_TIME_TYPE_1);
                }
            }
            if (kd.imc.rim.common.utils.StringUtils.isNotBlank((CharSequence)autoRecordTimeType)) {
                Date accountTime;
                Date timeAutoRecord = new Date();
                if (AUTO_RECORD_TIME_TYPE_1.equals(autoRecordTimeType) && (accountTime = invoice.getDate("account_time")) != null) {
                    timeAutoRecord = accountTime;
                }
                param.put("taxRecordedTime", (Object)DateUtils.format(timeAutoRecord, "yyyy-MM-dd"));
                param.put("taxRecordedPeriod", (Object)DateUtils.format(timeAutoRecord, "yyyyMM"));
            }
            param.put("preTaxRecordedStatus", (Object)preTaxRecordedStatus);
            if (InputInvoiceTypeEnum.isVatType(invoiceType) && ("recorded_update".equals(opereateType) || "recorded_revoke".equals(opereateType))) {
                DynamicObject invoiceDynamicObject;
                param.put("entryMarkStatus", (Object)preTaxRecordedStatus);
                String serialNo = invoice.getString("serial_no");
                String entityId = InputInvoiceTypeEnum.getEntity(invoiceType);
                QFilter serialNOFilter = new QFilter("serial_no", "=", (Object)serialNo);
                DynamicObject idObject = QueryServiceHelper.queryOne((String)entityId, (String)"id", (QFilter[])new QFilter[]{serialNOFilter});
                if (idObject != null && (invoiceDynamicObject = BusinessDataServiceHelper.loadSingle((Object)idObject.get("id"), (String)entityId)) != null) {
                    if (kd.imc.rim.common.utils.StringUtils.isNotBlank((CharSequence)invoiceDynamicObject.getString("recorded_mxuuid"))) {
                        param.put("mxuuid", (Object)invoiceDynamicObject.getString("recorded_mxuuid"));
                    }
                    if (kd.imc.rim.common.utils.StringUtils.isNotBlank((CharSequence)invoiceDynamicObject.getString("recorded_rzuuid"))) {
                        param.put("rzuuid", (Object)invoiceDynamicObject.getString("recorded_rzuuid"));
                    }
                }
            }
            String nextEntryMarkStatus = invoice.getString(TAX_RECORDED_PURPOSE);
            if (kd.imc.rim.common.utils.StringUtils.isBlank((CharSequence)invoice.getString(TAX_RECORDED_PURPOSE))) {
                nextEntryMarkStatus = "";
            }
            if (kd.imc.rim.common.utils.StringUtils.isNotBlank((CharSequence)nextEntryMarkStatusApi)) {
                nextEntryMarkStatus = nextEntryMarkStatusApi;
            }
            param.put(NEXT_ENTRY_MARK_STATUS, (Object)("recorded_revoke".equals(opereateType) ? TAX_RECORDED_STATUS_06 : nextEntryMarkStatus));
        }
        catch (NumberFormatException e) {
            logger.error("\u7c7b\u578b\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
            return null;
        }
        return param;
    }

    public static String convertInvoiceRiskLevel(String invoiceRiskLevel) {
        if (kd.imc.rim.common.utils.StringUtils.isBlank((CharSequence)invoiceRiskLevel)) {
            return "\u6b63\u5e38";
        }
        switch (invoiceRiskLevel) {
            case "1": {
                return "\u6b63\u5e38";
            }
            case "2": {
                return "\u7591\u70b9\u53d1\u7968";
            }
            case "3": {
                return "\u5f02\u5e38\u51ed\u8bc1";
            }
        }
        return "\u6b63\u5e38";
    }

    public static void batchUpateInvoiceMain(List<Object> ids, String taxRecordedPurpose, Date taxRecordedTime, Date taxRecordedPeriod, String taxRecordedStatus, String updateType) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(ids)) {
            return;
        }
        String tenantNo = TenantUtils.getTenantNo();
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"rim_invoice");
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)mainEntityType);
        if (dynamicObjects == null || dynamicObjects.length <= 0) {
            return;
        }
        ArrayList<DynamicObject> addDynamicObjects = new ArrayList<DynamicObject>(dynamicObjects.length);
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            HashMap<Long, List> typeMap = new HashMap<Long, List>(12);
            for (DynamicObject mainDynamicObject : dynamicObjects) {
                String serialNo1 = mainDynamicObject.getString("serial_no");
                Long typeId = mainDynamicObject.getLong("invoice_type_id");
                List list = typeMap.getOrDefault(typeId, new ArrayList(8));
                list.add(serialNo1);
                typeMap.put(typeId, list);
                String taxRecordedStatusDB = mainDynamicObject.getString(TAX_RECORDED_STATUS);
                if (kd.imc.rim.common.utils.StringUtils.isNotBlank((CharSequence)taxRecordedStatusDB) && "recorded_commit".equals(updateType)) continue;
                if (kd.imc.rim.common.utils.StringUtils.isNotBlank((CharSequence)taxRecordedPurpose)) {
                    mainDynamicObject.set(TAX_RECORDED_PURPOSE, (Object)taxRecordedPurpose);
                }
                if (kd.imc.rim.common.utils.StringUtils.isNotBlank((CharSequence)taxRecordedStatus)) {
                    mainDynamicObject.set(TAX_RECORDED_STATUS, (Object)taxRecordedStatus);
                }
                if (UPDATE_TYPE_TIME.equals(updateType)) {
                    mainDynamicObject.set(TAX_RECORDED_TIME, (Object)taxRecordedTime);
                    mainDynamicObject.set(TAX_RECORDED_PERIOD, (Object)taxRecordedPeriod);
                }
                addDynamicObjects.add(mainDynamicObject);
            }
            try (TXHandle h = TX.required();){
                try {
                    for (Map.Entry entry : typeMap.entrySet()) {
                        String entity;
                        Object[] invoiceList;
                        if (ObjectUtils.isEmpty(entry) || ArrayUtils.isEmpty((Object[])(invoiceList = InvoiceQueryService.loadAllBySerialNo(entity = InputInvoiceTypeEnum.getEntity((Long)entry.getKey()), tenantNo, (Collection)entry.getValue())))) continue;
                        for (Object bodyDynamicObject : invoiceList) {
                            String taxRecordedStatusDB;
                            if (bodyDynamicObject == null || kd.imc.rim.common.utils.StringUtils.isNotBlank((CharSequence)(taxRecordedStatusDB = bodyDynamicObject.getString(TAX_RECORDED_STATUS))) && "recorded_commit".equals(updateType)) continue;
                            if (kd.imc.rim.common.utils.StringUtils.isNotBlank((CharSequence)taxRecordedPurpose)) {
                                bodyDynamicObject.set(TAX_RECORDED_PURPOSE, (Object)taxRecordedPurpose);
                            }
                            if (kd.imc.rim.common.utils.StringUtils.isNotBlank((CharSequence)taxRecordedStatus)) {
                                bodyDynamicObject.set(TAX_RECORDED_STATUS, (Object)taxRecordedStatus);
                            }
                            if (!UPDATE_TYPE_TIME.equals(updateType)) continue;
                            bodyDynamicObject.set(TAX_RECORDED_TIME, (Object)taxRecordedTime);
                            bodyDynamicObject.set(TAX_RECORDED_PERIOD, (Object)taxRecordedPeriod);
                        }
                        SaveServiceHelper.save((DynamicObject[])invoiceList);
                    }
                    SaveServiceHelper.save((DynamicObject[])addDynamicObjects.toArray(new DynamicObject[addDynamicObjects.size()]));
                }
                catch (Throwable e) {
                    h.markRollback();
                    throw e;
                }
            }
        }
    }

    public static void removeLoopLoginCache(IPageCache pageCache) {
        pageCache.remove(CACHE_RECORDED_KEY_TAX_NO);
        pageCache.remove(CACHE_RECORDED_LOGIN_TAX_NO);
        pageCache.remove(CACHE_OPERATION_RESULT);
        pageCache.remove(CACHE_RECORDED_TITLE);
    }

    public void dealInvoiceSuccess(JSONObject result, String type) {
        if (result == null) {
            return;
        }
        ArrayList<JSONObject> resultList = new ArrayList<JSONObject>(1);
        resultList.add(result);
        List list = (List)result.get((Object)"invoices");
        Map<String, JSONObject> map = list.stream().collect(Collectors.toMap(k -> {
            String invoiceCode = k.getString("invoiceCode");
            String invoiceNo = k.getString("invoiceNo");
            return CommonUtils.getInvoiceCodeNoGroup(invoiceCode, invoiceNo);
        }, v -> v, (k1, k2) -> k2));
        this.saveRecordedLog(resultList, map, type);
    }

    public static boolean checkEleNoLength(String invoiceNo) {
        if (kd.imc.rim.common.utils.StringUtils.isBlank((CharSequence)invoiceNo)) {
            return false;
        }
        return invoiceNo.length() == 20;
    }

    public static JSONObject checkEleNo(String invoiceNo, String etaxInvoiceNo, Integer awsInvoiceType, String codeGroup) {
        if (InputInvoiceTypeEnum.isEleByAwsType(String.valueOf(awsInvoiceType)).booleanValue() && !RecordedConstant.checkEleNoLength(invoiceNo)) {
            return ResultContant.createJSONObject("0202", String.format(ResManager.loadKDString((String)"\u53d1\u7968\uff1a%1$s\u6570\u7535\u53f7\u7801\u9519\u8bef\uff0c\u8bf7\u4ece\u7a0e\u5c40\u4e0b\u8f7d\u53d1\u7968\u540e\u518d\u5165\u8d26", (String)"RecordedConstant_14", (String)"imc-rim-common", (Object[])new Object[0]), codeGroup));
        }
        if (InputInvoiceTypeEnum.isElePaperByAwsType(String.valueOf(awsInvoiceType)).booleanValue() && StringUtils.isNotBlank((CharSequence)etaxInvoiceNo) && !RecordedConstant.checkEleNoLength(etaxInvoiceNo)) {
            return ResultContant.createJSONObject("0202", String.format(ResManager.loadKDString((String)"\u53d1\u7968\uff1a%1$s\u6570\u7535\u53f7\u7801\u9519\u8bef\uff0c\u8bf7\u4ece\u7a0e\u5c40\u4e0b\u8f7d\u53d1\u7968\u540e\u518d\u5165\u8d26", (String)"RecordedConstant_14", (String)"imc-rim-common", (Object[])new Object[0]), codeGroup));
        }
        return null;
    }

    public void saveRecordedLog(List<JSONObject> resultList, Map<String, JSONObject> originalInvoiceMap, String operateType) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(resultList)) {
            return;
        }
        ArrayList successInvoiceList = new ArrayList(1);
        String operateTypedb = "02";
        if ("recorded_update".equals(operateType)) {
            operateTypedb = "03";
        } else if ("recorded_revoke".equals(operateType)) {
            operateTypedb = TAX_RECORDED_STATUS_06;
        }
        String userId = RequestContext.get().getUserId();
        long orgId = RequestContext.get().getOrgId();
        String tenantNo = TenantUtils.getTenantNo();
        for (JSONObject jsonObject : resultList) {
            boolean fail;
            String selectOperaType;
            Long orgIdAutoRecord;
            if (jsonObject.containsKey((Object)"orgId") && (orgIdAutoRecord = jsonObject.getLong("orgId")) != null && orgIdAutoRecord > 0L && orgId <= 0L) {
                orgId = orgIdAutoRecord;
            }
            String selectOperaTypeAuto = jsonObject.getString("selectOperaTypeAuto");
            String api = jsonObject.getString("api");
            String string = selectOperaType = AUTO_RECORD_TIME_TYPE_1.equals(api) ? "3" : AUTO_RECORD_TIME_TYPE_1;
            if (kd.imc.rim.common.utils.StringUtils.isNotBlank((CharSequence)selectOperaTypeAuto)) {
                selectOperaType = selectOperaTypeAuto;
            }
            String taskNo = jsonObject.getString("taskNo");
            String taxNo = jsonObject.getString("taxNo");
            String dktype = jsonObject.getString("dktype");
            JSONObject result = jsonObject.getJSONObject("result");
            String errcode = result.getString("errcode");
            String description = result.getString("description");
            if (StringUtils.isNotEmpty((CharSequence)description) && description.length() > 100) {
                description = description.substring(0, 100);
            }
            JSONObject data = result.getJSONObject("data");
            String batchNo = "";
            if (data != null && data.containsKey((Object)"batchNo")) {
                Object batchNoObj = data.get((Object)"batchNo");
                if (!ObjectUtils.isEmpty((Object)batchNoObj)) {
                    batchNo = batchNoObj.toString();
                }
            } else {
                batchNo = UUID.getBatchNo();
            }
            List invoices = (List)jsonObject.get((Object)"invoices");
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)invoices)) continue;
            ArrayList<DynamicObject> selectAccountList = new ArrayList<DynamicObject>(invoices.size());
            boolean bl = fail = !"0000".equals(errcode);
            if (!fail) {
                successInvoiceList.addAll(invoices);
            }
            for (JSONObject jsonObject1 : invoices) {
                String invoiceNo;
                String invoiceCode = jsonObject1.getString("invoiceCode");
                JSONObject invoice = originalInvoiceMap.get(CommonUtils.getInvoiceCodeNoGroup(invoiceCode, invoiceNo = jsonObject1.getString("invoiceNo")));
                if (invoice == null) continue;
                DynamicObject accountObject = BusinessDataServiceHelper.newDynamicObject((String)"rim_select_account");
                accountObject.set("serial_no", (Object)invoice.getString("serialNo"));
                accountObject.set("batch_no", (Object)batchNo);
                accountObject.set("invoice_type", (Object)InputInvoiceTypeEnum.getInvoiceTypeByAwsType(String.valueOf(invoice.getInteger("invoiceType"))));
                accountObject.set("org", (Object)(invoice.getLongValue("org") != 0L ? invoice.getLongValue("org") : orgId));
                accountObject.set("deduction_purpose", (Object)invoice.getString(NEXT_ENTRY_MARK_STATUS));
                accountObject.set("pre_authenticate_flag", (Object)invoice.getString("preTaxRecordedStatus"));
                accountObject.set("handle_status", (Object)(fail ? AUTO_RECORD_TIME_TYPE_2 : "3"));
                accountObject.set("invoice_code", invoice.get((Object)"invoiceCode"));
                accountObject.set("invoice_no", invoice.get((Object)"invoiceNo"));
                accountObject.set("electronic_no", (Object)invoice.getString("etaxInvoiceNo"));
                accountObject.set("invoice_amount", (Object)invoice.getBigDecimal("invoiceAmount"));
                accountObject.set("total_tax_amount", (Object)invoice.getBigDecimal("totalTaxAmount"));
                if (kd.imc.rim.common.utils.StringUtils.isNotBlank((CharSequence)invoice.getString("invoiceDate"))) {
                    accountObject.set("invoice_date", (Object)DateUtils.stringToDate(invoice.getString("invoiceDate"), "yyyy-MM-dd HH:mm:ss"));
                }
                accountObject.set("saler_tax_no", (Object)invoice.getString("salerTaxNo"));
                accountObject.set("saler_name", (Object)invoice.getString("salerName"));
                accountObject.set("manage_status", (Object)"0");
                Date selectTime = null;
                if ("4".equals(dktype) && kd.imc.rim.common.utils.StringUtils.isNotBlank((CharSequence)invoice.getString("taxRecordedTime"))) {
                    selectTime = DateUtils.stringToDate(invoice.getString("taxRecordedTime"), "yyyy-MM-dd");
                }
                if ("5".equals(dktype) && kd.imc.rim.common.utils.StringUtils.isNotBlank((CharSequence)invoice.getString("taxRecordedPeriod"))) {
                    selectTime = DateUtils.stringToDate(invoice.getString("taxRecordedPeriod"), "yyyyMM");
                }
                accountObject.set("select_time", selectTime);
                accountObject.set("creater", (Object)userId);
                accountObject.set("select_opera_type", (Object)selectOperaType);
                if (fail) {
                    String invoiceDescription = invoice.getString("description");
                    if (kd.imc.rim.common.utils.StringUtils.isNotBlank((CharSequence)invoiceDescription) && invoiceDescription.length() > 100) {
                        invoiceDescription = invoiceDescription.substring(0, 100);
                    }
                    accountObject.set("description", (Object)(kd.imc.rim.common.utils.StringUtils.isNotBlank((CharSequence)invoiceDescription) ? invoiceDescription : description));
                }
                accountObject.set("create_time", (Object)new Date());
                accountObject.set(UPDATE_TYPE_TIME, (Object)new Date());
                accountObject.set("tenant_no", (Object)tenantNo);
                selectAccountList.add(accountObject);
            }
            SelectLog selectLog = new SelectLog();
            selectLog.setBatchNo(batchNo);
            selectLog.setAccount(result.getString("account"));
            selectLog.setTaskNo(kd.imc.rim.common.utils.StringUtils.isNotBlank((CharSequence)taskNo) ? taskNo : UUID.randomUUID());
            selectLog.setFailNum(0);
            selectLog.setSuccessNum(0);
            if (fail) {
                selectLog.setDescription(description);
                selectLog.setFailNum(invoices.size());
            }
            selectLog.setTotalNum(invoices.size());
            selectLog.setSelectType("7");
            selectLog.setOperateType(operateTypedb);
            selectLog.setSelectOperaType(selectOperaType);
            selectLog.setOrgId(orgId);
            selectLog.setUserId(userId);
            selectLog.setTaxNo(taxNo);
            selectLog.setAsyncFlag(AUTO_RECORD_TIME_TYPE_1);
            selectLog.setHandleStatus(fail ? AUTO_RECORD_TIME_TYPE_2 : "3");
            String billType = jsonObject.getString("billType");
            selectLog.setBillType(org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)billType) ? billType : "0");
            TXHandle h = TX.required();
            Throwable throwable = null;
            try {
                try {
                    if (!CollectionUtils.isEmpty(successInvoiceList)) {
                        RecordedConstant.batchUpateInvoiceMain(successInvoiceList.stream().map(t -> t.getLong("id")).collect(Collectors.toList()), null, null, null, TAX_RECORDED_STATUS_11, TAX_RECORDED_STATUS);
                    }
                    SelectAccountService.insertSelectLog(selectLog);
                    SaveServiceHelper.save((DynamicObject[])selectAccountList.toArray(new DynamicObject[selectAccountList.size()]));
                }
                catch (Throwable e) {
                    logger.error("\u52fe\u9009\u65e5\u5fd7/\u53f0\u8d26\u5931\u8d25", e);
                    h.markRollback();
                    throw e;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (h == null) continue;
                if (throwable != null) {
                    try {
                        h.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                h.close();
            }
        }
    }
}

