/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.constant;

import kd.bos.dataentity.utils.StringUtils;
import kd.imc.rim.common.utils.InvoiceConvertUtils;

public class TaxExcelImportConstant {
    public static final String IMPORT_DEDUCT_EXCEL = "import_deduct_excel";
    public static final String IMPORT_NOT_DEDUCT_EXCEL = "import_not_deduct_excel";
    public static final String IMPORT_HKJK_DEDUCT = "import_hkjk_deduct";
    public static final String IMPORT_HKJK_NOT_DEDUCT = "import_hkjk_not_deduct";
    public static final String IMPORT_DKDJ_DEDUCT = "import_dkdj_deduct";
    public static final String IMPORT_DKDJ_NOT_DEDUCT = "import_dkdj_not_deduct";
    public static final String IMPORT_AUTHENTICATE_EXCEL = "import_authenticate_excel";

    public static Boolean isDeductTaxExcelImport(String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return false;
        }
        return IMPORT_DEDUCT_EXCEL.equals(key) || IMPORT_NOT_DEDUCT_EXCEL.equals(key) || IMPORT_HKJK_DEDUCT.equals(key) || IMPORT_HKJK_NOT_DEDUCT.equals(key) || IMPORT_DKDJ_DEDUCT.equals(key) || IMPORT_DKDJ_NOT_DEDUCT.equals(key);
    }

    public static Boolean isTaxExcelImport(String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return false;
        }
        return IMPORT_DEDUCT_EXCEL.equals(key) || IMPORT_NOT_DEDUCT_EXCEL.equals(key) || IMPORT_AUTHENTICATE_EXCEL.equals(key) || IMPORT_HKJK_DEDUCT.equals(key) || IMPORT_HKJK_NOT_DEDUCT.equals(key) || IMPORT_DKDJ_DEDUCT.equals(key) || IMPORT_DKDJ_NOT_DEDUCT.equals(key);
    }

    public static String getInvoiceStatus(String status) {
        String invoiceStatus = "0";
        if (StringUtils.isNotEmpty((CharSequence)status)) {
            if (StringUtils.contains((CharSequence)status, (CharSequence)"\u6b63\u5e38")) {
                invoiceStatus = "0";
            }
            if (StringUtils.contains((CharSequence)status, (CharSequence)"\u4f5c\u5e9f")) {
                invoiceStatus = "2";
            } else if (StringUtils.contains((CharSequence)status, (CharSequence)"\u5f02\u5e38")) {
                invoiceStatus = "4";
            } else if (StringUtils.contains((CharSequence)status, (CharSequence)"\u7ea2\u51b2")) {
                invoiceStatus = "3";
                if (StringUtils.contains((CharSequence)status, (CharSequence)"\u90e8\u5206")) {
                    invoiceStatus = "7";
                }
                if (StringUtils.contains((CharSequence)status, (CharSequence)"\u5168\u989d")) {
                    invoiceStatus = "8";
                }
            }
            if (StringUtils.contains((CharSequence)status, (CharSequence)"\u5f85\u786e\u8ba4")) {
                invoiceStatus = "6";
            }
        }
        return invoiceStatus;
    }

    public static String getInvoiceType(String invoiceType, String invoiceCode, String invoiceNo) {
        String awsType = "";
        if (StringUtils.isNotEmpty((CharSequence)invoiceType)) {
            if (StringUtils.contains((CharSequence)invoiceType, (CharSequence)"\u7535\u5b50\u666e\u901a")) {
                awsType = "1";
            } else if (StringUtils.contains((CharSequence)invoiceType, (CharSequence)"\u901a\u884c\u8d39")) {
                awsType = "15";
            } else if (StringUtils.contains((CharSequence)invoiceType, (CharSequence)"\u7535\u5b50\u4e13\u7528")) {
                awsType = "2";
            } else if (StringUtils.contains((CharSequence)invoiceType, (CharSequence)"\u7535\u5b50\u53d1\u7968") && StringUtils.contains((CharSequence)invoiceType, (CharSequence)"\u666e\u901a")) {
                awsType = "26";
            } else if (StringUtils.contains((CharSequence)invoiceType, (CharSequence)"\u7535\u5b50\u53d1\u7968") && StringUtils.contains((CharSequence)invoiceType, (CharSequence)"\u4e13\u7528")) {
                awsType = "27";
            } else if (StringUtils.contains((CharSequence)invoiceType, (CharSequence)"\u6570\u7535") && StringUtils.contains((CharSequence)invoiceType, (CharSequence)"\u666e\u901a")) {
                awsType = "26";
            } else if (StringUtils.contains((CharSequence)invoiceType, (CharSequence)"\u6570\u7535") && StringUtils.contains((CharSequence)invoiceType, (CharSequence)"\u4e13\u7528")) {
                awsType = "27";
            } else if (StringUtils.contains((CharSequence)invoiceType, (CharSequence)"\u7535\u5b50\u53d1\u7968") && StringUtils.contains((CharSequence)invoiceType, (CharSequence)"\u6570\u7535")) {
                awsType = "26";
            } else if (StringUtils.contains((CharSequence)invoiceType, (CharSequence)"\u7535\u5b50\u53d1\u7968") && StringUtils.contains((CharSequence)invoiceType, (CharSequence)"\u94c1\u8def")) {
                awsType = "29";
            } else if (TaxExcelImportConstant.isEleTypeExcel(invoiceType).booleanValue() && StringUtils.contains((CharSequence)invoiceType, (CharSequence)"\u822a\u7a7a\u8fd0\u8f93")) {
                awsType = "28";
            } else if (TaxExcelImportConstant.isEleTypeExcel(invoiceType).booleanValue() && StringUtils.contains((CharSequence)invoiceType, (CharSequence)"\u94c1\u8def")) {
                awsType = "29";
            } else if (StringUtils.contains((CharSequence)invoiceType, (CharSequence)"\u6570\u7535") && StringUtils.contains((CharSequence)invoiceType, (CharSequence)"\u673a\u52a8\u8f66")) {
                awsType = "83";
            } else if (StringUtils.contains((CharSequence)invoiceType, (CharSequence)"\u6570\u7535") && StringUtils.contains((CharSequence)invoiceType, (CharSequence)"\u4e8c\u624b\u8f66")) {
                awsType = "84";
            } else if (StringUtils.contains((CharSequence)invoiceType, (CharSequence)"\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968")) {
                awsType = "3";
            } else if (StringUtils.contains((CharSequence)invoiceType, (CharSequence)"\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968")) {
                awsType = "4";
            } else if (StringUtils.contains((CharSequence)invoiceType, (CharSequence)"\u673a\u52a8\u8f66")) {
                awsType = "12";
            } else if (StringUtils.contains((CharSequence)invoiceType, (CharSequence)"\u4e8c\u624b\u8f66")) {
                awsType = "13";
            }
            String qdzp = TaxExcelImportConstant.isQdzp(invoiceType);
            if (StringUtils.isNotEmpty((CharSequence)qdzp)) {
                awsType = qdzp;
            } else if ("1".equals(awsType) || "3".equals(awsType)) {
                awsType = InvoiceConvertUtils.checkInvoiceType(invoiceCode, invoiceNo);
            }
        }
        return awsType;
    }

    public static Boolean isEleTypeExcel(String chniese) {
        if (StringUtils.isEmpty((CharSequence)chniese)) {
            return false;
        }
        return StringUtils.contains((CharSequence)chniese, (CharSequence)"\u6570\u7535\u7968") || StringUtils.contains((CharSequence)chniese, (CharSequence)"\u6570\u7535\u53d1\u7968");
    }

    public static String isQdzp(String invoiceType) {
        String awsType = "";
        if (StringUtils.contains((CharSequence)invoiceType, (CharSequence)"\u6570\u7535\u7eb8\u8d28\u53d1\u7968") && StringUtils.contains((CharSequence)invoiceType, (CharSequence)"\u666e\u901a")) {
            awsType = "3";
        } else if (StringUtils.contains((CharSequence)invoiceType, (CharSequence)"\u7eb8\u8d28\u53d1\u7968") && StringUtils.contains((CharSequence)invoiceType, (CharSequence)"\u666e\u901a")) {
            awsType = "3";
        } else if (StringUtils.contains((CharSequence)invoiceType, (CharSequence)"\u6570\u7535\u7eb8\u8d28\u53d1\u7968") && StringUtils.contains((CharSequence)invoiceType, (CharSequence)"\u4e13\u7528")) {
            awsType = "4";
        } else if (StringUtils.contains((CharSequence)invoiceType, (CharSequence)"\u7eb8\u8d28\u53d1\u7968") && StringUtils.contains((CharSequence)invoiceType, (CharSequence)"\u4e13\u7528")) {
            awsType = "4";
        }
        return awsType;
    }
}

