/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.expense.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.ek.EkServiceFactory;
import kd.imc.rim.common.ek.service.InvoiceSaveEkService;
import kd.imc.rim.common.expense.domain.ExpenseInvoiceDTO;
import kd.imc.rim.common.expense.service.ExpenseService;
import kd.imc.rim.common.invoice.query.InvoiceQueryService;
import kd.imc.rim.common.invoice.save.InvoiceSaveService;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.service.InvoiceLog;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.TenantUtils;
import kd.sdk.annotation.SdkDeprecated;

public class VoucherService {
    private static Log LOGGER = LogFactory.getLog(VoucherService.class);
    private static final String OPERATE_TYPE_SAVE = "1";
    private static final String OPERATE_TYPE_DELETE = "2";
    private static final String ACCOUNT_DATE_REGEX = "^\\d{4}(?:0[1-9]|1[0-2])(?:0[1-9]|[12][0-9]|3[01])$";
    private static final String ACCOUNT_TIME_REGEX = "^\\d{4}-(?:0[1-9]|1[0-2])-(?:0[1-9]|[12][0-9]|3[01]) (?:[01]?[0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9]$";

    public String saveVoucherCover(Map<String, Object> param) {
        Object billIdFilter2;
        List vouchIdList;
        QFilter vouchIdFilter;
        QFilter serialNOFilter;
        DynamicObjectCollection vouchRelationInvCollection;
        boolean addFlag;
        String json = SerializationUtils.toJsonString(param);
        LOGGER.info("\u51ed\u8bc1\u8986\u76d6\u4fdd\u5b58:" + json);
        JSONObject paramJson = JSONObject.parseObject((String)json);
        String expenseId = paramJson.getString("expenseId");
        String resource = paramJson.getString("resource");
        if (StringUtils.isBlank((CharSequence)expenseId)) {
            LOGGER.error("\u5355\u636eID\u4e3a\u7a7a" + paramJson);
            throw new MsgException("1001", ResManager.loadKDString((String)"\u5355\u636eID\u4e0d\u80fd\u4e3a\u7a7a", (String)"VoucherService_2", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)resource)) {
            LOGGER.error("\u6765\u6e90\u4e3a\u7a7a" + paramJson);
            throw new MsgException("1001", ResManager.loadKDString((String)"\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a", (String)"VoucherService_3", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        JSONArray vouchArray = new JSONArray();
        if (paramJson.containsKey((Object)"vouchArray") && paramJson.get((Object)"vouchArray") != null) {
            vouchArray = paramJson.getJSONArray("vouchArray");
        }
        boolean bl = addFlag = !vouchArray.isEmpty();
        if (!addFlag) {
            LOGGER.info("\u65e0\u65b0\u589e\u51ed\u8bc1\u4fe1\u606f\uff1a" + paramJson);
        }
        JSONArray expenseIdArray = new JSONArray();
        expenseIdArray.add((Object)expenseId);
        JSONArray serialNoArray = this.getSerialNosFromExpense(expenseIdArray);
        QFilter resourceFilter = new QFilter("resource", "=", (Object)resource);
        QFilter billIdFilter = new QFilter("billid", "=", (Object)expenseId);
        QFilter billTypeFilter = new QFilter("bill_type", "=", (Object)OPERATE_TYPE_SAVE);
        DynamicObjectCollection vouchRelationCollection = QueryServiceHelper.query((String)"rim_vouch_relation", (String)"id,billid, bill_type, vouchid, resource", (QFilter[])new QFilter[]{billIdFilter, billTypeFilter, resourceFilter});
        if (CollectionUtils.isEmpty((Collection)vouchRelationCollection) && !addFlag) {
            LOGGER.info("\u5355\u636e\u672a\u5173\u8054\u51ed\u8bc1\uff0c\u5e76\u4e14\u65e0\u65b0\u589e\u51ed\u8bc1\u4fe1\u606f\uff1a" + paramJson);
            return null;
        }
        if (!(CollectionUtils.isEmpty((Collection)vouchRelationCollection) || serialNoArray.isEmpty() || CollectionUtils.isEmpty((Collection)(vouchRelationInvCollection = QueryServiceHelper.query((String)"rim_vouch_relation", (String)"id, billid, bill_type, vouchid, resource", (QFilter[])new QFilter[]{serialNOFilter = new QFilter("billid", "in", (Object)serialNoArray), vouchIdFilter = new QFilter("vouchid", "in", vouchIdList = vouchRelationCollection.stream().map(t -> t.getString("vouchid")).collect(Collectors.toList())), billIdFilter2 = new QFilter("bill_type", "=", (Object)OPERATE_TYPE_DELETE), resourceFilter}))))) {
            vouchRelationCollection.addAll((Collection)vouchRelationInvCollection);
        }
        List<Object> addVouchRelationList = new ArrayList();
        if (addFlag) {
            addVouchRelationList = this.getVouchAddParam(expenseId, resource, serialNoArray, vouchArray);
        }
        if (!CollectionUtils.isEmpty((Collection)vouchRelationCollection) || !CollectionUtils.isEmpty(addVouchRelationList)) {
            try (TXHandle h = TX.requiresNew();){
                try {
                    if (!CollectionUtils.isEmpty((Collection)vouchRelationCollection)) {
                        LOGGER.info("\u5220\u9664\u5355\u636e\u51ed\u8bc1\u3001\u53d1\u7968\u51ed\u8bc1\u5173\u8054\uff0c\u4e2a\u6570" + vouchRelationCollection.size());
                        DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"rim_vouch_relation"), (Object[])vouchRelationCollection.stream().map(t -> t.get("id")).toArray());
                        if (ExpenseService.dealReimEntry()) {
                            for (DynamicObject object : vouchRelationCollection) {
                                this.deleteInvoiceVouchEntry(serialNoArray, object.getString("resource"), object.getString("vouchid"));
                            }
                        }
                    }
                    if (!CollectionUtils.isEmpty(addVouchRelationList)) {
                        LOGGER.info("\u65b0\u589e\u5355\u636e\u51ed\u8bc1\u3001\u53d1\u7968\u51ed\u8bc1\u5173\u8054, \u4e2a\u6570" + vouchRelationCollection.size());
                        SaveServiceHelper.save((DynamicObject[])addVouchRelationList.toArray(new DynamicObject[0]));
                        if (ExpenseService.dealReimEntry()) {
                            for (Object vouchAdd : vouchArray) {
                                JSONObject paramJsonAdd = new JSONObject();
                                paramJsonAdd.put("expenseIdArray", (Object)expenseIdArray);
                                paramJsonAdd.put("serialNoArray", (Object)serialNoArray);
                                paramJsonAdd.put("voucherInfo", vouchAdd);
                                this.saveInvoiceVouchEntry(paramJsonAdd);
                            }
                        }
                    }
                    if (!serialNoArray.isEmpty()) {
                        this.updateInvoiceMain(serialNoArray);
                    }
                    InvoiceLog.insertExpenseLog("\u51ed\u8bc1\u8986\u76d6\u4fdd\u5b58", expenseId, "", json);
                }
                catch (Throwable e) {
                    LOGGER.error("\u51ed\u8bc1\u8986\u76d6\u4fdd\u5b58\u63a5\u53e3\u5f02\u5e38\uff1a" + paramJson);
                    h.markRollback();
                    throw e;
                }
            }
        }
        return null;
    }

    private List<DynamicObject> getVouchAddParam(String expenseId, String resource, JSONArray serialNoArray, JSONArray vouchArray) {
        ArrayList<DynamicObject> vouchRelationList = new ArrayList<DynamicObject>(8);
        if (!CollectionUtils.isEmpty((Collection)vouchArray)) {
            for (int i = 0; i < vouchArray.size(); ++i) {
                JSONObject voucherInfo = vouchArray.getJSONObject(i);
                if (voucherInfo == null) continue;
                voucherInfo.put("resource", (Object)resource);
                if (!StringUtils.isNotEmpty((CharSequence)voucherInfo.getString("vouchId")) || !StringUtils.isNotEmpty((CharSequence)voucherInfo.getString("vouchNo"))) continue;
                DynamicObject vouchRelationBillObj = this.getVouchRelationObj(voucherInfo);
                vouchRelationBillObj.set("billid", (Object)expenseId);
                vouchRelationBillObj.set("bill_type", (Object)OPERATE_TYPE_SAVE);
                vouchRelationList.add(vouchRelationBillObj);
                if (serialNoArray.isEmpty()) continue;
                for (Object serialNo : serialNoArray) {
                    DynamicObject vouchRelationInvoiceObj = this.getVouchRelationObj(voucherInfo);
                    vouchRelationInvoiceObj.set("billid", serialNo);
                    vouchRelationInvoiceObj.set("bill_type", (Object)OPERATE_TYPE_DELETE);
                    vouchRelationList.add(vouchRelationInvoiceObj);
                }
            }
        }
        return vouchRelationList;
    }

    private DynamicObject getVouchRelationObj(JSONObject voucherInfo) {
        Pattern pattern;
        Matcher matcher;
        DynamicObject vouchRelationObj = BusinessDataServiceHelper.newDynamicObject((String)"rim_vouch_relation");
        String vouchId = voucherInfo.getString("vouchId");
        String vouchNo = voucherInfo.getString("vouchNo");
        String resource = voucherInfo.getString("resource");
        String accountDateStr = voucherInfo.getString("accountDate");
        String accountTimeStr = voucherInfo.getString("accountTime");
        Date accountDate = null;
        Date accountTime = null;
        if (StringUtils.isNotEmpty((CharSequence)accountDateStr)) {
            if (accountDateStr.indexOf(45) > 0) {
                accountDateStr = accountDateStr.replace("-", "");
            }
            if ((matcher = (pattern = Pattern.compile(ACCOUNT_DATE_REGEX)).matcher(accountDateStr)).find()) {
                accountDate = DateUtils.getFirstDateOfMonth(DateUtils.stringToDate(accountDateStr, "yyyyMMdd"));
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)accountTimeStr)) {
            try {
                pattern = Pattern.compile(ACCOUNT_TIME_REGEX);
                matcher = pattern.matcher(accountTimeStr);
                if (matcher.find()) {
                    accountTime = voucherInfo.getDate("accountTime");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (accountTime == null && accountDate != null) {
            accountTime = DateUtils.stringToDate(accountDateStr, "yyyyMMdd");
        }
        vouchRelationObj.set("vouchid", (Object)vouchId);
        vouchRelationObj.set("vouch_no", (Object)vouchNo);
        vouchRelationObj.set("account_date", accountDate);
        if (accountTime != null) {
            vouchRelationObj.set("account_time", (Object)accountTime);
        } else {
            vouchRelationObj.set("account_time", (Object)new Date());
        }
        vouchRelationObj.set("resource", (Object)resource);
        return vouchRelationObj;
    }

    @SdkDeprecated
    public String saveVoucher(Map<String, Object> param) {
        Throwable throwable = null;
        try (TXHandle h = TX.requiresNew();){
            String string = this.saveVoucherContent(param);
            return string;
        }
        catch (Throwable e) {
            try {
                h.markRollback();
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public String saveVoucherContent(Map<String, Object> param) {
        String json = SerializationUtils.toJsonString(param);
        LOGGER.info("\u4fdd\u5b58\u51ed\u8bc1\u53c2\u6570:" + json);
        JSONObject paramJson = JSONObject.parseObject((String)json);
        JSONArray expenseIdArray = paramJson.getJSONArray("expenseIdArray");
        JSONArray serialNoArray = paramJson.getJSONArray("serialNoArray");
        if (CollectionUtils.isEmpty((Collection)expenseIdArray) && CollectionUtils.isEmpty((Collection)serialNoArray)) {
            LOGGER.error("\u62a5\u9500\u5355ID\u548c\u6d41\u6c34\u53f7\u96c6\u5408\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a" + paramJson);
            throw new MsgException("1001", ResManager.loadKDString((String)"\u62a5\u9500\u5355ID\u548c\u6d41\u6c34\u53f7\u96c6\u5408\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a", (String)"VoucherService_0", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        String vouchNo = null;
        JSONObject voucherInfo = paramJson.getJSONObject("voucherInfo");
        if (voucherInfo != null && StringUtils.isNotEmpty((CharSequence)voucherInfo.getString("vouchId")) && StringUtils.isNotEmpty((CharSequence)voucherInfo.getString("vouchNo"))) {
            String vouchId = voucherInfo.getString("vouchId");
            vouchNo = voucherInfo.getString("vouchNo");
            String resource = voucherInfo.getString("resource");
            String accountDateStr = voucherInfo.getString("accountDate");
            String accountTimeStr = voucherInfo.getString("accountTime");
            Date accountDate = null;
            Date accountTime = null;
            if (StringUtils.isNotEmpty((CharSequence)accountDateStr)) {
                if (accountDateStr.indexOf(45) > 0) {
                    accountDateStr = accountDateStr.replace("-", "");
                }
                accountDate = DateUtils.getFirstDateOfMonth(DateUtils.stringToDate(accountDateStr, "yyyyMMdd"));
                if (StringUtils.isNotEmpty((CharSequence)accountTimeStr)) {
                    try {
                        accountTime = voucherInfo.getDate("accountTime");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (accountTime == null) {
                    accountTime = DateUtils.stringToDate(accountDateStr, "yyyyMMdd");
                }
            } else {
                throw new MsgException("1001", ResManager.loadKDString((String)"\u5165\u8d26\u5c5e\u671faccountDate\u4e0d\u80fd\u4e3a\u7a7a", (String)"VoucherService_4", (String)"imc-rim-common", (Object[])new Object[0]));
            }
            QFilter idFilter = new QFilter("vouchid", "=", (Object)vouchId);
            QFilter resourceFilter = new QFilter("resource", "=", (Object)resource);
            DynamicObjectCollection collect = QueryServiceHelper.query((String)"rim_vouch_relation", (String)"id,bill_type,billid", (QFilter[])new QFilter[]{idFilter, resourceFilter});
            HashMap<String, Object> existsSet = new HashMap<String, Object>(8);
            if (!CollectionUtils.isEmpty((Collection)collect)) {
                for (DynamicObject obj : collect) {
                    existsSet.put(obj.getString("bill_type") + obj.getString("billid"), obj.get("id"));
                }
            }
            LOGGER.info("\u5df2\u5b58\u5728\u7684\u5355\u636e\uff1a{}", existsSet);
            ArrayList<DynamicObject> vouchRelationList = new ArrayList<DynamicObject>();
            if (!CollectionUtils.isEmpty((Collection)expenseIdArray)) {
                vouchRelationList.addAll(this.getVouchRelationList(expenseIdArray, OPERATE_TYPE_SAVE, vouchId, vouchNo, accountDate, accountTime, resource, existsSet));
                JSONArray serialNoArray2 = this.getSerialNosFromExpense(expenseIdArray);
                if (serialNoArray == null) {
                    serialNoArray = new JSONArray();
                }
                serialNoArray.addAll((Collection)serialNoArray2);
            }
            if (!CollectionUtils.isEmpty((Collection)serialNoArray)) {
                vouchRelationList.addAll(this.getVouchRelationList(serialNoArray, OPERATE_TYPE_DELETE, vouchId, vouchNo, accountDate, accountTime, resource, existsSet));
            }
            SaveServiceHelper.save((DynamicObject[])vouchRelationList.toArray(new DynamicObject[0]));
            this.updateInvoiceMain(serialNoArray);
            this.saveInvoiceVouchEntry(paramJson);
            this.saveCallBack("save", vouchId, vouchNo, resource, serialNoArray.toJavaList(String.class));
            InvoiceLog.insertExpenseLog("\u4fdd\u5b58\u51ed\u8bc1\u5173\u7cfb", vouchId, vouchNo, json);
            return vouchNo;
        }
        return vouchNo;
    }

    public void deleteVoucherOfAPI(String serialNo) {
        LOGGER.info("\u5220\u9664\u51ed\u8bc1\u53c2\u6570:" + serialNo);
        if (StringUtils.isBlank((CharSequence)serialNo)) {
            return;
        }
        QFilter idFilter = new QFilter("billid", "=", (Object)serialNo);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"rim_vouch_relation", (String)"id,billid,vouchid,resource", (QFilter[])new QFilter[]{idFilter});
        if (!CollectionUtils.isEmpty((Collection)collection)) {
            try (TXHandle h = TX.required();){
                try {
                    List<Object> idList = collection.stream().map(v -> v.get("id")).collect(Collectors.toList());
                    LOGGER.info("\u5220\u9664\u51ed\u8bc1\u53c2\u6570id:" + idList);
                    DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"rim_vouch_relation"), (Object[])idList.toArray(new Object[0]));
                    JSONArray serialList = new JSONArray();
                    serialList.add((Object)serialNo);
                    this.updateInvoiceMain(serialList);
                    for (DynamicObject dynamicObject : collection) {
                        this.deleteInvoiceVouchEntry(serialList, dynamicObject.getString("resource"), dynamicObject.getString("vouchid"));
                    }
                }
                catch (Throwable e) {
                    h.markRollback();
                    throw e;
                }
            }
        }
    }

    @SdkDeprecated
    public String deleteVoucher(Map<String, Object> param) {
        Throwable throwable = null;
        try (TXHandle h = TX.requiresNew();){
            String string = this.deleteVoucherContent(param);
            return string;
        }
        catch (Throwable e) {
            try {
                h.markRollback();
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public String deleteVoucherContent(Map<String, Object> param) {
        String json = SerializationUtils.toJsonString(param);
        LOGGER.info("\u5220\u9664\u51ed\u8bc1\u53c2\u6570:" + json);
        JSONObject paramJson = JSONObject.parseObject((String)json);
        String vouchId = paramJson.getString("vouchId");
        if (StringUtils.isEmpty((CharSequence)vouchId)) {
            throw new MsgException("1001", ResManager.loadKDString((String)"\u51ed\u8bc1ID\u4e0d\u80fd\u4e3a\u7a7a", (String)"VoucherService_1", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        String resource = paramJson.getString("resource");
        JSONArray serialNoArray = paramJson.getJSONArray("serialNoArray");
        QFilter idFilter = new QFilter("vouchid", "=", (Object)vouchId);
        QFilter billidFilter = null;
        if (!CollectionUtils.isEmpty((Collection)serialNoArray)) {
            billidFilter = new QFilter("billid", "in", (Object)serialNoArray.toJavaList(String.class));
        }
        QFilter resourceFilter = new QFilter("resource", "=", (Object)resource);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"rim_vouch_relation", (String)"id,billid", (QFilter[])new QFilter[]{idFilter, resourceFilter, billidFilter});
        if (!CollectionUtils.isEmpty((Collection)collection)) {
            Object[] idList = new Object[collection.size()];
            JSONArray serialList = new JSONArray();
            for (int i = 0; i < collection.size(); ++i) {
                DynamicObject obj = (DynamicObject)collection.get(i);
                idList[i] = obj.get("id");
                serialList.add((Object)obj.getString("billid"));
            }
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"rim_vouch_relation"), (Object[])idList);
            this.updateInvoiceMain(serialList);
            this.deleteInvoiceVouchEntry(serialList, resource, vouchId);
            this.saveCallBack("delete", vouchId, paramJson.getString("vouchNo"), resource, serialList.toJavaList(String.class));
            InvoiceLog.insertExpenseLog("\u5220\u9664\u51ed\u8bc1\u5173\u7cfb", vouchId, paramJson.getString("vouchNo"), json);
        }
        return vouchId;
    }

    private void saveCallBack(String operate, String vouchId, String vouchNo, String resource, List<String> serialList) {
        InvoiceSaveEkService ekService = EkServiceFactory.getInvoiceSaveEkService();
        if ("delete".equals(operate)) {
            ekService.afterDeleteVoucher(vouchId, vouchNo, resource, serialList);
        } else {
            ekService.afterSaveVoucher(vouchId, vouchNo, resource, serialList);
        }
    }

    public DynamicObjectCollection queryVouchRelationBySerialNos(List<?> serialList) {
        if (CollectionUtils.isEmpty(serialList)) {
            return null;
        }
        QFilter billidFilter = new QFilter("billid", "in", serialList);
        Object billTypeFilter = null;
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"rim_vouch_relation", (String)"vouch_no,billid,account_time,account_date,resource", (QFilter[])new QFilter[]{billidFilter, billTypeFilter});
        return collection;
    }

    public void updateInvoiceMain(JSONArray serialList) {
        ExpenseService expenseService = new ExpenseService();
        ArrayList<String> list = new ArrayList<String>(serialList.size());
        for (int i = 0; i < serialList.size(); ++i) {
            list.add(serialList.getString(i));
        }
        expenseService.updateInvoiceMain(list, null);
    }

    private JSONArray getSerialNosFromExpense(JSONArray expenseIdArray) {
        JSONArray serialNoArray = new JSONArray();
        for (int i = 0; i < expenseIdArray.size(); ++i) {
            serialNoArray.addAll(this.queryExpenseSerialNo(expenseIdArray.getString(i)));
        }
        return serialNoArray;
    }

    private List<String> queryExpenseSerialNo(String expenseId) {
        QFilter filter = new QFilter("expense_id", "=", (Object)expenseId);
        DynamicObjectCollection serialCollection = QueryServiceHelper.query((String)"rim_expense_relation", (String)"serial_no", (QFilter[])new QFilter[]{filter});
        List<String> serialNoList = new ArrayList<String>();
        if (!CollectionUtils.isEmpty((Collection)serialCollection)) {
            serialNoList = serialCollection.stream().map(s -> s.getString("serial_no")).collect(Collectors.toList());
        }
        return serialNoList;
    }

    private List<DynamicObject> getVouchRelationList(JSONArray array, String billType, String vouchid, String vouchNo, Date accountDate, Date accountTime, String resource, Map<String, Object> existsSet) {
        ArrayList<DynamicObject> vouchRelationList = new ArrayList<DynamicObject>();
        DynamicObject vouchRelationObj = null;
        HashSet<String> set = new HashSet<String>(array.size());
        for (int i = 0; i < array.size(); ++i) {
            String key = billType + array.get(i);
            Object kevValue = existsSet.get(key);
            if (kevValue != null) {
                LOGGER.info("\u67e5\u8be2\u5df2\u5b58\u5728\u7684\u51ed\u8bc1\u5173\u7cfb:{}", kevValue);
                vouchRelationObj = BusinessDataServiceHelper.loadSingle((Object)kevValue, (String)"rim_vouch_relation");
            } else {
                if (!set.add(array.getString(i))) continue;
                vouchRelationObj = BusinessDataServiceHelper.newDynamicObject((String)"rim_vouch_relation");
                vouchRelationObj.set("bill_type", (Object)billType);
                vouchRelationObj.set("billid", array.get(i));
                vouchRelationObj.set("vouchid", (Object)vouchid);
            }
            if (vouchRelationObj == null) continue;
            vouchRelationObj.set("vouch_no", (Object)vouchNo);
            vouchRelationObj.set("account_date", (Object)accountDate);
            if (accountTime != null) {
                vouchRelationObj.set("account_time", (Object)accountTime);
            } else {
                vouchRelationObj.set("account_time", (Object)new Date());
            }
            vouchRelationObj.set("resource", (Object)resource);
            vouchRelationList.add(vouchRelationObj);
        }
        return vouchRelationList;
    }

    public void deleteVouchAndInvoiceMain(List<String> serialList, Map<String, ExpenseInvoiceDTO> invoiceDtoMap) {
        QFilter tenantFilter = new QFilter("tenant_no", "=", (Object)TenantUtils.getTenantNo());
        QFilter serialFilter = new QFilter("serial_no", "in", serialList);
        DynamicObjectCollection relationList = QueryServiceHelper.query((String)"rim_expense_relation", (String)"id,serial_no,status,expense_num", (QFilter[])new QFilter[]{serialFilter});
        HashMap<String, Integer> statusMap = new HashMap<String, Integer>(serialList.size());
        HashMap<String, Set<String>> expenNoMap = new HashMap<String, Set<String>>(serialList.size());
        for (DynamicObject obj : relationList) {
            String expense_num;
            HashSet<String> set;
            Integer status = this.getStausInteger(obj.getString("status"));
            String serailNo = obj.getString("serial_no");
            Integer status2 = (Integer)statusMap.get(serailNo);
            if (status2 == null || status > status2) {
                statusMap.put(serailNo, status);
            }
            if ((set = (HashSet<String>)expenNoMap.get(serailNo)) == null) {
                set = new HashSet<String>();
            }
            if (StringUtils.isNotEmpty((CharSequence)(expense_num = obj.getString("expense_num")))) {
                set.add(obj.getString("expense_num"));
            }
            expenNoMap.put(serailNo, set);
        }
        DynamicObjectCollection mainList = QueryServiceHelper.query((String)"rim_invoice", (String)"id,serial_no,expense_status,expense_num", (QFilter[])new QFilter[]{tenantFilter, serialFilter});
        ArrayList<Object> pkList = new ArrayList<Object>(mainList.size());
        for (DynamicObject obj : mainList) {
            pkList.add(obj.get("id"));
        }
        if (!CollectionUtils.isEmpty(pkList)) {
            this.updateMainExpense(invoiceDtoMap, statusMap, expenNoMap, pkList);
        }
        DynamicObjectCollection uncheckList = QueryServiceHelper.query((String)"rim_invoice_uncheck", (String)"id,serial_no,expense_status,expense_num", (QFilter[])new QFilter[]{tenantFilter, serialFilter});
        ArrayList<Object> uncheckPkList = new ArrayList<Object>(uncheckList.size());
        for (DynamicObject obj : uncheckList) {
            uncheckPkList.add(obj.get("id"));
        }
        if (!CollectionUtils.isEmpty(uncheckPkList)) {
            this.updateUncheckExpense(invoiceDtoMap, statusMap, expenNoMap, uncheckPkList);
        }
        if (!CollectionUtils.isEmpty(serialList)) {
            this.deleteVouchBySerialNos(serialList);
        }
    }

    private void updateUncheckExpense(Map<String, ExpenseInvoiceDTO> invoiceDtoMap, Map<String, Integer> statusMap, Map<String, Set<String>> expenNoMap, List<Object> pkList) {
        DynamicObject[] mainDynamicObjectsTemp;
        for (DynamicObject obj : mainDynamicObjectsTemp = BusinessDataServiceHelper.load((Object[])pkList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"rim_invoice_uncheck"))) {
            ExpenseInvoiceDTO dto;
            String serailNo = obj.getString("serial_no");
            Integer status2 = statusMap.get(serailNo);
            if (status2 != null) {
                obj.set("expense_status", (Object)status2.toString());
            } else {
                obj.set("expense_status", (Object)OPERATE_TYPE_SAVE);
            }
            Set<String> set = expenNoMap.get(serailNo);
            if (set == null || set.isEmpty()) {
                obj.set("expense_num", (Object)"");
            } else {
                String num = String.join((CharSequence)",", set);
                if (num.length() > 450) {
                    obj.set("expense_num", (Object)num.substring(0, 450));
                } else {
                    obj.set("expense_num", (Object)String.join((CharSequence)",", set));
                }
            }
            if (invoiceDtoMap != null && (dto = invoiceDtoMap.get(serailNo)) != null && dto.getOrgId() != null && dto.getOrgId() > 0L) {
                obj.set("org", (Object)dto.getOrgId());
            }
            obj.set("expense_time", (Object)new Date());
            obj.set("update_time", (Object)new Date());
        }
        SaveServiceHelper.save((DynamicObject[])mainDynamicObjectsTemp);
    }

    private void updateMainExpense(Map<String, ExpenseInvoiceDTO> invoiceDtoMap, Map<String, Integer> statusMap, Map<String, Set<String>> expenNoMap, List<Object> pkList) {
        DynamicObject[] mainDynamicObjectsTemp = BusinessDataServiceHelper.load((Object[])pkList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"rim_invoice"));
        InvoiceSaveService service = new InvoiceSaveService();
        for (DynamicObject obj : mainDynamicObjectsTemp) {
            ExpenseInvoiceDTO dto;
            String serailNo = obj.getString("serial_no");
            String original_state = obj.getString("original_state");
            Integer status2 = statusMap.get(serailNo);
            if (status2 != null) {
                obj.set("expense_status", (Object)status2.toString());
            } else {
                obj.set("expense_status", (Object)OPERATE_TYPE_SAVE);
            }
            Set<String> set = expenNoMap.get(serailNo);
            if (set == null || set.isEmpty()) {
                obj.set("expense_num", (Object)"");
            } else {
                String num = String.join((CharSequence)",", set);
                if (num.length() > 450) {
                    obj.set("expense_num", (Object)num.substring(0, 450));
                } else {
                    obj.set("expense_num", (Object)String.join((CharSequence)",", set));
                }
            }
            if (invoiceDtoMap != null && (dto = invoiceDtoMap.get(serailNo)) != null) {
                if (!OPERATE_TYPE_SAVE.equals(original_state) && OPERATE_TYPE_SAVE.equals(dto.getOriginalState())) {
                    obj.set("original_state", (Object)OPERATE_TYPE_SAVE);
                    obj.set("original_time", (Object)new Date());
                }
                if (dto.getOrgId() != null && dto.getOrgId() > 0L) {
                    obj.set("org", (Object)dto.getOrgId());
                }
            }
            obj.set("vouch_no", (Object)"");
            obj.set("account_time", null);
            obj.set("account_date", null);
            obj.set("expense_time", (Object)new Date());
            obj.set("modifytime", (Object)new Date());
            service.setMainInvoiceInfo(obj);
        }
        SaveServiceHelper.save((DynamicObject[])mainDynamicObjectsTemp);
    }

    private Integer getStausInteger(String status) {
        if (status == null || "".equals(status.trim())) {
            return Integer.valueOf(OPERATE_TYPE_SAVE);
        }
        return Integer.valueOf(status.trim());
    }

    public void updateInvoiceMain(List<String> serialNos, Integer expenseStatus) {
        QFilter tenantFilter = new QFilter("tenant_no", "=", (Object)TenantUtils.getTenantNo());
        QFilter serialFilter = new QFilter("serial_no", "in", serialNos);
        DynamicObjectCollection mainList = QueryServiceHelper.query((String)"rim_invoice", (String)"id,serial_no,expense_status", (QFilter[])new QFilter[]{tenantFilter, serialFilter});
        List pkList = mainList.stream().map(s -> s.get("id")).collect(Collectors.toList());
        DynamicObject[] mainDynamicObjectsTemp = BusinessDataServiceHelper.load((Object[])pkList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"rim_invoice"));
        InvoiceSaveService service = new InvoiceSaveService();
        for (DynamicObject obj : mainDynamicObjectsTemp) {
            obj.set("expense_status", (Object)expenseStatus);
            obj.set("vouch_no", (Object)"");
            obj.set("account_time", null);
            obj.set("account_date", null);
            obj.set("modifytime", (Object)new Date());
            service.setMainInvoiceInfo(obj);
        }
        SaveServiceHelper.save((DynamicObject[])mainDynamicObjectsTemp);
    }

    private void deleteVouchBySerialNos(List<String> serialNos) {
        QFilter tenantFilter = new QFilter("tenant_no", "=", (Object)TenantUtils.getTenantNo());
        QFilter serialFilter = new QFilter("serial_no", "in", serialNos);
        DynamicObjectCollection mainDynamicObjectsTemp = QueryServiceHelper.query((String)"rim_invoice", (String)"id,serial_no,expense_status", (QFilter[])new QFilter[]{tenantFilter, serialFilter});
        List serialNos1 = mainDynamicObjectsTemp.stream().filter(c -> StringUtils.equals((CharSequence)OPERATE_TYPE_SAVE, (CharSequence)c.getString("expense_status"))).map(s -> s.get("serial_no")).collect(Collectors.toList());
        QFilter serialNoFilter = new QFilter("billid", "in", serialNos1);
        QFilter billTypeFilter = new QFilter("bill_type", "=", (Object)OPERATE_TYPE_DELETE);
        DynamicObjectCollection billList = QueryServiceHelper.query((String)"rim_vouch_relation", (String)"id,resource,vouchid", (QFilter[])new QFilter[]{serialNoFilter, billTypeFilter});
        List pkIds = billList.stream().map(obj -> obj.get("id")).collect(Collectors.toList());
        QFilter deleteFlilter = new QFilter("id", "in", pkIds);
        DeleteServiceHelper.delete((String)"rim_vouch_relation", (QFilter[])deleteFlilter.toArray());
        for (DynamicObject relation : billList) {
            this.deleteInvoiceVouchEntry(serialNos, relation.getString("resource"), relation.getString("vouchid"));
        }
    }

    public void saveInvoiceVouchEntry(JSONArray serialList, List<DynamicObject> relationList) {
        JSONObject paramJson = new JSONObject();
        paramJson.put("serialNoArray", (Object)serialList);
        if (relationList.isEmpty()) {
            return;
        }
        DynamicObject vouchRelation = relationList.get(0);
        JSONObject voucherInfo = new JSONObject();
        voucherInfo.put("vouchId", vouchRelation.get("vouchid"));
        voucherInfo.put("vouchNo", vouchRelation.get("vouch_no"));
        voucherInfo.put("resource", (Object)OPERATE_TYPE_SAVE);
        voucherInfo.put("accountDate", (Object)DateUtils.format(vouchRelation.getDate("account_date"), "yyyyMMdd"));
        paramJson.put("voucherInfo", (Object)voucherInfo);
        this.saveInvoiceVouchEntry(paramJson);
    }

    private void saveInvoiceVouchEntry(JSONObject paramJson) {
        DynamicObject[] invoiceArr;
        JSONArray serialNoArray;
        if (!ExpenseService.dealReimEntry()) {
            return;
        }
        Set<Object> paramSerialno = Sets.newHashSet();
        Set<Object> serialNoOfExpenseId = Sets.newHashSet();
        HashSet allSerialNo = Sets.newHashSet();
        JSONArray expenseIdArray = paramJson.getJSONArray("expenseIdArray");
        if (!CollectionUtils.isEmpty((Collection)expenseIdArray)) {
            JSONArray serialNoArrayOfExpense = this.getSerialNosFromExpense(expenseIdArray);
            serialNoOfExpenseId = serialNoArrayOfExpense.stream().map(v -> (String)v).collect(Collectors.toSet());
            allSerialNo.addAll(serialNoOfExpenseId);
        }
        if (!CollectionUtils.isEmpty((Collection)(serialNoArray = paramJson.getJSONArray("serialNoArray")))) {
            paramSerialno = serialNoArray.stream().map(v -> (String)v).collect(Collectors.toSet());
            allSerialNo.addAll(paramSerialno);
        }
        JSONObject voucherInfo = paramJson.getJSONObject("voucherInfo");
        String vouchId = voucherInfo.getString("vouchId");
        String vouchNo = voucherInfo.getString("vouchNo");
        String resource = voucherInfo.getString("resource");
        String accountDateStr = voucherInfo.getString("accountDate");
        Date accountDate = null;
        Date accountTime = null;
        if (StringUtils.isNotEmpty((CharSequence)accountDateStr)) {
            if (accountDateStr.indexOf(45) > 0) {
                accountDateStr = accountDateStr.replace("-", "");
            }
            accountDate = DateUtils.getFirstDateOfMonth(DateUtils.stringToDate(accountDateStr, "yyyyMMdd"));
            accountTime = DateUtils.stringToDate(accountDateStr, "yyyyMMdd");
        }
        QFilter invoiceFilter = new QFilter("serial_no", "in", (Object)allSerialNo);
        ArrayList listClumn = Lists.newArrayList((Object[])new String[]{"id", "serial_no", "reimvouchrelation.reim_resource", "reimvouchrelation.reim_entityid", "reimvouchrelation.reim_expense_id", "reimvouchrelation.reim_expense_num", "reimvouchrelation.reim_create_time", "reimvouchrelation.reim_status", "reimvouchrelation.reim_expense_type", "reimvouchrelation.vouch_vouchid", "reimvouchrelation.vouch_vouch_no", "reimvouchrelation.vouch_resource", "reimvouchrelation.vouch_account_date", "reimvouchrelation.vouch_account_time"});
        String selectClumn = listClumn.stream().collect(Collectors.joining(","));
        for (DynamicObject invoice : invoiceArr = BusinessDataServiceHelper.load((String)"rim_invoice", (String)selectClumn, (QFilter[])new QFilter[]{invoiceFilter})) {
            DynamicObjectCollection relationEntry = invoice.getDynamicObjectCollection("reimvouchrelation");
            String serialNo = invoice.getString("serial_no");
            if (serialNoOfExpenseId.contains(serialNo)) {
                for (DynamicObject relation : relationEntry) {
                    String expenseId = relation.getString("reim_expense_id");
                    if (!expenseIdArray.contains((Object)expenseId)) continue;
                    relation.set("vouch_vouchid", (Object)StringUtils.defaultIfBlank((CharSequence)vouchId, (CharSequence)" "));
                    relation.set("vouch_vouch_no", (Object)StringUtils.defaultIfBlank((CharSequence)vouchNo, (CharSequence)" "));
                    relation.set("vouch_resource", (Object)StringUtils.defaultIfBlank((CharSequence)resource, (CharSequence)" "));
                    relation.set("vouch_account_date", (Object)accountDate);
                    relation.set("vouch_account_time", (Object)accountTime);
                }
                continue;
            }
            DynamicObject newRelation = new DynamicObject(relationEntry.getDynamicObjectType());
            newRelation.set("reim_expense_id", (Object)" ");
            newRelation.set("reim_resource", (Object)" ");
            newRelation.set("reim_entityid", (Object)" ");
            newRelation.set("reim_expense_num", (Object)" ");
            newRelation.set("reim_create_time", (Object)new Date());
            newRelation.set("reim_status", (Object)" ");
            newRelation.set("reim_expense_type", (Object)" ");
            newRelation.set("vouch_vouchid", (Object)StringUtils.defaultIfBlank((CharSequence)vouchId, (CharSequence)" "));
            newRelation.set("vouch_vouch_no", (Object)StringUtils.defaultIfBlank((CharSequence)vouchNo, (CharSequence)" "));
            newRelation.set("vouch_resource", (Object)StringUtils.defaultIfBlank((CharSequence)resource, (CharSequence)" "));
            newRelation.set("vouch_account_date", (Object)accountDate);
            newRelation.set("vouch_account_time", (Object)accountTime);
            relationEntry.add((Object)newRelation);
        }
        SaveServiceHelper.save((DynamicObject[])invoiceArr);
    }

    private void deleteInvoiceVouchEntry(JSONArray serialList, String resource, String vouchId) {
        this.deleteInvoiceVouchEntry(serialList.stream().map(v -> (String)v).collect(Collectors.toList()), resource, vouchId);
    }

    public void deleteInvoiceVouchEntry(List<String> serialList, String resource, String vouchId) {
        if (!ExpenseService.dealReimEntry()) {
            return;
        }
        QFilter invoiceFilter = new QFilter("serial_no", "in", serialList);
        ArrayList listClumn = Lists.newArrayList((Object[])new String[]{"id", "serial_no", "reimvouchrelation.reim_resource", "reimvouchrelation.reim_entityid", "reimvouchrelation.reim_expense_id", "reimvouchrelation.reim_expense_num", "reimvouchrelation.reim_create_time", "reimvouchrelation.reim_status", "reimvouchrelation.reim_expense_type", "reimvouchrelation.vouch_vouchid", "reimvouchrelation.vouch_vouch_no", "reimvouchrelation.vouch_resource", "reimvouchrelation.vouch_account_date", "reimvouchrelation.vouch_account_time"});
        String selectClumn = listClumn.stream().collect(Collectors.joining(","));
        DynamicObject[] invoiceArr = BusinessDataServiceHelper.load((String)"rim_invoice", (String)selectClumn, (QFilter[])new QFilter[]{invoiceFilter});
        invoiceFilter = new QFilter("reimvouchrelation.reim_expense_id", "in", serialList);
        DynamicObject[] invoiceArrBillId = BusinessDataServiceHelper.load((String)"rim_invoice", (String)selectClumn, (QFilter[])new QFilter[]{invoiceFilter});
        ArrayList<DynamicObject> invoiceList = new ArrayList<DynamicObject>(Arrays.asList(invoiceArr));
        invoiceList.addAll(Arrays.asList(invoiceArrBillId));
        for (DynamicObject invoice : invoiceList) {
            DynamicObjectCollection relationEntry = invoice.getDynamicObjectCollection("reimvouchrelation");
            relationEntry.removeIf(v -> StringUtils.isBlank((CharSequence)v.getString("reim_expense_id")) && this.isCurrentVouch((DynamicObject)v, resource, vouchId));
            for (DynamicObject relation : relationEntry) {
                if (!this.isCurrentVouch(relation, resource, vouchId)) continue;
                relation.set("vouch_vouchid", (Object)" ");
                relation.set("vouch_vouch_no", (Object)" ");
                relation.set("vouch_resource", (Object)" ");
                relation.set("vouch_account_date", null);
                relation.set("vouch_account_time", null);
            }
        }
        SaveServiceHelper.save((DynamicObject[])invoiceArr);
    }

    @SdkDeprecated
    public List<JSONObject> getVoucherInfoList(Map<Long, Long> billPkMap) {
        HashMap<Long, ArrayList<Long>> voucherBillIdMap = new HashMap<Long, ArrayList<Long>>(billPkMap.size());
        for (Map.Entry<Long, Long> e : billPkMap.entrySet()) {
            Long voucherPk = e.getValue();
            Long billPk = e.getKey();
            ArrayList<Long> billPks = (ArrayList<Long>)voucherBillIdMap.get(voucherPk);
            if (billPks == null) {
                billPks = new ArrayList<Long>(8);
            }
            billPks.add(billPk);
            voucherBillIdMap.put(voucherPk, billPks);
        }
        ArrayList<JSONObject> voucherInfoList = new ArrayList<JSONObject>(voucherBillIdMap.size());
        QFilter qFilter = new QFilter("id", "in", voucherBillIdMap.keySet());
        DynamicObjectCollection vouchers = QueryServiceHelper.query((String)"gl_voucher", (String)"id, billno, period.number, bizdate, bookeddate", (QFilter[])new QFilter[]{qFilter});
        for (DynamicObject voucher : vouchers) {
            Long vouchId = voucher.getLong("id");
            List billPks = (List)voucherBillIdMap.get(vouchId);
            List<String> serialNoList = InvoiceQueryService.getSerialNoListByIds(billPks);
            String vouchNo = voucher.getString("billno");
            String period = voucher.getString("period.number");
            JSONObject voucherJson = new JSONObject();
            voucherJson.put("serialNoArray", serialNoList);
            voucherJson.put("vouchId", (Object)vouchId);
            voucherJson.put("resource", (Object)"10");
            JSONObject voucherInfo = new JSONObject();
            voucherInfo.put("vouchId", (Object)vouchId);
            voucherInfo.put("vouchNo", (Object)vouchNo);
            voucherInfo.put("period", (Object)period);
            voucherInfo.put("resource", (Object)"10");
            voucherInfo.put("accountDate", (Object)DateUtils.format(voucher.getDate("bookeddate")));
            voucherInfo.put("businessDate", (Object)DateUtils.format(voucher.getDate("bizdate")));
            voucherJson.put("voucherInfo", (Object)voucherInfo);
            voucherInfoList.add(voucherJson);
        }
        return voucherInfoList;
    }

    private boolean isCurrentVouch(DynamicObject relation, String resource, String vouchId) {
        return StringUtils.equals((CharSequence)relation.getString("vouch_vouchid"), (CharSequence)vouchId) && StringUtils.equals((CharSequence)relation.getString("vouch_resource"), (CharSequence)resource);
    }
}

