/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.h5;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.invoice.fpzs.InvoiceClassService;
import kd.imc.rim.common.invoice.query.convert.InvoiceConvertService;
import kd.imc.rim.common.utils.CurrencyUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.MetadataUtil;
import kd.imc.rim.common.utils.TenantUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang.StringUtils;

public class H5InvoiceListService {
    private static Log LOGGER = LogFactory.getLog(H5InvoiceListService.class);
    public static final String ID = "id";
    public static final String SERIAL_NO = "serial_no";
    public static final String TAG_INVOICE_TYPE = "invoice_type_tag";
    public static final String TAG_INVOICE_STATUS = "invoice_status_tag";
    public static final String TAG_EXPENSE_STATUS = "expense_status_tag";
    public static final String TAG_CHECK_STATUS = "check_status_tag";
    public static final String TAG_ORIGINAL_STATUS = "original_status_tag";
    public static final String TAG_AUTHENTICATE_STATUS = "authenticate_status_tag";
    public static final String TAG_MODIFY_STATUS = "modify_status_tag";
    public static final String TAG_ATTACH = "inv_attach_label";
    public static final String TAG_ATTACH_COUNT = "inv_attach_cnt";
    public static final String TAG_TYPE_INVOICE_TYPE = "invoice_type";
    public static final String TAG_TYPE_INVOICE_STATUS = "invoice_status";
    public static final String TAG_TYPE_EXPENSE_STATUS = "expense_status";
    public static final String TAG_TYPE_CHECK_STATUS = "check_status";
    public static final String TAG_TYPE_ORIGINAL_STATUS = "original_status";
    public static final String TAG_TYPE_AUTHENTICATE_FLAG = "authenticate_flag";
    public static final String TAG_TYPE_IS_REVISE = "is_revise";
    public static final String STYLE_TEXT = "text";
    public static final String STYLE_FORE_COLOR = "foreColor";
    public static final String STYLE_BACK_COLOR = "backColor";
    public static final String STYLE_BORDER_COLOR = "borderColor";
    public static final String ENTITY_TOTAL_AMOUNT = "total_amount";
    public static final String ENTITY_PAYER_PARTY_NAME = "payer_party_name";
    public static final String ENTITY_BUYER_NAME = "buyer_name";
    public static final String ENTITY_SALER_NAME = "saler_name";
    public static final String ENTITY_STATION_GET_ON = "station_get_on";
    public static final String ENTITY_STATION_GET_OFF = "station_get_off";
    public static final String ENTITY_PLACE = "place";
    public static final String ENTITY_EXIT = "exit";
    public static final String ENTITY_REMARK = "remark";
    public static final String ENTITY_TAX_AUTHORITY_NAME = "tax_authority_name";
    public static final String ENTITY_INVOICE_DATE = "invoice_date";
    private List<Map<String, Object>> invoiceData;
    private String fieldSuffix = "";
    private String entityName;
    protected AbstractFormPlugin plugin;

    public H5InvoiceListService(AbstractFormPlugin plugin, String entityName, String fieldSuffix) {
        this.plugin = plugin;
        this.entityName = entityName;
        if (fieldSuffix != null) {
            this.fieldSuffix = fieldSuffix;
        }
    }

    public H5InvoiceListService(AbstractFormPlugin plugin) {
        this.plugin = plugin;
    }

    public List<Map<String, Object>> loadList(List<QFilter> filterList, String sortField) {
        List<Map<String, Object>> invoices = this.queryData(filterList, sortField);
        this.fillEntryEntity();
        return invoices;
    }

    /*
     * WARNING - void declaration
     */
    public List<Map<String, Object>> queryData(List<QFilter> filterList, String orderBys) {
        String selectFields = MetadataUtil.getFields((String)"rim_invoice");
        DynamicObjectCollection mainCollection = QueryServiceHelper.query((String)"rim_invoice", (String)selectFields, (QFilter[])filterList.toArray(new QFilter[0]), (String)orderBys, (int)500);
        HashMap<Object, void> typeSerialMap = new HashMap<Object, void>(8);
        ArrayList<String> allSerialList = new ArrayList<String>(mainCollection.size());
        for (DynamicObject obj : mainCollection) {
            void var11_11;
            Long invoiceType = obj.getLong(TAG_TYPE_INVOICE_TYPE);
            String entity = InputInvoiceTypeEnum.getEntity(invoiceType);
            List list = (List)typeSerialMap.get(entity);
            if (list == null) {
                ArrayList arrayList = new ArrayList(8);
            }
            var11_11.add(obj.getString(SERIAL_NO));
            allSerialList.add(obj.getString(SERIAL_NO));
            typeSerialMap.put(entity, var11_11);
        }
        String tenantNo = TenantUtils.getTenantNo();
        QFilter tenantFilter = new QFilter("tenant_no", "=", (Object)tenantNo);
        HashMap<String, DynamicObject> bodyMap = new HashMap<String, DynamicObject>(16);
        for (Map.Entry entry : typeSerialMap.entrySet()) {
            String key = (String)entry.getKey();
            if (StringUtils.isEmpty((String)key)) continue;
            String bodyFields = MetadataUtil.getFields((String)key);
            QFilter serialFilter = new QFilter(SERIAL_NO, "in", entry.getValue());
            DynamicObjectCollection bodyCollection = QueryServiceHelper.query((String)((String)entry.getKey()), (String)bodyFields, (QFilter[])new QFilter[]{serialFilter, tenantFilter});
            if (bodyCollection == null) continue;
            for (DynamicObject obj : bodyCollection) {
                bodyMap.put(obj.getString(SERIAL_NO), obj);
            }
        }
        Map<String, List<String>> invoiceAttach = this.queryAttach(allSerialList);
        this.invoiceData = new ArrayList<Map<String, Object>>(mainCollection.size());
        for (DynamicObject mainObj : mainCollection) {
            Map<String, Object> mainMap = DynamicObjectUtil.dynamicObjectToMap(mainObj);
            String serial_no = mainObj.getString(SERIAL_NO);
            Object mainId = mainMap.get(ID);
            Map<String, Object> body = DynamicObjectUtil.dynamicObjectToMap((DynamicObject)bodyMap.get(serial_no));
            InvoiceConvertService.putAll(mainMap, body);
            mainMap.put(ID, mainId);
            List<String> attachList = invoiceAttach.get(serial_no);
            if (attachList == null || attachList.isEmpty()) {
                mainMap.put("attach_count", 0);
            } else {
                String attachIds = StringUtils.join(attachList, (String)",");
                mainMap.put("attach_ids", attachIds);
                mainMap.put("attach_count", attachList.size());
            }
            this.invoiceData.add(mainMap);
        }
        InvoiceClassService.getInstance().initInvoiceClass(this.invoiceData);
        return this.invoiceData;
    }

    private Map<String, List<String>> queryAttach(List<String> allSerialList) {
        HashMap<String, List<String>> invoiceAttach = new HashMap<String, List<String>>(allSerialList.size());
        if (!allSerialList.isEmpty()) {
            QFilter qFilters = new QFilter("relation_id", "in", allSerialList);
            qFilters.and(new QFilter("relation_type", "=", (Object)"3"));
            DynamicObjectCollection attach = QueryServiceHelper.query((String)"rim_attach_relation", (String)"relation_id,attach_id", (QFilter[])new QFilter[]{qFilters});
            attach.stream().forEach(c -> {
                String attId = c.getString("attach_id");
                String serial = c.getString("relation_id");
                ArrayList<String> list = (ArrayList<String>)invoiceAttach.get(serial);
                if (list == null) {
                    list = new ArrayList<String>(8);
                }
                list.add(attId);
                invoiceAttach.put(serial, list);
            });
        }
        return invoiceAttach;
    }

    public void orderListByFields(List<String> orderedFieldList, String orderFieldName) {
        if (CollectionUtils.isEmpty(this.invoiceData) || CollectionUtils.isEmpty(orderedFieldList)) {
            return;
        }
        HashMap map = new HashMap(this.invoiceData.size());
        this.invoiceData.forEach(invocie -> map.put(invocie.get(orderFieldName).toString(), invocie));
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(orderedFieldList.size());
        for (String field : orderedFieldList) {
            Map invoice = (Map)map.get(field);
            if (invoice == null) continue;
            list.add(invoice);
        }
        this.invoiceData = list;
    }

    public void fillEntryEntity() {
        Map<String, String> map = this.getFieldMap();
        this.clearListData(this.entityName);
        this.plugin.getView().getModel().beginInit();
        for (Map<String, Object> invoice : this.invoiceData) {
            Long invoiceType = MapUtils.getLong(invoice, (Object)TAG_TYPE_INVOICE_TYPE);
            if (InputInvoiceTypeEnum.AIR_INVOICE.getCode().equals(invoiceType)) {
                invoice.put(ENTITY_STATION_GET_ON, invoice.get("place_of_departure"));
                invoice.put(ENTITY_STATION_GET_OFF, invoice.get("destination"));
            }
            int row = this.plugin.getView().getModel().createNewEntryRow(this.entityName);
            for (Map.Entry<String, String> modelEntry : map.entrySet()) {
                try {
                    if ("currencyid".equals(modelEntry.getValue())) {
                        if (InputInvoiceTypeEnum.containCurrencyId(invoiceType)) {
                            Long currencyid = MapUtils.getLong(invoice, (Object)modelEntry.getValue());
                            this.plugin.getView().getModel().setValue(modelEntry.getKey(), (Object)currencyid, row);
                            continue;
                        }
                        this.plugin.getView().getModel().setValue(modelEntry.getKey(), (Object)CurrencyUtils.FpzsMainService_100_id, row);
                        continue;
                    }
                    this.plugin.getView().getModel().setValue(modelEntry.getKey(), invoice.get(modelEntry.getValue()), row);
                }
                catch (Exception e) {
                    LOGGER.info("\u53d1\u7968\u6570\u636e\u586b\u5145\u62a5\u9519:{}", (Object)e);
                }
            }
            JSONObject invoiceInfo = new JSONObject();
            invoiceInfo.put(TAG_TYPE_INVOICE_TYPE, (Object)invoiceType);
            invoiceInfo.put(TAG_TYPE_INVOICE_STATUS, invoice.get(TAG_TYPE_INVOICE_STATUS));
            invoiceInfo.put(TAG_TYPE_AUTHENTICATE_FLAG, invoice.get(TAG_TYPE_AUTHENTICATE_FLAG));
            invoiceInfo.put(TAG_TYPE_CHECK_STATUS, invoice.get(TAG_TYPE_CHECK_STATUS));
            invoiceInfo.put(TAG_TYPE_EXPENSE_STATUS, invoice.get(TAG_TYPE_EXPENSE_STATUS));
            invoiceInfo.put(TAG_TYPE_ORIGINAL_STATUS, invoice.get(TAG_TYPE_ORIGINAL_STATUS));
            invoiceInfo.put(TAG_TYPE_IS_REVISE, invoice.get(TAG_TYPE_IS_REVISE));
            invoiceInfo.put(TAG_ATTACH_COUNT, invoice.get("attach_count"));
            String invoiceStr = JSONObject.toJSONString(invoice);
            this.plugin.getView().getModel().setValue("invoice_info" + this.fieldSuffix, (Object)invoiceStr, row);
            CardEntry cardEntry = (CardEntry)this.plugin.getView().getControl(this.entityName);
            if (row >= cardEntry.getPageRow()) continue;
            this.setTag(invoice, row);
        }
        this.plugin.getView().getModel().endInit();
        this.plugin.getView().updateView(this.entityName);
    }

    public void setTag(Map<String, Object> invoice, int row) {
        Map<String, String> map = this.getFieldMap();
        this.setCardEntryChildVisible(false, row, TAG_INVOICE_TYPE + this.fieldSuffix, TAG_INVOICE_STATUS + this.fieldSuffix, TAG_EXPENSE_STATUS + this.fieldSuffix, TAG_ORIGINAL_STATUS + this.fieldSuffix, TAG_AUTHENTICATE_STATUS + this.fieldSuffix, TAG_CHECK_STATUS + this.fieldSuffix, TAG_MODIFY_STATUS + this.fieldSuffix, TAG_ATTACH + this.fieldSuffix);
        this.setCellVisible(row, MapUtils.getLong(map, (Object)TAG_TYPE_INVOICE_TYPE));
        this.createTag(invoice, row, TAG_INVOICE_TYPE, TAG_TYPE_INVOICE_TYPE);
        this.createTag(invoice, row, TAG_INVOICE_STATUS, TAG_TYPE_INVOICE_STATUS);
        this.createTag(invoice, row, TAG_EXPENSE_STATUS, TAG_TYPE_EXPENSE_STATUS);
        this.createTag(invoice, row, TAG_ORIGINAL_STATUS, TAG_TYPE_ORIGINAL_STATUS);
        this.createTag(invoice, row, TAG_AUTHENTICATE_STATUS, TAG_TYPE_AUTHENTICATE_FLAG);
        this.createTag(invoice, row, TAG_CHECK_STATUS, TAG_TYPE_CHECK_STATUS);
        this.createTag(invoice, row, TAG_MODIFY_STATUS, TAG_TYPE_IS_REVISE);
        int attachCount = MapUtils.getIntValue(invoice, (Object)"attach_count");
        if (attachCount > 0) {
            this.setCardEntryChildVisible(true, row, TAG_ATTACH + this.fieldSuffix);
            this.setCardEntryChildVisible(true, row, TAG_ATTACH_COUNT + this.fieldSuffix);
        }
    }

    public void createTag(Map<String, Object> invoice, int row, String tagKey, String tagType) {
        Map<String, String> style = this.createTagStyle(invoice, tagType);
        if (style != null) {
            this.setTagStyle(tagKey + this.fieldSuffix, row, style.get(STYLE_TEXT), style.get(STYLE_BACK_COLOR), style.get(STYLE_FORE_COLOR), style.get(STYLE_BORDER_COLOR));
        }
    }

    public Map<String, String> getFieldMap() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(12);
        map.put(ENTITY_TOTAL_AMOUNT + this.fieldSuffix, ENTITY_TOTAL_AMOUNT);
        map.put(ENTITY_PAYER_PARTY_NAME + this.fieldSuffix, ENTITY_PAYER_PARTY_NAME);
        map.put(ENTITY_BUYER_NAME + this.fieldSuffix, ENTITY_BUYER_NAME);
        map.put(ENTITY_SALER_NAME + this.fieldSuffix, ENTITY_SALER_NAME);
        map.put(ENTITY_STATION_GET_ON + this.fieldSuffix, ENTITY_STATION_GET_ON);
        map.put(ENTITY_PLACE + this.fieldSuffix, ENTITY_PLACE);
        map.put(ENTITY_EXIT + this.fieldSuffix, ENTITY_EXIT);
        map.put(ENTITY_REMARK + this.fieldSuffix, ENTITY_REMARK);
        map.put(ENTITY_TAX_AUTHORITY_NAME + this.fieldSuffix, ENTITY_TAX_AUTHORITY_NAME);
        map.put(ENTITY_INVOICE_DATE + this.fieldSuffix, ENTITY_INVOICE_DATE);
        map.put(TAG_ATTACH_COUNT + this.fieldSuffix, "attach_count");
        map.put("attach_ids" + this.fieldSuffix, "attach_ids");
        map.put(ID + this.fieldSuffix, ID);
        map.put(SERIAL_NO + this.fieldSuffix, SERIAL_NO);
        map.put("invoice_class" + this.fieldSuffix, "invoiceClassName");
        map.put("invoice_class_show" + this.fieldSuffix, "invoiceClassName_show");
        map.put("currencyid" + this.fieldSuffix, "currencyid");
        map.put("amount" + this.fieldSuffix, ENTITY_TOTAL_AMOUNT);
        return map;
    }

    public Map<String, String> createTagStyle(Map<String, Object> invoice, String tagType) {
        if (TAG_TYPE_INVOICE_TYPE.equals(tagType)) {
            return this.createInvoiceTypeTag((Long)invoice.get(TAG_TYPE_INVOICE_TYPE));
        }
        if (TAG_TYPE_EXPENSE_STATUS.equals(tagType)) {
            return this.createExpenseStatusTag((String)invoice.get(TAG_TYPE_EXPENSE_STATUS));
        }
        if (TAG_TYPE_CHECK_STATUS.equals(tagType) && InputInvoiceTypeEnum.needCheck((Long)invoice.get(TAG_TYPE_INVOICE_TYPE)).booleanValue()) {
            return this.createCheckStatusTag((String)invoice.get(TAG_TYPE_CHECK_STATUS));
        }
        if (TAG_TYPE_INVOICE_STATUS.equals(tagType)) {
            return this.createInvoiceStatusTag((String)invoice.get(TAG_TYPE_INVOICE_STATUS));
        }
        if (TAG_TYPE_ORIGINAL_STATUS.equals(tagType)) {
            return this.createOriginalStatusTag((String)invoice.get(TAG_TYPE_ORIGINAL_STATUS));
        }
        if (TAG_TYPE_AUTHENTICATE_FLAG.equals(tagType)) {
            return this.createAuthenticateStatusTag((String)invoice.get(TAG_TYPE_AUTHENTICATE_FLAG));
        }
        if (TAG_MODIFY_STATUS.equals(tagType)) {
            return this.createModifyStatusTag((String)invoice.get(TAG_TYPE_IS_REVISE));
        }
        return null;
    }

    private Map<String, String> createInvoiceTypeTag(Long invoiceType) {
        if (invoiceType.equals(InputInvoiceTypeEnum.ORDINARY_ELECTRON.getCode()) || invoiceType.equals(InputInvoiceTypeEnum.SPECIAL_ELECTRON.getCode())) {
            return this.createTagStyle(ResManager.loadKDString((String)"\u7535\u7968", (String)"H5InvoiceListService_0", (String)"imc-rim-common", (Object[])new Object[0]), "#276ff5", "#FFFFFF", "#276ff5");
        }
        if (invoiceType.equals(InputInvoiceTypeEnum.ORDINARY_PAPER.getCode())) {
            return this.createTagStyle(ResManager.loadKDString((String)"\u7eb8\u7968", (String)"H5InvoiceListService_1", (String)"imc-rim-common", (Object[])new Object[0]), "#276ff5", "#FFFFFF", "#276ff5");
        }
        if (invoiceType.equals(InputInvoiceTypeEnum.SPECIAL_PAPER.getCode())) {
            return this.createTagStyle(ResManager.loadKDString((String)"\u4e13\u7968", (String)"H5InvoiceListService_2", (String)"imc-rim-common", (Object[])new Object[0]), "#276ff5", "#FFFFFF", "#276ff5");
        }
        if (invoiceType.equals(InputInvoiceTypeEnum.ORDINARY_ROLL.getCode())) {
            return this.createTagStyle(ResManager.loadKDString((String)"\u5377\u7968", (String)"H5InvoiceListService_3", (String)"imc-rim-common", (Object[])new Object[0]), "#276ff5", "#FFFFFF", "#276ff5");
        }
        if (invoiceType.equals(InputInvoiceTypeEnum.GENERAL_PAPER.getCode())) {
            return this.createTagStyle(ResManager.loadKDString((String)"\u673a\u6253", (String)"H5InvoiceListService_4", (String)"imc-rim-common", (Object[])new Object[0]), "#5797ff", "#FFFFFF", "#5797ff");
        }
        if (invoiceType.equals(InputInvoiceTypeEnum.TAXI_INVOICE.getCode())) {
            return this.createTagStyle(ResManager.loadKDString((String)"\u7684\u58eb", (String)"H5InvoiceListService_5", (String)"imc-rim-common", (Object[])new Object[0]), "#16b8b1", "#FFFFFF", "#16b8b1");
        }
        if (invoiceType.equals(InputInvoiceTypeEnum.TRAIN_INVOICE.getCode()) || invoiceType.equals(InputInvoiceTypeEnum.TRAIN_REFUND.getCode())) {
            return this.createTagStyle(ResManager.loadKDString((String)"\u706b\u8f66", (String)"H5InvoiceListService_6", (String)"imc-rim-common", (Object[])new Object[0]), "#16b8b1", "#FFFFFF", "#16b8b1");
        }
        if (invoiceType.equals(InputInvoiceTypeEnum.AIR_INVOICE.getCode())) {
            return this.createTagStyle(ResManager.loadKDString((String)"\u98de\u673a", (String)"H5InvoiceListService_7", (String)"imc-rim-common", (Object[])new Object[0]), "#16b8b1", "#FFFFFF", "#16b8b1");
        }
        if (invoiceType.equals(InputInvoiceTypeEnum.OTHER_INVOICE.getCode())) {
            return this.createTagStyle(ResManager.loadKDString((String)"\u5176\u4ed6", (String)"H5InvoiceListService_8", (String)"imc-rim-common", (Object[])new Object[0]), "#ff5257", "#FFFFFF", "#ff5257");
        }
        if (invoiceType.equals(InputInvoiceTypeEnum.MOTOR_INVOICE.getCode())) {
            return this.createTagStyle(ResManager.loadKDString((String)"\u673a\u52a8", (String)"H5InvoiceListService_9", (String)"imc-rim-common", (Object[])new Object[0]), "#276ff5", "#FFFFFF", "#276ff5");
        }
        if (invoiceType.equals(InputInvoiceTypeEnum.USEDCAR_INVOICE.getCode())) {
            return this.createTagStyle(ResManager.loadKDString((String)"\u4e8c\u624b", (String)"H5InvoiceListService_10", (String)"imc-rim-common", (Object[])new Object[0]), "#5797ff", "#FFFFFF", "#5797ff");
        }
        if (invoiceType.equals(InputInvoiceTypeEnum.QUOTA_INVOICE.getCode())) {
            return this.createTagStyle(ResManager.loadKDString((String)"\u5b9a\u989d", (String)"H5InvoiceListService_11", (String)"imc-rim-common", (Object[])new Object[0]), "#FF991C", "#FFFFFF", "#FF991C");
        }
        if (invoiceType.equals(InputInvoiceTypeEnum.TOLL_ELECTRON.getCode())) {
            return this.createTagStyle(ResManager.loadKDString((String)"\u901a\u884c", (String)"H5InvoiceListService_12", (String)"imc-rim-common", (Object[])new Object[0]), "#276ff5", "#FFFFFF", "#276ff5");
        }
        if (invoiceType.equals(InputInvoiceTypeEnum.TRANSPORT_INVOICE.getCode())) {
            return this.createTagStyle(ResManager.loadKDString((String)"\u5ba2\u8fd0", (String)"H5InvoiceListService_13", (String)"imc-rim-common", (Object[])new Object[0]), "#16b8b1", "#FFFFFF", "#16b8b1");
        }
        if (invoiceType.equals(InputInvoiceTypeEnum.ROAD_BRIDGE.getCode())) {
            return this.createTagStyle(ResManager.loadKDString((String)"\u8fc7\u8def", (String)"H5InvoiceListService_14", (String)"imc-rim-common", (Object[])new Object[0]), "#16b8b1", "#FFFFFF", "#16b8b1");
        }
        if (invoiceType.equals(InputInvoiceTypeEnum.BOAT_INVOICE.getCode())) {
            return this.createTagStyle(ResManager.loadKDString((String)"\u8f6e\u8239", (String)"H5InvoiceListService_15", (String)"imc-rim-common", (Object[])new Object[0]), "#16b8b1", "#FFFFFF", "#16b8b1");
        }
        if (invoiceType.equals(InputInvoiceTypeEnum.HGJKS.getCode())) {
            return this.createTagStyle(ResManager.loadKDString((String)"\u6d77\u5173", (String)"H5InvoiceListService_16", (String)"imc-rim-common", (Object[])new Object[0]), "#5797ff", "#FFFFFF", "#5797ff");
        }
        if (invoiceType.equals(InputInvoiceTypeEnum.GENERAL_ELECTRON.getCode())) {
            return this.createTagStyle(ResManager.loadKDString((String)"\u673a\u6253", (String)"H5InvoiceListService_4", (String)"imc-rim-common", (Object[])new Object[0]), "#16b8b1", "#FFFFFF", "#16b8b1");
        }
        if (invoiceType.equals(InputInvoiceTypeEnum.FINANCIAL_INVOICE.getCode())) {
            return this.createTagStyle(ResManager.loadKDString((String)"\u8d22\u653f", (String)"H5InvoiceListService_17", (String)"imc-rim-common", (Object[])new Object[0]), "#5797ff", "#FFFFFF", "#5797ff");
        }
        if (invoiceType.equals(InputInvoiceTypeEnum.TAX_PROOF.getCode())) {
            return this.createTagStyle(ResManager.loadKDString((String)"\u5b8c\u7a0e", (String)"H5InvoiceListService_18", (String)"imc-rim-common", (Object[])new Object[0]), "#FF991C", "#FFFFFF", "#FF991C");
        }
        if (invoiceType.equals(InputInvoiceTypeEnum.ELECTRIC_SPECIAL.getCode()) || invoiceType.equals(InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getCode())) {
            return this.createTagStyle(ResManager.loadKDString((String)"\u6570\u7535\u7968", (String)"H5InvoiceListService_19", (String)"imc-rim-common", (Object[])new Object[0]), "#276ff5", "#FFFFFF", "#276ff5");
        }
        if (invoiceType.equals(InputInvoiceTypeEnum.OVERSEA_INVOICE.getCode())) {
            return this.createTagStyle(ResManager.loadKDString((String)"\u6d77\u5916", (String)"H5InvoiceListService_35", (String)"imc-rim-common", (Object[])new Object[0]), "#FF991C", "#FFFFFF", "#FF991C");
        }
        if (invoiceType.equals(InputInvoiceTypeEnum.AIR_ELE_INVOICE.getCode())) {
            return this.createTagStyle(ResManager.loadKDString((String)"\u6570\u7535\u822a\u7a7a", (String)"H5InvoiceListService_36", (String)"imc-rim-common", (Object[])new Object[0]), "#276ff5", "#FFFFFF", "#276ff5");
        }
        if (invoiceType.equals(InputInvoiceTypeEnum.TRAIN_ELE_INVOICE.getCode())) {
            return this.createTagStyle(ResManager.loadKDString((String)"\u6570\u7535\u94c1\u8def", (String)"H5InvoiceListService_37", (String)"imc-rim-common", (Object[])new Object[0]), "#276ff5", "#FFFFFF", "#276ff5");
        }
        if (invoiceType.equals(InputInvoiceTypeEnum.MOTOR_ELE_INVOICE.getCode())) {
            return this.createTagStyle(ResManager.loadKDString((String)"\u6570\u7535\u673a\u52a8\u8f66", (String)"InvoiceInfoLabelService_45", (String)"imc-rim-common", (Object[])new Object[0]), "#276ff5", "#FFFFFF", "#276ff5");
        }
        if (invoiceType.equals(InputInvoiceTypeEnum.USEDCAR_ELE_INVOICE.getCode())) {
            return this.createTagStyle(ResManager.loadKDString((String)"\u6570\u7535\u4e8c\u624b\u8f66", (String)"InvoiceInfoLabelService_46", (String)"imc-rim-common", (Object[])new Object[0]), "#276ff5", "#FFFFFF", "#276ff5");
        }
        return null;
    }

    private Map<String, String> createExpenseStatusTag(String expenseStatus) {
        if ("1".equals(expenseStatus)) {
            return this.createTagStyle(ResManager.loadKDString((String)"\u672a\u7528", (String)"H5InvoiceListService_20", (String)"imc-rim-common", (Object[])new Object[0]), "#666666", "#FFFFFF", "#666666");
        }
        if ("30".equals(expenseStatus)) {
            return this.createTagStyle(ResManager.loadKDString((String)"\u5728\u7528", (String)"H5InvoiceListService_21", (String)"imc-rim-common", (Object[])new Object[0]), "#3987ed", "#FFFFFF", "#3987ed");
        }
        if ("60".equals(expenseStatus)) {
            return this.createTagStyle(ResManager.loadKDString((String)"\u5df2\u7528", (String)"H5InvoiceListService_22", (String)"imc-rim-common", (Object[])new Object[0]), "#16b8b1", "#FFFFFF", "#16b8b1");
        }
        if ("65".equals(expenseStatus)) {
            return this.createTagStyle(ResManager.loadKDString((String)"\u5df2\u5165\u8d26", (String)"H5InvoiceListService_23", (String)"imc-rim-common", (Object[])new Object[0]), "#16b8b1", "#FFFFFF", "#16b8b1");
        }
        return null;
    }

    private Map<String, String> createCheckStatusTag(String checkStatus) {
        if ("1".equals(checkStatus)) {
            return this.createTagStyle(ResManager.loadKDString((String)"\u5df2\u9a8c", (String)"H5InvoiceListService_24", (String)"imc-rim-common", (Object[])new Object[0]), "#3987ed", "#FFFFFF", "#3987ed");
        }
        if (!StringUtils.isEmpty((String)checkStatus)) {
            return this.createTagStyle(ResManager.loadKDString((String)"\u672a\u9a8c", (String)"H5InvoiceListService_25", (String)"imc-rim-common", (Object[])new Object[0]), "#666666", "#FFFFFF", "#666666");
        }
        return null;
    }

    private Map<String, String> createInvoiceStatusTag(String invoiceStatus) {
        if ("2".equals(invoiceStatus)) {
            return this.createTagStyle(ResManager.loadKDString((String)"\u4f5c\u5e9f", (String)"H5InvoiceListService_26", (String)"imc-rim-common", (Object[])new Object[0]), "#666666", "#FFFFFF", "#666666");
        }
        if ("3".equals(invoiceStatus) || "7".equals(invoiceStatus) || "8".equals(invoiceStatus)) {
            return this.createTagStyle(ResManager.loadKDString((String)"\u7ea2\u51b2", (String)"H5InvoiceListService_27", (String)"imc-rim-common", (Object[])new Object[0]), "#fb2323", "#FFFFFF", "#fb2323");
        }
        return null;
    }

    private Map<String, String> createOriginalStatusTag(String originalStatus) {
        if ("1".equals(originalStatus)) {
            return this.createTagStyle(ResManager.loadKDString((String)"\u5df2\u7b7e\u6536", (String)"H5InvoiceListService_28", (String)"imc-rim-common", (Object[])new Object[0]), "#40bd6e", "#FFFFFF", "#40bd6e");
        }
        return this.createTagStyle(ResManager.loadKDString((String)"\u672a\u7b7e\u6536", (String)"H5InvoiceListService_29", (String)"imc-rim-common", (Object[])new Object[0]), "#FF991C", "#FFFFFF", "#FF991C");
    }

    private Map<String, String> createModifyStatusTag(String modifyStatus) {
        if ("1".equals(modifyStatus)) {
            return this.createTagStyle(ResManager.loadKDString((String)"\u5df2\u6539", (String)"H5InvoiceListService_30", (String)"imc-rim-common", (Object[])new Object[0]), "#40bd6e", "#FFFFFF", "#40bd6e");
        }
        return null;
    }

    private Map<String, String> createAuthenticateStatusTag(String authenticateStatus) {
        if ("0".equals(authenticateStatus)) {
            return this.createTagStyle(ResManager.loadKDString((String)"\u672a\u52fe\u9009", (String)"H5InvoiceListService_31", (String)"imc-rim-common", (Object[])new Object[0]), "#666666", "#FFFFFF", "#666666");
        }
        if ("1".equals(authenticateStatus)) {
            return this.createTagStyle(ResManager.loadKDString((String)"\u5df2\u52fe\u9009", (String)"H5InvoiceListService_32", (String)"imc-rim-common", (Object[])new Object[0]), "#40bd6e", "#FFFFFF", "#40bd6e");
        }
        if ("2".equals(authenticateStatus) || "3".equals(authenticateStatus)) {
            return this.createTagStyle(ResManager.loadKDString((String)"\u5df2\u62b5\u6263", (String)"H5InvoiceListService_33", (String)"imc-rim-common", (Object[])new Object[0]), "#40bd6e", "#FFFFFF", "#40bd6e");
        }
        if ("4".equals(authenticateStatus)) {
            return this.createTagStyle(ResManager.loadKDString((String)"\u9884\u52fe\u9009", (String)"H5InvoiceListService_34", (String)"imc-rim-common", (Object[])new Object[0]), "#40bd6e", "#FFFFFF", "#40bd6e");
        }
        return null;
    }

    private Map<String, String> createTagStyle(String text, String backColor, String foreColor, String borderColor) {
        HashMap<String, String> map = new HashMap<String, String>(4);
        map.put(STYLE_TEXT, text);
        map.put(STYLE_BACK_COLOR, backColor);
        map.put(STYLE_FORE_COLOR, foreColor);
        map.put(STYLE_BORDER_COLOR, borderColor);
        return map;
    }

    public List<Map<String, Object>> getInvoiceData() {
        return this.invoiceData;
    }

    public void setInvoiceData(List<Map<String, Object>> invoiceData) {
        this.invoiceData = invoiceData;
    }

    public void setCellVisible(int row, Long invoiceType) {
        if (InputInvoiceTypeEnum.TRAIN_INVOICE.getCode().equals(invoiceType) || InputInvoiceTypeEnum.TRANSPORT_INVOICE.getCode().equals(invoiceType) || InputInvoiceTypeEnum.BOAT_INVOICE.getCode().equals(invoiceType) || InputInvoiceTypeEnum.AIR_INVOICE.getCode().equals(invoiceType)) {
            this.setCardEntryChildVisible(false, row, ENTITY_BUYER_NAME + this.fieldSuffix, ENTITY_SALER_NAME + this.fieldSuffix, ENTITY_PLACE + this.fieldSuffix, ENTITY_EXIT + this.fieldSuffix, ENTITY_REMARK + this.fieldSuffix, ENTITY_TAX_AUTHORITY_NAME + this.fieldSuffix, ENTITY_PAYER_PARTY_NAME + this.fieldSuffix);
        } else if (InputInvoiceTypeEnum.TRAIN_REFUND.getCode().equals(invoiceType)) {
            this.setCardEntryChildVisible(false, row, ENTITY_BUYER_NAME + this.fieldSuffix, ENTITY_SALER_NAME + this.fieldSuffix, ENTITY_STATION_GET_ON + this.fieldSuffix, ENTITY_STATION_GET_OFF + this.fieldSuffix, ENTITY_PLACE + this.fieldSuffix, ENTITY_EXIT + this.fieldSuffix, ENTITY_REMARK + this.fieldSuffix, ENTITY_TAX_AUTHORITY_NAME + this.fieldSuffix, ENTITY_PAYER_PARTY_NAME + this.fieldSuffix);
        } else if (Arrays.asList(InputInvoiceTypeEnum.TAXI_INVOICE.getCode(), InputInvoiceTypeEnum.QUOTA_INVOICE.getCode()).contains(invoiceType)) {
            this.setCardEntryChildVisible(false, row, ENTITY_BUYER_NAME + this.fieldSuffix, ENTITY_SALER_NAME + this.fieldSuffix, ENTITY_STATION_GET_ON + this.fieldSuffix, ENTITY_STATION_GET_OFF + this.fieldSuffix, ENTITY_EXIT + this.fieldSuffix, ENTITY_REMARK + this.fieldSuffix, ENTITY_TAX_AUTHORITY_NAME + this.fieldSuffix, ENTITY_PAYER_PARTY_NAME + this.fieldSuffix);
        } else if (InputInvoiceTypeEnum.ROAD_BRIDGE.getCode().equals(invoiceType)) {
            this.setCardEntryChildVisible(false, row, ENTITY_BUYER_NAME + this.fieldSuffix, ENTITY_SALER_NAME + this.fieldSuffix, ENTITY_STATION_GET_ON + this.fieldSuffix, ENTITY_STATION_GET_OFF + this.fieldSuffix, ENTITY_PLACE + this.fieldSuffix, ENTITY_REMARK + this.fieldSuffix, ENTITY_TAX_AUTHORITY_NAME + this.fieldSuffix, ENTITY_PAYER_PARTY_NAME + this.fieldSuffix);
        } else if (InputInvoiceTypeEnum.OTHER_INVOICE.getCode().equals(invoiceType)) {
            this.setCardEntryChildVisible(false, row, ENTITY_BUYER_NAME + this.fieldSuffix, ENTITY_SALER_NAME + this.fieldSuffix, ENTITY_STATION_GET_ON + this.fieldSuffix, ENTITY_STATION_GET_OFF + this.fieldSuffix, ENTITY_PLACE + this.fieldSuffix, ENTITY_EXIT + this.fieldSuffix, ENTITY_TAX_AUTHORITY_NAME + this.fieldSuffix, ENTITY_PAYER_PARTY_NAME + this.fieldSuffix);
        } else if (InputInvoiceTypeEnum.TAX_PROOF.getCode().equals(invoiceType)) {
            this.setCardEntryChildVisible(false, row, ENTITY_BUYER_NAME + this.fieldSuffix, ENTITY_SALER_NAME + this.fieldSuffix, ENTITY_STATION_GET_ON + this.fieldSuffix, ENTITY_STATION_GET_OFF + this.fieldSuffix, ENTITY_PLACE + this.fieldSuffix, ENTITY_EXIT + this.fieldSuffix, ENTITY_REMARK + this.fieldSuffix, ENTITY_PAYER_PARTY_NAME + this.fieldSuffix);
        } else if (InputInvoiceTypeEnum.FINANCIAL_INVOICE.getCode().equals(invoiceType)) {
            this.setCardEntryChildVisible(false, row, ENTITY_BUYER_NAME + this.fieldSuffix, ENTITY_SALER_NAME + this.fieldSuffix, ENTITY_STATION_GET_ON + this.fieldSuffix, ENTITY_STATION_GET_OFF + this.fieldSuffix, ENTITY_PLACE + this.fieldSuffix, ENTITY_EXIT + this.fieldSuffix, ENTITY_REMARK + this.fieldSuffix, ENTITY_TAX_AUTHORITY_NAME + this.fieldSuffix);
        } else {
            this.setCardEntryChildVisible(false, row, ENTITY_STATION_GET_ON + this.fieldSuffix, ENTITY_STATION_GET_OFF + this.fieldSuffix, ENTITY_PLACE + this.fieldSuffix, ENTITY_EXIT + this.fieldSuffix, ENTITY_REMARK + this.fieldSuffix, ENTITY_TAX_AUTHORITY_NAME + this.fieldSuffix, ENTITY_PAYER_PARTY_NAME + this.fieldSuffix);
        }
    }

    private void setTagStyle(String key, int rowIndex, String text, String backColor, String foreColor, String borderColor) {
        CardEntry cardEntry = (CardEntry)this.plugin.getView().getControl(this.entityName);
        cardEntry.setChildVisible(true, rowIndex, new String[]{key});
        HashMap activeItem = new HashMap(1);
        HashMap<String, Object> propertiesMap = new HashMap<String, Object>(4);
        propertiesMap.put("followTheme", Boolean.TRUE);
        propertiesMap.put(STYLE_TEXT, text);
        propertiesMap.put("bc", backColor);
        propertiesMap.put("fc", foreColor);
        HashMap style = new HashMap(1);
        propertiesMap.put("s", style);
        activeItem.put(key, propertiesMap);
        ((IClientViewProxy)this.plugin.getView().getService(IClientViewProxy.class)).invokeControlMethod(this.entityName, "setCustomProperties", new Object[]{rowIndex, activeItem});
    }

    public void setTagStyle(String key, String text, String backColor, String foreColor, String borderColor) {
        this.plugin.getView().setVisible(Boolean.TRUE, new String[]{key});
        Label invToastLabelap = (Label)this.plugin.getControl(key);
        invToastLabelap.setText(text);
    }

    public void setCardEntryChildVisible(boolean value, int rowIndex, String ... fileds) {
        CardEntry cardEntry = (CardEntry)this.plugin.getView().getControl(this.entityName);
        Arrays.stream(fileds).forEach(c -> cardEntry.setChildVisible(value, rowIndex, new String[]{c}));
    }

    public List<Map<String, Object>> arrayToListMap(JSONArray invoiceArray, Boolean needConvert) {
        if (CollectionUtils.isEmpty((Collection)invoiceArray)) {
            return new ArrayList<Map<String, Object>>(1);
        }
        ArrayList<Map<String, Object>> invoiceList = new ArrayList<Map<String, Object>>(invoiceArray.size());
        for (int i = 0; i < invoiceArray.size(); ++i) {
            JSONObject invoiceInfo = invoiceArray.getJSONObject(i);
            if (ObjectUtils.isEmpty((Object)invoiceInfo)) continue;
            if (needConvert.booleanValue()) {
                this.convertField(invoiceInfo);
            }
            Map invoiceMap = invoiceInfo.getInnerMap();
            invoiceList.add(invoiceMap);
        }
        InvoiceClassService.getInstance().initInvoiceClass(invoiceList);
        return invoiceList;
    }

    public void convertField(JSONObject invoiceInfo) {
        invoiceInfo.put(TAG_TYPE_INVOICE_TYPE, (Object)InputInvoiceTypeEnum.getInvoiceTypeByAwsType(invoiceInfo.getString("invoiceType")));
        invoiceInfo.put(TAG_TYPE_CHECK_STATUS, (Object)invoiceInfo.getString("checkStatus"));
        invoiceInfo.put(TAG_TYPE_IS_REVISE, (Object)invoiceInfo.getString("isRevise"));
        invoiceInfo.put(TAG_TYPE_ORIGINAL_STATUS, (Object)invoiceInfo.getString("originalStatus"));
        invoiceInfo.put(TAG_TYPE_EXPENSE_STATUS, (Object)invoiceInfo.getString("expenseStatus"));
        invoiceInfo.put(TAG_TYPE_AUTHENTICATE_FLAG, (Object)invoiceInfo.getString("authenticateFlag"));
        invoiceInfo.put(TAG_TYPE_INVOICE_STATUS, (Object)invoiceInfo.getString("invoiceStatus"));
        invoiceInfo.put(ENTITY_BUYER_NAME, invoiceInfo.get((Object)"buyerName"));
        invoiceInfo.put(ENTITY_INVOICE_DATE, invoiceInfo.get((Object)"invoiceDate"));
        invoiceInfo.put(ENTITY_PAYER_PARTY_NAME, invoiceInfo.get((Object)"payerPartyName"));
        invoiceInfo.put(ENTITY_SALER_NAME, invoiceInfo.get((Object)"salerName"));
        invoiceInfo.put(ENTITY_EXIT, invoiceInfo.get((Object)ENTITY_EXIT));
        invoiceInfo.put(ENTITY_STATION_GET_OFF, invoiceInfo.get((Object)"stationGetOff"));
        invoiceInfo.put(ENTITY_STATION_GET_ON, invoiceInfo.get((Object)"stationGetOn"));
        invoiceInfo.put(ENTITY_TAX_AUTHORITY_NAME, invoiceInfo.get((Object)"taxAuthorityName"));
        invoiceInfo.put(ENTITY_TOTAL_AMOUNT, invoiceInfo.get((Object)"totalAmount"));
        invoiceInfo.put("place_of_departure", invoiceInfo.get((Object)"placeOfDeparture"));
        invoiceInfo.put(SERIAL_NO, invoiceInfo.get((Object)"serialNo"));
    }

    private void clearListData(String var) {
        this.plugin.getView().getModel().deleteEntryData(var);
    }
}

