/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.helper;

import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.RimConfigUtils;
import org.apache.commons.lang3.StringUtils;

public class ApiLogHelper {
    private static final String[] MSG_TYPES = new String[]{"msg_new_agric_invoice_handle_apply", "msg_new_agric_invoice_handle_query", "msg_new_agric_invoice_down_query", "msg_new_agric_invoice_down_apply", "msg_new_fprz_recorded_commit", "msg_new_fprz_recorded_commit_query", "msg_shuipan", "new_fpdk_inputDownloadFileApply", "fpdk_getTaxPeriod", "fpdk_queryInvoices", "fpdk_getStatisticTable", "fpdk_createStatisticTable", "fpdk_cancelStatisticTable", "fpdk_confirmStatisticTable", "fpdk_selectInvoices", "fpdk_downloadInvoicesApply", "fpdk_downloadInvoicesQuery", "fpdk_drawbackStatisticQuery", "fpdk_drawbackConfirmStatistic", "new_fpdk_inputDownloadFileQuery", "msg_etax_duduct_apply", "msg_etax_duduct_query", "msg_etax_customs_duduct_apply", "msg_etax_customs_duduct_query", "msg_etax_withholding_duduct_apply", "msg_etax_withholding_duduct_query", "new_fpdk_fullInvoiceDownloadApply", "new_fpdk_fullInvoiceDownloadQuery", "new_etax_invoice_full_apply", "new_etax_invoice_full_query", "new_etax_customs_full_apply", "new_etax_customs_full_query", "new_etax_ele_filedown_apply", "msg_new_fprz_recorded_update", "msg_new_fprz_recorded_update_query", "msg_new_header_down_unconfirmed", "msg_new_header_down_unconfirmed_query", "msg_new_header_down_confirmed", "msg_new_header_down_confirmed_query", "msg_new_customs_header_down_unconfirmed", "msg_new_customs_header_down_unconfirmed_query", "msg_new_customs_header_down_confirmed", "msg_new_customs_header_down_confirmed_query", "msg_new_withholding_header_unconfirmed", "msg_new_withholding_header_unconfirmed_query", "msg_new_withholding_header_confirmed", "msg_new_withholding_header_confirmed_query", "new_etax_discard_tasks", "new_etax_ele_filedown_query"};

    public static void asyncSaveLog(String request, String requestUrl, String requestBody, String response, long startTime, String msgType) {
        String traceId = RequestContext.get().getTraceId();
        ThreadPools.executeOnceIncludeRequestContext((String)"ApiLogHelperSaveRun", () -> {
            if (ApiLogHelper.isSaveLog(msgType)) {
                ApiLogHelper.saveLog(request, requestUrl, requestBody, response, startTime, traceId);
            }
        });
    }

    private static boolean isSaveLog(String msgType) {
        if (StringUtils.isEmpty((CharSequence)msgType)) {
            return false;
        }
        HashSet<String> set = new HashSet<String>(8);
        set.addAll(Arrays.asList(MSG_TYPES));
        String retryErrcode = RimConfigUtils.getConfig("save_log_msg_types");
        if (StringUtils.isNotEmpty((CharSequence)retryErrcode)) {
            List<String> multiValues = CommonUtils.getMultiValues(retryErrcode);
            set.addAll(multiValues);
        }
        return set.contains(msgType);
    }

    public static void asyncSaveLog(String request, String requestUrl, String requestBody, String response, long startTime) {
        String traceId = RequestContext.get().getTraceId();
        ThreadPools.executeOnceIncludeRequestContext((String)"ApiLogHelperSaveRun", () -> ApiLogHelper.saveLog(request, requestUrl, requestBody, response, startTime, traceId));
    }

    public static void saveLog(String request, String requestUrl, String requestBody, String response, long startTime, String traceId) {
        DynamicObject apiLog = BusinessDataServiceHelper.newDynamicObject((String)"bdm_api_log");
        apiLog.set("createdate", (Object)new Date());
        apiLog.set("response", (Object)traceId);
        apiLog.set("response", (Object)traceId);
        apiLog.set("response_tag", (Object)response);
        apiLog.set("request", (Object)request);
        apiLog.set("request_tag", (Object)requestBody);
        requestUrl = StringUtils.trimToEmpty((String)requestUrl);
        requestUrl = requestUrl.replaceAll("access_token=[0-9a-zA-Z]*&", "");
        if (requestUrl.contains("access_token=")) {
            requestUrl = requestUrl.substring(0, requestUrl.lastIndexOf("=") + 1);
        }
        apiLog.set("requesturl", (Object)requestUrl);
        apiLog.set("taketime", (Object)(System.currentTimeMillis() - startTime));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{apiLog});
    }
}

