/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.constant.XbrlTypeConstant;
import kd.imc.rim.common.invoice.checknew.model.CheckParam;
import kd.imc.rim.common.invoice.checknew.model.CheckResult;
import kd.imc.rim.common.invoice.download.excel.TaxInvoiceConvertUtil;
import kd.imc.rim.common.invoice.model.ConvertFieldUtil;
import kd.imc.rim.common.invoice.query.convert.InvoiceConvertService;
import kd.imc.rim.common.service.SimplyCheckService;
import kd.imc.rim.common.utils.AwsFpyService;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.HttpUtil;
import kd.imc.rim.common.utils.MetadataUtil;
import kd.imc.rim.common.utils.TenantUtils;
import kd.imc.rim.common.utils.ZipUtil;
import kd.imc.rim.common.utils.extract.OfdExtractUtil;
import kd.imc.rim.file.pdfanalysis.utils.PdfXbrlExtractUtil;
import kd.imc.rim.file.utils.XmlUtil2;
import org.apache.commons.compress.utils.Lists;
import org.dom4j.DocumentException;

public class ElectAccVoucherHelper {
    private static Log logger = LogFactory.getLog(ElectAccVoucherHelper.class);
    private static final String RAI = "ElectronicInvoiceRailwayETicketNumber";
    private static final String ATR = "ElectronicInvoiceAirTransportReceiptNumber";
    private static final String BKER = "bker:";
    private static final String NTREV = "ntrev:";
    private static final String NTREV2 = "efi:";
    private static final String BKRS = "bkrs:";
    private static final String ELE_VAT = "TypeOfInvoice";
    private static final String TYPE_OF_INVOICE_SPECIAL = "\u589e\u503c\u7a0e\u7535\u5b50\u4e13\u7528\u53d1\u7968";
    private static final String TYPE_OF_INVOICE_ORDINARY = "\u589e\u503c\u7a0e\u7535\u5b50\u666e\u901a\u53d1\u7968";
    private static final int connectionTimeout = 3000;
    private static final int readTimeout = 60000;

    public JSONObject getByAwsAPI(Object orgId, byte[] fileByte, String fileName) throws Exception {
        long start = System.currentTimeMillis();
        JSONObject result = new JSONObject();
        String token = AwsFpyService.newInstance().getAccessToken(Long.parseLong(orgId + ""));
        if (StringUtils.isNotEmpty((String)token)) {
            String url = AwsFpyService.newInstance().getUrl("xbrl_analysis", token);
            try (ByteArrayInputStream inputStream = new ByteArrayInputStream(fileByte);){
                String postResult = HttpUtil.postFormData(url, AwsFpyService.newInstance().getProxy(), null, inputStream, fileName, null, 3000, 60000);
                logger.info("\u7535\u5b50\u4f1a\u8ba1\u51ed\u8bc1\u8c03\u7528aws\u63a5\u53e3\u8017\u65f6\uff1a{}\uff0c\u7ed3\u679c\uff1a{}", (Object)(System.currentTimeMillis() - start), (Object)postResult);
                if (postResult != null) {
                    postResult = ElectAccVoucherHelper.removeTextBetweenTargets(postResult, "<inv:SecurityCode", "</inv:SecurityCode>");
                    result.put("errcode", (Object)"0000");
                    result.put("description", (Object)ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"ElectAccVoucherHelper_0", (String)"imc-rim-common", (Object[])new Object[0]));
                    result.put("xbrlInfo", (Object)postResult);
                    result.put("signPassFlag", (Object)true);
                } else {
                    result.put("errcode", (Object)"9999");
                    result.put("description", (Object)ResManager.loadKDString((String)"\u8c03\u7528aws\u7535\u5b50\u51ed\u8bc1\u89e3\u6790\u5931\u8d25", (String)"ElectAccVoucherHelper_1", (String)"imc-rim-common", (Object[])new Object[0]));
                }
            }
        }
        return result;
    }

    public JSONObject getByAnalysis(String fileType, byte[] fileByte) {
        JSONObject result = ResultContant.createSuccessJSONObject();
        result.put("signPassFlag", (Object)false);
        try {
            if ("zip".equalsIgnoreCase(fileType)) {
                JSONObject xbrlObject = ZipUtil.getXbrl((byte[])fileByte);
                logger.info("\u7535\u5b50\u4f1a\u8ba1\u51ed\u8bc1zip\u6587\u4ef6\u672c\u5730\u89e3\u6790\u7ed3\u679c\uff1a{}", (Object)result);
                result.put("xbrlInfo", (Object)xbrlObject.toJSONString());
                result.put("signPassFlag", (Object)true);
            } else if ("ofd".equalsIgnoreCase(fileType)) {
                result.put("xbrlInfo", (Object)OfdExtractUtil.getXbrlStr((byte[])fileByte));
                result.put("signPassFlag", (Object)OfdExtractUtil.verifySign((byte[])fileByte));
                logger.info("\u7535\u5b50\u4f1a\u8ba1\u51ed\u8bc1ofd\u6587\u4ef6\u672c\u5730\u89e3\u6790\u7ed3\u679c\uff1a{}", (Object)result);
            } else if ("pdf".equalsIgnoreCase(fileType)) {
                JSONObject xbrlObject = PdfXbrlExtractUtil.extractXbrl((byte[])fileByte);
                logger.info("\u7535\u5b50\u4f1a\u8ba1\u51ed\u8bc1pdf\u6587\u4ef6\u672c\u5730\u89e3\u6790\u7ed3\u679c\uff1a{}", (Object)xbrlObject);
                if (xbrlObject == null) {
                    return result;
                }
                String message = xbrlObject.getString("message");
                if (StringUtils.isNotEmpty((String)message) && message.contains("xml")) {
                    result.put("xbrlInfo", (Object)message);
                    result.put("signPassFlag", (Object)true);
                }
            }
        }
        catch (Exception e) {
            logger.info("\u89e3\u6790\u7535\u5b50\u4f1a\u8ba1\u51ed\u8bc1\u51fa\u9519\uff1a{}", (Object)e);
            result.put("signPassFlag", (Object)false);
        }
        return result;
    }

    public static String removeTextBetweenTargets(String input, String target1, String target2) {
        int startIndex = input.indexOf(target1);
        int endIndex = input.indexOf(target2);
        if (startIndex != -1 && endIndex != -1) {
            String result = input.substring(0, startIndex) + input.substring(endIndex + target2.length());
            return ElectAccVoucherHelper.removeTextBetweenTargets(result, target1, target2);
        }
        return input;
    }

    public JSONObject toInvoiceJson(String xbrlXml, Object orgId, String taxNo) throws DocumentException {
        JSONObject resultInvoice = new JSONObject();
        if (StringUtils.isEmpty((String)xbrlXml)) {
            return resultInvoice;
        }
        boolean ntrFlag = false;
        boolean efiFlag = false;
        boolean bkerFlag = false;
        boolean bkrsFlag = false;
        if (xbrlXml.contains(NTREV) || xbrlXml.contains("\u975e\u7a0e\u6536\u5165\u7f34\u6b3e\u4e66")) {
            ntrFlag = true;
        } else if (xbrlXml.contains(NTREV2) || xbrlXml.contains("<EInvoiceData>")) {
            efiFlag = true;
        } else if (xbrlXml.contains(BKER) || xbrlXml.contains("\u56de\u5355")) {
            bkerFlag = true;
        } else if (xbrlXml.contains(BKRS)) {
            bkrsFlag = true;
        }
        Map<String, Object> xbrlMap = XmlUtil2.xmlToMap((String)xbrlXml, (boolean)false);
        logger.info("\u7535\u5b50\u4f1a\u8ba1\u51ed\u8bc1\u7ed3\u679c\uff1a{}", (Object)xbrlMap);
        ElectAccVoucherHelper.cleanMapValues(xbrlMap);
        BigDecimal otherTotalAmount = BigDecimal.ZERO;
        String invoiceCode = null;
        String invoiceNo = null;
        Long invoiceType = 0L;
        String itemKey = null;
        boolean needCheck = false;
        if (xbrlMap.containsKey(ELE_VAT)) {
            invoiceCode = (String)xbrlMap.get("CodeOfInvoice");
            invoiceNo = (String)xbrlMap.get("NumberOfInvoice");
            if (TYPE_OF_INVOICE_SPECIAL.equals(xbrlMap.get(ELE_VAT))) {
                invoiceType = InputInvoiceTypeEnum.SPECIAL_ELECTRON.getCode();
            } else if (TYPE_OF_INVOICE_ORDINARY.equals(xbrlMap.get(ELE_VAT))) {
                invoiceType = InputInvoiceTypeEnum.ORDINARY_ELECTRON.getCode();
            }
            itemKey = "InformationOfTaxableGoodsOrServicesDetailItemsTuple";
            Object item = xbrlMap.get(itemKey);
            if (item instanceof LinkedHashMap) {
                JSONArray items = new JSONArray();
                items.add((Object)new JSONObject((Map)((LinkedHashMap)item)));
                xbrlMap.put(itemKey, items);
            }
            needCheck = true;
        } else if (xbrlMap.containsKey(RAI)) {
            invoiceNo = (String)xbrlMap.get(RAI);
            invoiceType = InputInvoiceTypeEnum.TRAIN_ELE_INVOICE.getCode();
            needCheck = Boolean.TRUE;
        } else if (xbrlMap.containsKey(ATR)) {
            invoiceNo = (String)xbrlMap.get(ATR);
            invoiceType = InputInvoiceTypeEnum.AIR_ELE_INVOICE.getCode();
            resultInvoice = new JSONObject(xbrlMap);
            resultInvoice.put("invoiceType", (Object)InputInvoiceTypeEnum.AIR_ELE_INVOICE.getCode());
            this.dealAirEleInvoice(resultInvoice, xbrlMap);
            itemKey = "DetailInformationOfAirTicketTuple";
            needCheck = Boolean.TRUE;
        } else if (ntrFlag || efiFlag) {
            if (ntrFlag) {
                xbrlMap = this.dealFinancialInvoice(xbrlMap);
                invoiceNo = (String)xbrlMap.get("EINVOICE_CODE");
                invoiceCode = (String)xbrlMap.get("NON_TAX_PAY_NO");
            } else {
                xbrlMap = this.dealFinancialInvoice2(xbrlMap);
                invoiceNo = (String)xbrlMap.get("EInvoiceNumber");
                invoiceCode = (String)xbrlMap.get("EInvoiceCode");
            }
            invoiceType = InputInvoiceTypeEnum.FINANCIAL_INVOICE.getCode();
            itemKey = "items";
        } else {
            Object printDate = xbrlMap.get("PrintDate");
            if (printDate == null) {
                printDate = xbrlMap.get("DateOfBookkeeping");
            }
            resultInvoice.put("invoiceDate", printDate);
            resultInvoice.put("isOther", (Object)"1");
            resultInvoice.put("totalAmount", (Object)otherTotalAmount);
            resultInvoice.put("invoiceType", (Object)InputInvoiceTypeEnum.OTHER_INVOICE.getCode());
            resultInvoice.put("serialNo", (Object)UUID.randomUUID());
            resultInvoice.put("invoiceCode", (Object)"");
            resultInvoice.put("invoiceNo", (Object)"");
            resultInvoice.put("isUploadOriginal", (Object)Boolean.FALSE);
            if (bkrsFlag) {
                resultInvoice.put("xbrlType", (Object)XbrlTypeConstant.BANK_STATEMENT.getCode());
            } else if (bkerFlag) {
                resultInvoice.put("xbrlType", (Object)XbrlTypeConstant.BANK_RECEIPT.getCode());
            }
            return resultInvoice;
        }
        String destination = resultInvoice.getString("destination");
        String placeOfDeparture = resultInvoice.getString("placeOfDeparture");
        DynamicObject dynamicObject = ElectAccVoucherHelper.queryInvoiceMain(invoiceCode, invoiceNo);
        Boolean isUploadOriginal = Boolean.TRUE;
        if (dynamicObject == null) {
            resultInvoice = ElectAccVoucherHelper.convertData(xbrlMap, invoiceType, itemKey);
            isUploadOriginal = Boolean.FALSE;
            if (resultInvoice != null && needCheck) {
                this.check(resultInvoice, orgId, taxNo);
            }
            if (resultInvoice != null && InputInvoiceTypeEnum.AIR_ELE_INVOICE.getCode().equals(invoiceType)) {
                this.convertBuyerSalerInfo(resultInvoice);
            }
        } else {
            String serial_no;
            DynamicObject fileObject;
            JSONObject xbrInvoice;
            String entity = InputInvoiceTypeEnum.getEntity(dynamicObject.getLong("invoice_type"));
            DynamicObject invoiceObject = BusinessDataServiceHelper.loadSingle((String)entity, (String)MetadataUtil.getFields((String)entity), (QFilter[])new QFilter[]{new QFilter("serial_no", "=", (Object)dynamicObject.getString("serial_no"))});
            InvoiceConvertService convertService = InvoiceConvertService.newInstance(invoiceType, "4");
            resultInvoice = convertService.convert(DynamicObjectUtil.dynamicObjectToMap(invoiceObject));
            resultInvoice.put("checkStatus", (Object)dynamicObject.getString("check_status"));
            if ((InputInvoiceTypeEnum.AIR_ELE_INVOICE.getCode().equals(invoiceType) || InputInvoiceTypeEnum.TRAIN_ELE_INVOICE.getCode().equals(invoiceType)) && StringUtils.isEmpty((String)resultInvoice.getString("invoiceDate"))) {
                resultInvoice.put("invoiceDate", resultInvoice.get((Object)"issueDate"));
            }
            if ((InputInvoiceTypeEnum.AIR_ELE_INVOICE.getCode().equals(invoiceType) || InputInvoiceTypeEnum.TRAIN_ELE_INVOICE.getCode().equals(invoiceType)) && (xbrInvoice = ElectAccVoucherHelper.convertData(xbrlMap, invoiceType, itemKey)) != null) {
                resultInvoice.put("taxRate", (Object)xbrInvoice.getBigDecimal("taxRate"));
                if (InputInvoiceTypeEnum.AIR_ELE_INVOICE.getCode().equals(invoiceType)) {
                    resultInvoice.put("airportConstructionFee", (Object)xbrInvoice.getBigDecimal("airportConstructionFee"));
                }
            }
            if (!"1".equals(dynamicObject.getString("check_status"))) {
                resultInvoice.put("invoiceType", (Object)invoiceType);
                this.check(resultInvoice, orgId, taxNo);
            }
            resultInvoice.put("destination", (Object)destination);
            resultInvoice.put("placeOfDeparture", (Object)placeOfDeparture);
            String originalState = dynamicObject.getString("original_state");
            if ("1".equals(originalState)) {
                resultInvoice.put("originalTime", (Object)dynamicObject.getDate("original_time"));
            }
            if ((fileObject = QueryServiceHelper.queryOne((String)"rim_invoice_file", (String)"id, original_state, ofd_url, pdf_url, snapshot_url, image_url, xml_url", (QFilter[])new QFilter[]{new QFilter("serial_no", "=", (Object)(serial_no = dynamicObject.getString("serial_no")))})) == null) {
                isUploadOriginal = Boolean.FALSE;
            } else {
                String original_state = fileObject.getString("original_state");
                if (!"1".equals(original_state)) {
                    isUploadOriginal = Boolean.FALSE;
                }
            }
            if (isUploadOriginal.booleanValue()) {
                resultInvoice.put("ofdUrl", (Object)fileObject.getString("ofd_url"));
                resultInvoice.put("pdfUrl", (Object)fileObject.getString("pdf_url"));
                resultInvoice.put("snapshotUrl", (Object)fileObject.getString("snapshot_url"));
                resultInvoice.put("imageUrl", (Object)fileObject.getString("image_url"));
                resultInvoice.put("xmlUrl", (Object)fileObject.getString("xml_url"));
            }
        }
        if (resultInvoice != null) {
            resultInvoice.put("isUploadOriginal", (Object)isUploadOriginal);
            resultInvoice.put("totalTaxAmount", resultInvoice.get((Object)"taxAmount"));
            Object invoiceDate = resultInvoice.get((Object)"invoiceDate");
            if (invoiceDate instanceof Long) {
                Date date = new Date((Long)invoiceDate);
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
                String dateString = formatter.format(date);
                resultInvoice.put("invoiceDate", (Object)dateString);
            }
            if (invoiceDate instanceof Integer) {
                SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
                try {
                    Date parse = formatter.parse(invoiceDate.toString());
                    resultInvoice.put("invoiceDate", (Object)new SimpleDateFormat("yyyy-MM-dd").format(parse));
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
        this.setXbrlType(xbrlMap, resultInvoice);
        return resultInvoice;
    }

    private Map<String, Object> dealFinancialInvoice2(Map<String, Object> xbrlMap) {
        LinkedHashMap invoiceData = (LinkedHashMap)xbrlMap.get("EInvoiceData");
        LinkedHashMap invoiceMain = (LinkedHashMap)invoiceData.get("Main");
        invoiceMain.putAll((LinkedHashMap)invoiceMain.get("InvoicingParty"));
        invoiceMain.putAll((LinkedHashMap)invoiceMain.get("PayerParty"));
        invoiceMain.putAll((LinkedHashMap)invoiceMain.get("InvoicingPartySeal"));
        invoiceMain.putAll((LinkedHashMap)invoiceMain.get("MainExt"));
        LinkedHashMap invoiceDetail = (LinkedHashMap)invoiceData.get("Details");
        List item = (List)invoiceDetail.get("Item");
        JSONArray items = new JSONArray(item);
        invoiceMain.put("items", items);
        invoiceMain.put("IssueTime", invoiceMain.get("IssueDate"));
        invoiceMain.put(NTREV2, NTREV2);
        return invoiceMain;
    }

    private void convertBuyerSalerInfo(JSONObject resultInvoice) {
        resultInvoice.put("buyerName", (Object)(StringUtils.isEmpty((String)resultInvoice.getString("purchaserName")) ? resultInvoice.getString("buyerName") : resultInvoice.getString("purchaserName")));
        resultInvoice.put("buyerTaxNo", (Object)(StringUtils.isEmpty((String)resultInvoice.getString("purchaserUnifiedSocialCreditCode")) ? resultInvoice.getString("buyerTaxNo") : resultInvoice.getString("purchaserUnifiedSocialCreditCode")));
        resultInvoice.put("salerName", (Object)(StringUtils.isEmpty((String)resultInvoice.getString("sellerName")) ? resultInvoice.getString("salerName") : resultInvoice.getString("sellerName")));
    }

    private void setXbrlType(Map<String, Object> xbrlMap, JSONObject resultInvoice) {
        if (Objects.isNull(resultInvoice) || Objects.isNull(xbrlMap) || xbrlMap.size() == 0) {
            return;
        }
        String xbrlCode = "";
        if (xbrlMap.containsKey(ELE_VAT)) {
            xbrlCode = XbrlTypeConstant.E_VAT.getCode();
        } else if (xbrlMap.containsKey(RAI)) {
            xbrlCode = XbrlTypeConstant.TRAIN_ELE.getCode();
        } else if (xbrlMap.containsKey(ATR)) {
            xbrlCode = XbrlTypeConstant.AIR_ELE.getCode();
        } else if (xbrlMap.containsKey(NTREV2)) {
            xbrlCode = XbrlTypeConstant.FINANCIAL.getCode();
        } else if (xbrlMap.containsKey(NTREV)) {
            xbrlCode = XbrlTypeConstant.COVERINGWARRANT.getCode();
        }
        resultInvoice.put("xbrlType", (Object)xbrlCode);
    }

    public static void cleanMapValues(Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof String) {
                String cleanedValue = ((String)value).replaceAll("[\\n\\r\\s]+", "");
                entry.setValue(cleanedValue);
                continue;
            }
            if (value instanceof ArrayList) {
                ArrayList list = (ArrayList)value;
                for (int i = 0; i < list.size(); ++i) {
                    LinkedHashMap listValue = (LinkedHashMap)list.get(i);
                    ElectAccVoucherHelper.cleanMapValues(listValue);
                }
                continue;
            }
            if (!(value instanceof LinkedHashMap)) continue;
            ElectAccVoucherHelper.cleanMapValues((LinkedHashMap)value);
        }
    }

    private void check(JSONObject resultInvoice, Object orgId, String taxNo) {
        CheckParam checkParam;
        CheckResult checkResult;
        String checkTaxNo = resultInvoice.getString("buyerTaxNo");
        if (StringUtils.isEmpty((String)checkTaxNo)) {
            String string = checkTaxNo = StringUtils.isEmpty((String)taxNo) ? TenantUtils.getTaxNoByOrgId((Long)orgId) : taxNo;
        }
        if ("0000".equals((checkResult = SimplyCheckService.checkInvoice(checkParam = ConvertFieldUtil.getInvoiceCheckPart(resultInvoice), (Long)orgId, checkTaxNo)).getErrcode()) && checkResult.getData() != null) {
            Object invoiceEntity = checkResult.getData();
            String invoiceCheckStr = JSONObject.toJSONString((Object)invoiceEntity);
            this.mergeData(resultInvoice, invoiceCheckStr);
            resultInvoice.put("checkStatus", (Object)"1");
        } else {
            resultInvoice.put("checkStatus", (Object)"2");
            resultInvoice.put("errcode", (Object)checkResult.getErrcode());
            resultInvoice.put("description", (Object)checkResult.getDescription());
        }
    }

    private void mergeData(JSONObject resultInvoice, String invoiceCheckStr) {
        JSONObject invoiceCheckJsonObj = JSON.parseObject((String)invoiceCheckStr);
        String items = "items";
        boolean isCheckDataHavaItems = invoiceCheckJsonObj.containsKey((Object)items);
        boolean isResultInvoiceHavaItems = resultInvoice.containsKey((Object)items);
        JSONArray invoiceCheckItems = invoiceCheckJsonObj.getJSONArray(items);
        JSONArray resultInvoiceItems = resultInvoice.getJSONArray(items);
        if (resultInvoiceItems == null) {
            resultInvoiceItems = new JSONArray();
        }
        invoiceCheckJsonObj.remove((Object)items);
        resultInvoice.remove((Object)items);
        resultInvoice.putAll((Map)invoiceCheckJsonObj);
        if (isCheckDataHavaItems && !isResultInvoiceHavaItems) {
            resultInvoice.put(items, (Object)invoiceCheckItems);
        }
        if (isCheckDataHavaItems && isResultInvoiceHavaItems) {
            JSONArray jsonArray = new JSONArray();
            for (int i = 0; i < resultInvoiceItems.size(); ++i) {
                if (i == 0) {
                    JSONObject jsonObject = resultInvoiceItems.getJSONObject(i);
                    JSONObject jsonObject1 = invoiceCheckItems.getJSONObject(i);
                    jsonObject.putAll((Map)jsonObject1);
                    jsonArray.add((Object)jsonObject);
                    continue;
                }
                jsonArray.add((Object)resultInvoiceItems.getJSONObject(i));
            }
            resultInvoice.put(items, (Object)jsonArray);
        }
    }

    private Map<String, Object> dealAirEleInvoice(JSONObject resultInvoice, Map<String, Object> xbrlMap) {
        BigDecimal insuranceDecimal = BigDecimal.ZERO;
        String insurance = resultInvoice.getString("Insurance");
        try {
            insuranceDecimal = new BigDecimal(insurance);
        }
        catch (Exception exception) {
            // empty catch block
        }
        xbrlMap.put("Insurance", insuranceDecimal);
        String internationalFlag = resultInvoice.getString("MarkingOfDomesticOrInternational");
        internationalFlag = "\u56fd\u5185".equals(internationalFlag) ? "1" : "2";
        xbrlMap.put("internationalFlag", internationalFlag);
        String itemKey = "DetailInformationOfAirTicketTuple";
        Object flights = resultInvoice.get((Object)itemKey);
        Map flight = Maps.newHashMap();
        if (flights instanceof LinkedHashMap) {
            flight = (Map)flights;
            if (!flight.isEmpty()) {
                xbrlMap.put("destination", flight.get("DestinationStation"));
            }
            JSONArray item = new JSONArray();
            item.add(flight);
            xbrlMap.put(itemKey, item);
        } else {
            List flightList = (List)resultInvoice.get((Object)itemKey);
            if (flightList != null && flightList.size() > 0) {
                Map flightLast;
                String destinationStation;
                flight = (Map)flightList.get(0);
                String departureStation = (String)flight.get("DepartureStation");
                if (departureStation.equals(destinationStation = (String)(flightLast = (Map)flightList.get(flightList.size() - 1)).get("DestinationStation"))) {
                    destinationStation = (String)flight.get("DestinationStation");
                }
                xbrlMap.put("destination", destinationStation);
            }
        }
        if (!flight.isEmpty()) {
            xbrlMap.put("placeOfDeparture", flight.get("DepartureStation"));
            xbrlMap.put("carrier", flight.get("Carrier"));
            xbrlMap.put("flightNum", flight.get("Flight"));
            xbrlMap.put("seatGrade", flight.get("Class"));
            xbrlMap.put("airTime", flight.get("DepartureTime"));
            xbrlMap.put("invoiceDate", flight.get("CarrierDate"));
        }
        xbrlMap.put("IssuingStatus", TaxInvoiceConvertUtil.getInvoiceStateByCN(xbrlMap.get("IssuingStatus") + ""));
        return xbrlMap;
    }

    private Map<String, Object> dealFinancialInvoice(Map<String, Object> xbrlMap) {
        LinkedHashMap invoiceData = (LinkedHashMap)xbrlMap.get("EINVOICE_DATA");
        LinkedHashMap invoiceMain = (LinkedHashMap)invoiceData.get("MAIN");
        invoiceMain.putAll((LinkedHashMap)invoiceMain.get("EXEC_AGENCY_PARTY"));
        invoiceMain.putAll((LinkedHashMap)invoiceMain.get("PAYER_PARTY"));
        invoiceMain.putAll((LinkedHashMap)invoiceMain.get("INVOICING_PARTY_SEAL"));
        invoiceMain.putAll((LinkedHashMap)invoiceMain.get("SUPERVISOR_PARTY_SEAL"));
        LinkedHashMap invoiceDetail = (LinkedHashMap)invoiceData.get("DETAILS");
        LinkedHashMap item = (LinkedHashMap)invoiceDetail.get("ITEM");
        JSONArray items = new JSONArray();
        items.add((Object)new JSONObject((Map)item));
        invoiceMain.put("items", items);
        invoiceMain.put("BILL_TIME", invoiceMain.get("BILL_DATE"));
        invoiceMain.put(NTREV, NTREV);
        return invoiceMain;
    }

    private static JSONObject convertData(Map<String, Object> xbrlMap, Long invoiceType, String itemKey) {
        JSONObject resultInvoice = new JSONObject(xbrlMap);
        resultInvoice.put("invoiceType", (Object)invoiceType);
        ArrayList entityList = Lists.newArrayList();
        JSONArray resultArray = new JSONArray();
        resultArray.add((Object)resultInvoice);
        ConvertFieldUtil.convertRecognitionEntity(entityList, resultArray, itemKey);
        if (entityList.size() > 0) {
            Object obj = entityList.get(0);
            String invoiceStr = JSONObject.toJSONString(obj);
            return JSON.parseObject((String)invoiceStr);
        }
        return null;
    }

    public static DynamicObject queryInvoiceMain(String invoiceCode, String invoiceNo) {
        QFilter codeFilter = null;
        if (invoiceCode != null) {
            codeFilter = new QFilter("invoice_code", "=", (Object)invoiceCode);
        }
        QFilter noFilter = new QFilter("invoice_no", "=", (Object)invoiceNo);
        return QueryServiceHelper.queryOne((String)"rim_invoice", (String)"id, serial_no, invoice_type, check_status, original_state, original_time", (QFilter[])new QFilter[]{codeFilter, noFilter});
    }
}

