/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.helper;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.TaxExcelImportConstant;
import kd.imc.rim.common.invoice.collector.TaxExcelAuthResolverConstant;
import kd.imc.rim.common.invoice.collector.TaxExcelCustomResolverConstant;
import kd.imc.rim.common.invoice.collector.TaxExcelDeductResolverConstant;
import kd.imc.rim.common.invoice.collector.TaxExcelDkdjDeductResolverConstant;
import kd.imc.rim.common.invoice.collector.TaxExcelHkjkDeductResolverConstant;
import kd.imc.rim.common.invoice.collector.TaxExcelResolverConstant;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DeductionUtils;
import kd.imc.rim.common.utils.UUID;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public abstract class ExcelInvoiceImportUtil {
    private static Log logger = LogFactory.getLog(ExcelInvoiceImportUtil.class);
    private static Map<String, String> codeNameMap = new HashMap<String, String>();

    public static JSONObject[] checkInvoice(Workbook workbook, JSONObject fileParam, Map<Integer, Set<String>> checkFieldMap, int startRow, Map<Integer, JSONObject[]> checkDataParam) {
        boolean dkdjDeductImportFlag;
        long startTime = System.currentTimeMillis();
        logger.info("\u7edf\u8ba1\u786e\u8ba4\u3001\u62b5\u6263\u548c\u4e0d\u62b5\u6263\u5bfc\u5165\uff0c\u5b57\u6bb5\u6821\u9a8c\uff0c\u5f00\u59cb\uff0c{}", (Object)startTime);
        if (MapUtils.isEmpty(checkDataParam)) {
            return null;
        }
        String excelType = fileParam.getString("excelType");
        boolean deductImportFlag = "import_deduct_excel".equals(excelType) || "import_not_deduct_excel".equals(excelType);
        boolean hgjkDeductImportFlag = "import_hkjk_deduct".equals(excelType) || "import_hkjk_not_deduct".equals(excelType);
        boolean bl = dkdjDeductImportFlag = "import_dkdj_deduct".equals(excelType) || "import_dkdj_not_deduct".equals(excelType);
        if (deductImportFlag) {
            codeNameMap = TaxExcelDeductResolverConstant.getInvoiceResolver();
        }
        if (hgjkDeductImportFlag) {
            codeNameMap = TaxExcelHkjkDeductResolverConstant.getInvoiceResolver();
        }
        if (dkdjDeductImportFlag) {
            codeNameMap = TaxExcelDkdjDeductResolverConstant.getInvoiceResolver();
        }
        if ("import_authenticate_excel".equals(excelType)) {
            codeNameMap = TaxExcelAuthResolverConstant.getInvoiceResolver();
        }
        ArrayList<JSONObject> invoiceList = new ArrayList<JSONObject>();
        String fileName = fileParam.getString("fileName");
        JSONObject excelImportResult = new JSONObject();
        String fileId = UUID.randomUUID();
        excelImportResult.put("file_num", (Object)fileId);
        excelImportResult.put("resolve_status", (Object)"1");
        excelImportResult.put("excel_name", (Object)fileName);
        excelImportResult.put("upload_time", (Object)new Date());
        excelImportResult.put("operate_user", (Object)RequestContext.get().getUserId());
        String fileKey = "excel_file_id" + RequestContext.get().getUserId();
        String cache = CacheHelper.get(fileKey);
        int timeout = CommonUtils.getTempFileMaxTimeout();
        JSONArray fileIds = cache == null ? new JSONArray() : JSONArray.parseArray((String)cache);
        if (!fileIds.contains((Object)fileId)) {
            fileIds.add((Object)fileId);
            CacheHelper.put(fileKey, fileIds.toJSONString(), timeout);
        }
        CacheHelper.put(fileId, excelImportResult.toJSONString(), timeout);
        ByteArrayOutputStream os = null;
        ByteArrayInputStream fin = null;
        try {
            for (Map.Entry<Integer, JSONObject[]> entry : checkDataParam.entrySet()) {
                int sheetNumber = entry.getKey();
                ExcelInvoiceImportUtil.setCodeNameMap(codeNameMap, sheetNumber);
                Set<String> checkFiledSet = checkFieldMap.get(sheetNumber);
                JSONObject[] invoiceArray = entry.getValue();
                Sheet sheet = workbook.getSheetAt(sheetNumber);
                Row paramRow = sheet.getRow(startRow);
                int writeCellNum = paramRow.getPhysicalNumberOfCells();
                paramRow.createCell(writeCellNum).setCellValue(ResManager.loadKDString((String)"\u5bfc\u5165\u7ed3\u679c", (String)"TaxInvoiceExcelImportTask_0", (String)"imc-rim-common", (Object[])new Object[0]));
                for (JSONObject invoice : invoiceArray) {
                    String deductCheckResult;
                    ApiResult apiResult;
                    String qdzpLx;
                    Row resultRow = sheet.getRow(invoice.getInteger("row").intValue());
                    String invoiceCode = invoice.getString("invoiceCode");
                    String invoiceNo = invoice.getString("invoiceNo");
                    String eleInvoiceNo = invoice.getString("eleInvoiceNo");
                    if (StringUtils.isBlank((CharSequence)eleInvoiceNo) && StringUtils.isBlank((CharSequence)invoiceNo)) {
                        resultRow.createCell(writeCellNum).setCellValue(ResManager.loadKDString((String)"\u6570\u7535\u7968\u53f7\u7801\u3001\u53d1\u7968\u53f7\u7801\u90fd\u4e0d\u5b58\u5728", (String)"ExcelInvoiceImportUtil_6", (String)"imc-rim-common", (Object[])new Object[0]));
                        continue;
                    }
                    invoiceCode = Optional.ofNullable(invoiceCode).orElse("");
                    invoiceNo = Optional.ofNullable(invoiceNo).orElse("");
                    eleInvoiceNo = Optional.ofNullable(eleInvoiceNo).orElse("");
                    invoiceCode = invoiceCode.replace("-", "");
                    invoiceNo = invoiceNo.replace("-", "");
                    eleInvoiceNo = eleInvoiceNo.replace("-", "");
                    String invoiceType = TaxExcelImportConstant.getInvoiceType(invoice.getString("invoiceType"), invoiceCode, invoiceNo);
                    if (InputInvoiceTypeEnum.isEleByAwsType(invoiceType).booleanValue()) {
                        invoice.put("invoiceCode", (Object)"");
                        invoiceNo = eleInvoiceNo;
                        invoice.put("invoiceNo", (Object)eleInvoiceNo);
                    }
                    if (StringUtils.isNotEmpty((CharSequence)(qdzpLx = TaxExcelImportConstant.isQdzp(invoice.getString("invoiceType"))))) {
                        invoice.put("etaxInvoiceNo", (Object)eleInvoiceNo);
                    }
                    if ("import_authenticate_excel".equals(excelType) && sheetNumber == 1) {
                        invoiceType = InputInvoiceTypeEnum.HGJKS.getAwsType();
                    }
                    if ("import_authenticate_excel".equals(excelType) && sheetNumber == 2) {
                        invoiceType = InputInvoiceTypeEnum.WITHHOLDING.getAwsType();
                    }
                    if ("import_hkjk_deduct".equals(excelType) || "import_hkjk_not_deduct".equals(excelType)) {
                        invoiceType = InputInvoiceTypeEnum.HGJKS.getAwsType();
                        invoice.put("totalTaxAmount", (Object)invoice.getString("totalAmount"));
                        invoice.put("skje", (Object)invoice.getString("totalAmount"));
                        invoice.put("skje", (Object)invoice.getString("totalAmount"));
                    } else if ("import_dkdj_deduct".equals(excelType) || "import_dkdj_not_deduct".equals(excelType)) {
                        invoiceType = InputInvoiceTypeEnum.WITHHOLDING.getAwsType();
                    }
                    if (InputInvoiceTypeEnum.HGJKS.getAwsType().equals(invoiceType)) {
                        invoice.put("totalTaxAmount", (Object)invoice.getString("totalAmount"));
                        invoice.put("skje", (Object)invoice.getString("totalAmount"));
                    }
                    if (StringUtils.equals((CharSequence)"1", (CharSequence)invoice.getString("dateRegError")) || ExcelInvoiceImportUtil.checkDateReg(invoice, "invoiceDate", "selectTime", "selectAuthenticateTime")) {
                        resultRow.createCell(writeCellNum).setCellValue(ResManager.loadKDString((String)"\u65f6\u95f4\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u6309\u7167\u7a0e\u5c40\u5bfc\u51fa\u7684\u6587\u4ef6\u4e0a\u4f20", (String)"ExcelInvoiceImportUtil_9", (String)"imc-rim-common", (Object[])new Object[0]));
                        continue;
                    }
                    if (!CollectionUtils.isEmpty(checkFiledSet) && (apiResult = ExcelInvoiceImportUtil.checkHaveNull(checkFiledSet, invoice, invoice.getString("invoiceType"), sheetNumber)) != null) {
                        resultRow.createCell(writeCellNum).setCellValue(apiResult.getMessage());
                        continue;
                    }
                    if (deductImportFlag || hgjkDeductImportFlag || dkdjDeductImportFlag) {
                        String checkFlag = invoice.getString("checkFlag");
                        if ("\u5426".equals(checkFlag)) {
                            invoice.put("checkFlag", (Object)"0");
                        } else if ("\u662f".equals(checkFlag)) {
                            invoice.put("checkFlag", (Object)"1");
                        } else {
                            resultRow.createCell(writeCellNum).setCellValue(ResManager.loadKDString((String)"\u662f\u5426\u52fe\u9009\u53ea\u6709\uff1a'\u662f'\u3001'\u5426'\u4e24\u4e2a\u9009\u9879", (String)"ExcelInvoiceImportUtil_7", (String)"imc-rim-common", (Object[])new Object[0]));
                            continue;
                        }
                        invoice.put("authenticateFlag", (Object)invoice.getString("checkFlag"));
                        if (StringUtils.isNotBlank((CharSequence)invoice.getString("notDeductibleType"))) {
                            invoice.put("notDeductibleType", (Object)ExcelInvoiceImportUtil.getUndeductReasonCode(invoice.getString("notDeductibleType")));
                        }
                    }
                    if (hgjkDeductImportFlag || dkdjDeductImportFlag) {
                        deductCheckResult = DeductionUtils.checkDeductionFiledNew(invoice);
                        if (deductCheckResult != null) {
                            resultRow.createCell(writeCellNum).setCellValue(deductCheckResult);
                            continue;
                        }
                    } else {
                        deductCheckResult = DeductionUtils.checkDeductionFiled(invoice);
                        if (deductCheckResult != null) {
                            resultRow.createCell(writeCellNum).setCellValue(deductCheckResult);
                            continue;
                        }
                    }
                    invoice.put("invoiceType", (Object)invoiceType);
                    invoice.put("invoiceStatus", (Object)TaxExcelImportConstant.getInvoiceStatus(invoice.getString("invoiceStatus")));
                    if ("import_deduct_excel".equals(excelType) && "\u9501\u5b9a".equals(invoice.getString("redLockFlag"))) {
                        invoice.put("invoiceStatus", (Object)"6");
                    }
                    invoiceList.add(invoice);
                    resultRow.createCell(writeCellNum).setCellValue(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f", (String)"TaxInvoiceExcelImportTask_3", (String)"imc-rim-common", (Object[])new Object[0]));
                }
                byte[] bytes = null;
                os = new ByteArrayOutputStream();
                workbook.write((OutputStream)os);
                bytes = os.toByteArray();
                String exportFileName = String.format(ResManager.loadKDString((String)"%1$s_\u5bfc\u5165\u7ed3\u679c_%2$s", (String)"InvoiceExcelImportTask_60", (String)"imc-rim-common", (Object[])new Object[0]), DateUtils.format(new Date(), "yyyyMMddHHmmss"), fileName);
                fin = new ByteArrayInputStream(bytes);
                String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(exportFileName, (InputStream)fin, timeout);
                excelImportResult.put("resolve_status", (Object)"2");
                excelImportResult.put("url", (Object)url);
                excelImportResult.put("export_file_name", (Object)url);
                CacheHelper.put(fileId, excelImportResult.toJSONString(), timeout);
                logger.info("\u7edf\u8ba1\u786e\u8ba4\u3001\u62b5\u6263\u548c\u4e0d\u62b5\u6263\u5bfc\u5165\uff0c\u5b57\u6bb5\u6821\u9a8c\uff0c\u8017\u65f6: {}", (Object)(System.currentTimeMillis() - startTime));
            }
            JSONObject[] jSONObjectArray = invoiceList.toArray(new JSONObject[0]);
            return jSONObjectArray;
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790excel\u5f02\u5e38\uff1a", (Throwable)e);
            excelImportResult.put("resolve_status", (Object)"3");
            CacheHelper.put(fileId, excelImportResult.toJSONString(), timeout);
            throw new MsgException(e, String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u6570\u636e\u683c\u5f0f\u6709\u8bef\uff0c\u8bf7\u4f7f\u7528\u7a0e\u5c40\u4e0b\u8f7d\u7684excel\u5bfc\u5165\uff1a%1$s", (String)"ExcelInvoiceImportUtil_1", (String)"imc-rim-common", (Object[])new Object[0]), e.getMessage()));
        }
        finally {
            IOUtils.closeQuietly(fin);
            IOUtils.closeQuietly(os);
            IOUtils.closeQuietly((Closeable)workbook);
        }
    }

    private static void setCodeNameMap(Map<String, String> codeNameMap, int sheetNumber) {
        if (1 == sheetNumber) {
            codeNameMap = TaxExcelAuthResolverConstant.getCustomsInvoiceResolver();
        }
        if (2 == sheetNumber) {
            codeNameMap = TaxExcelAuthResolverConstant.getInvoiceWithholdremitInvoiceResolver();
        }
    }

    private static boolean checkDateReg(JSONObject invoice, String ... fieldNames) {
        for (String fieldName : fieldNames) {
            Object time = invoice.get((Object)fieldName);
            if (!(time instanceof String)) continue;
            try {
                DateUtils.stringToDate(invoice.getString(fieldName), "yyyy-MM-dd HH:mm:ss");
            }
            catch (Exception e) {
                try {
                    DateUtils.stringToDate(invoice.getString(fieldName), "yyyy-MM-dd");
                }
                catch (Exception exception) {
                    logger.info("\u65f6\u95f4\u683c\u5f0f\u9519\u8bef\uff0c{}", invoice.get((Object)fieldName));
                    return true;
                }
            }
        }
        return false;
    }

    private static ApiResult checkHaveNull(Set<String> fields, JSONObject data, String invoiceTypeName, int sheetNumber) {
        for (String field : fields) {
            Object value = data.get((Object)field);
            if (Objects.isNull(value)) {
                if (sheetNumber == 0) {
                    return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"%1$s\u7f3a\u5c11\u5fc5\u5f55\u53c2\u6570\uff1a%2$s", (String)"ExcelInvoiceImportUtil_5", (String)"imc-rim-common", (Object[])new Object[0]), invoiceTypeName, ExcelInvoiceImportUtil.getFieldChineseName(field)), (String)"2001");
                }
                return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"\u7f3a\u5c11\u5fc5\u5f55\u53c2\u6570\uff1a%1$s", (String)"ExcelInvoiceImportUtil_10", (String)"imc-rim-common", (Object[])new Object[0]), ExcelInvoiceImportUtil.getFieldChineseName(field)), (String)"2001");
            }
            if (!(value instanceof String) || !org.apache.commons.lang.StringUtils.isBlank((String)((String)value))) continue;
            if (sheetNumber == 0) {
                return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"%1$s\u7f3a\u5c11\u5fc5\u5f55\u53c2\u6570\uff1a%2$s", (String)"ExcelInvoiceImportUtil_5", (String)"imc-rim-common", (Object[])new Object[0]), invoiceTypeName, ExcelInvoiceImportUtil.getFieldChineseName(field)), (String)"2001");
            }
            return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"\u7f3a\u5c11\u5fc5\u5f55\u53c2\u6570\uff1a%1$s", (String)"ExcelInvoiceImportUtil_10", (String)"imc-rim-common", (Object[])new Object[0]), ExcelInvoiceImportUtil.getFieldChineseName(field)), (String)"2001");
        }
        return null;
    }

    private static String getFieldChineseName(String code) {
        for (Map.Entry<String, String> entry : codeNameMap.entrySet()) {
            String value = entry.getValue();
            if (!value.equals(code)) continue;
            return entry.getKey();
        }
        return code;
    }

    public static JSONObject[] getInvoiceObjectArray(Sheet sheet, String type, int valueRowNo, int invoiceLast, Row fieldNameRow, JSONObject defaultInvoice, boolean checkNotDeductibleType, String taxNoInput) {
        boolean hasCheckedFlag = false;
        if (invoiceLast < valueRowNo) {
            return new JSONObject[0];
        }
        JSONObject[] invoiceArray = new JSONObject[invoiceLast - valueRowNo + 1];
        for (int cIndex = fieldNameRow.getFirstCellNum(); cIndex < fieldNameRow.getLastCellNum(); ++cIndex) {
            Cell fieldCell = fieldNameRow.getCell(cIndex);
            if (fieldCell == null || StringUtils.isBlank((CharSequence)fieldCell.getStringCellValue())) {
                logger.info("\u53d1\u7968\u5bfc\u5165\uff0c\u89e3\u6790excel\uff0c\u5b57\u6bb5\u540d\u4e3a\u7a7a\uff0c\u5ffd\u7565");
                continue;
            }
            String fieldName = ExcelInvoiceImportUtil.invoiceCell2Name(fieldCell.getStringCellValue(), type);
            for (int rIndex = valueRowNo; rIndex <= invoiceLast; ++rIndex) {
                block29: {
                    int invoiceIndex = rIndex - valueRowNo;
                    Row row = sheet.getRow(rIndex);
                    if (checkNotDeductibleType && "notDeductibleType".equals(fieldName)) {
                        checkNotDeductibleType = false;
                    }
                    if (row == null) continue;
                    Cell cell = row.getCell(cIndex);
                    if (cell == null) {
                        if (!"invoiceNo".equals(fieldName) || !"withholdremit".equals(type) || rIndex != invoiceLast) continue;
                        ++cIndex;
                        continue;
                    }
                    if (invoiceArray[invoiceIndex] == null) {
                        invoiceArray[invoiceIndex] = new JSONObject();
                        if (MapUtils.isNotEmpty((Map)defaultInvoice)) {
                            invoiceArray[invoiceIndex].putAll((Map)defaultInvoice);
                        }
                    }
                    CellType cellType = cell.getCellType();
                    invoiceArray[invoiceIndex].put("row", (Object)rIndex);
                    if (CellType.NUMERIC.equals((Object)cellType)) {
                        String strVal;
                        if ("selectTime".equals(fieldName) || "invoiceDate".equals(fieldName) || "selectAuthenticateTime".equals(fieldName)) {
                            try {
                                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                                    Date dateCellValue = cell.getDateCellValue();
                                    if (dateCellValue != null) {
                                        invoiceArray[invoiceIndex].put(fieldName, (Object)dateCellValue);
                                        if ("selectTime".equals(fieldName)) {
                                            invoiceArray[invoiceIndex].put("selectAuthenticateTime", (Object)dateCellValue);
                                        }
                                        if ("selectAuthenticateTime".equals(fieldName)) {
                                            invoiceArray[invoiceIndex].put("selectTime", (Object)dateCellValue);
                                        }
                                    }
                                } else if (StringUtils.isBlank((CharSequence)invoiceArray[invoiceIndex].getString("dateRegError"))) {
                                    invoiceArray[invoiceIndex].put("dateRegError", (Object)"1");
                                }
                                break block29;
                            }
                            catch (Exception e) {
                                logger.info("\u65f6\u95f4\u683c\u5f0f\u8f6c\u6362\u6709\u8bef", (Object)e);
                                if (StringUtils.isBlank((CharSequence)invoiceArray[invoiceIndex].getString("dateRegError"))) {
                                    invoiceArray[invoiceIndex].put("dateRegError", (Object)"1");
                                }
                                break block29;
                            }
                        }
                        BigDecimal val = BigDecimalUtil.transDecimal(cell.getNumericCellValue());
                        if ("invoiceCode".equals(fieldName) || "invoiceNo".equals(fieldName) || "eleInvoiceNo".equals(fieldName) || "goodsCode".equals(fieldName)) {
                            strVal = val.stripTrailingZeros().toPlainString();
                        } else {
                            strVal = BigDecimalUtil.format(val);
                            if ("totalTaxAmount".equals(fieldName)) {
                                invoiceArray[invoiceIndex].put("taxAmount", (Object)strVal);
                            }
                        }
                        invoiceArray[invoiceIndex].put(fieldName, (Object)strVal);
                    } else if (CellType.STRING.equals((Object)cellType)) {
                        if (checkNotDeductibleType && "checkFlag".equals(fieldName) && !hasCheckedFlag && "\u662f".equals(cell.getStringCellValue())) {
                            hasCheckedFlag = true;
                        }
                        String cellValue = cell.getStringCellValue();
                        if ("buyerTaxNo".equals(fieldName) && !taxNoInput.equals(cellValue)) {
                            throw new MsgException("0003", ResManager.loadKDString((String)"\u8d2d\u65b9\u7a0e\u53f7\u548c\u6240\u9009\u7ec4\u7ec7\u7a0e\u53f7\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5", (String)"ExcelInvoiceImportUtil_2", (String)"imc-rim-common", (Object[])new Object[0]));
                        }
                        invoiceArray[invoiceIndex].put(fieldName, (Object)cellValue);
                        if ("selectTime".equals(fieldName)) {
                            invoiceArray[invoiceIndex].put("selectAuthenticateTime", (Object)cellValue);
                        }
                        if ("selectAuthenticateTime".equals(fieldName)) {
                            invoiceArray[invoiceIndex].put("selectTime", (Object)cellValue);
                        }
                    }
                }
                if (!"invoiceNo".equals(fieldName) || !"withholdremit".equals(type) || rIndex != invoiceLast) continue;
                ++cIndex;
            }
        }
        if (hasCheckedFlag && checkNotDeductibleType) {
            throw new KDException(new ErrorCode("2001", ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u5217 \u2019\u4e0d\u62b5\u6263\u539f\u56e0\u2018 \uff0c\u68c0\u67e5\u5bfc\u5165\u6a21\u677f\u662f\u5426\u6b63\u786e", (String)"ExcelInvoiceImportUtil_3", (String)"imc-rim-common", (Object[])new Object[0])), new Object[0]);
        }
        return invoiceArray;
    }

    public static String invoiceCell2Name(String invoiceCellName, String type) {
        Map<String, String> resolver = null;
        if ("invoice".equals(type)) {
            resolver = TaxExcelResolverConstant.getInvoiceResolver();
        }
        if ("hgjk".equals(type)) {
            resolver = TaxExcelCustomResolverConstant.getInvoiceResolver();
        }
        if ("hgjk_items".equals(type)) {
            resolver = TaxExcelCustomResolverConstant.getInvoiceResolverItem();
        }
        if ("items".equals(type)) {
            resolver = TaxExcelResolverConstant.getInvoiceResolverItem();
        }
        if ("air_train_items".equals(type)) {
            resolver = TaxExcelResolverConstant.getResolverAirItem();
        }
        if ("motor_train_items".equals(type)) {
            resolver = TaxExcelResolverConstant.getResolverMotoItem();
        }
        if ("auth".equals(type)) {
            resolver = TaxExcelAuthResolverConstant.getInvoiceResolver();
        }
        if ("customs".equals(type)) {
            resolver = TaxExcelAuthResolverConstant.getCustomsInvoiceResolver();
        }
        if ("withholdremit".equals(type)) {
            resolver = TaxExcelAuthResolverConstant.getInvoiceWithholdremitInvoiceResolver();
        }
        if ("deduct".equals(type)) {
            resolver = TaxExcelDeductResolverConstant.getInvoiceResolver();
        }
        if ("hkjk_deduct".equals(type)) {
            resolver = TaxExcelHkjkDeductResolverConstant.getInvoiceResolver();
        }
        if ("dkdj_deduct".equals(type)) {
            resolver = TaxExcelDkdjDeductResolverConstant.getInvoiceResolver();
        }
        if (resolver == null) {
            throw new KDException(new ErrorCode("2001", ResManager.loadKDString((String)"\u53d1\u7968\u7c7b\u578b\u6709\u8bef", (String)"ExcelInvoiceImportUtil_4", (String)"imc-rim-common", (Object[])new Object[0])), new Object[0]);
        }
        invoiceCellName = StringUtils.trimToEmpty((String)invoiceCellName);
        for (Map.Entry<String, String> entry : resolver.entrySet()) {
            String[] names;
            String entryKey = entry.getKey();
            for (String name : names = entryKey.split(",")) {
                if (!invoiceCellName.equals(name)) continue;
                return entry.getValue();
            }
        }
        return invoiceCellName;
    }

    private static String getUndeductReasonCode(String undeductReason) {
        if (StringUtils.isNotBlank((CharSequence)undeductReason)) {
            if (StringUtils.contains((CharSequence)undeductReason, (CharSequence)"\u975e\u5e94\u7a0e\u9879\u76ee")) {
                return "1";
            }
            if (StringUtils.contains((CharSequence)undeductReason, (CharSequence)"\u514d\u7a0e\u9879\u76ee")) {
                return "2";
            }
            if (StringUtils.contains((CharSequence)undeductReason, (CharSequence)"\u96c6\u4f53\u798f\u5229") || StringUtils.contains((CharSequence)undeductReason, (CharSequence)"\u4e2a\u4eba\u6d88\u8d39")) {
                return "3";
            }
            if (StringUtils.contains((CharSequence)undeductReason, (CharSequence)"\u975e\u6b63\u5e38\u635f\u5931")) {
                return "4";
            }
            return "5";
        }
        return undeductReason;
    }
}

