/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.checknew.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.sql.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.rim.common.constant.HolytaxInvoiceTypeEnum;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.invoice.checknew.CheckService;
import kd.imc.rim.common.invoice.checknew.model.CheckParam;
import kd.imc.rim.common.invoice.checknew.model.CheckResult;
import kd.imc.rim.common.invoice.model.ConvertFieldUtil;
import kd.imc.rim.common.utils.AisinoService;
import kd.imc.rim.common.utils.ImcConfigUtil;
import kd.imc.rim.common.utils.UUID;

public class HangxinCheckService
implements CheckService {
    private static Log logger = LogFactory.getLog(HangxinCheckService.class);

    @Override
    public CheckResult checkInvoice(CheckParam checkParam) {
        CheckResult checkResult = new CheckResult();
        Map<String, Object> extMap = checkParam.getExtMap();
        Long orgId = (Long)extMap.get("orgId");
        String taxNo = (String)extMap.get("taxNo");
        String check_tax_no = ImcConfigUtil.getValue("rim_deduction", "aisino_tax_no");
        if (StringUtils.isEmpty((CharSequence)check_tax_no)) {
            check_tax_no = taxNo;
        }
        if (StringUtils.isEmpty((CharSequence)check_tax_no)) {
            checkResult.setErrcode("3301");
            checkResult.setDescription(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6240\u5728\u7684\u7ec4\u7ec7\u672a\u914d\u7f6e\u7a0e\u53f7,\u8bf7\u5728\u53d1\u7968\u4e91-\u57fa\u7840\u8d44\u6599-\u4f01\u4e1a\u7ba1\u7406\u4e2d\u914d\u7f6e", (String)"HangxinCheckService_0", (String)"imc-rim-common", (Object[])new Object[0]));
            return checkResult;
        }
        if (StringUtils.isEmpty((CharSequence)checkParam.getInvoiceCode())) {
            checkParam.setInvoiceCode("");
        }
        Long invoiceType = checkParam.getInvoiceType();
        String invoiceNo = checkParam.getInvoiceNo();
        String invoiceCode = checkParam.getInvoiceCode();
        boolean allElectricFlag = StringUtils.isBlank((CharSequence)invoiceCode) && !StringUtils.isEmpty((CharSequence)invoiceNo) && invoiceNo.length() == 20;
        AisinoService aisinoService = AisinoService.newInstance();
        LinkedHashMap postMap = Maps.newLinkedHashMap();
        postMap.put("fpdm", invoiceCode);
        postMap.put("fphm", invoiceNo);
        String holytaxType = HolytaxInvoiceTypeEnum.getHolytaxType(invoiceType);
        if (allElectricFlag && !HolytaxInvoiceTypeEnum.TRAIN_ELE_INVOICE.getCode().equals(holytaxType) && !HolytaxInvoiceTypeEnum.AIR_ELE_INVOICE.getCode().equals(holytaxType)) {
            holytaxType = HolytaxInvoiceTypeEnum.SPECIAL_ELECTRON.getCode();
        }
        postMap.put("fplx", holytaxType);
        postMap.put("kprq", checkParam.getInvoiceDate());
        BigDecimal invoiceMoney = checkParam.getInvoiceMoney();
        if (invoiceMoney != null) {
            postMap.put("je", invoiceMoney.setScale(2));
        } else if (allElectricFlag && checkParam.getTotalAmount() != null) {
            postMap.put("je", checkParam.getTotalAmount().setScale(2));
        }
        String checkCode = checkParam.getCheckCode();
        if (StringUtils.isNotEmpty((CharSequence)checkCode) && checkCode.length() > 6) {
            checkCode = checkCode.substring(checkCode.length() - 6);
        }
        postMap.put("jym", checkCode);
        logger.info("\u8c03\u7528\u822a\u4fe1\u67e5\u9a8c\u63a5\u53e3\u53c2\u6570\uff1a" + postMap);
        long startTime = System.currentTimeMillis();
        boolean cache = true;
        String forceCheck = ImcConfigUtil.getValue("rim_recog_check", "force_check", "0");
        logger.info("\u5f3a\u5236\u67e5\u9a8c\u914d\u7f6e\u9879\u662f\u5426\u6253\u5f00\uff1a{}", (Object)forceCheck);
        JSONObject result = this.getReultFormDb(checkParam, "HangxinCheckService");
        if (result == null) {
            cache = false;
            result = aisinoService.postAppJson("jx.invoiceCheck", orgId, check_tax_no, (Map)postMap);
        }
        logger.info("\u82cd\u7a79\u822a\u4fe1\u67e5\u9a8c\u8017\u65f6\uff1a{}\uff0c\u7f13\u5b58:{},\u8fd4\u56de\u7ed3\u679c\uff1a{}", new Object[]{System.currentTimeMillis() - startTime, cache, result});
        if (result == null) {
            return checkResult;
        }
        String errCode = this.getFinalErrcode(checkParam.getInvoiceDate(), result.getString("errcode"));
        checkResult.setErrcode(errCode);
        checkResult.setDescription(result.getString("description"));
        JSONObject checkInvoiceInfo = result.getJSONObject("data");
        if (checkInvoiceInfo != null) {
            String taxRate;
            JSONArray invoiceList = checkInvoiceInfo.getJSONArray("invoiceList");
            JSONObject invoiceInfo = invoiceList.getJSONObject(0).getJSONObject("invoiceInfo");
            if (cache && !this.checkCache(checkParam, invoiceInfo)) {
                checkResult.setErrcode("1005");
                checkResult.setDescription(ResManager.loadKDString((String)"\u53d1\u7968\u4e0d\u89c4\u8303\uff0c\u8bf7\u68c0\u67e5\u5fc5\u586b\u5b57\u6bb5\u662f\u5426\u6b63\u786e", (String)"HangxinCheckService_1", (String)"imc-rim-common", (Object[])new Object[0]));
                return checkResult;
            }
            if (!cache) {
                this.saveReultToDb(checkParam, result, "HangxinCheckService");
            }
            if (StringUtils.isNotEmpty((CharSequence)(taxRate = invoiceInfo.getString("taxRate"))) && taxRate.contains("%")) {
                taxRate = taxRate.replace("%", "");
                invoiceInfo.put("taxRate", (Object)new BigDecimal(taxRate).divide(new BigDecimal("100")));
            }
            String cancellationMark = invoiceInfo.getString("cancellationMark");
            invoiceInfo.put("invoiceStatus", (Object)"0");
            if ("Y".equals(cancellationMark)) {
                invoiceInfo.put("invoiceStatus", (Object)"2");
            } else if (StringUtils.isNotEmpty((CharSequence)cancellationMark) && !"N".equals(cancellationMark)) {
                invoiceInfo.put("invoiceStatus", (Object)cancellationMark);
            }
            invoiceInfo.put("serialNo", (Object)UUID.randomUUID());
            String invoiceDate = invoiceInfo.getString("invoiceDate");
            try {
                java.util.Date date = new SimpleDateFormat("yyyyMMdd").parse(invoiceDate.replaceAll("-", ""));
                String invoiceDateStr = new SimpleDateFormat("yyyy-MM-dd").format(date);
                invoiceInfo.put("invoiceDate", (Object)Date.valueOf(invoiceDateStr));
            }
            catch (ParseException e) {
                logger.info("\u822a\u4fe1\u67e5\u9a8c\u4e2d\u65e5\u671f\u8f6c\u6362\u9519\u8bef\uff1a", (Object)e.getMessage());
            }
            String holytaxInvoiceType = invoiceInfo.getString("invoiceType");
            Long invoiceType1 = HolytaxInvoiceTypeEnum.getInvoiceTypeByHolytaxType(holytaxInvoiceType);
            if (allElectricFlag) {
                if (InputInvoiceTypeEnum.ORDINARY_ELECTRON.getCode().equals(invoiceType1)) {
                    invoiceType1 = InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getCode();
                }
                if (InputInvoiceTypeEnum.SPECIAL_ELECTRON.getCode().equals(invoiceType1)) {
                    invoiceType1 = InputInvoiceTypeEnum.ELECTRIC_SPECIAL.getCode();
                }
            }
            invoiceInfo.put("invoiceType", (Object)invoiceType1);
            String itemsKey = "detailList";
            Object entity = ConvertFieldUtil.convertCheckEntityByInvoiceType(invoiceType1, invoiceInfo, itemsKey);
            checkResult.setData(entity);
        }
        return checkResult;
    }

    private String getFinalErrcode(String invoiceDate, String errcode) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            java.util.Date parseDay = simpleDateFormat.parse(invoiceDate);
            java.util.Date today = new java.util.Date();
            String todayStr = simpleDateFormat.format(today);
            java.util.Date nowDay = simpleDateFormat.parse(todayStr);
            if ("0009".equals(errcode) && parseDay.compareTo(nowDay) == 0) {
                return "1014";
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return errcode;
    }

    private boolean checkCache(CheckParam param1, JSONObject invoiceInfo) {
        boolean isElectric;
        String checkCode = invoiceInfo.getString("checkCode");
        java.util.Date invoiceDate = invoiceInfo.getDate("invoiceDate");
        BigDecimal amount = BigDecimal.ZERO;
        boolean isUsedCar = InputInvoiceTypeEnum.USEDCAR_INVOICE.getCode().equals(param1.getInvoiceType());
        boolean bl = isElectric = InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getCode().equals(param1.getInvoiceType()) || InputInvoiceTypeEnum.ELECTRIC_SPECIAL.getCode().equals(param1.getInvoiceType()) || InputInvoiceTypeEnum.AIR_ELE_INVOICE.getCode().equals(param1.getInvoiceType());
        if (InputInvoiceTypeEnum.TRAIN_ELE_INVOICE.getCode().equals(param1.getInvoiceType())) {
            amount = invoiceInfo.getBigDecimal("fare");
        } else if (isUsedCar || isElectric) {
            amount = invoiceInfo.getBigDecimal("totalAmount");
            if (amount == null) {
                amount = invoiceInfo.getBigDecimal("carPrice");
            }
        } else {
            amount = invoiceInfo.getBigDecimal("invoiceAmount");
        }
        CheckParam param2 = new CheckParam(param1.getInvoiceCode(), param1.getInvoiceNo(), param1.getInvoiceType(), invoiceDate, amount, checkCode, null);
        return this.compareParam(param1, param2);
    }
}

