/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.checknew.impl;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.StringUtils;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.invoice.checknew.CheckService;
import kd.imc.rim.common.invoice.checknew.model.CheckParam;
import kd.imc.rim.common.invoice.checknew.model.CheckResult;
import kd.imc.rim.common.invoice.model.ConvertFieldUtil;
import kd.imc.rim.common.utils.ImcConfigUtil;
import kd.imc.rim.common.utils.LqConvertUtil;
import kd.imc.rim.common.utils.TenantUtils;
import kd.imc.rim.file.utils.BigDecimalUtil;
import kd.imc.rim.file.utils.CompressHelper;

public class LqCheckService
implements CheckService {
    private static Log logger = LogFactory.getLog(LqCheckService.class);

    @Override
    public CheckResult checkInvoice(CheckParam checkParam) {
        CheckResult finalResult;
        block14: {
            finalResult = new CheckResult();
            finalResult.setLeqi(true);
            Map<String, Object> extMap = checkParam.getExtMap();
            String taxNo = (String)extMap.get("taxNo");
            if (StringUtils.isEmpty((String)taxNo)) {
                long orgId = RequestContext.get().getOrgId();
                taxNo = TenantUtils.getTaxNoByOrgId(orgId);
            }
            if (StringUtils.isEmpty((String)taxNo)) {
                finalResult.setErrcode("3301");
                finalResult.setDescription(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6240\u5728\u7684\u7ec4\u7ec7\u672a\u914d\u7f6e\u7a0e\u53f7,\u8bf7\u5728\u53d1\u7968\u4e91-\u57fa\u7840\u8d44\u6599-\u4f01\u4e1a\u7ba1\u7406\u4e2d\u914d\u7f6e", (String)"LqCheckService_0", (String)"imc-rim-common", (Object[])new Object[0]));
                return finalResult;
            }
            JSONObject lqCheckParam = this.convertParam(taxNo, checkParam);
            String checkCode = checkParam.getCheckCode();
            if (StringUtils.isNotEmpty((String)checkCode) && checkCode.length() > 6) {
                checkParam.setCheckCode(checkCode.substring(checkCode.length() - 6));
            }
            boolean cache = true;
            String forceCheck = ImcConfigUtil.getValue("rim_recog_check", "force_check", "0");
            logger.info("\u5f3a\u5236\u67e5\u9a8c\u914d\u7f6e\u9879\u662f\u5426\u6253\u5f00\uff1a{}", (Object)forceCheck);
            JSONObject result = this.getReultFormDb(checkParam, "LqCheckService");
            if (result == null) {
                cache = false;
                result = (JSONObject)DispatchServiceHelper.invokeBizService((String)"imc", (String)"bdm", (String)"CheckApiService", (String)"send", (Object[])new Object[]{lqCheckParam});
            }
            logger.info("\u4e50\u4f01\u67e5\u9a8c\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\uff1a" + result);
            if (result != null) {
                try {
                    finalResult.setErrcode(result.getString("errcode"));
                    JSONObject data = result.getJSONObject("data");
                    if (data == null) {
                        finalResult.setDescription(String.format(ResManager.loadKDString((String)"[\u4e50\u4f01\u901a\u9053] \u67e5\u9a8c\u5931\u8d25%1$s", (String)"AwsCheckService_2", (String)"imc-rim-common", (Object[])new Object[0]), result.getString("description")));
                        return finalResult;
                    }
                    String code = data.getString("returncode");
                    if ("00".equals(code)) {
                        String cyjg = data.getString("cyjgxx");
                        if (StringUtils.isNotEmpty((String)cyjg)) {
                            JSONObject cyjgObj = JSONObject.parseObject((String)CompressHelper.decodeBase64AndGZip((String)cyjg));
                            logger.info("\u4e50\u4f01\u67e5\u9a8c\u89e3\u5bc6\u7ed3\u679c\uff1a{}", (Object)cyjgObj);
                            this.getLqFpzt(lqCheckParam, cyjgObj);
                            ConvertFieldUtil.mixLqPartField(cyjgObj, checkParam.getInvoiceType());
                            if (cache && !this.checkCache(checkParam, cyjgObj)) {
                                finalResult.setErrcode("1005");
                                finalResult.setDescription(ResManager.loadKDString((String)"\u53d1\u7968\u4e0d\u89c4\u8303\uff0c\u8bf7\u68c0\u67e5\u5fc5\u586b\u5b57\u6bb5\u662f\u5426\u6b63\u786e", (String)"AwsCheckService_1", (String)"imc-rim-common", (Object[])new Object[0]));
                                return finalResult;
                            }
                            if (!cache) {
                                this.saveReultToDb(checkParam, result, "LqCheckService");
                            }
                            String itemsKey = "hwxx";
                            Object entity = ConvertFieldUtil.convertCheckEntityByInvoiceType(checkParam.getInvoiceType(), cyjgObj, itemsKey);
                            finalResult.setDescription(data.getString("returnmsg"));
                            finalResult.setData(entity);
                            return finalResult;
                        }
                        break block14;
                    }
                    if ("01".equals(code) || "02".equals(code) || "03".equals(code)) {
                        finalResult.setDescription(ResManager.loadKDString((String)"\u53d1\u7968\u4e0d\u89c4\u8303\uff0c\u8bf7\u68c0\u67e5\u5fc5\u586b\u5b57\u6bb5\u662f\u5426\u6b63\u786e", (String)"AwsCheckService_1", (String)"imc-rim-common", (Object[])new Object[0]));
                        break block14;
                    }
                    finalResult.setErrcode(code);
                    finalResult.setDescription(String.format(ResManager.loadKDString((String)"[\u4e50\u4f01\u901a\u9053] \u67e5\u9a8c\u5931\u8d25%1$s", (String)"AwsCheckService_2", (String)"imc-rim-common", (Object[])new Object[0]), result.getString("description")));
                }
                catch (Exception e) {
                    logger.info("\u4e50\u4f01\u67e5\u9a8c\u5931\u8d25\uff1a{}", (Object)e);
                }
            } else {
                finalResult.setErrcode("9999");
                finalResult.setDescription(String.format(ResManager.loadKDString((String)"\u67e5\u9a8c\u5931\u8d25%1$s", (String)"AwsCheckService_0", (String)"imc-rim-common", (Object[])new Object[0]), "null"));
            }
        }
        return finalResult;
    }

    private void getLqFpzt(JSONObject lqCheckParam, JSONObject cyjgObj) {
        cyjgObj.put("invoiceStatus", (Object)"0");
        try {
            JSONObject data;
            lqCheckParam.put("api_type", (Object)"FPZTXXCX");
            JSONObject useResult = LqConvertUtil.invokeService(lqCheckParam);
            if (ResultContant.isSuccess(useResult).booleanValue() && (data = useResult.getJSONObject("data")) != null) {
                cyjgObj.put("invoiceStatus", (Object)LqConvertUtil.getInvoiceStatus(data.getString("fpzt"), data.getString("hzsdbs")));
            }
        }
        catch (Exception e) {
            logger.info("\u4e50\u4f01\u53d1\u7968\u7528\u9014\u63a5\u53e3\u51fa\u9519\uff1a", (Object)e);
        }
    }

    private JSONObject convertParam(String taxNo, CheckParam checkParam) {
        String lqEtaxInvoiceType;
        JSONObject lqCheckParam = new JSONObject();
        String etaxInvoiceNo = checkParam.getEtaxInvoiceNo();
        String lqInvoiceType = InputInvoiceTypeEnum.getLqInvoiceType(checkParam.getInvoiceType());
        if (StringUtils.isNotEmpty((String)etaxInvoiceNo) && StringUtils.isNotEmpty((String)(lqEtaxInvoiceType = InputInvoiceTypeEnum.getLqEtaxInvoiceType(checkParam.getInvoiceType())))) {
            lqInvoiceType = lqEtaxInvoiceType;
        }
        lqCheckParam.put("fplx", (Object)lqInvoiceType);
        lqCheckParam.put("fpdm", (Object)checkParam.getInvoiceCode());
        lqCheckParam.put("fphm", (Object)checkParam.getInvoiceNo());
        lqCheckParam.put("jym", (Object)checkParam.getCheckCode());
        if (checkParam.getInvoiceNo() != null && checkParam.getInvoiceNo().length() == 20) {
            lqCheckParam.put("kpje", (Object)checkParam.getTotalAmount());
        } else {
            lqCheckParam.put("kpje", (Object)checkParam.getInvoiceMoney());
        }
        lqCheckParam.put("kprq", (Object)checkParam.getInvoiceDate());
        lqCheckParam.put("nsrsbh", (Object)taxNo);
        return lqCheckParam;
    }

    private boolean checkCache(CheckParam param1, JSONObject invoiceInfo) {
        String invoiceDate = invoiceInfo.getString("kprq");
        String kprq = invoiceDate.substring(0, 10);
        BigDecimal amount = BigDecimal.ZERO;
        String checkCode = param1.getCheckCode();
        boolean isUsedCar = InputInvoiceTypeEnum.USEDCAR_INVOICE.getCode().equals(param1.getInvoiceType());
        boolean isElectric = InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getCode().equals(param1.getInvoiceType()) || InputInvoiceTypeEnum.ELECTRIC_SPECIAL.getCode().equals(param1.getInvoiceType()) || InputInvoiceTypeEnum.TRAIN_ELE_INVOICE.getCode().equals(param1.getInvoiceType()) || InputInvoiceTypeEnum.AIR_ELE_INVOICE.getCode().equals(param1.getInvoiceType());
        boolean isZzs = InputInvoiceTypeEnum.SPECIAL_ELECTRON.getCode().equals(param1.getInvoiceType()) || InputInvoiceTypeEnum.SPECIAL_PAPER.getCode().equals(param1.getInvoiceType()) || InputInvoiceTypeEnum.ORDINARY_PAPER.getCode().equals(param1.getInvoiceType()) || InputInvoiceTypeEnum.ORDINARY_ELECTRON.getCode().equals(param1.getInvoiceType()) || InputInvoiceTypeEnum.ORDINARY_ROLL.getCode().equals(param1.getInvoiceType()) || InputInvoiceTypeEnum.TOLL_ELECTRON.getCode().equals(param1.getInvoiceType());
        boolean isCar = InputInvoiceTypeEnum.MOTOR_INVOICE.getCode().equals(param1.getInvoiceType());
        if (isUsedCar) {
            amount = BigDecimalUtil.transDecimal((Object)invoiceInfo.get((Object)"cjhj"));
        }
        if (isElectric) {
            amount = BigDecimalUtil.transDecimal((Object)invoiceInfo.get((Object)"jshj"));
        }
        if (isZzs && BigDecimal.ZERO.compareTo(amount = BigDecimalUtil.transDecimal((Object)invoiceInfo.get((Object)"hjje"))) == 0) {
            amount = BigDecimalUtil.transDecimal((Object)invoiceInfo.get((Object)"je"));
        }
        if (isCar) {
            amount = BigDecimalUtil.transDecimal((Object)invoiceInfo.get((Object)"cjfy"));
        }
        CheckParam param2 = new CheckParam(param1.getInvoiceCode(), param1.getInvoiceNo(), param1.getInvoiceType(), kprq, amount, checkCode, null);
        return this.compareParam(param1, param2);
    }

    @Override
    public JSONObject getReultFormDb(CheckParam checkParam, String checkType) {
        return CheckService.super.getReultFormDb(checkParam, checkType);
    }

    @Override
    public void saveReultToDb(CheckParam checkParam, JSONObject result, String checkType) {
        CheckService.super.saveReultToDb(checkParam, result, checkType);
    }

    @Override
    public boolean compareParam(CheckParam checkParam, CheckParam checkResult) {
        return CheckService.super.compareParam(checkParam, checkResult);
    }
}

