/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.collector;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.MulComboProp;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.rim.common.constant.AttachConstant;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.VerifyConstant;
import kd.imc.rim.common.datagrid.Column;
import kd.imc.rim.common.helper.RecognitionCheckHelper;
import kd.imc.rim.common.invoice.fpzs.ExpenseRelationService;
import kd.imc.rim.common.invoice.query.convert.InvoiceConvertService;
import kd.imc.rim.common.invoice.verify.VerifyService;
import kd.imc.rim.common.invoice.verify.VerifyStatisticsService;
import kd.imc.rim.common.invoice.verify.VerifyUtil;
import kd.imc.rim.common.invoice.verify.dto.VerifyResultDto;
import kd.imc.rim.common.service.RecognitionCheckService;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.common.utils.CurrencyUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.InvoiceConfigUtils;
import kd.imc.rim.common.utils.InvoiceConvertUtils;
import kd.imc.rim.common.utils.MetadataUtil;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.common.utils.UUID;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.compress.utils.Lists;

public class InvoiceCollectPluginService {
    private static Log logger = LogFactory.getLog(InvoiceCollectPluginService.class);
    private AbstractFormPlugin plugin;
    private static Map<String, ValueMapItem> imgMap = null;
    private static String CACHE_INVOICE_DATA = "collect_invoice_cache";
    private static String SUCCESS_SIGN_INVOICE = "success_sign_invoice";
    private static String FAIL_SIGN_INVOICE = "fail_sign_invoice";
    private static String CACHE_SALER_LIST = "salerlist_cache";
    private static final String format = "###,##0.00";
    private static String CACHE_INV_SIGN_SEQ_DATA = "collect_inv_sign_seq_cache";
    private static String CACHE_EXPENSE_MAX_SEQ_DATA = "collect_expense_max_seq_cache";
    private static String CACHE_INVOICE_VERIFY_DATA = "collect_invoice_verify_cache";
    private static String CACHE_INVOICE_SEQ_DATA = "collect_invoice_seq_cache";
    public static final Long typeofsalerlist = AttachConstant.ATTACH_LIST_CATEGORY_ID;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JSONObject cacheInvoiceList(String pageId, Map<String, Object> customParam, List<Long> invoiceIds, List<Long> uncheckInvoiceIds, JSONArray invoiceArray, Boolean verifyInsertFlag, Boolean saleListNumFlag) {
        Throwable throwable = null;
        try (DLock lock = DLock.create((String)("showSelectInvoice" + pageId), (String)ResManager.loadKDString((String)"\u91c7\u96c6\u5217\u8868\u5237\u65b0", (String)"InvoiceCollectPluginService_0", (String)"imc-rim-common", (Object[])new Object[0]));){
            int times = 0;
            while (times < 30) {
                JSONObject jSONObject;
                if (!lock.tryLock(500L)) continue;
                try {
                    String serialNo;
                    String serialNo2;
                    JSONObject dataJson = InvoiceCollectPluginService.getInvoiceDataCache(pageId);
                    logger.info("\u91c7\u96c6\u7b7e\u6536\u52a0\u8f7d\u53d1\u7968\uff1a{}\u5df2\u7ecf\u5b58\u5728{}\u4e2a", (Object)pageId, (Object)dataJson.size());
                    if (!CollectionUtils.isEmpty(invoiceIds) || !CollectionUtils.isEmpty(uncheckInvoiceIds)) {
                        JSONArray list = VerifyUtil.verifyByMainIds(customParam, invoiceIds, uncheckInvoiceIds, true);
                        long start = System.currentTimeMillis();
                        for (int i = 0; i < list.size(); ++i) {
                            List<String> expenseNums;
                            JSONObject invoice = list.getJSONObject(i);
                            InvoiceCollectPluginService.countSuccessAndFail(pageId, invoice);
                            logger.info("\u7b2c{}\u5f20\u53d1\u7968\u8bc6\u522b\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)i, (Object)invoice);
                            serialNo2 = invoice.getString("serialNo");
                            invoice.put("invoiceType", (Object)InputInvoiceTypeEnum.getInvoiceTypeByAwsType(invoice.getString("invoiceType")));
                            String resourcePlugin = MapUtils.getString(customParam, (Object)"resourcePlugin");
                            if (!"sign_by_expense".equals(resourcePlugin) && !CollectionUtils.isEmpty(expenseNums = InvoiceCollectPluginService.findExpenseNums(invoice))) {
                                invoice.put("expenseNum", (Object)String.join((CharSequence)",", expenseNums));
                            }
                            dataJson.put(serialNo2, (Object)invoice);
                        }
                        logger.info("\u8ba1\u7b97\u53d1\u7968\u662f\u5426\u7b7e\u6536\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
                        InvoiceCollectPluginService.saveVerifyResult(list, customParam);
                    }
                    Map<String, List<String>> existsSaleList = InvoiceCollectPluginService.getExistsSaleList(dataJson, pageId);
                    if (null != invoiceArray && invoiceArray.size() > 0) {
                        int arraySize = invoiceArray.size();
                        for (int invoiceIndex = 0; invoiceIndex < arraySize; ++invoiceIndex) {
                            JSONObject invoiceJson = invoiceArray.getJSONObject(invoiceIndex);
                            String attachUrl = invoiceJson.getString("attach_url");
                            if (StringUtils.isNotEmpty((CharSequence)attachUrl)) {
                                invoiceJson.put("invoiceType", (Object)typeofsalerlist);
                                String no = invoiceJson.getString("invoiceCode") + "_" + invoiceJson.getString("invoiceNo");
                                List<String> saleList = existsSaleList.get(no);
                                serialNo = invoiceJson.getString("serialNo");
                                if (saleList == null) {
                                    saleList = new ArrayList<String>(8);
                                    saleList.add(serialNo);
                                } else if (!saleList.contains(serialNo)) {
                                    saleList.add(serialNo);
                                }
                                existsSaleList.put(no, saleList);
                            } else {
                                invoiceJson.put("errorLevel", (Object)"0");
                                if (StringUtils.isBlank((CharSequence)invoiceJson.getString("validateMessage_html"))) {
                                    invoiceJson.put("validateMessage_html", (Object)VerifyConstant.getForbidHtml());
                                    ArrayList<VerifyResultDto> resultList = new ArrayList<VerifyResultDto>(2);
                                    VerifyResultDto dto = new VerifyResultDto();
                                    String msg = ResManager.loadKDString((String)"\u53d1\u7968\u5fc5\u8981\u5b57\u6bb5\u7f3a\u5931\uff0c\u8bf7\u7f16\u8f91\u8865\u5168", (String)"InvoiceCollectPluginService_3", (String)"imc-rim-common", (Object[])new Object[0]);
                                    if (StringUtils.isNotBlank((CharSequence)invoiceJson.getString("errorMsg"))) {
                                        msg = invoiceJson.getString("errorMsg");
                                        invoiceJson.put("validateMessage_html", (Object)VerifyConstant.getForbidHtml(msg));
                                    }
                                    dto.setName(msg);
                                    dto.setConfig("0");
                                    dto.setMsg(msg);
                                    resultList.add(dto);
                                    invoiceJson.put("validateMessage", (Object)VerifyService.getResultMsg(resultList));
                                    invoiceJson.put("verifyResult", resultList);
                                }
                                String awsType = InputInvoiceTypeEnum.getAwsType(invoiceJson.getLong("invoiceType"));
                                StringBuilder invoice_info = new StringBuilder();
                                if (StringUtils.isNotEmpty((CharSequence)awsType)) {
                                    invoice_info.append("ty_").append(awsType).append(',');
                                }
                                if (InvoiceConvertUtils.isVatInvoiceType(invoiceJson.getLong("invoiceType"))) {
                                    invoice_info.append("ch_3").append(',');
                                }
                                if (StringUtils.isEmpty((CharSequence)invoiceJson.getString("serialNo"))) {
                                    invoiceJson.put("serialNo", (Object)UUID.randomUUIDZero());
                                }
                                invoiceJson.put("invoice_info", (Object)invoice_info);
                            }
                            invoiceJson.put("isStorage", (Object)"0");
                            dataJson.put(invoiceJson.getString("serialNo"), (Object)invoiceJson);
                        }
                        InvoiceCollectPluginService.cacheInvoiceSeqRelation(invoiceArray);
                    }
                    List<Map<String, Object>> orderedSerialNo = InvoiceCollectPluginService.getOrderedInvoiceSeqRelation();
                    JSONObject orderedDataJson = new JSONObject(true);
                    if (!CollectionUtils.isEmpty(orderedSerialNo)) {
                        for (Map<String, Object> seqMap : orderedSerialNo) {
                            if (CollectionUtils.isEmpty(seqMap) || StringUtils.isEmpty((CharSequence)(serialNo2 = String.valueOf(seqMap.get("serialNo")))) || ObjectUtils.isEmpty((Object)dataJson.get((Object)serialNo2))) continue;
                            JSONObject orderedInvoice = (JSONObject)dataJson.get((Object)serialNo2);
                            orderedInvoice.put("uploadSeq", seqMap.get("seq"));
                            orderedDataJson.put(serialNo2, (Object)orderedInvoice);
                        }
                    }
                    logger.info("\u91c7\u96c6\u7b7e\u6536\u52a0\u8f7d\u53d1\u7968\uff1a{},{},{}", new Object[]{pageId, orderedDataJson.size(), orderedDataJson.keySet()});
                    Iterator it = orderedDataJson.keySet().iterator();
                    String verifySaveFlag = RimConfigUtils.getConfig("verify_save");
                    boolean checkFlag = "0".equals(verifySaveFlag);
                    HashMap verifyMap = Maps.newHashMap();
                    while (it.hasNext()) {
                        serialNo = (String)it.next();
                        JSONObject invoice = orderedDataJson.getJSONObject(serialNo);
                        String errorLevel = invoice.getString("errorLevel");
                        String invoiceType = invoice.getString("invoiceType");
                        if (!checkFlag || "0".equals(errorLevel)) continue;
                        StringBuilder sbSerial = new StringBuilder(serialNo);
                        StringBuilder savedValue = (StringBuilder)verifyMap.get(invoiceType);
                        if (savedValue != null) {
                            verifyMap.put(invoiceType, savedValue.append(',').append(serialNo));
                            continue;
                        }
                        verifyMap.put(invoiceType, sbSerial);
                    }
                    if (!verifyMap.isEmpty()) {
                        boolean needUserRelation = !"0".equals(customParam.get("needUserRelation") + "");
                        VerifyUtil.updateBatchDataStatus(verifyMap, orderedDataJson, needUserRelation);
                    }
                    JSONObject finalResult = orderedDataJson;
                    if (saleListNumFlag.booleanValue()) {
                        finalResult = InvoiceCollectPluginService.getFinalResult(orderedDataJson, existsSaleList);
                    }
                    InvoiceCollectPluginService.setCacheSaleList(pageId, existsSaleList);
                    InvoiceCollectPluginService.setInvoiceDataCache(pageId, SerializationUtils.toJsonString((Object)finalResult));
                    jSONObject = orderedDataJson;
                }
                catch (Throwable throwable2) {
                    try {
                        lock.unlock();
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        throw throwable4;
                        return null;
                    }
                }
                lock.unlock();
                return jSONObject;
            }
        }
    }

    private static Map<String, List<String>> getExistsSaleList(JSONObject dataJson, String pageId) {
        PageCache page = new PageCache(pageId);
        Map<String, List<String>> attachMap = new HashMap<String, List<String>>(8);
        if (dataJson != null) {
            String cache = page.get(CACHE_SALER_LIST);
            if (!StringUtils.isEmpty((CharSequence)cache)) {
                attachMap = (Map)SerializationUtils.fromJsonString((String)cache, attachMap.getClass());
            }
            for (Map.Entry entry : dataJson.entrySet()) {
                String serialNo = (String)entry.getKey();
                JSONObject valueObj = dataJson.getJSONObject(serialNo);
                if (!typeofsalerlist.equals(valueObj.getLong("invoiceType"))) continue;
                String no = valueObj.getString("invoiceCode") + "_" + valueObj.getString("invoiceNo");
                List<String> list = attachMap.get(no);
                if (list == null) {
                    list = new ArrayList<String>(8);
                    list.add(serialNo);
                } else if (!list.contains(serialNo)) {
                    list.add(serialNo);
                }
                attachMap.put(no, list);
            }
        }
        if (CollectionUtils.isEmpty(attachMap)) {
            page.remove(CACHE_SALER_LIST);
        }
        return attachMap;
    }

    public static void setCacheSaleList(String pageId, Map<String, List<String>> attachMap) {
        if (CollectionUtils.isEmpty(attachMap)) {
            new PageCache(pageId).remove(CACHE_SALER_LIST);
        } else {
            new PageCache(pageId).put(CACHE_SALER_LIST, SerializationUtils.toJsonString(attachMap));
        }
    }

    public static Map<String, List<String>> getCacheSaleList(String pageId) {
        PageCache page = new PageCache(pageId);
        HashMap<String, List<String>> attachMap = new HashMap<String, List<String>>(8);
        String cache = page.get(CACHE_SALER_LIST);
        if (!StringUtils.isEmpty((CharSequence)cache)) {
            return (Map)SerializationUtils.fromJsonString((String)cache, attachMap.getClass());
        }
        return attachMap;
    }

    private static JSONObject getFinalResult(JSONObject orderedDataJson, Map<String, List<String>> existsSaleList) {
        JSONObject result = new JSONObject(true);
        String url = RimConfigUtils.getConfig("rim_recog_check", "salelistposturl");
        Map<String, List<Map.Entry>> collect = orderedDataJson.entrySet().stream().filter(f -> {
            JSONObject valueObj = (JSONObject)f.getValue();
            return typeofsalerlist.equals(valueObj.getLong("invoiceType"));
        }).collect(Collectors.groupingBy(item -> {
            JSONObject valueObj = (JSONObject)item.getValue();
            return valueObj.getString("invoiceCode") + "_" + valueObj.getString("invoiceNo");
        }));
        orderedDataJson.entrySet().stream().forEach(f -> {
            JSONObject valueObj = (JSONObject)f.getValue();
            if (!typeofsalerlist.equals(valueObj.getLong("invoiceType"))) {
                result.put((String)f.getKey(), (Object)valueObj);
            }
        });
        for (Map.Entry<String, List<Map.Entry>> entry : collect.entrySet()) {
            List<Map.Entry> valueList = entry.getValue();
            Map.Entry attachEntry = (Map.Entry)valueList.stream().max((i, j) -> {
                JSONObject valueObj = (JSONObject)i.getValue();
                JSONObject valueObj2 = (JSONObject)j.getValue();
                Integer bindNum = BigDecimalUtil.transDecimal(valueObj.get((Object)"bindNum")).intValue();
                return Integer.compare(bindNum, BigDecimalUtil.transDecimal(valueObj2.get((Object)"bindNum")).intValue());
            }).get();
            JSONObject maxValue = (JSONObject)attachEntry.getValue();
            String no = maxValue.getString("invoiceCode") + "_" + maxValue.getString("invoiceNo");
            List<String> list = existsSaleList.get(no);
            logger.info("existsSaleList:{},{}", existsSaleList);
            if (list != null && list.size() > 0) {
                maxValue.put("num", (Object)list.size());
            } else {
                maxValue.put("num", (Object)1);
            }
            result.put(maxValue.getString("serialNo"), (Object)maxValue);
        }
        InvoiceCollectPluginService.fixSaleListNumInfo(result, url);
        return result;
    }

    private static void saveVerifyResult(JSONArray invoices, Map<String, Object> param) {
        if (CollectionUtils.isEmpty((Collection)invoices)) {
            return;
        }
        VerifyStatisticsService.asyncSaveVerifyStatistics((JSONArray)invoices, (Long)BigDecimalUtil.transDecimal(param.get("orgId")).longValue(), (String)((String)param.get("userId")));
    }

    private static void fixSaleListNumInfo(JSONObject result, String url) {
        if (result.isEmpty()) {
            return;
        }
        List<Map.Entry> normalInvoiceList = result.entrySet().stream().filter(f -> {
            JSONObject valueObj = (JSONObject)f.getValue();
            return !typeofsalerlist.equals(valueObj.getLong("invoiceType")) && InvoiceConvertUtils.isSaleListInvoiceType(valueObj.getLong("invoiceType"));
        }).collect(Collectors.toList());
        ArrayList attachNoList = Lists.newArrayList();
        normalInvoiceList.forEach(f -> attachNoList.add(((JSONObject)f.getValue()).getString("invoiceCode") + "_" + ((JSONObject)f.getValue()).getString("invoiceNo")));
        QFilter attachNoFilter = new QFilter("attach_no", "in", (Object)attachNoList);
        DynamicObject[] attachCollect = BusinessDataServiceHelper.load((String)"rim_attach", (String)"id, attach_no, page_sum, page_no", (QFilter[])new QFilter[]{attachNoFilter});
        HashMap attachPageSumMap = Maps.newHashMap();
        for (DynamicObject obj : attachCollect) {
            if (attachPageSumMap.get(obj.getString("attach_no")) != null) continue;
            attachPageSumMap.put(obj.getString("attach_no"), obj.getInt("page_sum"));
        }
        Map<String, Integer> bindNumRelation = InvoiceCollectPluginService.getBindNumByAttachNos(attachNoList, url);
        for (Map.Entry normalEntry : normalInvoiceList) {
            Integer pageSum;
            JSONObject normalEntryValue = (JSONObject)normalEntry.getValue();
            String salelistSum = normalEntryValue.getString("salelistSum");
            if (StringUtils.isEmpty((CharSequence)salelistSum)) continue;
            String attachNo = normalEntryValue.getString("invoiceCode") + "_" + normalEntryValue.getString("invoiceNo");
            Integer n = pageSum = attachPageSumMap.get(attachNo) == null ? Integer.valueOf(0) : (Integer)attachPageSumMap.get(attachNo);
            if (pageSum != 0 && !String.valueOf(pageSum).equals(salelistSum)) {
                salelistSum = String.valueOf(pageSum);
            }
            for (Map.Entry entry : result.entrySet()) {
                JSONObject entryValue = (JSONObject)entry.getValue();
                if (!StringUtils.isNotEmpty((CharSequence)entryValue.getString("attach_no")) || !attachNo.equals(entryValue.getString("attach_no"))) continue;
                entryValue.put("salelistSum", (Object)salelistSum);
                if (bindNumRelation.get(attachNo) == null) {
                    entryValue.put("bindNum", (Object)0);
                    continue;
                }
                entryValue.put("bindNum", (Object)bindNumRelation.get(attachNo));
            }
        }
    }

    private static Map<String, Integer> getBindNumByAttachNos(List<String> attachNoList, String url) {
        if (attachNoList.size() == 0) {
            return Maps.newHashMap();
        }
        QFilter attachNoFilter = new QFilter("attach_no", "in", attachNoList);
        String attachFields = MetadataUtil.getFields((String)"rim_attach");
        DynamicObject[] attachCollect = BusinessDataServiceHelper.load((String)"rim_attach", (String)attachFields, (QFilter[])new QFilter[]{attachNoFilter});
        RecognitionCheckHelper recognitionCheckHelper = new RecognitionCheckHelper();
        if (attachCollect != null && attachCollect.length > 0) {
            if (StringUtils.isNotEmpty((CharSequence)url)) {
                Set collect = Arrays.stream(attachCollect).filter(f -> f.getInt("page_no") != 0).collect(Collectors.toSet());
                List<String> attachIds = collect.stream().map(m -> m.getString("id")).collect(Collectors.toList());
                return recognitionCheckHelper.filterBindAttach(attachIds);
            }
            List<String> attachIds = Arrays.stream(attachCollect).map(m -> m.getString("id")).collect(Collectors.toList());
            return recognitionCheckHelper.filterBindAttach(attachIds);
        }
        return Maps.newHashMap();
    }

    private static String getBindNumByAttachNo(String attachNo, String url) {
        QFilter attachNoFilter = new QFilter("attach_no", "=", (Object)attachNo);
        String attachFields = MetadataUtil.getFields((String)"rim_attach");
        DynamicObject[] attachCollect = BusinessDataServiceHelper.load((String)"rim_attach", (String)attachFields, (QFilter[])new QFilter[]{attachNoFilter});
        int bindNum = 0;
        RecognitionCheckHelper recognitionCheckHelper = new RecognitionCheckHelper();
        if (attachCollect != null && attachCollect.length > 0) {
            if (StringUtils.isNotEmpty((CharSequence)url)) {
                Set numSet = Arrays.stream(attachCollect).filter(f -> {
                    if (f.getInt("page_no") == 0) {
                        return false;
                    }
                    Long attachId = f.getLong("id");
                    boolean isBind = recognitionCheckHelper.checkBind(attachId);
                    return isBind;
                }).map(m -> m.getInt("page_no")).collect(Collectors.toSet());
                bindNum = numSet.size();
            } else {
                for (DynamicObject attachObject : attachCollect) {
                    Long attachId = attachObject.getLong("id");
                    boolean isBind = recognitionCheckHelper.checkBind(attachId);
                    if (!isBind) continue;
                    ++bindNum;
                }
            }
        }
        return String.valueOf(bindNum);
    }

    public static void cacheInvoiceSeqRelation(JSONArray invoiceArray) {
        if (invoiceArray == null || invoiceArray.size() == 0) {
            return;
        }
        String seqDataStr = CacheHelper.get(CACHE_INVOICE_SEQ_DATA);
        JSONObject seqData = JSONObject.parseObject((String)seqDataStr);
        if (seqData == null) {
            seqData = new JSONObject();
        }
        String uploadIndex = String.valueOf(System.currentTimeMillis());
        for (int i = 0; i < invoiceArray.size(); ++i) {
            Long oldSeq;
            JSONObject invoice = invoiceArray.getJSONObject(i);
            String mainId = invoice.getString("mainId");
            Long uploadSeq = invoice.getLong("uploadSeq");
            String seqMapKey = invoice.getString("serialNo");
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)seqMapKey)) {
                seqMapKey = mainId;
            }
            if ((oldSeq = seqData.getLong(seqMapKey)) != null && oldSeq > 0L) continue;
            if (uploadSeq == null) {
                seqData.put(seqMapKey, (Object)RecognitionCheckService.getInvoiceSeq(uploadIndex, 0, i));
                continue;
            }
            seqData.put(seqMapKey, (Object)uploadSeq);
        }
        CacheHelper.put(CACHE_INVOICE_SEQ_DATA, seqData.toJSONString(), 600);
    }

    public static List<Map<String, Object>> getOrderedInvoiceSeqRelation() {
        String seqDataStr = CacheHelper.get(CACHE_INVOICE_SEQ_DATA);
        JSONObject invoiceSeq = JSONObject.parseObject((String)seqDataStr);
        ArrayList<Map<String, Object>> invoiceArray = new ArrayList<Map<String, Object>>(16);
        if (invoiceSeq != null) {
            for (Map.Entry obj : invoiceSeq.entrySet()) {
                HashMap<String, Object> invoiceSeqMap = new HashMap<String, Object>(2);
                invoiceSeqMap.put("serialNo", obj.getKey());
                invoiceSeqMap.put("seq", obj.getValue());
                invoiceArray.add(invoiceSeqMap);
            }
        }
        if (invoiceArray.size() > 0) {
            Collections.sort(invoiceArray, (o1, o2) -> {
                Long uploadSeq1 = BigDecimalUtil.transDecimal(o1.get("seq")).longValue();
                Long uploadSeq2 = BigDecimalUtil.transDecimal(o2.get("seq")).longValue();
                return uploadSeq1.compareTo(uploadSeq2);
            });
        }
        return invoiceArray;
    }

    private static List<String> findExpenseNums(JSONObject invoiceJson) {
        QFilter qFilters = new QFilter("serial_no", "=", (Object)invoiceJson.getString("serialNo"));
        ExpenseRelationService expenseRelationService = new ExpenseRelationService();
        DynamicObjectCollection relCollection = expenseRelationService.findByFilter("expense_num", qFilters);
        List<String> expenseNums = relCollection.stream().map(c -> c.getString("expense_num")).collect(Collectors.toList());
        return expenseNums;
    }

    public static void updateInvoiceGrid(AbstractFormPlugin plugin, JSONObject invoiceArray, Long type) {
        logger.info(invoiceArray.size() + "\u91c7\u96c6\u7b7e\u6536\u9884\u89c8\u53d1\u7968\uff1a" + invoiceArray);
        ArrayList<ArrayList<Column>> invoiceList = new ArrayList<ArrayList<Column>>(16);
        int i = 0;
        boolean firstFlag = true;
        List<Column> columnList = InvoiceCollectPluginService.getColumnListByInvoiceType(type);
        int width = 0;
        for (Map.Entry entry : invoiceArray.entrySet()) {
            JSONObject obj = (JSONObject)entry.getValue();
            Long invoiceType = obj.getLong("invoiceType");
            if (!invoiceType.equals(type)) continue;
            ++i;
            ArrayList<Column> data = new ArrayList<Column>(8);
            data.add(new Column("rowkey", "rowkey", null, obj.getString("serialNo")));
            for (Column column : columnList) {
                InvoiceCollectPluginService.updateColumn(column, data, obj, i);
                if (!firstFlag) continue;
                width += InvoiceCollectPluginService.getWidth(column.getStyle());
            }
            firstFlag = false;
            invoiceList.add(data);
        }
        String pageId = plugin.getView().getPageId();
        CustomControl customInvoiceControl = (CustomControl)plugin.getControl("custom_invoice");
        JSONObject customInvoiceMap = new JSONObject();
        customInvoiceMap.put("clomuns", columnList);
        customInvoiceMap.put("data", invoiceList);
        customInvoiceMap.put("tableId", (Object)(pageId + "_customInvoice_" + type));
        customInvoiceMap.put("operate", (Object)"loadData");
        customInvoiceMap.put("time", (Object)System.currentTimeMillis());
        customInvoiceControl.setData((Object)customInvoiceMap);
    }

    private static int getWidth(String style) {
        int pxIndex;
        int widthIndex;
        if (StringUtils.isNotEmpty((CharSequence)style) && (widthIndex = style.indexOf("width:")) > 0 && (pxIndex = style.indexOf("px", widthIndex)) > 0) {
            String whidthStr = style.substring(widthIndex + 6, pxIndex);
            return BigDecimalUtil.transDecimal(whidthStr).intValue();
        }
        return 100;
    }

    private static List<Column> ORDINARY_ELECTRON_COLUMN_LIST() {
        ArrayList<Column> ORDINARY_ELECTRON_COLUMN_LIST = new ArrayList<Column>(16);
        ORDINARY_ELECTRON_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u64cd\u4f5c\u5217", (String)"InvoiceCollectPluginService_5", (String)"imc-rim-common", (Object[])new Object[0]), "operate", "text-align:left;width:70px;"));
        ORDINARY_ELECTRON_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u63d0\u793a", (String)"InvoiceCollectPluginService_6", (String)"imc-rim-common", (Object[])new Object[0]), "status", "text-align:left;width:50px;"));
        ORDINARY_ELECTRON_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u53d1\u7968\u4fe1\u606f", (String)"InvoiceCollectPluginService_7", (String)"imc-rim-common", (Object[])new Object[0]), "invoice_info", "text-align:left;width:230px;"));
        ORDINARY_ELECTRON_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801", (String)"InvoiceCollectPluginService_8", (String)"imc-rim-common", (Object[])new Object[0]), "invoiceCode", "text-align:left;width:70px;"));
        ORDINARY_ELECTRON_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801", (String)"InvoiceCollectPluginService_9", (String)"imc-rim-common", (Object[])new Object[0]), "invoiceNo", "text-align:left;width:70px;"));
        ORDINARY_ELECTRON_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u4ef7\u7a0e\u5408\u8ba1", (String)"InvoiceCollectPluginService_10", (String)"imc-rim-common", (Object[])new Object[0]), "totalAmount", "text-align:left;width:70px;"));
        ORDINARY_ELECTRON_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u5f00\u7968\u65e5\u671f", (String)"InvoiceCollectPluginService_11", (String)"imc-rim-common", (Object[])new Object[0]), "invoiceDate", "text-align:left;width:70px;"));
        ORDINARY_ELECTRON_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u4e0d\u542b\u7a0e\u91d1\u989d", (String)"InvoiceCollectPluginService_12", (String)"imc-rim-common", (Object[])new Object[0]), "invoiceAmount", "text-align:left;width:70px;"));
        ORDINARY_ELECTRON_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u7a0e\u989d", (String)"InvoiceCollectPluginService_13", (String)"imc-rim-common", (Object[])new Object[0]), "totalTaxAmount", "text-align:left;width:70px;"));
        ORDINARY_ELECTRON_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u9500\u65b9\u540d\u79f0", (String)"InvoiceCollectPluginService_14", (String)"imc-rim-common", (Object[])new Object[0]), "salerName", "text-align:left;width:70px;"));
        ORDINARY_ELECTRON_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u9500\u65b9\u7eb3\u7a0e\u8bc6\u522b\u53f7", (String)"InvoiceCollectPluginService_15", (String)"imc-rim-common", (Object[])new Object[0]), "salerTaxNo", "text-align:left;width:70px;"));
        ORDINARY_ELECTRON_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u8d2d\u65b9\u540d\u79f0", (String)"InvoiceCollectPluginService_16", (String)"imc-rim-common", (Object[])new Object[0]), "buyerName", "text-align:left;width:70px;"));
        ORDINARY_ELECTRON_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u8d2d\u65b9\u7eb3\u7a0e\u8bc6\u522b\u53f7", (String)"InvoiceCollectPluginService_17", (String)"imc-rim-common", (Object[])new Object[0]), "buyerTaxNo", "text-align:left;width:70px;"));
        ORDINARY_ELECTRON_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e", (String)"InvoiceCollectPluginService_18", (String)"imc-rim-common", (Object[])new Object[0]), "expenseNum", "text-align:left;width:70px;"));
        ORDINARY_ELECTRON_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7", (String)"ListFieldNameSevice_26", (String)"imc-rim-common", (Object[])new Object[0]), "orgName", "text-align:left;width:150px;overflow:hidden;", 1));
        return ORDINARY_ELECTRON_COLUMN_LIST;
    }

    private static final List<Column> SPECIAL_ELECTRON_COLUMN_LIST() {
        ArrayList<Column> SPECIAL_ELECTRON_COLUMN_LIST = new ArrayList<Column>(16);
        SPECIAL_ELECTRON_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u64cd\u4f5c\u5217", (String)"InvoiceCollectPluginService_5", (String)"imc-rim-common", (Object[])new Object[0]), "operate", "text-align:left;width:70px;"));
        SPECIAL_ELECTRON_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u63d0\u793a", (String)"InvoiceCollectPluginService_6", (String)"imc-rim-common", (Object[])new Object[0]), "status", "text-align:left;width:50px;"));
        SPECIAL_ELECTRON_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u53d1\u7968\u4fe1\u606f", (String)"InvoiceCollectPluginService_7", (String)"imc-rim-common", (Object[])new Object[0]), "invoice_info", "text-align:left;width:230px;"));
        SPECIAL_ELECTRON_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801", (String)"InvoiceCollectPluginService_8", (String)"imc-rim-common", (Object[])new Object[0]), "invoiceCode", "text-align:left;width:70px;"));
        SPECIAL_ELECTRON_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801", (String)"InvoiceCollectPluginService_9", (String)"imc-rim-common", (Object[])new Object[0]), "invoiceNo", "text-align:left;width:70px;"));
        SPECIAL_ELECTRON_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u4ef7\u7a0e\u5408\u8ba1", (String)"InvoiceCollectPluginService_10", (String)"imc-rim-common", (Object[])new Object[0]), "totalAmount", "text-align:left;width:70px;"));
        SPECIAL_ELECTRON_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u5f00\u7968\u65e5\u671f", (String)"InvoiceCollectPluginService_11", (String)"imc-rim-common", (Object[])new Object[0]), "invoiceDate", "text-align:left;width:70px;"));
        SPECIAL_ELECTRON_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u4e0d\u542b\u7a0e\u91d1\u989d", (String)"InvoiceCollectPluginService_12", (String)"imc-rim-common", (Object[])new Object[0]), "invoiceAmount", "text-align:left;width:70px;"));
        SPECIAL_ELECTRON_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u7a0e\u989d", (String)"InvoiceCollectPluginService_13", (String)"imc-rim-common", (Object[])new Object[0]), "totalTaxAmount", "text-align:left;width:70px;"));
        SPECIAL_ELECTRON_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u9500\u65b9\u540d\u79f0", (String)"InvoiceCollectPluginService_14", (String)"imc-rim-common", (Object[])new Object[0]), "salerName", "text-align:left;width:70px;"));
        SPECIAL_ELECTRON_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u9500\u65b9\u7eb3\u7a0e\u8bc6\u522b\u53f7", (String)"InvoiceCollectPluginService_15", (String)"imc-rim-common", (Object[])new Object[0]), "salerTaxNo", "text-align:left;width:70px;"));
        SPECIAL_ELECTRON_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u8d2d\u65b9\u540d\u79f0", (String)"InvoiceCollectPluginService_16", (String)"imc-rim-common", (Object[])new Object[0]), "buyerName", "text-align:left;width:70px;"));
        SPECIAL_ELECTRON_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u8d2d\u65b9\u7eb3\u7a0e\u8bc6\u522b\u53f7", (String)"InvoiceCollectPluginService_17", (String)"imc-rim-common", (Object[])new Object[0]), "buyerTaxNo", "text-align:left;width:70px;"));
        SPECIAL_ELECTRON_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e", (String)"InvoiceCollectPluginService_18", (String)"imc-rim-common", (Object[])new Object[0]), "expenseNum", "text-align:left;width:70px;"));
        SPECIAL_ELECTRON_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7", (String)"ListFieldNameSevice_26", (String)"imc-rim-common", (Object[])new Object[0]), "orgName", "text-align:left;width:150px;overflow:hidden;", 1));
        return SPECIAL_ELECTRON_COLUMN_LIST;
    }

    private static final List<Column> ORDINARY_PAPER_COLUMN_LIST() {
        ArrayList<Column> ORDINARY_PAPER_COLUMN_LIST = new ArrayList<Column>(16);
        ORDINARY_PAPER_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u64cd\u4f5c\u5217", (String)"InvoiceCollectPluginService_5", (String)"imc-rim-common", (Object[])new Object[0]), "operate", "text-align:left;width:70px;"));
        ORDINARY_PAPER_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u63d0\u793a", (String)"InvoiceCollectPluginService_6", (String)"imc-rim-common", (Object[])new Object[0]), "status", "text-align:left;width:50px;"));
        if (InvoiceConfigUtils.showInvoiceInfo()) {
            ORDINARY_PAPER_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u53d1\u7968\u4fe1\u606f", (String)"InvoiceCollectPluginService_7", (String)"imc-rim-common", (Object[])new Object[0]), "invoice_info", "text-align:left;width:230px;"));
        }
        ORDINARY_PAPER_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801", (String)"InvoiceCollectPluginService_8", (String)"imc-rim-common", (Object[])new Object[0]), "invoiceCode", "text-align:left;width:70px;"));
        ORDINARY_PAPER_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801", (String)"InvoiceCollectPluginService_9", (String)"imc-rim-common", (Object[])new Object[0]), "invoiceNo", "text-align:left;width:70px;"));
        ORDINARY_PAPER_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u4ef7\u7a0e\u5408\u8ba1", (String)"InvoiceCollectPluginService_10", (String)"imc-rim-common", (Object[])new Object[0]), "totalAmount", "text-align:left;width:70px;"));
        ORDINARY_PAPER_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u5f00\u7968\u65e5\u671f", (String)"InvoiceCollectPluginService_11", (String)"imc-rim-common", (Object[])new Object[0]), "invoiceDate", "text-align:left;width:70px;"));
        ORDINARY_PAPER_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u4e0d\u542b\u7a0e\u91d1\u989d", (String)"InvoiceCollectPluginService_12", (String)"imc-rim-common", (Object[])new Object[0]), "invoiceAmount", "text-align:left;width:70px;"));
        ORDINARY_PAPER_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u7a0e\u989d", (String)"InvoiceCollectPluginService_13", (String)"imc-rim-common", (Object[])new Object[0]), "totalTaxAmount", "text-align:left;width:70px;"));
        ORDINARY_PAPER_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u9500\u65b9\u540d\u79f0", (String)"InvoiceCollectPluginService_14", (String)"imc-rim-common", (Object[])new Object[0]), "salerName", "text-align:left;width:70px;"));
        ORDINARY_PAPER_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u9500\u65b9\u7eb3\u7a0e\u8bc6\u522b\u53f7", (String)"InvoiceCollectPluginService_15", (String)"imc-rim-common", (Object[])new Object[0]), "salerTaxNo", "text-align:left;width:70px;"));
        ORDINARY_PAPER_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u8d2d\u65b9\u540d\u79f0", (String)"InvoiceCollectPluginService_16", (String)"imc-rim-common", (Object[])new Object[0]), "buyerName", "text-align:left;width:70px;"));
        ORDINARY_PAPER_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u8d2d\u65b9\u7eb3\u7a0e\u8bc6\u522b\u53f7", (String)"InvoiceCollectPluginService_17", (String)"imc-rim-common", (Object[])new Object[0]), "buyerTaxNo", "text-align:left;width:70px;"));
        ORDINARY_PAPER_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e", (String)"InvoiceCollectPluginService_18", (String)"imc-rim-common", (Object[])new Object[0]), "expenseNum", "text-align:left;width:70px;"));
        ORDINARY_PAPER_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7", (String)"ListFieldNameSevice_26", (String)"imc-rim-common", (Object[])new Object[0]), "orgName", "text-align:left;width:150px;overflow:hidden;", 1));
        return ORDINARY_PAPER_COLUMN_LIST;
    }

    private static final List<Column> SPECIAL_PAPER_COLUMN_LIST() {
        ArrayList<Column> SPECIAL_PAPER_COLUMN_LIST = new ArrayList<Column>(16);
        SPECIAL_PAPER_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u64cd\u4f5c\u5217", (String)"InvoiceCollectPluginService_5", (String)"imc-rim-common", (Object[])new Object[0]), "operate", "text-align:left;width:70px;"));
        SPECIAL_PAPER_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u63d0\u793a", (String)"InvoiceCollectPluginService_6", (String)"imc-rim-common", (Object[])new Object[0]), "status", "text-align:left;width:50px;"));
        if (InvoiceConfigUtils.showInvoiceInfo()) {
            SPECIAL_PAPER_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u53d1\u7968\u4fe1\u606f", (String)"InvoiceCollectPluginService_7", (String)"imc-rim-common", (Object[])new Object[0]), "invoice_info", "text-align:left;width:230px;"));
        }
        SPECIAL_PAPER_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801", (String)"InvoiceCollectPluginService_8", (String)"imc-rim-common", (Object[])new Object[0]), "invoiceCode", "text-align:left;width:70px;"));
        SPECIAL_PAPER_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801", (String)"InvoiceCollectPluginService_9", (String)"imc-rim-common", (Object[])new Object[0]), "invoiceNo", "text-align:left;width:70px;"));
        SPECIAL_PAPER_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u4ef7\u7a0e\u5408\u8ba1", (String)"InvoiceCollectPluginService_10", (String)"imc-rim-common", (Object[])new Object[0]), "totalAmount", "text-align:left;width:70px;"));
        SPECIAL_PAPER_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u5f00\u7968\u65e5\u671f", (String)"InvoiceCollectPluginService_11", (String)"imc-rim-common", (Object[])new Object[0]), "invoiceDate", "text-align:left;width:70px;"));
        SPECIAL_PAPER_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u4e0d\u542b\u7a0e\u91d1\u989d", (String)"InvoiceCollectPluginService_12", (String)"imc-rim-common", (Object[])new Object[0]), "invoiceAmount", "text-align:left;width:70px;"));
        SPECIAL_PAPER_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u7a0e\u989d", (String)"InvoiceCollectPluginService_13", (String)"imc-rim-common", (Object[])new Object[0]), "totalTaxAmount", "text-align:left;width:70px;"));
        SPECIAL_PAPER_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u9500\u65b9\u540d\u79f0", (String)"InvoiceCollectPluginService_14", (String)"imc-rim-common", (Object[])new Object[0]), "salerName", "text-align:left;width:70px;"));
        SPECIAL_PAPER_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u9500\u65b9\u7eb3\u7a0e\u8bc6\u522b\u53f7", (String)"InvoiceCollectPluginService_15", (String)"imc-rim-common", (Object[])new Object[0]), "salerTaxNo", "text-align:left;width:70px;"));
        SPECIAL_PAPER_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u8d2d\u65b9\u540d\u79f0", (String)"InvoiceCollectPluginService_16", (String)"imc-rim-common", (Object[])new Object[0]), "buyerName", "text-align:left;width:70px;"));
        SPECIAL_PAPER_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u8d2d\u65b9\u7eb3\u7a0e\u8bc6\u522b\u53f7", (String)"InvoiceCollectPluginService_17", (String)"imc-rim-common", (Object[])new Object[0]), "buyerTaxNo", "text-align:left;width:70px;"));
        SPECIAL_PAPER_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e", (String)"InvoiceCollectPluginService_18", (String)"imc-rim-common", (Object[])new Object[0]), "expenseNum", "text-align:left;width:70px;"));
        SPECIAL_PAPER_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7", (String)"ListFieldNameSevice_26", (String)"imc-rim-common", (Object[])new Object[0]), "orgName", "text-align:left;width:150px;overflow:hidden;", 1));
        return SPECIAL_PAPER_COLUMN_LIST;
    }

    private static final List<Column> ORDINARY_ROLL_COLUMN_LIST() {
        ArrayList<Column> ORDINARY_ROLL_COLUMN_LIST = new ArrayList<Column>(16);
        ORDINARY_ROLL_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u64cd\u4f5c\u5217", (String)"InvoiceCollectPluginService_5", (String)"imc-rim-common", (Object[])new Object[0]), "operate", "text-align:left;width:70px;"));
        ORDINARY_ROLL_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u63d0\u793a", (String)"InvoiceCollectPluginService_6", (String)"imc-rim-common", (Object[])new Object[0]), "status", "text-align:left;width:50px;"));
        if (InvoiceConfigUtils.showInvoiceInfo()) {
            ORDINARY_ROLL_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u53d1\u7968\u4fe1\u606f", (String)"InvoiceCollectPluginService_7", (String)"imc-rim-common", (Object[])new Object[0]), "invoice_info", "text-align:left;width:230px;"));
        }
        ORDINARY_ROLL_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801", (String)"InvoiceCollectPluginService_8", (String)"imc-rim-common", (Object[])new Object[0]), "invoiceCode", "text-align:left;width:70px;"));
        ORDINARY_ROLL_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801", (String)"InvoiceCollectPluginService_9", (String)"imc-rim-common", (Object[])new Object[0]), "invoiceNo", "text-align:left;width:70px;"));
        ORDINARY_ROLL_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u4ef7\u7a0e\u5408\u8ba1", (String)"InvoiceCollectPluginService_10", (String)"imc-rim-common", (Object[])new Object[0]), "totalAmount", "text-align:left;width:70px;"));
        ORDINARY_ROLL_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u5f00\u7968\u65e5\u671f", (String)"InvoiceCollectPluginService_11", (String)"imc-rim-common", (Object[])new Object[0]), "invoiceDate", "text-align:left;width:70px;"));
        ORDINARY_ROLL_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u4e0d\u542b\u7a0e\u91d1\u989d", (String)"InvoiceCollectPluginService_12", (String)"imc-rim-common", (Object[])new Object[0]), "invoiceAmount", "text-align:left;width:70px;"));
        ORDINARY_ROLL_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u7a0e\u989d", (String)"InvoiceCollectPluginService_13", (String)"imc-rim-common", (Object[])new Object[0]), "totalTaxAmount", "text-align:left;width:70px;"));
        ORDINARY_ROLL_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u9500\u65b9\u540d\u79f0", (String)"InvoiceCollectPluginService_14", (String)"imc-rim-common", (Object[])new Object[0]), "salerName", "text-align:left;width:70px;"));
        ORDINARY_ROLL_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u9500\u65b9\u7eb3\u7a0e\u8bc6\u522b\u53f7", (String)"InvoiceCollectPluginService_15", (String)"imc-rim-common", (Object[])new Object[0]), "salerTaxNo", "text-align:left;width:70px;"));
        ORDINARY_ROLL_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u8d2d\u65b9\u540d\u79f0", (String)"InvoiceCollectPluginService_16", (String)"imc-rim-common", (Object[])new Object[0]), "buyerName", "text-align:left;width:70px;"));
        ORDINARY_ROLL_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u8d2d\u65b9\u7eb3\u7a0e\u8bc6\u522b\u53f7", (String)"InvoiceCollectPluginService_17", (String)"imc-rim-common", (Object[])new Object[0]), "buyerTaxNo", "text-align:left;width:70px;"));
        ORDINARY_ROLL_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e", (String)"InvoiceCollectPluginService_18", (String)"imc-rim-common", (Object[])new Object[0]), "expenseNum", "text-align:left;width:70px;"));
        ORDINARY_ROLL_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7", (String)"ListFieldNameSevice_26", (String)"imc-rim-common", (Object[])new Object[0]), "orgName", "text-align:left;width:150px;overflow:hidden;", 1));
        return ORDINARY_ROLL_COLUMN_LIST;
    }

    private static final List<Column> GENERAL_PAPER_COLUMN_LIST() {
        ArrayList<Column> GENERAL_PAPER_COLUMN_LIST = new ArrayList<Column>(16);
        GENERAL_PAPER_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u64cd\u4f5c\u5217", (String)"InvoiceCollectPluginService_5", (String)"imc-rim-common", (Object[])new Object[0]), "operate", "text-align:left;width:70px;"));
        GENERAL_PAPER_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u63d0\u793a", (String)"InvoiceCollectPluginService_6", (String)"imc-rim-common", (Object[])new Object[0]), "status", "text-align:left;width:50px;"));
        if (InvoiceConfigUtils.showInvoiceInfo()) {
            GENERAL_PAPER_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u53d1\u7968\u4fe1\u606f", (String)"InvoiceCollectPluginService_7", (String)"imc-rim-common", (Object[])new Object[0]), "invoice_info", "text-align:left;width:230px;"));
        }
        GENERAL_PAPER_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801", (String)"InvoiceCollectPluginService_8", (String)"imc-rim-common", (Object[])new Object[0]), "invoiceCode", "text-align:left;width:70px;"));
        GENERAL_PAPER_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801", (String)"InvoiceCollectPluginService_9", (String)"imc-rim-common", (Object[])new Object[0]), "invoiceNo", "text-align:left;width:70px;"));
        GENERAL_PAPER_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u4ef7\u7a0e\u5408\u8ba1", (String)"InvoiceCollectPluginService_10", (String)"imc-rim-common", (Object[])new Object[0]), "totalAmount", "text-align:left;width:70px;"));
        GENERAL_PAPER_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u5f00\u7968\u65e5\u671f", (String)"InvoiceCollectPluginService_11", (String)"imc-rim-common", (Object[])new Object[0]), "invoiceDate", "text-align:left;width:70px;"));
        GENERAL_PAPER_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u9500\u65b9\u540d\u79f0", (String)"InvoiceCollectPluginService_14", (String)"imc-rim-common", (Object[])new Object[0]), "salerName", "text-align:left;width:70px;"));
        GENERAL_PAPER_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u9500\u65b9\u7eb3\u7a0e\u8bc6\u522b\u53f7", (String)"InvoiceCollectPluginService_15", (String)"imc-rim-common", (Object[])new Object[0]), "salerTaxNo", "text-align:left;width:70px;"));
        GENERAL_PAPER_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u8d2d\u65b9\u540d\u79f0", (String)"InvoiceCollectPluginService_16", (String)"imc-rim-common", (Object[])new Object[0]), "buyerName", "text-align:left;width:70px;"));
        GENERAL_PAPER_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u8d2d\u65b9\u7eb3\u7a0e\u8bc6\u522b\u53f7", (String)"InvoiceCollectPluginService_17", (String)"imc-rim-common", (Object[])new Object[0]), "buyerTaxNo", "text-align:left;width:70px;"));
        GENERAL_PAPER_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e", (String)"InvoiceCollectPluginService_18", (String)"imc-rim-common", (Object[])new Object[0]), "expenseNum", "text-align:left;width:70px;"));
        GENERAL_PAPER_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7", (String)"ListFieldNameSevice_26", (String)"imc-rim-common", (Object[])new Object[0]), "orgName", "text-align:left;width:150px;overflow:hidden;", 1));
        return GENERAL_PAPER_COLUMN_LIST;
    }

    private static final List<Column> GENERAL_ELECTRON_COLUMN_LIST() {
        ArrayList<Column> GENERAL_ELECTRON_COLUMN_LIST = new ArrayList<Column>(16);
        GENERAL_ELECTRON_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u64cd\u4f5c\u5217", (String)"InvoiceCollectPluginService_5", (String)"imc-rim-common", (Object[])new Object[0]), "operate", "text-align:left;width:70px;"));
        GENERAL_ELECTRON_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u63d0\u793a", (String)"InvoiceCollectPluginService_6", (String)"imc-rim-common", (Object[])new Object[0]), "status", "text-align:left;width:50px;"));
        if (InvoiceConfigUtils.showInvoiceInfo()) {
            GENERAL_ELECTRON_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u53d1\u7968\u4fe1\u606f", (String)"InvoiceCollectPluginService_7", (String)"imc-rim-common", (Object[])new Object[0]), "invoice_info", "text-align:left;width:230px;"));
        }
        GENERAL_ELECTRON_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801", (String)"InvoiceCollectPluginService_8", (String)"imc-rim-common", (Object[])new Object[0]), "invoiceCode", "text-align:left;width:70px;"));
        GENERAL_ELECTRON_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801", (String)"InvoiceCollectPluginService_9", (String)"imc-rim-common", (Object[])new Object[0]), "invoiceNo", "text-align:left;width:70px;"));
        GENERAL_ELECTRON_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u4ef7\u7a0e\u5408\u8ba1", (String)"InvoiceCollectPluginService_10", (String)"imc-rim-common", (Object[])new Object[0]), "totalAmount", "text-align:left;width:70px;"));
        GENERAL_ELECTRON_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u5f00\u7968\u65e5\u671f", (String)"InvoiceCollectPluginService_11", (String)"imc-rim-common", (Object[])new Object[0]), "invoiceDate", "text-align:left;width:70px;"));
        GENERAL_ELECTRON_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u9500\u65b9\u540d\u79f0", (String)"InvoiceCollectPluginService_14", (String)"imc-rim-common", (Object[])new Object[0]), "salerName", "text-align:left;width:70px;"));
        GENERAL_ELECTRON_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u9500\u65b9\u7eb3\u7a0e\u8bc6\u522b\u53f7", (String)"InvoiceCollectPluginService_15", (String)"imc-rim-common", (Object[])new Object[0]), "salerTaxNo", "text-align:left;width:70px;"));
        GENERAL_ELECTRON_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u8d2d\u65b9\u540d\u79f0", (String)"InvoiceCollectPluginService_16", (String)"imc-rim-common", (Object[])new Object[0]), "buyerName", "text-align:left;width:70px;"));
        GENERAL_ELECTRON_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u8d2d\u65b9\u7eb3\u7a0e\u8bc6\u522b\u53f7", (String)"InvoiceCollectPluginService_17", (String)"imc-rim-common", (Object[])new Object[0]), "buyerTaxNo", "text-align:left;width:70px;"));
        GENERAL_ELECTRON_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e", (String)"InvoiceCollectPluginService_18", (String)"imc-rim-common", (Object[])new Object[0]), "expenseNum", "text-align:left;width:70px;"));
        GENERAL_ELECTRON_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7", (String)"ListFieldNameSevice_26", (String)"imc-rim-common", (Object[])new Object[0]), "orgName", "text-align:left;width:150px;overflow:hidden;", 1));
        return GENERAL_ELECTRON_COLUMN_LIST;
    }

    private static final List<Column> TAXI_INVOICE_COLUMN_LIST() {
        ArrayList<Column> TAXI_INVOICE_COLUMN_LIST = new ArrayList<Column>(16);
        TAXI_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u64cd\u4f5c\u5217", (String)"InvoiceCollectPluginService_5", (String)"imc-rim-common", (Object[])new Object[0]), "operate", "text-align:left;width:70px;"));
        TAXI_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u63d0\u793a", (String)"InvoiceCollectPluginService_6", (String)"imc-rim-common", (Object[])new Object[0]), "status", "text-align:left;width:50px;"));
        if (InvoiceConfigUtils.showInvoiceInfo()) {
            TAXI_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u53d1\u7968\u4fe1\u606f", (String)"InvoiceCollectPluginService_7", (String)"imc-rim-common", (Object[])new Object[0]), "invoice_info", "text-align:left;width:230px;"));
        }
        TAXI_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801", (String)"InvoiceCollectPluginService_8", (String)"imc-rim-common", (Object[])new Object[0]), "invoiceCode", "text-align:left;width:70px;"));
        TAXI_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801", (String)"InvoiceCollectPluginService_9", (String)"imc-rim-common", (Object[])new Object[0]), "invoiceNo", "text-align:left;width:70px;"));
        TAXI_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u91d1\u989d", (String)"InvoiceCollectPluginService_19", (String)"imc-rim-common", (Object[])new Object[0]), "totalAmount", "text-align:left;width:70px;"));
        TAXI_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u4e58\u8f66\u65e5\u671f", (String)"InvoiceCollectPluginService_20", (String)"imc-rim-common", (Object[])new Object[0]), "invoiceDate", "text-align:left;width:70px;"));
        TAXI_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u4e0a\u8f66\u65f6\u95f4", (String)"InvoiceCollectPluginService_21", (String)"imc-rim-common", (Object[])new Object[0]), "timeGetOn", "text-align:left;width:70px;"));
        TAXI_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u4e0b\u8f66\u65f6\u95f4", (String)"InvoiceCollectPluginService_22", (String)"imc-rim-common", (Object[])new Object[0]), "timeGetOff", "text-align:left;width:70px;"));
        TAXI_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u6253\u8f66\u91cc\u7a0b", (String)"InvoiceCollectPluginService_23", (String)"imc-rim-common", (Object[])new Object[0]), "mileage", "text-align:left;width:70px;"));
        TAXI_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u53d1\u7968\u6240\u5728\u5730", (String)"InvoiceCollectPluginService_24", (String)"imc-rim-common", (Object[])new Object[0]), "place", "text-align:left;width:70px;"));
        TAXI_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e", (String)"InvoiceCollectPluginService_18", (String)"imc-rim-common", (Object[])new Object[0]), "expenseNum", "text-align:left;width:70px;"));
        TAXI_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7", (String)"ListFieldNameSevice_26", (String)"imc-rim-common", (Object[])new Object[0]), "orgName", "text-align:left;width:150px;overflow:hidden;", 1));
        return TAXI_INVOICE_COLUMN_LIST;
    }

    private static final List<Column> TRAIN_INVOICE_COLUMN_LIST() {
        ArrayList<Column> TRAIN_INVOICE_COLUMN_LIST = new ArrayList<Column>(16);
        TRAIN_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u64cd\u4f5c\u5217", (String)"InvoiceCollectPluginService_5", (String)"imc-rim-common", (Object[])new Object[0]), "operate", "text-align:left;width:70px;"));
        TRAIN_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u63d0\u793a", (String)"InvoiceCollectPluginService_6", (String)"imc-rim-common", (Object[])new Object[0]), "status", "text-align:left;width:50px;"));
        if (InvoiceConfigUtils.showInvoiceInfo()) {
            TRAIN_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u53d1\u7968\u4fe1\u606f", (String)"InvoiceCollectPluginService_7", (String)"imc-rim-common", (Object[])new Object[0]), "invoice_info", "text-align:left;width:230px;"));
        }
        TRAIN_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u7968\u53f7", (String)"InvoiceCollectPluginService_25", (String)"imc-rim-common", (Object[])new Object[0]), "printingSequenceNo", "text-align:left;width:70px;"));
        TRAIN_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u8f66\u6b21", (String)"InvoiceCollectPluginService_26", (String)"imc-rim-common", (Object[])new Object[0]), "trainNum", "text-align:left;width:70px;"));
        TRAIN_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u4ef7\u7a0e\u5408\u8ba1", (String)"InvoiceCollectPluginService_10", (String)"imc-rim-common", (Object[])new Object[0]), "totalAmount", "text-align:left;width:70px;"));
        TRAIN_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u4e58\u8f66\u65e5\u671f", (String)"InvoiceCollectPluginService_20", (String)"imc-rim-common", (Object[])new Object[0]), "travelDate", "text-align:left;width:70px;"));
        TRAIN_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u7a0e\u989d", (String)"InvoiceCollectPluginService_13", (String)"imc-rim-common", (Object[])new Object[0]), "totalTaxAmount", "text-align:left;width:70px;"));
        TRAIN_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u51fa\u53d1\u70b9", (String)"InvoiceCollectPluginService_27", (String)"imc-rim-common", (Object[])new Object[0]), "stationGetOn", "text-align:left;width:70px;"));
        TRAIN_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u76ee\u7684\u5730", (String)"InvoiceCollectPluginService_28", (String)"imc-rim-common", (Object[])new Object[0]), "stationGetOff", "text-align:left;width:70px;"));
        TRAIN_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u59d3\u540d", (String)"InvoiceCollectPluginService_29", (String)"imc-rim-common", (Object[])new Object[0]), "passengerName", "text-align:left;width:70px;"));
        TRAIN_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u8eab\u4efd\u8bc1\u53f7", (String)"InvoiceCollectPluginService_30", (String)"imc-rim-common", (Object[])new Object[0]), "customerIdentityNum", "text-align:left;width:70px;", true));
        TRAIN_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u5ea7\u4f4d\u7b49\u7ea7", (String)"InvoiceCollectPluginService_31", (String)"imc-rim-common", (Object[])new Object[0]), "seat", "text-align:left;width:70px;"));
        TRAIN_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e", (String)"InvoiceCollectPluginService_18", (String)"imc-rim-common", (Object[])new Object[0]), "expenseNum", "text-align:left;width:70px;"));
        TRAIN_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7", (String)"ListFieldNameSevice_26", (String)"imc-rim-common", (Object[])new Object[0]), "orgName", "text-align:left;width:150px;overflow:hidden;", 1));
        return TRAIN_INVOICE_COLUMN_LIST;
    }

    private static final List<Column> AIR_INVOICE_COLUMN_LIST() {
        ArrayList<Column> AIR_INVOICE_COLUMN_LIST = new ArrayList<Column>(16);
        AIR_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u64cd\u4f5c\u5217", (String)"InvoiceCollectPluginService_5", (String)"imc-rim-common", (Object[])new Object[0]), "operate", "text-align:left;width:70px;"));
        AIR_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u63d0\u793a", (String)"InvoiceCollectPluginService_6", (String)"imc-rim-common", (Object[])new Object[0]), "status", "text-align:left;width:50px;"));
        if (InvoiceConfigUtils.showInvoiceInfo()) {
            AIR_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u53d1\u7968\u4fe1\u606f", (String)"InvoiceCollectPluginService_7", (String)"imc-rim-common", (Object[])new Object[0]), "invoice_info", "text-align:left;width:230px;"));
        }
        AIR_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u7535\u5b50\u7968\u53f7", (String)"InvoiceCollectPluginService_32", (String)"imc-rim-common", (Object[])new Object[0]), "electronicTicketNum", "text-align:left;width:170px;"));
        AIR_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u5370\u5237\u5e8f\u53f7", (String)"InvoiceCollectPluginService_33", (String)"imc-rim-common", (Object[])new Object[0]), "printNum", "text-align:left;width:100px;"));
        AIR_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u4ef7\u7a0e\u5408\u8ba1", (String)"InvoiceCollectPluginService_10", (String)"imc-rim-common", (Object[])new Object[0]), "totalAmount", "text-align:left;width:100px;"));
        AIR_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u4e58\u673a\u65e5\u671f", (String)"InvoiceCollectPluginService_34", (String)"imc-rim-common", (Object[])new Object[0]), "invoiceDate", "text-align:left;width:70px;"));
        AIR_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u7a0e\u989d", (String)"InvoiceCollectPluginService_13", (String)"imc-rim-common", (Object[])new Object[0]), "totalTaxAmount", "text-align:left;width:70px;"));
        AIR_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u51fa\u53d1\u70b9", (String)"InvoiceCollectPluginService_27", (String)"imc-rim-common", (Object[])new Object[0]), "placeOfDeparture", "text-align:left;width:70px;"));
        AIR_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u76ee\u7684\u5730", (String)"InvoiceCollectPluginService_28", (String)"imc-rim-common", (Object[])new Object[0]), "destination", "text-align:left;width:70px;"));
        AIR_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u59d3\u540d", (String)"InvoiceCollectPluginService_29", (String)"imc-rim-common", (Object[])new Object[0]), "customerName", "text-align:left;width:70px;"));
        AIR_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u8eab\u4efd\u8bc1\u53f7", (String)"InvoiceCollectPluginService_30", (String)"imc-rim-common", (Object[])new Object[0]), "customerIdentityNum", "text-align:left;width:70px;", true));
        AIR_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u5ea7\u4f4d\u7b49\u7ea7", (String)"InvoiceCollectPluginService_31", (String)"imc-rim-common", (Object[])new Object[0]), "seatGrade", "text-align:left;width:70px;"));
        AIR_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u7968\u4ef7", (String)"InvoiceCollectPluginService_35", (String)"imc-rim-common", (Object[])new Object[0]), "invoiceAmount", "text-align:left;width:70px;"));
        AIR_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u673a\u573a\u5efa\u8bbe\u8d39", (String)"InvoiceCollectPluginService_36", (String)"imc-rim-common", (Object[])new Object[0]), "airportConstructionFee", "text-align:left;width:70px;"));
        AIR_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u71c3\u6cb9\u9644\u52a0\u8d39", (String)"InvoiceCollectPluginService_37", (String)"imc-rim-common", (Object[])new Object[0]), "fuelSurcharge", "text-align:left;width:70px;"));
        AIR_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e", (String)"InvoiceCollectPluginService_18", (String)"imc-rim-common", (Object[])new Object[0]), "expenseNum", "text-align:left;width:70px;"));
        AIR_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7", (String)"ListFieldNameSevice_26", (String)"imc-rim-common", (Object[])new Object[0]), "orgName", "text-align:left;width:150px;overflow:hidden;", 1));
        return AIR_INVOICE_COLUMN_LIST;
    }

    private static final List<Column> OTHER_INVOICE_COLUMN_LIST() {
        ArrayList<Column> OTHER_INVOICE_COLUMN_LIST = new ArrayList<Column>(16);
        OTHER_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u64cd\u4f5c\u5217", (String)"InvoiceCollectPluginService_5", (String)"imc-rim-common", (Object[])new Object[0]), "operate", "text-align:left;width:70px;"));
        OTHER_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u63d0\u793a", (String)"InvoiceCollectPluginService_6", (String)"imc-rim-common", (Object[])new Object[0]), "status", "text-align:left;width:50px;"));
        if (InvoiceConfigUtils.showInvoiceInfo()) {
            OTHER_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u53d1\u7968\u4fe1\u606f", (String)"InvoiceCollectPluginService_7", (String)"imc-rim-common", (Object[])new Object[0]), "invoice_info", "text-align:left;width:230px;"));
        }
        OTHER_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u91d1\u989d", (String)"InvoiceCollectPluginService_19", (String)"imc-rim-common", (Object[])new Object[0]), "totalAmount", "text-align:left;width:70px;"));
        OTHER_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u5907\u6ce8", (String)"InvoiceCollectPluginService_38", (String)"imc-rim-common", (Object[])new Object[0]), "remark", "text-align:left;width:70px;"));
        OTHER_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e", (String)"InvoiceCollectPluginService_18", (String)"imc-rim-common", (Object[])new Object[0]), "expenseNum", "text-align:left;width:70px;"));
        OTHER_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7", (String)"ListFieldNameSevice_26", (String)"imc-rim-common", (Object[])new Object[0]), "orgName", "text-align:left;width:150px;overflow:hidden;", 1));
        return OTHER_INVOICE_COLUMN_LIST;
    }

    private static final List<Column> MOTOR_INVOICE_COLUMN_LIST() {
        ArrayList<Column> MOTOR_INVOICE_COLUMN_LIST = new ArrayList<Column>(16);
        MOTOR_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u64cd\u4f5c\u5217", (String)"InvoiceCollectPluginService_5", (String)"imc-rim-common", (Object[])new Object[0]), "operate", "text-align:left;width:70px;"));
        MOTOR_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u63d0\u793a", (String)"InvoiceCollectPluginService_6", (String)"imc-rim-common", (Object[])new Object[0]), "status", "text-align:left;width:50px;"));
        if (InvoiceConfigUtils.showInvoiceInfo()) {
            MOTOR_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u53d1\u7968\u4fe1\u606f", (String)"InvoiceCollectPluginService_7", (String)"imc-rim-common", (Object[])new Object[0]), "invoice_info", "text-align:left;width:230px;"));
        }
        MOTOR_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801", (String)"InvoiceCollectPluginService_8", (String)"imc-rim-common", (Object[])new Object[0]), "invoiceCode", "text-align:left;width:70px;"));
        MOTOR_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801", (String)"InvoiceCollectPluginService_9", (String)"imc-rim-common", (Object[])new Object[0]), "invoiceNo", "text-align:left;width:70px;"));
        MOTOR_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u4ef7\u7a0e\u5408\u8ba1", (String)"InvoiceCollectPluginService_10", (String)"imc-rim-common", (Object[])new Object[0]), "totalAmount", "text-align:left;width:70px;"));
        MOTOR_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u5f00\u7968\u65f6\u95f4", (String)"InvoiceCollectPluginService_39", (String)"imc-rim-common", (Object[])new Object[0]), "invoiceDate", "text-align:left;width:70px;"));
        MOTOR_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u4e0d\u542b\u7a0e\u91d1\u989d", (String)"InvoiceCollectPluginService_12", (String)"imc-rim-common", (Object[])new Object[0]), "invoiceAmount", "text-align:left;width:70px;"));
        MOTOR_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u7a0e\u989d", (String)"InvoiceCollectPluginService_13", (String)"imc-rim-common", (Object[])new Object[0]), "totalTaxAmount", "text-align:left;width:70px;"));
        MOTOR_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u9500\u65b9\u540d\u79f0", (String)"InvoiceCollectPluginService_14", (String)"imc-rim-common", (Object[])new Object[0]), "salerName", "text-align:left;width:70px;"));
        MOTOR_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u9500\u65b9\u7eb3\u7a0e\u8bc6\u522b\u53f7", (String)"InvoiceCollectPluginService_15", (String)"imc-rim-common", (Object[])new Object[0]), "salerTaxNo", "text-align:left;width:70px;"));
        MOTOR_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u8d2d\u65b9\u540d\u79f0", (String)"InvoiceCollectPluginService_16", (String)"imc-rim-common", (Object[])new Object[0]), "buyerName", "text-align:left;width:70px;"));
        MOTOR_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u8d2d\u65b9\u7eb3\u7a0e\u8bc6\u522b\u53f7", (String)"InvoiceCollectPluginService_17", (String)"imc-rim-common", (Object[])new Object[0]), "buyerTaxNo", "text-align:left;width:70px;"));
        MOTOR_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e", (String)"InvoiceCollectPluginService_18", (String)"imc-rim-common", (Object[])new Object[0]), "expenseNum", "text-align:left;width:70px;"));
        MOTOR_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7", (String)"ListFieldNameSevice_26", (String)"imc-rim-common", (Object[])new Object[0]), "orgName", "text-align:left;width:150px;overflow:hidden;", 1));
        return MOTOR_INVOICE_COLUMN_LIST;
    }

    private static final List<Column> MOTOR_INVOICE_ELE_COLUMN_LIST() {
        ArrayList<Column> MOTOR_INVOICE_COLUMN_LIST = new ArrayList<Column>(16);
        MOTOR_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u64cd\u4f5c\u5217", (String)"InvoiceCollectPluginService_5", (String)"imc-rim-common", (Object[])new Object[0]), "operate", "text-align:left;width:70px;"));
        MOTOR_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u63d0\u793a", (String)"InvoiceCollectPluginService_6", (String)"imc-rim-common", (Object[])new Object[0]), "status", "text-align:left;width:50px;"));
        if (InvoiceConfigUtils.showInvoiceInfo()) {
            MOTOR_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u53d1\u7968\u4fe1\u606f", (String)"InvoiceCollectPluginService_7", (String)"imc-rim-common", (Object[])new Object[0]), "invoice_info", "text-align:left;width:230px;"));
        }
        MOTOR_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801", (String)"InvoiceCollectPluginService_9", (String)"imc-rim-common", (Object[])new Object[0]), "invoiceNo", "text-align:left;width:70px;"));
        MOTOR_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u4ef7\u7a0e\u5408\u8ba1", (String)"InvoiceCollectPluginService_10", (String)"imc-rim-common", (Object[])new Object[0]), "totalAmount", "text-align:left;width:70px;"));
        MOTOR_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u5f00\u7968\u65f6\u95f4", (String)"InvoiceCollectPluginService_39", (String)"imc-rim-common", (Object[])new Object[0]), "invoiceDate", "text-align:left;width:70px;"));
        MOTOR_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u4e0d\u542b\u7a0e\u91d1\u989d", (String)"InvoiceCollectPluginService_12", (String)"imc-rim-common", (Object[])new Object[0]), "invoiceAmount", "text-align:left;width:70px;"));
        MOTOR_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u7a0e\u989d", (String)"InvoiceCollectPluginService_13", (String)"imc-rim-common", (Object[])new Object[0]), "totalTaxAmount", "text-align:left;width:70px;"));
        MOTOR_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u9500\u65b9\u540d\u79f0", (String)"InvoiceCollectPluginService_14", (String)"imc-rim-common", (Object[])new Object[0]), "salerName", "text-align:left;width:70px;"));
        MOTOR_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u9500\u65b9\u7eb3\u7a0e\u8bc6\u522b\u53f7", (String)"InvoiceCollectPluginService_15", (String)"imc-rim-common", (Object[])new Object[0]), "salerTaxNo", "text-align:left;width:70px;"));
        MOTOR_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u8d2d\u65b9\u540d\u79f0", (String)"InvoiceCollectPluginService_16", (String)"imc-rim-common", (Object[])new Object[0]), "buyerName", "text-align:left;width:70px;"));
        MOTOR_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u8d2d\u65b9\u7eb3\u7a0e\u8bc6\u522b\u53f7", (String)"InvoiceCollectPluginService_17", (String)"imc-rim-common", (Object[])new Object[0]), "buyerTaxNo", "text-align:left;width:70px;"));
        MOTOR_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e", (String)"InvoiceCollectPluginService_18", (String)"imc-rim-common", (Object[])new Object[0]), "expenseNum", "text-align:left;width:70px;"));
        MOTOR_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7", (String)"ListFieldNameSevice_26", (String)"imc-rim-common", (Object[])new Object[0]), "orgName", "text-align:left;width:150px;overflow:hidden;", 1));
        return MOTOR_INVOICE_COLUMN_LIST;
    }

    private static final List<Column> USEDCAR_INVOICE_COLUMN_LIST() {
        ArrayList<Column> USEDCAR_INVOICE_COLUMN_LIST = new ArrayList<Column>(16);
        USEDCAR_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u64cd\u4f5c\u5217", (String)"InvoiceCollectPluginService_5", (String)"imc-rim-common", (Object[])new Object[0]), "operate", "text-align:left;width:70px;"));
        USEDCAR_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u63d0\u793a", (String)"InvoiceCollectPluginService_6", (String)"imc-rim-common", (Object[])new Object[0]), "status", "text-align:left;width:50px;"));
        if (InvoiceConfigUtils.showInvoiceInfo()) {
            USEDCAR_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u53d1\u7968\u4fe1\u606f", (String)"InvoiceCollectPluginService_7", (String)"imc-rim-common", (Object[])new Object[0]), "invoice_info", "text-align:left;width:230px;"));
        }
        USEDCAR_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801", (String)"InvoiceCollectPluginService_8", (String)"imc-rim-common", (Object[])new Object[0]), "invoiceCode", "text-align:left;width:70px;"));
        USEDCAR_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801", (String)"InvoiceCollectPluginService_9", (String)"imc-rim-common", (Object[])new Object[0]), "invoiceNo", "text-align:left;width:70px;"));
        USEDCAR_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u91d1\u989d", (String)"InvoiceCollectPluginService_19", (String)"imc-rim-common", (Object[])new Object[0]), "totalAmount", "text-align:left;width:70px;"));
        USEDCAR_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u5f00\u7968\u65f6\u95f4", (String)"InvoiceCollectPluginService_39", (String)"imc-rim-common", (Object[])new Object[0]), "invoiceDate", "text-align:left;width:70px;"));
        USEDCAR_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u8d2d\u4e70\u65b9\u540d\u79f0", (String)"InvoiceCollectPluginService_40", (String)"imc-rim-common", (Object[])new Object[0]), "buyerName", "text-align:left;width:70px;"));
        USEDCAR_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u8d2d\u4e70\u65b9\u8bc1\u4ef6\u53f7", (String)"InvoiceCollectPluginService_41", (String)"imc-rim-common", (Object[])new Object[0]), "buyerIdNo,buyerTaxNo", "text-align:left;width:70px;", true));
        USEDCAR_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u9500\u552e\u65b9\u540d\u79f0", (String)"InvoiceCollectPluginService_42", (String)"imc-rim-common", (Object[])new Object[0]), "salerName", "text-align:left;width:70px;"));
        USEDCAR_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u9500\u552e\u65b9\u8bc1\u4ef6\u53f7", (String)"InvoiceCollectPluginService_43", (String)"imc-rim-common", (Object[])new Object[0]), "salerIdNo,salerIdNO,salerTaxNo", "text-align:left;width:70px;", true));
        USEDCAR_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e", (String)"InvoiceCollectPluginService_18", (String)"imc-rim-common", (Object[])new Object[0]), "expenseNum", "text-align:left;width:70px;"));
        USEDCAR_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7", (String)"ListFieldNameSevice_26", (String)"imc-rim-common", (Object[])new Object[0]), "orgName", "text-align:left;width:150px;overflow:hidden;", 1));
        return USEDCAR_INVOICE_COLUMN_LIST;
    }

    private static final List<Column> USEDCAR_INVOICE_ELE_COLUMN_LIST() {
        ArrayList<Column> USEDCAR_INVOICE_COLUMN_LIST = new ArrayList<Column>(16);
        USEDCAR_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u64cd\u4f5c\u5217", (String)"InvoiceCollectPluginService_5", (String)"imc-rim-common", (Object[])new Object[0]), "operate", "text-align:left;width:70px;"));
        USEDCAR_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u63d0\u793a", (String)"InvoiceCollectPluginService_6", (String)"imc-rim-common", (Object[])new Object[0]), "status", "text-align:left;width:50px;"));
        if (InvoiceConfigUtils.showInvoiceInfo()) {
            USEDCAR_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u53d1\u7968\u4fe1\u606f", (String)"InvoiceCollectPluginService_7", (String)"imc-rim-common", (Object[])new Object[0]), "invoice_info", "text-align:left;width:230px;"));
        }
        USEDCAR_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801", (String)"InvoiceCollectPluginService_9", (String)"imc-rim-common", (Object[])new Object[0]), "invoiceNo", "text-align:left;width:70px;"));
        USEDCAR_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u91d1\u989d", (String)"InvoiceCollectPluginService_19", (String)"imc-rim-common", (Object[])new Object[0]), "totalAmount", "text-align:left;width:70px;"));
        USEDCAR_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u5f00\u7968\u65f6\u95f4", (String)"InvoiceCollectPluginService_39", (String)"imc-rim-common", (Object[])new Object[0]), "invoiceDate", "text-align:left;width:70px;"));
        USEDCAR_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u8d2d\u4e70\u65b9\u540d\u79f0", (String)"InvoiceCollectPluginService_40", (String)"imc-rim-common", (Object[])new Object[0]), "buyerName", "text-align:left;width:70px;"));
        USEDCAR_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u8d2d\u4e70\u65b9\u8bc1\u4ef6\u53f7", (String)"InvoiceCollectPluginService_41", (String)"imc-rim-common", (Object[])new Object[0]), "buyerIdNo,buyerTaxNo", "text-align:left;width:70px;", true));
        USEDCAR_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u9500\u552e\u65b9\u540d\u79f0", (String)"InvoiceCollectPluginService_42", (String)"imc-rim-common", (Object[])new Object[0]), "salerName", "text-align:left;width:70px;"));
        USEDCAR_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u9500\u552e\u65b9\u8bc1\u4ef6\u53f7", (String)"InvoiceCollectPluginService_43", (String)"imc-rim-common", (Object[])new Object[0]), "salerIdNo,salerIdNO,salerTaxNo", "text-align:left;width:70px;", true));
        USEDCAR_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e", (String)"InvoiceCollectPluginService_18", (String)"imc-rim-common", (Object[])new Object[0]), "expenseNum", "text-align:left;width:70px;"));
        USEDCAR_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7", (String)"ListFieldNameSevice_26", (String)"imc-rim-common", (Object[])new Object[0]), "orgName", "text-align:left;width:150px;overflow:hidden;", 1));
        return USEDCAR_INVOICE_COLUMN_LIST;
    }

    private static final List<Column> QUOTA_INVOICE_COLUMN_LIST() {
        ArrayList<Column> QUOTA_INVOICE_COLUMN_LIST = new ArrayList<Column>(16);
        QUOTA_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u64cd\u4f5c\u5217", (String)"InvoiceCollectPluginService_5", (String)"imc-rim-common", (Object[])new Object[0]), "operate", "text-align:left;width:70px;"));
        QUOTA_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u63d0\u793a", (String)"InvoiceCollectPluginService_6", (String)"imc-rim-common", (Object[])new Object[0]), "status", "text-align:left;width:50px;"));
        if (InvoiceConfigUtils.showInvoiceInfo()) {
            QUOTA_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u53d1\u7968\u4fe1\u606f", (String)"InvoiceCollectPluginService_7", (String)"imc-rim-common", (Object[])new Object[0]), "invoice_info", "text-align:left;width:230px;"));
        }
        QUOTA_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801", (String)"InvoiceCollectPluginService_8", (String)"imc-rim-common", (Object[])new Object[0]), "invoiceCode", "text-align:left;width:70px;"));
        QUOTA_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801", (String)"InvoiceCollectPluginService_9", (String)"imc-rim-common", (Object[])new Object[0]), "invoiceNo", "text-align:left;width:70px;"));
        QUOTA_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u91d1\u989d", (String)"InvoiceCollectPluginService_19", (String)"imc-rim-common", (Object[])new Object[0]), "totalAmount", "text-align:left;width:70px;"));
        QUOTA_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u53d1\u7968\u6240\u5728\u5730", (String)"InvoiceCollectPluginService_24", (String)"imc-rim-common", (Object[])new Object[0]), "place", "text-align:left;width:70px;"));
        QUOTA_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e", (String)"InvoiceCollectPluginService_18", (String)"imc-rim-common", (Object[])new Object[0]), "expenseNum", "text-align:left;width:70px;"));
        QUOTA_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7", (String)"ListFieldNameSevice_26", (String)"imc-rim-common", (Object[])new Object[0]), "orgName", "text-align:left;width:150px;overflow:hidden;", 1));
        return QUOTA_INVOICE_COLUMN_LIST;
    }

    private static final List<Column> TOLL_ELECTRON_COLUMN_LIST() {
        ArrayList<Column> TOLL_ELECTRON_COLUMN_LIST = new ArrayList<Column>(16);
        TOLL_ELECTRON_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u64cd\u4f5c\u5217", (String)"InvoiceCollectPluginService_5", (String)"imc-rim-common", (Object[])new Object[0]), "operate", "text-align:left;width:70px;"));
        TOLL_ELECTRON_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u63d0\u793a", (String)"InvoiceCollectPluginService_6", (String)"imc-rim-common", (Object[])new Object[0]), "status", "text-align:left;width:50px;"));
        if (InvoiceConfigUtils.showInvoiceInfo()) {
            TOLL_ELECTRON_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u53d1\u7968\u4fe1\u606f", (String)"InvoiceCollectPluginService_7", (String)"imc-rim-common", (Object[])new Object[0]), "invoice_info", "text-align:left;width:230px;"));
        }
        TOLL_ELECTRON_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801", (String)"InvoiceCollectPluginService_8", (String)"imc-rim-common", (Object[])new Object[0]), "invoiceCode", "text-align:left;width:70px;"));
        TOLL_ELECTRON_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801", (String)"InvoiceCollectPluginService_9", (String)"imc-rim-common", (Object[])new Object[0]), "invoiceNo", "text-align:left;width:70px;"));
        TOLL_ELECTRON_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u4ef7\u7a0e\u5408\u8ba1", (String)"InvoiceCollectPluginService_10", (String)"imc-rim-common", (Object[])new Object[0]), "totalAmount", "text-align:left;width:70px;"));
        TOLL_ELECTRON_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u5f00\u7968\u65f6\u95f4", (String)"InvoiceCollectPluginService_39", (String)"imc-rim-common", (Object[])new Object[0]), "invoiceDate", "text-align:left;width:70px;"));
        TOLL_ELECTRON_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u4e0d\u542b\u7a0e\u91d1\u989d", (String)"InvoiceCollectPluginService_12", (String)"imc-rim-common", (Object[])new Object[0]), "invoiceAmount,amount", "text-align:left;width:70px;"));
        TOLL_ELECTRON_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u7a0e\u989d", (String)"InvoiceCollectPluginService_13", (String)"imc-rim-common", (Object[])new Object[0]), "totalTaxAmount,taxAmount", "text-align:left;width:70px;"));
        TOLL_ELECTRON_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u9500\u65b9\u540d\u79f0", (String)"InvoiceCollectPluginService_14", (String)"imc-rim-common", (Object[])new Object[0]), "salerName", "text-align:left;width:70px;"));
        TOLL_ELECTRON_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u9500\u65b9\u7eb3\u7a0e\u8bc6\u522b\u53f7", (String)"InvoiceCollectPluginService_15", (String)"imc-rim-common", (Object[])new Object[0]), "salerTaxNo", "text-align:left;width:70px;"));
        TOLL_ELECTRON_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u8d2d\u65b9\u540d\u79f0", (String)"InvoiceCollectPluginService_16", (String)"imc-rim-common", (Object[])new Object[0]), "buyerName", "text-align:left;width:70px;"));
        TOLL_ELECTRON_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u8d2d\u65b9\u7eb3\u7a0e\u8bc6\u522b\u53f7", (String)"InvoiceCollectPluginService_17", (String)"imc-rim-common", (Object[])new Object[0]), "buyerTaxNo", "text-align:left;width:70px;"));
        TOLL_ELECTRON_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e", (String)"InvoiceCollectPluginService_18", (String)"imc-rim-common", (Object[])new Object[0]), "expenseNum", "text-align:left;width:70px;"));
        TOLL_ELECTRON_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7", (String)"ListFieldNameSevice_26", (String)"imc-rim-common", (Object[])new Object[0]), "orgName", "text-align:left;width:150px;overflow:hidden;", 1));
        return TOLL_ELECTRON_COLUMN_LIST;
    }

    private static final List<Column> TRANSPORT_INVOICE_COLUMN_LIST() {
        ArrayList<Column> TRANSPORT_INVOICE_COLUMN_LIST = new ArrayList<Column>(16);
        TRANSPORT_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u64cd\u4f5c\u5217", (String)"InvoiceCollectPluginService_5", (String)"imc-rim-common", (Object[])new Object[0]), "operate", "text-align:left;width:70px;"));
        TRANSPORT_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u63d0\u793a", (String)"InvoiceCollectPluginService_6", (String)"imc-rim-common", (Object[])new Object[0]), "status", "text-align:left;width:50px;"));
        if (InvoiceConfigUtils.showInvoiceInfo()) {
            TRANSPORT_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u53d1\u7968\u4fe1\u606f", (String)"InvoiceCollectPluginService_7", (String)"imc-rim-common", (Object[])new Object[0]), "invoice_info", "text-align:left;width:230px;"));
        }
        TRANSPORT_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801", (String)"InvoiceCollectPluginService_8", (String)"imc-rim-common", (Object[])new Object[0]), "invoiceCode", "text-align:left;width:70px;"));
        TRANSPORT_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801", (String)"InvoiceCollectPluginService_9", (String)"imc-rim-common", (Object[])new Object[0]), "invoiceNo", "text-align:left;width:70px;"));
        TRANSPORT_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u4ef7\u7a0e\u5408\u8ba1", (String)"InvoiceCollectPluginService_10", (String)"imc-rim-common", (Object[])new Object[0]), "totalAmount", "text-align:left;width:70px;"));
        TRANSPORT_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u4e58\u8f66\u65e5\u671f", (String)"InvoiceCollectPluginService_20", (String)"imc-rim-common", (Object[])new Object[0]), "invoiceDate", "text-align:left;width:70px;"));
        TRANSPORT_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u7a0e\u989d", (String)"InvoiceCollectPluginService_13", (String)"imc-rim-common", (Object[])new Object[0]), "totalTaxAmount", "text-align:left;width:70px;"));
        TRANSPORT_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u51fa\u53d1\u70b9", (String)"InvoiceCollectPluginService_27", (String)"imc-rim-common", (Object[])new Object[0]), "stationGetOn", "text-align:left;width:70px;"));
        TRANSPORT_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u76ee\u7684\u5730", (String)"InvoiceCollectPluginService_28", (String)"imc-rim-common", (Object[])new Object[0]), "stationGetOff", "text-align:left;width:70px;"));
        TRANSPORT_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u59d3\u540d", (String)"InvoiceCollectPluginService_29", (String)"imc-rim-common", (Object[])new Object[0]), "passengerName", "text-align:left;width:70px;"));
        TRANSPORT_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e", (String)"InvoiceCollectPluginService_18", (String)"imc-rim-common", (Object[])new Object[0]), "expenseNum", "text-align:left;width:70px;"));
        TRANSPORT_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7", (String)"ListFieldNameSevice_26", (String)"imc-rim-common", (Object[])new Object[0]), "orgName", "text-align:left;width:150px;overflow:hidden;", 1));
        return TRANSPORT_INVOICE_COLUMN_LIST;
    }

    private static final List<Column> ROAD_BRIDGE_COLUMN_LIST() {
        ArrayList<Column> ROAD_BRIDGE_COLUMN_LIST = new ArrayList<Column>(16);
        ROAD_BRIDGE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u64cd\u4f5c\u5217", (String)"InvoiceCollectPluginService_5", (String)"imc-rim-common", (Object[])new Object[0]), "operate", "text-align:left;width:70px;"));
        ROAD_BRIDGE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u63d0\u793a", (String)"InvoiceCollectPluginService_6", (String)"imc-rim-common", (Object[])new Object[0]), "status", "text-align:left;width:50px;"));
        if (InvoiceConfigUtils.showInvoiceInfo()) {
            ROAD_BRIDGE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u53d1\u7968\u4fe1\u606f", (String)"InvoiceCollectPluginService_7", (String)"imc-rim-common", (Object[])new Object[0]), "invoice_info", "text-align:left;width:230px;"));
        }
        ROAD_BRIDGE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801", (String)"InvoiceCollectPluginService_8", (String)"imc-rim-common", (Object[])new Object[0]), "invoiceCode", "text-align:left;width:70px;"));
        ROAD_BRIDGE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801", (String)"InvoiceCollectPluginService_9", (String)"imc-rim-common", (Object[])new Object[0]), "invoiceNo", "text-align:left;width:70px;"));
        ROAD_BRIDGE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u91d1\u989d", (String)"InvoiceCollectPluginService_19", (String)"imc-rim-common", (Object[])new Object[0]), "totalAmount", "text-align:left;width:70px;"));
        ROAD_BRIDGE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u5f00\u7968\u65e5\u671f", (String)"InvoiceCollectPluginService_11", (String)"imc-rim-common", (Object[])new Object[0]), "invoiceDate", "text-align:left;width:70px;"));
        ROAD_BRIDGE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u5165\u53e3", (String)"InvoiceCollectPluginService_44", (String)"imc-rim-common", (Object[])new Object[0]), "entrance", "text-align:left;width:70px;"));
        ROAD_BRIDGE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u51fa\u53e3", (String)"InvoiceCollectPluginService_45", (String)"imc-rim-common", (Object[])new Object[0]), "exit", "text-align:left;width:70px;"));
        ROAD_BRIDGE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u65f6\u95f4", (String)"InvoiceCollectPluginService_46", (String)"imc-rim-common", (Object[])new Object[0]), "ftime,time", "text-align:left;width:70px;"));
        ROAD_BRIDGE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u53d1\u7968\u6240\u5728\u5730", (String)"InvoiceCollectPluginService_24", (String)"imc-rim-common", (Object[])new Object[0]), "place", "text-align:left;width:70px;"));
        ROAD_BRIDGE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e", (String)"InvoiceCollectPluginService_18", (String)"imc-rim-common", (Object[])new Object[0]), "expenseNum", "text-align:left;width:70px;"));
        ROAD_BRIDGE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7", (String)"ListFieldNameSevice_26", (String)"imc-rim-common", (Object[])new Object[0]), "orgName", "text-align:left;width:150px;overflow:hidden;", 1));
        return ROAD_BRIDGE_COLUMN_LIST;
    }

    private static final List<Column> TAX_PROOF_COLUMN_LIST() {
        ArrayList<Column> TAX_PROOF_COLUMN_LIST = new ArrayList<Column>(16);
        TAX_PROOF_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u64cd\u4f5c\u5217", (String)"InvoiceCollectPluginService_5", (String)"imc-rim-common", (Object[])new Object[0]), "operate", "text-align:left;width:70px;"));
        TAX_PROOF_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u63d0\u793a", (String)"InvoiceCollectPluginService_6", (String)"imc-rim-common", (Object[])new Object[0]), "status", "text-align:left;width:50px;"));
        if (InvoiceConfigUtils.showInvoiceInfo()) {
            TAX_PROOF_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u53d1\u7968\u4fe1\u606f", (String)"InvoiceCollectPluginService_7", (String)"imc-rim-common", (Object[])new Object[0]), "invoice_info", "text-align:left;width:230px;"));
        }
        TAX_PROOF_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u7eb3\u7a0e\u8bc6\u522b\u53f7", (String)"InvoiceCollectPluginService_47", (String)"imc-rim-common", (Object[])new Object[0]), "buyerTaxNo", "text-align:left;width:70px;"));
        TAX_PROOF_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u5b8c\u7a0e\u8bc1\u660e\u53f7\u7801", (String)"InvoiceCollectPluginService_48", (String)"imc-rim-common", (Object[])new Object[0]), "taxPaidProofNo", "text-align:left;width:70px;"));
        TAX_PROOF_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u91d1\u989d", (String)"InvoiceCollectPluginService_19", (String)"imc-rim-common", (Object[])new Object[0]), "totalAmount", "text-align:left;width:70px;"));
        TAX_PROOF_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u586b\u53d1\u65e5\u671f", (String)"InvoiceCollectPluginService_49", (String)"imc-rim-common", (Object[])new Object[0]), "invoiceDate", "text-align:left;width:70px;"));
        TAX_PROOF_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e", (String)"InvoiceCollectPluginService_18", (String)"imc-rim-common", (Object[])new Object[0]), "expenseNum", "text-align:left;width:70px;"));
        TAX_PROOF_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7", (String)"ListFieldNameSevice_26", (String)"imc-rim-common", (Object[])new Object[0]), "orgName", "text-align:left;width:150px;overflow:hidden;", 1));
        return TAX_PROOF_COLUMN_LIST;
    }

    private static final List<Column> BOAT_INVOICE_COLUMN_LIST() {
        ArrayList<Column> BOAT_INVOICE_COLUMN_LIST = new ArrayList<Column>(16);
        BOAT_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u64cd\u4f5c\u5217", (String)"InvoiceCollectPluginService_5", (String)"imc-rim-common", (Object[])new Object[0]), "operate", "text-align:left;width:70px;"));
        BOAT_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u63d0\u793a", (String)"InvoiceCollectPluginService_6", (String)"imc-rim-common", (Object[])new Object[0]), "status", "text-align:left;width:50px;"));
        if (InvoiceConfigUtils.showInvoiceInfo()) {
            BOAT_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u53d1\u7968\u4fe1\u606f", (String)"InvoiceCollectPluginService_7", (String)"imc-rim-common", (Object[])new Object[0]), "invoice_info", "text-align:left;width:230px;"));
        }
        BOAT_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801", (String)"InvoiceCollectPluginService_8", (String)"imc-rim-common", (Object[])new Object[0]), "invoiceCode", "text-align:left;width:70px;"));
        BOAT_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801", (String)"InvoiceCollectPluginService_9", (String)"imc-rim-common", (Object[])new Object[0]), "invoiceNo", "text-align:left;width:70px;"));
        BOAT_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u4ef7\u7a0e\u5408\u8ba1", (String)"InvoiceCollectPluginService_10", (String)"imc-rim-common", (Object[])new Object[0]), "totalAmount", "text-align:left;width:70px;"));
        BOAT_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u4e58\u8239\u65e5\u671f", (String)"InvoiceCollectPluginService_50", (String)"imc-rim-common", (Object[])new Object[0]), "invoiceDate", "text-align:left;width:70px;"));
        BOAT_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u7a0e\u989d", (String)"InvoiceCollectPluginService_13", (String)"imc-rim-common", (Object[])new Object[0]), "totalTaxAmount", "text-align:left;width:70px;"));
        BOAT_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u51fa\u53d1\u70b9", (String)"InvoiceCollectPluginService_27", (String)"imc-rim-common", (Object[])new Object[0]), "stationGetOn", "text-align:left;width:70px;"));
        BOAT_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u76ee\u7684\u5730", (String)"InvoiceCollectPluginService_28", (String)"imc-rim-common", (Object[])new Object[0]), "stationGetOff", "text-align:left;width:70px;"));
        BOAT_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u59d3\u540d", (String)"InvoiceCollectPluginService_29", (String)"imc-rim-common", (Object[])new Object[0]), "passengerName", "text-align:left;width:70px;"));
        BOAT_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e", (String)"InvoiceCollectPluginService_18", (String)"imc-rim-common", (Object[])new Object[0]), "expenseNum", "text-align:left;width:70px;"));
        BOAT_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7", (String)"ListFieldNameSevice_26", (String)"imc-rim-common", (Object[])new Object[0]), "orgName", "text-align:left;width:150px;overflow:hidden;", 1));
        return BOAT_INVOICE_COLUMN_LIST;
    }

    private static final List<Column> HGJKS_INVOICE_COLUMN_LIST() {
        ArrayList<Column> HGJKS_INVOICE_COLUMN_LIST = new ArrayList<Column>(16);
        HGJKS_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u64cd\u4f5c\u5217", (String)"InvoiceCollectPluginService_5", (String)"imc-rim-common", (Object[])new Object[0]), "operate", "text-align:left;width:70px;"));
        HGJKS_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u63d0\u793a", (String)"InvoiceCollectPluginService_6", (String)"imc-rim-common", (Object[])new Object[0]), "status", "text-align:left;width:50px;"));
        if (InvoiceConfigUtils.showInvoiceInfo()) {
            HGJKS_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u53d1\u7968\u4fe1\u606f", (String)"InvoiceCollectPluginService_7", (String)"imc-rim-common", (Object[])new Object[0]), "invoice_info", "text-align:left;width:230px;"));
        }
        HGJKS_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u7f34\u6b3e\u4e66\u53f7\u7801", (String)"InvoiceCollectPluginService_51", (String)"imc-rim-common", (Object[])new Object[0]), "customDeclarationNo", "text-align:left;width:70px;"));
        HGJKS_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u586b\u53d1\u65e5\u671f", (String)"InvoiceCollectPluginService_49", (String)"imc-rim-common", (Object[])new Object[0]), "invoiceDate", "text-align:left;width:70px;"));
        HGJKS_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u5408\u8ba1\u91d1\u989d", (String)"InvoiceCollectPluginService_52", (String)"imc-rim-common", (Object[])new Object[0]), "totalAmount", "text-align:left;width:70px;"));
        HGJKS_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u7f34\u6b3e\u5355\u4f4d\u4e00\u540d\u79f0", (String)"InvoiceCollectPluginService_53", (String)"imc-rim-common", (Object[])new Object[0]), "deptName", "text-align:left;width:70px;"));
        HGJKS_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u7f34\u6b3e\u5355\u4f4d\u4e8c\u540d\u79f0", (String)"InvoiceCollectPluginService_54", (String)"imc-rim-common", (Object[])new Object[0]), "secondDeptName", "text-align:left;width:70px;"));
        HGJKS_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e", (String)"InvoiceCollectPluginService_18", (String)"imc-rim-common", (Object[])new Object[0]), "expenseNum", "text-align:left;width:70px;"));
        HGJKS_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7", (String)"ListFieldNameSevice_26", (String)"imc-rim-common", (Object[])new Object[0]), "orgName", "text-align:left;width:150px;overflow:hidden;", 1));
        return HGJKS_INVOICE_COLUMN_LIST;
    }

    private static final List<Column> TRAIN_REFUND_COLUMN_LIST() {
        ArrayList<Column> TRAIN_REFUND_COLUMN_LIST = new ArrayList<Column>(16);
        TRAIN_REFUND_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u64cd\u4f5c\u5217", (String)"InvoiceCollectPluginService_5", (String)"imc-rim-common", (Object[])new Object[0]), "operate", "text-align:left;width:70px;"));
        TRAIN_REFUND_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u63d0\u793a", (String)"InvoiceCollectPluginService_6", (String)"imc-rim-common", (Object[])new Object[0]), "status", "text-align:left;width:50px;"));
        if (InvoiceConfigUtils.showInvoiceInfo()) {
            TRAIN_REFUND_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u53d1\u7968\u4fe1\u606f", (String)"InvoiceCollectPluginService_7", (String)"imc-rim-common", (Object[])new Object[0]), "invoice_info", "text-align:left;width:230px;"));
        }
        TRAIN_REFUND_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u6536\u636e\u53f7\u7801", (String)"InvoiceCollectPluginService_55", (String)"imc-rim-common", (Object[])new Object[0]), "number", "text-align:left;width:70px;"));
        TRAIN_REFUND_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u91d1\u989d", (String)"InvoiceCollectPluginService_19", (String)"imc-rim-common", (Object[])new Object[0]), "totalAmount", "text-align:left;width:70px;"));
        TRAIN_REFUND_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e", (String)"InvoiceCollectPluginService_18", (String)"imc-rim-common", (Object[])new Object[0]), "expenseNum", "text-align:left;width:70px;"));
        TRAIN_REFUND_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7", (String)"ListFieldNameSevice_26", (String)"imc-rim-common", (Object[])new Object[0]), "orgName", "text-align:left;width:150px;overflow:hidden;", 1));
        return TRAIN_REFUND_COLUMN_LIST;
    }

    private static final List<Column> FINANCIAL_INVOICE_COLUMN_LIST() {
        ArrayList<Column> FINANCIAL_INVOICE_COLUMN_LIST = new ArrayList<Column>(16);
        FINANCIAL_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u64cd\u4f5c\u5217", (String)"InvoiceCollectPluginService_5", (String)"imc-rim-common", (Object[])new Object[0]), "operate", "text-align:left;width:70px;"));
        FINANCIAL_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u63d0\u793a", (String)"InvoiceCollectPluginService_6", (String)"imc-rim-common", (Object[])new Object[0]), "status", "text-align:left;width:50px;"));
        if (InvoiceConfigUtils.showInvoiceInfo()) {
            FINANCIAL_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u53d1\u7968\u4fe1\u606f", (String)"InvoiceCollectPluginService_7", (String)"imc-rim-common", (Object[])new Object[0]), "invoice_info", "text-align:left;width:230px;"));
        }
        FINANCIAL_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u7968\u636e\u4ee3\u7801", (String)"InvoiceCollectPluginService_56", (String)"imc-rim-common", (Object[])new Object[0]), "invoiceCode", "text-align:left;width:70px;"));
        FINANCIAL_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u7968\u636e\u53f7\u7801", (String)"InvoiceCollectPluginService_57", (String)"imc-rim-common", (Object[])new Object[0]), "invoiceNo", "text-align:left;width:70px;"));
        FINANCIAL_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u5f00\u7968\u65f6\u95f4", (String)"InvoiceCollectPluginService_39", (String)"imc-rim-common", (Object[])new Object[0]), "invoiceDate", "text-align:left;width:70px;"));
        FINANCIAL_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u603b\u91d1\u989d", (String)"InvoiceCollectPluginService_58", (String)"imc-rim-common", (Object[])new Object[0]), "totalAmount", "text-align:left;width:70px;"));
        FINANCIAL_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u5f00\u7968\u5355\u4f4d\u4ee3\u7801", (String)"InvoiceCollectPluginService_59", (String)"imc-rim-common", (Object[])new Object[0]), "invoicingPartyCode", "text-align:left;width:70px;"));
        FINANCIAL_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u5f00\u7968\u5355\u4f4d\u540d\u79f0", (String)"InvoiceCollectPluginService_60", (String)"imc-rim-common", (Object[])new Object[0]), "invoicingPartyName", "text-align:left;width:70px;"));
        FINANCIAL_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u4ea4\u6b3e\u4eba\u4ee3\u7801", (String)"InvoiceCollectPluginService_61", (String)"imc-rim-common", (Object[])new Object[0]), "payerPartyCode", "text-align:left;width:70px;"));
        FINANCIAL_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u4ea4\u6b3e\u4eba\u540d\u79f0", (String)"InvoiceCollectPluginService_62", (String)"imc-rim-common", (Object[])new Object[0]), "payerPartyName", "text-align:left;width:70px;"));
        FINANCIAL_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e", (String)"InvoiceCollectPluginService_18", (String)"imc-rim-common", (Object[])new Object[0]), "expenseNum", "text-align:left;width:70px;"));
        FINANCIAL_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7", (String)"ListFieldNameSevice_26", (String)"imc-rim-common", (Object[])new Object[0]), "orgName", "text-align:left;width:150px;overflow:hidden;", 1));
        return FINANCIAL_INVOICE_COLUMN_LIST;
    }

    private static final List<Column> ELECTRIC_ORDINARY_COLUMN_LIST() {
        ArrayList<Column> ELECTRIC_ORDINARY_COLUMN_LIST = new ArrayList<Column>(16);
        ELECTRIC_ORDINARY_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u64cd\u4f5c\u5217", (String)"InvoiceCollectPluginService_5", (String)"imc-rim-common", (Object[])new Object[0]), "operate", "text-align:left;width:70px;"));
        ELECTRIC_ORDINARY_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u63d0\u793a", (String)"InvoiceCollectPluginService_6", (String)"imc-rim-common", (Object[])new Object[0]), "status", "text-align:left;width:50px;"));
        if (InvoiceConfigUtils.showInvoiceInfo()) {
            ELECTRIC_ORDINARY_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u53d1\u7968\u4fe1\u606f", (String)"InvoiceCollectPluginService_7", (String)"imc-rim-common", (Object[])new Object[0]), "invoice_info", "text-align:left;width:230px;"));
        }
        ELECTRIC_ORDINARY_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u7968\u636e\u53f7\u7801", (String)"InvoiceCollectPluginService_57", (String)"imc-rim-common", (Object[])new Object[0]), "invoiceNo", "text-align:left;width:70px;"));
        ELECTRIC_ORDINARY_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u4ef7\u7a0e\u5408\u8ba1", (String)"InvoiceCollectPluginService_10", (String)"imc-rim-common", (Object[])new Object[0]), "totalAmount", "text-align:left;width:70px;"));
        ELECTRIC_ORDINARY_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u5f00\u7968\u65e5\u671f", (String)"InvoiceCollectPluginService_11", (String)"imc-rim-common", (Object[])new Object[0]), "invoiceDate", "text-align:left;width:70px;"));
        ELECTRIC_ORDINARY_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u4e0d\u542b\u7a0e\u91d1\u989d", (String)"InvoiceCollectPluginService_12", (String)"imc-rim-common", (Object[])new Object[0]), "invoiceAmount,amount", "text-align:left;width:70px;"));
        ELECTRIC_ORDINARY_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u7a0e\u989d", (String)"InvoiceCollectPluginService_13", (String)"imc-rim-common", (Object[])new Object[0]), "totalTaxAmount,taxAmount", "text-align:left;width:70px;"));
        ELECTRIC_ORDINARY_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u9500\u65b9\u540d\u79f0", (String)"InvoiceCollectPluginService_14", (String)"imc-rim-common", (Object[])new Object[0]), "salerName", "text-align:left;width:70px;"));
        ELECTRIC_ORDINARY_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u9500\u65b9\u7eb3\u7a0e\u8bc6\u522b\u53f7", (String)"InvoiceCollectPluginService_15", (String)"imc-rim-common", (Object[])new Object[0]), "salerTaxNo", "text-align:left;width:70px;"));
        ELECTRIC_ORDINARY_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u8d2d\u65b9\u540d\u79f0", (String)"InvoiceCollectPluginService_16", (String)"imc-rim-common", (Object[])new Object[0]), "buyerName", "text-align:left;width:70px;"));
        ELECTRIC_ORDINARY_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u8d2d\u65b9\u7eb3\u7a0e\u8bc6\u522b\u53f7", (String)"InvoiceCollectPluginService_17", (String)"imc-rim-common", (Object[])new Object[0]), "buyerTaxNo", "text-align:left;width:70px;"));
        ELECTRIC_ORDINARY_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e", (String)"InvoiceCollectPluginService_18", (String)"imc-rim-common", (Object[])new Object[0]), "expenseNum", "text-align:left;width:70px;"));
        ELECTRIC_ORDINARY_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7", (String)"ListFieldNameSevice_26", (String)"imc-rim-common", (Object[])new Object[0]), "orgName", "text-align:left;width:150px;overflow:hidden;", 1));
        return ELECTRIC_ORDINARY_COLUMN_LIST;
    }

    private static final List<Column> ELECTRIC_SPECIAL_COLUMN_LIST() {
        ArrayList<Column> ELECTRIC_SPECIAL_COLUMN_LIST = new ArrayList<Column>(16);
        ELECTRIC_SPECIAL_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u64cd\u4f5c\u5217", (String)"InvoiceCollectPluginService_5", (String)"imc-rim-common", (Object[])new Object[0]), "operate", "text-align:left;width:70px;"));
        ELECTRIC_SPECIAL_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u63d0\u793a", (String)"InvoiceCollectPluginService_6", (String)"imc-rim-common", (Object[])new Object[0]), "status", "text-align:left;width:50px;"));
        if (InvoiceConfigUtils.showInvoiceInfo()) {
            ELECTRIC_SPECIAL_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u53d1\u7968\u4fe1\u606f", (String)"InvoiceCollectPluginService_7", (String)"imc-rim-common", (Object[])new Object[0]), "invoice_info", "text-align:left;width:230px;"));
        }
        ELECTRIC_SPECIAL_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u7968\u636e\u53f7\u7801", (String)"InvoiceCollectPluginService_57", (String)"imc-rim-common", (Object[])new Object[0]), "invoiceNo", "text-align:left;width:70px;"));
        ELECTRIC_SPECIAL_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u4ef7\u7a0e\u5408\u8ba1", (String)"InvoiceCollectPluginService_10", (String)"imc-rim-common", (Object[])new Object[0]), "totalAmount", "text-align:left;width:70px;"));
        ELECTRIC_SPECIAL_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u5f00\u7968\u65e5\u671f", (String)"InvoiceCollectPluginService_11", (String)"imc-rim-common", (Object[])new Object[0]), "invoiceDate", "text-align:left;width:70px;"));
        ELECTRIC_SPECIAL_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u4e0d\u542b\u7a0e\u91d1\u989d", (String)"InvoiceCollectPluginService_12", (String)"imc-rim-common", (Object[])new Object[0]), "invoiceAmount,amount", "text-align:left;width:70px;"));
        ELECTRIC_SPECIAL_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u7a0e\u989d", (String)"InvoiceCollectPluginService_13", (String)"imc-rim-common", (Object[])new Object[0]), "totalTaxAmount,taxAmount", "text-align:left;width:70px;"));
        ELECTRIC_SPECIAL_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u9500\u65b9\u540d\u79f0", (String)"InvoiceCollectPluginService_14", (String)"imc-rim-common", (Object[])new Object[0]), "salerName", "text-align:left;width:70px;"));
        ELECTRIC_SPECIAL_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u9500\u65b9\u7eb3\u7a0e\u8bc6\u522b\u53f7", (String)"InvoiceCollectPluginService_15", (String)"imc-rim-common", (Object[])new Object[0]), "salerTaxNo", "text-align:left;width:70px;"));
        ELECTRIC_SPECIAL_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u8d2d\u65b9\u540d\u79f0", (String)"InvoiceCollectPluginService_16", (String)"imc-rim-common", (Object[])new Object[0]), "buyerName", "text-align:left;width:70px;"));
        ELECTRIC_SPECIAL_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u8d2d\u65b9\u7eb3\u7a0e\u8bc6\u522b\u53f7", (String)"InvoiceCollectPluginService_17", (String)"imc-rim-common", (Object[])new Object[0]), "buyerTaxNo", "text-align:left;width:70px;"));
        ELECTRIC_SPECIAL_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e", (String)"InvoiceCollectPluginService_18", (String)"imc-rim-common", (Object[])new Object[0]), "expenseNum", "text-align:left;width:70px;"));
        ELECTRIC_SPECIAL_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7", (String)"ListFieldNameSevice_26", (String)"imc-rim-common", (Object[])new Object[0]), "orgName", "text-align:left;width:150px;overflow:hidden;", 1));
        return ELECTRIC_SPECIAL_COLUMN_LIST;
    }

    private static final List<Column> SALERLIST_COLUMN_LIST() {
        ArrayList<Column> SALERLIST_COLUMN_LIST = new ArrayList<Column>(16);
        SALERLIST_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u64cd\u4f5c\u5217", (String)"InvoiceCollectPluginService_5", (String)"imc-rim-common", (Object[])new Object[0]), "operate", "text-align:left;width:70px;"));
        SALERLIST_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801", (String)"InvoiceCollectPluginService_8", (String)"imc-rim-common", (Object[])new Object[0]), "invoiceCode", "text-align:left;width:70px;"));
        SALERLIST_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801", (String)"InvoiceCollectPluginService_9", (String)"imc-rim-common", (Object[])new Object[0]), "invoiceNo", "text-align:left;width:70px;"));
        SALERLIST_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u5f53\u524d\u6e05\u5355\u6570\u91cf", (String)"InvoiceCollectPluginService_63", (String)"imc-rim-common", (Object[])new Object[0]), "bindNum", "text-align:left;width:70px;"));
        SALERLIST_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u6e05\u5355\u603b\u9875\u7801\u6570", (String)"InvoiceCollectPluginService_64", (String)"imc-rim-common", (Object[])new Object[0]), "salelistSum", "text-align:left;width:70px;"));
        SALERLIST_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u672c\u6b21\u4e0a\u4f20\u4efd\u6570", (String)"InvoiceCollectPluginService_65", (String)"imc-rim-common", (Object[])new Object[0]), "num", "text-align:left;width:70px;"));
        return SALERLIST_COLUMN_LIST;
    }

    private static final List<Column> AIR_ELE_INVOICE_COLUMN_LIST() {
        ArrayList<Column> AIR_ELE_INVOICE_COLUMN_LIST = new ArrayList<Column>(16);
        AIR_ELE_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u64cd\u4f5c\u5217", (String)"InvoiceCollectPluginService_5", (String)"imc-rim-common", (Object[])new Object[0]), "operate", "text-align:left;width:70px;"));
        AIR_ELE_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u63d0\u793a", (String)"InvoiceCollectPluginService_6", (String)"imc-rim-common", (Object[])new Object[0]), "status", "text-align:left;width:50px;"));
        if (InvoiceConfigUtils.showInvoiceInfo()) {
            AIR_ELE_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u53d1\u7968\u4fe1\u606f", (String)"InvoiceCollectPluginService_7", (String)"imc-rim-common", (Object[])new Object[0]), "invoice_info", "text-align:left;width:230px;"));
        }
        AIR_ELE_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u7968\u636e\u53f7\u7801", (String)"InvoiceCollectPluginService_57", (String)"imc-rim-common", (Object[])new Object[0]), "invoiceNo", "text-align:left;width:70px;"));
        AIR_ELE_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"GP\u5355\u53f7", (String)"InvoiceCollectPluginService_66", (String)"imc-rim-common", (Object[])new Object[0]), "gpOrderNo", "text-align:left;width:70px;"));
        AIR_ELE_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u65c5\u5ba2\u59d3\u540d", (String)"InvoiceCollectPluginService_67", (String)"imc-rim-common", (Object[])new Object[0]), "customerName", "text-align:left;width:70px;"));
        AIR_ELE_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u6709\u6548\u8eab\u4efd\u8bc1\u4ef6\u53f7\u7801", (String)"InvoiceCollectPluginService_68", (String)"imc-rim-common", (Object[])new Object[0]), "customerIdentityNum", "text-align:left;width:70px;"));
        AIR_ELE_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u59cb\u53d1\u7ad9", (String)"InvoiceCollectPluginService_69", (String)"imc-rim-common", (Object[])new Object[0]), "placeOfDeparture", "text-align:left;width:70px;"));
        AIR_ELE_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u76ee\u7684\u7ad9", (String)"InvoiceCollectPluginService_70", (String)"imc-rim-common", (Object[])new Object[0]), "destination", "text-align:left;width:70px;"));
        AIR_ELE_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u822a\u73ed\u53f7", (String)"InvoiceCollectPluginService_71", (String)"imc-rim-common", (Object[])new Object[0]), "flightNum", "text-align:left;width:70px;"));
        AIR_ELE_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u5ea7\u4f4d\u7b49\u7ea7", (String)"InvoiceCollectPluginService_31", (String)"imc-rim-common", (Object[])new Object[0]), "seatGrade", "text-align:left;width:70px;"));
        AIR_ELE_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u627f\u8fd0\u65e5\u671f", (String)"InvoiceCollectPluginService_72", (String)"imc-rim-common", (Object[])new Object[0]), "carrierDate", "text-align:left;width:70px;"));
        AIR_ELE_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u7968\u4ef7", (String)"InvoiceCollectPluginService_35", (String)"imc-rim-common", (Object[])new Object[0]), "ticketPrice", "text-align:left;width:70px;"));
        AIR_ELE_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u71c3\u6cb9\u9644\u52a0\u8d39", (String)"InvoiceCollectPluginService_37", (String)"imc-rim-common", (Object[])new Object[0]), "fuelSurcharge", "text-align:left;width:70px;"));
        AIR_ELE_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u589e\u503c\u7a0e\u7a0e\u7387", (String)"InvoiceCollectPluginService_73", (String)"imc-rim-common", (Object[])new Object[0]), "taxRate", "text-align:left;width:70px;"));
        AIR_ELE_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u589e\u503c\u7a0e\u7a0e\u989d", (String)"InvoiceCollectPluginService_74", (String)"imc-rim-common", (Object[])new Object[0]), "taxAmount", "text-align:left;width:70px;"));
        AIR_ELE_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u6c11\u822a\u53d1\u5c55\u57fa\u91d1", (String)"InvoiceCollectPluginService_75", (String)"imc-rim-common", (Object[])new Object[0]), "airportConstructionFee", "text-align:left;width:70px;"));
        AIR_ELE_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u5176\u4ed6\u7a0e\u8d39", (String)"InvoiceCollectPluginService_76", (String)"imc-rim-common", (Object[])new Object[0]), "otherTotalTaxAmount", "text-align:left;width:70px;"));
        AIR_ELE_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u91d1\u989d\u5408\u8ba1", (String)"InvoiceCollectPluginService_77", (String)"imc-rim-common", (Object[])new Object[0]), "totalAmount", "text-align:left;width:70px;"));
        AIR_ELE_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u7535\u5b50\u5ba2\u7968\u53f7\u7801", (String)"InvoiceCollectPluginService_78", (String)"imc-rim-common", (Object[])new Object[0]), "electronicTicketNum", "text-align:left;width:70px;"));
        AIR_ELE_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u4fdd\u9669\u8d39", (String)"InvoiceCollectPluginService_79", (String)"imc-rim-common", (Object[])new Object[0]), "insurancePremium", "text-align:left;width:70px;"));
        AIR_ELE_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u586b\u5f00\u65e5\u671f", (String)"InvoiceCollectPluginService_80", (String)"imc-rim-common", (Object[])new Object[0]), "issueDate", "text-align:left;width:70px;"));
        AIR_ELE_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7", (String)"ListFieldNameSevice_26", (String)"imc-rim-common", (Object[])new Object[0]), "orgName", "text-align:left;width:150px;overflow:hidden;", 1));
        return AIR_ELE_INVOICE_COLUMN_LIST;
    }

    private static final List<Column> TRAIN_ELE_INVOICE_COLUMN_LIST() {
        ArrayList<Column> TRAIN_ELE_INVOICE_COLUMN_LIST = new ArrayList<Column>(16);
        TRAIN_ELE_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u64cd\u4f5c\u5217", (String)"InvoiceCollectPluginService_5", (String)"imc-rim-common", (Object[])new Object[0]), "operate", "text-align:left;width:70px;"));
        TRAIN_ELE_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u63d0\u793a", (String)"InvoiceCollectPluginService_6", (String)"imc-rim-common", (Object[])new Object[0]), "status", "text-align:left;width:50px;"));
        if (InvoiceConfigUtils.showInvoiceInfo()) {
            TRAIN_ELE_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u53d1\u7968\u4fe1\u606f", (String)"InvoiceCollectPluginService_7", (String)"imc-rim-common", (Object[])new Object[0]), "invoice_info", "text-align:left;width:230px;"));
        }
        TRAIN_ELE_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u7968\u636e\u53f7\u7801", (String)"InvoiceCollectPluginService_57", (String)"imc-rim-common", (Object[])new Object[0]), "invoiceNo", "text-align:left;width:70px;"));
        TRAIN_ELE_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u5f00\u7968\u65e5\u671f", (String)"InvoiceCollectPluginService_11", (String)"imc-rim-common", (Object[])new Object[0]), "invoiceDate", "text-align:left;width:70px;"));
        TRAIN_ELE_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u51fa\u53d1\u7ad9", (String)"InvoiceCollectPluginService_81", (String)"imc-rim-common", (Object[])new Object[0]), "departureStation", "text-align:left;width:70px;"));
        TRAIN_ELE_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u5230\u8fbe\u7ad9", (String)"InvoiceCollectPluginService_82", (String)"imc-rim-common", (Object[])new Object[0]), "destinationStation", "text-align:left;width:70px;"));
        TRAIN_ELE_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u8f66\u6b21", (String)"InvoiceCollectPluginService_26", (String)"imc-rim-common", (Object[])new Object[0]), "trainNum", "text-align:left;width:70px;"));
        TRAIN_ELE_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u4e58\u8f66\u65e5\u671f", (String)"InvoiceCollectPluginService_20", (String)"imc-rim-common", (Object[])new Object[0]), "trainTime", "text-align:left;width:70px;"));
        TRAIN_ELE_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u5e2d\u522b", (String)"InvoiceCollectPluginService_83", (String)"imc-rim-common", (Object[])new Object[0]), "seatLevel", "text-align:left;width:70px;"));
        TRAIN_ELE_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u7968\u4ef7", (String)"InvoiceCollectPluginService_35", (String)"imc-rim-common", (Object[])new Object[0]), "totalAmount", "text-align:left;width:70px;"));
        TRAIN_ELE_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u7535\u5b50\u5ba2\u7968\u53f7", (String)"InvoiceCollectPluginService_84", (String)"imc-rim-common", (Object[])new Object[0]), "eleTicketNumber", "text-align:left;width:70px;"));
        TRAIN_ELE_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u8bc1\u4ef6\u53f7", (String)"InvoiceCollectPluginService_85", (String)"imc-rim-common", (Object[])new Object[0]), "idNumber", "text-align:left;width:70px;"));
        TRAIN_ELE_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u59d3\u540d", (String)"InvoiceCollectPluginService_29", (String)"imc-rim-common", (Object[])new Object[0]), "passengerName", "text-align:left;width:70px;"));
        TRAIN_ELE_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u91d1\u989d", (String)"InvoiceCollectPluginService_19", (String)"imc-rim-common", (Object[])new Object[0]), "detailAmount", "text-align:left;width:70px;"));
        TRAIN_ELE_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u7a0e\u7387", (String)"InvoiceCollectPluginService_86", (String)"imc-rim-common", (Object[])new Object[0]), "taxRate", "text-align:left;width:70px;"));
        TRAIN_ELE_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u7a0e\u989d", (String)"InvoiceCollectPluginService_13", (String)"imc-rim-common", (Object[])new Object[0]), "taxAmount", "text-align:left;width:70px;"));
        TRAIN_ELE_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u539f\u53d1\u7968\u53f7\u7801", (String)"InvoiceCollectPluginService_87", (String)"imc-rim-common", (Object[])new Object[0]), "originalInvoiceNo", "text-align:left;width:70px;"));
        TRAIN_ELE_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7", (String)"ListFieldNameSevice_26", (String)"imc-rim-common", (Object[])new Object[0]), "orgName", "text-align:left;width:150px;overflow:hidden;", 1));
        return TRAIN_ELE_INVOICE_COLUMN_LIST;
    }

    private static List<Column> getColumnListByInvoiceType(Long invoiceType) {
        if (InputInvoiceTypeEnum.ORDINARY_ELECTRON.getCode().equals(invoiceType)) {
            return InvoiceCollectPluginService.ORDINARY_ELECTRON_COLUMN_LIST();
        }
        if (InputInvoiceTypeEnum.SPECIAL_ELECTRON.getCode().equals(invoiceType)) {
            return InvoiceCollectPluginService.SPECIAL_ELECTRON_COLUMN_LIST();
        }
        if (InputInvoiceTypeEnum.ORDINARY_PAPER.getCode().equals(invoiceType)) {
            return InvoiceCollectPluginService.ORDINARY_PAPER_COLUMN_LIST();
        }
        if (InputInvoiceTypeEnum.SPECIAL_PAPER.getCode().equals(invoiceType)) {
            return InvoiceCollectPluginService.SPECIAL_PAPER_COLUMN_LIST();
        }
        if (InputInvoiceTypeEnum.ORDINARY_ROLL.getCode().equals(invoiceType)) {
            return InvoiceCollectPluginService.ORDINARY_ROLL_COLUMN_LIST();
        }
        if (InputInvoiceTypeEnum.GENERAL_PAPER.getCode().equals(invoiceType)) {
            return InvoiceCollectPluginService.GENERAL_PAPER_COLUMN_LIST();
        }
        if (InputInvoiceTypeEnum.GENERAL_ELECTRON.getCode().equals(invoiceType)) {
            return InvoiceCollectPluginService.GENERAL_ELECTRON_COLUMN_LIST();
        }
        if (InputInvoiceTypeEnum.TAXI_INVOICE.getCode().equals(invoiceType)) {
            return InvoiceCollectPluginService.TAXI_INVOICE_COLUMN_LIST();
        }
        if (InputInvoiceTypeEnum.TRAIN_INVOICE.getCode().equals(invoiceType)) {
            return InvoiceCollectPluginService.TRAIN_INVOICE_COLUMN_LIST();
        }
        if (InputInvoiceTypeEnum.AIR_INVOICE.getCode().equals(invoiceType)) {
            return InvoiceCollectPluginService.AIR_INVOICE_COLUMN_LIST();
        }
        if (InputInvoiceTypeEnum.OTHER_INVOICE.getCode().equals(invoiceType)) {
            return InvoiceCollectPluginService.OTHER_INVOICE_COLUMN_LIST();
        }
        if (InputInvoiceTypeEnum.MOTOR_INVOICE.getCode().equals(invoiceType)) {
            return InvoiceCollectPluginService.MOTOR_INVOICE_COLUMN_LIST();
        }
        if (InputInvoiceTypeEnum.USEDCAR_INVOICE.getCode().equals(invoiceType)) {
            return InvoiceCollectPluginService.USEDCAR_INVOICE_COLUMN_LIST();
        }
        if (InputInvoiceTypeEnum.QUOTA_INVOICE.getCode().equals(invoiceType)) {
            return InvoiceCollectPluginService.QUOTA_INVOICE_COLUMN_LIST();
        }
        if (InputInvoiceTypeEnum.TOLL_ELECTRON.getCode().equals(invoiceType)) {
            return InvoiceCollectPluginService.TOLL_ELECTRON_COLUMN_LIST();
        }
        if (InputInvoiceTypeEnum.TRANSPORT_INVOICE.getCode().equals(invoiceType)) {
            return InvoiceCollectPluginService.TRANSPORT_INVOICE_COLUMN_LIST();
        }
        if (InputInvoiceTypeEnum.ROAD_BRIDGE.getCode().equals(invoiceType)) {
            return InvoiceCollectPluginService.ROAD_BRIDGE_COLUMN_LIST();
        }
        if (InputInvoiceTypeEnum.TAX_PROOF.getCode().equals(invoiceType)) {
            return InvoiceCollectPluginService.TAX_PROOF_COLUMN_LIST();
        }
        if (InputInvoiceTypeEnum.BOAT_INVOICE.getCode().equals(invoiceType)) {
            return InvoiceCollectPluginService.BOAT_INVOICE_COLUMN_LIST();
        }
        if (InputInvoiceTypeEnum.HGJKS.getCode().equals(invoiceType)) {
            return InvoiceCollectPluginService.HGJKS_INVOICE_COLUMN_LIST();
        }
        if (InputInvoiceTypeEnum.TRAIN_REFUND.getCode().equals(invoiceType)) {
            return InvoiceCollectPluginService.TRAIN_REFUND_COLUMN_LIST();
        }
        if (InputInvoiceTypeEnum.FINANCIAL_INVOICE.getCode().equals(invoiceType)) {
            return InvoiceCollectPluginService.FINANCIAL_INVOICE_COLUMN_LIST();
        }
        if (InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getCode().equals(invoiceType)) {
            return InvoiceCollectPluginService.ELECTRIC_ORDINARY_COLUMN_LIST();
        }
        if (InputInvoiceTypeEnum.ELECTRIC_SPECIAL.getCode().equals(invoiceType)) {
            return InvoiceCollectPluginService.ELECTRIC_SPECIAL_COLUMN_LIST();
        }
        if (typeofsalerlist.equals(invoiceType)) {
            return InvoiceCollectPluginService.SALERLIST_COLUMN_LIST();
        }
        if (InputInvoiceTypeEnum.AIR_ELE_INVOICE.getCode().equals(invoiceType)) {
            return InvoiceCollectPluginService.AIR_ELE_INVOICE_COLUMN_LIST();
        }
        if (InputInvoiceTypeEnum.TRAIN_ELE_INVOICE.getCode().equals(invoiceType)) {
            return InvoiceCollectPluginService.TRAIN_ELE_INVOICE_COLUMN_LIST();
        }
        if (InputInvoiceTypeEnum.OVERSEA_INVOICE.getCode().equals(invoiceType)) {
            return InvoiceCollectPluginService.OVERSEA_INVOICE_COLUMN_LIST();
        }
        if (InputInvoiceTypeEnum.MOTOR_ELE_INVOICE.getCode().equals(invoiceType)) {
            return InvoiceCollectPluginService.MOTOR_INVOICE_ELE_COLUMN_LIST();
        }
        if (InputInvoiceTypeEnum.USEDCAR_ELE_INVOICE.getCode().equals(invoiceType)) {
            return InvoiceCollectPluginService.USEDCAR_INVOICE_ELE_COLUMN_LIST();
        }
        return null;
    }

    private static List<Column> OVERSEA_INVOICE_COLUMN_LIST() {
        ArrayList<Column> OVERSEA_INVOICE_COLUMN_LIST = new ArrayList<Column>(16);
        OVERSEA_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u64cd\u4f5c\u5217", (String)"InvoiceCollectPluginService_5", (String)"imc-rim-common", (Object[])new Object[0]), "operate", "text-align:left;width:70px;"));
        OVERSEA_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u63d0\u793a", (String)"InvoiceCollectPluginService_6", (String)"imc-rim-common", (Object[])new Object[0]), "status", "text-align:left;width:50px;"));
        if (InvoiceConfigUtils.showInvoiceInfo()) {
            OVERSEA_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u53d1\u7968\u4fe1\u606f", (String)"InvoiceCollectPluginService_7", (String)"imc-rim-common", (Object[])new Object[0]), "invoice_info", "text-align:left;width:230px;"));
        }
        OVERSEA_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u7968\u636e\u53f7\u7801", (String)"InvoiceCollectPluginService_57", (String)"imc-rim-common", (Object[])new Object[0]), "invoiceNo", "text-align:left;width:70px;"));
        OVERSEA_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u5f00\u7968\u65e5\u671f", (String)"InvoiceCollectPluginService_11", (String)"imc-rim-common", (Object[])new Object[0]), "invoiceDate", "text-align:left;width:70px;"));
        OVERSEA_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u539f\u5e01\u91d1\u989d", (String)"InvoiceCollectPluginService_91", (String)"imc-rim-common", (Object[])new Object[0]), "totalAmount", "text-align:left;width:70px;"));
        OVERSEA_INVOICE_COLUMN_LIST.add(new Column(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7", (String)"ListFieldNameSevice_26", (String)"imc-rim-common", (Object[])new Object[0]), "orgName", "text-align:left;width:150px;overflow:hidden;", 1));
        return OVERSEA_INVOICE_COLUMN_LIST;
    }

    private static void updateColumn(Column column, List<Column> data, JSONObject obj, int i) {
        String level = (String)obj.get((Object)"errorLevel");
        String contextPath = RequestContext.get().getClientFullContextPath();
        StringBuilder text = new StringBuilder();
        if ("operate".equals(column.getField())) {
            if (typeofsalerlist.equals(obj.getLong("invoiceType"))) {
                text.append("</span><span class=\"_2fitdDwA unukSyOk kdfont kdfont-yanjing kd-hover-color click_class\" clickkey=\"viewAttach\" title=\"").append(ResManager.loadKDString((String)"\u9884\u89c8", (String)"InvoiceCollectPluginService_88", (String)"imc-rim-common", (Object[])new Object[0])).append("\"></span>");
            } else if (InvoiceCollectPluginService.canEdit(obj).booleanValue()) {
                text.append("</span><span class=\"_2fitdDwA unukSyOk kdfont kdfont-bianji kd-hover-color click_class\" clickkey=\"viewInvoice\" title=\"").append(ResManager.loadKDString((String)"\u7f16\u8f91", (String)"InvoiceCollectPluginService_89", (String)"imc-rim-common", (Object[])new Object[0])).append("\"></span>");
            } else {
                text.append("</span><span class=\"_2fitdDwA unukSyOk kdfont kdfont-yanjing kd-hover-color click_class\" clickkey=\"viewInvoice\" title=\"").append(ResManager.loadKDString((String)"\u9884\u89c8", (String)"InvoiceCollectPluginService_88", (String)"imc-rim-common", (Object[])new Object[0])).append("\"></span>");
            }
        } else if ("status".equals(column.getField())) {
            String icons = null;
            if ("0".equals(level) || "1".equals(level)) {
                icons = "icons/pc/state/fail_28_28.png";
            } else if ("2".equals(level)) {
                icons = "icons/pc/state/remind_28_28.png";
            }
            if (icons != null) {
                if (i > 4) {
                    text.append("<a class=\"outTipsText topTip\"><img class=\"tipIcon\" src=\"");
                } else {
                    text.append("<a class=\"outTipsText bottomTip\"><img class=\"tipIcon\" src=\"");
                }
                text.append(contextPath);
                text.append(icons).append("\"/><div class=\"tipsText\" style=\"display:none;\">");
                text.append(obj.getString("validateMessage_html"));
                text.append("</div></a>&nbsp;");
            } else {
                text.append("");
            }
        } else if ("invoice_info".equals(column.getField())) {
            text.append(InvoiceCollectPluginService.getImageKey(contextPath, obj.getString(column.getField())));
        } else if ("expenseNum".equals(column.getField())) {
            Object value = Optional.ofNullable(obj.get((Object)column.getField())).orElse("");
            String valueStr = value.toString();
            if (!",".equals(valueStr)) {
                String[] valueKeys = valueStr.split(",");
                String valueName = valueKeys[0];
                if (valueKeys.length > 1) {
                    valueName = valueName + "...";
                }
                text.append("</span><span class=\"f3ijJpks _3mxww4IO link-color  grid-hyper-link click_class\" clickkey=\"openInvoice\"");
                text.append("title=\"").append(valueStr).append("\">").append(valueName);
                text.append("</span>");
            }
        } else {
            Object value = null;
            if (column.getField().contains(",")) {
                String[] valueKeys;
                for (String valueKey : valueKeys = column.getField().split(",")) {
                    if (obj.get((Object)valueKey) == null || !StringUtils.isNotEmpty((CharSequence)obj.get((Object)valueKey).toString())) continue;
                    value = obj.get((Object)valueKey);
                }
            } else {
                value = obj.get((Object)column.getField());
            }
            if (value == null) {
                text.append("");
            } else if ("totalTaxAmount".equals(column.getField()) || "totalAmount".equals(column.getField()) || "airportConstructionFee".equals(column.getField()) || "fuelSurcharge".equals(column.getField())) {
                if (InputInvoiceTypeEnum.containCurrencyId(obj.getLong("invoiceType"))) {
                    BigDecimal bigDecimalValue = BigDecimalUtil.transDecimal(value);
                    int scale = bigDecimalValue.scale();
                    String format1 = CurrencyUtils.getDeliFormatByPrecision(scale);
                    text.append(BigDecimalUtil.format(bigDecimalValue, format1));
                } else {
                    text.append(BigDecimalUtil.format(BigDecimalUtil.transDecimal(value), format));
                }
            } else if (column.isEncrypt()) {
                text.append(InvoiceConvertService.encrypt(value));
            } else {
                text.append(DynamicObjectUtil.htmlEncode(value));
            }
        }
        data.add(column.clone(text.toString()));
    }

    private static String getImageKey(String contextPath, String invoiceInfo) {
        if (invoiceInfo == null) {
            return "";
        }
        if (MapUtils.isEmpty(imgMap)) {
            imgMap = InvoiceCollectPluginService.getImgMap();
        }
        String[] items = invoiceInfo.split(",");
        StringBuilder sb = new StringBuilder();
        for (String item : items) {
            ValueMapItem img;
            if (imgMap == null || (img = imgMap.get(item)) == null || img.getImageKey() == null) continue;
            sb.append("<img src=\"").append(contextPath).append(img.getImageKey().substring(1));
            sb.append("\" title=\"").append(img.getName()).append("\"/>&nbsp;");
        }
        return sb.toString();
    }

    private static Map<String, ValueMapItem> getImgMap() {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"rim_invoice");
        DataEntityPropertyCollection mainPros = mainEntityType.getProperties();
        HashMap<String, ValueMapItem> map = new HashMap<String, ValueMapItem>(16);
        for (IDataEntityProperty property : mainPros) {
            if (!property.getName().equals("invoice_info")) continue;
            MulComboProp prop = (MulComboProp)property;
            List items = prop.getComboItems();
            for (ValueMapItem item : items) {
                map.put(item.getValue(), item);
            }
            return map;
        }
        return null;
    }

    public static Boolean canEdit(JSONObject invoiceJson) {
        String expenseStatus = invoiceJson.getString("expenseStatus");
        if (StringUtils.isNotEmpty((CharSequence)expenseStatus) && !"1".equals(expenseStatus)) {
            return Boolean.FALSE;
        }
        String invoiceType = invoiceJson.getString("invoiceType");
        String checkStatus = invoiceJson.getString("checkStatus");
        Long type = InputInvoiceTypeEnum.getInvoiceTypeByAwsType(invoiceType);
        if (InputInvoiceTypeEnum.needCheck(type).booleanValue() && "1".equals(checkStatus)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static Boolean canEditInvoice(JSONObject invoiceJson) {
        String expenseStatus = invoiceJson.getString("expenseStatus");
        if (StringUtils.isNotEmpty((CharSequence)expenseStatus) && !"1".equals(expenseStatus)) {
            return Boolean.FALSE;
        }
        String invoiceType = invoiceJson.getString("invoiceType");
        String checkStatus = invoiceJson.getString("checkStatus");
        String invoiceInfo = invoiceJson.getString("invoice_info");
        Long type = InputInvoiceTypeEnum.getInvoiceTypeByAwsType(invoiceType);
        if (InputInvoiceTypeEnum.needCheck(type).booleanValue() && "1".equals(checkStatus) && invoiceInfo.indexOf("ch_1") != -1) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static JSONObject getInvoiceDataCache(String pageId) {
        String cache = new PageCache(pageId).get(CACHE_INVOICE_DATA);
        if (StringUtils.isNotEmpty((CharSequence)cache)) {
            return JSON.parseObject((String)cache, (Feature[])new Feature[]{Feature.OrderedField});
        }
        return new JSONObject();
    }

    public static void setInvoiceDataCache(String pageId, String data) {
        new PageCache(pageId).put(CACHE_INVOICE_DATA, data);
    }

    public static void setInvoiceSignSuccessCache(String pageId, String data) {
        new PageCache(pageId).put(SUCCESS_SIGN_INVOICE, data);
    }

    public static String getInvoiceSignSuccessCache(String pageId) {
        String cache = new PageCache(pageId).get(SUCCESS_SIGN_INVOICE);
        if (StringUtils.isNotEmpty((CharSequence)cache)) {
            return cache;
        }
        return null;
    }

    public static void setInvoiceSignFailCache(String pageId, String data) {
        new PageCache(pageId).put(FAIL_SIGN_INVOICE, data);
    }

    public static String getInvoiceSignFailCache(String pageId) {
        String cache = new PageCache(pageId).get(FAIL_SIGN_INVOICE);
        if (StringUtils.isNotEmpty((CharSequence)cache)) {
            return cache;
        }
        return null;
    }

    public static void setSerialNoCache(String pageId, String data) {
        new PageCache(pageId).put("serialnolist", data);
    }

    public static String getSerialNoCache(String pageId) {
        String cache = new PageCache(pageId).get("serialnolist");
        if (StringUtils.isNotEmpty((CharSequence)cache)) {
            return cache;
        }
        return null;
    }

    public static JSONObject getInvoiceSeqCache(String pageId) {
        String cache = new PageCache(pageId).get(CACHE_INV_SIGN_SEQ_DATA);
        if (StringUtils.isNotEmpty((CharSequence)cache)) {
            return JSON.parseObject((String)cache);
        }
        return new JSONObject();
    }

    public static void setInvoiceSeqCache(String pageId, String data) {
        new PageCache(pageId).put(CACHE_INV_SIGN_SEQ_DATA, data);
    }

    public static JSONObject getInvoiceVerifyCache(String pageId) {
        String cache = new PageCache(pageId).get(CACHE_INVOICE_VERIFY_DATA);
        if (StringUtils.isNotEmpty((CharSequence)cache)) {
            return JSON.parseObject((String)cache);
        }
        return new JSONObject();
    }

    public static void setInvoiceVerifyCache(String pageId, String data) {
        new PageCache(pageId).put(CACHE_INVOICE_VERIFY_DATA, data);
    }

    public AbstractFormPlugin getPlugin() {
        return this.plugin;
    }

    public void setPlugin(AbstractFormPlugin plugin) {
        this.plugin = plugin;
    }

    private static void countSuccessAndFail(String pageId, JSONObject invoice) {
        String serialno = invoice.getString("serialNo");
        String serialnocache = InvoiceCollectPluginService.getSerialNoCache(pageId);
        if (serialnocache == null) {
            serialnocache = "";
        }
        List serialnoList = Arrays.stream(serialnocache.split(",")).collect(Collectors.toList());
        boolean containflag = serialnoList.contains(serialno);
        if ("1".equals(invoice.getString("originalState"))) {
            if (InvoiceCollectPluginService.getInvoiceSignSuccessCache(pageId) == null) {
                InvoiceCollectPluginService.setInvoiceSignSuccessCache(pageId, "1");
                InvoiceCollectPluginService.setSerialNoCache(pageId, serialnocache + "," + serialno);
            } else if (!containflag) {
                InvoiceCollectPluginService.setInvoiceSignSuccessCache(pageId, InvoiceCollectPluginService.StringAddOne(InvoiceCollectPluginService.getInvoiceSignSuccessCache(pageId)));
                InvoiceCollectPluginService.setSerialNoCache(pageId, serialnocache + "," + serialno);
            }
        } else if (InvoiceCollectPluginService.getInvoiceSignFailCache(pageId) == null) {
            InvoiceCollectPluginService.setInvoiceSignFailCache(pageId, "1");
            InvoiceCollectPluginService.setSerialNoCache(pageId, serialnocache + "," + serialno);
        } else if (!containflag) {
            InvoiceCollectPluginService.setInvoiceSignFailCache(pageId, InvoiceCollectPluginService.StringAddOne(InvoiceCollectPluginService.getInvoiceSignFailCache(pageId)));
            InvoiceCollectPluginService.setSerialNoCache(pageId, serialnocache + "," + serialno);
        }
    }

    private static String StringAddOne(String numberStr) {
        long number = Long.parseLong(numberStr);
        return Long.toString(++number);
    }
}

