/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.collector;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.expense.service.ExpenseService;
import kd.imc.rim.common.expense.service.VoucherService;
import kd.imc.rim.common.helper.RecognitionCheckHelper;
import kd.imc.rim.common.invoice.collector.InvoiceCollectService;
import kd.imc.rim.common.invoice.save.ExcelInvoiceSaveService;
import kd.imc.rim.common.invoice.save.InvoiceSaveService;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.ImcConfigUtil;
import kd.imc.rim.common.utils.InvoiceConvertUtils;
import kd.imc.rim.common.utils.MetadataUtil;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.common.utils.UUID;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class InvoiceExcelImportTask
implements Runnable {
    private static Log logger = LogFactory.getLog(InvoiceExcelImportTask.class);
    public static final String excelFileIdCacheKey = "excel_file_id";
    private RequestContext rc;
    private String fileUrl;
    private String fileName;
    private List<Future<JSONObject>> futureList;
    private Workbook workbook;
    private Map<String, Integer> sheetIndexMap;

    public static String getExcelImportStatus() {
        String userId = RequestContext.get().getUserId();
        JSONArray keys = JSONArray.parseArray((String)CacheHelper.get(excelFileIdCacheKey + userId));
        if (CollectionUtils.isEmpty((Collection)keys)) {
            return "0";
        }
        String resultId = keys.getString(keys.size() - 1);
        String resultStr = CacheHelper.get(resultId);
        if (StringUtils.isBlank((CharSequence)resultStr)) {
            return "0";
        }
        JSONObject resultJson = JSONObject.parseObject((String)resultStr);
        String excelStatus = resultJson.getString("resolve_status");
        if (StringUtils.isBlank((CharSequence)excelStatus)) {
            return "0";
        }
        return excelStatus;
    }

    public InvoiceExcelImportTask(RequestContext rc, List<Future<JSONObject>> futureList, String fileName, String fileUrl, Workbook workbook, Map<String, Integer> sheetIndexMap) {
        this.rc = rc;
        this.fileUrl = fileUrl;
        this.fileName = fileName;
        this.futureList = futureList;
        this.workbook = workbook;
        this.sheetIndexMap = sheetIndexMap;
    }

    @Override
    public void run() {
        RequestContext.copyAndSet((RequestContext)this.rc);
        this.doTask();
    }

    private void doTask() {
        String excelImportStatus = "1";
        JSONObject excelImportResult = new JSONObject();
        String fileId = UUID.randomUUID();
        excelImportResult.put("file_num", (Object)fileId);
        excelImportResult.put("resolve_status", (Object)excelImportStatus);
        this.cacheImportResult(excelImportResult);
        String fileKey = excelFileIdCacheKey + RequestContext.get().getUserId();
        String cache = CacheHelper.get(fileKey);
        JSONArray fileIds = cache == null ? new JSONArray() : JSONArray.parseArray((String)cache);
        int timeout = CommonUtils.getTempFileMaxTimeout();
        if (!fileIds.contains((Object)fileId)) {
            fileIds.add((Object)fileId);
            CacheHelper.put(fileKey, fileIds.toJSONString(), timeout);
        }
        CacheHelper.put(fileId, excelImportResult.toJSONString(), timeout);
        JSONArray checkParamList = new JSONArray();
        Long invoiceType = null;
        JSONObject checkParamMap = new JSONObject();
        Boolean isEmptySheet = Boolean.TRUE;
        ByteArrayOutputStream os = null;
        ByteArrayInputStream fin = null;
        try {
            for (Future<JSONObject> future : this.futureList) {
                JSONArray tableArray;
                if (ObjectUtils.isEmpty(future)) continue;
                JSONObject obj = future.get();
                String tableName = obj.getString("table");
                String sheetName = obj.getString("sheetName");
                String sheetId = obj.getString("sheetId");
                Sheet currentSheet = this.workbook.getSheetAt(this.sheetIndexMap.get(sheetId).intValue());
                Row paramRow = currentSheet.getRow(2);
                int writeCellNum = paramRow.getPhysicalNumberOfCells();
                Row resultRow = currentSheet.getRow(3);
                resultRow.createCell(writeCellNum).setCellValue(ResManager.loadKDString((String)"\u5bfc\u5165\u7ed3\u679c", (String)"InvoiceExcelImportTask_0", (String)"imc-rim-common", (Object[])new Object[0]));
                if (!"general".equals(sheetId) && !"special".equals(sheetId)) {
                    invoiceType = Long.parseLong(sheetId);
                }
                if (CollectionUtils.isEmpty((Collection)(tableArray = obj.getJSONArray("data")))) continue;
                isEmptySheet = Boolean.FALSE;
                ArrayList<JSONObject> rowList = new ArrayList<JSONObject>(tableArray.size());
                JSONObject excelResult = new JSONObject();
                HashSet<String> savedSerialNos = new HashSet<String>(tableArray.size());
                String checkConfig = ImcConfigUtil.getValue("rim_config", "need_check");
                Boolean needCheck = Boolean.TRUE;
                if (!StringUtils.isBlank((CharSequence)checkConfig) && "0".equals(checkConfig)) {
                    needCheck = Boolean.FALSE;
                }
                HashSet<String> invoiceKeys = new HashSet<String>(tableArray.size());
                Boolean existFailed = Boolean.FALSE;
                for (int i = 0; i < tableArray.size(); ++i) {
                    long start = System.currentTimeMillis();
                    try {
                        Row resultDataRow;
                        Object tableObject = tableArray.get(i);
                        if (ObjectUtils.isEmpty((Object)tableObject)) {
                            Row resultDataRow2 = currentSheet.getRow(i + 4);
                            resultDataRow2.createCell(writeCellNum).setCellValue(ResManager.loadKDString((String)"\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u6309\u683c\u5f0f\u8981\u6c42\u6b63\u786e\u586b\u5165\u6570\u636e", (String)"InvoiceExcelImportTask_1", (String)"imc-rim-common", (Object[])new Object[0]));
                            continue;
                        }
                        JSONObject fieldObject = JSONObject.parseObject((String)JSONObject.toJSONString((Object)tableObject));
                        int maxRow = BigDecimalUtil.transDecimal(RimConfigUtils.getConfig("excel_maxrow")).intValue();
                        if (maxRow < 1) {
                            maxRow = 3000;
                        }
                        if (tableArray.size() > maxRow) {
                            resultDataRow = currentSheet.getRow(i + 4);
                            String msg = String.format(ResManager.loadKDString((String)"\u8d85\u8fc7%1$s\u884c\u7684sheet\u4e0d\u5904\u7406\uff0c\u6bcf\u4e2asheet\u7684\u884c\u6570\u76ee\u524d\u4e0d\u5141\u8bb8\u8d85\u8fc7%2$s\uff0c\u8bf7\u4fee\u6539excel", (String)"InvoiceExcelImportTask_52", (String)"imc-rim-common", (Object[])new Object[0]), maxRow, maxRow);
                            resultDataRow.createCell(writeCellNum).setCellValue(msg);
                            break;
                        }
                        if (fieldObject.getBoolean("isResolveError") != null && fieldObject.getBoolean("isResolveError").booleanValue()) {
                            resultDataRow = currentSheet.getRow(i + 4);
                            resultDataRow.createCell(writeCellNum).setCellValue(fieldObject.getString("resolveErrorMsg"));
                            existFailed = Boolean.TRUE;
                            continue;
                        }
                        String commonRuleCheckResult = this.checkCommonRule(fieldObject);
                        if (StringUtils.isNotBlank((CharSequence)commonRuleCheckResult)) {
                            Row resultDataRow3 = currentSheet.getRow(i + 4);
                            resultDataRow3.createCell(writeCellNum).setCellValue(commonRuleCheckResult);
                            existFailed = Boolean.TRUE;
                            continue;
                        }
                        excelResult = JSONObject.parseObject((String)fieldObject.toJSONString());
                        JSONObject saveResult = new JSONObject();
                        String tag = fieldObject.getString("tag");
                        String tagTips = "";
                        if (StringUtils.isNotBlank((CharSequence)tag) && tag.length() > 50) {
                            tag = tag.substring(0, 50);
                            fieldObject.put("tag", (Object)tag);
                            tagTips = ResManager.loadKDString((String)"\u53d1\u7968\u6807\u6ce8\u957f\u5ea6\u8d85\u8fc750\uff0c\u5df2\u622a\u53d6;", (String)"InvoiceExcelImportTask_3", (String)"imc-rim-common", (Object[])new Object[0]);
                        }
                        if (StringUtils.isBlank((Object)fieldObject.get((Object)"original_state"))) {
                            fieldObject.remove((Object)"original_state");
                            fieldObject.remove((Object)"original_time");
                            fieldObject.remove((Object)"receiver");
                        }
                        if ("general".equals(sheetId) || "special".equals(sheetId) || InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getCode().toString().equals(sheetId) || InputInvoiceTypeEnum.ELECTRIC_SPECIAL.getCode().toString().equals(sheetId)) {
                            String invoiceCode;
                            String vatRuleCheckResult = this.checkVatStandardRule(fieldObject, needCheck);
                            if (StringUtils.isNotBlank((CharSequence)vatRuleCheckResult)) {
                                Row resultDataRow4 = currentSheet.getRow(i + 4);
                                resultDataRow4.createCell(writeCellNum).setCellValue(vatRuleCheckResult);
                                existFailed = Boolean.TRUE;
                                continue;
                            }
                            if (needCheck.booleanValue()) {
                                String totalAmount;
                                InvoiceCollectService invoiceCollectService = new InvoiceCollectService();
                                invoiceCode = fieldObject.getString("invoice_code");
                                String invoiceNo = fieldObject.getString("invoice_no");
                                String invoice_amount = fieldObject.getString("invoice_amount");
                                BigDecimal invoiceAmount = BigDecimal.ZERO;
                                if (StringUtils.isNotEmpty((CharSequence)invoice_amount)) {
                                    invoiceAmount = new BigDecimal(invoice_amount);
                                }
                                if (StringUtils.isNotEmpty((CharSequence)invoiceNo) && invoiceNo.length() == 20 && StringUtils.isNotEmpty((CharSequence)(totalAmount = fieldObject.getString("total_amount")))) {
                                    invoiceAmount = new BigDecimal(totalAmount);
                                }
                                JSONObject businessParam = new JSONObject();
                                businessParam.put("org_id", fieldObject.get((Object)"org"));
                                businessParam.put("needUserRelation", (Object)"0");
                                JSONObject checkResultJson = invoiceCollectService.checkInvoice(invoiceCode, invoiceNo, invoiceType, fieldObject.getString("invoice_date"), invoiceAmount, fieldObject.getString("check_code"), businessParam);
                                logger.info(tableName + "\u7b2c" + (i + 1) + "\u884c\u67e5\u9a8c\u7ed3\u679c\uff1a" + checkResultJson);
                                if (checkResultJson != null) {
                                    logger.info(tableName + "\u7b2c" + (i + 1) + "\u884capi\u67e5\u9a8c\u8017\u65f6\u7edf\u8ba1\u4fe1\u606f:" + (System.currentTimeMillis() - start) + "===" + checkResultJson.getString("costTime"));
                                }
                                if (checkResultJson != null && "0000".equals(checkResultJson.getString("errcode"))) {
                                    JSONObject invoice = checkResultJson.getJSONObject("data");
                                    this.setVATProperties(fieldObject, invoice);
                                    invoice.put("fileName", (Object)this.fileName);
                                    invoice.put("fileIndex", (Object)(i + 1));
                                    invoice.put("originalState", fieldObject.get((Object)"original_state"));
                                    invoice.put("originalTime", fieldObject.get((Object)"original_time"));
                                    invoice.put("receiver", fieldObject.get((Object)"receiver"));
                                    invoice.put("collect_type", fieldObject.get((Object)"collect_type"));
                                    invoice.put("excel_all_invoice_import", (Object)"1");
                                    if (!InputInvoiceTypeEnum.ELECTRIC_SPECIAL.getCode().equals(invoiceType) && !InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getCode().equals(invoiceType)) {
                                        String invoiceTypeAws = InvoiceConvertUtils.checkInvoiceType(fieldObject.getString("invoice_code"), fieldObject.getString("invoice_no"));
                                        invoiceType = InputInvoiceTypeEnum.getInvoiceTypeByAwsType(invoiceTypeAws);
                                    }
                                    if (InputInvoiceTypeEnum.isExistEtaxInvoiceNo(invoiceType) && StringUtils.isNotBlank((Object)fieldObject.get((Object)"electronic_no"))) {
                                        if ("-".equals(fieldObject.getString("electronic_no"))) {
                                            invoice.put("electronicNo", (Object)fieldObject.getString("electronic_no"));
                                        } else if (InvoiceConvertUtils.checkElectronicNo(fieldObject.getString("electronic_no"))) {
                                            logger.info("\u6570\u7535\u7968\u957f\u5ea6\u6ee1\u8db320\u4f4d\u8981\u6c42\uff0c \u6570\u7535\u7968\u53f7\u7801\uff1a{}", (Object)fieldObject.getString("electronic_no"));
                                            invoice.put("electronicNo", (Object)fieldObject.getString("electronic_no"));
                                        }
                                    }
                                    InvoiceSaveService invoiceSaveService = new InvoiceSaveService();
                                    invoiceSaveService.notOverrideOrg(invoice);
                                    invoice.put("needUserRelation", (Object)"0");
                                    saveResult = invoiceCollectService.saveInvoice(invoice, null, null);
                                    saveResult.put("serial_no", invoice.get((Object)"serialNo"));
                                    saveResult.put("expense_num", fieldObject.get((Object)"expense_num"));
                                    saveResult.put("resource", fieldObject.get((Object)"resource"));
                                    saveResult.put("expense_status", fieldObject.get((Object)"expense_status"));
                                    saveResult.put("account_date", fieldObject.get((Object)"account_date"));
                                    saveResult.put("vouch_no", fieldObject.get((Object)"vouch_no"));
                                    saveResult.put("original_state", fieldObject.get((Object)"original_state"));
                                    logger.info("\u5f53\u524d\u53d1\u7968\u7684\u7b7e\u6536\u72b6\u6001\uff1a" + fieldObject.get((Object)"original_state") + "\u5f53\u524d\u7684\u53d1\u7968\u53f7" + ":" + fieldObject.getString("invoice_no") + "\u53d1\u7968\u4ee3\u7801" + "\uff1a" + fieldObject.getString("invoice_code") + "\u5e8f\u5217\u53f7" + "1\uff1a" + invoice.get((Object)"serialNo") + "\u5e8f\u5217\u53f7" + "2:" + fieldObject.get((Object)"serialNo") + "\u5e8f\u5217\u53f7" + "3\uff1a" + saveResult.get((Object)"serialNo"));
                                } else if (checkResultJson != null) {
                                    saveResult.put("checkFail", (Object)String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25:\u589e\u503c\u7a0e\u53d1\u7968\u67e5\u9a8c\u5931\u8d25\uff0c\u9519\u8bef\u7f16\u7801:%1$s,\u67e5\u9a8c\u72b6\u6001:%2$s,\u9519\u8bef\u63cf\u8ff0\uff1a%3$s", (String)"InvoiceExcelImportTask_4", (String)"imc-rim-common", (Object[])new Object[0]), checkResultJson.getString("errcode"), checkResultJson.getString("checkStatus"), checkResultJson.getString("description")));
                                    existFailed = Boolean.TRUE;
                                } else {
                                    saveResult.put("checkFail", (Object)ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25:\u589e\u503c\u7a0e\u53d1\u7968\u67e5\u9a8c\u5931\u8d25", (String)"InvoiceExcelImportTask_5", (String)"imc-rim-common", (Object[])new Object[0]));
                                    existFailed = Boolean.TRUE;
                                }
                            } else {
                                String checkStatus;
                                String invoiceNo = fieldObject.getString("invoice_no");
                                invoiceCode = fieldObject.getString("invoice_code");
                                String invoiceKey = null;
                                invoiceKey = StringUtils.isNotEmpty((CharSequence)invoiceCode) ? invoiceCode.concat(invoiceNo) : invoiceNo;
                                if (CollectionUtils.isEmpty(invoiceKeys) || !invoiceKeys.contains(invoiceKey)) {
                                    fieldObject.put("needClear", (Object)Boolean.TRUE);
                                }
                                if (!InputInvoiceTypeEnum.ELECTRIC_SPECIAL.getCode().equals(invoiceType) && !InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getCode().equals(invoiceType)) {
                                    String invoiceTypeAws = InvoiceConvertUtils.checkInvoiceType(fieldObject.getString("invoice_code"), fieldObject.getString("invoice_no"));
                                    invoiceType = InputInvoiceTypeEnum.getInvoiceTypeByAwsType(invoiceTypeAws);
                                }
                                if (StringUtils.isEmpty((CharSequence)(checkStatus = fieldObject.getString("check_status")))) {
                                    fieldObject.put("check_status", (Object)"4");
                                }
                                if (invoiceType == null) {
                                    saveResult.put("checkFail", (Object)ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25:\u65e0\u6cd5\u8bc6\u522b\u7684\u589e\u503c\u7a0e\u53d1\u7968\uff0c\u65e0\u6cd5\u83b7\u53d6\u53d1\u7968\u7c7b\u578b", (String)"InvoiceExcelImportTask_6", (String)"imc-rim-common", (Object[])new Object[0]));
                                    existFailed = Boolean.TRUE;
                                } else {
                                    fieldObject.put("invoiceType", (Object)invoiceType);
                                    Boolean checkFlag = this.checkRequiredParam(fieldObject, invoiceType);
                                    if (checkFlag.booleanValue()) {
                                        if (InputInvoiceTypeEnum.isExistEtaxInvoiceNo(invoiceType) && StringUtils.isNotBlank((Object)fieldObject.get((Object)"electronic_no"))) {
                                            if (!"-".equals(fieldObject.getString("electronic_no")) && !InvoiceConvertUtils.checkElectronicNo(fieldObject.getString("electronic_no"))) {
                                                fieldObject.remove((Object)"electronic_no");
                                            }
                                        } else {
                                            fieldObject.remove((Object)"electronic_no");
                                        }
                                        ExcelInvoiceSaveService excelInvoiceSaveService = new ExcelInvoiceSaveService(invoiceType);
                                        BigDecimal maxAmount = CommonUtils.getImportItemBalance();
                                        String detailTips = this.checkDetailRule(fieldObject, maxAmount);
                                        fieldObject.put("salelist_complete", (Object)"1");
                                        fieldObject.put("excel_all_invoice_import", (Object)"1");
                                        saveResult = excelInvoiceSaveService.save(fieldObject);
                                        if (InvoiceConvertUtils.isSaleListInvoiceType(invoiceType)) {
                                            DynamicObject invoiceDynamicObject;
                                            DynamicObjectCollection collection;
                                            int size;
                                            String fields;
                                            String serialNo = saveResult.getString("serialNo");
                                            String entity = InputInvoiceTypeEnum.getEntity(invoiceType);
                                            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)entity, (String)(fields = MetadataUtil.getFields((String)entity)), (QFilter[])new QFilter[]{new QFilter("serial_no", "=", (Object)serialNo)});
                                            if (dynamicObject != null && (size = (collection = (DynamicObjectCollection)(invoiceDynamicObject = BusinessDataServiceHelper.loadSingle((Object)dynamicObject.get("id"), (String)entity)).get("items")).size()) > 8) {
                                                double itemsNum = collection.size();
                                                double sum = Math.ceil(itemsNum / 25.0);
                                                String mainFields = MetadataUtil.getFields((String)"rim_invoice");
                                                DynamicObject mainObject = BusinessDataServiceHelper.loadSingle((String)"rim_invoice", (String)mainFields, (QFilter[])new QFilter[]{new QFilter("serial_no", "=", (Object)serialNo)});
                                                mainObject.set("salelist_sum", (Object)((int)sum));
                                                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{mainObject});
                                                RecognitionCheckHelper recognitionCheckHelper = new RecognitionCheckHelper();
                                                recognitionCheckHelper.dealInvoiceAttachRelation(saveResult);
                                            }
                                        }
                                        if (StringUtils.isNotBlank((CharSequence)detailTips)) {
                                            saveResult.put("detailTips", (Object)detailTips);
                                        }
                                    } else {
                                        saveResult.put("checkFail", (Object)ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25:\u5fc5\u586b\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6807\u7ea2\u7684\u5fc5\u586b\u5b57\u6bb5\u662f\u5426\u4e3a\u7a7a\uff0c\u6216\u5f53\u524d\u6a21\u677f\u662f\u5426\u4e3a\u6700\u65b0\u6a21\u677f", (String)"InvoiceExcelImportTask_7", (String)"imc-rim-common", (Object[])new Object[0]));
                                        existFailed = Boolean.TRUE;
                                    }
                                }
                                invoiceKeys.add(invoiceKey);
                            }
                        } else {
                            fieldObject.put("invoiceType", (Object)invoiceType);
                            fieldObject.put("excel_all_invoice_import", (Object)"1");
                            Boolean checkFlag = this.checkRequiredParam(fieldObject, invoiceType);
                            if (checkFlag.booleanValue()) {
                                String detailTips = this.checkDeductionFlag(fieldObject);
                                ExcelInvoiceSaveService excelInvoiceSaveService = new ExcelInvoiceSaveService(invoiceType);
                                saveResult = excelInvoiceSaveService.save(fieldObject);
                                if (StringUtils.isNotBlank((CharSequence)detailTips)) {
                                    saveResult.put("detailTips", (Object)detailTips);
                                }
                            } else {
                                saveResult.put("checkFail", (Object)ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25:\u5fc5\u586b\u53c2\u6570\u4e3a\u7a7a", (String)"InvoiceExcelImportTask_8", (String)"imc-rim-common", (Object[])new Object[0]));
                                existFailed = Boolean.TRUE;
                            }
                        }
                        if (saveResult != null && StringUtils.isNotBlank((CharSequence)tagTips)) {
                            String detailTips = saveResult.getString("detailTips");
                            detailTips = StringUtils.isNotBlank((CharSequence)detailTips) ? tagTips + detailTips : tagTips;
                            saveResult.put("detailTips", (Object)detailTips);
                        }
                        if (saveResult == null) {
                            excelResult.put("result", (Object)ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25", (String)"InvoiceExcelImportTask_9", (String)"imc-rim-common", (Object[])new Object[0]));
                            existFailed = Boolean.TRUE;
                        } else if (!StringUtils.isBlank((Object)saveResult.get((Object)"checkFail"))) {
                            excelResult.put("result", saveResult.get((Object)"checkFail"));
                            existFailed = Boolean.TRUE;
                        } else if (StringUtils.isBlank((Object)saveResult.get((Object)"mainId"))) {
                            excelResult.put("result", (Object)ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25", (String)"InvoiceExcelImportTask_9", (String)"imc-rim-common", (Object[])new Object[0]));
                            existFailed = Boolean.TRUE;
                        } else {
                            if (StringUtils.isEmpty((CharSequence)saveResult.getString("detailTips"))) {
                                excelResult.put("result", (Object)ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f", (String)"InvoiceExcelImportTask_10", (String)"imc-rim-common", (Object[])new Object[0]));
                            } else {
                                excelResult.put("result", (Object)String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f,\u6e29\u99a8\u63d0\u793a:%1$s", (String)"InvoiceExcelImportTask_11", (String)"imc-rim-common", (Object[])new Object[0]), saveResult.getString("detailTips")));
                            }
                            String serialNo = saveResult.getString("serial_no");
                            if (savedSerialNos.add(serialNo)) {
                                this.saveExpense(saveResult);
                                String accountDateStr = null;
                                if (!StringUtils.isBlank((CharSequence)saveResult.getString("account_date"))) {
                                    accountDateStr = saveResult.getString("account_date");
                                }
                                if (accountDateStr != null) {
                                    saveResult.put("account_date", (Object)DateUtils.stringToDate(accountDateStr, "yyyyMM"));
                                }
                                InvoiceExcelImportTask.saveVouch(saveResult);
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.error("\u5bfc\u5165\u5931\u8d25,\u5931\u8d25\u539f\u56e0\uff1a", (Throwable)e);
                        excelResult.put("result", (Object)String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25:%1$s", (String)"InvoiceExcelImportTask_12", (String)"imc-rim-common", (Object[])new Object[0]), e.getMessage()));
                        existFailed = Boolean.TRUE;
                    }
                    rowList.add(excelResult);
                    Row resultDataRow = currentSheet.getRow(i + 4);
                    resultDataRow.createCell(writeCellNum).setCellValue(excelResult.getString("result"));
                }
                if (existFailed.booleanValue()) {
                    Row tipsDataRow = currentSheet.getRow(1);
                    tipsDataRow.createCell(0).setCellValue(ResManager.loadKDString((String)"\u5b58\u5728\u5f15\u5165\u5931\u8d25\u7684\u53d1\u7968\uff0c\u8bf7\u5411\u53f3\u62c9\u52a8\u8868\u683c\u67e5\u770b\u5931\u8d25\u539f\u56e0", (String)"InvoiceExcelImportTask_13", (String)"imc-rim-common", (Object[])new Object[0]));
                }
                checkParamMap.put(sheetId, rowList);
                byte[] bytes = null;
                os = new ByteArrayOutputStream();
                this.workbook.write((OutputStream)os);
                bytes = os.toByteArray();
                String exportFileName = String.format(ResManager.loadKDString((String)"%1$s_\u5bfc\u5165\u7ed3\u679c_%2$s", (String)"InvoiceExcelImportTask_60", (String)"imc-rim-common", (Object[])new Object[0]), DateUtils.format(new Date(), "yyyyMMddHHmmss"), this.fileName);
                fin = new ByteArrayInputStream(bytes);
                int cacheTimes = CommonUtils.getTempFileMaxTimeout();
                String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(exportFileName, (InputStream)fin, cacheTimes);
                excelImportStatus = "1";
                excelImportResult.put("resolve_status", (Object)excelImportStatus);
                excelImportResult.put("url", (Object)url);
                excelImportResult.put("export_file_name", (Object)url);
                CacheHelper.put(fileId, excelImportResult.toJSONString(), cacheTimes);
                bytes = null;
            }
            excelImportStatus = isEmptySheet != false ? "3" : "2";
            excelImportResult.put("resolve_status", (Object)excelImportStatus);
            CacheHelper.put(fileId, excelImportResult.toJSONString(), 864000);
        }
        catch (Exception e) {
            excelImportStatus = "3";
            excelImportResult.put("resolve_status", (Object)excelImportStatus);
            CacheHelper.put(fileId, excelImportResult.toJSONString(), 864000);
            logger.error("\u83b7\u53d6excel\u5f02\u6b65\u5904\u7406\u7ed3\u679c\u51fa\u9519\uff1a", (Throwable)e);
            throw new MsgException(e, ResManager.loadKDString((String)"\u83b7\u53d6excel\u5f02\u6b65\u5904\u7406\u7ed3\u679c\u51fa\u9519\uff0c\u6267\u884c\u5931\u8d25", (String)"InvoiceExcelImportTask_14", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        finally {
            IOUtils.closeQuietly(fin);
            IOUtils.closeQuietly(os);
            IOUtils.closeQuietly((Closeable)this.workbook);
        }
        checkParamList.add((Object)checkParamMap);
    }

    private String checkCommonRule(JSONObject invoice) {
        String expenseStatus = invoice.getString("expense_status");
        String expenseNum = invoice.getString("expense_num");
        if (StringUtils.isNotEmpty((CharSequence)expenseStatus) && ("30".equals(expenseStatus) || "60".equals(expenseStatus)) && StringUtils.isEmpty((CharSequence)expenseNum)) {
            return ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25:\u53d1\u7968\u4e1a\u52a1\u72b6\u6001\u4e3a'\u5ba1\u6838\u4e2d','\u5df2\u62a5\u9500'\u72b6\u6001\u65f6\u4e1a\u52a1\u5355\u636e\u53f7\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a", (String)"InvoiceExcelImportTask_15", (String)"imc-rim-common", (Object[])new Object[0]);
        }
        if (StringUtils.isNotEmpty((CharSequence)expenseNum) && StringUtils.isEmpty((CharSequence)expenseStatus)) {
            return ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25:\u4e1a\u52a1\u5355\u636e\u53f7\u7801\u4e0d\u4e3a\u7a7a\u65f6\uff0c\u62a5\u9500\u72b6\u6001\u4e0d\u5141\u8bb8\u4e3a\u7a7a", (String)"InvoiceExcelImportTask_16", (String)"imc-rim-common", (Object[])new Object[0]);
        }
        Object accountDate = invoice.get((Object)"account_date");
        Object vouchNo = invoice.get((Object)"vouch_no");
        if (StringUtils.isNotEmpty((CharSequence)expenseStatus) && "65".equals(expenseStatus) && (ObjectUtils.isEmpty((Object)accountDate) || ObjectUtils.isEmpty((Object)vouchNo))) {
            return ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25:\u53d1\u7968\u4e1a\u52a1\u72b6\u6001\u4e3a'\u5df2\u5165\u8d26'\u72b6\u6001\u65f6\u4f1a\u8ba1\u5c5e\u671f\u548c\u51ed\u8bc1\u53f7\u5747\u4e0d\u5141\u8bb8\u4e3a\u7a7a", (String)"InvoiceExcelImportTask_17", (String)"imc-rim-common", (Object[])new Object[0]);
        }
        if (ObjectUtils.isEmpty((Object)accountDate) && !ObjectUtils.isEmpty((Object)vouchNo) || !ObjectUtils.isEmpty((Object)accountDate) && ObjectUtils.isEmpty((Object)vouchNo)) {
            return ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25:\u4f1a\u8ba1\u5c5e\u671f\u548c\u51ed\u8bc1\u53f7\u8981\u4e48\u90fd\u586b,\u8981\u4e48\u90fd\u4e0d\u586b", (String)"InvoiceExcelImportTask_18", (String)"imc-rim-common", (Object[])new Object[0]);
        }
        return null;
    }

    private String checkVatStandardRule(JSONObject invoice, Boolean needCheck) {
        String numObj;
        if (invoice == null) {
            return ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25:\u53d1\u7968\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u5728excel\u4e2d\u6b63\u786e\u586b\u5165\u53d1\u7968\u4fe1\u606f", (String)"InvoiceExcelImportTask_19", (String)"imc-rim-common", (Object[])new Object[0]);
        }
        String invoiceStatus = invoice.getString("invoice_status");
        String originalTime = invoice.getString("original_time");
        if (StringUtils.isNotEmpty((CharSequence)originalTime)) {
            try {
                Date date = DateUtils.stringToDate(originalTime, "yyyy-MM-dd HH:mm:ss");
            }
            catch (Exception e) {
                return ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25:\u53d1\u7968\u7b7e\u6536\u65f6\u95f4\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u5728excel\u4e2d\u6b63\u786e\u586b\u5165\u53d1\u7968\u4fe1\u606f", (String)"InvoiceExcelImportTask_51", (String)"imc-rim-common", (Object[])new Object[0]);
            }
        }
        String deductionFlag = invoice.getString("deduction_flag");
        String deductionPurpose = invoice.getString("deduction_purpose");
        String authenticateFlag = invoice.getString("authenticate_flag");
        Object selectTime = invoice.get((Object)"select_time");
        Object authenticateTime = invoice.get((Object)"authenticate_time");
        Object taxPeriod = invoice.get((Object)"tax_period");
        String transportDeduction = invoice.getString("transport_deduction");
        String notDeductibleType = invoice.getString("not_deductible_type");
        if (!("0".equals(invoiceStatus) || !InputInvoiceTypeEnum.canDeduction(invoice.getLong("invoiceType")).booleanValue() || StringUtils.isEmpty((CharSequence)deductionFlag) && StringUtils.isEmpty((CharSequence)deductionPurpose) && StringUtils.isEmpty((CharSequence)authenticateFlag) && ObjectUtils.isEmpty((Object)selectTime) && ObjectUtils.isEmpty((Object)authenticateTime) && ObjectUtils.isEmpty((Object)taxPeriod))) {
            return ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25:\u53d1\u7968\u72b6\u6001\u4e3a\u975e'\u6b63\u5e38'\u72b6\u6001\u65f6\uff0c\u6807\u7eff\u5b57\u6bb5\u4e0d\u5141\u8bb8\u586b\u5165\u4efb\u4f55\u503c", (String)"InvoiceExcelImportTask_20", (String)"imc-rim-common", (Object[])new Object[0]);
        }
        if (StringUtils.isNotEmpty((CharSequence)deductionPurpose) && "0".equals(deductionFlag)) {
            return ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25:\u62b5\u6263\u72b6\u6001\u4e3a'\u4e0d\u53ef\u62b5\u6263'\u72b6\u6001'\u65f6,\u6ca1\u6709\u62b5\u6263\u7528\u9014", (String)"InvoiceExcelImportTask_21", (String)"imc-rim-common", (Object[])new Object[0]);
        }
        if (StringUtils.isNotEmpty((CharSequence)deductionPurpose) && (StringUtils.isEmpty((CharSequence)authenticateFlag) || "0".equals(authenticateFlag) || ResManager.loadKDString((String)"\u672a\u52fe\u9009", (String)"InvoiceExcelImportTask_22", (String)"imc-rim-common", (Object[])new Object[0]).equals(authenticateFlag))) {
            return ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25:\u62b5\u6263\u7528\u9014\u4e0d\u4e3a\u7a7a\u65f6\uff0c\u52fe\u9009\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\u4e14\u4e0d\u80fd\u4e3a\u2018\u672a\u52fe\u9009\u2019\u72b6\u6001", (String)"InvoiceExcelImportTask_23", (String)"imc-rim-common", (Object[])new Object[0]);
        }
        if (("1".equals(deductionPurpose) || ResManager.loadKDString((String)"\u62b5\u6263", (String)"InvoiceExcelImportTask_24", (String)"imc-rim-common", (Object[])new Object[0]).equals(deductionPurpose)) && !StringUtils.isEmpty((CharSequence)notDeductibleType)) {
            return ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25:\u62b5\u6263\u7528\u9014\u4e3a'\u62b5\u6263'\u65f6\uff0c\u4e0d\u62b5\u6263\u539f\u56e0\u5fc5\u987b\u4e3a\u7a7a", (String)"InvoiceExcelImportTask_25", (String)"imc-rim-common", (Object[])new Object[0]);
        }
        String taxRate = invoice.getString("tax_rate");
        Double taxRateDouble = 0.0;
        if (StringUtils.isNotEmpty((CharSequence)taxRate) && !needCheck.booleanValue()) {
            try {
                if (taxRate.endsWith("%")) {
                    taxRate = taxRate.substring(0, taxRate.lastIndexOf(37));
                    taxRateDouble = Double.parseDouble(taxRate);
                    taxRateDouble = taxRateDouble / 100.0;
                    invoice.put("tax_rate", (Object)taxRateDouble);
                } else {
                    taxRateDouble = Double.parseDouble(taxRate);
                }
                if (taxRateDouble > 1.0 || taxRateDouble < 0.0) {
                    return ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25:\u7a0e\u7387\u683c\u5f0f\u6709\u8bef,\u7a0e\u7387\u7684\u503c\u53ea\u80fd\u57280%\u5230100%\u4e4b\u95f4", (String)"InvoiceExcelImportTask_26", (String)"imc-rim-common", (Object[])new Object[0]);
                }
            }
            catch (Exception e) {
                return ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25:\u7a0e\u7387\u683c\u5f0f\u6709\u8bef,\u7a0e\u7387\u7684\u683c\u5f0f\u5f62\u5982:9%", (String)"InvoiceExcelImportTask_27", (String)"imc-rim-common", (Object[])new Object[0]);
            }
        }
        if (!ObjectUtils.isEmpty((Object)(numObj = invoice.getString("num"))) && !needCheck.booleanValue()) {
            try {
                BigDecimal num = BigDecimalUtil.transDecimal(numObj);
                invoice.put("num", (Object)num);
            }
            catch (Exception e) {
                return ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25:\u660e\u7ec6\u6570\u91cf\u7684\u683c\u5f0f\u6821\u9a8c\u5931\u8d25", (String)"InvoiceExcelImportTask_28", (String)"imc-rim-common", (Object[])new Object[0]);
            }
        }
        try {
            BigDecimal effectiveTaxAmount = invoice.getBigDecimal("effective_tax_amount");
            BigDecimal totalTaxAmount = invoice.getBigDecimal("total_tax_amount");
            if (!(ObjectUtils.isEmpty((Object)effectiveTaxAmount) || ObjectUtils.isEmpty((Object)totalTaxAmount) || needCheck.booleanValue() || totalTaxAmount.compareTo(effectiveTaxAmount) >= 0)) {
                return ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25:\u6709\u6548\u7a0e\u989d\u53ea\u80fd\u5c0f\u4e8e\u7b49\u4e8e\u7a0e\u989d", (String)"InvoiceExcelImportTask_29", (String)"imc-rim-common", (Object[])new Object[0]);
            }
            BigDecimal invoiceAmount = invoice.getBigDecimal("invoice_amount");
            BigDecimal totalAmount = invoice.getBigDecimal("total_amount");
            if (!(ObjectUtils.isEmpty((Object)invoiceAmount) || ObjectUtils.isEmpty((Object)totalTaxAmount) || ObjectUtils.isEmpty((Object)totalAmount) || needCheck.booleanValue() || totalAmount.compareTo(invoiceAmount.add(totalTaxAmount)) == 0)) {
                return ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25:\u4ef7\u7a0e\u5408\u8ba1 = \u7a0e\u989d + \u4e0d\u542b\u7a0e\u91d1\u989d", (String)"InvoiceExcelImportTask_30", (String)"imc-rim-common", (Object[])new Object[0]);
            }
        }
        catch (Exception e) {
            return ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25:\u6709\u6548\u7a0e\u989d\uff0c\u7a0e\u989d\uff0c\u4e0d\u542b\u7a0e\u91d1\u989d\u6216\u4ef7\u7a0e\u5408\u8ba1\u683c\u5f0f\u4e0d\u6b63\u786e", (String)"InvoiceExcelImportTask_31", (String)"imc-rim-common", (Object[])new Object[0]);
        }
        return this.checkDeduction(invoice);
    }

    private String checkDetailRule(JSONObject invoice, BigDecimal maxAmount) {
        if (invoice == null) {
            return null;
        }
        String detailMsg = "";
        if (ObjectUtils.isEmpty((Object)invoice.get((Object)"total_amount"))) {
            detailMsg = ResManager.loadKDString((String)"\u4ef7\u7a0e\u5408\u8ba1\u4e3a\u7a7a;", (String)"InvoiceExcelImportTask_32", (String)"imc-rim-common", (Object[])new Object[0]);
        }
        try {
            BigDecimal offsetPrice;
            BigDecimal multiply;
            BigDecimal num = null;
            BigDecimal unitPrice = null;
            BigDecimal taxAmount = null;
            BigDecimal taxRate = null;
            String goodsCode = null;
            BigDecimal detailAmount = null;
            try {
                num = invoice.getBigDecimal("num");
            }
            catch (Exception e) {
                throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u660e\u7ec6\u6570\u91cf\u51fa\u9519\uff0c\u6570\u91cf\u5fc5\u987b\u662f\u6570\u5b57", (String)"InvoiceExcelImportTask_33", (String)"imc-rim-common", (Object[])new Object[0]));
            }
            try {
                unitPrice = invoice.getBigDecimal("unit_price");
            }
            catch (Exception e) {
                throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u660e\u7ec6\u5355\u4ef7\u51fa\u9519\uff0c\u5355\u4ef7\u5fc5\u987b\u662f\u6570\u5b57", (String)"InvoiceExcelImportTask_34", (String)"imc-rim-common", (Object[])new Object[0]));
            }
            try {
                detailAmount = invoice.getBigDecimal("detail_amount");
            }
            catch (Exception w) {
                throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u660e\u7ec6\u91d1\u989d\u51fa\u9519\uff0c\u660e\u7ec6\u91d1\u989d\u5fc5\u987b\u662f\u6570\u5b57", (String)"InvoiceExcelImportTask_35", (String)"imc-rim-common", (Object[])new Object[0]));
            }
            try {
                taxAmount = invoice.getBigDecimal("tax_amount");
            }
            catch (Exception w) {
                throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u660e\u7ec6\u7a0e\u989d\u51fa\u9519\uff0c\u660e\u7ec6\u7a0e\u989d\u5fc5\u987b\u662f\u6570\u5b57", (String)"InvoiceExcelImportTask_36", (String)"imc-rim-common", (Object[])new Object[0]));
            }
            try {
                taxRate = invoice.getBigDecimal("tax_rate");
            }
            catch (Exception w) {
                throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u660e\u7ec6\u7a0e\u7387\u51fa\u9519\uff0c\u7a0e\u7387\u5fc5\u987b\u662f\u6570\u5b57", (String)"InvoiceExcelImportTask_37", (String)"imc-rim-common", (Object[])new Object[0]));
            }
            try {
                goodsCode = invoice.getString("goods_code");
            }
            catch (Exception e) {
                throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u51fa\u9519\uff0c\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u4e3a\u5b57\u7b26\u4e32", (String)"InvoiceExcelImportTask_38", (String)"imc-rim-common", (Object[])new Object[0]));
            }
            String deductionFlagResult = this.checkDeductionFlag(invoice);
            if (StringUtils.isNotEmpty((CharSequence)deductionFlagResult)) {
                detailMsg = detailMsg.concat(deductionFlagResult).concat(";");
            }
            if (num == null && unitPrice != null || num != null && unitPrice == null) {
                detailMsg = detailMsg.concat(ResManager.loadKDString((String)"\u6570\u91cf\u548c\u5355\u4ef7\u9700\u540c\u65f6\u5fc5\u586b\u6216\u8005\u540c\u65f6\u4e0d\u586b;", (String)"InvoiceExcelImportTask_39", (String)"imc-rim-common", (Object[])new Object[0]));
            }
            if (num != null && unitPrice != null && detailAmount.compareTo(multiply = unitPrice.multiply(num).setScale(2, RoundingMode.HALF_UP)) != 0) {
                detailMsg = detailMsg.concat(ResManager.loadKDString((String)"\u6570\u91cf\u4e0e\u5355\u4ef7\u7684\u7684\u4e58\u79ef\u4e0d\u7b49\u4e8e\u91d1\u989d;", (String)"InvoiceExcelImportTask_40", (String)"imc-rim-common", (Object[])new Object[0]));
            }
            if (num != null && unitPrice != null && taxAmount != null && taxRate != null && (offsetPrice = taxAmount.subtract(unitPrice.multiply(num).multiply(taxRate).setScale(2, 4))).abs().compareTo(maxAmount) > 0) {
                detailMsg = detailMsg.concat(String.format(ResManager.loadKDString((String)"\u8ba1\u7b97\u7684\u7a0e\u989d\u4e0e\u5b9e\u9645\u586b\u5165\u7684\u7a0e\u989d\u7684\u504f\u5dee\u503c\u8d85\u8fc7\u4e86%s;", (String)"InvoiceExcelImportTask_41", (String)"imc-rim-common", (Object[])new Object[0]), maxAmount.toPlainString()));
            }
            if (StringUtils.isNotBlank((CharSequence)goodsCode)) {
                QFilter goodsCodeFilter;
                DynamicObject taxRateCodeObj;
                if (goodsCode.length() != 19) {
                    detailMsg = detailMsg.concat(ResManager.loadKDString((String)"\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u5e94\u8be5\u4e3a19\u4f4d\u957f\u5ea6;", (String)"InvoiceExcelImportTask_42", (String)"imc-rim-common", (Object[])new Object[0]));
                }
                if (ObjectUtils.isEmpty((Object)(taxRateCodeObj = QueryServiceHelper.queryOne((String)"er_taxclasscode", (String)"id, mergecode, name, taxrate", (QFilter[])new QFilter[]{goodsCodeFilter = new QFilter("mergecode", "=", (Object)goodsCode)})))) {
                    detailMsg = detailMsg.concat(ResManager.loadKDString((String)"\u6570\u636e\u5e93\u4e2d\u627e\u4e0d\u5230\u8be5\u7a0e\u6536\u5206\u7c7b\u7f16\u7801", (String)"InvoiceExcelImportTask_43", (String)"imc-rim-common", (Object[])new Object[0]));
                } else if (taxRate != null && taxRate.compareTo(taxRateCodeObj.getBigDecimal("taxrate")) != 0) {
                    detailMsg = detailMsg.concat(ResManager.loadKDString((String)"\u5f55\u5165\u7684\u7a0e\u7387\u4e0e\u6570\u636e\u5e93\u4e2d\u8be5\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u7684\u4e0b\u7684\u7a0e\u7387\u4e0d\u4e00\u81f4;", (String)"InvoiceExcelImportTask_44", (String)"imc-rim-common", (Object[])new Object[0]));
                }
            }
        }
        catch (Exception e) {
            detailMsg = detailMsg.concat(String.format(ResManager.loadKDString((String)"\u6570\u91cf\uff0c\u5355\u4ef7\uff0c\u91d1\u989d\uff0c\u7a0e\u7387\uff0c\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u6216\u7a0e\u989d\u7684\u683c\u5f0f\u4e0d\u6b63\u786e;\u9519\u8bef\u660e\u7ec6\uff1a%1$s", (String)"InvoiceExcelImportTask_45", (String)"imc-rim-common", (Object[])new Object[0]), e.getMessage()));
            return detailMsg;
        }
        return detailMsg;
    }

    private String checkDeductionFlag(JSONObject invoice) {
        Long invoiceType = invoice.getLong("invoiceType");
        if (InputInvoiceTypeEnum.canDeduction(invoiceType).booleanValue()) {
            String userDeductionFlag = invoice.getString("deduction_flag");
            JSONObject invoiceParam = new JSONObject();
            invoiceParam.put("invoiceStatus", (Object)invoice.getString("invoice_status"));
            if (!ObjectUtils.isEmpty((Object)invoice.getDate("invoice_date"))) {
                invoiceParam.put("invoiceDate", (Object)DateUtils.format(invoice.getDate("invoice_date"), "yyyy-MM-dd"));
            }
            invoiceParam.put("totalTaxAmount", invoice.get((Object)"total_tax_amount"));
            invoiceParam.put("taxAmount", invoice.get((Object)"tax_amount"));
            invoiceParam.put("invoiceType", (Object)invoiceType);
            String sysDeductionFlag = DeductionConstant.canBeDeductionForTaxInvoice(invoiceParam);
            if ("1".equals(userDeductionFlag) && "0".equals(sysDeductionFlag)) {
                invoice.put("deduction_purpose", (Object)"");
                invoice.put("not_deductible_type", (Object)"");
                invoice.put("authenticate_flag", (Object)"");
                invoice.put("select_time", null);
                invoice.put("authenticate_time", null);
                invoice.put("tax_period", (Object)"");
                return ResManager.loadKDString((String)"\u7cfb\u7edf\u5224\u65ad\u8be5\u53d1\u7968\u4e0d\u53ef\u62b5\u6263\uff0c\u4e0e\u586b\u5165\u7684\u503c\u4e0d\u7b26\uff0c\u4fdd\u5b58\u8be5\u53d1\u7968\u65f6\u5df2\u81ea\u52a8\u6e05\u9664\u6807\u7eff\u5b57\u6bb5\u7684\u5185\u5bb9", (String)"InvoiceExcelImportTask_46", (String)"imc-rim-common", (Object[])new Object[0]);
            }
        }
        return null;
    }

    private String checkDeduction(JSONObject invoice) {
        if ("4".equals(invoice.getString("authenticate_flag")) && (ObjectUtils.isEmpty((Object)invoice.getString("tax_period")) || ObjectUtils.isEmpty((Object)invoice.getString("deduction_purpose")))) {
            return ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25:\u9884\u52fe\u9009\u72b6\u6001,\u62b5\u6263\u7528\u9014\u548c\u7a0e\u671f\u5747\u4e0d\u5141\u8bb8\u4e3a\u7a7a", (String)"InvoiceExcelImportTask_47", (String)"imc-rim-common", (Object[])new Object[0]);
        }
        if ("1".equals(invoice.getString("authenticate_flag")) && (ObjectUtils.isEmpty((Object)invoice.getDate("select_time")) || ObjectUtils.isEmpty((Object)invoice.getString("tax_period")) || ObjectUtils.isEmpty((Object)invoice.getString("deduction_purpose")))) {
            return ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25:\u5df2\u52fe\u9009\u72b6\u6001,\u62b5\u6263\u7528\u9014\uff0c\u52fe\u9009\u65f6\u95f4\u548c\u7a0e\u671f\u5747\u4e0d\u5141\u8bb8\u4e3a\u7a7a", (String)"InvoiceExcelImportTask_48", (String)"imc-rim-common", (Object[])new Object[0]);
        }
        if (("2".equals(invoice.getString("authenticate_flag")) || "3".equals(invoice.getString("authenticate_flag"))) && (ObjectUtils.isEmpty((Object)invoice.getDate("select_time")) || ObjectUtils.isEmpty((Object)invoice.getString("tax_period")) || ObjectUtils.isEmpty((Object)invoice.getString("deduction_purpose")) || ObjectUtils.isEmpty((Object)invoice.getDate("authenticate_time")))) {
            return ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25:\u8ba4\u8bc1\u72b6\u6001,\u62b5\u6263\u7528\u9014\uff0c\u52fe\u9009\u65f6\u95f4\uff0c\u7a0e\u671f\u548c\u8ba4\u8bc1\u65f6\u95f4\u5747\u4e0d\u5141\u8bb8\u4e3a\u7a7a", (String)"InvoiceExcelImportTask_49", (String)"imc-rim-common", (Object[])new Object[0]);
        }
        if (("1".equals(invoice.getString("transport_deduction")) || "2".equals(invoice.getString("transport_deduction"))) && ObjectUtils.isEmpty((Object)invoice.getString("tax_period"))) {
            return ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25:\u65c5\u5ba2\u8fd0\u8f93\u62b5\u6263\u4e3a\u9884\u62b5\u6263\u6216\u5df2\u62b5\u6263\u65f6\uff0c\u62b5\u6263\u7a0e\u671f\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceExcelImportTask_50", (String)"imc-rim-common", (Object[])new Object[0]);
        }
        return null;
    }

    private void cacheImportResult(JSONObject fileImportResult) {
        fileImportResult.put("excel_name", (Object)this.fileName);
        fileImportResult.put("upload_time", (Object)new Date());
        fileImportResult.put("operate_user", (Object)this.rc.getUserId());
    }

    private Boolean checkRequiredParam(JSONObject fieldObject, Long invoiceType) {
        Boolean checkFlag = Boolean.TRUE;
        if ((InputInvoiceTypeEnum.GENERAL_PAPER.getCode().equals(invoiceType) || InputInvoiceTypeEnum.GENERAL_ELECTRON.getCode().equals(invoiceType) || InputInvoiceTypeEnum.TRANSPORT_INVOICE.getCode().equals(invoiceType) || InputInvoiceTypeEnum.BOAT_INVOICE.getCode().equals(invoiceType) || InputInvoiceTypeEnum.TAXI_INVOICE.getCode().equals(invoiceType) || InputInvoiceTypeEnum.ROAD_BRIDGE.getCode().equals(invoiceType) || InputInvoiceTypeEnum.FINANCIAL_INVOICE.getCode().equals(invoiceType)) && (StringUtils.isBlank((CharSequence)fieldObject.getString("invoice_code")) || StringUtils.isBlank((CharSequence)fieldObject.getString("invoice_no")) || StringUtils.isBlank((CharSequence)fieldObject.getString("invoice_date")) || StringUtils.isBlank((CharSequence)fieldObject.getString("total_amount")))) {
            checkFlag = Boolean.FALSE;
        }
        if (InputInvoiceTypeEnum.TRAIN_INVOICE.getCode().equals(invoiceType)) {
            if (StringUtils.isBlank((CharSequence)fieldObject.getString("train_num")) || StringUtils.isBlank((CharSequence)fieldObject.getString("sequence_no")) || StringUtils.isBlank((CharSequence)fieldObject.getString("travel_date")) || StringUtils.isBlank((CharSequence)fieldObject.getString("total_amount")) || StringUtils.isBlank((CharSequence)fieldObject.getString("passenger_name"))) {
                checkFlag = Boolean.FALSE;
            }
            if (checkFlag.booleanValue()) {
                fieldObject.put("invoice_date", (Object)fieldObject.getString("travel_date"));
            }
        }
        if (InputInvoiceTypeEnum.AIR_INVOICE.getCode().equals(invoiceType) && (StringUtils.isBlank((CharSequence)fieldObject.getString("eticket_no")) || StringUtils.isBlank((CharSequence)fieldObject.getString("print_num")) || StringUtils.isBlank((CharSequence)fieldObject.getString("invoice_date")) || StringUtils.isBlank((CharSequence)fieldObject.getString("total_amount")))) {
            checkFlag = Boolean.FALSE;
        }
        if (InputInvoiceTypeEnum.QUOTA_INVOICE.getCode().equals(invoiceType) && (StringUtils.isBlank((CharSequence)fieldObject.getString("invoice_code")) || StringUtils.isBlank((CharSequence)fieldObject.getString("invoice_no")) || StringUtils.isBlank((CharSequence)fieldObject.getString("total_amount")))) {
            checkFlag = Boolean.FALSE;
        }
        if (InputInvoiceTypeEnum.TAX_PROOF.getCode().equals(invoiceType) && (StringUtils.isBlank((CharSequence)fieldObject.getString("tax_paid_proof_no")) || StringUtils.isBlank((CharSequence)fieldObject.getString("invoice_date")) || StringUtils.isBlank((CharSequence)fieldObject.getString("total_amount")) || StringUtils.isBlank((CharSequence)fieldObject.getString("buyer_tax_no")))) {
            checkFlag = Boolean.FALSE;
        }
        if (InputInvoiceTypeEnum.HGJKS.getCode().equals(invoiceType) && (StringUtils.isBlank((CharSequence)fieldObject.getString("custom_declaration_no")) || StringUtils.isBlank((CharSequence)fieldObject.getString("invoice_date")) || StringUtils.isBlank((CharSequence)fieldObject.getString("total_tax_amount")))) {
            checkFlag = Boolean.FALSE;
        }
        if ((InputInvoiceTypeEnum.ELECTRIC_SPECIAL.getCode().equals(invoiceType) || InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getCode().equals(invoiceType)) && (StringUtils.isBlank((CharSequence)fieldObject.getString("invoice_no")) || StringUtils.isBlank((CharSequence)fieldObject.getString("invoice_date")) || StringUtils.isBlank((CharSequence)fieldObject.getString("total_amount")))) {
            checkFlag = Boolean.FALSE;
        }
        if (checkFlag.booleanValue() && InputInvoiceTypeEnum.HGJKS.getCode().equals(invoiceType) && !ObjectUtils.isEmpty((Object)fieldObject.get((Object)"total_tax_amount"))) {
            fieldObject.put("total_amount", fieldObject.get((Object)"total_tax_amount"));
        }
        return checkFlag;
    }

    private void saveExpense(JSONObject invoice) {
        String serialNo = invoice.getString("serial_no");
        String expenseNum = invoice.getString("expense_num");
        String expenseStatus = invoice.getString("expense_status");
        if (StringUtils.isBlank((CharSequence)serialNo) || StringUtils.isBlank((CharSequence)expenseNum) || StringUtils.isBlank((CharSequence)expenseStatus)) {
            return;
        }
        String excelresource = "1";
        QFilter serialFilet = new QFilter("serial_no", "=", (Object)serialNo);
        QFilter resourceFilet = new QFilter("resource", "=", (Object)excelresource);
        DeleteServiceHelper.delete((String)"rim_expense_relation", (QFilter[])new QFilter[]{serialFilet, resourceFilet});
        String[] expenseNums = this.getExpenseNums(expenseNum);
        List<Map<String, String>> addExpenseList = this.addExpense(expenseNums, expenseStatus, excelresource);
        ArrayList<DynamicObject> realtionList = new ArrayList<DynamicObject>(addExpenseList.size());
        for (Map<String, String> map : addExpenseList) {
            DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"rim_expense_relation");
            obj.set("expense_id", (Object)map.get("expense_id"));
            obj.set("expense_type", (Object)map.get("expense_type"));
            obj.set("serial_no", (Object)serialNo);
            obj.set("resource", (Object)excelresource);
            obj.set("expense_num", (Object)map.get("expense_num"));
            obj.set("status", (Object)expenseStatus);
            realtionList.add(obj);
        }
        SaveServiceHelper.save((DynamicObject[])realtionList.toArray(new DynamicObject[0]));
        ExpenseService expenseService = new ExpenseService();
        ArrayList<String> serialList = new ArrayList<String>(1);
        serialList.add(serialNo);
        expenseService.updateInvoiceMain(serialList, null);
    }

    private List<Map<String, String>> addExpense(String[] expenseNums, String status, String resource) {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>(expenseNums.length);
        if (expenseNums != null && expenseNums.length > 0) {
            QFilter fileter1 = new QFilter("expense_num", "in", (Object)expenseNums);
            QFilter fileter2 = new QFilter("resource", "=", (Object)"1");
            DynamicObjectCollection collect = QueryServiceHelper.query((String)"rim_expense", (String)"expense_id,expense_num, expense_type", (QFilter[])new QFilter[]{fileter1, fileter2});
            HashMap expneseMap = new HashMap(collect.size());
            collect.forEach(obj -> expneseMap.put(obj.getString("expense_num"), obj));
            for (String num : expenseNums) {
                DynamicObject expenseObject = (DynamicObject)expneseMap.get(num);
                if (expenseObject == null) {
                    expenseObject = BusinessDataServiceHelper.newDynamicObject((String)"rim_expense");
                    expenseObject.set("create_time", (Object)new Date());
                    expenseObject.set("update_time", (Object)new Date());
                    expenseObject.set("expense_num", (Object)num);
                    expenseObject.set("expense_id", (Object)UUID.randomUUID());
                    expenseObject.set("expense_type", (Object)"invoice_pool_enter");
                    expenseObject.set("status", (Object)status);
                    expenseObject.set("resource", (Object)resource);
                    expenseObject.set("creator_id", (Object)RequestContext.get().getCurrUserId());
                    expenseObject.set("creator_name", (Object)RequestContext.get().getUserName());
                    expenseObject.set("orgid", (Object)RequestContext.get().getOrgId());
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{expenseObject});
                }
                HashMap<String, String> map = new HashMap<String, String>(4);
                map.put("expense_id", expenseObject.getString("expense_id"));
                map.put("expense_type", expenseObject.getString("expense_type"));
                map.put("expense_num", num);
                list.add(map);
            }
        }
        return list;
    }

    private String[] getExpenseNums(String expenseNum) {
        if (expenseNum.indexOf(",") > 0) {
            return expenseNum.split(",");
        }
        if (expenseNum.indexOf("\uff0c") > 0) {
            return expenseNum.split("\uff0c");
        }
        return new String[]{expenseNum};
    }

    private static void saveVouch(JSONObject invoice) {
        String serialNo = invoice.getString("serial_no");
        String resource = invoice.getString("resource");
        String vouchNo = invoice.getString("vouch_no");
        Date accountDate = invoice.getDate("account_date");
        if (StringUtils.isBlank((CharSequence)serialNo) || StringUtils.isBlank((CharSequence)vouchNo) || ObjectUtils.isEmpty((Object)accountDate)) {
            return;
        }
        QFilter serialFilet1 = new QFilter("billid", "=", (Object)serialNo);
        QFilter serialFilet2 = new QFilter("bill_type", "=", (Object)"2");
        QFilter resourceFilet = new QFilter("resource", "=", (Object)resource);
        DeleteServiceHelper.delete((String)"rim_vouch_relation", (QFilter[])new QFilter[]{serialFilet1, serialFilet2, resourceFilet});
        DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"rim_vouch_relation");
        obj.set("billid", (Object)serialNo);
        obj.set("bill_type", (Object)"2");
        obj.set("resource", (Object)resource);
        obj.set("vouch_no", (Object)vouchNo);
        obj.set("account_date", (Object)accountDate);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
        VoucherService voucherService = new VoucherService();
        JSONArray serialList = new JSONArray();
        serialList.add((Object)serialNo);
        voucherService.updateInvoiceMain(serialList);
    }

    private void setVATProperties(JSONObject fieldObject, JSONObject invoice) {
        invoice.put("deductionFlag", fieldObject.get((Object)"deduction_flag"));
        invoice.put("selectTime", fieldObject.get((Object)"select_time"));
        invoice.put("authenticateFlag", fieldObject.get((Object)"authenticate_flag"));
        invoice.put("authenticateTime", fieldObject.get((Object)"authenticate_time"));
        invoice.put("taxPeriod", fieldObject.get((Object)"tax_period"));
        invoice.put("resource", fieldObject.get((Object)"resource"));
        invoice.put("org_id", fieldObject.get((Object)"org"));
        invoice.put("tax_org", fieldObject.get((Object)"tax_org"));
        invoice.put("effectiveTaxAmount", (Object)fieldObject.getBigDecimal("effective_tax_amount"));
        if (StringUtils.isNotBlank((CharSequence)fieldObject.getString("deduction_purpose")) && StringUtils.isBlank((Object)invoice.get((Object)"deductionPurpose"))) {
            invoice.put("deductionPurpose", (Object)fieldObject.getString("deduction_purpose"));
        }
        if (StringUtils.isNotBlank((CharSequence)fieldObject.getString("transport_deduction")) && StringUtils.isBlank((Object)invoice.get((Object)"transportDeduction"))) {
            invoice.put("transportDeduction", (Object)fieldObject.getString("transport_deduction"));
        }
        invoice.put("allowDeduction", (Object)"1");
    }

    public static Log getLogger() {
        return logger;
    }

    public static void setLogger(Log logger) {
        InvoiceExcelImportTask.logger = logger;
    }

    public RequestContext getRc() {
        return this.rc;
    }

    public void setRc(RequestContext rc) {
        this.rc = rc;
    }

    public String getFileUrl() {
        return this.fileUrl;
    }

    public void setFileUrl(String fileUrl) {
        this.fileUrl = fileUrl;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }
}

