/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.collector;

import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.invoice.deduction.DeductService;
import kd.imc.rim.common.invoice.deduction.DeductServiceFactory;
import kd.imc.rim.common.invoice.deduction.impl.NewEtaxDeductService;
import kd.imc.rim.common.invoice.download.impl.HeaderInvoiceDownServiceImpl;
import kd.imc.rim.common.invoice.download.impl.InOutputInvoiceDownServiceImpl;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.UUID;

public class InvoiceHeaderDownService {
    private Long orgId;
    private static Log LOGGER = LogFactory.getLog(InvoiceHeaderDownService.class);

    public InvoiceHeaderDownService(Long orgId) {
        this.orgId = orgId;
    }

    public void applySelectedTable(String taxNo, String billType, String deductFlag, String taxPeriod) {
        this.applyTable(taxNo, billType, deductFlag, taxPeriod, "", "", "");
    }

    public void applyUnSelectTable(String taxNo, String billType, String startTime, String endTime, String invoiceStatus) {
        this.applyTable(taxNo, billType, "0", "", startTime, endTime, invoiceStatus);
    }

    public void applyTable(String taxNo, String billType, String deductFlag, String taxPeriod, String startTime, String endTime, String invoiceStatus) {
        NewEtaxDeductService newEtaxDeductService = new NewEtaxDeductService(this.orgId);
        JSONObject paramJson = new JSONObject();
        paramJson.put("taxNo", (Object)taxNo);
        paramJson.put("billType", (Object)billType);
        JSONObject searchOpt = new JSONObject();
        searchOpt.put("deductFlag", (Object)deductFlag);
        searchOpt.put("invoiceType", (Object)"-1");
        if (StringUtils.isBlank((CharSequence)invoiceStatus)) {
            searchOpt.put("invoiceStatus", (Object)"-1");
        } else if (invoiceStatus.contains(",")) {
            searchOpt.put("multInvoiceStatus", (Object)invoiceStatus);
        } else {
            searchOpt.put("invoiceStatus", (Object)invoiceStatus);
        }
        searchOpt.put("deductionPurpose", (Object)"-1");
        String syncType = "8";
        if ("2".equals(deductFlag)) {
            syncType = "10";
            searchOpt.put("taxPeriod", (Object)taxPeriod);
        } else if ("1".equals(deductFlag)) {
            syncType = "9";
        } else {
            searchOpt.put("startTime", (Object)startTime);
            searchOpt.put("endTime", (Object)endTime);
        }
        if ("1".equals(billType)) {
            searchOpt.put("invoiceType", (Object)InputInvoiceTypeEnum.HGJKS.getAwsType());
        }
        paramJson.put("searchOpt", (Object)searchOpt);
        JSONObject resultObject = newEtaxDeductService.downInvoiceHeadApply(paramJson);
        if (resultObject != null && ResultContant.isSuccess(resultObject).booleanValue()) {
            JSONObject logParam = new JSONObject();
            logParam.put("searchOpt", (Object)searchOpt);
            logParam.put("rpadownAsyn", (Object)paramJson.getString("rpadownAsyn"));
            logParam.put("billType", (Object)billType);
            logParam.put("taxNo", (Object)taxNo);
            logParam.put("taskNo", (Object)UUID.getBatchNo(""));
            logParam.put("syncType", (Object)syncType);
            this.insertDownLog(logParam, resultObject);
        } else {
            LOGGER.info("rpa\u5f02\u6b65\u8868\u5934\u4e0b\u8f7d\u7533\u8bf7\u5931\u8d25, \u7a0e\u53f7-{}, \u8fd4\u56de\u503c-{}", (Object)taxNo, (Object)resultObject);
        }
    }

    public void insertDownLog(JSONObject param, JSONObject result) {
        String syncType;
        if (!ResultContant.isSuccess(result).booleanValue() || ObjectUtils.isEmpty((Object)result.get((Object)"data"))) {
            LOGGER.info("\u5f02\u6b65\u8868\u5934\u4e0b\u8f7d\uff0c\u7533\u8bf7\u5931\u8d25\uff0c{}", (Object)result);
            return;
        }
        JSONObject data = result.getJSONObject("data");
        String asyncFlag = param.getString("asyncFlag");
        String taxNo = param.getString("taxNo");
        String dkType = DeductionConstant.getDkType(taxNo);
        boolean isRpa = "4".equals(dkType);
        int totalNum = 0;
        JSONObject searchOpt = param.getJSONObject("searchOpt");
        HeaderInvoiceDownServiceImpl downService = new HeaderInvoiceDownServiceImpl();
        String awsInvoiceType = searchOpt.getString("invoiceType");
        String string = syncType = StringUtils.isNotBlank((CharSequence)param.getString("syncType")) ? param.getString("syncType") : "1";
        String taskNo = StringUtils.isNotEmpty((CharSequence)data.getString("taskNo")) ? data.getString("taskNo") : (StringUtils.isNotEmpty((CharSequence)param.getString("taskNo")) ? param.getString("taskNo") : UUID.getBatchNo("DOWN"));
        String batchNo = data.getString("batchNo");
        DynamicObject downLogObj = downService.getDownLogDynamicObject(taskNo, batchNo, this.orgId, taxNo, totalNum, syncType, InputInvoiceTypeEnum.getInvoiceTypeByAwsType(awsInvoiceType));
        if (StringUtils.isNotBlank((CharSequence)awsInvoiceType) && !StringUtils.equals((CharSequence)"-1", (CharSequence)awsInvoiceType) && InputInvoiceTypeEnum.getInvoiceTypeByAwsType(awsInvoiceType) > 0L) {
            downLogObj.set("aws_invoice_type", (Object)awsInvoiceType);
        }
        Object taxPeriod = searchOpt.get((Object)"taxPeriod");
        Date startTime = null;
        Date endTime = null;
        if (taxPeriod != null) {
            if (taxPeriod instanceof Long) {
                startTime = new Date((Long)taxPeriod);
            }
            if (taxPeriod instanceof String) {
                startTime = DateUtils.stringToDate(taxPeriod.toString(), "yyyyMM");
            }
            if (taxPeriod instanceof Date) {
                startTime = (Date)taxPeriod;
            }
            if (startTime != null) {
                endTime = DateUtils.getLastDateOfMonthZero(startTime);
            }
        } else {
            startTime = searchOpt.getDate("startTime");
            endTime = searchOpt.getDate("endTime");
        }
        downLogObj.set("invoice_startdate", (Object)startTime);
        downLogObj.set("invoice_enddate", (Object)endTime);
        downLogObj.set("json_tag", (Object)param.toJSONString());
        downLogObj.set("gov_status", (Object)"6");
        String account = result.getString("account");
        if (StringUtils.isNotBlank((CharSequence)account)) {
            downLogObj.set("account", (Object)account);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{downLogObj});
    }

    public JSONObject downAgricInvoice(String taxNo, Long orgId, JSONObject param) {
        String dkType = DeductionConstant.getDkType(taxNo);
        DeductService deductService = DeductServiceFactory.newInstanceForDeduct(dkType, orgId);
        JSONObject result = deductService.applyDownAgricInvoice(param);
        if (ResultContant.isSuccess(result).booleanValue()) {
            JSONObject data = result.getJSONObject("data");
            String taskNo = data.getString("batchNo");
            InOutputInvoiceDownServiceImpl downService = new InOutputInvoiceDownServiceImpl();
            String applyBatchNo = UUID.getBatchNo("DOWN");
            DynamicObject downLog = downService.getDownLogDynamicObject(applyBatchNo, taskNo, orgId, taxNo, 0, "", 0L);
            downLog.set("gov_status", (Object)"6");
            downLog.set("download_errcode", (Object)"0");
            downLog.set("inout", (Object)"9");
            downLog.set("apply_step", (Object)1);
            downLog.set("invoice_startdate", (Object)param.getDate("startDate"));
            downLog.set("invoice_enddate", (Object)param.getDate("endDate"));
            downLog.set("json_tag", (Object)param.toJSONString());
            String account = result.getString("account");
            if (StringUtils.isNotBlank((CharSequence)account)) {
                downLog.set("account", (Object)account);
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{downLog});
        }
        return result;
    }
}

