/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.collector;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.ExpenseConstant;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.InvoiceSaveConstant;
import kd.imc.rim.common.expense.service.ExpenseService;
import kd.imc.rim.common.invoice.collector.InvoiceHisDataSyncRelationService;
import kd.imc.rim.common.invoice.model.ConvertFieldUtil;
import kd.imc.rim.common.invoice.save.InvoiceSaveResult;
import kd.imc.rim.common.invoice.save.InvoiceSaveService;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.common.utils.TenantUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class InvoiceHisDataSaveCallable
implements Callable<InvoiceSaveResult> {
    private static final Log logger = LogFactory.getLog(InvoiceHisDataSaveCallable.class);
    private static final String DELETE_EXPENSE_ID = "deleteExpenseIdList";
    private static final String EXPENSE_INFO = "expenseInfo";
    private RequestContext rc;
    private JSONObject invoiceJson;
    private Map<String, Object> expenseMap;

    public InvoiceHisDataSaveCallable(RequestContext rc, JSONObject invoiceJson) {
        this.rc = rc;
        this.invoiceJson = invoiceJson;
    }

    @Override
    public InvoiceSaveResult call() throws Exception {
        RequestContext.copyAndSet((RequestContext)this.rc);
        try {
            Long xhInvoiceType;
            Class entityClazz;
            Long awsOrgId;
            boolean downFile;
            String syncFlag = this.invoiceJson.getString("syncAll");
            boolean saveExpenseFlag = !"0".equals(this.invoiceJson.getString("saveExpenseFlag"));
            boolean syncAll = "1".equals(syncFlag) ? true : "1".equals(RimConfigUtils.getConfig("synchis_all"));
            this.expenseMap = new HashMap<String, Object>(2);
            this.invoiceJson.put("needUserRelation", (Object)"0");
            this.invoiceJson.put(InvoiceSaveConstant.INVOICE_SAVE_FROM, (Object)InvoiceSaveConstant.INVOICE_SAVE_FROM_VALUE);
            String awsSerialNo = this.invoiceJson.getString("serialNo");
            String invoiceType = this.invoiceJson.getString("invoiceType");
            JSONArray expenseArray = this.invoiceJson.getJSONArray("expenseArray");
            JSONArray userPhoneList = this.invoiceJson.getJSONArray("userPhoneList");
            if (!CollectionUtils.isEmpty((Collection)userPhoneList)) {
                JSONArray userPhoneNewList = new JSONArray(userPhoneList.size());
                for (int i = 0; i < userPhoneList.size(); ++i) {
                    String phoneNumber = userPhoneList.getString(i);
                    if (!StringUtils.isNotEmpty((CharSequence)phoneNumber)) continue;
                    userPhoneNewList.add((Object)InvoiceHisDataSyncRelationService.desensitizationPhone(phoneNumber));
                }
                this.invoiceJson.put("userPhoneList", (Object)userPhoneNewList);
            }
            this.syncImage(expenseArray);
            JSONArray vouchArray = this.invoiceJson.getJSONArray("vouchArray");
            if (!syncAll && "11".equals(invoiceType) && CollectionUtils.isEmpty((Collection)expenseArray) && CollectionUtils.isEmpty((Collection)vouchArray)) {
                String serialNo = this.invoiceJson.getString("serialNo");
                if (StringUtils.isNotEmpty((CharSequence)serialNo)) {
                    this.saveExpenseAndVouch(saveExpenseFlag, serialNo, expenseArray, vouchArray);
                }
                logger.info("\u5176\u4ed6\u53d1\u7968\u672a\u7528\u4e0d\u5165\u5e93{}", (Object)awsSerialNo);
                return null;
            }
            boolean bl = downFile = !"0".equals(RimConfigUtils.getConfig("down_invoice_file"));
            if (downFile) {
                this.invoiceJson.put("insertAwsFile", (Object)"1");
            }
            if (!syncAll && CollectionUtils.isEmpty((Collection)expenseArray) && CollectionUtils.isEmpty((Collection)vouchArray)) {
                String serialNo = this.invoiceJson.getString("serialNo");
                if (StringUtils.isNotEmpty((CharSequence)serialNo)) {
                    this.saveExpenseAndVouch(saveExpenseFlag, serialNo, expenseArray, vouchArray);
                }
                logger.info("\u672a\u7528\u53d1\u7968\u4e0d\u5165\u5e93{}", (Object)awsSerialNo);
                return null;
            }
            InvoiceSaveService saveService = InvoiceSaveService.newInstance(invoiceType);
            if ("1".equals(RimConfigUtils.getConfig("his_deduct"))) {
                this.invoiceJson.put("allowDeduction", (Object)"1");
                this.invoiceJson.put("awsHisFlag", (Object)"1");
            }
            if ((awsOrgId = this.getOrgBySkyOrgId()) > 0L) {
                this.invoiceJson.put("org_id", (Object)awsOrgId);
            }
            String checkStatus = this.invoiceJson.getString("checkStatus");
            this.invoiceJson.put("invoiceType", (Object)saveService.getInvoiceType());
            Object trainTime = null;
            String departureTime = "";
            if (InputInvoiceTypeEnum.TRAIN_ELE_INVOICE.getCode().equals(this.invoiceJson.getLong("invoiceType"))) {
                departureTime = this.invoiceJson.getString("departureTime");
            }
            if ((entityClazz = InputInvoiceTypeEnum.getClazzByCode(xhInvoiceType = this.invoiceJson.getLong("invoiceType"))) != null) {
                JSONObject covertObj = InputInvoiceTypeEnum.needCheck(xhInvoiceType) != false && "1".equals(checkStatus) ? ConvertFieldUtil.convert(entityClazz, this.invoiceJson, "2") : ConvertFieldUtil.convert(entityClazz, this.invoiceJson, "1");
                this.invoiceJson.putAll((Map)covertObj);
                if (trainTime != null) {
                    this.invoiceJson.put("trainTime", trainTime);
                }
                if (StringUtils.isNotEmpty((CharSequence)departureTime)) {
                    this.invoiceJson.put("departureTime", (Object)departureTime);
                }
            }
            InvoiceSaveResult saveResult = null;
            saveResult = !"1".equals(checkStatus) && InputInvoiceTypeEnum.needCheck(saveService.getInvoiceType()) != false ? saveService.saveUncheckInvoice(this.invoiceJson, "") : saveService.save(this.invoiceJson);
            String entryAmount = this.invoiceJson.getString("entryAmount");
            String outputReason = this.invoiceJson.getString("outputReason");
            String outputAmount = this.invoiceJson.getString("outputAmount");
            String serialNo = saveResult.getSerialNo();
            Long org = this.saveExpenseAndVouch(saveExpenseFlag, serialNo, expenseArray, vouchArray);
            Object mainId = saveResult.getMainId();
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadHead((Object)mainId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"rim_invoice"));
            dynamicObject.set("output_reason", (Object)outputReason);
            dynamicObject.set("entry_amount", (Object)BigDecimalUtil.transDecimal(entryAmount));
            dynamicObject.set("output_amount", (Object)BigDecimalUtil.transDecimal(outputAmount));
            Long orgId = DynamicObjectUtil.getDynamicObjectLongValue(dynamicObject.get("org"));
            String deduction_flag = DeductionConstant.getDeductionFlag(this.invoiceJson, orgId);
            if (deduction_flag.equals("1") && "0".equals(this.invoiceJson.getString("canBeDeduction"))) {
                deduction_flag = "0";
                dynamicObject.set("deduction_flag", (Object)deduction_flag);
            } else {
                dynamicObject.set("deduction_flag", (Object)deduction_flag);
            }
            if (awsOrgId <= 1L) {
                if (org < 1L) {
                    org = this.getOrgByClientId(expenseArray);
                }
                if (org > 0L) {
                    dynamicObject.set("org", (Object)org);
                }
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
            if (!(StringUtils.isEmpty((CharSequence)saveResult.getInvoiceEntity()) || org <= 0L && StringUtils.isEmpty((CharSequence)deduction_flag))) {
                DynamicObject invoiceDynamicObject = BusinessDataServiceHelper.loadHead((Object)saveResult.getInvoiceId(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)saveResult.getInvoiceEntity()));
                if (org > 0L) {
                    invoiceDynamicObject.set("org", (Object)org);
                    if (!InputInvoiceTypeEnum.needCheck(saveResult.getInvoiceType()).booleanValue()) {
                        Long taxOrg = TenantUtils.getTaxOrgId(org);
                        invoiceDynamicObject.set("tax_org", (Object)taxOrg);
                        dynamicObject.set("tax_org", (Object)taxOrg);
                    }
                }
                if (!StringUtils.isEmpty((CharSequence)deduction_flag)) {
                    invoiceDynamicObject.set("deduction_flag", (Object)deduction_flag);
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{invoiceDynamicObject});
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
            this.saveSerialNo(awsSerialNo, saveResult);
            try {
                this.dealRelationAndAttach(serialNo, mainId, userPhoneList);
            }
            catch (Exception e) {
                logger.info("\u5904\u7406\u53d1\u7968\u5173\u7cfb\u548c\u9644\u4ef6\u5f02\u5e38", (Object)e);
            }
            saveResult.setExtObject(this.expenseMap);
            return saveResult;
        }
        catch (Throwable e) {
            logger.info("\u53d1\u7968\u4fdd\u5b58\u5931\u8d25\uff1a{}", (Object)this.invoiceJson);
            logger.error("\u53d1\u7968\u4fdd\u5b58\u5931\u8d25", e);
            return null;
        }
    }

    private void dealRelationAndAttach(String serialNo, Object mainId, JSONArray userPhoneList) {
        if (null != mainId && StringUtils.isNotBlank((CharSequence)serialNo)) {
            JSONArray attachment;
            if (!CollectionUtils.isEmpty((Collection)userPhoneList)) {
                JSONArray userPhoneNewList = new JSONArray(userPhoneList.size());
                for (int i = 0; i < userPhoneList.size(); ++i) {
                    String phoneNumber = userPhoneList.getString(i);
                    if (!StringUtils.isNotEmpty((CharSequence)phoneNumber)) continue;
                    userPhoneNewList.add((Object)InvoiceHisDataSyncRelationService.desensitizationPhone(phoneNumber));
                }
                logger.info("userPhoneList: {}", (Object)userPhoneNewList.toString());
            }
            JSONObject invoiceParam = new JSONObject();
            invoiceParam.put("serialNo", (Object)serialNo);
            invoiceParam.put("mainId", mainId);
            invoiceParam.put("userPhoneList", (Object)userPhoneList);
            InvoiceHisDataSyncRelationService relationService = new InvoiceHisDataSyncRelationService();
            Pair<Boolean, List<Long>> pair = relationService.checkNeedSave(invoiceParam);
            invoiceParam.remove((Object)"userPhoneList");
            Long userId = 0L;
            if (((Boolean)pair.getLeft()).booleanValue()) {
                List userIds = (List)pair.getRight();
                userId = (Long)userIds.get(0);
                invoiceParam.put("userIds", (Object)userIds);
                relationService.saveUserInvoiceRelation(invoiceParam);
            }
            if (!CollectionUtils.isEmpty((Collection)(attachment = this.invoiceJson.getJSONArray("attachList")))) {
                logger.info("\u53d1\u7968\u9644\u4ef6\u4e2a\u6570\uff1a{}", (Object)attachment.size());
                JSONObject attachParam = new JSONObject();
                attachParam.put("serialNo", (Object)serialNo);
                attachParam.put("attachment", (Object)attachment);
                attachParam.put("userId", (Object)userId);
                relationService.dealAwsAttachment(attachParam);
            }
        }
    }

    private Long getOrgBySkyOrgId() {
        Long awsOrgId = 0L;
        String starrySkyOrgId = this.invoiceJson.getString("starrySkyOrgId");
        if (!StringUtils.isEmpty((CharSequence)starrySkyOrgId)) {
            try {
                QFilter idFilter = new QFilter("third_org_no", "=", (Object)starrySkyOrgId);
                DynamicObject thirdOrg = QueryServiceHelper.queryOne((String)"bdm_third_org", (String)"id,third_org_no,org_no,orgid", (QFilter[])new QFilter[]{idFilter});
                if (thirdOrg != null) {
                    awsOrgId = thirdOrg.getLong("orgid");
                } else {
                    QFilter idFilter11;
                    DynamicObject[] org11;
                    QFilter idFilter1 = new QFilter("number", "=", (Object)starrySkyOrgId);
                    DynamicObject[] org = BusinessDataServiceHelper.load((String)"bos_org", (String)"id, number, name", (QFilter[])new QFilter[]{idFilter1});
                    if (org != null && org.length > 0) {
                        return org[0].getLong("id");
                    }
                    if (BigDecimal.ZERO.compareTo(BigDecimalUtil.transDecimal(starrySkyOrgId)) > 0 && (org11 = BusinessDataServiceHelper.load((String)"bos_org", (String)"id, number, name", (QFilter[])new QFilter[]{idFilter11 = new QFilter("id", "=", (Object)BigDecimalUtil.transDecimal(starrySkyOrgId))})) != null && org11.length > 0) {
                        return org11[0].getLong("id");
                    }
                }
            }
            catch (Exception e) {
                logger.info("\u6839\u636e\u661f\u7a7a\u7ec4\u7ec7\u83b7\u53d6\u7ec4\u7ec7id\u5931\u8d25");
            }
        }
        return awsOrgId;
    }

    private void saveSerialNo(String awsSerialNo, InvoiceSaveResult saveResult) {
        try {
            if (!StringUtils.isEmpty((CharSequence)awsSerialNo) && !saveResult.getSerialNo().equals(awsSerialNo)) {
                QFilter filter = new QFilter("aws_serial_no", "=", (Object)awsSerialNo);
                DynamicObject obj = QueryServiceHelper.queryOne((String)"rim_invoice_serial", (String)"id,serial_no", (QFilter[])new QFilter[]{filter});
                if (obj == null) {
                    obj = BusinessDataServiceHelper.newDynamicObject((String)"rim_invoice_serial");
                    obj.set("aws_serial_no", (Object)awsSerialNo);
                    obj.set("serial_no", (Object)saveResult.getSerialNo());
                    obj.set("create_time", (Object)new Date());
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
                } else if (!saveResult.getSerialNo().equals(obj.getString("serial_no"))) {
                    obj = BusinessDataServiceHelper.loadSingle((Object)obj.get("id"), (String)"rim_invoice_serial");
                    obj.set("aws_serial_no", (Object)awsSerialNo);
                    obj.set("serial_no", (Object)saveResult.getSerialNo());
                    obj.set("create_time", (Object)new Date());
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
                }
            }
        }
        catch (Exception e) {
            logger.info("\u4fdd\u5b58\u6d41\u6c34\u53f7\u5173\u7cfb\u62a5\u9519{}-{},{}", new Object[]{awsSerialNo, saveResult, e.getMessage()});
        }
    }

    private Long saveExpenseAndVouch(boolean saveExpenseFlag, String serialNo, JSONArray expenseArray, JSONArray vouchArray) {
        if (!saveExpenseFlag) {
            return 0L;
        }
        long start = System.currentTimeMillis();
        Long returnOrg = 0L;
        this.deleteExpenseRelation(serialNo, expenseArray);
        QFilter resourceFilet = new QFilter("resource", "=", (Object)"aws");
        if (expenseArray != null) {
            QFilter serialFilet = new QFilter("serial_no", "=", (Object)serialNo);
            DeleteServiceHelper.delete((String)"rim_expense_relation", (QFilter[])new QFilter[]{serialFilet, resourceFilet});
            DynamicObjectCollection collect = QueryServiceHelper.query((String)"rim_expense_relation", (String)"expense_id,entityid,reimbursingid", (QFilter[])new QFilter[]{serialFilet});
            HashSet<String> expenseIdSet = new HashSet<String>(8);
            if (!CollectionUtils.isEmpty((Collection)collect)) {
                for (DynamicObject obj : collect) {
                    String entityid = obj.getString("entityid");
                    if (StringUtils.isEmpty((CharSequence)entityid)) continue;
                    expenseIdSet.add(obj.getString("entityid") + "_" + obj.getString("expense_id"));
                }
            }
            ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(expenseArray.size());
            int expenseStatus = -1;
            Date minDate = DateUtils.addYear(new Date(), -30);
            Date minDefDate = DateUtils.addYear(new Date(), -30);
            for (int i = 0; i < expenseArray.size(); ++i) {
                Long org;
                JSONObject json = expenseArray.getJSONObject(i);
                String status = json.getString("status");
                String expenseId = json.getString("expenseId");
                if (expenseId != null && expenseId.startsWith("rim_invoice") || !expenseIdSet.add(expenseId)) continue;
                String expenseNum = json.getString("expenseNum");
                String reimbursingId = json.getString("reimbursingId");
                String entityId = ExpenseConstant.getExpenseEntityId(expenseId, null);
                if (!"ap_invoice".equals(entityId) && !"ap_finapbill".equals(entityId) && (StringUtils.isEmpty((CharSequence)status) || "1".equals(status))) continue;
                DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"rim_expense_relation");
                obj.set("serial_no", (Object)serialNo);
                obj.set("resource", (Object)"aws");
                obj.set("expense_num", (Object)expenseNum);
                obj.set("expense_id", (Object)expenseId);
                obj.set("status", (Object)status);
                obj.set("reimbursingid", (Object)reimbursingId);
                obj.set("deduction_flag", (Object)json.getString("canBeDeduction"));
                obj.set("deduction_amount", (Object)BigDecimalUtil.transDecimal(json.getString("entryAmount")));
                obj.set("output_amount", (Object)BigDecimalUtil.transDecimal(json.getString("outputAmount")));
                obj.set("output_reason", (Object)json.getString("outputReason"));
                String expense_type = "";
                expense_type = "ap_invoice".equals(entityId) ? "1" : ("ap_finapbill".equals(entityId) ? "4" : entityId);
                obj.set("expense_type", (Object)expense_type);
                obj.set("entityid", (Object)entityId);
                if (!StringUtils.isEmpty((CharSequence)entityId) && StringUtils.isEmpty((CharSequence)reimbursingId)) {
                    reimbursingId = ExpenseConstant.getExpenseReimbursingid(expenseId, entityId);
                    obj.set("reimbursingid", (Object)reimbursingId);
                }
                Date expenseTime = null;
                if (StringUtils.isNotEmpty((CharSequence)json.getString("createTime"))) {
                    expenseTime = json.getDate("createTime");
                    obj.set("create_time", (Object)json.getDate("createTime"));
                } else {
                    obj.set("create_time", (Object)new Date());
                    expenseTime = minDefDate;
                }
                int curStatus = BigDecimalUtil.transDecimal(json.getString("status")).intValue();
                if (expenseStatus < curStatus) {
                    org = this.getExpenseOrg(entityId, reimbursingId);
                    if ("ap_invoice".equals(entityId) && org < 1L) {
                        org = this.getExpenseOrg("ap_finapbill", reimbursingId);
                    }
                    if ("ap_finapbill".equals(entityId) && org < 1L) {
                        org = this.getExpenseOrg("ap_invoice", reimbursingId);
                    }
                    if (org > 0L) {
                        expenseStatus = curStatus;
                        minDate = expenseTime;
                        returnOrg = org;
                    }
                } else if (expenseStatus == curStatus && expenseTime.compareTo(minDate) > 0) {
                    org = this.getExpenseOrg(entityId, reimbursingId);
                    if ("ap_invoice".equals(entityId) && org < 1L) {
                        org = this.getExpenseOrg("ap_finapbill", reimbursingId);
                    }
                    if ("ap_finapbill".equals(entityId) && org < 1L) {
                        org = this.getExpenseOrg("ap_invoice", reimbursingId);
                    }
                    if (org > 0L) {
                        expenseStatus = curStatus;
                        minDate = expenseTime;
                        returnOrg = org;
                    }
                }
                list.add(obj);
                this.cacheHead(json, returnOrg, expense_type, entityId);
            }
            SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
        }
        QFilter serialFilet1 = new QFilter("billid", "=", (Object)serialNo);
        QFilter serialFilet2 = new QFilter("bill_type", "=", (Object)"2");
        DeleteServiceHelper.delete((String)"rim_vouch_relation", (QFilter[])new QFilter[]{serialFilet1, serialFilet2, resourceFilet});
        if (vouchArray != null) {
            ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(vouchArray.size());
            for (int i = 0; i < vouchArray.size(); ++i) {
                JSONObject json = vouchArray.getJSONObject(i);
                DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"rim_vouch_relation");
                obj.set("billid", (Object)serialNo);
                obj.set("bill_type", (Object)"2");
                obj.set("resource", (Object)"aws");
                JSONObject vouchInfo = this.getVouchInfo(json.getString("vouchId"));
                if (vouchInfo != null) {
                    obj.set("vouchid", (Object)vouchInfo.getString("vouchId"));
                    obj.set("vouch_no", (Object)vouchInfo.getString("vouchNo"));
                    obj.set("account_date", (Object)vouchInfo.getDate("accountDate"));
                    this.setAccountTime(obj, vouchInfo);
                } else {
                    obj.set("vouchid", (Object)json.getString("vouchId"));
                    obj.set("vouch_no", (Object)json.getString("vouchNo"));
                    obj.set("account_date", (Object)json.getDate("accountDate"));
                    this.setAccountTime(obj, json);
                }
                list.add(obj);
            }
            SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
        }
        ExpenseService expenseService = new ExpenseService();
        ArrayList<String> serialList = new ArrayList<String>(1);
        serialList.add(serialNo);
        expenseService.updateInvoiceMain(serialList, null, InvoiceSaveConstant.INVOICE_SAVE_FROM_VALUE);
        logger.info("\u5904\u7406\u62a5\u9500\u4fe1\u606f\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
        return returnOrg;
    }

    private void setAccountTime(DynamicObject obj, JSONObject vouchInfo) {
        if (obj == null || vouchInfo == null) {
            return;
        }
        String accountTimeStr = vouchInfo.getString("accountTime");
        Date accountTime = null;
        if (StringUtils.isNotEmpty((CharSequence)accountTimeStr)) {
            try {
                accountTime = vouchInfo.getDate("accountTime");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (accountTime == null) {
            accountTime = vouchInfo.getDate("accountDate");
        }
        obj.set("account_time", (Object)accountTime);
    }

    private JSONObject getVouchInfo(String vouchId) {
        Long longId = BigDecimalUtil.transDecimal(vouchId).longValue();
        if (longId < 1L) {
            return null;
        }
        try {
            QFilter qFilter = new QFilter("id", "=", (Object)longId);
            DynamicObjectCollection vouchers = QueryServiceHelper.query((String)"gl_voucher", (String)"id, billno, period.number, bizdate, bookeddate", (QFilter[])new QFilter[]{qFilter});
            if (vouchers != null && !vouchers.isEmpty()) {
                DynamicObject voucher = (DynamicObject)vouchers.get(0);
                String vouchNo = voucher.getString("billno");
                String period = voucher.getString("period.number");
                JSONObject voucherInfo = new JSONObject();
                voucherInfo.put("vouchId", (Object)longId);
                voucherInfo.put("vouchNo", (Object)vouchNo);
                voucherInfo.put("period", (Object)period);
                voucherInfo.put("accountDate", (Object)DateUtils.format(voucher.getDate("bookeddate")));
                voucherInfo.put("businessDate", (Object)DateUtils.format(voucher.getDate("bizdate")));
                return voucherInfo;
            }
        }
        catch (Exception e) {
            logger.info("\u67e5\u8be2\u51ed\u8bc1\u8be6\u60c5\u5931\u8d25{}", (Object)vouchId);
        }
        return null;
    }

    private Long getOrgByClientId(JSONArray expenseArray) {
        long start = System.currentTimeMillis();
        Long returnOrg = 0L;
        String finalClientId = null;
        if (expenseArray != null) {
            int expenseStatus = -1;
            Date minDate = DateUtils.addYear(new Date(), -30);
            Date minDefDate = DateUtils.addYear(new Date(), -30);
            HashSet<String> expenseIdSet = new HashSet<String>(8);
            for (int i = 0; i < expenseArray.size(); ++i) {
                Long org;
                JSONObject json = expenseArray.getJSONObject(i);
                String expenseId = json.getString("expenseId");
                String clientId = json.getString("clientId");
                if (!expenseIdSet.add(expenseId) || !expenseIdSet.add(clientId)) continue;
                Date expenseTime = null;
                expenseTime = StringUtils.isNotEmpty((CharSequence)json.getString("createTime")) ? json.getDate("createTime") : minDefDate;
                int curStatus = BigDecimalUtil.transDecimal(json.getString("status")).intValue();
                if (expenseStatus < curStatus) {
                    expenseStatus = curStatus;
                    minDate = expenseTime;
                    org = this.queryOrg(clientId);
                    if (org <= 0L) continue;
                    returnOrg = org;
                    finalClientId = clientId;
                    continue;
                }
                if (expenseStatus != curStatus || expenseTime.compareTo(minDate) <= 0) continue;
                expenseStatus = curStatus;
                minDate = expenseTime;
                org = this.queryOrg(clientId);
                if (org <= 0L) continue;
                returnOrg = org;
                finalClientId = clientId;
            }
        }
        logger.info("\u5904\u7406getOrgByClientId\uff1a{}-{}-{}", new Object[]{finalClientId, returnOrg, System.currentTimeMillis() - start});
        return returnOrg;
    }

    private Long queryOrg(String clientId) {
        try {
            QFilter enableQFilter1 = new QFilter("enable", "=", (Object)true);
            QFilter enableQFilter2 = new QFilter("client_id", "=", (Object)clientId);
            DynamicObject configResult = QueryServiceHelper.queryOne((String)"er_bd_kdinvoicecloudcfg", (String)"org", (QFilter[])new QFilter[]{enableQFilter1, enableQFilter2});
            if (configResult != null) {
                return BigDecimalUtil.transDecimal(configResult.get("org")).longValue();
            }
            DynamicObject groupResult = QueryServiceHelper.queryOne((String)"er_bd_kdinvoicecloudcfgct", (String)"org", (QFilter[])new QFilter[]{enableQFilter1, enableQFilter2});
            if (groupResult != null) {
                return BigDecimalUtil.transDecimal(groupResult.get("org")).longValue();
            }
        }
        catch (Exception e) {
            logger.info("\u83b7\u53d6\u7ec4\u7ec7\u5931\u8d25{},{}", (Object)clientId, (Object)e.getMessage());
        }
        return 0L;
    }

    private void cacheHead(JSONObject json, Long returnOrg, String expense_type, String entityId) {
        JSONObject expenseHead = new JSONObject();
        String expenseId = json.getString("expenseId");
        expenseHead.put("expense_num", (Object)json.getString("expenseNum"));
        expenseHead.put("expense_id", (Object)json.getString("expenseId"));
        expenseHead.put("expense_type", (Object)expense_type);
        expenseHead.put("status", (Object)json.getString("status"));
        expenseHead.put("resource", (Object)"aws");
        expenseHead.put("entityid", (Object)entityId);
        expenseHead.put("orgid", (Object)returnOrg);
        expenseHead.put("reimbursing_id", (Object)json.getString("reimbursingId"));
        if (StringUtils.isNotEmpty((CharSequence)json.getString("createTime"))) {
            Date tempTime = json.getDate("createTime");
            expenseHead.put("create_time", (Object)DateUtils.format(tempTime, "yyyy-MM-dd HH:mm:ss"));
        }
        CacheHelper.put("expense_" + expenseId, expenseHead.toJSONString(), 600);
        HashMap<String, JSONObject> map = (HashMap<String, JSONObject>)this.expenseMap.get(EXPENSE_INFO);
        if (map == null) {
            map = new HashMap<String, JSONObject>(4);
        }
        map.put(json.getString("expenseId"), expenseHead);
        this.expenseMap.put(EXPENSE_INFO, map);
    }

    private Long getExpenseOrg(String entityId, String reimbursingid) {
        Long pk = BigDecimalUtil.transDecimal(reimbursingid).longValue();
        if (StringUtils.isEmpty((CharSequence)entityId) || pk < 1L) {
            return 0L;
        }
        try {
            QFilter filter = new QFilter("id", "=", (Object)pk);
            String orgField = "costcompany.id as org";
            orgField = "ap_finapbill".equals(entityId) || "ap_invoice".equals(entityId) ? "org.id as org" : ("er_checkingpaybill".equals(entityId) ? "company.id as org" : "costcompany.id as org");
            DynamicObject obj = QueryServiceHelper.queryOne((String)entityId, (String)orgField, (QFilter[])new QFilter[]{filter});
            if (obj != null) {
                return obj.getLong("org");
            }
        }
        catch (Exception e) {
            return 0L;
        }
        return 0L;
    }

    private void deleteExpenseRelation(String serialNo, JSONArray expenseArray) {
        QFilter serialFilet = new QFilter("serial_no", "=", (Object)serialNo);
        QFilter resourceFilet = new QFilter("resource", "=", (Object)"aws");
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"rim_expense_relation", (String)"id,expense_id", (QFilter[])new QFilter[]{serialFilet, resourceFilet});
        if (!CollectionUtils.isEmpty((Collection)collection)) {
            HashSet expenseIdSet = new HashSet(collection.size());
            ArrayList ids = new ArrayList(collection.size());
            collection.forEach(obj -> {
                expenseIdSet.add(obj.getString("expense_id"));
                ids.add(obj.get("id"));
            });
            this.expenseMap.put(DELETE_EXPENSE_ID, expenseIdSet);
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"rim_expense_relation"), (Object[])ids.toArray());
        }
    }

    public static void megerExpenseInfo(InvoiceSaveResult result, Map<String, Object> expenseMap) {
        Map expenseMap1 = (Map)result.getExtObject();
        if (expenseMap1 != null) {
            Set expenseIdSet = (Set)expenseMap1.get(DELETE_EXPENSE_ID);
            Map expenseInfo = (Map)expenseMap1.get(EXPENSE_INFO);
            HashSet allIdSet = (HashSet)expenseMap.get(DELETE_EXPENSE_ID);
            HashMap allInfo = (HashMap)expenseMap.get(EXPENSE_INFO);
            if (expenseIdSet != null && !expenseIdSet.isEmpty()) {
                if (allIdSet == null) {
                    allIdSet = new HashSet(2);
                }
                allIdSet.addAll(expenseIdSet);
                expenseMap.put(DELETE_EXPENSE_ID, allIdSet);
            }
            if (expenseInfo != null && !expenseInfo.isEmpty()) {
                if (allInfo == null) {
                    allInfo = new HashMap(2);
                }
                allInfo.putAll(expenseInfo);
                expenseMap.put(EXPENSE_INFO, allInfo);
            }
        }
    }

    public static void deleteExpenseFinish(Map<String, Object> expenseMap) {
        if (expenseMap != null) {
            Map expenseInfo = (Map)expenseMap.get(EXPENSE_INFO);
            Set expenseIdSet = (Set)expenseMap.get(DELETE_EXPENSE_ID);
            if (expenseInfo != null && !expenseInfo.isEmpty()) {
                for (Map.Entry entry : expenseInfo.entrySet()) {
                    InvoiceHisDataSaveCallable.saveExpenseFormCache((String)entry.getKey(), (JSONObject)entry.getValue());
                    if (expenseIdSet == null) continue;
                    expenseIdSet.remove(entry.getKey());
                }
            }
            if (expenseIdSet != null && !expenseIdSet.isEmpty()) {
                QFilter idFilter = new QFilter("expense_id", "in", (Object)expenseIdSet);
                QFilter resourceFilter = new QFilter("resource", "=", (Object)"aws");
                DynamicObjectCollection collection = QueryServiceHelper.query((String)"rim_expense_relation", (String)"expense_id", (QFilter[])new QFilter[]{resourceFilter, idFilter});
                for (DynamicObject object : collection) {
                    String id = object.getString("expense_id");
                    expenseIdSet.remove(id);
                }
                if (expenseIdSet.size() > 0) {
                    idFilter = new QFilter("expense_id", "in", (Object)expenseIdSet);
                    DeleteServiceHelper.delete((String)"rim_expense", (QFilter[])new QFilter[]{resourceFilter, idFilter});
                }
            }
        }
    }

    private static void saveExpenseFormCache(String expenseId, JSONObject bodyObject) {
        QFilter resourceFilet = new QFilter("resource", "=", (Object)"aws");
        QFilter idfilter = new QFilter("expense_id", "=", (Object)expenseId);
        List expenselist = QueryServiceHelper.queryPrimaryKeys((String)"rim_expense", (QFilter[])new QFilter[]{idfilter, resourceFilet}, (String)"id", (int)5);
        DynamicObject expenseObject = null;
        if (!CollectionUtils.isEmpty((Collection)expenselist)) {
            Object pk = expenselist.get(0);
            if (expenselist.size() > 1) {
                QFilter pkfilter = new QFilter("id", "!=", pk);
                DeleteServiceHelper.delete((String)"rim_expense", (QFilter[])new QFilter[]{idfilter, pkfilter});
            }
            expenseObject = BusinessDataServiceHelper.loadSingle(pk, (String)"rim_expense");
            expenseObject.set("update_time", (Object)new Date());
        } else {
            expenseObject = BusinessDataServiceHelper.newDynamicObject((String)"rim_expense");
            expenseObject.set("create_time", (Object)new Date());
            expenseObject.set("update_time", (Object)new Date());
        }
        expenseObject.set("expense_num", (Object)bodyObject.getString("expense_num"));
        expenseObject.set("expense_id", (Object)expenseId);
        expenseObject.set("expense_type", (Object)bodyObject.getString("expense_type"));
        expenseObject.set("status", (Object)bodyObject.getString("status"));
        expenseObject.set("resource", (Object)"aws");
        expenseObject.set("entityid", (Object)bodyObject.getString("entityid"));
        expenseObject.set("orgid", (Object)bodyObject.getLong("orgid"));
        expenseObject.set("reimbursing_id", (Object)bodyObject.getString("expense_num"));
        String time = bodyObject.getString("create_time");
        if (StringUtils.isNotEmpty((CharSequence)time)) {
            expenseObject.set("create_time", (Object)DateUtils.stringToDate(time, "yyyy-MM-dd HH:mm:ss"));
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{expenseObject});
    }

    public void syncImage(JSONArray expenseArray) {
        if (CollectionUtils.isEmpty((Collection)expenseArray)) {
            return;
        }
        String sync = RimConfigUtils.getConfig("sync_image");
        if (!"1".equals(sync) || expenseArray == null) {
            logger.info("\u672a\u5f00\u542f\u540c\u6b65\u5f71\u50cf\u914d\u7f6e");
            return;
        }
        for (int i = 0; i < expenseArray.size(); ++i) {
            String selectField;
            DynamicObject billimagemaintain;
            JSONObject json = expenseArray.getJSONObject(i);
            String expenseId = json.getString("expenseId");
            int lastIndex = expenseId.lastIndexOf("_");
            if (lastIndex != -1) {
                expenseId = expenseId.substring(lastIndex + 1);
            }
            if ((billimagemaintain = BusinessDataServiceHelper.loadSingle((String)"billimagemaintain", (String)(selectField = "billtype,imagenumber,billnumber,billid"), (QFilter[])new QFilter[]{new QFilter("billid", "=", (Object)expenseId)})) == null) {
                logger.info("\u3010\u5f71\u50cf\u540c\u6b65\u3011\uff0c\u672a\u627e\u5230\u5bf9\u5e94\u5355\u636e\u7684\u5f71\u50cf\u7f16\u7801\uff1a{}", (Object)json.toJSONString());
                continue;
            }
            JSONObject param = new JSONObject();
            param.put("fscanBillNo", (Object)billimagemaintain.getString("imagenumber"));
            param.put("fbillId", (Object)expenseId);
            param.put("fbillTypeCode", (Object)billimagemaintain.getString("billtype"));
            param.put("billNo", (Object)billimagemaintain.getString("billnumber"));
            param.put("syncInvoice", (Object)"0");
            String reimbursingId = json.getString("expenseId");
            String entityId = ExpenseConstant.getExpenseEntityId(reimbursingId, null);
            Long org = this.getExpenseOrg(entityId, expenseId);
            if ("ap_invoice".equals(entityId) && org < 1L) {
                org = this.getExpenseOrg("ap_finapbill", expenseId);
            }
            if ("ap_finapbill".equals(entityId) && org < 1L) {
                org = this.getExpenseOrg("ap_invoice", expenseId);
            }
            if (org > 0L) {
                param.put("orgId", (Object)org);
            }
            logger.info("\u3010\u5f71\u50cf\u540c\u6b65\u3011\uff1a{}", (Object)param);
            DispatchServiceHelper.invokeBizService((String)"imc", (String)"bds", (String)"YXZSService", (String)"syncInvoice", (Object[])new Object[]{param});
        }
    }
}

