/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.collector;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.imc.rim.common.constant.ExpenseStatusEnum;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.invoice.collector.InvoiceHisDataSaveCallable;
import kd.imc.rim.common.invoice.collector.InvoiceHisDataSyncThread;
import kd.imc.rim.common.invoice.recognitionnew.task.handle.FileHandleService;
import kd.imc.rim.common.invoice.save.InvoiceSaveResult;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.utils.AwsFpyService;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.LockUtils;
import kd.imc.rim.common.utils.MD5;
import kd.imc.rim.common.utils.MetadataUtil;
import kd.imc.rim.common.utils.RimConfigUtils;

public class InvoiceHisDataSyncService {
    private static Log LOGGER = LogFactory.getLog(InvoiceHisDataSyncService.class);
    private static ThreadPool hisDataSaveThreadPool = ThreadPools.newFixedThreadPool((String)"InvoiceHisDataSyncService", (int)6);
    public static final String KEY_ORG_ID = "org_id";
    public static final String KEY_DATA_START_DATE = "data_start_time";
    public static final String KEY_START_TIME = "start_time";
    public static final String KEY_END_TIME = "end_time";
    public static final String KEY_COUNT = "count";
    public static final String KEY_STATUS = "status";
    public static final String KEY_MSG = "message";
    public static final String KEY_CACHE = "rim_history_data";
    public static final String STATUS_FAIL = "0";
    public static final String STATUS_SUCCESS = "1";
    public static final String STATUS_WAITING = "2";
    public static final String STATUS_SYNCING = "3";

    public static boolean needSync() {
        return STATUS_SUCCESS.equals(RimConfigUtils.getConfig("sync_his"));
    }

    public static void start() {
        if (InvoiceHisDataSyncService.needSync()) {
            InvoiceHisDataSyncThread thread = new InvoiceHisDataSyncThread(RequestContext.get());
            ThreadPools.executeOnceIncludeRequestContext((String)"InvoiceHisDataSyncService-start", (Runnable)thread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sync(Long logId, Long orgId, String clientId, String startTime, String endTime, String syncType) {
        String status;
        DynamicObject logObj = null;
        if (logId != null && logId > 0L && (logObj = BusinessDataServiceHelper.loadSingle((Object)logId, (String)"rim_his_sync_log")) != null && !STATUS_WAITING.equals(status = logObj.getString(KEY_STATUS))) {
            return;
        }
        Map<String, Object> config = InvoiceHisDataSyncService.getConfig(orgId, clientId);
        if (config == null) {
            return;
        }
        String clientSecret = (String)config.get("client_secret");
        String taxNo = (String)config.get("tax_no");
        String companyName = (String)config.get("company_name");
        DLock lock = LockUtils.createDLockByMd5((String)("InvoiceHisDataSyncService" + clientId), (String)"downHisInvoice");
        if (lock.tryLock()) {
            try {
                if (logObj == null) {
                    logObj = InvoiceHisDataSyncService.getSyncLogObj(orgId, clientId, syncType, startTime);
                } else {
                    logObj.set(KEY_STATUS, (Object)STATUS_SYNCING);
                    logObj.set(KEY_START_TIME, (Object)new Date());
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{logObj});
                }
                JSONObject getDataResult = InvoiceHisDataSyncService.getData(orgId, clientId, clientSecret, startTime, endTime);
                LOGGER.info("\u4e0b\u8f7d\u5386\u53f2\u53d1\u7968\u6570\u636e{},{}", (Object)clientId, (Object)getDataResult.toJSONString());
                logObj.set("org", (Object)orgId);
                logObj.set("tax_no", (Object)taxNo);
                logObj.set("company_name", (Object)companyName);
                logObj.set("clientid", (Object)clientId);
                logObj.set("data_date", (Object)startTime);
                logObj.set("sync_type", (Object)syncType);
                InvoiceHisDataSyncService.setLogObject(getDataResult, logObj);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{logObj});
                if (STATUS_SUCCESS.equals(logObj.getString(KEY_STATUS))) {
                    List list;
                    QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
                    QFilter idFilter = new QFilter("id", "!=", (Object)logId);
                    QFilter clientidFilter = new QFilter("clientid", "=", (Object)clientId);
                    QFilter dataDateFilter = null;
                    if (null != startTime) {
                        dataDateFilter = new QFilter("data_date", "=", (Object)startTime);
                    }
                    if (!CollectionUtils.isEmpty((Collection)(list = QueryServiceHelper.queryPrimaryKeys((String)"rim_his_sync_log", (QFilter[])new QFilter[]{orgFilter, clientidFilter, idFilter, dataDateFilter}, null, (int)100)))) {
                        DynamicObject[] logList;
                        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"rim_his_sync_log");
                        for (DynamicObject log : logList = BusinessDataServiceHelper.load((Object[])list.toArray(), (DynamicObjectType)mainEntityType)) {
                            log.set(KEY_STATUS, (Object)STATUS_SUCCESS);
                            log.set(KEY_END_TIME, (Object)new Date());
                        }
                        SaveServiceHelper.save((DynamicObject[])logList);
                    }
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    public static void setLogObject(JSONObject getDataResult, DynamicObject logObj) {
        int dealTimes = BigDecimalUtil.transDecimal(logObj.get("deal_times")).intValue();
        logObj.set("deal_times", (Object)(dealTimes + 1));
        logObj.set(KEY_START_TIME, getDataResult.get((Object)"startTime"));
        logObj.set(KEY_END_TIME, getDataResult.get((Object)"endTime"));
        logObj.set("success", getDataResult.get((Object)"successCount"));
        logObj.set("page_no", getDataResult.get((Object)"pageNo"));
        String errorCode = getDataResult.getString("errcode");
        StringBuilder sb = new StringBuilder();
        if ("0000".equals(errorCode)) {
            logObj.set(KEY_STATUS, (Object)STATUS_SUCCESS);
            sb.append(String.format(ResManager.loadKDString((String)"\u6210\u529f\uff1a\u8bf7\u6c42\u8017\u65f6ms\uff1a%1$s ,\u5904\u7406\u8017\u65f6ms\uff1a%2$s", (String)"InvoiceHisDataSyncService_13", (String)"imc-rim-common", (Object[])new Object[0]), getDataResult.get((Object)"httpTime"), getDataResult.get((Object)"saveTime")));
        } else {
            logObj.set(KEY_STATUS, (Object)STATUS_FAIL);
            sb.append(String.format(ResManager.loadKDString((String)"\u5931\u8d25\uff1a%1$s\uff0c\u63cf\u8ff0\uff1a%2$s\uff0c \u8bf7\u6c42\u8017\u65f6\uff1a%3$s", (String)"InvoiceHisDataSyncService_1", (String)"imc-rim-common", (Object[])new Object[0]), getDataResult.getString("errcode"), getDataResult.getString("description"), getDataResult.get((Object)"httpTime")));
        }
        logObj.set("msg", (Object)sb.toString());
    }

    private static DynamicObject getSyncLogObj(Long orgId, String clientId, String syncType, String dataDate) {
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter clientidFilter = new QFilter("clientid", "=", (Object)clientId);
        QFilter syncTypeFilter = new QFilter("sync_type", "=", (Object)syncType);
        QFilter appidFilter = new QFilter("appid", "=", (Object)"rim");
        QFilter dataDateFilter = null;
        if (null != dataDate) {
            dataDateFilter = new QFilter("data_date", "=", (Object)dataDate);
        }
        List pks = QueryServiceHelper.queryPrimaryKeys((String)"rim_his_sync_log", (QFilter[])new QFilter[]{orgFilter, clientidFilter, syncTypeFilter, dataDateFilter, appidFilter}, null, (int)2);
        DynamicObject obj = null;
        if (pks != null && !pks.isEmpty()) {
            obj = BusinessDataServiceHelper.loadSingle(pks.get(0), (String)"rim_his_sync_log");
            int times = obj.getInt("deal_times");
            obj.set("deal_times", (Object)(times + 1));
        } else {
            obj = BusinessDataServiceHelper.newDynamicObject((String)"rim_his_sync_log");
            obj.set("appid", (Object)"rim");
            obj.set("deal_times", (Object)1);
        }
        return obj;
    }

    public static JSONObject getData(Long orgId, String clientId, String clientSecret, String startTime, String endTime) {
        JSONObject resultObject = new JSONObject();
        resultObject.put("startTime", (Object)new Date());
        int pageNo = 0;
        resultObject.put("pageNo", (Object)pageNo);
        String errorCode = "";
        String errorMsg = "";
        long httpTime = 0L;
        long saveTime = 0L;
        int successCount = 0;
        try {
            AwsFpyService service = AwsFpyService.newInstance("sync_his");
            String token = null;
            try {
                token = service.getAccessToken(clientId, clientSecret);
            }
            catch (MsgException e) {
                throw e;
            }
            catch (Exception e) {
                throw new MsgException(e, "0001", ResManager.loadKDString((String)"\u83b7\u53d6token\u5931\u8d25", (String)"InvoiceHisDataSyncService_3", (String)"imc-rim-common", (Object[])new Object[0]));
            }
            String url = service.getUrl("query_invoice", token);
            RequestContext request = RequestContext.get();
            JSONObject param = new JSONObject();
            param.put("erpTenantId", (Object)request.getTenantId());
            int pageSize = BigDecimalUtil.transDecimal(RimConfigUtils.getConfig("synchis_pagesize")).intValue();
            if (pageSize < 1 || pageSize > 500) {
                pageSize = 300;
            }
            param.put("pageSize", (Object)pageSize);
            if (StringUtils.isNotEmpty((CharSequence)startTime)) {
                param.put("updateTimeStart", (Object)startTime);
            }
            if (StringUtils.isNotEmpty((CharSequence)endTime)) {
                param.put("updateTimeEnd", (Object)endTime);
            }
            while (true) {
                if (!InvoiceHisDataSyncService.needSync()) {
                    errorCode = "8001";
                    errorMsg = ResManager.loadKDString((String)"\u5f3a\u5236\u505c\u6b62", (String)"InvoiceHisDataSyncService_4", (String)"imc-rim-common", (Object[])new Object[0]);
                    LOGGER.info("\u4e0b\u8f7d\u5386\u53f2\u53d1\u7968\u6570\u636erim_config_synchis_stop\u5f00\u5173\u6253\u5f00\uff0c\u5f3a\u5236\u505c\u6b62\u540c\u6b65");
                    break;
                }
                param.put("pageNo", (Object)(++pageNo));
                param.put("expenseInfo", (Object)STATUS_SUCCESS);
                param.put("syncWcy", (Object)STATUS_SUCCESS);
                param.put("requestId", (Object)MD5.md5Hex((String)(clientId + startTime + pageNo)));
                LOGGER.info("\u4e0b\u8f7d\u5386\u53f2\u53d1\u7968\u6570\u636e{},{},{}", new Object[]{clientId, param.toJSONString(), url});
                long start = System.currentTimeMillis();
                JSONObject result = service.postAppJson(url, param.toJSONString());
                if (result == null) {
                    result = service.postAppJson(url, param.toJSONString());
                }
                httpTime += System.currentTimeMillis() - start;
                if (ResultContant.isSuccess(result).booleanValue()) {
                    JSONArray data = result.getJSONArray("data");
                    if (data == null || data.isEmpty()) {
                        errorCode = "0000";
                        break;
                    }
                    long startSave = System.currentTimeMillis();
                    int size = data.size();
                    LOGGER.info("\u4e0b\u8f7d\u5386\u53f2\u53d1\u7968\u6570\u636e" + clientId + "\u8017\u65f61\uff1a" + (System.currentTimeMillis() - start) + "ms,pageNo" + pageNo + ",size:" + size);
                    successCount += InvoiceHisDataSyncService.saveInvoice(orgId, request, data);
                    saveTime += System.currentTimeMillis() - startSave;
                } else {
                    if (result != null) {
                        errorCode = result.getString("errcode");
                        errorMsg = result.getString("description");
                    } else {
                        errorCode = "8002";
                    }
                    LOGGER.info("\u4e0b\u8f7d\u5386\u53f2\u53d1\u7968\u5931\u8d25" + clientId + ",result:" + result);
                    break;
                }
                resultObject.put("pageNo", (Object)pageNo);
                LOGGER.info("\u4e0b\u8f7d\u5386\u53f2\u53d1\u7968\u6570\u636e" + clientId + "\u8017\u65f62\uff1a" + (System.currentTimeMillis() - start) + "ms,pageNo:" + pageNo);
            }
        }
        catch (MsgException e) {
            errorCode = e.getErrorCode();
            errorMsg = e.getMessage();
        }
        catch (Exception e) {
            LOGGER.error("\u5904\u7406\u9519\u8bef8008", (Throwable)e);
            errorCode = "8008";
            errorMsg = e.getMessage();
        }
        resultObject.put("errcode", (Object)errorCode);
        resultObject.put("description", (Object)errorMsg);
        resultObject.put("httpTime", (Object)httpTime);
        resultObject.put("saveTime", (Object)saveTime);
        resultObject.put("successCount", (Object)successCount);
        resultObject.put("endTime", (Object)new Date());
        return resultObject;
    }

    public static int saveInvoice(Long orgId, RequestContext request, JSONArray data, String phone) {
        ArrayList<Future<InvoiceSaveResult>> futureList = new ArrayList<Future<InvoiceSaveResult>>(8);
        int successCount = 0;
        for (int i = 0; i < data.size(); ++i) {
            JSONObject invoice = data.getJSONObject(i);
            invoice.put(KEY_ORG_ID, (Object)orgId);
            invoice.put("override", (Object)STATUS_SUCCESS);
            invoice.put("overrideOrg", (Object)STATUS_FAIL);
            if (StringUtils.isNotEmpty((CharSequence)phone)) {
                invoice.put("syncAll", (Object)STATUS_SUCCESS);
                ArrayList<String> userPhoneList = new ArrayList<String>(1);
                userPhoneList.add(phone);
                invoice.put("saveExpenseFlag", (Object)STATUS_FAIL);
                invoice.remove((Object)"expenseArray");
                invoice.put("userPhoneList", userPhoneList);
            }
            InvoiceHisDataSaveCallable callable = new InvoiceHisDataSaveCallable(request, invoice);
            futureList.add(hisDataSaveThreadPool.submit((Callable)callable));
            InvoiceHisDataSyncService.wait(futureList, i);
            ++successCount;
        }
        InvoiceHisDataSyncService.wait(futureList, 6);
        return successCount;
    }

    public static int saveInvoice(Long orgId, RequestContext request, JSONArray data) {
        return InvoiceHisDataSyncService.saveInvoice(orgId, request, data, null);
    }

    private static void wait(List<Future<InvoiceSaveResult>> futureList, int index) {
        if (index > 0 && index % 6 == 0 && !futureList.isEmpty()) {
            HashMap<String, Object> expenseMap = new HashMap<String, Object>(6);
            for (Future<InvoiceSaveResult> future : futureList) {
                try {
                    InvoiceSaveResult result = future.get();
                    InvoiceHisDataSaveCallable.megerExpenseInfo(result, expenseMap);
                }
                catch (Exception exception) {}
            }
            InvoiceHisDataSaveCallable.deleteExpenseFinish(expenseMap);
            futureList.clear();
        }
    }

    public static Map<String, Object> getConfig(Long orgId, String clientId) {
        QFilter filter = new QFilter("client_id", "=", (Object)clientId);
        QFilter enableQFilter = new QFilter("enable", "=", (Object)true);
        DynamicObjectCollection configResult = QueryServiceHelper.query((String)"er_bd_kdinvoicecloudcfg", (String)"id,org,taxregnum,firmname,client_id,client_secret,encrypt_key", (QFilter[])new QFilter[]{filter, enableQFilter});
        if (!CollectionUtils.isEmpty((Collection)configResult)) {
            DynamicObject obj = (DynamicObject)configResult.get(0);
            HashMap<String, Object> client = new HashMap<String, Object>(8);
            client.put("org", orgId);
            client.put("tax_no", obj.get("taxregnum"));
            client.put("clientid", obj.get("client_id"));
            client.put("company_name", obj.get("firmname"));
            client.put("client_secret", obj.get("client_secret"));
            client.put("encrypt_key", obj.get("encrypt_key"));
            return client;
        }
        DynamicObjectCollection groupResult = QueryServiceHelper.query((String)"er_bd_kdinvoicecloudcfgct", (String)"client_id,client_secret,encrypt_key,createorg,taxregnum,firmname", (QFilter[])new QFilter[]{filter, enableQFilter});
        if (!CollectionUtils.isEmpty((Collection)groupResult)) {
            DynamicObject obj = (DynamicObject)groupResult.get(0);
            HashMap<String, Object> client = new HashMap<String, Object>(8);
            client.put("org", orgId);
            client.put("tax_no", obj.get("taxregnum"));
            client.put("clientid", obj.get("client_id"));
            client.put("client_secret", obj.get("client_secret"));
            client.put("encrypt_key", obj.get("encrypt_key"));
            client.put("company_name", obj.get("firmname"));
            return client;
        }
        return null;
    }

    public static List<Map<String, Object>> queryClients() {
        HashSet<String> set = new HashSet<String>(8);
        QFilter filter = new QFilter(KEY_STATUS, "=", (Object)STATUS_FAIL);
        DynamicObjectCollection collect = QueryServiceHelper.query((String)"rim_his_sync_config", (String)"clientid", (QFilter[])new QFilter[]{filter});
        for (DynamicObject obj : collect) {
            set.add(obj.getString("clientid"));
        }
        boolean enable = true;
        QFilter enableQFilter = new QFilter("enable", "=", (Object)enable);
        DynamicObjectCollection configResult = QueryServiceHelper.query((String)"er_bd_kdinvoicecloudcfg", (String)"id,org,taxregnum,firmname,client_id,client_secret,encrypt_key", (QFilter[])new QFilter[]{enableQFilter});
        ArrayList<Map<String, Object>> clientList = new ArrayList<Map<String, Object>>(8);
        for (DynamicObject obj : configResult) {
            String clientId = obj.getString("client_id");
            if (clientId == null || "".equals(clientId.trim()) || !set.add(clientId)) continue;
            HashMap<String, Object> client = new HashMap<String, Object>(8);
            client.put("org", DynamicObjectUtil.getDynamicObjectLongValue(obj.get("org")));
            client.put("tax_no", obj.get("taxregnum"));
            client.put("clientid", obj.get("client_id"));
            client.put("company_name", obj.get("firmname"));
            client.put("client_secret", obj.get("client_secret"));
            client.put("encrypt_key", obj.get("encrypt_key"));
            clientList.add(client);
        }
        DynamicObjectCollection groupResult = QueryServiceHelper.query((String)"er_bd_kdinvoicecloudcfgct", (String)"client_id,client_secret,encrypt_key,createorg,taxregnum,firmname", (QFilter[])new QFilter[]{enableQFilter});
        for (DynamicObject obj : groupResult) {
            String clientId = obj.getString("client_id");
            if (clientId == null || "".equals(clientId.trim()) || !set.add(clientId)) continue;
            HashMap<String, Object> client = new HashMap<String, Object>(8);
            client.put("org", DynamicObjectUtil.getDynamicObjectLongValue(obj.get("createorg")));
            client.put("tax_no", obj.get("taxregnum"));
            client.put("clientid", obj.get("client_id"));
            client.put("client_secret", obj.get("client_secret"));
            client.put("encrypt_key", obj.get("encrypt_key"));
            client.put("company_name", obj.get("firmname"));
            clientList.add(client);
        }
        return clientList;
    }

    private static Map<String, String> getClient(String clientId) {
        boolean enable = true;
        QFilter filter = new QFilter("client_id", "=", (Object)clientId);
        QFilter enableQFilter = new QFilter("enable", "=", (Object)enable);
        DynamicObjectCollection configResult = QueryServiceHelper.query((String)"er_bd_kdinvoicecloudcfg", (String)"id,org,taxregnum,firmname,client_id,client_secret,encrypt_key", (QFilter[])new QFilter[]{enableQFilter, filter});
        if (configResult != null && !configResult.isEmpty()) {
            HashMap<String, String> client = new HashMap<String, String>(4);
            DynamicObject obj = (DynamicObject)configResult.get(0);
            client.put("clientId", String.valueOf(obj.get("client_id")));
            client.put("clientSecret", String.valueOf(obj.get("client_secret")));
            client.put("encryptKey", String.valueOf(obj.get("encrypt_key")));
            client.put("org", String.valueOf(DynamicObjectUtil.getDynamicObjectLongValue("org")));
            return client;
        }
        DynamicObjectCollection groupResult = QueryServiceHelper.query((String)"er_bd_kdinvoicecloudcfgct", (String)"client_id,client_secret,encrypt_key,createorg,taxregnum,firmname", (QFilter[])new QFilter[]{enableQFilter, filter});
        if (groupResult != null && !groupResult.isEmpty()) {
            HashMap<String, String> client = new HashMap<String, String>(4);
            DynamicObject obj = (DynamicObject)groupResult.get(0);
            client.put("clientId", String.valueOf(obj.get("client_id")));
            client.put("clientSecret", String.valueOf(obj.get("client_secret")));
            client.put("encryptKey", String.valueOf(obj.get("encrypt_key")));
            client.put("org", String.valueOf(DynamicObjectUtil.getDynamicObjectLongValue("createorg")));
            return client;
        }
        return null;
    }

    public static int syncExpenseInfo(Long orgId, String clientId, String expenseId, JSONArray serialList) {
        if (StringUtils.isEmpty((CharSequence)clientId) || StringUtils.isEmpty((CharSequence)expenseId) && (serialList == null || serialList.isEmpty())) {
            throw new KDException(new ErrorCode("9999", ResManager.loadKDString((String)"\u53c2\u6570\u4e3a\u7a7a", (String)"InvoiceHisDataSyncService_5", (String)"imc-rim-common", (Object[])new Object[0])), new Object[0]);
        }
        Map<String, String> client = InvoiceHisDataSyncService.getClient(clientId);
        if (client == null) {
            throw new KDException(new ErrorCode("9999", ResManager.loadKDString((String)"\u914d\u7f6e\u9519\u8bef", (String)"InvoiceHisDataSyncService_6", (String)"imc-rim-common", (Object[])new Object[0])), new Object[0]);
        }
        if (orgId == null || orgId < 1L) {
            orgId = BigDecimalUtil.transDecimal(client.get("org")).longValue();
        }
        RequestContext context = RequestContext.get();
        if (orgId == null || orgId < 1L) {
            orgId = context.getOrgId();
        }
        AwsFpyService service = AwsFpyService.newInstance("sync_his");
        String token = null;
        try {
            token = service.getAccessToken(client.get("clientId"), client.get("clientSecret"));
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, new ErrorCode("9999", ResManager.loadKDString((String)"\u83b7\u53d6token\u5931\u8d25", (String)"InvoiceHisDataSyncService_7", (String)"imc-rim-common", (Object[])new Object[0])), new Object[0]);
        }
        if (serialList == null || serialList.isEmpty()) {
            serialList = InvoiceHisDataSyncService.getSerialByExpense(orgId, expenseId, context, service, token);
        }
        return InvoiceHisDataSyncService.syncBySerials(orgId, context, service, token, serialList);
    }

    private static JSONArray getSerialByExpense(Long orgId, String expenseId, RequestContext context, AwsFpyService service, String token) {
        JSONObject param = new JSONObject();
        param.put("expenseId", (Object)expenseId);
        String url = service.getUrl("msg_getInvoiceByExpense", token);
        JSONObject expenseInfo = null;
        try {
            expenseInfo = service.postAppJson(url, param.toJSONString());
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, new ErrorCode("9999", ResManager.loadKDString((String)"\u83b7\u53d6\u62a5\u9500\u5355\u4fe1\u606f\u5931\u8d25", (String)"InvoiceHisDataSyncService_8", (String)"imc-rim-common", (Object[])new Object[0])), new Object[0]);
        }
        if (ResultContant.isSuccess(expenseInfo).booleanValue()) {
            JSONObject data = expenseInfo.getJSONObject("data");
            JSONArray array = data.getJSONArray("invoice");
            String returnId = expenseInfo.getString("expenseId");
            if (StringUtils.isNotEmpty((CharSequence)returnId)) {
                expenseId = returnId;
            }
            InvoiceHisDataSyncService.saveCover(data, expenseId);
            InvoiceHisDataSyncService.saveAttachment(data, expenseId);
            if (StringUtils.isNotEmpty((CharSequence)expenseId)) {
                try (TXHandle h = TX.requiresNew();){
                    LOGGER.info("\u6309\u5355\u540c\u6b65\u516c\u6709\u4e91\u5220\u9664\u5355\u636e\u4e0b\u7684\u53d1\u7968\u5173\u7cfb...");
                    QFilter resourceFilet1 = new QFilter("resource", "=", (Object)"aws");
                    QFilter resourceFilet2 = new QFilter("expense_id", "=", (Object)expenseId);
                    DeleteServiceHelper.delete((String)"rim_expense_relation", (QFilter[])new QFilter[]{resourceFilet1, resourceFilet2});
                }
            }
            JSONArray serialList = new JSONArray();
            if (!CollectionUtils.isEmpty((Collection)array)) {
                for (int i = 0; i < array.size(); ++i) {
                    JSONObject invoice = array.getJSONObject(i);
                    serialList.add((Object)invoice.getString("serialNo"));
                }
            } else {
                InvoiceHisDataSyncService.saveExpenseInfo(expenseInfo);
            }
            return serialList;
        }
        if (expenseInfo != null && "1162".equals(expenseInfo.getString("errcode"))) {
            throw new KDBizException(new ErrorCode("9996", ResManager.loadKDString((String)"\u53d1\u7968\u4e0d\u5b58\u5728", (String)"InvoiceHisDataSyncService_9", (String)"imc-rim-common", (Object[])new Object[0])), new Object[0]);
        }
        throw new KDException(new ErrorCode("9999", ResManager.loadKDString((String)"\u67e5\u8be2\u62a5\u9500\u5355\u5931\u8d25", (String)"InvoiceHisDataSyncService_10", (String)"imc-rim-common", (Object[])new Object[0])), new Object[0]);
    }

    private static void saveExpenseInfo(JSONObject expenseInfo) {
        if (expenseInfo == null || expenseInfo.isEmpty()) {
            return;
        }
        String expenseId = expenseInfo.getString("expenseId");
        String expenseNum = expenseInfo.getString("expenseNum");
        if (StringUtils.isEmpty((CharSequence)expenseId) || StringUtils.isEmpty((CharSequence)expenseNum)) {
            LOGGER.info("\u540c\u6b65\u516c\u6709\u4e91\u5355\u636e\u4fe1\u606f\u6570\u636e\u4e0d\u5b8c\u6574..");
            return;
        }
        String expenseStatus = ExpenseStatusEnum.UNDER_REVIEW.getCode();
        if (StringUtils.isNotEmpty((CharSequence)expenseInfo.getString(KEY_STATUS))) {
            expenseStatus = expenseInfo.getString(KEY_STATUS);
        }
        QFilter resourceFilet = new QFilter("resource", "=", (Object)"aws");
        QFilter idfilter = new QFilter("expense_id", "=", (Object)expenseId);
        DynamicObject expenseObject = BusinessDataServiceHelper.loadSingle((String)"rim_expense", (String)MetadataUtil.getFields((String)"rim_expense"), (QFilter[])new QFilter[]{resourceFilet, idfilter});
        if (expenseObject == null) {
            expenseObject = BusinessDataServiceHelper.newDynamicObject((String)"rim_expense");
            expenseObject.set("create_time", (Object)new Date());
            expenseObject.set("update_time", (Object)new Date());
            expenseObject.set("expense_num", (Object)expenseNum);
            expenseObject.set("expense_id", (Object)expenseId);
            expenseObject.set(KEY_STATUS, (Object)expenseStatus);
            expenseObject.set("resource", (Object)"aws");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{expenseObject});
        }
    }

    private static void saveCover(JSONObject data, String expenseId) {
        try {
            JSONArray array = data.getJSONArray("cover");
            for (int i = 0; i < array.size(); ++i) {
                JSONObject cover = array.getJSONObject(i);
                cover.put("expenseId", (Object)expenseId);
                String fileId = MD5.md5Hex((String)(expenseId + cover.getString("coverNo")));
                FileHandleService service = FileHandleService.newInstance(FileHandleService.DOWN_TYPE_COV);
                service.insert(fileId, cover);
                String isSyncDownload = RimConfigUtils.getConfig("rim_config", "sync_download_aws_file");
                if (!STATUS_SUCCESS.equals(isSyncDownload)) continue;
                LOGGER.info("\u540c\u6b65\u4e0b\u8f7d\u5f71\u50cf\uff1a{}", (Object)fileId);
                FileHandleService fileHandleService = FileHandleService.newInstance(FileHandleService.DOWN_TYPE_COV);
                InvoiceHisDataSyncService.downloadCurrentFileById(fileHandleService, fileId);
            }
        }
        catch (Exception e) {
            LOGGER.info("\u4fdd\u5b58\u5c01\u9762\u5931\u8d25" + e.getMessage());
        }
    }

    private static void saveAttachment(JSONObject data, String expenseId) {
        try {
            DeleteServiceHelper.delete((String)"rim_attach_relation", (QFilter[])new QFilter[]{new QFilter("expense_id", "=", (Object)expenseId)});
            JSONArray array = data.getJSONArray("attachment");
            for (int i = 0; i < array.size(); ++i) {
                JSONObject attachment = array.getJSONObject(i);
                attachment.put("expenseId", (Object)expenseId);
                String fileId = MD5.md5Hex((String)(expenseId + attachment.getString("serialNo")));
                FileHandleService service = FileHandleService.newInstance(FileHandleService.DOWN_TYPE_ATT);
                service.insert(fileId, attachment);
                String isSyncDownload = RimConfigUtils.getConfig("rim_config", "sync_download_aws_file");
                if (!STATUS_SUCCESS.equals(isSyncDownload)) continue;
                LOGGER.info("\u540c\u6b65\u4e0b\u8f7d\u9644\u4ef6\uff1a{}", (Object)fileId);
                FileHandleService fileHandleService = FileHandleService.newInstance(FileHandleService.DOWN_TYPE_ATT);
                InvoiceHisDataSyncService.downloadCurrentFileById(fileHandleService, fileId);
            }
        }
        catch (Exception e) {
            LOGGER.info("\u4fdd\u5b58\u9644\u4ef6\u5931\u8d25" + e.getMessage());
        }
    }

    public static void downloadCurrentFileById(FileHandleService fileHandleService, String fileId) {
        if (fileHandleService != null) {
            QFilter filter = new QFilter("id", "=", (Object)fileId);
            DynamicObject currentObj = BusinessDataServiceHelper.loadSingle((String)"rim_invoice_file_aws", (QFilter[])new QFilter[]{filter});
            fileHandleService.doBusiness(currentObj);
        }
    }

    private static int syncBySerials(Long orgId, RequestContext context, AwsFpyService service, String token, JSONArray serialList) {
        if (serialList == null || serialList.isEmpty()) {
            return 0;
        }
        String syncUrl = service.getUrl("query_invoice", token);
        JSONObject param = new JSONObject();
        param.put("serialNo", (Object)serialList);
        param.put("syncWcy", (Object)STATUS_SUCCESS);
        param.put("expenseInfo", (Object)STATUS_SUCCESS);
        try {
            LOGGER.info("\u540c\u6b65aws\u53d1\u7968{},{}", (Object)syncUrl, (Object)param.toJSONString());
            JSONObject result = service.postAppJson(syncUrl, param.toJSONString());
            if (ResultContant.isSuccess(result).booleanValue()) {
                JSONArray invoiceData = result.getJSONArray("data");
                InvoiceHisDataSyncService.saveInvoice(orgId, context, invoiceData);
                return invoiceData.size();
            }
            throw new KDException(new ErrorCode("9999", ResManager.loadKDString((String)"\u540c\u6b65\u5931\u8d25", (String)"InvoiceHisDataSyncService_11", (String)"imc-rim-common", (Object[])new Object[0])), new Object[0]);
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, new ErrorCode("9999", ResManager.loadKDString((String)"\u4e0b\u8f7d\u53d1\u7968\u6570\u636e\u5931\u8d25", (String)"InvoiceHisDataSyncService_12", (String)"imc-rim-common", (Object[])new Object[0])), new Object[0]);
        }
    }
}

