/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.collector;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.earlywarn.kit.StringUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.CollectTypeEnum;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.TaxExcelImportConstant;
import kd.imc.rim.common.helper.RecognitionCheckHelper;
import kd.imc.rim.common.invoice.deduction.DeductionDownService;
import kd.imc.rim.common.invoice.download.excel.TaxInvoiceConvertUtil;
import kd.imc.rim.common.invoice.model.ConvertFieldUtil;
import kd.imc.rim.common.invoice.save.InvoiceSaveResult;
import kd.imc.rim.common.invoice.save.InvoiceSaveService;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.InvoiceCheckUtils;
import kd.imc.rim.common.utils.InvoiceConvertUtils;
import kd.imc.rim.common.utils.UUID;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class TaxInvoiceExcelImportTask
implements Runnable {
    private static Log logger = LogFactory.getLog(TaxInvoiceExcelImportTask.class);
    public static final String excelFileIdCacheKey = "excel_file_id";
    private RequestContext rc;
    private String fileUrl;
    private String fileName;
    private String itemKey;
    private JSONObject[] invoiceArray;
    private Map<String, JSONArray> itemMap;
    private Workbook workbook;
    private int index;

    public static String getExcelImportStatus() {
        String userId = RequestContext.get().getUserId();
        JSONArray keys = JSONArray.parseArray((String)CacheHelper.get(excelFileIdCacheKey + userId));
        if (CollectionUtils.isEmpty((Collection)keys)) {
            return "0";
        }
        String resultId = keys.getString(keys.size() - 1);
        String resultStr = CacheHelper.get(resultId);
        if (StringUtils.isBlank((CharSequence)resultStr)) {
            return "0";
        }
        JSONObject resultJson = JSONObject.parseObject((String)resultStr);
        String excelStatus = resultJson.getString("resolve_status");
        if (StringUtils.isBlank((CharSequence)excelStatus)) {
            return "0";
        }
        return excelStatus;
    }

    public TaxInvoiceExcelImportTask(RequestContext rc, JSONObject[] invoiceArray, String fileName, String fileUrl, Workbook workbook, Map<String, JSONArray> itemMap, String itemKey) {
        this.rc = rc;
        this.fileUrl = fileUrl;
        this.fileName = fileName;
        this.invoiceArray = invoiceArray;
        this.workbook = workbook;
        this.itemMap = itemMap;
        this.itemKey = itemKey;
    }

    public TaxInvoiceExcelImportTask(RequestContext rc, JSONObject[] invoiceArray, String fileName, String fileUrl, Workbook workbook, Map<String, JSONArray> itemMap, String itemKey, int index) {
        this.rc = rc;
        this.fileUrl = fileUrl;
        this.fileName = fileName;
        this.invoiceArray = invoiceArray;
        this.workbook = workbook;
        this.itemMap = itemMap;
        this.itemKey = itemKey;
        this.index = index;
    }

    @Override
    public void run() {
        RequestContext.copyAndSet((RequestContext)this.rc);
        this.doTask();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doTask() {
        if (this.index != 0) {
            int dotIndex = this.fileName.lastIndexOf(46);
            String name = this.fileName.substring(0, dotIndex);
            String ext = this.fileName.substring(dotIndex);
            this.fileName = name + "_" + this.index + ext;
        }
        JSONObject excelImportResult = new JSONObject();
        String fileId = UUID.randomUUID();
        excelImportResult.put("file_num", (Object)fileId);
        excelImportResult.put("resolve_status", (Object)"1");
        excelImportResult.put("excel_name", (Object)this.fileName);
        excelImportResult.put("upload_time", (Object)new Date());
        excelImportResult.put("operate_user", (Object)RequestContext.get().getUserId());
        String fileKey = excelFileIdCacheKey + RequestContext.get().getUserId();
        String cache = CacheHelper.get(fileKey);
        JSONArray fileIds = cache == null ? new JSONArray() : JSONArray.parseArray((String)cache);
        if (!fileIds.contains((Object)fileId)) {
            fileIds.add((Object)fileId);
            CacheHelper.put(fileKey, fileIds.toJSONString(), 86400);
        }
        CacheHelper.put(fileId, excelImportResult.toJSONString(), 86400);
        ByteArrayOutputStream os = null;
        ByteArrayInputStream fin = null;
        try {
            int numberOfSheet = this.workbook.getNumberOfSheets();
            Sheet mainSheet = null;
            Object itemSheet = null;
            for (int i = 0; i < numberOfSheet; ++i) {
                String sheetName = this.workbook.getSheetName(i);
                if (this.index != 0) {
                    if (!("\u53d1\u7968\u57fa\u7840\u4fe1\u606f" + this.index).equals(sheetName) && !("\u6d77\u5173\u7f34\u6b3e\u4e66\u57fa\u7840\u4fe1\u606f" + this.index).equals(sheetName)) continue;
                    mainSheet = this.workbook.getSheetAt(i);
                    continue;
                }
                if (!"\u53d1\u7968\u57fa\u7840\u4fe1\u606f".equals(sheetName) && !"\u6d77\u5173\u7f34\u6b3e\u4e66\u57fa\u7840\u4fe1\u606f".equals(sheetName)) continue;
                mainSheet = this.workbook.getSheetAt(i);
            }
            if (mainSheet == null) {
                throw new MsgException("0002", String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u6570\u636e\u683c\u5f0f\u6709\u8bef\uff0c\u8bf7\u4f7f\u7528\u7a0e\u5c40\u4e0b\u8f7d\u7684excel\u5bfc\u5165\uff1a%1$s", (String)"TaxInvoiceExcelImportTask_5", (String)"imc-rim-common", (Object[])new Object[0]), new Object[0]));
            }
            Sheet firstSheet = mainSheet;
            Row paramRow = firstSheet.getRow(0);
            int writeCellNum = paramRow.getPhysicalNumberOfCells();
            paramRow.createCell(writeCellNum).setCellValue(ResManager.loadKDString((String)"\u5bfc\u5165\u7ed3\u679c", (String)"TaxInvoiceExcelImportTask_0", (String)"imc-rim-common", (Object[])new Object[0]));
            for (JSONObject invoice : this.invoiceArray) {
                JSONObject originInfo;
                boolean dateFlag;
                JSONArray items;
                String type;
                String invoiceType;
                String invoiceNo;
                String invoiceCode;
                block52: {
                    block53: {
                        String qdzpLx;
                        invoiceCode = invoice.getString("invoiceCode");
                        invoiceNo = invoice.getString("invoiceNo");
                        String eleInvoiceNo = invoice.getString("eleInvoiceNo");
                        invoiceCode = Optional.ofNullable(invoiceCode).orElse("");
                        invoiceNo = Optional.ofNullable(invoiceNo).orElse("");
                        eleInvoiceNo = Optional.ofNullable(eleInvoiceNo).orElse("");
                        invoiceCode = invoiceCode.replace("-", "");
                        invoiceNo = invoiceNo.replace("-", "");
                        eleInvoiceNo = eleInvoiceNo.replace("-", "");
                        invoiceType = TaxExcelImportConstant.getInvoiceType(invoice.getString("invoiceType"), invoiceCode, invoiceNo);
                        invoice.put("importType", (Object)"totalExcel");
                        if (InputInvoiceTypeEnum.isEleByAwsType(invoiceType).booleanValue()) {
                            invoice.put("invoiceCode", (Object)"");
                            invoiceNo = eleInvoiceNo;
                            invoice.put("invoiceNo", (Object)eleInvoiceNo);
                        }
                        if (StringUtils.isNotEmpty((CharSequence)(qdzpLx = TaxExcelImportConstant.isQdzp(invoice.getString("invoiceType"))))) {
                            invoice.put("etaxInvoiceNo", (Object)eleInvoiceNo);
                        }
                        if ("import_hgjk_full".equals(this.itemKey)) {
                            invoiceType = InputInvoiceTypeEnum.HGJKS.getAwsType();
                        }
                        invoice.put("invoiceType", (Object)invoiceType);
                        String invoiceStatus = TaxExcelImportConstant.getInvoiceStatus(invoice.getString("invoiceStatus"));
                        invoice.put("invoiceStatus", (Object)invoiceStatus);
                        BigDecimal totalAmount = BigDecimal.ZERO;
                        if ("84".equals(invoiceType) || InputInvoiceTypeEnum.HGJKS.getAwsType().equals(invoiceType)) {
                            totalAmount = BigDecimalUtil.transDecimal(invoice.get((Object)"totalAmount"));
                        } else {
                            BigDecimal invoiceAmount = BigDecimalUtil.transDecimal(invoice.get((Object)"invoiceAmount"));
                            BigDecimal totalTaxAmount = BigDecimalUtil.transDecimal(invoice.get((Object)"totalTaxAmount"));
                            totalAmount = invoiceAmount.add(totalTaxAmount);
                        }
                        invoice.put("totalAmount", (Object)totalAmount);
                        String invoiceDate = invoice.getString("invoiceDate");
                        if (StringUtils.isNotEmpty((CharSequence)invoiceDate) && invoiceDate.length() > 10) {
                            invoice.put("invoiceDate", (Object)invoiceDate.substring(0, 10));
                        }
                        type = "0";
                        if (totalAmount != null && totalAmount.compareTo(BigDecimal.ZERO) < 0) {
                            type = "1";
                        }
                        invoice.put("type", (Object)type);
                        String uniqueKey = TaxInvoiceExcelImportTask.getUniqueKey(invoice);
                        items = this.itemMap.get(uniqueKey);
                        DecimalFormat decimalFormat = new DecimalFormat("#0.###");
                        JSONArray airItems = new JSONArray(1);
                        dateFlag = false;
                        if (CollectionUtils.isEmpty((Collection)items)) break block52;
                        for (int i = 0; i < items.size(); ++i) {
                            JSONObject item = items.getJSONObject(i);
                            if (item == null) continue;
                            if ("15".equals(invoiceType)) {
                                item.put("vehPlate", item.get((Object)"specModel"));
                                item.put("specModel", item.get((Object)"unit"));
                                item.put("startDate", item.get((Object)"num"));
                                item.put("endDate", item.get((Object)"unitPrice"));
                                item.remove((Object)"unit");
                                item.remove((Object)"num");
                                item.remove((Object)"unitPrice");
                            }
                            BigDecimal taxRateBd = BigDecimal.ZERO;
                            String taxRate = item.getString("taxRate");
                            if (StringUtils.isNotEmpty((CharSequence)taxRate)) {
                                if ((taxRate = taxRate.trim()).contains("%")) {
                                    taxRate = taxRate.replace("%", "");
                                    taxRateBd = new BigDecimal(taxRate).divide(new BigDecimal("100"));
                                } else if (taxRate.contains("\u514d\u7a0e")) {
                                    item.put("zeroTaxRateFlag", (Object)1);
                                } else if (taxRate.contains("\u4e0d\u5f81\u7a0e")) {
                                    item.put("zeroTaxRateFlag", (Object)2);
                                }
                            }
                            item.put("taxRate", (Object)decimalFormat.format(taxRateBd));
                            this.dealAirTrainItems(invoice, invoiceType, airItems, item);
                            this.dealmotoUsedCarItems(invoice, invoiceType, item);
                        }
                        ConvertFieldUtil.setDisCountType(items, type);
                        if (!"28".equals(invoiceType) && !"29".equals(invoiceType)) break block53;
                        if (!CollectionUtils.isEmpty((Collection)airItems)) {
                            invoice.put("items", (Object)airItems);
                        }
                        if ("28".equals(invoiceType)) {
                            Date invoiceDates = invoice.getDate("invoiceDate");
                            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                            try {
                                Date date = sdf.parse("2025-07-28 00:00:00");
                                if (invoiceDates.compareTo(date) >= 0) {
                                    dateFlag = true;
                                }
                            }
                            catch (ParseException date) {
                                // empty catch block
                            }
                            if (dateFlag) {
                                BigDecimal trueTotalAmount = BigDecimal.ZERO;
                                for (int i = 0; i < items.size(); ++i) {
                                    JSONObject item = items.getJSONObject(i);
                                    BigDecimal partAmount = item.getBigDecimal("totalAmount");
                                    if (partAmount == null) continue;
                                    trueTotalAmount = trueTotalAmount.add(partAmount);
                                }
                                invoice.put("totalTaxInclAmount", (Object)totalAmount);
                                invoice.put("totalAmount", (Object)trueTotalAmount);
                                break block52;
                            } else {
                                invoice.put("totalTaxInclAmount", (Object)0);
                            }
                        }
                        break block52;
                    }
                    invoice.put("items", (Object)items);
                }
                String remark = invoice.getString("remark");
                if (StringUtils.contains((CharSequence)invoice.getString("salerName"), (CharSequence)"\u7a0e\u52a1\u5c40") && StringUtils.contains((CharSequence)remark, (CharSequence)"\u4ee3\u5f00")) {
                    invoice.put("proxyMark", (Object)"1");
                }
                ConvertFieldUtil.setProxySalerInfoByRemark(invoice);
                if ("1".equals(type) && null != (originInfo = TaxInvoiceConvertUtil.getOriginDmHm(remark))) {
                    invoice.put("originalInvoiceCode", (Object)originInfo.getString("originalInvoiceCode"));
                    invoice.put("originalInvoiceNo", (Object)originInfo.getString("originalInvoiceNo"));
                }
                Row resultRow = firstSheet.getRow(invoice.getInteger("row").intValue());
                ApiResult apiResult = null;
                if ("import_hgjk_full".equals(this.itemKey)) {
                    if (org.apache.commons.lang.StringUtils.isEmpty((String)invoice.getString("customDeclarationNo"))) {
                        invoice.put("customDeclarationNo", (Object)invoice.getString("invoiceNo"));
                    }
                    if (org.apache.commons.lang.StringUtils.isEmpty((String)invoice.getString("invoiceNo"))) {
                        invoice.put("invoiceNo", (Object)invoice.getString("customDeclarationNo"));
                    }
                    apiResult = InvoiceCheckUtils.checkHaveNull(InvoiceCheckUtils.HGJKS_INVOICE_MUST, invoice, InputInvoiceTypeEnum.HGJKS.getName());
                } else {
                    apiResult = InvoiceCheckUtils.checkMust(invoice, false, false);
                }
                if (apiResult != null) {
                    resultRow.createCell(writeCellNum).setCellValue(apiResult.getMessage());
                    continue;
                }
                DynamicObject mainObj = TaxInvoiceExcelImportTask.getMainObj(invoice.getString("invoiceCode"), invoice.getString("invoiceNo"));
                if (mainObj != null && "1".equals(mainObj.getString("check_status"))) {
                    if (dateFlag && "28".equals(invoiceType)) {
                        QFilter qFilter = new QFilter("invoice_code", "=", (Object)invoiceCode).and("invoice_no", "=", (Object)invoiceNo).and("delete", "=", (Object)"1");
                        DynamicObject main = BusinessDataServiceHelper.loadSingle((String)"rim_invoice", (QFilter[])qFilter.toArray());
                        main.set("invoice_amount", (Object)invoice.getBigDecimal("invoiceAmount"));
                        BigDecimal originTotalAmount = main.getBigDecimal("total_amount");
                        if (BigDecimal.ZERO.compareTo(originTotalAmount) == 0) {
                            main.set("total_amount", (Object)invoice.getBigDecimal("totalAmount"));
                        }
                        main.set("modifytime", (Object)new Date());
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{main});
                        QFilter eleFilter = new QFilter("invoice_no", "=", (Object)invoiceNo).and("delete", "=", (Object)"1");
                        DynamicObject eleInvoice = BusinessDataServiceHelper.loadSingle((String)"rim_inv_air_ele", (QFilter[])eleFilter.toArray());
                        eleInvoice.set("invoice_amount", (Object)invoice.getBigDecimal("invoiceAmount"));
                        eleInvoice.set("total_tax_incl_amount", (Object)invoice.getBigDecimal("totalTaxInclAmount"));
                        originTotalAmount = eleInvoice.getBigDecimal("total_amount");
                        if (BigDecimal.ZERO.compareTo(originTotalAmount) == 0) {
                            eleInvoice.set("total_amount", (Object)invoice.getBigDecimal("totalAmount"));
                        }
                        eleInvoice.set("modifytime", (Object)new Date());
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{eleInvoice});
                    }
                    resultRow.createCell(writeCellNum).setCellValue(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u5df2\u9a8c\u53d1\u7968", (String)"TaxInvoiceExcelImportTask_1", (String)"imc-rim-common", (Object[])new Object[0]));
                    continue;
                }
                invoice.put("checkStatus", (Object)"4");
                invoice.put("resource", (Object)CollectTypeEnum.TAX_EXCEL_IMPORT.getName());
                invoice.put("collect_type", (Object)CollectTypeEnum.TAX_EXCEL_IMPORT.getCode());
                Long invoiceTypeLong = InputInvoiceTypeEnum.getInvoiceTypeByAwsType(invoiceType);
                invoice.put("invoiceType", (Object)invoiceTypeLong);
                if (InputInvoiceTypeEnum.needItems(invoiceTypeLong).booleanValue() && CollectionUtils.isEmpty((Collection)items)) {
                    resultRow.createCell(writeCellNum).setCellValue(ResManager.loadKDString((String)"\u7f3a\u5c11\u53d1\u7968\u660e\u7ec6", (String)"TaxInvoiceExcelImportTask_2", (String)"imc-rim-common", (Object[])new Object[0]));
                    continue;
                }
                try {
                    InvoiceSaveService saveService = InvoiceSaveService.newInstance(invoiceTypeLong + "");
                    if (saveService != null) {
                        String serialNo;
                        if (InvoiceConvertUtils.isSaleListInvoiceType(invoiceTypeLong)) {
                            RecognitionCheckHelper.markSaleListByCheckResult(invoice);
                        }
                        if (StringUtils.isEmpty((CharSequence)(serialNo = DeductionDownService.handleTaxFullInvoice(saveService, invoice)))) {
                            invoice.put("needUserRelation", (Object)"0");
                            InvoiceSaveResult save = saveService.save(invoice);
                            serialNo = save.getSerialNo();
                        }
                        invoice.put("serialNo", (Object)serialNo);
                        String isSaleListInvoice = invoice.getString("isSaleListInvoice");
                        if ("1".equals(isSaleListInvoice)) {
                            RecognitionCheckHelper recognitionCheckHelper = new RecognitionCheckHelper();
                            recognitionCheckHelper.dealInvoiceAttachRelation(invoice);
                        }
                    }
                    resultRow.createCell(writeCellNum).setCellValue(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f", (String)"TaxInvoiceExcelImportTask_3", (String)"imc-rim-common", (Object[])new Object[0]));
                }
                catch (Exception e) {
                    resultRow.createCell(writeCellNum).setCellValue(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25%1$s", (String)"TaxInvoiceExcelImportTask_4", (String)"imc-rim-common", (Object[])new Object[0]), e.getMessage()));
                    logger.error("\u4fdd\u5b58\u5931\u8d25" + invoiceCode + invoiceNo, (Throwable)e);
                }
            }
            byte[] bytes = null;
            os = new ByteArrayOutputStream();
            this.workbook.write((OutputStream)os);
            bytes = os.toByteArray();
            String exportFileName = String.format(ResManager.loadKDString((String)"%1$s_\u5bfc\u5165\u7ed3\u679c_%2$s", (String)"InvoiceExcelImportTask_60", (String)"imc-rim-common", (Object[])new Object[0]), DateUtils.format(new Date(), "yyyyMMddHHmmss"), this.fileName);
            fin = new ByteArrayInputStream(bytes);
            String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(exportFileName, (InputStream)fin, 86400);
            excelImportResult.put("resolve_status", (Object)"2");
            excelImportResult.put("url", (Object)url);
            excelImportResult.put("export_file_name", (Object)url);
            CacheHelper.put(fileId, excelImportResult.toJSONString(), 86400);
        }
        catch (IOException e) {
            try {
                logger.error("\u89e3\u6790excel\u5f02\u5e38\uff1a", (Throwable)e);
                excelImportResult.put("resolve_status", (Object)"3");
                CacheHelper.put(fileId, excelImportResult.toJSONString(), 86400);
                throw new MsgException(e, String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u6570\u636e\u683c\u5f0f\u6709\u8bef\uff0c\u8bf7\u4f7f\u7528\u7a0e\u5c40\u4e0b\u8f7d\u7684excel\u5bfc\u5165\uff1a%1$s", (String)"TaxInvoiceExcelImportTask_5", (String)"imc-rim-common", (Object[])new Object[0]), e.getMessage()));
                catch (Exception e2) {
                    logger.error("\u89e3\u6790excel\u5f02\u5e38\uff1a", (Throwable)e2);
                    excelImportResult.put("resolve_status", (Object)"3");
                    CacheHelper.put(fileId, excelImportResult.toJSONString(), 86400);
                    throw new MsgException(e2, String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u6570\u636e\u683c\u5f0f\u6709\u8bef\uff0c\u8bf7\u4f7f\u7528\u7a0e\u5c40\u4e0b\u8f7d\u7684excel\u5bfc\u5165\uff1a%1$s", (String)"TaxInvoiceExcelImportTask_5", (String)"imc-rim-common", (Object[])new Object[0]), e2.getMessage()));
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fin);
                IOUtils.closeQuietly(os);
                IOUtils.closeQuietly((Closeable)this.workbook);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)fin);
        IOUtils.closeQuietly((Closeable)os);
        IOUtils.closeQuietly((Closeable)this.workbook);
    }

    private void dealmotoUsedCarItems(JSONObject invoice, String invoiceType, JSONObject item) {
        if ("83".equals(invoiceType) || "84".equals(invoiceType)) {
            if ("83".equals(invoiceType)) {
                if (item.containsKey((Object)"commodityInspectionNo")) {
                    invoice.put("commodityInspectionNo", (Object)item.getString("commodityInspectionNo"));
                }
                if (item.containsKey((Object)"producingArea")) {
                    invoice.put("producingArea", (Object)item.getString("producingArea"));
                }
                if (item.containsKey((Object)"engineNum")) {
                    invoice.put("engineNum", (Object)item.getString("engineNum"));
                }
                if (item.containsKey((Object)"vehicleIdentificationNo")) {
                    invoice.put("vehicleIdentificationNo", (Object)item.getString("vehicleIdentificationNo"));
                }
                if (item.containsKey((Object)"certificateNum")) {
                    invoice.put("certificateNum", (Object)item.getString("certificateNum"));
                }
            }
            if ("84".equals(invoiceType)) {
                if (item.containsKey((Object)"salerPhoneNumber")) {
                    invoice.put("salerPhoneNumber", (Object)item.getString("salerPhoneNumber"));
                }
                if (item.containsKey((Object)"salerAddress")) {
                    invoice.put("salerAddress", (Object)item.getString("salerAddress"));
                }
                if (item.containsKey((Object)"buyerAddress")) {
                    invoice.put("buyerAddress", (Object)item.getString("buyerAddress"));
                }
                if (item.containsKey((Object)"buyerPhoneNumber")) {
                    invoice.put("buyerPhoneNumber", (Object)item.getString("buyerPhoneNumber"));
                }
                if (item.containsKey((Object)"remark") && StringUtils.isEmpty((CharSequence)invoice.getString("remark"))) {
                    invoice.put("remark", (Object)item.getString("remark"));
                }
                if (item.containsKey((Object)"vehicleIdentificationNo")) {
                    invoice.put("vehicleIdentificationNo", (Object)item.getString("vehicleIdentificationNo"));
                }
                if (item.containsKey((Object)"licensePlateNumber")) {
                    invoice.put("licensePlateNumber", (Object)item.getString("licensePlateNumber"));
                }
                if (item.containsKey((Object)"registrationNumber")) {
                    invoice.put("registrationNumber", (Object)item.getString("registrationNumber"));
                }
                if (item.containsKey((Object)"vehicleManagementName")) {
                    invoice.put("vehicleManagementName", (Object)item.getString("vehicleManagementName"));
                }
                if (item.containsKey((Object)"auctionName")) {
                    invoice.put("auctionName", (Object)item.getString("auctionName"));
                }
                if (item.containsKey((Object)"auctionTaxpayerId")) {
                    invoice.put("auctionTaxpayerId", (Object)item.getString("auctionTaxpayerId"));
                }
                if (item.containsKey((Object)"marketName")) {
                    invoice.put("marketName", (Object)item.getString("marketName"));
                }
                if (item.containsKey((Object)"marketTaxpayerId")) {
                    invoice.put("marketTaxpayerId", (Object)item.getString("marketTaxpayerId"));
                }
                if (item.containsKey((Object)"specialTypeMark")) {
                    String specialTypeMark = item.getString("specialTypeMark");
                    if (ResManager.loadKDString((String)"\u6b63\u5e38\u5f00\u5177", (String)"SpecialTypeMarkEnum_26", (String)"imc-rim-common", (Object[])new Object[0]).equals(specialTypeMark)) {
                        invoice.put("specialTypeMark", (Object)"27");
                    } else if (ResManager.loadKDString((String)"\u53cd\u5411\u5f00\u5177", (String)"SpecialTypeMarkEnum_27", (String)"imc-rim-common", (Object[])new Object[0]).equals(specialTypeMark)) {
                        invoice.put("specialTypeMark", (Object)"28");
                    } else {
                        invoice.put("specialTypeMark", (Object)"");
                    }
                }
            }
        }
    }

    private void dealAirTrainItems(JSONObject invoice, String invoiceType, JSONArray airItems, JSONObject item) {
        if ("28".equals(invoiceType) || "29".equals(invoiceType)) {
            String destination;
            String placeOfDeparture;
            String idNumber;
            String passengerName;
            String goodsName;
            if ("28".equals(invoiceType)) {
                if (item.containsKey((Object)"goodsName")) {
                    goodsName = item.getString("goodsName");
                    String goodsCode = item.getString("goodsCode");
                    String detailAmount = item.getString("detailAmount");
                    String taxAmount = item.getString("taxAmount");
                    String taxRate = item.getString("taxRate");
                    if (kd.imc.rim.common.utils.StringUtils.isNotBlank((CharSequence)goodsName)) {
                        if (goodsName.contains("\u7968\u4ef7")) {
                            invoice.put("taxRate", (Object)taxRate);
                            invoice.put("ticketPrice", (Object)detailAmount);
                        }
                        if (goodsName.contains("\u71c3\u6cb9\u9644\u52a0\u8d39")) {
                            invoice.put("fuelSurcharge", (Object)detailAmount);
                        }
                        if (goodsName.contains("\u6c11\u822a\u53d1\u5c55\u57fa\u91d1")) {
                            invoice.put("airportConstructionFee", (Object)detailAmount);
                        }
                    }
                }
                if (item.containsKey((Object)"passengerName")) {
                    passengerName = item.getString("passengerName");
                    idNumber = item.getString("idNumber");
                    placeOfDeparture = item.getString("placeOfDeparture");
                    destination = item.getString("destination");
                    String carrier = item.getString("carrier");
                    String flightNum = item.getString("flightNum");
                    String carrierDate = item.getString("carrierDate");
                    String airTime = item.getString("airTime");
                    JSONObject saveItem = new JSONObject();
                    if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)carrierDate)) {
                        try {
                            Date carrierDateSave = DateUtils.stringToDate(carrierDate, "yyyy-MM-dd");
                            saveItem.put("carrierDate", (Object)carrierDateSave);
                            invoice.put("carrierDate", (Object)carrierDateSave);
                        }
                        catch (Exception e) {
                            logger.info("\u6570\u7535\u98de\u673a\u7968\uff0c\u4e58\u673a\u65e5\u671f\u8f6c\u6362\u5f02\u5e38\uff0c\u53d1\u7968\u53f7\u7801:{}, time {}", (Object)invoice.getString("invoiceNo"), (Object)airTime);
                        }
                    }
                    if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)airTime) && airTime.length() > 16) {
                        saveItem.put("airTime", (Object)airTime.substring(11, 16));
                        invoice.put("airTime", (Object)airTime.substring(11, 16));
                    }
                    if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)idNumber)) {
                        invoice.put("customerIdentityNum", (Object)idNumber);
                        InvoiceCheckUtils.encodeIDNumber(invoice, "customerIdentityNum", 8);
                    }
                    invoice.put("customerName", (Object)passengerName);
                    saveItem.put("placeOfDeparture", (Object)placeOfDeparture);
                    invoice.put("placeOfDeparture", (Object)placeOfDeparture);
                    saveItem.put("destination", (Object)destination);
                    invoice.put("destination", (Object)destination);
                    saveItem.put("carrier", (Object)carrier);
                    invoice.put("carrier", (Object)carrier);
                    saveItem.put("flightNum", (Object)flightNum);
                    invoice.put("flightNum", (Object)flightNum);
                    airItems.add((Object)saveItem);
                }
            }
            if ("29".equals(invoiceType)) {
                if (item.containsKey((Object)"goodsName")) {
                    goodsName = item.getString("goodsName");
                    String detailAmount = item.getString("detailAmount");
                    if (kd.imc.rim.common.utils.StringUtils.isNotBlank((CharSequence)goodsName)) {
                        String taxRate = item.getString("taxRate");
                        if (goodsName.contains("\u7968\u4ef7")) {
                            invoice.put("taxRate", (Object)taxRate);
                        }
                    }
                }
                if (item.containsKey((Object)"passengerName")) {
                    passengerName = item.getString("passengerName");
                    idNumber = item.getString("idNumber");
                    placeOfDeparture = item.getString("placeOfDeparture");
                    destination = item.getString("destination");
                    String carrierDate = item.getString("carrierDate");
                    String airTime = item.getString("airTime");
                    String trainNum = item.getString("trainNum");
                    invoice.put("passengerName", (Object)passengerName);
                    if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)idNumber)) {
                        invoice.put("customerIdentityNum", (Object)idNumber);
                        InvoiceCheckUtils.encodeIDNumber(invoice, "customerIdentityNum", 8);
                    }
                    invoice.put("departureStation", (Object)placeOfDeparture);
                    invoice.put("destinationStation", (Object)destination);
                    invoice.put("trainNum", (Object)trainNum);
                    invoice.put("trainTime", (Object)carrierDate);
                    invoice.put("departureTime", (Object)airTime);
                }
            }
        }
    }

    public static String getUniqueKey(JSONObject invoiceJson) {
        String invoiceCode = invoiceJson.getString("invoiceCode");
        String invoiceNo = invoiceJson.getString("invoiceNo");
        String eleInvoiceNo = invoiceJson.getString("eleInvoiceNo");
        invoiceCode = Optional.ofNullable(invoiceCode).orElse("");
        invoiceNo = Optional.ofNullable(invoiceNo).orElse("");
        eleInvoiceNo = Optional.ofNullable(eleInvoiceNo).orElse("");
        invoiceCode = invoiceCode.replace("-", "");
        invoiceNo = invoiceNo.replace("-", "");
        if (StringUtil.isNotEmpty((CharSequence)(eleInvoiceNo = eleInvoiceNo.replace("-", "")))) {
            return eleInvoiceNo;
        }
        return invoiceCode + invoiceNo;
    }

    private static DynamicObject getMainObj(String invoiceCode, String invoiceNo) {
        QFilter qFilter = new QFilter("invoice_code", "=", (Object)invoiceCode).and("invoice_no", "=", (Object)invoiceNo).and("delete", "=", (Object)"1");
        return QueryServiceHelper.queryOne((String)"rim_invoice", (String)"check_status", (QFilter[])qFilter.toArray());
    }

    public static Log getLogger() {
        return logger;
    }

    public static void setLogger(Log logger) {
        TaxInvoiceExcelImportTask.logger = logger;
    }

    public RequestContext getRc() {
        return this.rc;
    }

    public void setRc(RequestContext rc) {
        this.rc = rc;
    }

    public String getFileUrl() {
        return this.fileUrl;
    }

    public void setFileUrl(String fileUrl) {
        this.fileUrl = fileUrl;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }
}

