/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.deduction;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.CollectTypeEnum;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.InvoiceSaveConstant;
import kd.imc.rim.common.invoice.save.InvoiceSaveService;
import kd.imc.rim.common.invoice.save.impl.AirEleSaveService;
import kd.imc.rim.common.service.InvoiceLog;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DeductionUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.InvoiceConvertUtils;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.common.utils.TenantUtils;
import org.apache.commons.lang3.tuple.Pair;

public class DeductionDownService {
    private static final Log LOGGER = LogFactory.getLog(DeductionDownService.class);

    public static Pair<Boolean, String> isUpdateDownInvoice(InvoiceSaveService saveService, Long invoiceType, JSONObject invoice) {
        String headerDownFlag = invoice.getString("headerDownFlag");
        String invoiceCode = invoice.getString("invoiceCode");
        String invoiceNo = CommonUtils.getJsonValue((Map<String, Object>)invoice, String.class, true, "invoiceNo", "customDeclarationNo", "jkshm");
        String etaxInvoiceNo = invoice.getString("etaxInvoiceNo");
        QFilter invoiceTypeFilter = new QFilter("invoice_type", "=", (Object)invoiceType);
        String tenantNo = TenantUtils.getTenantNo();
        QFilter tenantFilter = new QFilter("tenant_no", "=", (Object)tenantNo);
        QFilter invoiceNoFilter = new QFilter("invoice_no", "=", (Object)invoiceNo);
        QFilter invoiceCodeFilter = new QFilter("invoice_code", "=", (Object)StringUtils.trimToEmpty((String)invoiceCode));
        if (StringUtils.isNotEmpty((CharSequence)etaxInvoiceNo) && StringUtils.isEmpty((CharSequence)invoiceCode)) {
            invoiceCodeFilter = null;
            invoiceNoFilter = new QFilter("electronic_no", "=", (Object)etaxInvoiceNo);
        }
        QFilter invoiceDateFilter = null;
        Date invoiceDate = invoice.getDate("invoiceDate");
        if (InputInvoiceTypeEnum.WITHHOLDING.getCode().equals(invoiceType)) {
            if (invoiceDate == null) {
                return Pair.of((Object)Boolean.FALSE, (Object)"");
            }
            invoiceDate = DateUtils.trunc(invoiceDate);
            invoiceDateFilter = new QFilter("invoice_date", ">=", (Object)invoiceDate);
            invoiceDateFilter.and(new QFilter("invoice_date", "<", (Object)DateUtils.addDay(invoiceDate, 1)));
        }
        String entity = InputInvoiceTypeEnum.getEntity(invoiceType);
        DynamicObject serialObject = QueryServiceHelper.queryOne((String)"rim_invoice", (String)"id,serial_no,check_status,collect_type", (QFilter[])new QFilter[]{invoiceCodeFilter, invoiceNoFilter, invoiceTypeFilter, tenantFilter, invoiceDateFilter});
        DeductionUtils.deleteCheckCache(invoice, invoiceType);
        boolean updateFlag = false;
        String serialNo = "";
        JSONObject logInfo = new JSONObject();
        if (serialObject != null) {
            boolean bl = updateFlag = "1".equals(serialObject.getString("check_status")) || (InputInvoiceTypeEnum.HGJKS.getCode().equals(invoiceType) || InputInvoiceTypeEnum.WITHHOLDING.getCode().equals(invoiceType)) && CollectTypeEnum.PC_SHUIPAN.getCode().equals(serialObject.getString("collect_type"));
            if (updateFlag) {
                serialNo = serialObject.getString("serial_no");
                invoice.put("serialNo", (Object)serialNo);
                LOGGER.info("\u53d1\u7968:{}-{}-{} \u76f4\u63a5\u66f4\u65b0\u4e3b\u8868", new Object[]{invoiceCode, invoiceNo, etaxInvoiceNo});
                DynamicObject mainDynamicObject = BusinessDataServiceHelper.loadSingle((Object)serialObject.get("id"), (String)"rim_invoice");
                long orgId = DynamicObjectUtil.getDynamicObjectLongValue(mainDynamicObject.get("org"));
                DynamicObject invoiceBody = null;
                QFilter serialFilter = new QFilter("serial_no", "=", (Object)serialNo);
                DynamicObject idObject = QueryServiceHelper.queryOne((String)entity, (String)"id,serial_no", (QFilter[])new QFilter[]{tenantFilter, serialFilter});
                if (idObject != null) {
                    invoiceBody = BusinessDataServiceHelper.loadSingle((Object)idObject.get("id"), (String)entity);
                    DeductionUtils.addInvoiceItems(invoiceType, invoiceBody, invoice);
                    DeductionUtils.addTrainEleBusinessType(invoiceType, invoiceBody, invoice);
                }
                DeductionDownService.setMainInvoiceValue(mainDynamicObject, saveService, invoice, invoiceType, logInfo, orgId, invoiceBody);
                try (TXHandle h = TX.required();){
                    try {
                        Date invoiceDateParam = null;
                        try {
                            invoiceDateParam = DateUtils.stringToDate(invoice.getString("invoiceDate"), "yyyy-MM-dd HH:mm:ss");
                        }
                        catch (Exception e) {
                            LOGGER.info(String.format(ResManager.loadKDString((String)"\u65e5\u671f[%1$s]\u683c\u5f0f\u9519\u8bef,\u6b63\u786e\u683c\u5f0f\u4e3a:%2$s", (String)"DateUtils_0", (String)"imc-rim-common", (Object[])new Object[0]), invoice.getString("invoiceDate"), "yyyy-MM-dd HH:mm:ss"));
                        }
                        String collectType = invoice.getString("collect_type");
                        if (("1".equals(headerDownFlag) || CollectTypeEnum.TAX_EXCEL_IMPORT.getCode().equals(collectType)) && (InputInvoiceTypeEnum.AIR_ELE_INVOICE.getCode().equals(invoiceType) || InputInvoiceTypeEnum.TRAIN_ELE_INVOICE.getCode().equals(invoiceType))) {
                            DeductionDownService.setAirTrainInfo(saveService, invoice, mainDynamicObject, invoiceDateParam);
                        }
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{mainDynamicObject});
                        if (invoiceBody != null) {
                            DeductionDownService.setInvoiceBodyValue(invoiceBody, mainDynamicObject, saveService, invoice, invoiceType, orgId);
                            if (("1".equals(headerDownFlag) || CollectTypeEnum.TAX_EXCEL_IMPORT.getCode().equals(collectType)) && (InputInvoiceTypeEnum.AIR_ELE_INVOICE.getCode().equals(invoiceType) || InputInvoiceTypeEnum.TRAIN_ELE_INVOICE.getCode().equals(invoiceType))) {
                                if (InputInvoiceTypeEnum.AIR_ELE_INVOICE.getCode().equals(invoiceType)) {
                                    DeductionDownService.setEleAirInfoBody(saveService, invoice, invoiceBody, invoiceDateParam);
                                }
                                if (InputInvoiceTypeEnum.TRAIN_ELE_INVOICE.getCode().equals(invoiceType)) {
                                    DeductionDownService.setTrainInfoBody(saveService, invoice, invoiceBody, invoiceDateParam);
                                }
                            }
                            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{invoiceBody});
                        }
                        DeductionDownService.saveLog(invoice, logInfo);
                    }
                    catch (Throwable e) {
                        LOGGER.error("\u7a0e\u76d8\u4e0b\u8f7d\u66f4\u65b0\u53d1\u7968\u62a5\u9519", e);
                        h.markRollback();
                        throw e;
                    }
                }
            }
        }
        return Pair.of((Object)updateFlag, (Object)serialNo);
    }

    private static void setTrainInfoBody(InvoiceSaveService saveService, JSONObject invoice, DynamicObject invoiceBody, Date invoiceDateParam) {
        try {
            if (invoiceDateParam != null) {
                saveService.setInvoiceDate(invoiceDateParam, invoiceBody, "invoice_date");
            }
            if (StringUtils.isNotBlank((CharSequence)invoice.getString("salerName"))) {
                invoiceBody.set("seller_name", (Object)invoice.getString("salerName"));
            }
            if (StringUtils.isNotBlank((CharSequence)invoice.getString("salerTaxNo"))) {
                invoiceBody.set("seller_unif_soc_cre_code", (Object)invoice.getString("salerTaxNo"));
            }
            if (StringUtils.isNotBlank((CharSequence)invoice.getString("invoiceAmount"))) {
                invoiceBody.set("detail_amount", (Object)invoice.getString("invoiceAmount"));
            }
            if (StringUtils.isNotBlank((CharSequence)invoice.getString("effectiveTaxAmount"))) {
                invoiceBody.set("effective_tax_amount", (Object)invoice.getString("effectiveTaxAmount"));
            }
        }
        catch (Exception e) {
            LOGGER.error("\u6570\u7535\u94c1\u8def\u7968\u8868\u5934\u4e0b\u8f7d\u5b57\u6bb5\u8986\u76d6\u5f02\u5e38", (Throwable)e);
        }
    }

    private static void setEleAirInfoBody(InvoiceSaveService saveService, JSONObject invoice, DynamicObject invoiceBody, Date invoiceDateParam) {
        try {
            if (invoiceDateParam != null) {
                saveService.setInvoiceDate(invoiceDateParam, invoiceBody, "invoice_date");
                saveService.setInvoiceDate(invoiceDateParam, invoiceBody, "issue_date");
            }
            if (StringUtils.isNotBlank((CharSequence)invoice.getString("salerName"))) {
                invoiceBody.set("seller_name", (Object)invoice.getString("salerName"));
            }
            if (StringUtils.isNotBlank((CharSequence)invoice.getString("invoiceAmount"))) {
                invoiceBody.set("invoice_amount", (Object)invoice.getString("invoiceAmount"));
            }
            if (StringUtils.isNotBlank((CharSequence)invoice.getString("effectiveTaxAmount"))) {
                invoiceBody.set("effective_tax_amount", (Object)invoice.getString("effectiveTaxAmount"));
            }
        }
        catch (Exception e) {
            LOGGER.error("\u6570\u7535\u98de\u673a\u7968\u8868\u5934\u4e0b\u8f7d\u5b57\u6bb5\u8986\u76d6\u5f02\u5e38", (Throwable)e);
        }
    }

    private static void setAirTrainInfo(InvoiceSaveService saveService, JSONObject invoice, DynamicObject mainDynamicObject, Date invoiceDateParam) {
        AirEleSaveService airEleSaveService = new AirEleSaveService();
        try {
            if (invoiceDateParam != null) {
                saveService.setInvoiceDate(invoiceDateParam, mainDynamicObject, "invoice_date");
            }
            if (StringUtils.isNotBlank((CharSequence)invoice.getString("salerName"))) {
                mainDynamicObject.set("saler_name", (Object)invoice.getString("salerName"));
            }
            if (StringUtils.isNotBlank((CharSequence)invoice.getString("salerTaxNo"))) {
                mainDynamicObject.set("saler_tax_no", (Object)invoice.getString("salerTaxNo"));
            }
            if (StringUtils.isNotBlank((CharSequence)invoice.getString("invoiceAmount"))) {
                mainDynamicObject.set("invoice_amount", (Object)invoice.getString("invoiceAmount"));
            }
            if (StringUtils.isNotBlank((CharSequence)invoice.getString("effectiveTaxAmount"))) {
                mainDynamicObject.set("effective_tax_amount", (Object)invoice.getString("effectiveTaxAmount"));
            }
            if (StringUtils.isNotBlank((CharSequence)invoice.getString("invoiceRiskLevel"))) {
                mainDynamicObject.set("invoice_risk_level", (Object)invoice.getString("invoiceRiskLevel"));
            }
        }
        catch (Exception e) {
            LOGGER.error("\u6570\u7535\u98de\u673a/\u706b\u8f66--\u8868\u5934\u4e0b\u8f7d\u5b57\u6bb5\u8986\u76d6\u5f02\u5e38\uff0c\u53d1\u7968\u53f7\u7801: " + invoice.getString("invoiceNo"), (Throwable)e);
        }
    }

    private static void setMainInvoiceValue(DynamicObject mainDynamicObject, InvoiceSaveService saveService, JSONObject invoice, Long invoiceType, JSONObject logInfo, long orgId, DynamicObject invoiceBody) {
        BigDecimal totalTaxAmount;
        String specialTypeMark;
        LOGGER.info("setMainInvoiceValue \u5f00\u59cb,\u53d1\u7968\u7c7b\u578b\u4e3a{}", (Object)invoiceType);
        if (invoice == null || mainDynamicObject == null || logInfo == null || saveService == null) {
            return;
        }
        String etaxInvoiceNo = invoice.getString("etaxInvoiceNo");
        if (InputInvoiceTypeEnum.isExistEtaxInvoiceNo(invoiceType)) {
            if (StringUtils.isNotEmpty((CharSequence)etaxInvoiceNo) && InvoiceConvertUtils.checkElectronicNo(etaxInvoiceNo)) {
                mainDynamicObject.set("electronic_no", (Object)etaxInvoiceNo);
            }
        } else {
            invoice.remove((Object)"etaxInvoiceNo");
            mainDynamicObject.set("electronic_no", null);
        }
        if (StringUtils.isNotEmpty((CharSequence)(specialTypeMark = invoice.getString("specialTypeMark")))) {
            mainDynamicObject.set("special_type_mark", (Object)specialTypeMark);
        }
        mainDynamicObject.set("modifytime", (Object)new Date());
        String invoiceStatus = invoice.getString("invoiceStatus");
        mainDynamicObject.set("invoice_status", (Object)invoiceStatus);
        String sellerName = invoice.getString("sellerName");
        if (StringUtils.isBlank((CharSequence)sellerName)) {
            sellerName = invoice.getString("salerName");
        }
        if (StringUtils.isNotBlank((CharSequence)sellerName)) {
            mainDynamicObject.set("saler_name", (Object)sellerName);
        }
        if (StringUtils.isNotBlank((CharSequence)invoice.getString("salerTaxNo"))) {
            mainDynamicObject.set("saler_tax_no", (Object)invoice.getString("salerTaxNo"));
        }
        if (!"inputHeader".equals(invoice.getString("downResource"))) {
            if (InputInvoiceTypeEnum.canSelfproducedAgric(invoiceType) || InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getCode().equals(invoiceType)) {
                saveService.setAgricData(mainDynamicObject, invoiceBody, invoice);
            }
            saveService.setDeductionFieldValue(invoiceType, mainDynamicObject, invoice);
            saveService.setDeductionFlag(invoice, mainDynamicObject);
            logInfo.put("deductionFlag", (Object)mainDynamicObject.getString(InvoiceSaveConstant.FIELD_DEDUCTION_FLAG));
        } else if (DeductionDownService.isLqHeadNotDeductionFlag(invoiceStatus, invoiceType, mainDynamicObject)) {
            InvoiceSaveService.setExtInfo(mainDynamicObject, InvoiceSaveConstant.EXT_DEDUCTION_FLAG, mainDynamicObject.getString(InvoiceSaveConstant.FIELD_DEDUCTION_FLAG));
        }
        if (InputInvoiceTypeEnum.HGJKS.getCode().equals(invoiceType) && (totalTaxAmount = invoice.getBigDecimal("totalTaxAmount")) != null) {
            mainDynamicObject.set("total_tax_amount", (Object)totalTaxAmount);
            mainDynamicObject.set("total_amount", (Object)totalTaxAmount);
        }
        if (InputInvoiceTypeEnum.AIR_ELE_INVOICE.getCode().equals(invoiceType)) {
            mainDynamicObject.set("invoice_amount", invoice.get((Object)"invoiceAmount"));
        }
        saveService.setMainInvoiceInfo(mainDynamicObject);
        saveService.setSourceAndRiskLevel(invoice, mainDynamicObject);
        if (orgId == 0L || "1".equals(invoice.getString("overrideOrg"))) {
            Long invoiceOrgId = saveService.getOrgId(invoice);
            RequestContext requestContext = RequestContext.get();
            saveService.setUserAndOrg(requestContext.getUserId(), String.valueOf(invoiceOrgId), 0L, mainDynamicObject, true);
        }
        DeductionDownService.updateOrg(mainDynamicObject, saveService, invoice, logInfo, orgId, mainDynamicObject.getString("buyer_tax_no"));
        LOGGER.info("setMainInvoiceValue \u7ed3\u675f");
    }

    private static void updateOrg(DynamicObject dynamicObject, InvoiceSaveService saveService, JSONObject invoice, JSONObject logInfo, long orgId, String buyerTaxNo) {
        Date invoiceDate;
        if (orgId == 0L || "1".equals(invoice.getString("overrideOrg"))) {
            Long invoiceOrgId = saveService.getOrgId(invoice);
            String taxNo = invoice.getString("buyerTaxNo");
            if (StringUtils.isEmpty((CharSequence)taxNo)) {
                taxNo = buyerTaxNo;
            }
            Long invoiceTaxOrgId = TenantUtils.getTaxOrgId(null, taxNo);
            LOGGER.info("\u53d1\u7968:{}-{},\u539f\u7ec4\u7ec7id:{},\u66f4\u65b0\u540e\u7684\u7ec4\u7ec7id:{}", new Object[]{invoice.getString("invoiceCode"), invoice.getString("invoiceNo"), orgId, invoiceOrgId});
            if (logInfo != null) {
                logInfo.put("OrgId", (Object)invoiceOrgId);
                logInfo.put("tagOrgId", (Object)invoiceTaxOrgId);
            }
            dynamicObject.set("org", (Object)invoiceOrgId);
            dynamicObject.set("tax_org", (Object)invoiceTaxOrgId);
        } else if (DynamicObjectUtil.getDynamicObjectLongValue(dynamicObject.get("tax_org")) == 0L) {
            String taxNo = invoice.getString("buyerTaxNo");
            if (StringUtils.isEmpty((CharSequence)taxNo)) {
                taxNo = buyerTaxNo;
            }
            Long invoiceTaxOrgId = TenantUtils.getTaxOrgId(null, taxNo);
            dynamicObject.set("tax_org", (Object)invoiceTaxOrgId);
            if (logInfo != null) {
                logInfo.put("tagOrgId", (Object)invoiceTaxOrgId);
            }
        }
        String updateDelete = RimConfigUtils.getConfig("rim_deduction", "update_delete");
        if (!"0".equals(updateDelete)) {
            dynamicObject.set("delete", (Object)"1");
        }
        if ((invoiceDate = invoice.getDate("invoiceDate")) != null && !DateUtils.isTimeZero(invoiceDate)) {
            dynamicObject.set("invoice_date", (Object)invoiceDate);
        }
    }

    private static void setInvoiceBodyValue(DynamicObject invoiceBody, DynamicObject mainDynamicObject, InvoiceSaveService saveService, JSONObject invoice, Long invoiceType, long orgId) {
        String sellerName;
        LOGGER.info("setInvoiceBodyValue \u5f00\u59cb,\u53d1\u7968\u7c7b\u578b\u4e3a{}", (Object)invoiceType);
        if (invoice == null || invoiceBody == null || saveService == null) {
            return;
        }
        invoiceBody.set("modifytime", (Object)new Date());
        if (!"inputHeader".equals(invoice.getString("downResource"))) {
            saveService.setDeductionFieldValue(invoiceType, invoiceBody, invoice);
            saveService.setDeductionFlag(invoice, invoiceBody);
        } else {
            String invoiceStatus = invoice.getString("invoiceStatus");
            DeductionDownService.isLqHeadNotDeductionFlag(invoiceStatus, invoiceType, mainDynamicObject);
        }
        if (!InputInvoiceTypeEnum.HGJKS.getCode().equals(invoiceType) && !InputInvoiceTypeEnum.WITHHOLDING.getCode().equals(invoiceType)) {
            invoiceBody.set("invoice_status", (Object)invoice.getString("invoiceStatus"));
        }
        if (InputInvoiceTypeEnum.HGJKS.getCode().equals(invoiceType)) {
            invoiceBody.set("subject", (Object)"1");
            BigDecimal totalTaxAmount = invoice.getBigDecimal("totalTaxAmount");
            if (totalTaxAmount != null) {
                invoiceBody.set("total_tax_amount", (Object)totalTaxAmount);
            }
        }
        if (InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getCode().equals(invoiceType) || InputInvoiceTypeEnum.ELECTRIC_SPECIAL.getCode().equals(invoiceType)) {
            if (StringUtils.isNotBlank((CharSequence)invoice.getString("buyerAccount"))) {
                invoiceBody.set("buyer_account", (Object)invoice.getString("buyerAccount"));
            }
            if (StringUtils.isNotBlank((CharSequence)invoice.getString("buyerAddressPhone"))) {
                invoiceBody.set("buyer_address_phone", (Object)invoice.getString("buyerAddressPhone"));
            }
            if (StringUtils.isNotBlank((CharSequence)invoice.getString("salerAccount"))) {
                invoiceBody.set("saler_account", (Object)invoice.getString("salerAccount"));
            }
            if (StringUtils.isNotBlank((CharSequence)invoice.getString("salerAddressPhone"))) {
                invoiceBody.set("saler_address_phone", (Object)invoice.getString("salerAddressPhone"));
            }
        }
        if (InputInvoiceTypeEnum.AIR_ELE_INVOICE.getCode().equals(invoiceType)) {
            JSONArray items;
            String salesUnitCode;
            BigDecimal ticketPrice;
            if (StringUtils.isNotBlank((CharSequence)invoice.getString("seatGrade"))) {
                invoiceBody.set("seat_grade", (Object)invoice.getString("seatGrade"));
            }
            if (BigDecimal.ZERO.compareTo(ticketPrice = saveService.getObject(invoice, "ticketPrice", BigDecimal.class)) != 0 && StringUtils.isNotBlank((CharSequence)invoice.getString("ticketPrice"))) {
                invoiceBody.set("ticket_price", (Object)invoice.getString("ticketPrice"));
            }
            if (StringUtils.isBlank((CharSequence)(sellerName = invoice.getString("sellerName")))) {
                sellerName = invoice.getString("salerName");
            }
            if (StringUtils.isNotBlank((CharSequence)sellerName)) {
                invoiceBody.set("seller_name", (Object)sellerName);
            }
            if (StringUtils.isEmpty((CharSequence)(salesUnitCode = invoice.getString("salesUnitCode")))) {
                salesUnitCode = invoice.getString("salerTaxNo");
            }
            if (StringUtils.isNotBlank((CharSequence)salesUnitCode)) {
                invoiceBody.set("sales_unit_code", (Object)salesUnitCode);
            }
            if (StringUtils.isNotBlank((CharSequence)invoice.getString("fuelSurcharge"))) {
                invoiceBody.set("fuel_surcharge", (Object)invoice.getString("fuelSurcharge"));
            }
            if (StringUtils.isNotBlank((CharSequence)invoice.getString("taxRate"))) {
                invoiceBody.set("tax_rate", (Object)invoice.getString("taxRate"));
            }
            if (StringUtils.isNotBlank((CharSequence)invoice.getString("airportConstructionFee"))) {
                invoiceBody.set("airport_construction_fee", (Object)invoice.getString("airportConstructionFee"));
            }
            if (StringUtils.isNotBlank((CharSequence)invoice.getString("otherTotalTaxAmount"))) {
                invoiceBody.set("other_total_tax_amount", (Object)invoice.getString("otherTotalTaxAmount"));
            }
            if (StringUtils.isNotBlank((CharSequence)invoice.getString("electronicTicketNum"))) {
                invoiceBody.set("electronic_ticket_num", (Object)invoice.getString("electronicTicketNum"));
            }
            if (StringUtils.isNotBlank((CharSequence)invoice.getString("insurancePremium"))) {
                invoiceBody.set("insurance_premium", (Object)invoice.getString("insurancePremium"));
            }
            if (StringUtils.isNotBlank((CharSequence)invoice.getString("fillingUnit"))) {
                invoiceBody.set("filling_unit", (Object)invoice.getString("fillingUnit"));
            }
            if ((items = invoice.getJSONArray("items")) != null) {
                DynamicObjectCollection collection = (DynamicObjectCollection)invoiceBody.get("items");
                for (int i = 0; i < items.size(); ++i) {
                    JSONObject itemJson = items.getJSONObject(i);
                    String seatGrade = itemJson.getString("seatGrade");
                    if (!StringUtils.isNotBlank((CharSequence)seatGrade)) continue;
                    DynamicObject invoiceItem = (DynamicObject)collection.get(i);
                    invoiceItem.set("entry_seat_grade", (Object)seatGrade);
                }
            }
        }
        if (InputInvoiceTypeEnum.AIR_ELE_INVOICE.getCode().equals(invoiceType)) {
            invoiceBody.set("invoice_amount", invoice.get((Object)"invoiceAmount"));
            if (invoice.get((Object)"totalTaxInclAmount") != null) {
                invoiceBody.set("total_tax_incl_amount", (Object)invoice.getBigDecimal("totalTaxInclAmount"));
            } else {
                BigDecimal invoiceAmount = BigDecimalUtil.transDecimal(invoice.get((Object)"invoiceAmount"));
                BigDecimal totalTaxAmount = BigDecimalUtil.transDecimal(invoice.get((Object)"totalTaxAmount"));
                BigDecimal totalTaxInclAmount = invoiceAmount.add(totalTaxAmount);
                invoiceBody.set("total_tax_incl_amount", (Object)totalTaxInclAmount);
            }
        }
        if (InputInvoiceTypeEnum.TRAIN_ELE_INVOICE.getCode().equals(invoiceType)) {
            String sellerUnifiedSocialCreditCode;
            if (StringUtils.isNotBlank((CharSequence)invoice.getString("seatLevel"))) {
                invoiceBody.set("seat_level", (Object)invoice.getString("seatLevel"));
            }
            String tknumber = saveService.getJSONValue(invoice, String.class, "eleTicketNumber", "electronicTicketNum");
            if (StringUtils.isNotBlank((CharSequence)invoice.getString("tknumber"))) {
                invoiceBody.set("ele_ticket_number", (Object)tknumber);
            }
            if (StringUtils.isBlank((CharSequence)(sellerName = invoice.getString("sellerName")))) {
                sellerName = invoice.getString("salerName");
            }
            if (StringUtils.isNotBlank((CharSequence)sellerName)) {
                invoiceBody.set("seller_name", (Object)sellerName);
            }
            if (StringUtils.isEmpty((CharSequence)(sellerUnifiedSocialCreditCode = invoice.getString("sellerUnifiedSocialCreditCode")))) {
                sellerUnifiedSocialCreditCode = invoice.getString("salerTaxNo");
            }
            if (StringUtils.isNotBlank((CharSequence)sellerUnifiedSocialCreditCode)) {
                invoiceBody.set("seller_unif_soc_cre_code", (Object)sellerUnifiedSocialCreditCode);
            }
            String businessType = saveService.getJSONValue(invoice, String.class, "businessType", "typeOfBusiness");
            if (CollectTypeEnum.PC_SHUIPAN.getCode().equals(invoice.getString("collect_type")) && kd.bos.util.StringUtils.isEmpty((String)businessType)) {
                businessType = invoiceBody.getString("business_type");
            }
            if ("\u552e".equals(businessType)) {
                businessType = "1";
            }
            if ("\u9000".equals(businessType)) {
                businessType = "2";
            }
            if (StringUtils.isNotBlank((CharSequence)businessType)) {
                invoiceBody.set("business_type", (Object)businessType);
            }
        }
        String originalInvoiceCode = invoice.getString("originalInvoiceCode");
        String originalInvoiceNo = invoice.getString("originalInvoiceNo");
        if (StringUtils.isNotBlank((CharSequence)originalInvoiceCode) && CommonUtils.dynamicObjectContainsProperty(invoiceBody, "original_invoice_code")) {
            invoiceBody.set("original_invoice_code", (Object)originalInvoiceCode);
        }
        if (StringUtils.isNotBlank((CharSequence)originalInvoiceNo) && CommonUtils.dynamicObjectContainsProperty(invoiceBody, "original_invoice_no")) {
            invoiceBody.set("original_invoice_no", (Object)originalInvoiceNo);
        }
        DeductionDownService.updateOrg(invoiceBody, saveService, invoice, null, orgId, mainDynamicObject.getString("buyer_tax_no"));
        LOGGER.info("setInvoiceBodyValue \u7ed3\u675f,\u53d1\u7968\u7c7b\u578b\u4e3a{}", (Object)invoiceType);
    }

    private static boolean isLqHeadNotDeductionFlag(String invoiceStatus, Long invoiceType, DynamicObject dynamicObject) {
        boolean isHgjks;
        boolean bl = isHgjks = InputInvoiceTypeEnum.HGJKS.getCode().equals(invoiceType) || InputInvoiceTypeEnum.WITHHOLDING.getCode().equals(invoiceType);
        if (!isHgjks && StringUtils.isNotBlank((CharSequence)invoiceStatus) && !"0".equals(invoiceStatus) && !"7".equals(invoiceStatus)) {
            dynamicObject.set(InvoiceSaveConstant.FIELD_DEDUCTION_FLAG, (Object)"0");
            String authenticateFlag = dynamicObject.getString("authenticate_flag");
            if ("0".equals(authenticateFlag) || "4".equals(authenticateFlag) || StringUtils.isEmpty((CharSequence)authenticateFlag)) {
                dynamicObject.set("authenticate_flag", (Object)"0");
                dynamicObject.set("tax_period", null);
                dynamicObject.set("deduction_purpose", (Object)"");
                dynamicObject.set("effective_tax_amount", null);
                dynamicObject.set("not_deductible_type", null);
            }
            return true;
        }
        return false;
    }

    private static void saveLog(JSONObject invoice, JSONObject logInfo) {
        if (invoice == null || logInfo == null) {
            return;
        }
        logInfo.put("authenticateFlag", (Object)invoice.getString("authenticateFlag"));
        logInfo.put("invoiceStatus", (Object)invoice.getString("invoiceStatus"));
        logInfo.put("traceId", (Object)RequestContext.get().getTraceId());
        InvoiceLog.insert("deduct_authenticate", invoice.getString("serialNo"), logInfo.toJSONString(), invoice.getLong("org_id"), CollectTypeEnum.PC_SHUIPAN.getName(), CollectTypeEnum.PC_SHUIPAN.getCode());
    }

    public static String handleTaxFullInvoice(InvoiceSaveService service, JSONObject invoiceJson) {
        QFilter serialFilter;
        if (service == null || invoiceJson == null) {
            return null;
        }
        Long invoiceType = service.getInvoiceType();
        String checkFlag = RimConfigUtils.getConfig("rim_deduction", "not_check_status");
        boolean isCheckType = false;
        String checkTypes = RimConfigUtils.getConfig("rim_down", "notcheck_status_types");
        if (StringUtils.isNotBlank((CharSequence)checkTypes)) {
            LOGGER.info("\u914d\u7f6e\u53d1\u7968\u7c7b\u578b\u5168\u91cf\u66f4\u65b0:{}", (Object)checkTypes);
            List<String> types = CommonUtils.getMultiValues(checkTypes);
            isCheckType = types.contains(InputInvoiceTypeEnum.getAwsType(invoiceType));
        }
        if ("1".equals(checkFlag) || isCheckType || InputInvoiceTypeEnum.HGJKS.getCode().equals(invoiceType) || InputInvoiceTypeEnum.AIR_ELE_INVOICE.getCode().equals(invoiceType) || InputInvoiceTypeEnum.TRAIN_ELE_INVOICE.getCode().equals(invoiceType) || InputInvoiceTypeEnum.WITHHOLDING.getCode().equals(invoiceType)) {
            return null;
        }
        DynamicObject invoiceObject = service.getInvoiceDynamicObject(invoiceJson);
        String serialNo = null;
        if (invoiceObject == null || service.checkIdIsNull(invoiceObject.getPkValue()).booleanValue()) {
            return serialNo;
        }
        String tenantNo = invoiceObject.getString("tenant_no");
        QFilter tenantFilter = new QFilter("tenant_no", "=", (Object)tenantNo);
        DynamicObject queryMain = QueryServiceHelper.queryOne((String)"rim_invoice", (String)"id,check_status", (QFilter[])new QFilter[]{tenantFilter, serialFilter = new QFilter("serial_no", "=", (Object)invoiceObject.getString("serial_no"))});
        if (ObjectUtils.isEmpty((Object)queryMain)) {
            return serialNo;
        }
        String checkStatusPre = queryMain.getString("check_status");
        if ("1".equals(checkStatusPre)) {
            DynamicObject mainDynamicObject = BusinessDataServiceHelper.loadSingle((Object)queryMain.get("id"), (String)"rim_invoice");
            serialNo = invoiceObject.getString("serial_no");
            String invoiceCode = invoiceJson.getString("invoiceCode");
            String invoiceNo = CommonUtils.getJsonValue((Map<String, Object>)invoiceJson, String.class, "invoiceNo", "jkshm", "customDeclarationNo");
            String invoiceCodeNo = CommonUtils.getInvoiceCodeNoGroup(invoiceCode, invoiceNo);
            LOGGER.info("\u53d1\u7968\u5df2\u9a8c:{} \u76f4\u63a5\u66f4\u65b0\u5173\u952e\u6570\u636e", (Object)invoiceCodeNo);
            invoiceJson.put("serialNo", (Object)serialNo);
            JSONObject logInfo = new JSONObject();
            long orgId = DynamicObjectUtil.getDynamicObjectLongValue(mainDynamicObject.get("org"));
            if ("6".equals(mainDynamicObject.getString("invoice_status")) && "0".equals(invoiceJson.getString("invoiceStatus"))) {
                invoiceJson.put("invoiceStatus", (Object)mainDynamicObject.getString("invoice_status"));
            }
            DeductionDownService.setMainInvoiceValue(mainDynamicObject, service, invoiceJson, invoiceType, logInfo, orgId, invoiceObject);
            DeductionDownService.setInvoiceBodyValue(invoiceObject, mainDynamicObject, service, invoiceJson, invoiceType, orgId);
            service.setInvoiceItemsValue(invoiceJson, invoiceObject);
            JSONArray items = invoiceJson.getJSONArray("items");
            if (!CollectionUtils.isEmpty((Collection)items)) {
                service.setInvoiceItemsValue(invoiceJson, invoiceObject);
            }
            try (TXHandle h = TX.required();){
                try {
                    service.updateInvoiceStatusByRedRemark(invoiceType, mainDynamicObject, invoiceJson);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{mainDynamicObject});
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{invoiceObject});
                    DeductionDownService.saveLog(invoiceJson, logInfo);
                }
                catch (Throwable e) {
                    LOGGER.error("\u7a0e\u76d8\u4e0b\u8f7d\u66f4\u65b0\u53d1\u7968\u62a5\u9519", e);
                    h.markRollback();
                    throw e;
                }
            }
        }
        return serialNo;
    }
}

