/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.deduction;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.invoice.query.InvoiceQueryService;
import kd.imc.rim.common.invoice.save.InvoiceSaveService;
import kd.imc.rim.common.service.InvoiceLog;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.TenantUtils;

public class UpdateAuthenticateFlagTask
implements Callable<Boolean> {
    private RequestContext ctx;
    private List<Object> idList;
    private String authenticateFlag;
    private Date operateTime;

    public UpdateAuthenticateFlagTask(RequestContext ctx, List<Object> idList, String authenticateFlag) {
        this.ctx = ctx;
        this.idList = idList;
        this.authenticateFlag = authenticateFlag;
    }

    public UpdateAuthenticateFlagTask(RequestContext ctx, List<Object> idList, String authenticateFlag, Date operateTime) {
        this.ctx = ctx;
        this.idList = idList;
        this.authenticateFlag = authenticateFlag;
        this.operateTime = operateTime;
    }

    @Override
    public Boolean call() throws Exception {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"rim_invoice");
        DynamicObject[] mains = BusinessDataServiceHelper.load((Object[])this.idList.toArray(), (DynamicObjectType)mainEntityType);
        InvoiceSaveService saveService = new InvoiceSaveService();
        HashMap<Long, List> typeMap = new HashMap<Long, List>(8);
        ArrayList<String> updateSerialNos = new ArrayList<String>(8);
        for (DynamicObject main : mains) {
            String string = main.getString("serial_no");
            if (!this.setUpdateAuthenticateValus(this.authenticateFlag, main)) continue;
            updateSerialNos.add(string);
            saveService.setMainInvoiceInfo(main);
            Long typeId = DynamicObjectUtil.getDynamicObjectLongValue(main.get("invoice_type"));
            List list = typeMap.getOrDefault(typeId, new ArrayList(8));
            list.add(string);
            typeMap.put(typeId, list);
        }
        String tenantNo = TenantUtils.getTenantNo();
        try (TXHandle h = TX.required();){
            try {
                SaveServiceHelper.save((DynamicObject[])mains);
                for (Map.Entry entry : typeMap.entrySet()) {
                    String entity;
                    Object[] invoiceList;
                    if (ObjectUtils.isEmpty((Object)entry) || ArrayUtils.isEmpty((Object[])(invoiceList = InvoiceQueryService.loadAllBySerialNo(entity = InputInvoiceTypeEnum.getEntity((Long)entry.getKey()), tenantNo, (Collection)entry.getValue())))) continue;
                    for (Object bodyDynamicObject : invoiceList) {
                        this.setUpdateAuthenticateValus(this.authenticateFlag, (DynamicObject)bodyDynamicObject);
                    }
                    SaveServiceHelper.save((DynamicObject[])invoiceList);
                }
                JSONObject info = new JSONObject();
                info.put("authenticateFlag", (Object)this.authenticateFlag);
                info.put("traceId", (Object)this.ctx.getTraceId());
                ThreadPools.executeOnceIncludeRequestContext((String)"DeductInvoiceOperateService.saveInvoiceLog1", () -> InvoiceLog.insert("deduct_authenticate", updateSerialNos, info.toJSONString()));
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
        return Boolean.TRUE;
    }

    private boolean setUpdateAuthenticateValus(String authenticateFlag, DynamicObject dynamicObject) {
        String preAuthenticateFlag = dynamicObject.getString("authenticate_flag");
        if ("2".equals(authenticateFlag) && "1".equals(preAuthenticateFlag)) {
            dynamicObject.set("authenticate_time", (Object)new Date());
        } else if ("1".equals(authenticateFlag) && "2".equals(preAuthenticateFlag)) {
            dynamicObject.set("authenticate_time", null);
        } else {
            return false;
        }
        dynamicObject.set("authenticate_flag", (Object)authenticateFlag);
        dynamicObject.set("modifytime", (Object)new Date());
        if (this.operateTime != null) {
            dynamicObject.set("tax_operatetime", (Object)this.operateTime);
        }
        return true;
    }
}

