/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.deduction.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.InvoiceDownloadConstant;
import kd.imc.rim.common.invoice.deduction.DeductSelectService;
import kd.imc.rim.common.invoice.deduction.DeductService;
import kd.imc.rim.common.invoice.deduction.impl.BwAsyncDeductSelectService;
import kd.imc.rim.common.invoice.deduction.impl.BwDeductService;

public class BwDeductSelectService
extends DeductSelectService {
    private static final int DEFAULT_SIZE = 100;

    public BwDeductSelectService() {
        int size = InvoiceDownloadConstant.getPageSizeFromConfig(100, "bw_select_size");
        if (size <= 0) {
            size = 100;
        }
        this.selectSize = size;
    }

    @Override
    public DeductService getDeductServiceImpl(Long orgId) {
        return new BwDeductService(orgId);
    }

    @Override
    public Map<String, Object> selectedResult(DeductService service, JSONObject paramJson) {
        HashMap result = Maps.newHashMap();
        int successNum = 0;
        int failNum = 0;
        JSONArray invoices = paramJson.getJSONArray("invoices");
        HashMap<String, String> serialNoStatusMap = new HashMap<String, String>(8);
        for (int i = 0; i < invoices.size(); ++i) {
            serialNoStatusMap.put(invoices.getJSONObject(i).getString("serialNo"), "5");
        }
        int size = invoices.size();
        String billType = paramJson.getString("billType");
        StringBuilder message = new StringBuilder();
        JSONObject gxInvoicesRtn = service.gxInvoices(paramJson);
        if (ErrorType.SUCCESS.getCode().equals(gxInvoicesRtn.get((Object)"errcode"))) {
            JSONArray data = gxInvoicesRtn.getJSONArray("data");
            StringBuilder batchNo = new StringBuilder();
            for (int i = 0; i < data.size(); ++i) {
                JSONObject info = data.getJSONObject(i);
                String taskNo = info.getString("task_no");
                String invoiceNo = info.getString("invoice_number");
                String handleStatus = "3";
                if (StringUtils.isEmpty((String)taskNo)) {
                    handleStatus = "2";
                } else {
                    batchNo.append(taskNo).append(",");
                }
                JSONArray subInvoice = invoices.stream().filter(f -> ((JSONObject)f).getString("invoiceNo").equals(invoiceNo)).collect(Collectors.toCollection(JSONArray::new));
                paramJson.put("invoices", (Object)subInvoice);
                this.insertSelectAccount(paramJson, ErrorType.STATUS_HANDLING.getCode(), info.getString("task_no"), "2", handleStatus);
            }
            successNum = size;
            if (batchNo.length() > 0) {
                result.put("batchNo", batchNo.substring(batchNo.length() - 1));
            }
            this.updateInvoiceSelecting(serialNoStatusMap);
        } else {
            failNum = size;
            this.setFailMessage(paramJson, String.format(ResManager.loadKDString((String)"\u52fe\u9009\u5931\u8d25:%s", (String)"BwDeductSelectService_0", (String)"imc-rim-common", (Object[])new Object[0]), gxInvoicesRtn.getString("description")), message);
        }
        result.put("errcode", gxInvoicesRtn.getString("errcode"));
        result.put("successNum", successNum);
        result.put("failNum", failNum);
        result.put("message", message.toString());
        result.put("sync", "0");
        return result;
    }

    @Override
    public void queryAsyncSelectResult(List<String> batchNoList) {
        if (!CollectionUtils.isEmpty(batchNoList)) {
            BwAsyncDeductSelectService asyncDeductSelectService = new BwAsyncDeductSelectService();
            asyncDeductSelectService.queryAsyncSelectResultByBatchNo(batchNoList);
        }
    }
}

