/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.deduction.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.util.CollectionUtils;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.invoice.deduction.DeductInvoiceOperateService;
import kd.imc.rim.common.invoice.deduction.DeductService;
import kd.imc.rim.common.invoice.deduction.impl.LqAsyncDeductSelectService;
import kd.imc.rim.common.invoice.deduction.impl.LqDeductService;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.TenantUtils;

public class LqAsyncAgrichandleService
extends LqAsyncDeductSelectService {
    @Override
    public void setUpdateInvoiceData(JSONObject example, DynamicObject updateAccount, JSONObject successJson, String deductibleMode) {
        if (example == null || updateAccount == null || successJson == null) {
            return;
        }
        String effectiveTaxAmountRtn = successJson.getString("effectiveTaxAmount");
        if (StringUtils.isNotEmpty((CharSequence)effectiveTaxAmountRtn)) {
            BigDecimal effectiveTaxAmount = BigDecimalUtil.transDecimal(effectiveTaxAmountRtn);
            example.put("effective_tax_amount", (Object)effectiveTaxAmount);
            updateAccount.set("effective_tax_amount", (Object)effectiveTaxAmount);
        } else {
            example.put("effective_tax_amount", updateAccount.get("effective_tax_amount"));
        }
        String agricPartialAmountRtn = successJson.getString("agricPartialAmount");
        if (StringUtils.isNotEmpty((CharSequence)agricPartialAmountRtn)) {
            BigDecimal agricPartialAmount = BigDecimalUtil.transDecimal(agricPartialAmountRtn);
            example.put("agric_partial_amount", (Object)agricPartialAmount);
            updateAccount.set("agric_partial_amount", (Object)agricPartialAmount);
        } else {
            example.put("agric_partial_amount", (Object)updateAccount.getBigDecimal("agric_partial_amount"));
        }
        String agricPartialTaxAmountRtn = successJson.getString("agricPartialTaxAmount");
        if (StringUtils.isNotEmpty((CharSequence)agricPartialTaxAmountRtn)) {
            BigDecimal agricPartialTaxAmount = BigDecimalUtil.transDecimal(agricPartialTaxAmountRtn);
            example.put("agric_partial_taxamount", (Object)agricPartialTaxAmount);
            updateAccount.set("agric_partial_taxamount", (Object)agricPartialTaxAmount);
        } else {
            example.put("agric_partial_taxamount", (Object)updateAccount.getBigDecimal("agric_partial_taxamount"));
        }
        if ("14".equals(deductibleMode)) {
            example.put("deduction_purpose", (Object)"2");
            updateAccount.set("effective_tax_amount", (Object)BigDecimal.ZERO);
            example.put("effective_tax_amount", (Object)BigDecimal.ZERO);
        } else {
            example.remove((Object)"deduction_purpose");
        }
    }

    @Override
    public void setFailInvoiceStatus(Map<String, String> serialNoStatusMap, DynamicObject failAccount) {
        if (StringUtils.isNotEmpty((CharSequence)failAccount.getString("serial_no"))) {
            serialNoStatusMap.put(failAccount.getString("serial_no"), failAccount.getString("pre_authenticate_flag"));
        }
    }

    @Override
    public void updateInvoiceData(String taxNo, JSONArray updateInvoiceArray, String deductibleMode) {
        DeductInvoiceOperateService deductInvoiceOperateService = new DeductInvoiceOperateService();
        deductInvoiceOperateService.updateAgricHandleInvoice(updateInvoiceArray, deductibleMode, taxNo);
    }

    @Override
    protected JSONObject doSelect(Long orgId, JSONObject param) {
        if (TenantUtils.isSmallScaleTaxpayer(param.getString("taxNo"))) {
            return ResultContant.createJSONObject(ErrorType.SMALL_SCALE_TAXPAYER_DEDUCT);
        }
        LqDeductService deductService = new LqDeductService(orgId);
        return ((DeductService)deductService).agricInvoiceHandleQuery(param);
    }

    @Override
    protected void recoverMainInvoiceStatus(Map<String, String> serialNoStatusMap) {
        this.recoverMainInvoiceStatus(serialNoStatusMap, "");
    }

    @Override
    protected void recoverMainInvoiceStatus(Map<String, String> serialNoStatusMap, String selectOperaType) {
        if (!CollectionUtils.isEmpty(serialNoStatusMap)) {
            DeductInvoiceOperateService operateService = new DeductInvoiceOperateService();
            operateService.updateMainInvoiceHanding(serialNoStatusMap, "0");
        }
    }
}

