/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.deduction.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.InvoiceDownloadConstant;
import kd.imc.rim.common.invoice.deduction.DeductSelectService;
import kd.imc.rim.common.invoice.deduction.DeductService;
import kd.imc.rim.common.invoice.deduction.impl.LqAsyncDeductSelectService;
import kd.imc.rim.common.invoice.deduction.impl.LqDeductService;
import kd.imc.rim.common.utils.ViewUtil;

public class LqDeductSelectService
extends DeductSelectService {
    private static Log LOGGER = LogFactory.getLog(LqDeductSelectService.class);
    private static final int DEFAULT_SIZE = 1000;
    private static Set<String> WITHHOLDING_FILEDS = Sets.newHashSet((Object[])new String[]{"voucherNo", "invoiceDate", "withholdingAgentIDNum"});

    public LqDeductSelectService() {
        int size = InvoiceDownloadConstant.getPageSizeFromConfig(1000, "lq_select_size");
        if (size <= 0) {
            size = 1000;
        }
        this.selectSize = size;
    }

    @Override
    public DeductService getDeductServiceImpl(Long orgId) {
        return new LqDeductService(orgId);
    }

    @Override
    public Map<String, Object> selectedResult(DeductService service, JSONObject paramJson) {
        HashMap result = Maps.newHashMap();
        int successNum = 0;
        int failNum = 0;
        JSONArray invoices = paramJson.getJSONArray("invoices");
        int size = invoices.size();
        StringBuilder message = new StringBuilder();
        String billType = paramJson.getString("billType");
        ArrayList<JSONObject> invoiceOriginList = new ArrayList<JSONObject>(size);
        for (int i = 0; i < invoices.size(); ++i) {
            JSONObject jsonObject = invoices.getJSONObject(i);
            if ("2".equals(billType) && LqDeductSelectService.checkHaveNullLQ(WITHHOLDING_FILEDS, jsonObject)) {
                String voucherNo = jsonObject.getString("voucherNo");
                message.append(String.format(ResManager.loadKDString((String)"\u53d1\u7968%1$s \u52fe\u9009\u6240\u9700\u5b57\u6bb5\u4e0d\u5b8c\u6574\uff0c\u8bf7\u524d\u5f80\u201c\u53d1\u7968\u5f52\u96c6\u7ba1\u7406-\u8fdb\u9879\u53d1\u7968\u5173\u952e\u8981\u7d20\u540c\u6b65\u201d\u624b\u5de5\u4e0b\u8f7d\u540e\u91cd\u8bd5\u3002", (String)"NewEtaxDeductSelectService_1", (String)"imc-rim-common", (Object[])new Object[0]), voucherNo)).append(ViewUtil.LINE_SEPARATOR);
                ++failNum;
                continue;
            }
            invoiceOriginList.add(jsonObject);
        }
        if (CollectionUtils.isEmpty(invoiceOriginList)) {
            LOGGER.info("\u6240\u6709\u53d1\u7968\u7684\u5fc5\u586b\u6027\u6821\u9a8c\u5931\u8d25\uff0c\u4e0d\u8fdb\u884c\u8c03\u7528\u4e50\u4f01");
            result.put("errcode", "0002");
            result.put("successNum", successNum);
            result.put("failNum", failNum);
            result.put("message", message.toString());
            result.put("sync", "0");
            return result;
        }
        paramJson.put("invoices", invoiceOriginList);
        JSONObject gxInvoicesRtn = service.gxInvoices(paramJson);
        JSONObject data = gxInvoicesRtn.getJSONObject("data");
        JSONArray fail = new JSONArray();
        if (data != null) {
            fail = data.getJSONArray("fail");
        }
        if (ErrorType.SUCCESS.getCode().equals(gxInvoicesRtn.get((Object)"errcode"))) {
            String batchNo = "";
            if (data != null) {
                batchNo = data.getString("batchNo");
            }
            result.put("batchNo", batchNo);
            if (!CollectionUtils.isEmpty((Collection)fail)) {
                this.handlePartialFail(fail, invoices, message, this.getTitle(), billType);
            }
            this.insertSelectAccount(paramJson, ErrorType.STATUS_HANDLING.getCode(), batchNo, "2", "3");
            HashMap<String, String> serialNoStatusMap = new HashMap<String, String>(8);
            for (int i = 0; i < invoices.size(); ++i) {
                JSONObject invoice1 = invoices.getJSONObject(i);
                if (!StringUtils.isBlank((CharSequence)invoice1.getString("selectResult"))) continue;
                ++successNum;
                serialNoStatusMap.put(invoice1.getString("serialNo"), "5");
            }
            this.updateInvoiceSelecting(serialNoStatusMap);
        } else if (!CollectionUtils.isEmpty((Collection)fail)) {
            this.handlePartialFail(fail, invoices, message, this.getTitle(), billType);
        } else {
            this.setFailMessage(paramJson, String.format(ResManager.loadKDString((String)"\u52fe\u9009\u5931\u8d25:%s", (String)"LqDeductSelectService_0", (String)"imc-rim-common", (Object[])new Object[0]), gxInvoicesRtn.getString("description")), message);
        }
        result.put("errcode", gxInvoicesRtn.getString("errcode"));
        result.put("successNum", successNum);
        result.put("failNum", size - successNum);
        result.put("message", message.toString());
        result.put("sync", "0");
        return result;
    }

    private static boolean checkHaveNullLQ(Set<String> fields, JSONObject data) {
        for (String field : fields) {
            Object value = data.get((Object)field);
            if (Objects.isNull(value)) {
                return true;
            }
            if (!(value instanceof String) || !org.apache.commons.lang.StringUtils.isBlank((String)((String)value))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void queryAsyncSelectResult(List<String> batchNoList) {
        if (!CollectionUtils.isEmpty(batchNoList)) {
            LqAsyncDeductSelectService asyncDeductSelectService = new LqAsyncDeductSelectService();
            asyncDeductSelectService.queryAsyncSelectResultByBatchNo(batchNoList);
        }
    }
}

