/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.deduction.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.threads.ThreadPools;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.InvoiceDownloadConstant;
import kd.imc.rim.common.constant.RecordedConstant;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.constant.StatisticsStatusEnum;
import kd.imc.rim.common.invoice.deduction.DeductService;
import kd.imc.rim.common.invoice.deduction.DeductStatisticsService;
import kd.imc.rim.common.invoice.deduction.StatisticService;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DeductionUtils;
import kd.imc.rim.common.utils.LqConvertUtil;
import kd.imc.rim.common.utils.MetadataUtil;
import kd.imc.rim.common.utils.ViewUtil;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.tuple.Pair;

public class LqDeductService
extends DeductService {
    private static Log LOGGER = LogFactory.getLog(LqDeductService.class);
    private static final int RECORDED_DEFAULT_SIZE = 100;

    public LqDeductService(Long orgId) {
        this.orgId = orgId;
        int maxSize = InvoiceDownloadConstant.getPageSizeFromConfig(100, "recorded_size_5");
        this.maxSizeRecorded = maxSize <= 0 ? 100 : maxSize;
    }

    @Override
    public JSONObject queryTaxperiod(String taxNo) {
        JSONObject data;
        if (org.apache.commons.lang.StringUtils.isEmpty((String)taxNo)) {
            return null;
        }
        JSONObject param = new JSONObject();
        param.put("nsrsbh", (Object)taxNo);
        param.put("api_type", (Object)"HQDQSKSSQYDQSKSSQTJZT");
        JSONObject result = this.allEPostAppJson(param);
        LOGGER.info("\u4e50\u4f01-\u83b7\u53d6\u5f53\u524d\u6536\u6b3e\u6240\u5c5e\u671f\u4e0e\u5f53\u671f\u7a0e\u6b3e\u6240\u5c5e\u671f\u7edf\u8ba1\u72b6\u6001\uff1a{}-{}", (Object)taxNo, (Object)result);
        if (ResultContant.isSuccess(result).booleanValue() && (data = result.getJSONObject("data")) != null) {
            String skssq = data.getString("skssq");
            data.put("taxPeriod", (Object)skssq);
            if (org.apache.commons.lang.StringUtils.isBlank((String)skssq)) {
                return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u83b7\u53d6\u5f53\u524d\u7a0e\u671f\u5931\u8d25", (String)"LqDeductService_35", (String)"imc-rim-common", (Object[])new Object[0]));
            }
            Date date = DateUtils.stringToDate(skssq, "yyyyMM");
            String format = DateUtils.format(DateUtils.getLastDateOfMonth(date), "yyyyMMdd");
            data.put("gxrqfw", (Object)("20170101-" + format));
        }
        return result;
    }

    @Override
    public JSONObject changeTaxperiod(JSONObject bodyJson) {
        String taxNo = bodyJson.getString("taxNo");
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        String taxPeriod = bodyJson.getString("taxPeriod");
        if (StringUtils.isBlank((CharSequence)taxPeriod)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL.getCode(), ResManager.loadKDString((String)"\u53d8\u66f4\u540e\u7684\u6240\u5c5e\u671f\u4e0d\u80fd\u4e3a\u7a7a", (String)"NewEtaxDeductService_6", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        JSONObject param = new JSONObject();
        param.put("nsrsbh", (Object)taxNo);
        param.put("bgsq", (Object)taxPeriod);
        param.put("api_type", (Object)"SQSKSSQBG");
        JSONObject result = this.allEPostAppJson(param);
        if (result == null) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL.getCode(), ResManager.loadKDString((String)"\u53d8\u66f4\u7a0e\u6b3e\u6240\u5c5e\u671f\u5931\u8d25\u3002", (String)"LqDeductService_42", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        if (!ResultContant.isSuccess(result).booleanValue()) {
            return result;
        }
        JSONObject data = result.getJSONObject("data");
        if (data == null) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL.getCode(), ResManager.loadKDString((String)"\u53d8\u66f4\u7a0e\u6b3e\u6240\u5c5e\u671f\u5931\u8d25\u3002", (String)"LqDeductService_42", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        String sfbgcg = data.getString("sfbgcg");
        if (!"01".equals(sfbgcg)) {
            String errormsg = data.getString("errormsg");
            if (kd.imc.rim.common.utils.StringUtils.isBlank((CharSequence)errormsg)) {
                errormsg = ResManager.loadKDString((String)"\u53d8\u66f4\u7a0e\u6b3e\u6240\u5c5e\u671f\u5931\u8d25\u3002", (String)"LqDeductService_42", (String)"imc-rim-common", (Object[])new Object[0]);
            }
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL.getCode(), errormsg);
        }
        data.put("skssq", (Object)data.getString("bgsq"));
        CacheHelper.remove("rim_skssq" + taxNo);
        DeductionUtils.setStatisticsStatusCahche(taxNo, "");
        return result;
    }

    @Override
    public JSONObject queryInvoices(JSONObject bodyJson) {
        return ResultContant.createJSONObject(ErrorType.LQ_NONSUPPORT);
    }

    @Override
    public JSONObject getStatisticTable(JSONObject bodyJson) {
        String taxNo = bodyJson.getString("taxNo");
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        return DeductStatisticsService.getLqStatisticsInfo(taxNo, this.orgId);
    }

    @Override
    public JSONObject createStatisticTable(JSONObject bodyJson) {
        if (ObjectUtils.isEmpty((Object)bodyJson)) {
            return ResultContant.createJSONObject(ErrorType.PARAM_NULL);
        }
        String taxNo = bodyJson.getString("taxNo");
        if (org.apache.commons.lang.StringUtils.isBlank((String)taxNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        JSONObject createResult = this.sendStatisticTable(taxNo, "1");
        if (null == createResult) {
            return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u751f\u6210\u7edf\u8ba1\u8868\u5931\u8d25,\u8bf7\u91cd\u65b0\u67e5\u8be2\u7edf\u8ba1\u8868", (String)"LqDeductService_1", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        String batchNo = "";
        String asyncFlag = bodyJson.getString("asyncFlag");
        LOGGER.info("\u4e50\u4f01-\u7533\u8bf7\u62b5\u6263\u7edf\u8ba1\u7ed3\u679c\uff1a{}-{}", (Object)taxNo, (Object)createResult);
        if (ResultContant.isSuccess(createResult).booleanValue()) {
            JSONObject data = createResult.getJSONObject("data");
            if (!ObjectUtils.isEmpty((Object)data)) {
                batchNo = data.getString("pclsh");
            } else {
                return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL.getCode(), ResManager.loadKDString((String)"\u751f\u6210\u7edf\u8ba1\u8868\u8fd4\u56de\u6570\u636edata\u4e3a\u7a7a", (String)"LqDeductService_2", (String)"imc-rim-common", (Object[])new Object[0]));
            }
        }
        return DeductionUtils.setBatchNo2Result(createResult, asyncFlag, batchNo);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public JSONObject cancelStatisticTable(JSONObject bodyJson) {
        JSONObject cancelResult;
        if (ObjectUtils.isEmpty((Object)bodyJson)) {
            return ResultContant.createJSONObject(ErrorType.PARAM_NULL);
        }
        String taxNo = bodyJson.getString("taxNo");
        if (org.apache.commons.lang.StringUtils.isBlank((String)taxNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        String tjbbStatus = bodyJson.getString("tjbbStatus");
        if (org.apache.commons.lang.StringUtils.isEmpty((String)tjbbStatus)) {
            cancelResult = this.queryTaxperiod(taxNo);
            if (!ResultContant.isSuccess(cancelResult).booleanValue()) {
                return cancelResult;
            }
            JSONObject data = cancelResult.getJSONObject("data");
            if (ObjectUtils.isEmpty((Object)data)) return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL.getCode(), ResManager.loadKDString((String)"\u64a4\u9500\u7edf\u8ba1\u8868\u8fd4\u56de\u6570\u636edata\u4e3a\u7a7a", (String)"LqDeductService_4", (String)"imc-rim-common", (Object[])new Object[0]));
            String zt = data.getString("zt");
            if ("1".equals(zt)) {
                tjbbStatus = StatisticsStatusEnum.CREATED_CONFIRM.getCode();
            } else {
                if (!"2".equals(zt)) return ResultContant.createJSONObject("0205", ResManager.loadKDString((String)"\u672a\u7533\u8bf7\u7edf\u8ba1,\u4e0d\u80fd\u64a4\u9500", (String)"LqDeductService_10", (String)"imc-rim-common", (Object[])new Object[0]));
                tjbbStatus = StatisticsStatusEnum.CONFIRMED.getCode();
            }
        }
        if (StatisticsStatusEnum.CONFIRMED.getCode().equals(tjbbStatus)) {
            bodyJson.put("sqbz", (Object)"2");
            cancelResult = this.confirmStatisticTable(bodyJson);
        } else {
            cancelResult = this.sendStatisticTable(taxNo, "2");
        }
        if (null == cancelResult) {
            return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u64a4\u9500\u7edf\u8ba1\u8868\u5931\u8d25,\u8bf7\u91cd\u65b0\u67e5\u8be2\u7edf\u8ba1\u8868", (String)"LqDeductService_3", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        LOGGER.info("\u4e50\u4f01-\u7533\u8bf7\u64a4\u9500\u62b5\u6263\u7edf\u8ba1\u7ed3\u679c\uff1a{}-{}", (Object)taxNo, (Object)cancelResult);
        String batchNo = "";
        String asyncFlag = bodyJson.getString("asyncFlag");
        if (!ResultContant.isSuccess(cancelResult).booleanValue()) return DeductionUtils.setBatchNo2Result(cancelResult, asyncFlag, batchNo);
        JSONObject data = cancelResult.getJSONObject("data");
        if (ObjectUtils.isEmpty((Object)data)) return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL.getCode(), ResManager.loadKDString((String)"\u64a4\u9500\u7edf\u8ba1\u8868\u8fd4\u56de\u6570\u636edata\u4e3a\u7a7a", (String)"LqDeductService_4", (String)"imc-rim-common", (Object[])new Object[0]));
        batchNo = data.getString("pclsh");
        data.put("tjbbStatus", (Object)tjbbStatus);
        return DeductionUtils.setBatchNo2Result(cancelResult, asyncFlag, batchNo);
    }

    private JSONObject sendStatisticTable(String taxNo, String sqbz) {
        JSONObject param = new JSONObject();
        param.put("nsrsbh", (Object)taxNo);
        param.put("sqbz", (Object)sqbz);
        param.put("api_type", (Object)"SQCXDKTJ");
        return this.allEPostAppJson(param);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public JSONObject queryStatisticTable(JSONObject param) {
        JSONArray tjxx;
        boolean allowChangeSsqBySeason;
        boolean isFinish;
        boolean isAllowGxInvoice;
        boolean isAllowQrtj;
        boolean isAllowQxTj;
        String updateTime;
        String createTjbbStatus;
        JSONObject standardData;
        JSONObject data;
        String description;
        String errcode;
        if (org.apache.commons.lang.StringUtils.isEmpty((String)param.getString("batchNo"))) {
            return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u6279\u6b21\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"LqDeductService_5", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        String applyFlag = param.getString("tjbz");
        JSONObject paramJson = new JSONObject();
        paramJson.put("pclsh", (Object)param.getString("batchNo"));
        String taxNo = param.getString("taxNo");
        paramJson.put("nsrsbh", (Object)taxNo);
        paramJson.put("api_type", (Object)"CXTJCLJG");
        JSONObject queryResult = this.allEPostAppJson(paramJson);
        if (queryResult == null) {
            return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u83b7\u53d6\u7edf\u8ba1\u8868\u5931\u8d25", (String)"LqDeductService_6", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        LOGGER.info("\u4e50\u4f01-\u7533\u8bf7\u62b5\u6263\u7edf\u8ba1\u67e5\u8be2\u5904\u7406\u7ed3\u679c\uff1a{}-{}", (Object)taxNo, (Object)queryResult);
        if (ResultContant.isSuccess(queryResult).booleanValue()) {
            ErrorCode errorCode;
            errcode = "0000";
            description = ResManager.loadKDString((String)"\u7edf\u8ba1\u6210\u529f", (String)"LqDeductService_7", (String)"imc-rim-common", (Object[])new Object[0]);
            data = queryResult.getJSONObject("data");
            if (data == null) return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u83b7\u53d6\u7533\u8bf7/\u64a4\u9500\u7edf\u8ba1\u8868\u5931\u8d25\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a", (String)"LqDeductService_15", (String)"imc-rim-common", (Object[])new Object[0]));
            String code = data.getString("code");
            if (!"1".equals(applyFlag)) {
                switch (code) {
                    case "01": {
                        data.put("isFinish", (Object)true);
                        break;
                    }
                    case "03": {
                        queryResult = ResultContant.createJSONObject("0203", ResManager.loadKDString((String)"\u5f53\u671f\u5df2\u786e\u8ba4,\u4e0d\u53ef\u7edf\u8ba1", (String)"LqDeductService_8", (String)"imc-rim-common", (Object[])new Object[0]));
                        break;
                    }
                    case "04": {
                        queryResult = ResultContant.createJSONObject("0204", ResManager.loadKDString((String)"\u7a0e\u53f7\u4e0d\u5b58\u5728", (String)"LqDeductService_9", (String)"imc-rim-common", (Object[])new Object[0]));
                        break;
                    }
                    case "05": {
                        queryResult = ResultContant.createJSONObject("0205", ResManager.loadKDString((String)"\u672a\u7533\u8bf7\u7edf\u8ba1,\u4e0d\u80fd\u64a4\u9500", (String)"LqDeductService_10", (String)"imc-rim-common", (Object[])new Object[0]));
                        break;
                    }
                    case "06": {
                        queryResult = ResultContant.createJSONObject("0205", ResManager.loadKDString((String)"\u5df2\u7533\u62a5,\u4e0d\u80fd\u64a4\u9500\u7edf\u8ba1", (String)"LqDeductService_11", (String)"imc-rim-common", (Object[])new Object[0]));
                        break;
                    }
                    case "10": {
                        queryResult = ResultContant.createJSONObject("0205", ResManager.loadKDString((String)"\u5df2\u786e\u8ba4\u7edf\u8ba1,\u4e0d\u80fd\u64a4\u9500", (String)"LqDeductService_12", (String)"imc-rim-common", (Object[])new Object[0]));
                        break;
                    }
                    case "12": {
                        queryResult = ResultContant.createJSONObject("0212", ResManager.loadKDString((String)"\u5904\u7406\u5931\u8d25\uff0c\u65e0\u6743\u9650\u8c03\u7528\u6b64\u63a5\u53e3", (String)"LqDeductService_29", (String)"imc-rim-common", (Object[])new Object[0]));
                        break;
                    }
                    default: {
                        queryResult = ResultContant.createJSONObject("0299", ResManager.loadKDString((String)"\u5176\u4ed6\u5f02\u5e38", (String)"LqDeductService_13", (String)"imc-rim-common", (Object[])new Object[0]));
                    }
                }
                ErrorCode errorCode2 = CommonUtils.getCustomErrorCode("lq_statistics_query", code);
                if (errorCode2 == null) return queryResult;
                return ResultContant.createJSONObject(errorCode2.getCode(), errorCode2.getMessage());
            }
            standardData = new JSONObject();
            String taxPeriod = data.getString("skssq");
            standardData.put("taxPeriod", (Object)taxPeriod);
            standardData.put("applyTime", (Object)data.getString("tjsj"));
            createTjbbStatus = "";
            updateTime = "";
            isAllowQxTj = true;
            isAllowQrtj = false;
            isAllowGxInvoice = true;
            isFinish = true;
            allowChangeSsqBySeason = false;
            switch (code) {
                case "01": {
                    createTjbbStatus = StatisticsStatusEnum.CREATED_CONFIRM.getCode();
                    isAllowQrtj = true;
                    isAllowGxInvoice = false;
                    String curTaxPeriod = DateUtils.format(new Date(), "yyyyMM");
                    if (!taxPeriod.equals(curTaxPeriod)) break;
                    createTjbbStatus = StatisticsStatusEnum.PRE_CREATED.getCode();
                    isAllowQrtj = false;
                    isAllowGxInvoice = false;
                    break;
                }
                case "02": {
                    errcode = "0202";
                    description = ResManager.loadKDString((String)"\u91cd\u590d\u7533\u8bf7\u7edf\u8ba1", (String)"LqDeductService_14", (String)"imc-rim-common", (Object[])new Object[0]);
                    break;
                }
                case "03": {
                    errcode = "0203";
                    description = ResManager.loadKDString((String)"\u5f53\u671f\u5df2\u786e\u8ba4,\u4e0d\u53ef\u7edf\u8ba1", (String)"LqDeductService_8", (String)"imc-rim-common", (Object[])new Object[0]);
                    break;
                }
                case "04": {
                    errcode = "0204";
                    description = ResManager.loadKDString((String)"\u7a0e\u53f7\u4e0d\u5b58\u5728", (String)"LqDeductService_9", (String)"imc-rim-common", (Object[])new Object[0]);
                    break;
                }
                case "11": {
                    errcode = "0211";
                    description = ResManager.loadKDString((String)"\u5904\u7406\u5931\u8d25\uff0c\u5b58\u5728\u5f02\u5e38\u6570\u636e", (String)"LqDeductService_28", (String)"imc-rim-common", (Object[])new Object[0]);
                    break;
                }
                case "12": {
                    errcode = "0212";
                    description = ResManager.loadKDString((String)"\u5904\u7406\u5931\u8d25\uff0c\u65e0\u6743\u9650\u8c03\u7528\u6b64\u63a5\u53e3", (String)"LqDeductService_29", (String)"imc-rim-common", (Object[])new Object[0]);
                    break;
                }
                case "13": {
                    errcode = "0213";
                    description = ResManager.loadKDString((String)"\u5904\u7406\u5931\u8d25\uff0c\u6c47\u603b\u7eb3\u7a0e\u4eba\u673a\u6784\u6e05\u5355\u53d8\u5316\u9700\u91cd\u65b0\u786e\u8ba4", (String)"LqDeductService_30", (String)"imc-rim-common", (Object[])new Object[0]);
                    break;
                }
                default: {
                    errcode = "0299";
                    description = ResManager.loadKDString((String)"\u5176\u4ed6\u5f02\u5e38", (String)"LqDeductService_13", (String)"imc-rim-common", (Object[])new Object[0]);
                }
            }
            if ((errorCode = CommonUtils.getCustomErrorCode("lq_statistics_query", code)) != null) {
                errcode = errorCode.getCode();
                description = errorCode.getMessage();
            }
            tjxx = new JSONArray();
            JSONArray tjjg = data.getJSONArray("tjjg");
            if (!CollectionUtils.isEmpty((Collection)tjjg)) {
                for (int i = 0; i < tjjg.size(); ++i) {
                    JSONObject tjInfo = tjjg.getJSONObject(i);
                    String fplx = tjInfo.getString("fplx");
                    String invoiceType = this.convertInvoiceType(fplx);
                    if (invoiceType == null) continue;
                    JSONObject statistJson = StatisticService.getStatistJson(invoiceType);
                    statistJson.put("deductibleNum", (Object)tjInfo.getIntValue("hjfs"));
                    statistJson.put("deductibleAmount", (Object)tjInfo.getBigDecimal("hjyxdkse"));
                    tjxx.add((Object)statistJson);
                }
            }
            if (CollectionUtils.isEmpty((Collection)tjxx) && "01".equals(code)) {
                tjxx = DeductStatisticsService.createStatistics(taxPeriod, taxNo);
            }
        } else {
            if (!CommonUtils.isMatchErrcodes(queryResult, ErrorType.STATUS_HANDLING.getCode(), ErrorType.STATUS_TIMEOUT.getCode(), ErrorType.LQ_SERVICE_ERROR_6099.getCode())) return queryResult;
            JSONObject data2 = new JSONObject();
            data2.put("isFinish", (Object)false);
            return ResultContant.createSuccessJSONObject(data2);
        }
        standardData.put("tjxx", (Object)tjxx);
        standardData.put("tjInfoArr", (Object)tjxx);
        standardData.put("createTjbbStatus", (Object)createTjbbStatus);
        standardData.put("isFinish", (Object)isFinish);
        standardData.put("allowChangeSsqBySeason", (Object)allowChangeSsqBySeason);
        standardData.put("isAllowQxTj", (Object)isAllowQxTj);
        standardData.put("isAllowQrtj", (Object)isAllowQrtj);
        standardData.put("isAllowGxInvoice", (Object)isAllowGxInvoice);
        standardData.put("updateTime", (Object)updateTime);
        standardData.put("message", (Object)this.getMsgFromStatisticQuery(data));
        queryResult.put("errcode", (Object)errcode);
        queryResult.put("description", (Object)description);
        queryResult.put("data", (Object)standardData);
        return queryResult;
    }

    private String getMsgFromStatisticQuery(JSONObject data) {
        JSONArray hgjksycxx;
        String msg;
        int i;
        if (data == null) {
            return null;
        }
        StringBuilder message = new StringBuilder();
        JSONArray fpycxx = data.getJSONArray("fpycxx");
        if (!CollectionUtils.isEmpty((Collection)fpycxx)) {
            JSONArray updateInvoices = new JSONArray();
            for (i = 0; i < fpycxx.size(); ++i) {
                JSONObject invoice = fpycxx.getJSONObject(i);
                msg = String.format(ResManager.loadKDString((String)"\u53d1\u7968\uff1a%1$s\u72b6\u6001\u5f02\u5e38\uff0c\u8bf7\u64a4\u9500\u52fe\u9009\u3002", (String)"LqDeductService_31", (String)"imc-rim-common", (Object[])new Object[0]), CommonUtils.getInvoiceCodeNoGroup(invoice.getString("fpdm"), invoice.getString("fphm")));
                message.append(msg).append(ViewUtil.LINE_SEPARATOR);
                JSONObject newJson = new JSONObject();
                newJson.put("invoiceType", (Object)InputInvoiceTypeEnum.getAwsTypeByLqType(invoice.getString("fplx")));
                newJson.put("invoiceCode", (Object)invoice.getString("fpdm"));
                newJson.put("invoiceNo", (Object)invoice.getString("fphm"));
                newJson.put("invoiceDate", (Object)invoice.getString("kprq"));
                newJson.put("invoiceStatus", (Object)LqConvertUtil.getInvoiceStatus(invoice.getString("fpzt"), invoice.getString("sdzt")));
                newJson.put("invoiceRiskLevel", (Object)LqConvertUtil.getRiskLevel(invoice.getString("sfycpz")));
                updateInvoices.add((Object)newJson);
            }
            ThreadPools.executeOnceIncludeRequestContext((String)"AsyncStatisticsUpdateinvoiceRun", () -> DeductStatisticsService.updateInvoiceStatus(updateInvoices, "", this.orgId));
        }
        if (!CollectionUtils.isEmpty((Collection)(hgjksycxx = data.getJSONArray("hgjksycxx")))) {
            for (i = 0; i < hgjksycxx.size(); ++i) {
                JSONObject hgjks = hgjksycxx.getJSONObject(i);
                msg = String.format(ResManager.loadKDString((String)"\u6d77\u5173\u7f34\u6b3e\u4e66\uff1a%1$s\u72b6\u6001\u5f02\u5e38\uff0c\u8bf7\u64a4\u9500\u52fe\u9009\u3002", (String)"LqDeductService_32", (String)"imc-rim-common", (Object[])new Object[0]), hgjks.getString("jkshm"));
                message.append(msg).append(ViewUtil.LINE_SEPARATOR);
            }
        }
        return message.toString();
    }

    private String convertInvoiceType(String lqType) {
        String type = null;
        if (org.apache.commons.lang.StringUtils.isNotEmpty((String)lqType)) {
            switch (lqType) {
                case "0": {
                    type = InputInvoiceTypeEnum.SPECIAL_PAPER.getAwsType();
                    break;
                }
                case "3": {
                    type = InputInvoiceTypeEnum.TOLL_ELECTRON.getAwsType();
                    break;
                }
                case "5": {
                    type = InputInvoiceTypeEnum.MOTOR_INVOICE.getAwsType();
                    break;
                }
                case "6": {
                    type = InputInvoiceTypeEnum.HGJKS.getAwsType();
                    break;
                }
            }
        }
        return type;
    }

    @Override
    public JSONObject confirmStatisticTable(JSONObject paramJson) {
        if (ObjectUtils.isEmpty((Object)paramJson)) {
            return ResultContant.createJSONObject(ErrorType.PARAM_NULL);
        }
        String taxNo = paramJson.getString("taxNo");
        if (org.apache.commons.lang.StringUtils.isBlank((String)taxNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        String sqbz = Optional.ofNullable(paramJson.getString("sqbz")).filter(org.apache.commons.lang.StringUtils::isNotEmpty).orElse("1");
        JSONObject result = this.sendConfirmStatisticTable(taxNo, sqbz);
        if (result == null) {
            return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u786e\u8ba4\u7edf\u8ba1\u8868\u5931\u8d25", (String)"LqDeductService_16", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        LOGGER.info("\u786e\u8ba4\u7edf\u8ba1\u8868\u7ed3\u679c:{}-{}", (Object)taxNo, (Object)result);
        String batchNo = "";
        String asyncFlag = paramJson.getString("asyncFlag");
        if (ResultContant.isSuccess(result).booleanValue()) {
            JSONObject data = result.getJSONObject("data");
            if (ObjectUtils.isEmpty((Object)data)) {
                return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL.getCode(), ResManager.loadKDString((String)"\u786e\u8ba4\u7edf\u8ba1\u8868\u8fd4\u56de\u6570\u636edata\u4e3a\u7a7a", (String)"LqDeductService_17", (String)"imc-rim-common", (Object[])new Object[0]));
            }
            batchNo = data.getString("pclsh");
        }
        return DeductionUtils.setBatchNo2Result(result, asyncFlag, batchNo);
    }

    private JSONObject sendConfirmStatisticTable(String taxNo, String sqbz) {
        JSONObject param = new JSONObject();
        param.put("nsrsbh", (Object)taxNo);
        param.put("sqbz", (Object)Optional.ofNullable(sqbz).orElse("1"));
        param.put("api_type", (Object)"SQQRDKTJ");
        JSONObject result = this.allEPostAppJson(param);
        LOGGER.info("\u4e50\u4f01-\u7533\u8bf7\u786e\u8ba4\u62b5\u6263\u7edf\u8ba1\uff1a{}", (Object)result);
        return result;
    }

    @Override
    public JSONObject queryConfirmStatisticTable(JSONObject param) {
        if (org.apache.commons.lang.StringUtils.isEmpty((String)param.getString("batchNo"))) {
            return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u6279\u6b21\u6d41\u6c34\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"LqDeductService_18", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        JSONObject paramJson = new JSONObject();
        paramJson.put("nsrsbh", (Object)param.getString("taxNo"));
        paramJson.put("pclsh", (Object)param.getString("batchNo"));
        paramJson.put("api_type", (Object)"CXQRTJCLJG");
        JSONObject queryResult = this.allEPostAppJson(paramJson);
        LOGGER.info("\u4e50\u4f01-\u67e5\u8be2\u786e\u8ba4\u62b5\u6263\u7edf\u8ba1\u5904\u7406\u7ed3\u679c\uff1a{}-{}", (Object)param.getString("taxNo"), (Object)queryResult);
        if (ResultContant.isSuccess(queryResult).booleanValue()) {
            JSONObject data = queryResult.getJSONObject("data");
            if (!ObjectUtils.isEmpty((Object)data)) {
                String jgzt = data.getString("jgzt");
                if (org.apache.commons.lang.StringUtils.isEmpty((String)jgzt)) {
                    return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u8fd4\u56de\u7edf\u8ba1\u72b6\u6001\u4e3a\u7a7a", (String)"LqDeductService_19", (String)"imc-rim-common", (Object[])new Object[0]));
                }
                if ("01".equals(jgzt)) {
                    data.put("isFinish", (Object)true);
                    return queryResult;
                }
                switch (jgzt) {
                    case "07": {
                        queryResult = ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u786e\u8ba4\u5931\u8d25,\u672a\u7533\u8bf7\u7edf\u8ba1", (String)"LqDeductService_20", (String)"imc-rim-common", (Object[])new Object[0]));
                        break;
                    }
                    case "08": {
                        queryResult = ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u786e\u8ba4\u5931\u8d25,\u4e0d\u80fd\u91cd\u590d\u786e\u8ba4", (String)"LqDeductService_21", (String)"imc-rim-common", (Object[])new Object[0]));
                        break;
                    }
                    case "04": {
                        queryResult = ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u7a0e\u53f7\u4e0d\u5b58\u5728", (String)"LqDeductService_9", (String)"imc-rim-common", (Object[])new Object[0]));
                        break;
                    }
                    case "09": {
                        queryResult = ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u4e0d\u7b26\u5408\u786e\u8ba4\u6761\u4ef6(\u5f53\u524d\u6708\u4e0e\u5c5e\u671f\u76f8\u7b49\u65f6)", (String)"LqDeductService_22", (String)"imc-rim-common", (Object[])new Object[0]));
                        break;
                    }
                    case "10": {
                        queryResult = ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u5df2\u786e\u8ba4\u7edf \u8ba1\u4e0d\u80fd\u64a4\u9500", (String)"LqDeductService_23", (String)"imc-rim-common", (Object[])new Object[0]));
                        break;
                    }
                    case "11": {
                        data.put("message", (Object)this.getMsgFromStatisticQuery(data));
                        queryResult = ResultContant.createJSONObject("0211", ResManager.loadKDString((String)"\u5904\u7406\u5931\u8d25\uff0c\u5b58\u5728\u5f02\u5e38\u6570\u636e", (String)"LqDeductService_28", (String)"imc-rim-common", (Object[])new Object[0]), data);
                        break;
                    }
                    case "12": {
                        queryResult = ResultContant.createJSONObject("0212", ResManager.loadKDString((String)"\u5904\u7406\u5931\u8d25\uff0c\u65e0\u6743\u9650\u8c03\u7528\u6b64\u63a5\u53e3", (String)"LqDeductService_29", (String)"imc-rim-common", (Object[])new Object[0]));
                        break;
                    }
                    case "13": {
                        queryResult = ResultContant.createJSONObject("0213", ResManager.loadKDString((String)"\u5904\u7406\u5931\u8d25\uff0c\u6c47\u603b\u7eb3\u7a0e\u4eba\u673a\u6784\u6e05\u5355\u53d8\u5316\u9700\u91cd\u65b0\u786e\u8ba4", (String)"LqDeductService_30", (String)"imc-rim-common", (Object[])new Object[0]));
                        break;
                    }
                    case "99": {
                        queryResult = ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u5176\u4ed6\u5f02\u5e38", (String)"LqDeductService_13", (String)"imc-rim-common", (Object[])new Object[0]));
                        break;
                    }
                    default: {
                        queryResult = ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u786e\u8ba4\u5931\u8d25", (String)"LqDeductService_24", (String)"imc-rim-common", (Object[])new Object[0]));
                    }
                }
                ErrorCode errorCode = CommonUtils.getCustomErrorCode("lq_statistics_confirm_query", jgzt);
                if (errorCode != null) {
                    queryResult = ResultContant.createJSONObject(errorCode.getCode(), errorCode.getMessage());
                }
            } else {
                queryResult = ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a", (String)"LqDeductService_25", (String)"imc-rim-common", (Object[])new Object[0]));
            }
        } else if (CommonUtils.isMatchErrcodes(queryResult, ErrorType.STATUS_HANDLING.getCode(), ErrorType.STATUS_TIMEOUT.getCode(), ErrorType.LQ_SERVICE_ERROR_6099.getCode())) {
            JSONObject data = new JSONObject();
            data.put("isFinish", (Object)false);
            queryResult = ResultContant.createSuccessJSONObject(data);
        }
        return queryResult;
    }

    @Override
    public JSONObject gxInvoices(JSONObject bodyJson) {
        String billType;
        String taxNo = bodyJson.getString("taxNo");
        if (org.apache.commons.lang.StringUtils.isBlank((String)taxNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        JSONArray invoices = bodyJson.getJSONArray("invoices");
        if (CollectionUtils.isEmpty((Collection)invoices)) {
            return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef", (String)"LqDeductService_27", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        String deductibleMode = bodyJson.getString("deductibleMode");
        if ("-2".equals(deductibleMode)) {
            return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u5f53\u524d\u4e50\u4f01\u901a\u9053\u4e0d\u652f\u6301\u9000\u7a0e\u64a4\u9500\u64cd\u4f5c", (String)"DeductOperateService_75", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
        boolean drawBackApplyFlag = false;
        String gxlxDm = "";
        switch (deductibleMode) {
            case "1": {
                gxlxDm = "01";
                break;
            }
            case "-1": {
                gxlxDm = "02";
                break;
            }
            case "4": {
                gxlxDm = "03";
                break;
            }
            case "-4": {
                gxlxDm = "04";
                break;
            }
            case "2": {
                drawBackApplyFlag = true;
            }
        }
        if (!drawBackApplyFlag) {
            JSONObject taxPeriodRtn = this.queryTaxperiod(taxNo);
            if (!ResultContant.isSuccess(taxPeriodRtn).booleanValue()) {
                if (taxPeriodRtn != null) {
                    return taxPeriodRtn;
                }
                return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u83b7\u53d6\u5f53\u524d\u7a0e\u671f\u5931\u8d25", (String)"LqDeductService_26", (String)"imc-rim-common", (Object[])new Object[0]));
            }
            JSONObject periodData = taxPeriodRtn.getJSONObject("data");
            if (!ObjectUtils.isEmpty((Object)periodData)) {
                bodyJson.put("taxPeriod", (Object)periodData.getString("skssq"));
                String zt = periodData.getString("zt");
                if ("1".equals(zt) || "2".equals(zt)) {
                    return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u5f53\u671f\u5df2\u9501\u5b9a\u52fe\u9009\uff0c\u8bf7\u64a4\u9500\u7edf\u8ba1\u8868\u4e4b\u540e\u518d\u64cd\u4f5c", (String)"LqDeductService_41", (String)"imc-rim-common", (Object[])new Object[0]));
                }
            }
        }
        JSONObject param = new JSONObject();
        param.put("nsrsbh", (Object)taxNo);
        if (!drawBackApplyFlag) {
            param.put("gxlxDm", (Object)gxlxDm);
        }
        if ("1".equals(billType = bodyJson.getString("billType"))) {
            this.gxCustomParam(param, invoices, deductibleMode);
        } else if ("2".equals(billType)) {
            if (drawBackApplyFlag) {
                return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u4e50\u4f01\u901a\u9053\u6682\u4e0d\u652f\u6301\u4ee3\u6263\u4ee3\u7f34\u53d1\u7968\u7684\u9000\u7a0e\u64cd\u4f5c", (String)"LqDeductService_51", (String)"imc-rim-common", (Object[])new Object[0]));
            }
            param.put("kjywrsbh", (Object)taxNo);
            this.gxWithholdingParam(param, invoices, deductibleMode);
        } else {
            this.gxNormalParam(param, invoices, deductibleMode);
        }
        JSONObject result = this.allEPostAppJson(param);
        LOGGER.info("\u4e50\u4f01-\u6279\u91cf\u4e0a\u4f20\u62b5\u6263(\u53d1\u7968\u6216\u6d77\u5173\u7f34\u6b3e\u4e66)\uff1a{}-{}", (Object)taxNo, (Object)result);
        if (result == null) {
            result = ResultContant.createJSONObject(ErrorType.FAIL);
        }
        JSONObject data = result.getJSONObject("data");
        if (ResultContant.isSuccess(result).booleanValue()) {
            data.put("batchNo", (Object)data.getString("pclsh"));
        }
        if (data != null) {
            if ("1".equals(billType)) {
                this.handleCommitFialData(data, drawBackApplyFlag ? "jksmx" : "hgjksmx");
            } else if ("2".equals(billType)) {
                this.handleCommitFialData(data, "dkdjmx");
            } else {
                this.handleCommitFialData(data);
            }
            if (drawBackApplyFlag) {
                JSONArray fail = new JSONArray();
                if (data != null) {
                    fail = data.getJSONArray("fail");
                }
                if (!CollectionUtils.isEmpty((Collection)fail)) {
                    JSONArray checkedInvoiceArray = new JSONArray();
                    for (int j = 0; j < invoices.size(); ++j) {
                        JSONObject invoice = invoices.getJSONObject(j);
                        for (int i = 0; i < fail.size(); ++i) {
                            JSONObject failJson = fail.getJSONObject(i);
                            if (CommonUtils.compareInvoiceCodeNo(failJson, invoice, billType)) continue;
                            checkedInvoiceArray.add((Object)invoice);
                        }
                    }
                    bodyJson.put("invoices", (Object)checkedInvoiceArray);
                }
            }
        }
        return result;
    }

    private void gxWithholdingParam(JSONObject param, JSONArray invoices, String deductibleMode) {
        param.put("api_type", (Object)"PLSCZZSDKDJWSPZDKGX");
        Pair<String, String> deductionPair = DeductionConstant.getDeductionPurpose(deductibleMode);
        JSONArray dkdjmx = new JSONArray();
        for (int i = 0; i < invoices.size(); ++i) {
            JSONObject invoice = invoices.getJSONObject(i);
            JSONObject dkdjpz = new JSONObject();
            dkdjpz.put("dkdjwspzh", (Object)invoice.getString("invoiceNo"));
            dkdjpz.put("bkjnsrsbh", (Object)invoice.getString("salerTaxNo"));
            dkdjpz.put("tfrq", (Object)DateUtils.format(invoice.getDate("invoiceDate"), "yyyyMMdd"));
            if ("2".equals(deductionPair.getRight())) {
                String notDeductibleType = invoice.getString("notDeductibleType");
                dkdjpz.put("bdklx", (Object)notDeductibleType);
                if ("5".equals(notDeductibleType)) {
                    dkdjpz.put("bdkyy", (Object)"\u5176\u4ed6");
                }
            }
            dkdjmx.add((Object)dkdjpz);
        }
        param.put("dkdjmx", (Object)dkdjmx);
    }

    private void gxNormalParam(JSONObject param, JSONArray invoices, String deductibleMode) {
        JSONArray fpmx = new JSONArray();
        Pair<String, String> deductionPurposeMap = DeductionConstant.getDeductionPurpose(deductibleMode);
        String yt = (String)deductionPurposeMap.getRight();
        for (int i = 0; i < invoices.size(); ++i) {
            JSONObject invoice = invoices.getJSONObject(i);
            JSONObject info = new JSONObject();
            this.convertInvoice(invoice, info, yt);
            fpmx.add((Object)info);
        }
        param.put("fpmx", (Object)fpmx);
        String apiType = "PLFPDKGX";
        if ("3".equals(yt)) {
            apiType = "PLFPTSGXQR";
        }
        param.put("api_type", (Object)apiType);
    }

    private void convertInvoice(JSONObject sourceJson, JSONObject tagJson) {
        this.convertInvoice(sourceJson, tagJson, "");
    }

    private void convertInvoice11(JSONObject sourceJson, JSONObject tagJson, String deductionPurpose) {
    }

    private void convertInvoice(JSONObject sourceJson, JSONObject tagJson, String deductionPurpose) {
        if (sourceJson == null || tagJson == null) {
            return;
        }
        tagJson.put("serialNo", (Object)sourceJson.getString("serialNo"));
        tagJson.put("kprq", (Object)DateUtils.format(sourceJson.getDate("invoiceDate"), "yyyyMMdd"));
        tagJson.put("fpdm", (Object)sourceJson.getString("invoiceCode"));
        tagJson.put("fphm", (Object)sourceJson.getString("invoiceNo"));
        String awsInvoiceType = sourceJson.getString("invoiceType");
        String fplx = InputInvoiceTypeEnum.getLqInvoiceType(awsInvoiceType);
        String etaxInvoiceNo = sourceJson.getString("etaxInvoiceNo");
        if (org.apache.commons.lang.StringUtils.isNotEmpty((String)etaxInvoiceNo)) {
            if ("03".equals(fplx)) {
                fplx = "87";
                tagJson.remove((Object)"fpdm");
                tagJson.put("fphm", (Object)etaxInvoiceNo);
            } else if ("01".equals(fplx)) {
                fplx = "85";
                tagJson.remove((Object)"fpdm");
                tagJson.put("fphm", (Object)etaxInvoiceNo);
            } else if ("04".equals(fplx)) {
                fplx = "86";
                tagJson.remove((Object)"fpdm");
                tagJson.put("fphm", (Object)etaxInvoiceNo);
            } else if ("15".equals(fplx)) {
                fplx = "88";
                tagJson.remove((Object)"fpdm");
                tagJson.put("fphm", (Object)etaxInvoiceNo);
            }
        }
        tagJson.put("fplx", (Object)fplx);
        if ("2".equals(deductionPurpose)) {
            String notDeductibleType = sourceJson.getString("notDeductibleType");
            tagJson.put("bdklx", (Object)notDeductibleType);
            if ("5".equals(notDeductibleType)) {
                tagJson.put("bdkyy", (Object)"\u5176\u4ed6");
            }
        }
    }

    private void gxCustomParam(JSONObject param, JSONArray invoices, String deductibleMode) {
        JSONArray fpmx = new JSONArray();
        Pair<String, String> deductionPurposeMap = DeductionConstant.getDeductionPurpose(deductibleMode);
        String yt = (String)deductionPurposeMap.getRight();
        for (int i = 0; i < invoices.size(); ++i) {
            JSONObject invoice = invoices.getJSONObject(i);
            JSONObject info = new JSONObject();
            info.put("jkshm", (Object)invoice.getString("invoiceNo"));
            info.put("tfrq", (Object)DateUtils.format(invoice.getDate("invoiceDate"), "yyyyMMdd"));
            if ("2".equals(yt)) {
                String notDeductibleType = invoice.getString("notDeductibleType");
                info.put("bdklx", (Object)notDeductibleType);
                if ("5".equals(notDeductibleType)) {
                    info.put("bdkyy", (Object)"\u5176\u4ed6");
                }
            }
            fpmx.add((Object)info);
        }
        String apiType = "PLHGJKSDKGX";
        param.put("hgjksmx", (Object)fpmx);
        if ("3".equals(yt)) {
            param.remove((Object)"hgjksmx");
            param.put("jksmx", (Object)fpmx);
            apiType = "PLHGJKSTSGXQR";
        }
        param.put("api_type", (Object)apiType);
    }

    @Override
    public JSONObject gxInvoicesQuery(JSONObject bodyJson) {
        String taxNo = bodyJson.getString("taxNo");
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        String batchNo = bodyJson.getString("batchNo");
        String billType = bodyJson.getString("billType");
        String deductibleMode = bodyJson.getString("deductibleMode");
        boolean drawBackQueryFlag = "2".equals(deductibleMode);
        JSONObject param = new JSONObject();
        param.put("nsrsbh", (Object)taxNo);
        param.put("pclsh", (Object)batchNo);
        String apiType = "CXFPDKGXCLJG";
        if ("1".equals(billType)) {
            apiType = "CXHGJKSDKGXCLJG";
            if (drawBackQueryFlag) {
                apiType = "CXHGJKSTSGXQRCLJG";
            }
        } else if ("2".equals(billType)) {
            if (drawBackQueryFlag) {
                return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u4e50\u4f01\u901a\u9053\u6682\u4e0d\u652f\u6301\u4ee3\u6263\u4ee3\u7f34\u53d1\u7968\u7684\u9000\u7a0e\u64cd\u4f5c", (String)"LqDeductService_51", (String)"imc-rim-common", (Object[])new Object[0]));
            }
            param.put("kjywrsbh", (Object)taxNo);
            apiType = "CXZZSDKDJWSPZDKGXCLJG";
        } else if (drawBackQueryFlag) {
            apiType = "CXFPTSGXQRCLJG";
        }
        param.put("api_type", (Object)apiType);
        LOGGER.info("\u4e50\u4f01-\u67e5\u8be2\u62b5\u6263\u52fe\u9009\u5904\u7406\u7ed3\u679c(\u53d1\u7968,\u6d77\u5173\u7f34\u6b3e\u4e66,\u4ee3\u6263\u4ee3\u7f34)\u53c2\u6570\uff1a{}-{}", (Object)taxNo, (Object)param);
        JSONObject result = this.allEPostAppJson(param);
        LOGGER.info("\u4e50\u4f01-\u67e5\u8be2\u62b5\u6263\u52fe\u9009\u5904\u7406\u7ed3\u679c(\u53d1\u7968,\u6d77\u5173\u7f34\u6b3e\u4e66,\u4ee3\u6263\u4ee3\u7f34)\uff1a{}-{}", (Object)taxNo, (Object)result);
        if (ResultContant.isSuccess(result).booleanValue()) {
            JSONObject data = result.getJSONObject("data");
            JSONArray success = new JSONArray();
            JSONArray fail = new JSONArray();
            JSONArray handling = new JSONArray();
            JSONArray invoicesData = null;
            invoicesData = "1".equals(billType) ? CommonUtils.getJsonValue((Map<String, Object>)data, JSONArray.class, "hgjksmx", "jksmx") : ("2".equals(billType) ? data.getJSONArray("dkdjmx") : data.getJSONArray("fpmx"));
            if (invoicesData == null) {
                return ResultContant.createJSONObject("2002", ResManager.loadKDString((String)"\u6ca1\u6709\u8fd4\u56de\u53d1\u7968\u660e\u7ec6\u6570\u636e", (String)"LqDeductService_34", (String)"imc-rim-common", (Object[])new Object[0]));
            }
            for (int i = 0; i < invoicesData.size(); ++i) {
                JSONObject invoice = invoicesData.getJSONObject(i);
                JSONObject invoiceParam = new JSONObject();
                if (StringUtils.isNotEmpty((CharSequence)invoice.getString("jkshm"))) {
                    invoiceParam.put("invoiceCode", (Object)"");
                    invoiceParam.put("invoiceNo", invoice.get((Object)"jkshm"));
                } else if (org.apache.commons.lang.StringUtils.isNotBlank((String)invoice.getString("dkdjwspzh"))) {
                    invoiceParam.put("invoiceCode", (Object)invoice.getString("bkjnsrsbh"));
                    invoiceParam.put("invoiceNo", invoice.get((Object)"dkdjwspzh"));
                } else {
                    invoiceParam.put("invoiceCode", invoice.get((Object)"fpdm"));
                    invoiceParam.put("invoiceNo", invoice.get((Object)"fphm"));
                }
                if (org.apache.commons.lang.StringUtils.isNotEmpty((String)invoice.getString("tfrq"))) {
                    invoiceParam.put("invoiceDate", invoice.get((Object)"tfrq"));
                } else {
                    invoiceParam.put("invoiceDate", invoice.get((Object)"kprq"));
                }
                invoiceParam.put("taxPeriod", invoice.get((Object)"skssq"));
                invoiceParam.put("selectDate", invoice.get((Object)"gxsj"));
                String selectResult = "";
                String cljg = invoice.getString("cljg");
                ErrorCode errorCode = CommonUtils.getCustomErrorCode("lq_select_query", cljg);
                if (errorCode != null) {
                    selectResult = errorCode.getCode();
                    invoiceParam.put("description", (Object)errorCode.getMessage());
                } else if ("01".equals(cljg)) {
                    selectResult = "1";
                } else if ("02".equals(cljg)) {
                    selectResult = "2";
                } else if ("03".equals(cljg)) {
                    selectResult = "3";
                    invoiceParam.put("description", (Object)this.getGxErrorMsg(invoice));
                } else if ("04".equals(cljg)) {
                    selectResult = "5";
                } else if ("05".equals(cljg)) {
                    selectResult = "20";
                } else if ("06".equals(cljg)) {
                    selectResult = "1";
                    invoiceParam.remove((Object)"taxPeriod");
                    invoiceParam.remove((Object)"selectDate");
                    String deductionPurpose = LqConvertUtil.getDeductionPurpose(invoice.getString("hxyt"));
                    invoiceParam.put("deductionPurpose", (Object)deductionPurpose);
                } else if ("07".equals(cljg)) {
                    selectResult = "10";
                } else if ("31".equals(cljg)) {
                    selectResult = "34";
                    invoiceParam.put("description", (Object)ResManager.loadKDString((String)"\u5f85\u5904\u7406\u519c\u4ea7\u54c1\u53d1\u7968\u672a\u786e\u8ba4", (String)"LqDeductService_33", (String)"imc-rim-common", (Object[])new Object[0]));
                } else if ("32".equals(cljg)) {
                    selectResult = "34";
                    invoiceParam.put("description", (Object)ResManager.loadKDString((String)"\u4e0d\u5f97\u62b5\u6263\u53ca\u9000\u7a0e\u53d1\u7968", (String)"LqDeductService_50", (String)"imc-rim-common", (Object[])new Object[0]));
                } else if ("99".equals(cljg)) {
                    selectResult = "34";
                    invoiceParam.put("description", (Object)ResManager.loadKDString((String)"\u4e50\u4f01\u7cfb\u7edf\u8fd4\u56de\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7a0e\u5c40\u4eba\u5458\u5904\u7406", (String)"LqDeductService_52", (String)"imc-rim-common", (Object[])new Object[0]));
                } else {
                    selectResult = "34";
                }
                invoiceParam.put("selectResult", (Object)selectResult);
                if ("1".equals(selectResult)) {
                    success.add((Object)invoiceParam);
                } else {
                    fail.add((Object)invoiceParam);
                }
                data.clear();
                data.put("success", (Object)success);
                data.put("fail", (Object)fail);
                data.put("handling", (Object)handling);
            }
        }
        LOGGER.info("LQ-gxInvoicesQuery result :{}-{}", (Object)taxNo, (Object)result);
        return result;
    }

    private String getGxErrorMsg(JSONObject invoice) {
        if (ObjectUtils.isEmpty((Object)invoice)) {
            return null;
        }
        String fpzt = LqConvertUtil.getInvoiceStatus(invoice.getString("fpzt"), invoice.getString("sdzt"));
        if (org.apache.commons.lang.StringUtils.isNotEmpty((String)fpzt) && !"0".equals(fpzt)) {
            return String.format(ResManager.loadKDString((String)"\u53d1\u7968\u72b6\u6001\u5f02\u5e38[%1$s]", (String)"LqDeductService_36", (String)"imc-rim-common", (Object[])new Object[0]), MetadataUtil.getComboItemName((String)"rim_invoice", (String)"invoice_status", (String)fpzt));
        }
        String sfycpz = LqConvertUtil.getRiskLevel(invoice.getString("sfycpz"));
        if (org.apache.commons.lang.StringUtils.isNotEmpty((String)sfycpz) && !"\u6b63\u5e38".equals(sfycpz)) {
            return sfycpz;
        }
        return null;
    }

    @Override
    public JSONObject queryHistoryStatistics(String taxNo, String taxPeriod) {
        return DeductStatisticsService.queryTaxPeriodInvoices(taxNo, taxPeriod);
    }

    @Override
    public JSONObject queryHistoryStatistics(String taxNo, String taxPeriod, boolean queryStatistics) {
        return null;
    }

    @Override
    public JSONObject getDrawbackStatisticTable(JSONObject paramJson) {
        return null;
    }

    @Override
    public JSONObject drawbackStatisticConfirm(JSONObject paramJson) {
        return null;
    }

    @Override
    public JSONObject applyFullInvoice(JSONObject paramJson) {
        return super.applyFullInvoice(paramJson);
    }

    @Override
    public JSONObject downFullInvoice(JSONObject paramJson) {
        return super.downFullInvoice(paramJson);
    }

    public JSONObject quereyCurrDeductInvoices(String taxNo) {
        JSONObject resultDjdj;
        JSONObject resultHgjks;
        JSONArray data = new JSONArray();
        JSONObject resultVat = this.quereyCurrDeductInvoices(taxNo, 0L);
        if (ResultContant.isSuccess(resultVat).booleanValue()) {
            data.addAll((Collection)resultVat.getJSONArray("data"));
        }
        if (ResultContant.isSuccess(resultHgjks = this.quereyCurrDeductInvoices(taxNo, InputInvoiceTypeEnum.HGJKS.getCode())).booleanValue()) {
            data.addAll((Collection)resultHgjks.getJSONArray("data"));
        }
        if (ResultContant.isSuccess(resultDjdj = this.quereyCurrDeductInvoices(taxNo, InputInvoiceTypeEnum.WITHHOLDING.getCode())).booleanValue()) {
            data.addAll((Collection)resultDjdj.getJSONArray("data"));
        }
        return ResultContant.createSuccessJSONObject(data);
    }

    public JSONObject quereyCurrDeductInvoices(String taxNo, Long invoiceType) {
        JSONObject param = new JSONObject();
        param.put("nsrsbh", (Object)taxNo);
        param.put("cxym", (Object)1);
        param.put("api_type", (Object)"HQDQSKSSQFPDKGXCLJG");
        if (InputInvoiceTypeEnum.HGJKS.getCode().equals(invoiceType)) {
            param.put("api_type", (Object)"HQDQSKSSQHGJKSDKGXCLJG");
        } else if (InputInvoiceTypeEnum.WITHHOLDING.getCode().equals(invoiceType)) {
            param.put("kjywrsbh", (Object)taxNo);
            param.put("api_type", (Object)"HQDQSKSSQDKDJWSPZDKGXCLJG");
        }
        JSONObject result = this.allEPostAppJson(param);
        if (result != null && "6904".equals(result.getString("errcode"))) {
            result.put("errcode", (Object)ErrorType.SUCCESS.getCode());
            result.put("data", (Object)new JSONArray());
            return result;
        }
        if (result == null || !ResultContant.isSuccess(result).booleanValue()) {
            return result;
        }
        JSONArray items = new JSONArray();
        JSONObject data = result.getJSONObject("data");
        int pageNum = data.getIntValue("zys");
        if (pageNum == 0) {
            return result;
        }
        JSONArray fpmx = LqConvertUtil.getPeriodInvoices(invoiceType, data);
        if (!CollectionUtils.isEmpty((Collection)fpmx)) {
            items.addAll((Collection)fpmx);
        }
        if (pageNum >= 2) {
            this.downSurplusInvoice(param, pageNum, items, invoiceType);
        }
        result.put("data", (Object)LqConvertUtil.convertPeriodInvoice(items, invoiceType));
        return result;
    }

    private JSONObject downSurplusInvoice(JSONObject param, int pageNum, JSONArray items, Long invoiceType) {
        JSONObject result = null;
        for (int currentPage = 2; currentPage <= pageNum; ++currentPage) {
            JSONObject data;
            JSONArray fpmx;
            param.put("cxym", (Object)currentPage);
            result = this.allEPostAppJson(param);
            if (!ResultContant.isSuccess(result).booleanValue() || CollectionUtils.isEmpty((Collection)(fpmx = LqConvertUtil.getPeriodInvoices(invoiceType, data = result.getJSONObject("data"))))) continue;
            items.addAll((Collection)fpmx);
        }
        return result;
    }

    @Override
    public JSONObject agricInvoiceHandle(JSONObject param) {
        String taxNo = param.getString("taxNo");
        if (org.apache.commons.lang.StringUtils.isBlank((String)taxNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        JSONArray invoices = param.getJSONArray("invoices");
        if (CollectionUtils.isEmpty((Collection)invoices)) {
            return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef", (String)"LqDeductService_27", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        JSONObject lqParam = new JSONObject();
        lqParam.put("gfsbh", (Object)taxNo);
        lqParam.put("nsrsbh", (Object)taxNo);
        lqParam.put("api_type", (Object)"PLSCDCLNCPFPQRQD");
        String deductibleMode = param.getString("deductibleMode");
        String ncplx = "1";
        if ("16".equals(deductibleMode) || "17".equals(deductibleMode)) {
            ncplx = "2";
        }
        lqParam.put("ncplx", (Object)ncplx);
        lqParam.put("gxlxDm", (Object)deductibleMode);
        JSONArray fpmx = new JSONArray();
        for (int i = 0; i < invoices.size(); ++i) {
            JSONObject invoice = invoices.getJSONObject(i);
            JSONObject lqInvoice = new JSONObject();
            this.convertInvoice(invoice, lqInvoice);
            if ("15".equals(deductibleMode)) {
                lqInvoice.put("ncpbfje", invoice.get((Object)"agricPartialAmount"));
            }
            fpmx.add((Object)lqInvoice);
        }
        lqParam.put("fpmx", (Object)fpmx);
        JSONObject result = this.allEPostAppJson(lqParam);
        LOGGER.info("\u4e50\u4f01-\u6279\u91cf\u4e0a\u4f20\u519c\u4ea7\u54c1\u5904\u7406\u8fd4\u56de\u7ed3\u679c\uff1a{}-{}", (Object)taxNo, (Object)result);
        if (ResultContant.isSuccess(result).booleanValue()) {
            JSONObject data = result.getJSONObject("data");
            data.put("batchNo", (Object)data.getString("pclsh"));
        }
        if (result == null) {
            result = ResultContant.createJSONObject(ErrorType.FAIL);
        }
        this.handleCommitFialData(result.getJSONObject("data"));
        return result;
    }

    @Override
    public JSONObject agricInvoiceHandleQuery(JSONObject param) {
        String taxNo = param.getString("taxNo");
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        JSONObject lqParam = new JSONObject();
        lqParam.put("nsrsbh", (Object)param.getString("taxNo"));
        lqParam.put("pclsh", (Object)param.getString("batchNo"));
        lqParam.put("api_type", (Object)"CXPLSCDCLNCPFPQRQDCLJG");
        JSONObject result = this.allEPostAppJson(lqParam);
        LOGGER.info("\u4e50\u4f01-\u67e5\u8be2\u6279\u91cf\u4e0a\u4f20\u519c\u4ea7\u54c1\u5904\u7406\u7ed3\u679c\u8fd4\u56de\u7ed3\u679c\uff1a{}-{}", (Object)taxNo, (Object)result);
        if (ResultContant.isSuccess(result).booleanValue()) {
            JSONObject data = result.getJSONObject("data");
            JSONArray success = new JSONArray();
            JSONArray fail = new JSONArray();
            JSONArray handling = new JSONArray();
            JSONArray invoicesData = data.getJSONArray("fpmx");
            if (invoicesData == null) {
                return ResultContant.createJSONObject("2002", ResManager.loadKDString((String)"\u6ca1\u6709\u8fd4\u56de\u53d1\u7968\u660e\u7ec6\u6570\u636e", (String)"LqDeductService_34", (String)"imc-rim-common", (Object[])new Object[0]));
            }
            for (int i = 0; i < invoicesData.size(); ++i) {
                JSONObject invoice = invoicesData.getJSONObject(i);
                JSONObject invoiceParam = new JSONObject();
                if (StringUtils.isNotEmpty((CharSequence)invoice.getString("jkshm"))) {
                    invoiceParam.put("invoiceCode", (Object)"");
                    invoiceParam.put("invoiceNo", invoice.get((Object)"jkshm"));
                } else if (org.apache.commons.lang.StringUtils.isNotBlank((String)invoice.getString("dkdjwspzh"))) {
                    invoiceParam.put("invoiceCode", (Object)invoice.getString("bkjnsrsbh"));
                    invoiceParam.put("invoiceNo", invoice.get((Object)"dkdjwspzh"));
                } else {
                    invoiceParam.put("invoiceCode", invoice.get((Object)"fpdm"));
                    invoiceParam.put("invoiceNo", invoice.get((Object)"fphm"));
                }
                if (org.apache.commons.lang.StringUtils.isNotEmpty((String)invoice.getString("tfrq"))) {
                    invoiceParam.put("invoiceDate", invoice.get((Object)"tfrq"));
                } else {
                    invoiceParam.put("invoiceDate", invoice.get((Object)"kprq"));
                }
                invoiceParam.put("effectiveTaxAmount", invoice.get((Object)"yxdkse"));
                invoiceParam.put("agricPartialAmount", invoice.get((Object)"ncpbfje"));
                invoiceParam.put("agricPartialTaxAmount", invoice.get((Object)"ncpbfse"));
                String qrsj = invoice.getString("qrsj");
                if (org.apache.commons.lang.StringUtils.isNotEmpty((String)qrsj) && qrsj.indexOf(46) != -1) {
                    qrsj = qrsj.substring(0, qrsj.indexOf(46));
                }
                invoiceParam.put("selectDate", (Object)qrsj);
                String selectResult = "";
                String cljg = invoice.getString("cljg");
                ErrorCode errorCode = CommonUtils.getCustomErrorCode("lq_agric_handle", cljg);
                if (errorCode != null && org.apache.commons.lang.StringUtils.isNotEmpty((String)errorCode.getCode())) {
                    selectResult = errorCode.getCode();
                    invoiceParam.put("description", (Object)errorCode.getMessage());
                } else if ("20".equals(cljg)) {
                    selectResult = "1";
                } else if ("21".equals(cljg)) {
                    selectResult = "38";
                    invoiceParam.put("description", (Object)ResManager.loadKDString((String)"\u975e\u5f85\u5904\u7406\u519c\u4ea7\u54c1\u53d1\u7968", (String)"LqDeductService_37", (String)"imc-rim-common", (Object[])new Object[0]));
                } else if ("22".equals(cljg)) {
                    selectResult = "39";
                    invoiceParam.put("description", (Object)ResManager.loadKDString((String)"\u5df2\u52fe\u9009\u65e0\u6cd5\u8fdb\u884c\u5f85\u5904\u7406\u519c\u4ea7\u54c1\u786e\u8ba4", (String)"LqDeductService_38", (String)"imc-rim-common", (Object[])new Object[0]));
                } else if ("23".equals(cljg)) {
                    selectResult = "40";
                    invoiceParam.put("description", (Object)ResManager.loadKDString((String)"\u672a\u5f55\u5165\u519c\u4ea7\u54c1\u90e8\u5206\u91d1\u989d", (String)"LqDeductService_39", (String)"imc-rim-common", (Object[])new Object[0]));
                } else if ("99".equals(cljg)) {
                    selectResult = "41";
                    invoiceParam.put("description", (Object)ResManager.loadKDString((String)"\u4e50\u4f01\u7cfb\u7edf\u8fd4\u56de\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7a0e\u5c40\u4eba\u5458\u5904\u7406", (String)"LqDeductService_52", (String)"imc-rim-common", (Object[])new Object[0]));
                } else {
                    selectResult = "34";
                }
                invoiceParam.put("selectResult", (Object)selectResult);
                if ("1".equals(selectResult)) {
                    success.add((Object)invoiceParam);
                } else {
                    fail.add((Object)invoiceParam);
                }
                data.clear();
                data.put("success", (Object)success);
                data.put("fail", (Object)fail);
                data.put("handling", (Object)handling);
            }
        }
        return result;
    }

    @Override
    public JSONObject recordedCommit(JSONObject paramJson) {
        LOGGER.info("\u4e50\u4f01-\u53d1\u7968\u5165\u8d26\u7533\u8bf7\uff0c\u521d\u59cb\u53c2\u6570:{}", (Object)paramJson);
        if (null == paramJson) {
            return ResultContant.createJSONObject("0201", ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef", (String)"NewEtaxDeductService_1", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        String taxNo = paramJson.getString("taxNo");
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        JSONArray invoices = paramJson.getJSONArray("invoices");
        if (StringUtils.isBlank((Object)invoices)) {
            return ResultContant.createJSONObject("0201", ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef", (String)"NewEtaxDeductService_1", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        JSONArray convertInvoices = new JSONArray(invoices.size());
        for (int i = 0; i < invoices.size(); ++i) {
            convertInvoices.add((Object)this.createRecordedInvoiceParam(invoices.getJSONObject(i)));
        }
        JSONObject lqParam = new JSONObject();
        lqParam.put("gfsbh", (Object)taxNo);
        lqParam.put("nsrsbh", (Object)taxNo);
        lqParam.put("fpmx", (Object)convertInvoices);
        LOGGER.info("\u4e50\u4f01-\u53d1\u7968\u5165\u8d26\u7533\u8bf7\uff0c\u7533\u8bf7\u53c2\u6570:{}", (Object)lqParam);
        lqParam.put("api_type", (Object)"PLSCRZFP");
        JSONObject result = this.allEPostAppJson(lqParam);
        LOGGER.info("\u4e50\u4f01-\u53d1\u7968\u5165\u8d26\u7533\u8bf7\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}-{}", (Object)taxNo, (Object)result);
        if (result == null) {
            result = ResultContant.createJSONObject(ErrorType.FAIL);
        }
        if (ResultContant.isSuccess(result).booleanValue()) {
            JSONObject data = result.getJSONObject("data");
            data.put("batchNo", (Object)data.getString("pclsh"));
        }
        return result;
    }

    @Override
    public JSONObject queryRecordedCommitResult(JSONObject bodyJson) {
        if (MapUtils.isEmpty((Map)bodyJson)) {
            return ResultContant.createJSONObject("0201", ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef", (String)"NewEtaxDeductService_1", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        String batchNo = bodyJson.getString("batchNo");
        if (StringUtils.isBlank((CharSequence)batchNo)) {
            return ResultContant.createJSONObject(ErrorType.PARAM_NULL);
        }
        String billType = bodyJson.getString("billType");
        String taxNo = bodyJson.getString("taxNo");
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        JSONObject requestParam = new JSONObject();
        requestParam.put("pclsh", (Object)batchNo);
        requestParam.put("nsrsbh", (Object)taxNo);
        if (!"1".equals(billType) && !"2".equals(billType)) {
            requestParam.put("api_type", (Object)"CXFPRZCLJG");
        }
        LOGGER.info("\u4e50\u4f01-\u67e5\u8be2\u53d1\u7968\u5165\u8d26\u7ed3\u679c\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}-{}", (Object)taxNo, (Object)requestParam);
        JSONObject result = this.allEPostAppJson(requestParam);
        LOGGER.info("\u4e50\u4f01-\u67e5\u8be2\u53d1\u7968\u5165\u8d26\u7ed3\u679c\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}-{}", (Object)taxNo, (Object)result);
        if (ResultContant.isSuccess(result).booleanValue()) {
            JSONObject data = result.getJSONObject("data");
            JSONArray success = new JSONArray();
            JSONArray fail = new JSONArray();
            JSONArray handling = new JSONArray();
            JSONArray invoicesData = null;
            invoicesData = "1".equals(billType) ? data.getJSONArray("hgjksmx") : ("2".equals(billType) ? data.getJSONArray("dkdjmx") : data.getJSONArray("fpmx"));
            if (invoicesData == null) {
                return ResultContant.createJSONObject("2002", ResManager.loadKDString((String)"\u6ca1\u6709\u8fd4\u56de\u53d1\u7968\u660e\u7ec6\u6570\u636e", (String)"LqDeductService_34", (String)"imc-rim-common", (Object[])new Object[0]));
            }
            for (int i = 0; i < invoicesData.size(); ++i) {
                JSONObject invoice = invoicesData.getJSONObject(i);
                JSONObject invoiceParam = new JSONObject();
                if (StringUtils.isNotEmpty((CharSequence)invoice.getString("jkshm"))) {
                    invoiceParam.put("invoiceCode", (Object)"");
                    invoiceParam.put("invoiceNo", invoice.get((Object)"jkshm"));
                } else if (org.apache.commons.lang.StringUtils.isNotBlank((String)invoice.getString("dkdjwspzh"))) {
                    invoiceParam.put("invoiceCode", (Object)invoice.getString("bkjnsrsbh"));
                    invoiceParam.put("invoiceNo", invoice.get((Object)"dkdjwspzh"));
                } else {
                    invoiceParam.put("invoiceCode", invoice.get((Object)"fpdm"));
                    invoiceParam.put("invoiceNo", invoice.get((Object)"fphm"));
                }
                if (org.apache.commons.lang.StringUtils.isNotEmpty((String)invoice.getString("tfrq"))) {
                    invoiceParam.put("invoiceDate", invoice.get((Object)"tfrq"));
                } else {
                    invoiceParam.put("invoiceDate", invoice.get((Object)"kprq"));
                }
                if (org.apache.commons.lang.StringUtils.isNotBlank((String)invoice.getString("rzsj"))) {
                    invoiceParam.put("lqTaxRecordedTime", (Object)invoice.getString("rzsj"));
                }
                if (org.apache.commons.lang.StringUtils.isNotBlank((String)invoice.getString("yrzskssq"))) {
                    invoiceParam.put("preTaxRecordedPeriod", (Object)invoice.getString("yrzskssq"));
                }
                invoiceParam.put("invoiceStatus", invoice.get((Object)"fpzt"));
                String selectResult = "";
                String cljg = invoice.getString("cljg");
                String description = "";
                if ("1".equals(cljg)) {
                    selectResult = "1";
                } else if ("2".equals(cljg)) {
                    selectResult = "2";
                    description = ResManager.loadKDString((String)"\u67e5\u65e0\u6b64\u7968", (String)"LqDeductSelectService_1", (String)"imc-rim-common", (Object[])new Object[0]);
                } else if ("3".equals(cljg)) {
                    selectResult = "3";
                    description = ResManager.loadKDString((String)"\u8be5\u7968\u5f02\u5e38\u65e0\u6cd5\u5165\u8d26", (String)"LqDeductSelectService_2", (String)"imc-rim-common", (Object[])new Object[0]);
                } else if ("4".equals(cljg)) {
                    selectResult = "4";
                    description = ResManager.loadKDString((String)"\u91cd\u590d\u5165\u8d26", (String)"LqDeductSelectService_3", (String)"imc-rim-common", (Object[])new Object[0]);
                } else if ("5".equals(cljg)) {
                    selectResult = "34";
                    description = ResManager.loadKDString((String)"\u4e50\u4f01\u7cfb\u7edf\u8fd4\u56de\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7a0e\u5c40\u4eba\u5458\u5904\u7406", (String)"LqDeductService_52", (String)"imc-rim-common", (Object[])new Object[0]);
                } else {
                    selectResult = "34";
                    description = ResManager.loadKDString((String)"\u7a0e\u5c40\u670d\u52a1\u5f02\u5e38", (String)"LqDeductSelectService_4", (String)"imc-rim-common", (Object[])new Object[0]);
                }
                if (org.apache.commons.lang.StringUtils.isNotBlank((String)description)) {
                    invoiceParam.put("description", (Object)description);
                }
                invoiceParam.put("entryResult", (Object)selectResult);
                if ("1".equals(selectResult)) {
                    success.add((Object)invoiceParam);
                } else {
                    fail.add((Object)invoiceParam);
                }
                data.clear();
                data.put("success", (Object)success);
                data.put("fail", (Object)fail);
                data.put("handling", (Object)handling);
            }
        }
        LOGGER.info("LQ-rzInvoicesQuery result :{}-{}", (Object)taxNo, (Object)result);
        if (null == result) {
            return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u67e5\u8be2\u53d1\u7968\u5165\u8d26\u63d0\u4ea4\u7ed3\u679c\uff0c\u8bf7\u6c42\u5931\u8d25", (String)"NewEtaxDeductService_27", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        return result;
    }

    @Override
    public JSONObject checkRecordedInvoiceParam(JSONObject param, String operateType) {
        String etaxInvoiceNo;
        JSONObject checkResult;
        String dateRegError = param.getString("dateRegError");
        String invoiceNo = param.getString("invoiceNo");
        String codeGroup = CommonUtils.getInvoiceCodeNoGroup(param.getString("invoiceCode"), invoiceNo);
        Integer awsInvoiceType = param.getInteger("invoiceType");
        if (!InputInvoiceTypeEnum.isVatType(InputInvoiceTypeEnum.getInvoiceTypeByAwsType(awsInvoiceType != null ? String.valueOf(awsInvoiceType) : "0"))) {
            return ResultContant.createJSONObject("0202", String.format(ResManager.loadKDString((String)"\u53d1\u7968\uff1a%1$s\uff0c\u8be5\u53d1\u7968\u7c7b\u578b\u4e0d\u652f\u6301\u5165\u8d26\u64cd\u4f5c\uff0c\u5f53\u524d\u53ea\u652f\u6301\u589e\u503c\u7a0e\u53d1\u7968\u5165\u8d26", (String)"NewEtaxDeductService_51", (String)"imc-rim-common", (Object[])new Object[0]), codeGroup));
        }
        if ("1".equals(dateRegError)) {
            return ResultContant.createJSONObject("0202", String.format(ResManager.loadKDString((String)"\u53d1\u7968\uff1a%1$s\uff0c\u65e5\u671f\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u5bf9\u7167\u9700\u6c42\u6587\u6863\u68c0\u67e5", (String)"NewEtaxDeductService_52", (String)"imc-rim-common", (Object[])new Object[0]), codeGroup));
        }
        String preTaxRecordedStatus = param.getString("preTaxRecordedStatus");
        if ("11".equals(preTaxRecordedStatus)) {
            return ResultContant.createJSONObject("0202", String.format(ResManager.loadKDString((String)"\u53d1\u7968\uff1a%1$s\uff0c\u5165\u8d26\u5904\u7406\u4e2d\u7684\u53d1\u7968\u4e0d\u80fd\u53d1\u8d77\u5165\u8d26\u7533\u8bf7", (String)"RecordedConstant_9", (String)"imc-rim-common", (Object[])new Object[0]), codeGroup));
        }
        String nextEntryMarkStatus = param.getString("nextEntryMarkStatus");
        String invoiceDateStr = param.getString("invoiceDate");
        Long invoiceType = param.getLong("invoiceType");
        if (kd.imc.rim.common.utils.StringUtils.isBlank((CharSequence)invoiceNo)) {
            return ResultContant.createJSONObject("0202", String.format(ResManager.loadKDString((String)"\u53d1\u7968\uff1a%1$s\uff0c\u53d1\u7968\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a", (String)"RecordedConstant_4", (String)"imc-rim-common", (Object[])new Object[0]), codeGroup));
        }
        if (kd.imc.rim.common.utils.StringUtils.isBlank((CharSequence)invoiceDateStr)) {
            return ResultContant.createJSONObject("0202", String.format(ResManager.loadKDString((String)"\u53d1\u7968\uff1a%1$s\uff0c\u5f00\u7968\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", (String)"RecordedConstant_5", (String)"imc-rim-common", (Object[])new Object[0]), codeGroup));
        }
        if (invoiceType == null) {
            return ResultContant.createJSONObject("0202", String.format(ResManager.loadKDString((String)"\u53d1\u7968\uff1a%1$s\uff0c\u53d1\u7968\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (String)"RecordedConstant_6", (String)"imc-rim-common", (Object[])new Object[0]), codeGroup));
        }
        if (kd.imc.rim.common.utils.StringUtils.isBlank((CharSequence)nextEntryMarkStatus)) {
            return ResultContant.createJSONObject("0202", String.format(ResManager.loadKDString((String)"\u53d1\u7968\uff1a%1$s\uff0c\u7a0e\u5c40\u5165\u8d26\u7528\u9014\u4e0d\u80fd\u4e3a\u7a7a", (String)"RecordedConstant_2", (String)"imc-rim-common", (Object[])new Object[0]), codeGroup));
        }
        if (("02".equals(nextEntryMarkStatus) || "03".equals(nextEntryMarkStatus)) && org.apache.commons.lang.StringUtils.isBlank((String)param.getString("taxRecordedPeriod"))) {
            return ResultContant.createJSONObject("0202", String.format(ResManager.loadKDString((String)"\u53d1\u7968\uff1a%1$s\uff0c\u4e50\u4f01\u901a\u9053\uff0c\u7a0e\u5c40\u5165\u8d26\u5c5e\u671f\u4e0d\u80fd\u4e3a\u7a7a", (String)"RecordedConstant_0", (String)"imc-rim-common", (Object[])new Object[0]), codeGroup));
        }
        if (null != param.get((Object)"taxRecordedPeriod") && kd.imc.rim.common.utils.StringUtils.isNotBlank((CharSequence)invoiceDateStr)) {
            String taxRecordedPeriod = param.getString("taxRecordedPeriod");
            Date invoiceDate = DateUtils.stringToDate(invoiceDateStr, "yyyy-MM-dd HH:mm:ss");
            Date taxRecordedPeriodDate = DateUtils.stringToDate(taxRecordedPeriod, "yyyyMM");
            if (null != invoiceDate && DateUtils.compare(taxRecordedPeriodDate, DateUtils.trunc(DateUtils.getFirstDateOfMonth(invoiceDate))) < 0) {
                return ResultContant.createJSONObject("0202", String.format(ResManager.loadKDString((String)"\u53d1\u7968\uff1a%1$s\uff0c\u53d1\u7968\u7684\u5165\u8d26\u5c5e\u671f\u5c0f\u4e8e\u5f00\u7968\u65e5\u671f", (String)"RecordedConstant_11", (String)"imc-rim-common", (Object[])new Object[0]), codeGroup));
            }
            Date now = new Date();
            if (taxRecordedPeriodDate.compareTo(DateUtils.getFirstDateOfMonth(now)) > 0) {
                return ResultContant.createJSONObject("0202", String.format(ResManager.loadKDString((String)"\u53d1\u7968\uff1a%1$s\u7684\u7a0e\u5c40\u5165\u8d26\u5c5e\u671f\u5927\u4e8e\u5f53\u524d\u6708\u4efd", (String)"RecordedConstant_12", (String)"imc-rim-common", (Object[])new Object[0]), codeGroup));
            }
        }
        if ((checkResult = RecordedConstant.checkEleNo(invoiceNo, etaxInvoiceNo = param.getString("etaxInvoiceNo"), awsInvoiceType, codeGroup)) != null) {
            return checkResult;
        }
        return ResultContant.createSuccessJSONObject();
    }

    @Override
    public JSONObject createRecordedInvoiceParam(JSONObject param) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("kprq", (Object)DateUtils.format(DateUtils.stringToDate(param.getString("invoiceDate"), "yyyy-MM-dd HH:mm:ss"), "yyyyMMdd"));
        jsonObject.put("fpdm", (Object)param.getString("invoiceCode"));
        jsonObject.put("fphm", (Object)param.getString("invoiceNo"));
        jsonObject.put("skssq", (Object)param.getString("taxRecordedPeriod"));
        String nextEntryMarkStatus = param.getString("nextEntryMarkStatus");
        if ("06".equals(nextEntryMarkStatus)) {
            jsonObject.remove((Object)"skssq");
        }
        jsonObject.put("sqgxlx", (Object)nextEntryMarkStatus);
        String awsInvoiceType = String.valueOf(param.getInteger("invoiceType"));
        String fplx = InputInvoiceTypeEnum.getLqInvoiceType(awsInvoiceType);
        String etaxInvoiceNo = param.getString("etaxInvoiceNo");
        if (org.apache.commons.lang.StringUtils.isNotEmpty((String)etaxInvoiceNo)) {
            if ("03".equals(fplx)) {
                fplx = "87";
                jsonObject.remove((Object)"fpdm");
                jsonObject.put("fphm", (Object)etaxInvoiceNo);
            } else if ("01".equals(fplx)) {
                fplx = "85";
                jsonObject.remove((Object)"fpdm");
                jsonObject.put("fphm", (Object)etaxInvoiceNo);
            } else if ("04".equals(fplx)) {
                fplx = "86";
                jsonObject.remove((Object)"fpdm");
                jsonObject.put("fphm", (Object)etaxInvoiceNo);
            } else if ("15".equals(fplx)) {
                fplx = "88";
                jsonObject.remove((Object)"fpdm");
                jsonObject.put("fphm", (Object)etaxInvoiceNo);
            }
        }
        jsonObject.put("fplx", (Object)fplx);
        return jsonObject;
    }

    private void handleCommitFialData(JSONObject data) {
        this.handleCommitFialData(data, "fpmx");
    }

    private void handleCommitFialData(JSONObject data, String fieldKey) {
        if (data == null || org.apache.commons.lang.StringUtils.isEmpty((String)fieldKey)) {
            return;
        }
        JSONArray fail = new JSONArray();
        JSONArray rtnFpmx = data.getJSONArray(fieldKey);
        if (!CollectionUtils.isEmpty((Collection)rtnFpmx)) {
            for (int i = 0; i < rtnFpmx.size(); ++i) {
                JSONObject object = rtnFpmx.getJSONObject(i);
                if ("00".equals(object.getString("sczt"))) continue;
                JSONObject newJson = new JSONObject();
                String invoiceCode = CommonUtils.getJsonValue((Map<String, Object>)object, String.class, "bkjnsrsbh", "fpdm");
                String invoiceNo = CommonUtils.getJsonValue((Map<String, Object>)object, String.class, "jkshm", "fphm", "dkdjwspzh");
                newJson.put("invoiceCode", (Object)invoiceCode);
                newJson.put("invoiceNo", (Object)invoiceNo);
                String kprq = CommonUtils.getJsonValue((Map<String, Object>)object, String.class, "kprq", "tfrq");
                if (org.apache.commons.lang.StringUtils.isNotEmpty((String)kprq) && kprq.indexOf(46) != -1) {
                    kprq = kprq.substring(0, kprq.indexOf(46));
                }
                newJson.put("invoiceDate", (Object)kprq);
                newJson.put("selectResult", (Object)"42");
                newJson.put("description", (Object)object.getString("errormsg"));
                fail.add((Object)newJson);
            }
        }
        data.put("fail", (Object)fail);
    }

    public JSONObject allEPostAppJson(JSONObject param) {
        return LqConvertUtil.invokeService(param, "DeductApiService");
    }
}

