/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.deduction.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.InvoiceDownloadConstant;
import kd.imc.rim.common.constant.RecordedConstant;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.invoice.deduction.DeductService;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.utils.AwsFpyService;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DeductionUtils;
import kd.imc.rim.common.utils.DistinctUtl;
import kd.imc.rim.common.utils.ImcConfigUtil;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.common.utils.RimRetryPostUtil;
import kd.imc.rim.common.utils.RpaConvertUtil;
import kd.imc.rim.common.utils.UUID;
import org.apache.commons.lang3.tuple.Pair;

public class NewEtaxDeductService
extends DeductService {
    private static Log LOGGER = LogFactory.getLog(NewEtaxDeductService.class);
    private static Set<String> HEAD_INVOICE_TYPE = Sets.newHashSet((Object[])new String[]{"1", "2", "3", "4", "12", "15", "26", "27", "28"});
    private static final String SYNC_TYPE_03 = "03";
    private static final String SYNC_TYPE_04 = "04";
    private static final String SYNC_TYPE_08 = "08";
    private static final String SYNC_TYPE_09 = "09";
    private static final int RECORDED_DEFAULT_SIZE = 500;
    private static Set<String> NOT_CUSTOM_FILEDS = Sets.newHashSet((Object[])new String[]{"invoiceType", "invoiceDate", "invoiceAmount", "effectiveTaxAmount", "totalTaxAmount"});
    private static Set<String> CUSTOM_FILEDS = Sets.newHashSet((Object[])new String[]{"customDeclarationNo", "invoiceDate", "effectiveTaxAmount", "totalTaxAmount"});
    private static Set<String> WITHHOLDING_FILEDS = Sets.newHashSet((Object[])new String[]{"voucherNo", "invoiceDate", "invoiceAmount", "effectiveTaxAmount", "totalTaxAmount"});
    private static Set<String> NOT_DEDUCTIBLE_TYPE = Sets.newHashSet((Object[])new String[]{"1", "2", "3", "4", "5"});
    private static Set<String> RECORDED_COMMIT_FILEDS = Sets.newHashSet((Object[])new String[]{"buyerTaxNo", "invoiceType", "invoiceNo", "invoiceDate", "invoiceAmount", "totalTaxAmount", "invoiceStatus", "invoiceRiskLevel", "nextEntryMarkStatus", "salerName", "salerTaxNo"});
    private static Set<String> RECORDED_UPDATE_REVOKE_FILEDS = Sets.newHashSet((Object[])new String[]{"entryMarkStatus", "mxuuid", "rzuuid"});
    protected static final Set<String> COLLECT_ERRCODE = new HashSet<String>(8);

    public NewEtaxDeductService(Long orgId) {
        this.orgId = orgId;
        COLLECT_ERRCODE.addAll(DeductionUtils.getEtaxRetryErrcodes());
        int maxSize = InvoiceDownloadConstant.getPageSizeFromConfig(500, "recorded_size_4");
        this.maxSizeRecorded = maxSize <= 0 ? 500 : maxSize;
    }

    @Override
    public JSONObject login(String taxNo) {
        JSONObject param = new JSONObject();
        param.put("taxNo", (Object)taxNo);
        return this.login(param);
    }

    @Override
    public JSONObject login(String taxNo, String operationKey, AbstractFormPlugin plugin) {
        JSONObject param = new JSONObject();
        param.put("taxNo", (Object)taxNo);
        param.put("fpdkType", (Object)"4");
        JSONObject loginResult = this.login(param);
        if (!ResultContant.isSuccess(loginResult).booleanValue()) {
            return loginResult;
        }
        JSONObject data = loginResult.getJSONObject("data");
        if (this.needOpenLoginPage(data)) {
            data.put("taxNo", (Object)taxNo);
            data.put("account", (Object)param.getString("account"));
            this.showLoginPage(data, plugin, "loginAfter" + operationKey);
            loginResult.put("errcode", (Object)ErrorType.NEED_LOGIN.getCode());
            loginResult.put("description", (Object)ErrorType.NEED_LOGIN.getName());
        }
        return loginResult;
    }

    @Override
    public void showLoginPage(JSONObject param, AbstractFormPlugin plugin, String actionId) {
        AwsFpyService service;
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bdm_tax_login");
        String taxNo = param.getString("taxNo");
        showParameter.setCustomParam("taxNo", (Object)taxNo);
        String allEaccount = param.getString("account");
        if (StringUtils.isEmpty((CharSequence)allEaccount) && StringUtils.isEmpty((CharSequence)(allEaccount = (service = AwsFpyService.newInstance()).getAllEaccount(taxNo)))) {
            throw new MsgException(ErrorType.NEED_LOGIN.getCode(), String.format(ResManager.loadKDString((String)"\u7a0e\u53f7:[%s]\u672a\u67e5\u8be2\u5230\u8d26\u53f7\u4fe1\u606f\uff0c\u8bf7\u524d\u5f80\u57fa\u7840\u8d44\u6599-\u4f01\u4e1a\u7ba1\u7406-\u6570\u7535\u914d\u7f6e\u8fdb\u884c\u76f8\u5173\u914d\u7f6e", (String)"NewEtaxDeductService_0", (String)"imc-rim-common", (Object[])new Object[0]), taxNo));
        }
        String checkAuth = RimConfigUtils.getConfig("rim_deduction", "e_tax_check_auth");
        checkAuth = Optional.ofNullable(checkAuth).filter(StringUtils::isNotEmpty).orElse("0");
        showParameter.setCustomParam("checkAuth", (Object)checkAuth);
        showParameter.setCustomParam("operationType", (Object)"2");
        showParameter.setCustomParam("loginWebUrls", (Object)param.getString("loginWebUrl"));
        showParameter.setCustomParam("longLinkName", (Object)param.getString("longLinkName"));
        showParameter.setCustomParam("account", (Object)allEaccount);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)plugin, actionId);
        showParameter.setCloseCallBack(closeCallBack);
        plugin.getView().showForm(showParameter);
    }

    @Override
    public void clearLoginState(String taxNo) {
        CacheHelper.remove("e_down_login_" + taxNo);
    }

    @Override
    public JSONObject login(JSONObject param) {
        if (param == null) {
            return ResultContant.createJSONObject("0103", ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef", (String)"NewEtaxDeductService_1", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        String taxNo = param.getString("taxNo");
        if (StringUtils.isEmpty((CharSequence)taxNo)) {
            return ResultContant.createJSONObject("0103", ResManager.loadKDString((String)"\u7a0e\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"NewEtaxDeductService_2", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        String unitTestResult = CommonUtils.getUnitTestResult("Aws-", "newtax_login");
        if (StringUtils.isNotEmpty((CharSequence)unitTestResult)) {
            return JSONObject.parseObject((String)unitTestResult);
        }
        String allEaccount = param.getString("account");
        if (StringUtils.isEmpty((CharSequence)allEaccount)) {
            AwsFpyService service = AwsFpyService.newInstance();
            allEaccount = service.getAllEaccount(taxNo);
        }
        if (StringUtils.isEmpty((CharSequence)allEaccount)) {
            return ResultContant.createJSONObject(ErrorType.NEED_LOGIN.getCode(), String.format(ResManager.loadKDString((String)"\u7a0e\u53f7:[%s]\u672a\u67e5\u8be2\u5230\u8d26\u53f7\u4fe1\u606f\uff0c\u8bf7\u524d\u5f80\u57fa\u7840\u8d44\u6599-\u4f01\u4e1a\u7ba1\u7406-\u6570\u7535\u914d\u7f6e\u8fdb\u884c\u76f8\u5173\u914d\u7f6e", (String)"NewEtaxDeductService_0", (String)"imc-rim-common", (Object[])new Object[0]), taxNo));
        }
        param.put("account", (Object)allEaccount);
        String checkAuth = RimConfigUtils.getConfig("rim_deduction", "e_tax_check_auth");
        checkAuth = Optional.ofNullable(checkAuth).filter(StringUtils::isNotEmpty).orElse("0");
        param.put("checkAuth", (Object)checkAuth);
        param.put("operationType", (Object)"2");
        String result = (String)DispatchServiceHelper.invokeBizService((String)"imc", (String)"bdm", (String)"AllEInvoiceInputHelper", (String)"checkLogin", (Object[])new Object[]{param});
        LOGGER.info("\u767b\u5f55\u7ed3\u679c:{},{}", (Object)taxNo, (Object)JSONObject.toJSONString((Object)result));
        if (StringUtils.isBlank((CharSequence)result)) {
            return ResultContant.createJSONObject("0204", ResManager.loadKDString((String)"\u767b\u5f55\u5931\u8d25", (String)"NewEtaxDeductService_3", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        JSONObject resultJson = JSONObject.parseObject((String)result);
        if (ResultContant.isSuccess(resultJson).booleanValue()) {
            JSONObject data = resultJson.getJSONObject("data");
            if (data != null) {
                if (StringUtils.isNotEmpty((CharSequence)data.getString("skssq"))) {
                    DeductionConstant.cacheSkssq(taxNo, data.getString("skssq"));
                }
            } else {
                resultJson.put("errcode", (Object)ErrorType.FAIL.getCode());
                resultJson.put("description", (Object)ResManager.loadKDString((String)"\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a", (String)"NewEtaxDeductService_4", (String)"imc-rim-common", (Object[])new Object[0]));
            }
        }
        if (ResultContant.isSuccess(resultJson).booleanValue()) {
            this.clearLoginState(taxNo);
        }
        return resultJson;
    }

    @Override
    public JSONObject queryTaxperiod(String taxNo) {
        try {
            AwsFpyService service = AwsFpyService.newInstance();
            JSONObject param = new JSONObject();
            DeductionConstant.setUnittestFlag((Map<String, Object>)param);
            param.put("request_path", (Object)"/fpdk/getSkssq");
            param.put("taxNo", (Object)taxNo);
            LOGGER.info("\u540c\u6b65\u83b7\u53d6\u7a0e\u671f\u53c2\u6570:{}", (Object)param);
            JSONObject resultJson = this.allEPostAppJson(service, this.orgId, taxNo, param);
            if (null == resultJson) {
                return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u83b7\u53d6\u62b5\u6263\u7a0e\u671f\u5931\u8d25", (String)"NewEtaxDeductService_5", (String)"imc-rim-common", (Object[])new Object[0]));
            }
            LOGGER.info("\u540c\u6b65\u83b7\u53d6\u7a0e\u671f\u7ed3\u679c\u8fd4\u56de:{}-{}", (Object)taxNo, (Object)resultJson);
            return resultJson;
        }
        catch (Exception e) {
            LOGGER.error("\u540c\u6b65\u83b7\u53d6\u7a0e\u671f\u5931\u8d25:" + taxNo, (Throwable)e);
            return null;
        }
    }

    @Override
    public JSONObject changeTaxperiod(JSONObject bodyJson) {
        String taxNo = bodyJson.getString("taxNo");
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        String taxPeriod = bodyJson.getString("taxPeriod");
        if (StringUtils.isBlank((CharSequence)taxPeriod)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL.getCode(), ResManager.loadKDString((String)"\u53d8\u66f4\u540e\u7684\u6240\u5c5e\u671f\u4e0d\u80fd\u4e3a\u7a7a", (String)"NewEtaxDeductService_6", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        bodyJson.put("Bghskssq", (Object)taxPeriod);
        bodyJson.remove((Object)"taxPeriod");
        DeductionConstant.setUnittestFlag((Map<String, Object>)bodyJson);
        bodyJson.put("request_path", (Object)"/fpdk/taxPeriod");
        AwsFpyService service = AwsFpyService.newInstance();
        JSONObject resultJson = this.allEPostAppJson(service, this.orgId, taxNo, bodyJson);
        if (null == resultJson) {
            return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u53d8\u66f4\u7a0e\u671f\u5931\u8d25", (String)"NewEtaxDeductService_7", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        if (ResultContant.isSuccess(resultJson).booleanValue()) {
            CacheHelper.remove("rim_skssq" + taxNo);
            DeductionUtils.setStatisticsStatusCahche(taxNo, "");
        }
        LOGGER.info("\u53d8\u66f4\u7a0e\u671f\u7ed3\u679c\u8fd4\u56de:{}-{}", (Object)taxNo, (Object)resultJson);
        return resultJson;
    }

    @Override
    public JSONObject queryInvoices(JSONObject bodyJson) {
        List<JSONObject> invoiceList;
        JSONArray dataArray;
        boolean queryDrawback;
        String taxNo = bodyJson.getString("taxNo");
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        DeductionConstant.setUnittestFlag((Map<String, Object>)bodyJson);
        JSONObject searchOpt = bodyJson.getJSONObject("searchOpt");
        if (searchOpt == null) {
            return ResultContant.createJSONObject(ErrorType.PARAM_NULL);
        }
        String asyncFlag = bodyJson.getString("asyncFlag");
        String batchNo = UUID.getBatchNoByTaxNo(taxNo);
        if ("1".equals(asyncFlag)) {
            JSONObject resultJson = ResultContant.createSuccessJSONObject();
            return DeductionUtils.setBatchNo2Result(resultJson, asyncFlag, batchNo);
        }
        String dkType = bodyJson.getString("dkType");
        String billType = bodyJson.getString("billType");
        searchOpt.put("filterByInvoiceDate", (Object)true);
        String invoiceType = searchOpt.getString("invoiceType");
        String authenticateFlags = searchOpt.getString("authenticateFlags");
        String syncType = bodyJson.getString("synctype");
        boolean bl = queryDrawback = !"1".equals(dkType) && (StringUtils.isEmpty((CharSequence)authenticateFlags) || authenticateFlags.contains("1") || authenticateFlags.contains("2"));
        if (StringUtils.isNotEmpty((CharSequence)invoiceType)) {
            JSONArray dataArray2;
            List<JSONObject> invoiceList2;
            JSONObject result = this.queryInvoicesByType(bodyJson, invoiceType, syncType);
            if (!ResultContant.isSuccess(result).booleanValue()) {
                return result;
            }
            if (SYNC_TYPE_04.equals(syncType) && queryDrawback && InputInvoiceTypeEnum.allowDrawbackType(invoiceType)) {
                JSONObject resultDrawback = this.queryInvoicesByType(bodyJson, invoiceType, SYNC_TYPE_08);
                this.addExtInvoice(result, resultDrawback);
            }
            if (result != null && !CollectionUtils.isEmpty((Collection)result.getJSONArray("data")) && !CollectionUtils.isEmpty(invoiceList2 = DistinctUtl.getUniqueJsonObjects((dataArray2 = result.getJSONArray("data")).toJavaList(JSONObject.class), "invoiceNo", "jkshm", "customDeclarationNo", "invoiceCode", "invoiceType"))) {
                result.put("data", (Object)JSONObject.parseArray((String)invoiceList2.toString()));
            }
            return result;
        }
        JSONObject result = this.queryInvoicesByType(bodyJson, invoiceType, syncType);
        if (!ResultContant.isSuccess(result).booleanValue()) {
            return result;
        }
        if (SYNC_TYPE_04.equals(syncType) && queryDrawback) {
            JSONObject resultDrawback = this.queryInvoicesByType(bodyJson, invoiceType, SYNC_TYPE_08);
            this.addExtInvoice(result, resultDrawback);
        }
        if (!"0".equals(billType)) {
            invoiceType = "21";
            searchOpt.put("invoiceType", (Object)invoiceType);
            searchOpt.put("customDeclarationNo", (Object)"");
            bodyJson.put("searchOpt", (Object)searchOpt);
            JSONObject resultHgjks = this.queryInvoicesByType(bodyJson, invoiceType, syncType);
            this.addExtInvoice(result, resultHgjks);
        }
        if (result != null && !CollectionUtils.isEmpty((Collection)result.getJSONArray("data"))) {
            dataArray = result.getJSONArray("data");
            invoiceList = DistinctUtl.getUniqueJsonObjects(dataArray.toJavaList(JSONObject.class), "invoiceNo", "invoiceCode", "invoiceType");
            result.put("data", (Object)invoiceList.toArray());
        }
        if (result != null && !CollectionUtils.isEmpty((Collection)result.getJSONArray("data")) && !CollectionUtils.isEmpty(invoiceList = DistinctUtl.getUniqueJsonObjects((dataArray = result.getJSONArray("data")).toJavaList(JSONObject.class), "invoiceNo", "jkshm", "customDeclarationNo", "invoiceCode", "invoiceType"))) {
            result.put("data", (Object)JSONObject.parseArray((String)invoiceList.toString()));
        }
        return result;
    }

    private void addExtInvoice(JSONObject result, JSONObject extResult) {
        if (result == null) {
            return;
        }
        if (ResultContant.isSuccess(extResult).booleanValue()) {
            JSONArray dataHg = extResult.getJSONArray("data");
            JSONArray data = result.getJSONArray("data");
            if (data == null) {
                data = new JSONArray();
            }
            if (!CollectionUtils.isEmpty((Collection)dataHg)) {
                data.addAll((Collection)dataHg);
            }
            result.put("data", (Object)data);
        }
    }

    private JSONObject queryInvoicesByType(JSONObject bodyJson, String invoiceType, String syncType) {
        boolean isFilter;
        JSONObject resultJson;
        JSONArray invoices;
        String taxNo;
        block24: {
            block23: {
                taxNo = bodyJson.getString("taxNo");
                if (StringUtils.isBlank((CharSequence)taxNo)) {
                    return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
                }
                DeductionConstant.setUnittestFlag((Map<String, Object>)bodyJson);
                bodyJson.put("requestId", (Object)UUID.randomUUID());
                String disableCache = RimConfigUtils.getConfig("rim_deduction", "new_disable_cache");
                if ("1".equals(disableCache)) {
                    bodyJson.put("disableCache", (Object)true);
                }
                boolean isNotQueryPage = "1".equals(bodyJson.getString("notQueryPage"));
                String serialNo = "";
                int dataFromIndex = 0;
                int dataIndex = 0;
                if (isNotQueryPage) {
                    if (StringUtils.isNotBlank((CharSequence)bodyJson.getString("serialNo"))) {
                        serialNo = bodyJson.getString("serialNo");
                    }
                    if (StringUtils.isNotBlank((CharSequence)bodyJson.getString("dataFromIndex"))) {
                        dataFromIndex = bodyJson.getInteger("dataFromIndex");
                    }
                    if (StringUtils.isNotBlank((CharSequence)bodyJson.getString("dataIndex"))) {
                        dataIndex = bodyJson.getInteger("dataIndex");
                    }
                }
                bodyJson.put("serialNo", (Object)serialNo);
                bodyJson.put("dataFromIndex", (Object)dataFromIndex);
                bodyJson.put("dataIndex", (Object)dataIndex);
                bodyJson.put("clientType", (Object)"4");
                bodyJson.put("versionNo", (Object)"");
                bodyJson.put("continueFlag", (Object)Boolean.TRUE);
                AwsFpyService service = AwsFpyService.newInstance();
                invoices = new JSONArray();
                resultJson = null;
                String requestPath = "/fpdk/queryInvoice";
                if ("21".equals(invoiceType)) {
                    requestPath = "/fpdk/customBill/query";
                    if (SYNC_TYPE_03.equals(syncType)) {
                        requestPath = "/fpdk/query/ygxCustomBill";
                    } else if (SYNC_TYPE_08.equals(syncType) || SYNC_TYPE_09.equals(syncType)) {
                        return ResultContant.createSuccessJSONObject(new JSONArray());
                    }
                } else if (SYNC_TYPE_03.equals(syncType)) {
                    requestPath = "/fpdk/query/ygxInvoices";
                } else if (SYNC_TYPE_08.equals(syncType)) {
                    requestPath = "/fpdk/tsgx/queryInvoices";
                } else if (SYNC_TYPE_09.equals(syncType)) {
                    requestPath = "/fpdk/tsyt/ygxInvoices";
                }
                bodyJson.put("request_path", (Object)requestPath);
                while (true) {
                    LOGGER.info("\u4e0b\u8f7d\u53d1\u7968\u53c2\u6570:{}", (Object)bodyJson);
                    resultJson = this.allEPostAppJson(service, this.orgId, taxNo, bodyJson);
                    if (!ResultContant.isSuccess(resultJson).booleanValue()) break block23;
                    JSONArray invoiceArray = resultJson.getJSONArray("data");
                    invoices.addAll((Collection)invoiceArray);
                    String endFlag = resultJson.getString("endFlag");
                    if (!"false".equals(endFlag)) break;
                    resultJson.put("continueFlag", (Object)true);
                    if (!isNotQueryPage) {
                        bodyJson.put("requestId", (Object)UUID.randomUUID());
                        bodyJson.put("serialNo", (Object)resultJson.getString("serialNo"));
                        bodyJson.put("dataFromIndex", resultJson.get((Object)"nextDataFromIndex"));
                        bodyJson.put("dataIndex", resultJson.get((Object)"nextDataIndex"));
                        continue;
                    }
                    break block24;
                    break;
                }
                resultJson.put("continueFlag", (Object)false);
                break block24;
            }
            if (resultJson == null) {
                resultJson = ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u4e0b\u8f7d\u5931\u8d25", (String)"NewEtaxDeductService_8", (String)"imc-rim-common", (Object[])new Object[0]));
            }
        }
        if (null == resultJson) {
            resultJson = ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u83b7\u53d6\u53d1\u7968\u5931\u8d25", (String)"NewEtaxDeductService_9", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        if ("21".equals(invoiceType) && !CollectionUtils.isEmpty((Collection)invoices)) {
            for (int i = 0; i < invoices.size(); ++i) {
                JSONObject obj = invoices.getJSONObject(i);
                obj.put("invoiceNo", obj.get((Object)"customDeclarationNo"));
            }
        }
        boolean bl = isFilter = !CollectionUtils.isEmpty((Collection)invoices) && (SYNC_TYPE_03.equals(syncType) || SYNC_TYPE_09.equals(syncType)) && StringUtils.isNotEmpty((CharSequence)invoiceType) && !"21".equals(invoiceType);
        if (isFilter) {
            invoices.removeIf(s -> {
                JSONObject invoice = JSONObject.parseObject((String)JSONObject.toJSONString((Object)s));
                return !StringUtils.equals((CharSequence)invoiceType, (CharSequence)invoice.getString("invoiceType"));
            });
        }
        resultJson.put("data", (Object)invoices);
        LOGGER.info("\u4e0b\u8f7d\u53d1\u7968\u8fd4\u56de\u7ed3\u679c:{}-{}", (Object)taxNo, (Object)resultJson);
        LOGGER.info("\u4e0b\u8f7d\u53d1\u7968\u8fd4\u56de\u7ed3\u679c:[{}]{},\u4e0b\u8f7d\u6570\u91cf:{}", new Object[]{resultJson.get((Object)"errcode"), resultJson.get((Object)"description"), invoices.size()});
        return resultJson;
    }

    @Override
    public JSONObject getStatisticTable(JSONObject bodyJson) {
        String taxNo = bodyJson.getString("taxNo");
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        String requestId = DeductionConstant.getRequestId(bodyJson);
        bodyJson.put("requestId", (Object)requestId);
        bodyJson.put("request_path", (Object)"/fpdk/dkgx/dqtjcx");
        DeductionConstant.setUnittestFlag((Map<String, Object>)bodyJson);
        String config = RimConfigUtils.getConfig("rim_deduction", "all_tjbb");
        String allTjbb = Optional.ofNullable(config).orElse("1");
        bodyJson.put("allTjbb", (Object)allTjbb);
        LOGGER.info("\u67e5\u8be2\u7edf\u8ba1\u8868\u53c2\u6570:{}", (Object)bodyJson);
        AwsFpyService service = AwsFpyService.newInstance();
        JSONObject resultJson = this.allEPostAppJson(service, this.orgId, taxNo, bodyJson);
        if (null == resultJson) {
            return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u83b7\u53d6\u7edf\u8ba1\u8868\u5931\u8d25", (String)"NewEtaxDeductService_10", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        JSONObject data = resultJson.getJSONObject("data");
        if (data != null) {
            data.put("tjxx", data.get((Object)"tjInfoArr"));
            this.updateCacheTaxperiod(taxNo, resultJson);
        }
        LOGGER.info("\u67e5\u8be2\u7edf\u8ba1\u8868\u8fd4\u56de\u7ed3\u679c:{}-{}", (Object)taxNo, (Object)resultJson);
        return resultJson;
    }

    @Override
    public JSONObject createStatisticTable(JSONObject bodyJson) {
        if (ObjectUtils.isEmpty((Object)bodyJson)) {
            return ResultContant.createJSONObject(ErrorType.PARAM_NULL);
        }
        String taxNo = bodyJson.getString("taxNo");
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        String requestId = DeductionConstant.getRequestId(bodyJson);
        bodyJson.put("requestId", (Object)requestId);
        bodyJson.put("request_path", (Object)"/fpdk/dkgx/scdktjbb");
        DeductionConstant.setUnittestFlag((Map<String, Object>)bodyJson);
        String config = RimConfigUtils.getConfig("rim_deduction", "all_tjbb");
        String allTjbb = Optional.ofNullable(config).orElse("1");
        bodyJson.put("allTjbb", (Object)allTjbb);
        LOGGER.info("\u751f\u6210\u7edf\u8ba1\u8868\u53c2\u6570:{}", (Object)bodyJson);
        String batchNo = UUID.getBatchNoByTaxNo(taxNo);
        String asyncFlag = bodyJson.getString("asyncFlag");
        if ("1".equals(asyncFlag)) {
            JSONObject resultJson = ResultContant.createSuccessJSONObject();
            return DeductionUtils.setBatchNo2Result(resultJson, asyncFlag, batchNo);
        }
        AwsFpyService service = AwsFpyService.newInstance();
        JSONObject resultJson = this.allEPostAppJson(service, this.orgId, taxNo, bodyJson);
        if (null == resultJson) {
            return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u751f\u6210\u7edf\u8ba1\u8868\u5931\u8d25,\u8bf7\u91cd\u65b0\u67e5\u8be2\u7edf\u8ba1\u8868", (String)"NewEtaxDeductService_11", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        JSONObject data = resultJson.getJSONObject("data");
        if (data != null) {
            data.put("tjxx", data.get((Object)"tjInfoArr"));
            this.updateCacheTaxperiod(taxNo, resultJson);
        }
        LOGGER.info("\u751f\u6210\u7edf\u8ba1\u8868\u8fd4\u56de\u7ed3\u679c:{}-{}", (Object)taxNo, (Object)resultJson);
        return DeductionUtils.setBatchNo2Result(resultJson, asyncFlag, batchNo);
    }

    @Override
    public JSONObject cancelStatisticTable(JSONObject bodyJson) {
        if (ObjectUtils.isEmpty((Object)bodyJson)) {
            return ResultContant.createJSONObject(ErrorType.PARAM_NULL);
        }
        String taxNo = bodyJson.getString("taxNo");
        JSONObject resultJson = ResultContant.createSuccessJSONObject();
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        String requestId = DeductionConstant.getRequestId(bodyJson);
        bodyJson.put("requestId", (Object)requestId);
        bodyJson.put("request_path", (Object)"/fpdk/dkgx/qxdktjbb");
        DeductionConstant.setUnittestFlag((Map<String, Object>)bodyJson);
        LOGGER.info("\u53d6\u6d88\u7edf\u8ba1\u8868\u53c2\u6570:{}", (Object)bodyJson);
        String batchNo = UUID.getBatchNoByTaxNo(taxNo);
        String asyncFlag = bodyJson.getString("asyncFlag");
        if ("1".equals(asyncFlag)) {
            return DeductionUtils.setBatchNo2Result(resultJson, asyncFlag, batchNo);
        }
        AwsFpyService service = AwsFpyService.newInstance();
        resultJson = this.allEPostAppJson(service, this.orgId, taxNo, bodyJson);
        if (null == resultJson) {
            return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u64a4\u9500\u7edf\u8ba1\u8868\u5931\u8d25", (String)"NewEtaxDeductService_12", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        LOGGER.info("\u64a4\u9500\u7edf\u8ba1\u8868\u8fd4\u56de\u7ed3\u679c:{}-{}", (Object)taxNo, (Object)resultJson);
        return DeductionUtils.setBatchNo2Result(resultJson, asyncFlag, batchNo);
    }

    @Override
    public JSONObject confirmStatisticTable(JSONObject paramJson) {
        String taxNo = paramJson.getString("taxNo");
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        JSONObject resultJson = ResultContant.createSuccessJSONObject();
        if (StringUtils.isBlank((Object)paramJson)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        String requestId = DeductionConstant.getRequestId(paramJson);
        paramJson.put("requestId", (Object)requestId);
        paramJson.put("request_path", (Object)"/fpdk/dkgx/gxConfirm");
        DeductionConstant.setUnittestFlag((Map<String, Object>)paramJson);
        LOGGER.info("\u786e\u8ba4\u7b7e\u540d\u53c2\u6570:{}", (Object)paramJson);
        String batchNo = UUID.getBatchNoByTaxNo(taxNo);
        String asyncFlag = paramJson.getString("asyncFlag");
        if ("1".equals(asyncFlag)) {
            return DeductionUtils.setBatchNo2Result(resultJson, asyncFlag, batchNo);
        }
        AwsFpyService service = AwsFpyService.newInstance();
        resultJson = this.allEPostAppJson(service, this.orgId, taxNo, paramJson);
        if (null == resultJson) {
            return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u786e\u8ba4\u7edf\u8ba1\u8868\u5931\u8d25", (String)"NewEtaxDeductService_13", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        LOGGER.info("\u7edf\u8ba1\u8868\u786e\u8ba4\u7b7e\u540d\u8fd4\u56de\u7ed3\u679c{}-{}", (Object)taxNo, (Object)resultJson);
        this.updateCacheTaxperiod(taxNo, resultJson);
        return DeductionUtils.setBatchNo2Result(resultJson, asyncFlag, batchNo);
    }

    @Override
    public JSONObject gxInvoices(JSONObject bodyJson) {
        JSONObject data;
        if (null == bodyJson) {
            return ResultContant.createJSONObject("0201", ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef", (String)"NewEtaxDeductService_1", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        String taxNo = bodyJson.getString("taxNo");
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        JSONArray invoices = bodyJson.getJSONArray("invoices");
        if (StringUtils.isBlank((Object)invoices)) {
            return ResultContant.createJSONObject("0201", ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef", (String)"NewEtaxDeductService_1", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        String requestId = DeductionConstant.getRequestId(bodyJson);
        bodyJson.put("requestId", (Object)requestId);
        DeductionConstant.setUnittestFlag((Map<String, Object>)bodyJson);
        LOGGER.info("\u52fe\u9009\u53d1\u7968\u8bf7\u6c42\u53c2\u6570:{}", (Object)bodyJson);
        String asyncFlag = bodyJson.getString("asyncFlag");
        if ("1".equals(asyncFlag)) {
            return this.gxInvoicesAsyn(bodyJson);
        }
        AwsFpyService service = AwsFpyService.newInstance();
        String requestPath = "/fpdk/dkgx/gxInvoices";
        String deductibleMode = bodyJson.getString("deductibleMode");
        Pair<String, String> deductionPurposePair = DeductionConstant.getDeductionPurpose(deductibleMode);
        String authenticateFlag = (String)deductionPurposePair.getLeft();
        String deductionPurpose = (String)deductionPurposePair.getRight();
        if ("2".equals(deductionPurpose)) {
            requestPath = "/fpdk/bdkgx/gxInvoices";
        } else if ("3".equals(deductionPurpose)) {
            requestPath = "/fpdk/tsgx/gxInvoices";
        }
        String billType = bodyJson.getString("billType");
        if ("1".equals(billType)) {
            requestPath = "/fpdk/customBill/dkgx";
            if ("2".equals(deductionPurpose)) {
                requestPath = "/fpdk/customBill/bdkgx";
            } else if ("3".equals(deductionPurpose)) {
                return ResultContant.createJSONObject("0201", ResManager.loadKDString((String)"RPA\u4e0d\u652f\u6301\u6d77\u5173\u7f34\u6b3e\u4e66\u9000\u7a0e\u52fe\u9009", (String)"NewEtaxDeductService_14", (String)"imc-rim-common", (Object[])new Object[0]));
            }
        } else if ("2".equals(billType)) {
            return ResultContant.createJSONObject(ErrorType.DKDJ_NONSUPPORT);
        }
        bodyJson.put("authenticateFlag", (Object)Integer.parseInt(authenticateFlag));
        bodyJson.put("request_path", (Object)requestPath);
        JSONObject resultJson = this.allEPostAppJson(service, this.orgId, taxNo, bodyJson);
        if (null == resultJson) {
            return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u52fe\u9009\u53d1\u7968\u5931\u8d25", (String)"NewEtaxDeductService_15", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        LOGGER.info("\u52fe\u9009\u53d1\u7968\u8fd4\u56de\u7ed3\u679c:{}-{}", (Object)taxNo, (Object)resultJson);
        if ("91300".equals(resultJson.getString("errcode"))) {
            resultJson.remove((Object)"data");
        }
        if ("1".equals(billType) && !ObjectUtils.isEmpty((Object)(data = resultJson.getJSONObject("data")))) {
            this.handleInvoiceNo(data.getJSONArray("success"));
            this.handleInvoiceNo(data.getJSONArray("fail"));
        }
        if (!"3".equals(deductionPurpose)) {
            this.updateCacheTaxperiod(taxNo, resultJson);
        }
        return resultJson;
    }

    @Override
    public JSONObject gxInvoicesAsyn(JSONObject paramJson) {
        JSONObject jsonInvoiceParam;
        JSONObject jsonObject;
        int i;
        if (StringUtils.isBlank((Object)paramJson)) {
            return ResultContant.createJSONObject("0201", ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef", (String)"NewEtaxDeductService_1", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        JSONArray invoices = paramJson.getJSONArray("invoices");
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)invoices)) {
            return ResultContant.createJSONObject("0201", ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef", (String)"NewEtaxDeductService_1", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        String taxNo = paramJson.getString("taxNo");
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        String deductibleMode = paramJson.getString("deductibleMode");
        Pair<String, String> deductionPurposePair = DeductionConstant.getDeductionPurpose(deductibleMode);
        String authenticateFlag = (String)deductionPurposePair.getLeft();
        String deductionPurpose = (String)deductionPurposePair.getRight();
        String billType = paramJson.getString("billType");
        ArrayList<JSONObject> invoiceList = new ArrayList<JSONObject>(1);
        if ("2".equals(billType)) {
            for (i = 0; i < invoices.size(); ++i) {
                jsonObject = invoices.getJSONObject(i);
                jsonInvoiceParam = new JSONObject();
                String voucherNo = jsonObject.getString("voucherNo");
                if (NewEtaxDeductService.checkHaveNullRpa(WITHHOLDING_FILEDS, jsonObject) || !this.checkNotDeductReason(deductibleMode, jsonObject, jsonInvoiceParam, voucherNo)) continue;
                jsonInvoiceParam.put("buyerTaxNo", (Object)taxNo);
                jsonInvoiceParam.put("invoiceDate", (Object)jsonObject.getString("invoiceDate"));
                jsonInvoiceParam.put("voucherNo", (Object)voucherNo);
                jsonInvoiceParam.put("invoiceAmount", (Object)jsonObject.getString("invoiceAmount"));
                jsonInvoiceParam.put("totalTaxAmount", (Object)jsonObject.getString("totalTaxAmount"));
                jsonInvoiceParam.put("effectiveTaxAmount", (Object)jsonObject.getString("effectiveTaxAmount"));
                jsonInvoiceParam.put("withholdingAgentIDNum", (Object)jsonObject.getString("withholdingAgentIDNum"));
                invoiceList.add(jsonInvoiceParam);
            }
        } else if ("1".equals(billType)) {
            for (i = 0; i < invoices.size(); ++i) {
                jsonObject = invoices.getJSONObject(i);
                jsonInvoiceParam = new JSONObject();
                String customDeclarationNo = jsonObject.getString("customDeclarationNo");
                if (NewEtaxDeductService.checkHaveNullRpa(CUSTOM_FILEDS, jsonObject) || !this.checkNotDeductReason(deductibleMode, jsonObject, jsonInvoiceParam, customDeclarationNo)) continue;
                jsonInvoiceParam.put("customDeclarationNo", (Object)customDeclarationNo);
                jsonInvoiceParam.put("invoiceDate", (Object)jsonObject.getString("invoiceDate"));
                jsonInvoiceParam.put("effectiveTaxAmount", (Object)jsonObject.getString("effectiveTaxAmount"));
                jsonInvoiceParam.put("totalTaxAmount", (Object)jsonObject.getString("totalTaxAmount"));
                invoiceList.add(jsonInvoiceParam);
            }
        } else {
            for (i = 0; i < invoices.size(); ++i) {
                jsonObject = invoices.getJSONObject(i);
                jsonInvoiceParam = new JSONObject();
                String invoiceCode = jsonObject.getString("invoiceCode");
                String invoiceNo = jsonObject.getString("invoiceNo");
                if (NewEtaxDeductService.checkHaveNullRpa(NOT_CUSTOM_FILEDS, jsonObject) || !this.checkNotDeductReason(deductibleMode, jsonObject, jsonInvoiceParam, CommonUtils.getInvoiceCodeNoGroup(invoiceCode, invoiceNo))) continue;
                jsonInvoiceParam.put("salerName", (Object)jsonObject.getString("salerName"));
                jsonInvoiceParam.put("salerTaxNo", (Object)jsonObject.getString("salerTaxNo"));
                jsonInvoiceParam.put("invoiceType", (Object)Integer.valueOf(jsonObject.getString("invoiceType")));
                jsonInvoiceParam.put("invoiceCode", (Object)invoiceCode);
                jsonInvoiceParam.put("etaxInvoiceNo", (Object)jsonObject.getString("etaxInvoiceNo"));
                jsonInvoiceParam.put("invoiceNo", (Object)invoiceNo);
                jsonInvoiceParam.put("invoiceDate", (Object)jsonObject.getString("invoiceDate"));
                jsonInvoiceParam.put("invoiceAmount", (Object)jsonObject.getString("invoiceAmount"));
                jsonInvoiceParam.put("effectiveTaxAmount", (Object)jsonObject.getString("effectiveTaxAmount"));
                jsonInvoiceParam.put("totalTaxAmount", (Object)jsonObject.getString("totalTaxAmount"));
                invoiceList.add(jsonInvoiceParam);
            }
        }
        if (org.apache.commons.collections.CollectionUtils.isEmpty(invoiceList)) {
            LOGGER.info("\u4e0d\u5b58\u5728\u6ee1\u8db3\u6761\u4ef6\u8c03\u7528rpa\u5f02\u6b65\u52fe\u9009\u7684\u53d1\u7968\u6570\u636e");
            return ResultContant.createJSONObject("0201", ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u6ee1\u8db3\u6761\u4ef6\u8c03\u7528rpa\u5f02\u6b65\u52fe\u9009\u7684\u53d1\u7968\u6570\u636e", (String)"NewEtaxDeductService_50", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        LOGGER.info("rpa\u5f02\u6b65\u52fe\u9009\u63d0\u4ea4\uff0c\u7533\u8bf7\u53c2\u6570:{}", (Object)paramJson);
        AwsFpyService service = AwsFpyService.newInstance();
        String allEaccount = service.getAllEaccount(taxNo);
        if (StringUtils.isEmpty((CharSequence)allEaccount)) {
            return ResultContant.createJSONObject(ErrorType.NEED_LOGIN.getCode(), String.format(ResManager.loadKDString((String)"\u7a0e\u53f7:[%s]\u672a\u67e5\u8be2\u5230\u8d26\u53f7\u4fe1\u606f\uff0c\u8bf7\u524d\u5f80\u57fa\u7840\u8d44\u6599-\u4f01\u4e1a\u7ba1\u7406-\u6570\u7535\u914d\u7f6e\u8fdb\u884c\u76f8\u5173\u914d\u7f6e", (String)"NewEtaxDeductService_0", (String)"imc-rim-common", (Object[])new Object[0]), taxNo));
        }
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        params.put("reqid", UUID.getReqid());
        params.put("taxNo", taxNo);
        JSONObject body = new JSONObject();
        body.put("account", (Object)allEaccount);
        body.put("authenticateFlag", (Object)Integer.valueOf(authenticateFlag));
        body.put("deductionPurpose", (Object)deductionPurpose);
        body.put("invoices", invoiceList);
        body.put("body_encrypt", (Object)"1");
        String msgType = "msg_etax_duduct_apply";
        if ("1".equals(billType)) {
            msgType = "msg_etax_customs_duduct_apply";
        } else if ("2".equals(billType)) {
            msgType = "msg_etax_withholding_duduct_apply";
        }
        JSONObject resultJson = service.postAppJsonByTenant(msgType, this.orgId, (Map<String, Object>)body, params, taxNo, true);
        if (null == resultJson) {
            return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"rpa\u5f02\u6b65\u52fe\u9009\u63d0\u4ea4\uff0c\u8bf7\u6c42\u5931\u8d25", (String)"NewEtaxDeductService_40", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        LOGGER.info("rpa\u5f02\u6b65\u52fe\u9009\u63d0\u4ea4\uff0c\u8fd4\u56de\u7ed3\u679c:{}-{}", (Object)taxNo, (Object)resultJson);
        this.checkRepeatApply(resultJson, "1");
        return resultJson;
    }

    @Override
    public JSONObject gxInvoicesQuery(JSONObject bodyJson) {
        JSONObject data;
        String taxNo = bodyJson.getString("taxNo");
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        String batchNo = bodyJson.getString("batchNo");
        if (StringUtils.isBlank((CharSequence)batchNo)) {
            return ResultContant.createJSONObject(ErrorType.PARAM_NULL);
        }
        String billType = bodyJson.getString("billType");
        if (StringUtils.isBlank((CharSequence)billType)) {
            return ResultContant.createJSONObject(ErrorType.PARAM_NULL);
        }
        LOGGER.info("\u5f00\u59cb\u67e5\u8be2rpa\u5f02\u6b65\u52fe\u9009\u7ed3\u679c-\u7533\u8bf7\u53c2\u6570:\u6279\u6b21\u53f7{}\uff0c\u7a0e\u53f7\uff0c{}\uff0cbillType\uff1a{}", new Object[]{batchNo, taxNo, billType});
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        params.put("taxNo", taxNo);
        params.put("reqid", UUID.getReqid());
        JSONObject body = new JSONObject();
        body.put("batchNo", (Object)batchNo);
        body.put("body_encrypt", (Object)"1");
        AwsFpyService service = AwsFpyService.newInstance();
        String msgType = "msg_etax_duduct_query";
        if ("1".equals(billType)) {
            msgType = "msg_etax_customs_duduct_query";
        } else if ("2".equals(billType)) {
            msgType = "msg_etax_withholding_duduct_query";
        }
        JSONObject resultJson = service.postAppJsonByTenant(msgType, this.orgId, (Map<String, Object>)body, params, taxNo, true);
        if (null == resultJson) {
            return ResultContant.createJSONObject(ErrorType.ETAX_HANDLING_1.getCode(), ResManager.loadKDString((String)"\u67e5\u8be2rpa\u5f02\u6b65\u52fe\u9009\u7ed3\u679c\uff0c\u8bf7\u6c42\u5931\u8d25", (String)"NewEtaxDeductService_41", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        if (resultJson != null && !ObjectUtils.isEmpty((Object)(data = resultJson.getJSONObject("data")))) {
            JSONArray success = data.getJSONArray("success");
            this.handleTaxPeriod(success, data.getString("taxPeriod"));
            if ("2".equals(billType)) {
                JSONArray fail = data.getJSONArray("fail");
                this.handleSalerTaxNo(success);
                this.handleSalerTaxNo(fail);
            }
        }
        LOGGER.info("\u67e5\u8be2rpa\u5f02\u6b65\u52fe\u9009\u7ed3\u679c\uff0c\u53d1\u7968\u7c7b\u578b\uff1a{}\uff0c \u8fd4\u56de\u7ed3\u679c:{}-{}", new Object[]{billType, taxNo, resultJson});
        return resultJson;
    }

    private void handleSalerTaxNo(JSONArray invoices) {
        if (!CollectionUtils.isEmpty((Collection)invoices)) {
            for (int i = 0; i < invoices.size(); ++i) {
                JSONObject invoice = invoices.getJSONObject(i);
                if (invoice == null) continue;
                String withholdingAgentIDNum = invoice.getString("withholdingAgentIDNum");
                invoice.put("invoiceCode", (Object)withholdingAgentIDNum);
                String voucherNo = invoice.getString("voucherNo");
                invoice.put("invoiceNo", (Object)voucherNo);
            }
        }
    }

    private void handleTaxPeriod(JSONArray invoices, String taxPeriod) {
        if (!CollectionUtils.isEmpty((Collection)invoices) && StringUtils.isNotBlank((CharSequence)taxPeriod)) {
            for (int i = 0; i < invoices.size(); ++i) {
                String taxPeriod1;
                JSONObject invoice = invoices.getJSONObject(i);
                if (invoice == null || StringUtils.isNotBlank((CharSequence)(taxPeriod1 = invoice.getString("taxPeriod")))) continue;
                invoice.put("taxPeriod", (Object)taxPeriod);
            }
        }
    }

    private void handleInvoiceNo(JSONArray invoices) {
        if (!CollectionUtils.isEmpty((Collection)invoices)) {
            for (int i = 0; i < invoices.size(); ++i) {
                String invoiceNo;
                JSONObject invoice = invoices.getJSONObject(i);
                if (invoice == null || !StringUtils.isEmpty((CharSequence)(invoiceNo = invoice.getString("invoiceNo")))) continue;
                invoice.put("invoiceNo", (Object)invoice.getString("customDeclarationNo"));
            }
        }
    }

    @Override
    public JSONObject queryHistoryStatistics(String taxNo, String taxPeriod, String invoiceType) {
        return this.queryHistoryStatistics(taxNo, taxPeriod, invoiceType, SYNC_TYPE_03);
    }

    @Override
    public JSONObject queryHistoryStatistics(String taxNo, String taxPeriod, String invoiceType, String synctype) {
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        JSONObject bodyJson = new JSONObject();
        bodyJson.put("taxNo", (Object)taxNo);
        bodyJson.put("synccondition", (Object)taxPeriod);
        bodyJson.put("currentOrgId", (Object)0);
        bodyJson.put("jksbz", (Object)1);
        bodyJson.put("synctype", (Object)synctype);
        JSONObject searchOpt = new JSONObject();
        Date startTime = DateUtils.stringToDate(taxPeriod, "yyyy-MM");
        searchOpt.put("invoiceType", (Object)invoiceType);
        searchOpt.put("taxPeriod", (Object)DateUtils.format(startTime, "yyyyMM"));
        bodyJson.put("searchOpt", (Object)searchOpt);
        return this.queryInvoices(bodyJson);
    }

    @Override
    public JSONObject queryHistoryStatistics(String taxNo, String taxPeriod, boolean queryStatistics) {
        JSONObject resultJson = null;
        if (queryStatistics && !ResultContant.isSuccess(resultJson = this.queryHistoryStatisticsTable(taxNo, taxPeriod)).booleanValue()) {
            return resultJson;
        }
        JSONObject invoiceResult = this.queryHistoryStatistics(taxNo, taxPeriod);
        if (!ResultContant.isSuccess(invoiceResult).booleanValue()) {
            return invoiceResult;
        }
        if (resultJson != null && invoiceResult != null) {
            JSONObject data = resultJson.getJSONObject("data");
            JSONArray statistics = data.getJSONArray("tjxx");
            if (CollectionUtils.isEmpty((Collection)statistics)) {
                statistics = data.getJSONArray("tjInfoArr");
            }
            invoiceResult.put("tjxx", (Object)statistics);
            invoiceResult.put("tjInfoArr", (Object)statistics);
            invoiceResult.put("tjInfo", data.get((Object)"tjInfo"));
        }
        return invoiceResult;
    }

    @Override
    public JSONObject queryHistoryStatisticsTable(String taxNo, String taxPeriod) {
        JSONObject param = new JSONObject();
        param.put("taxNo", (Object)taxNo);
        param.put("request_path", (Object)"/fpdk/dkgx/wqtjcx");
        param.put("taxPeriod", (Object)taxPeriod.replace("-", ""));
        String config = RimConfigUtils.getConfig("rim_deduction", "all_tjbb");
        String allTjbb = Optional.ofNullable(config).orElse("1");
        param.put("allTjbb", (Object)allTjbb);
        LOGGER.info("\u67e5\u8be2\u5386\u53f2\u7edf\u8ba1\u8868\u53c2\u6570{}", (Object)param);
        AwsFpyService service = AwsFpyService.newInstance();
        JSONObject resultJson = this.allEPostAppJson(service, this.orgId, taxNo, param);
        if (null == resultJson) {
            return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u67e5\u8be2\u5386\u53f2\u7edf\u8ba1\u8868\u5931\u8d25", (String)"NewEtaxDeductService_16", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        LOGGER.info("\u67e5\u8be2\u5386\u53f2\u7edf\u8ba1\u8868\u8fd4\u56de\u7ed3\u679c{}-{}", (Object)taxNo, (Object)resultJson);
        return resultJson;
    }

    @Override
    public JSONObject applyFullInvoice(JSONObject paramJson) {
        String taxNo = paramJson.getString("taxNo");
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return ResultContant.createJSONObject("0201", ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u5f53\u524d\u4f01\u4e1a\u7a0e\u53f7\u8f6f\u8bc1\u4e66\u914d\u7f6e\u662f\u5426\u6b63\u786e", (String)"NewEtaxDeductService_17", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        LOGGER.info("\u7533\u8bf7\u4e0b\u8f7d\u8fdb\u9500\u9879\u53d1\u7968\u53c2\u6570:{}", (Object)paramJson);
        AwsFpyService service = AwsFpyService.newInstance();
        String account = service.getAllEaccount(taxNo);
        if (StringUtils.isEmpty((CharSequence)account)) {
            return ResultContant.createJSONObject(ErrorType.NEED_LOGIN.getCode(), String.format(ResManager.loadKDString((String)"\u7a0e\u53f7:[%s]\u672a\u67e5\u8be2\u5230\u8d26\u53f7\u4fe1\u606f\uff0c\u8bf7\u524d\u5f80\u57fa\u7840\u8d44\u6599-\u4f01\u4e1a\u7ba1\u7406-\u6570\u7535\u914d\u7f6e\u8fdb\u884c\u76f8\u5173\u914d\u7f6e", (String)"NewEtaxDeductService_0", (String)"imc-rim-common", (Object[])new Object[0]), taxNo));
        }
        paramJson.put("account", (Object)account);
        HashMap<String, String> params = new HashMap<String, String>(8);
        params.put("taxNo", taxNo);
        params.put("reqid", UUID.getReqid());
        String msgType = "new_etax_invoice_full_apply";
        if ("1".equals(paramJson.getString("billType"))) {
            msgType = "new_etax_customs_full_apply";
        }
        JSONObject body = new JSONObject();
        body.putAll((Map)paramJson);
        body.remove((Object)"billType");
        body.remove((Object)"startTime");
        body.remove((Object)"endTime");
        body.remove((Object)"syncType");
        body.remove((Object)"serialNo");
        body.remove((Object)"traceId");
        body.remove((Object)"logId");
        body.remove((Object)"invoiceType");
        String msgTypeStr = msgType;
        int retryTime = InvoiceDownloadConstant.getPageSizeFromConfig(3, "all_e_retry_times");
        int sleepTime = InvoiceDownloadConstant.getPageSizeFromConfig(3000, "all_e_sleep_times");
        JSONObject resultJson = RimRetryPostUtil.retryPost(() -> service.postAppJsonByTenant(msgTypeStr, this.orgId, (Map<String, Object>)body, (Map<String, Object>)params, taxNo, true), COLLECT_ERRCODE, (int)retryTime, (int)sleepTime);
        if (null == resultJson) {
            return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u83b7\u53d6\u5168\u91cf\u53d1\u7968\u5931\u8d25", (String)"NewEtaxDeductService_19", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        resultJson.put("account", (Object)account);
        LOGGER.info("\u7533\u8bf7\u4e0b\u8f7d\u8fdb\u9500\u9879\u53d1\u7968\u8fd4\u56de\u7ed3\u679c:{}-{}", (Object)taxNo, (Object)resultJson);
        this.checkRepeatApply(resultJson, "2");
        return resultJson;
    }

    @Override
    public JSONObject downFullInvoice(JSONObject paramJson) {
        JSONArray invoiceArray;
        String msgTypeFinal;
        JSONObject resultJson;
        String taxNo = paramJson.getString("taxNo");
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return ResultContant.createJSONObject("0201", ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u5f53\u524d\u4f01\u4e1a\u7a0e\u53f7\u8f6f\u8bc1\u4e66\u914d\u7f6e\u662f\u5426\u6b63\u786e", (String)"NewEtaxDeductService_17", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        String batchNo = paramJson.getString("batchNo");
        if (StringUtils.isBlank((CharSequence)batchNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL.getCode(), ResManager.loadKDString((String)"\u6279\u6b21\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"NewEtaxDeductService_23", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        paramJson.put("requestId", (Object)UUID.randomUUID());
        LOGGER.info("\u4e0b\u8f7d\u8fdb\u9500\u9879\u53d1\u7968\u53c2\u6570-\u5f02\u6b65:{}", (Object)paramJson);
        String billType = paramJson.getString("billType");
        HashMap<String, String> params = new HashMap<String, String>(8);
        params.put("taxNo", taxNo);
        params.put("reqid", UUID.getReqid());
        AwsFpyService service = AwsFpyService.newInstance();
        int retryTime = InvoiceDownloadConstant.getPageSizeFromConfig(3, "all_e_retry_times");
        int sleepTime = InvoiceDownloadConstant.getPageSizeFromConfig(3000, "all_e_sleep_times");
        String msgType = "new_etax_invoice_full_query";
        if ("1".equals(billType)) {
            msgType = "new_etax_customs_full_query";
        }
        if (null == (resultJson = RimRetryPostUtil.retryPost(() -> this.lambda$downFullInvoice$2(service, msgTypeFinal = msgType, paramJson, params, taxNo), COLLECT_ERRCODE, (int)retryTime, (int)sleepTime))) {
            return ResultContant.createJSONObject(ErrorType.ETAX_HANDLING_1.getCode(), ResManager.loadKDString((String)"\u83b7\u53d6\u5168\u91cf\u53d1\u7968\u5931\u8d25", (String)"NewEtaxDeductService_19", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        if (StringUtils.isNotBlank((Object)resultJson.getJSONArray("data")) && StringUtils.isNotBlank((Object)(invoiceArray = resultJson.getJSONArray("data")))) {
            for (int i = 0; i < invoiceArray.size(); ++i) {
                JSONObject invoice = invoiceArray.getJSONObject(i);
                if (invoice == null || !StringUtils.isNotBlank((CharSequence)invoice.getString("businessType"))) continue;
                invoice.put("specialTypeMark", (Object)RpaConvertUtil.convertSpecialTypeMark(invoice.getString("businessType")));
                invoice.remove((Object)"businessType");
            }
        }
        LOGGER.info("\u65b0\u7535\u5b50\u5e73\u53f0\u5168\u91cf\u53d1\u7968\u4e0b\u8f7d\u7ed3\u679c\u8fd4\u56de-\u5f02\u6b65:{}-{}", (Object)taxNo, (Object)resultJson);
        return resultJson;
    }

    public JSONObject downFullInvoiceSync(JSONObject bodyParam) {
        String taxNo = bodyParam.getString("taxNo");
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return ResultContant.createJSONObject("0201", ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u5f53\u524d\u4f01\u4e1a\u7a0e\u53f7\u8f6f\u8bc1\u4e66\u914d\u7f6e\u662f\u5426\u6b63\u786e", (String)"NewEtaxDeductService_17", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        boolean isCut = "1".equals(RimConfigUtils.getConfig("rim_deduction", "newetax_cut_flag"));
        AwsFpyService service = AwsFpyService.newInstance();
        bodyParam.put("request_path", (Object)"/fpdk/queryFullInvoices");
        bodyParam.put("requestId", (Object)UUID.randomUUID());
        JSONObject searchOpt = bodyParam.getJSONObject("searchOpt");
        if (ObjectUtils.isEmpty((Object)searchOpt)) {
            return ResultContant.createJSONObject("0201", ResManager.loadKDString((String)"\u67e5\u8be2\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"NewEtaxDeductService_18", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        Date startDate = searchOpt.getDate("startTime");
        Date endDate = searchOpt.getDate("endTime");
        String invoiceType = searchOpt.getString("invoiceType");
        if (InputInvoiceTypeEnum.HGJKS.getAwsType().equals(invoiceType)) {
            bodyParam.put("request_path", (Object)"/fpdk/customBill/queryFull");
        }
        int maxDays = InvoiceDownloadConstant.getPageSizeFromConfig(20, "newetax_cut_days");
        int cutNum = InvoiceDownloadConstant.getPageSizeFromConfig(3, "newetax_cut_num");
        if (cutNum > maxDays) {
            cutNum = maxDays;
        }
        long between = DateUtils.daysBetween(endDate, startDate);
        JSONObject resultJson = null;
        if (isCut && between >= (long)maxDays) {
            JSONArray invoices = new JSONArray();
            Map<Date, Date> dateDateMap = DateUtils.cutTimeRange(startDate, endDate, cutNum);
            for (Map.Entry<Date, Date> dateDateEntry : dateDateMap.entrySet()) {
                bodyParam.put("requestId", (Object)UUID.randomUUID());
                searchOpt.put("startTime", (Object)DateUtils.format(dateDateEntry.getKey()));
                searchOpt.put("endTime", (Object)DateUtils.format(dateDateEntry.getValue()));
                bodyParam.put("searchOpt", (Object)searchOpt);
                resultJson = this.allEPostAppJson(service, this.orgId, taxNo, bodyParam);
                LOGGER.info("\u65b0\u7535\u5b50\u5e73\u53f0\u5168\u91cf\u53d1\u7968\u4e0b\u8f7d\u7ed3\u679c\u8fd4\u56de:{}-{}", (Object)taxNo, (Object)resultJson);
                if (!ResultContant.isSuccess(resultJson).booleanValue()) break;
                JSONArray invoiceArray = resultJson.getJSONArray("data");
                if (CollectionUtils.isEmpty((Collection)invoiceArray)) continue;
                invoices.addAll((Collection)invoiceArray);
            }
            if (resultJson != null) {
                resultJson.put("data", (Object)invoices);
            }
        } else {
            resultJson = this.allEPostAppJson(service, this.orgId, taxNo, bodyParam);
            LOGGER.info("\u65b0\u7535\u5b50\u5e73\u53f0\u5168\u91cf\u53d1\u7968\u4e0b\u8f7d\u7ed3\u679c\u8fd4\u56de:{}-{}", (Object)taxNo, (Object)resultJson);
        }
        if (null == resultJson) {
            return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u83b7\u53d6\u5168\u91cf\u53d1\u7968\u5931\u8d25", (String)"NewEtaxDeductService_19", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        return resultJson;
    }

    @Override
    public JSONObject getDrawbackStatisticTable(JSONObject paramJson) {
        String taxNo = paramJson.getString("taxNo");
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        String requestId = DeductionConstant.getRequestId(paramJson);
        paramJson.put("requestId", (Object)requestId);
        paramJson.put("isComfirm", (Object)"2");
        paramJson.put("request_path", (Object)"/fpdk/tsgx/querytsytb");
        paramJson.put("taxPeriod", (Object)DateUtils.format(new Date(), "yyyyMM"));
        DeductionConstant.setUnittestFlag((Map<String, Object>)paramJson);
        LOGGER.info("\u67e5\u8be2\u9000\u7a0e\u7edf\u8ba1\u8868\u53c2\u6570:{}", (Object)paramJson);
        AwsFpyService service = AwsFpyService.newInstance();
        JSONObject resultJson = this.allEPostAppJson(service, this.orgId, taxNo, paramJson);
        if (null == resultJson) {
            return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u83b7\u53d6\u9000\u7a0e\u7edf\u8ba1\u8868\u5931\u8d25", (String)"NewEtaxDeductService_20", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        LOGGER.info("\u67e5\u8be2\u9000\u7a0e\u7edf\u8ba1\u8868\u8fd4\u56de\u7ed3\u679c:{}-{}", (Object)taxNo, (Object)resultJson);
        return resultJson;
    }

    @Override
    public JSONObject drawbackStatisticConfirm(JSONObject paramJson) {
        String taxNo = paramJson.getString("taxNo");
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        String requestId = DeductionConstant.getRequestId(paramJson);
        paramJson.put("requestId", (Object)requestId);
        paramJson.put("request_path", (Object)"/fpdk/tsgx/tsytComfirm");
        DeductionConstant.setUnittestFlag((Map<String, Object>)paramJson);
        LOGGER.info("\u786e\u8ba4\u9000\u7a0e\u7edf\u8ba1\u8868\u53c2\u6570:{}", (Object)paramJson);
        AwsFpyService service = AwsFpyService.newInstance();
        JSONObject resultJson = this.allEPostAppJson(service, this.orgId, taxNo, paramJson);
        if (null == resultJson) {
            return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u786e\u8ba4\u9000\u7a0e\u7edf\u8ba1\u8868\u5931\u8d25", (String)"NewEtaxDeductService_21", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        LOGGER.info("\u786e\u8ba4\u9000\u7a0e\u7edf\u8ba1\u8868\u8fd4\u56de\u7ed3\u679c:{}-{}", (Object)taxNo, (Object)resultJson);
        return resultJson;
    }

    @Override
    public JSONObject applyInvoiceFile(JSONObject paramJson) {
        String taxNo = paramJson.getString("taxNo");
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        JSONArray invoices = paramJson.getJSONArray("invoices");
        if (StringUtils.isBlank((Object)invoices)) {
            return ResultContant.createJSONObject("0201", ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef", (String)"NewEtaxDeductService_1", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        String eleAccount = paramJson.getString("account");
        LOGGER.info("\u6587\u4ef6\u4e0b\u8f7d\u7533\u8bf7\u53c2\u6570:{}", (Object)paramJson);
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        params.put("taxNo", taxNo);
        params.put("reqid", UUID.getReqid());
        AwsFpyService service = AwsFpyService.newInstance();
        JSONObject body = new JSONObject();
        body.putAll((Map)paramJson);
        body.remove((Object)"taxNo");
        JSONObject resultJson = null;
        boolean isLqFlag = "1".equals(paramJson.getString("lqFlag"));
        String flag = ImcConfigUtil.getValue("rim_config", "ele_file_token_lq");
        if (isLqFlag || StringUtils.equals((CharSequence)"1", (CharSequence)flag)) {
            resultJson = service.postAppJsonByTenantNew("new_etax_ele_filedown_apply", this.orgId, (Map<String, Object>)body, params, taxNo, true);
        } else {
            if (StringUtils.isBlank((CharSequence)eleAccount) && StringUtils.isEmpty((CharSequence)(eleAccount = service.getAllEaccount(taxNo)))) {
                return ResultContant.createJSONObject(ErrorType.NEED_LOGIN.getCode(), String.format(ResManager.loadKDString((String)"\u7a0e\u53f7:[%s]\u672a\u67e5\u8be2\u5230\u8d26\u53f7\u4fe1\u606f\uff0c\u8bf7\u524d\u5f80\u57fa\u7840\u8d44\u6599-\u4f01\u4e1a\u7ba1\u7406-\u6570\u7535\u914d\u7f6e\u8fdb\u884c\u76f8\u5173\u914d\u7f6e", (String)"NewEtaxDeductService_0", (String)"imc-rim-common", (Object[])new Object[0]), taxNo));
            }
            resultJson = service.postAppJsonByTenant("new_etax_ele_filedown_apply", this.orgId, (Map<String, Object>)body, params, taxNo, true);
        }
        if (null == resultJson) {
            return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u6587\u4ef6\u4e0b\u8f7d\u7533\u8bf7\u5931\u8d25", (String)"NewEtaxDeductService_22", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        if (StringUtils.isNotBlank((CharSequence)eleAccount)) {
            resultJson.put("account", (Object)eleAccount);
        }
        LOGGER.info("\u7533\u8bf7\u6587\u4ef6\u4e0b\u8f7d\u8fd4\u56de\u7ed3\u679c:{}-{}", (Object)taxNo, (Object)resultJson);
        this.checkRepeatApply(resultJson, "2");
        return resultJson;
    }

    @Override
    public JSONObject downInvoiceFile(JSONObject paramJson) {
        String taxNo = paramJson.getString("taxNo");
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        String batchNo = paramJson.getString("batchNo");
        if (StringUtils.isBlank((CharSequence)batchNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL.getCode(), ResManager.loadKDString((String)"\u6279\u6b21\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"NewEtaxDeductService_23", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        LOGGER.info("\u6587\u4ef6\u4e0b\u8f7d\u53c2\u6570:{}", (Object)paramJson);
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        params.put("taxNo", taxNo);
        params.put("reqid", UUID.getReqid());
        AwsFpyService service = AwsFpyService.newInstance();
        JSONObject resultJson = null;
        String flag = ImcConfigUtil.getValue("rim_config", "ele_file_token_old");
        String dkType = DeductionConstant.getDkType(taxNo);
        String lqTaxNoStr = ImcConfigUtil.getValue("rim_deduction", "leqi_taxno_down_ele_file");
        boolean isLqTaxno = "5".equals(dkType) || StringUtils.isNotBlank((CharSequence)lqTaxNoStr) && lqTaxNoStr.contains(taxNo);
        resultJson = isLqTaxno || StringUtils.equals((CharSequence)"1", (CharSequence)flag) ? service.postAppJsonByTenantNew("new_etax_ele_filedown_query", this.orgId, (Map<String, Object>)paramJson, params, taxNo, true) : service.postAppJsonByTenant("new_etax_ele_filedown_query", this.orgId, (Map<String, Object>)paramJson, params, taxNo, true);
        if (null == resultJson) {
            return ResultContant.createJSONObject(ErrorType.ETAX_HANDLING_1.getCode(), ResManager.loadKDString((String)"\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25", (String)"NewEtaxDeductService_24", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        LOGGER.info("\u6587\u4ef6\u4e0b\u8f7d\u8fd4\u56de\u7ed3\u679c:{}-{}", (Object)taxNo, (Object)resultJson);
        return resultJson;
    }

    private void updateCacheTaxperiod(String taxNo, JSONObject reslut) {
        if (!ResultContant.isSuccess(reslut).booleanValue() || StringUtils.isEmpty((CharSequence)taxNo)) {
            return;
        }
        JSONObject data = reslut.getJSONObject("data");
        if (data == null) {
            return;
        }
        String skssq = CommonUtils.getJsonValue((Map<String, Object>)data, String.class, true, "taxPeriod", "skssq");
        if (StringUtils.isNotEmpty((CharSequence)skssq) && DeductionConstant.updateSkssq(taxNo).booleanValue()) {
            DeductionConstant.cacheSkssq(taxNo, skssq);
        }
    }

    @Override
    public JSONObject recordedCommit(JSONObject paramJson) {
        JSONObject resultJson;
        LOGGER.info("rpa-\u53d1\u7968\u5165\u8d26\u7533\u8bf7\uff0c\u521d\u59cb\u53c2\u6570:{}", (Object)paramJson);
        if (StringUtils.isBlank((Object)paramJson)) {
            return ResultContant.createJSONObject("0201", ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef", (String)"NewEtaxDeductService_1", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        String operateType = paramJson.getString("operateType");
        if (StringUtils.isBlank((CharSequence)operateType)) {
            return ResultContant.createJSONObject("0201", ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef", (String)"NewEtaxDeductService_1", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        String taxNo = paramJson.getString("taxNo");
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        String nextEntryMarkStatus = paramJson.getString("nextEntryMarkStatus");
        if (StringUtils.isBlank((CharSequence)nextEntryMarkStatus)) {
            return ResultContant.createJSONObject("0201", ResManager.loadKDString((String)"\u5165\u8d26\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", (String)"NewEtaxDeductService_25", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        JSONArray invoices = paramJson.getJSONArray("invoices");
        if (StringUtils.isBlank((Object)invoices)) {
            return ResultContant.createJSONObject("0201", ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef", (String)"NewEtaxDeductService_1", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        JSONArray convertInvoices = new JSONArray(invoices.size());
        for (int i = 0; i < invoices.size(); ++i) {
            convertInvoices.add((Object)this.createRecordedInvoiceParam(invoices.getJSONObject(i)));
        }
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        params.put("taxNo", taxNo);
        params.put("reqid", UUID.getReqid());
        AwsFpyService service = AwsFpyService.newInstance();
        String allEaccount = service.getAllEaccount(taxNo);
        if (StringUtils.isEmpty((CharSequence)allEaccount)) {
            return ResultContant.createJSONObject(ErrorType.NEED_LOGIN.getCode(), String.format(ResManager.loadKDString((String)"\u7a0e\u53f7:[%s]\u672a\u67e5\u8be2\u5230\u8d26\u53f7\u4fe1\u606f\uff0c\u8bf7\u524d\u5f80\u57fa\u7840\u8d44\u6599-\u4f01\u4e1a\u7ba1\u7406-\u6570\u7535\u914d\u7f6e\u8fdb\u884c\u76f8\u5173\u914d\u7f6e", (String)"NewEtaxDeductService_0", (String)"imc-rim-common", (Object[])new Object[0]), taxNo));
        }
        JSONObject body = new JSONObject();
        body.put("account", (Object)allEaccount);
        body.put("nextEntryMarkStatus", (Object)nextEntryMarkStatus);
        body.put("invoices", (Object)convertInvoices);
        LOGGER.info("rpa-\u53d1\u7968\u5165\u8d26\u7533\u8bf7\uff0c\u8bf7\u6c42\u5934\uff1a{}\uff0c body\u53c2\u6570:{}", params, (Object)body);
        String msgType = "msg_new_fprz_recorded_commit";
        if ("recorded_update".equals(operateType) || "recorded_revoke".equals(operateType)) {
            msgType = "msg_new_fprz_recorded_update";
        }
        if (null == (resultJson = service.postAppJsonByTenant(msgType, this.orgId, (Map<String, Object>)body, params, taxNo, true))) {
            return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u53d1\u7968\u5165\u8d26\u72b6\u6001\u63d0\u4ea4\uff0c\u8bf7\u6c42\u5931\u8d25", (String)"NewEtaxDeductService_26", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        LOGGER.info("\u53d1\u7968\u5165\u8d26\u72b6\u6001\u63d0\u4ea4\uff0c\u8fd4\u56de\u7ed3\u679c:{}-{}", (Object)taxNo, (Object)resultJson);
        this.checkRepeatApply(resultJson, "1");
        return resultJson;
    }

    @Override
    public JSONObject queryRecordedCommitResult(JSONObject param) {
        JSONObject resultJson;
        String taxNo = param.getString("taxNo");
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        String batchNo = param.getString("batchNo");
        if (StringUtils.isBlank((CharSequence)batchNo)) {
            return ResultContant.createJSONObject(ErrorType.PARAM_NULL);
        }
        String operateType = param.getString("operateType");
        LOGGER.info("\u5f00\u59cb\u67e5\u8be2\u53d1\u7968\u5165\u8d26\u63d0\u4ea4/\u8c03\u6574\u7ed3\u679c-\u7533\u8bf7\u53c2\u6570:\u6279\u6b21\u53f7{}\uff0c\u7a0e\u53f7\uff0c{}\uff0c\u64cd\u4f5c\u7c7b\u578b\uff1a{}", new Object[]{batchNo, taxNo, operateType});
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        params.put("taxNo", taxNo);
        params.put("reqid", UUID.getReqid());
        JSONObject body = new JSONObject();
        body.put("batchNo", (Object)batchNo);
        AwsFpyService service = AwsFpyService.newInstance();
        String msgType = "msg_new_fprz_recorded_commit_query";
        if ("06".equals(operateType)) {
            msgType = "msg_new_fprz_recorded_update_query";
        }
        if (null == (resultJson = service.postAppJsonByTenant(msgType, this.orgId, (Map<String, Object>)body, params, taxNo, true))) {
            return ResultContant.createJSONObject(ErrorType.ETAX_HANDLING_1.getCode(), ResManager.loadKDString((String)"\u67e5\u8be2\u53d1\u7968\u5165\u8d26\u63d0\u4ea4\u7ed3\u679c\uff0c\u8bf7\u6c42\u5931\u8d25", (String)"NewEtaxDeductService_27", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        LOGGER.info("\u67e5\u8be2\u53d1\u7968\u5165\u8d26\u63d0\u4ea4\u7ed3\u679c\uff0c\u64cd\u4f5c\u7c7b\u578b\uff1a{}\uff0c \u8fd4\u56de\u7ed3\u679c:{}-{}", new Object[]{operateType, taxNo, resultJson});
        return resultJson;
    }

    @Override
    public JSONObject checkRecordedInvoiceParam(JSONObject param, String operateType) {
        String nextEntryMarkStatus = param.getString("nextEntryMarkStatus");
        String dateRegError = param.getString("dateRegError");
        String invoiceNo = param.getString("invoiceNo");
        String etaxInvoiceNo = param.getString("etaxInvoiceNo");
        String taxRecordedTime = param.getString("taxRecordedTime");
        Integer awsInvoiceType = param.getInteger("invoiceType");
        String codeGroup = CommonUtils.getInvoiceCodeNoGroup(param.getString("invoiceCode"), invoiceNo);
        if (!InputInvoiceTypeEnum.isVatType(InputInvoiceTypeEnum.getInvoiceTypeByAwsType(awsInvoiceType != null ? String.valueOf(awsInvoiceType) : "0"))) {
            return ResultContant.createJSONObject("0202", String.format(ResManager.loadKDString((String)"\u53d1\u7968\uff1a%1$s\uff0c\u8be5\u53d1\u7968\u7c7b\u578b\u4e0d\u652f\u6301\u5165\u8d26\u64cd\u4f5c\uff0c\u5f53\u524d\u53ea\u652f\u6301\u589e\u503c\u7a0e\u53d1\u7968\u5165\u8d26", (String)"NewEtaxDeductService_51", (String)"imc-rim-common", (Object[])new Object[0]), codeGroup));
        }
        if ("1".equals(dateRegError)) {
            return ResultContant.createJSONObject("0202", String.format(ResManager.loadKDString((String)"\u53d1\u7968\uff1a%1$s\uff0c\u65e5\u671f\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u5bf9\u7167\u9700\u6c42\u6587\u6863\u68c0\u67e5", (String)"NewEtaxDeductService_52", (String)"imc-rim-common", (Object[])new Object[0]), codeGroup));
        }
        String preTaxRecordedStatus = param.getString("preTaxRecordedStatus");
        if ("11".equals(preTaxRecordedStatus)) {
            return ResultContant.createJSONObject("0202", String.format(ResManager.loadKDString((String)"\u53d1\u7968\uff1a%1$s\uff0c\u5165\u8d26\u5904\u7406\u4e2d\u7684\u53d1\u7968\u4e0d\u80fd\u53d1\u8d77\u5165\u8d26\u7533\u8bf7", (String)"RecordedConstant_9", (String)"imc-rim-common", (Object[])new Object[0]), codeGroup));
        }
        if (kd.imc.rim.common.utils.StringUtils.isBlank((CharSequence)nextEntryMarkStatus)) {
            return ResultContant.createJSONObject("0202", String.format(ResManager.loadKDString((String)"\u53d1\u7968\uff1a%1$s\uff0c\u7a0e\u5c40\u5165\u8d26\u7528\u9014\u4e0d\u80fd\u4e3a\u7a7a", (String)"RecordedConstant_2", (String)"imc-rim-common", (Object[])new Object[0]), codeGroup));
        }
        if (("02".equals(nextEntryMarkStatus) || SYNC_TYPE_03.equals(nextEntryMarkStatus)) && StringUtils.isBlank((CharSequence)taxRecordedTime)) {
            return ResultContant.createJSONObject("0202", String.format(ResManager.loadKDString((String)"\u53d1\u7968\uff1a%1$s\uff0c\u65b0\u7535\u5b50\u7a0e\u5c40\u5e73\u53f0\uff0c\u7a0e\u5c40\u5165\u8d26\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (String)"RecordedConstant_3", (String)"imc-rim-common", (Object[])new Object[0]), codeGroup));
        }
        if (StringUtils.isNotBlank((CharSequence)taxRecordedTime) && kd.imc.rim.common.utils.StringUtils.isNotBlank((CharSequence)param.getString("invoiceDate"))) {
            Date invoiceDate = DateUtils.stringToDate(param.getString("invoiceDate"), "yyyy-MM-dd HH:mm:ss");
            Date taxRecordedTimeDate = DateUtils.stringToDate(taxRecordedTime, "yyyy-MM-dd");
            if (null != invoiceDate && DateUtils.compare(taxRecordedTimeDate, DateUtils.trunc(invoiceDate)) < 0) {
                return ResultContant.createJSONObject("0202", String.format(ResManager.loadKDString((String)"\u53d1\u7968\uff1a%1$s\uff0c\u53d1\u7968\u7684\u5165\u8d26\u65f6\u95f4\u5c0f\u4e8e\u5f00\u7968\u65e5\u671f", (String)"RecordedConstant_10", (String)"imc-rim-common", (Object[])new Object[0]), codeGroup));
            }
            Date now = new Date();
            if (taxRecordedTimeDate.compareTo(DateUtils.trunc(now)) > 0) {
                return ResultContant.createJSONObject("0202", String.format(ResManager.loadKDString((String)"\u53d1\u7968\uff1a%1$s\u7684\u7a0e\u5c40\u5165\u8d26\u65f6\u95f4\u5927\u4e8e\u5f53\u524d\u65e5\u671f", (String)"RecordedConstant_13", (String)"imc-rim-common", (Object[])new Object[0]), codeGroup));
            }
        }
        if (NewEtaxDeductService.checkHaveNullRpa(RECORDED_COMMIT_FILEDS, param)) {
            return ResultContant.createJSONObject("0202", String.format(ResManager.loadKDString((String)"\u65b0\u7535\u5b50\u7a0e\u52a1\u5e73\u53f0\uff0c\u53d1\u7968%1$s \u5165\u8d26\u6240\u9700\u5b57\u6bb5\u4e0d\u5b8c\u6574\uff0c\u8bf7\u524d\u5f80\u201c\u53d1\u7968\u5f52\u96c6\u7ba1\u7406-\u8fdb\u9879\u53d1\u7968\u5173\u952e\u8981\u7d20\u540c\u6b65\u201d\u624b\u5de5\u4e0b\u8f7d\u540e\u91cd\u8bd5\u3002", (String)"RecordedConstant_7", (String)"imc-rim-common", (Object[])new Object[0]), codeGroup));
        }
        if (("recorded_update".equals(operateType) || "recorded_revoke".equals(operateType)) && NewEtaxDeductService.checkHaveNullRpa(RECORDED_UPDATE_REVOKE_FILEDS, param)) {
            return ResultContant.createJSONObject("0202", String.format(ResManager.loadKDString((String)"\u65b0\u7535\u5b50\u7a0e\u52a1\u5e73\u53f0\uff0c\u53d1\u7968%1$s \u5165\u8d26\u66f4\u65b0\u6216\u5165\u8d26\u64a4\u9500\u6240\u9700\u5b57\u6bb5\u4e0d\u5b8c\u6574\u3002", (String)"RecordedConstant_8", (String)"imc-rim-common", (Object[])new Object[0]), codeGroup));
        }
        JSONObject checkResult = RecordedConstant.checkEleNo(invoiceNo, etaxInvoiceNo, awsInvoiceType, codeGroup);
        if (checkResult != null) {
            return checkResult;
        }
        return ResultContant.createSuccessJSONObject();
    }

    @Override
    public JSONObject createRecordedInvoiceParam(JSONObject param) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("buyerTaxNo", (Object)param.getString("buyerTaxNo"));
        jsonObject.put("salerName", (Object)param.getString("salerName"));
        jsonObject.put("salerTaxNo", (Object)param.getString("salerTaxNo"));
        jsonObject.put("invoiceType", (Object)param.getInteger("invoiceType"));
        jsonObject.put("invoiceCode", (Object)param.getString("invoiceCode"));
        jsonObject.put("etaxInvoiceNo", (Object)param.getString("etaxInvoiceNo"));
        jsonObject.put("invoiceNo", (Object)param.getString("invoiceNo"));
        jsonObject.put("invoiceDate", (Object)param.getString("invoiceDate"));
        jsonObject.put("invoiceAmount", (Object)param.getString("invoiceAmount"));
        jsonObject.put("totalTaxAmount", (Object)param.getString("totalTaxAmount"));
        jsonObject.put("invoiceStatus", (Object)param.getInteger("invoiceStatus"));
        jsonObject.put("invoiceRiskLevel", (Object)param.getString("invoiceRiskLevel"));
        jsonObject.put("entryMarkDate", (Object)param.getString("taxRecordedTime"));
        if (StringUtils.isNotBlank((CharSequence)param.getString("entryMarkStatus"))) {
            jsonObject.put("entryMarkStatus", (Object)param.getString("entryMarkStatus"));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getString("mxuuid"))) {
            jsonObject.put("mxuuid", (Object)param.getString("mxuuid"));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getString("rzuuid"))) {
            jsonObject.put("rzuuid", (Object)param.getString("rzuuid"));
        }
        return jsonObject;
    }

    private boolean checkNotDeductReason(String deductibleMode, JSONObject jsonObject, JSONObject jsonInvoiceParam, String invoiceNo) {
        if ("4".equals(deductibleMode) || "-4".equals(deductibleMode)) {
            String notDeductibleType = jsonObject.getString("notDeductibleType");
            if (StringUtils.isBlank((CharSequence)notDeductibleType)) {
                return false;
            }
            if (!NOT_DEDUCTIBLE_TYPE.contains(notDeductibleType)) {
                return false;
            }
            if ("5".equals(notDeductibleType)) {
                if (StringUtils.isBlank((CharSequence)jsonObject.getString("notDeductibleText"))) {
                    jsonInvoiceParam.put("notDeductibleText", (Object)"\u5176\u4ed6");
                } else {
                    jsonInvoiceParam.put("notDeductibleText", (Object)jsonObject.getString("notDeductibleText"));
                }
            }
            jsonInvoiceParam.put("notDeductibleType", (Object)Integer.valueOf(notDeductibleType));
        }
        return true;
    }

    private static boolean checkHaveNullRpa(Set<String> fields, JSONObject data) {
        for (String field : fields) {
            Object value = data.get((Object)field);
            if (Objects.isNull(value)) {
                return true;
            }
            if (!(value instanceof String) || !org.apache.commons.lang.StringUtils.isBlank((String)((String)value))) continue;
            return true;
        }
        return false;
    }

    @Override
    public JSONObject applyDownAgricInvoice(JSONObject paramJson) {
        String taxNo = paramJson.getString("taxNo");
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        params.put("taxNo", taxNo);
        params.put("reqid", UUID.getReqid());
        AwsFpyService service = AwsFpyService.newInstance();
        String allEaccount = service.getAllEaccount(taxNo);
        if (StringUtils.isEmpty((CharSequence)allEaccount)) {
            return ResultContant.createJSONObject(ErrorType.NEED_LOGIN.getCode(), String.format(ResManager.loadKDString((String)"\u7a0e\u53f7:[%s]\u672a\u67e5\u8be2\u5230\u8d26\u53f7\u4fe1\u606f\uff0c\u8bf7\u524d\u5f80\u57fa\u7840\u8d44\u6599-\u4f01\u4e1a\u7ba1\u7406-\u6570\u7535\u914d\u7f6e\u8fdb\u884c\u76f8\u5173\u914d\u7f6e", (String)"NewEtaxDeductService_0", (String)"imc-rim-common", (Object[])new Object[0]), taxNo));
        }
        paramJson.put("account", (Object)allEaccount);
        JSONObject resultJson = service.postAppJsonByTenant("msg_new_agric_invoice_down_apply", this.orgId, (Map<String, Object>)paramJson, params, taxNo, true);
        if (resultJson == null) {
            resultJson = ResultContant.createJSONObject("2002", ResManager.loadKDString((String)"\u519c\u4ea7\u54c1\u53d1\u7968\u7533\u8bf7\u4e0b\u8f7d\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"NewEtaxDeductService_28", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        resultJson.put("account", (Object)allEaccount);
        LOGGER.info("\u7533\u8bf7\u5f85\u5904\u7406\u519c\u4ea7\u54c1\u53d1\u7968\u8fd4\u56de\u7ed3\u679c:{},{}", (Object)taxNo, (Object)resultJson);
        this.checkRepeatApply(resultJson, "2");
        return resultJson;
    }

    @Override
    public JSONObject downAgricInvoice(JSONObject paramJson) {
        String taxNo = paramJson.getString("taxNo");
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        String batchNo = paramJson.getString("batchNo");
        if (StringUtils.isBlank((CharSequence)batchNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL.getCode(), ResManager.loadKDString((String)"\u6279\u6b21\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"NewEtaxDeductService_23", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        params.put("taxNo", taxNo);
        params.put("reqid", UUID.getReqid());
        AwsFpyService service = AwsFpyService.newInstance();
        JSONObject resultJson = service.postAppJsonByTenant("msg_new_agric_invoice_down_query", this.orgId, (Map<String, Object>)paramJson, params, taxNo, true);
        if (resultJson == null) {
            resultJson = ResultContant.createJSONObject(ErrorType.ETAX_HANDLING_1.getCode(), ResManager.loadKDString((String)"\u519c\u4ea7\u54c1\u53d1\u7968\u67e5\u8be2\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"NewEtaxDeductService_29", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        LOGGER.info("\u4e0b\u8f7d\u5f85\u5904\u7406\u519c\u4ea7\u54c1\u53d1\u7968\u8fd4\u56de\u7ed3\u679c:{},{}", (Object)taxNo, (Object)resultJson);
        return resultJson;
    }

    @Override
    public JSONObject getDownInvoiceHeadResult(JSONObject paramJson) {
        JSONArray invoiceArray;
        int size;
        LOGGER.info("\u63d0\u53d6rpa-\u8868\u5934\u5f02\u6b65\u4e0b\u8f7d\u7ed3\u679c\uff0c\u521d\u59cb\u5165\u53c2, {}", (Object)paramJson);
        if (StringUtils.isBlank((Object)paramJson)) {
            return ResultContant.createJSONObject("0201", ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef", (String)"NewEtaxDeductService_1", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        String batchNo = paramJson.getString("batchNo");
        if (StringUtils.isBlank((CharSequence)batchNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL.getCode(), ResManager.loadKDString((String)"\u6279\u6b21\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"NewEtaxDeductService_23", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        String taxNo = paramJson.getString("taxNo");
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        JSONObject searchOpt = paramJson.getJSONObject("searchOpt");
        if (searchOpt == null) {
            return ResultContant.createJSONObject("0201", ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef", (String)"NewEtaxDeductService_1", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        DeductionConstant.setUnittestFlag((Map<String, Object>)paramJson);
        JSONObject body = new JSONObject();
        String msgType = "msg_new_header_down_unconfirmed_query";
        String billType = paramJson.getString("billType");
        String deductFlag = searchOpt.getString("deductFlag");
        if ("0".equals(billType)) {
            if ("2".equals(deductFlag)) {
                msgType = "msg_new_header_down_confirmed_query";
            }
        } else if ("1".equals(billType)) {
            msgType = "msg_new_customs_header_down_unconfirmed_query";
            if ("2".equals(deductFlag)) {
                msgType = "msg_new_customs_header_down_confirmed_query";
            }
        } else if ("2".equals(billType)) {
            msgType = "msg_new_withholding_header_unconfirmed_query";
            if ("2".equals(deductFlag)) {
                msgType = "msg_new_withholding_header_confirmed_query";
            }
        } else {
            return ResultContant.createJSONObject("0201", ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef", (String)"NewEtaxDeductService_1", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        HashMap<String, String> params = new HashMap<String, String>(8);
        params.put("reqid", UUID.getReqid());
        params.put("taxNo", taxNo);
        body.put("batchNo", (Object)batchNo);
        body.put("pageSize", (Object)paramJson.getInteger("pageSize"));
        body.put("currentPage", (Object)paramJson.getInteger("currentPage"));
        LOGGER.info("\u63d0\u53d6rpa-\u8868\u5934\u5f02\u6b65\u4e0b\u8f7d\u7ed3\u679c\uff0c\u7ec4\u88c5\u540ebody\u5165\u53c2, {}", (Object)body);
        AwsFpyService service = AwsFpyService.newInstance();
        String msgTypeFinal = msgType;
        int retryTime = InvoiceDownloadConstant.getPageSizeFromConfig(3, "all_e_retry_times");
        int sleepTime = InvoiceDownloadConstant.getPageSizeFromConfig(3000, "all_e_sleep_times");
        JSONObject resultJson = RimRetryPostUtil.retryPost(() -> service.postAppJsonByTenant(msgTypeFinal, this.orgId, (Map<String, Object>)body, (Map<String, Object>)params, taxNo, true), COLLECT_ERRCODE, (int)retryTime, (int)sleepTime);
        if (null == resultJson) {
            resultJson = ResultContant.createJSONObject(ErrorType.ETAX_HANDLING_1.getCode(), ResManager.loadKDString((String)"\u83b7\u53d6\u53d1\u7968\u5931\u8d25", (String)"NewEtaxDeductService_9", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        int n = size = StringUtils.isNotBlank((Object)resultJson.getJSONArray("data")) ? resultJson.getJSONArray("data").size() : 0;
        if (size > 0 && StringUtils.isNotBlank((Object)(invoiceArray = resultJson.getJSONArray("data")))) {
            for (int i = 0; i < invoiceArray.size(); ++i) {
                JSONObject invoice = invoiceArray.getJSONObject(i);
                if (invoice == null) continue;
                if ("2".equals(billType)) {
                    if (StringUtils.isBlank((CharSequence)invoice.getString("invoiceType"))) {
                        invoice.put("invoiceType", (Object)InputInvoiceTypeEnum.WITHHOLDING.getAwsType());
                    }
                    if (StringUtils.isNotBlank((CharSequence)invoice.getString("voucherNo"))) {
                        invoice.put("invoiceNo", (Object)invoice.getString("voucherNo"));
                    }
                    if (StringUtils.isNotBlank((CharSequence)invoice.getString("withholdingAgentName"))) {
                        invoice.put("salerName", (Object)invoice.getString("withholdingAgentName"));
                    }
                    if (StringUtils.isNotBlank((CharSequence)invoice.getString("withholdingAgentIDNum"))) {
                        invoice.put("salerTaxNo", (Object)invoice.getString("withholdingAgentIDNum"));
                        invoice.put("invoiceCode", (Object)invoice.getString("withholdingAgentIDNum"));
                    }
                }
                if (!StringUtils.isNotBlank((CharSequence)invoice.getString("businessType"))) continue;
                invoice.put("specialTypeMark", (Object)RpaConvertUtil.convertSpecialTypeMark(invoice.getString("businessType")));
                invoice.remove((Object)"businessType");
            }
        }
        LOGGER.info("\u63d0\u53d6rpa-\u8868\u5934\u5f02\u6b65\u4e0b\u8f7d\u7ed3\u679c,\u4e0b\u8f7d\u53d1\u7968\u8fd4\u56de\u7ed3\u679c:{}-{}", (Object)taxNo, (Object)resultJson);
        LOGGER.info("\u63d0\u53d6rpa-\u8868\u5934\u5f02\u6b65\u4e0b\u8f7d\u7ed3\u679c,\u4e0b\u8f7d\u53d1\u7968\u8fd4\u56de\u7ed3\u679c:[{}]{},\u4e0b\u8f7d\u6570\u91cf:{}", new Object[]{resultJson.get((Object)"errcode"), resultJson.get((Object)"description"), size});
        return resultJson;
    }

    @Override
    public JSONObject downInvoiceHeadApply(JSONObject paramJson) {
        paramJson.put("rpadownAsyn", (Object)"1");
        LOGGER.info("rpa-\u8868\u5934\u5f02\u6b65\u4e0b\u8f7d\u7533\u8bf7\uff0c\u521d\u59cb\u5165\u53c2, {}", (Object)paramJson);
        if (StringUtils.isBlank((Object)paramJson)) {
            return ResultContant.createJSONObject("0201", ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef", (String)"NewEtaxDeductService_1", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        String taxNo = paramJson.getString("taxNo");
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        JSONObject searchOpt = paramJson.getJSONObject("searchOpt");
        if (searchOpt == null) {
            return ResultContant.createJSONObject("0201", ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef", (String)"NewEtaxDeductService_1", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        AwsFpyService service = AwsFpyService.newInstance();
        String allEaccount = service.getAllEaccount(taxNo);
        if (StringUtils.isEmpty((CharSequence)allEaccount)) {
            return ResultContant.createJSONObject(ErrorType.NEED_LOGIN.getCode(), String.format(ResManager.loadKDString((String)"\u7a0e\u53f7:[%s]\u672a\u67e5\u8be2\u5230\u8d26\u53f7\u4fe1\u606f\uff0c\u8bf7\u524d\u5f80\u57fa\u7840\u8d44\u6599-\u4f01\u4e1a\u7ba1\u7406-\u6570\u7535\u914d\u7f6e\u8fdb\u884c\u76f8\u5173\u914d\u7f6e", (String)"NewEtaxDeductService_0", (String)"imc-rim-common", (Object[])new Object[0]), taxNo));
        }
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        params.put("reqid", UUID.getReqid());
        params.put("taxNo", taxNo);
        JSONObject body = new JSONObject();
        String invoiceStatus = searchOpt.getString("invoiceStatus");
        if (StringUtils.isBlank((CharSequence)invoiceStatus)) {
            invoiceStatus = "-1";
        }
        String invoiceType = searchOpt.getString("invoiceType");
        String deductFlag = searchOpt.getString("deductFlag");
        String deductionPurpose = searchOpt.getString("deductionPurpose");
        String taxPeriod = searchOpt.getString("taxPeriod");
        String startTime = searchOpt.getString("startTime");
        String endTime = searchOpt.getString("endTime");
        HashSet<String> invoiceTypeSet = new HashSet<String>(1);
        HashSet<String> deductionPurposeSet = new HashSet<String>(1);
        deductionPurposeSet.add(StringUtils.isNotBlank((CharSequence)deductionPurpose) ? deductionPurpose : "-1");
        String msgType = "msg_new_header_down_unconfirmed";
        String billType = paramJson.getString("billType");
        if ("0".equals(billType)) {
            invoiceTypeSet.add(StringUtils.isNotBlank((CharSequence)invoiceType) ? invoiceType : "-1");
            body.put("invoiceTypes", invoiceTypeSet.stream().map(t -> Integer.valueOf(t)).collect(Collectors.toSet()));
            if ("2".equals(deductFlag)) {
                msgType = "msg_new_header_down_confirmed";
                body.put("taxPeriod", (Object)taxPeriod);
                body.put("deductionPurpose", deductionPurposeSet);
            } else {
                body.put("checkStatus", (Object)Integer.valueOf(deductFlag));
                if ("0".equals(deductFlag)) {
                    body.put("startDate", (Object)startTime);
                    body.put("endDate", (Object)endTime);
                    body.put("invoiceStatus", (Object)Integer.valueOf(invoiceStatus));
                    body.put("multInvoiceStatus", (Object)searchOpt.getString("multInvoiceStatus"));
                } else if ("1".equals(deductFlag)) {
                    body.put("deductionPurpose", deductionPurposeSet);
                }
            }
        } else if ("1".equals(billType)) {
            msgType = "msg_new_customs_header_down_unconfirmed";
            if ("2".equals(deductFlag)) {
                msgType = "msg_new_customs_header_down_confirmed";
                body.put("taxPeriod", (Object)taxPeriod);
                body.put("deductionPurpose", deductionPurposeSet);
            } else {
                body.put("checkStatus", (Object)Integer.valueOf(deductFlag));
                if ("0".equals(deductFlag)) {
                    body.put("startDate", (Object)startTime);
                    body.put("endDate", (Object)endTime);
                } else if ("1".equals(deductFlag)) {
                    body.put("deductionPurpose", deductionPurposeSet);
                }
            }
        } else if ("2".equals(billType)) {
            msgType = "msg_new_withholding_header_unconfirmed";
            if ("2".equals(deductFlag)) {
                msgType = "msg_new_withholding_header_confirmed";
                body.put("taxPeriod", (Object)taxPeriod);
                body.put("deductionPurpose", deductionPurposeSet);
                if (!"-1".equals(deductionPurpose) && !"1".equals(deductionPurpose)) {
                    return ResultContant.createJSONObject("0201", ResManager.loadKDString((String)"\u65b0\u7535\u5b50\u7a0e\u5c40\u7684\u4ee3\u6263\u4ee3\u7f34\u5b8c\u7a0e\u51ed\u8bc1\u5df2\u62b5\u6263\u4e0b\u8f7d\uff0c\u6682\u65f6\u53ea\u652f\u6301\u4e0b\u8f7d\u62b5\u6263\u7528\u9014\u4e3a\u62b5\u6263\u7684\u6570\u636e", (String)"NewEtaxDeductService_54", (String)"imc-rim-common", (Object[])new Object[0]));
                }
            } else {
                body.put("checkStatus", (Object)Integer.valueOf(deductFlag));
                if ("0".equals(deductFlag)) {
                    body.put("startDate", (Object)startTime);
                    body.put("endDate", (Object)endTime);
                } else if ("1".equals(deductFlag)) {
                    body.put("deductionPurpose", deductionPurposeSet);
                }
            }
        } else {
            return ResultContant.createJSONObject("0201", ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef", (String)"NewEtaxDeductService_1", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        body.put("account", (Object)allEaccount);
        LOGGER.info("rpa-\u8868\u5934\u5f02\u6b65\u4e0b\u8f7d\u7533\u8bf7\uff0c\u7ec4\u88c5\u540ebody\u5165\u53c2, {}", (Object)body);
        JSONObject resultJson = service.postAppJsonByTenant(msgType, this.orgId, (Map<String, Object>)body, params, taxNo, true);
        if (null == resultJson) {
            return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"rpa-\u8868\u5934\u5f02\u6b65\u4e0b\u8f7d\u63d0\u4ea4\uff0c\u8bf7\u6c42\u5931\u8d25", (String)"NewEtaxDeductService_43", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        resultJson.put("account", (Object)allEaccount);
        LOGGER.info("rpa-\u8868\u5934\u5f02\u6b65\u4e0b\u8f7d\u7533\u8bf7\uff0c\u8fd4\u56de\u7ed3\u679c:{}-{}", (Object)taxNo, (Object)resultJson);
        this.checkRepeatApply(resultJson, "2");
        return resultJson;
    }

    @Override
    public JSONObject discardTasks(JSONObject bodyJson) {
        String taxNo = bodyJson.getString("taxNo");
        List batchNos = (List)bodyJson.get((Object)"batchNos");
        if (null == bodyJson) {
            return ResultContant.createJSONObject("0201", ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef", (String)"NewEtaxDeductService_1", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        if (CollectionUtils.isEmpty((Collection)batchNos)) {
            return ResultContant.createJSONObject("0201", ResManager.loadKDString((String)"\u4f5c\u5e9f\u64cd\u4f5c\uff0c\u6279\u6b21\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"NewEtaxDeductService_55", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        Set newBatchNoSet = batchNos.stream().collect(Collectors.toSet());
        LOGGER.info("\u4f5c\u5e9f\u4efb\u52a1\u8bf7\u6c42\u53c2\u6570:{}", (Object)bodyJson);
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        params.put("reqid", UUID.getReqid());
        params.put("taxNo", taxNo);
        JSONObject body = new JSONObject();
        body.put("batchNos", newBatchNoSet);
        AwsFpyService service = AwsFpyService.newInstance();
        String msgType = "new_etax_discard_tasks";
        JSONObject resultJson = service.postAppJsonByTenant(msgType, this.orgId, (Map<String, Object>)body, params, taxNo, true);
        if (null == resultJson) {
            return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"rpa\u5e9f\u5f03\u4efb\u52a1\uff0c\u8bf7\u6c42\u5931\u8d25", (String)"NewEtaxDeductService_44", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        LOGGER.info("\u4f5c\u5e9f\u4efb\u52a1\uff0c\u8fd4\u56de\u7ed3\u679c:{}-{}", (Object)taxNo, (Object)resultJson);
        return resultJson;
    }

    @Override
    public JSONObject agricInvoiceHandle(JSONObject param) {
        String taxNo = param.getString("taxNo");
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        JSONArray invoices = param.getJSONArray("invoices");
        if (CollectionUtils.isEmpty((Collection)invoices)) {
            return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef", (String)"LqDeductService_27", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        AwsFpyService service = AwsFpyService.newInstance();
        JSONObject newParam = new JSONObject();
        String allEaccount = service.getAllEaccount(taxNo);
        if (StringUtils.isEmpty((CharSequence)allEaccount)) {
            return ResultContant.createJSONObject(ErrorType.NEED_LOGIN.getCode(), String.format(ResManager.loadKDString((String)"\u7a0e\u53f7:[%s]\u672a\u67e5\u8be2\u5230\u8d26\u53f7\u4fe1\u606f\uff0c\u8bf7\u524d\u5f80\u57fa\u7840\u8d44\u6599-\u4f01\u4e1a\u7ba1\u7406-\u6570\u7535\u914d\u7f6e\u8fdb\u884c\u76f8\u5173\u914d\u7f6e", (String)"NewEtaxDeductService_0", (String)"imc-rim-common", (Object[])new Object[0]), taxNo));
        }
        newParam.put("taxNo", (Object)taxNo);
        newParam.put("account", (Object)allEaccount);
        String deductibleMode = param.getString("deductibleMode");
        String processType = DeductionUtils.convertAgricPrehandleType(deductibleMode);
        String farmProductType = "1";
        if ("16".equals(deductibleMode) || "17".equals(deductibleMode)) {
            farmProductType = "2";
        }
        newParam.put("farmProductType", (Object)farmProductType);
        JSONArray fpmx = new JSONArray();
        for (int i = 0; i < invoices.size(); ++i) {
            JSONObject invoice = invoices.getJSONObject(i);
            String processingStatus = invoice.getString("agricHandleStatus");
            if (StringUtils.isEmpty((CharSequence)processingStatus)) {
                processingStatus = "0";
            }
            invoice.put("processingStatus", (Object)processingStatus);
            invoice.put("processType", (Object)processType);
            invoice.put("invoiceRiskLevel", (Object)DeductionUtils.convertInvoiceRiskLevelToAws(invoice.getString("invoiceRiskLevel")));
            if (!"15".equals(deductibleMode)) continue;
            invoice.put("farmProductAmount", invoice.get((Object)"agricPartialAmount"));
        }
        newParam.put("invoices", (Object)invoices);
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        params.put("taxNo", taxNo);
        params.put("reqid", UUID.getReqid());
        JSONObject result = service.postAppJsonByTenant("msg_new_agric_invoice_handle_apply", this.orgId, (Map<String, Object>)newParam, params, taxNo, true);
        LOGGER.info("RPA-\u6279\u91cf\u4e0a\u4f20\u519c\u4ea7\u54c1\u5904\u7406\u8fd4\u56de\u7ed3\u679c\uff1a{}-{}", (Object)taxNo, (Object)result);
        if (result == null) {
            result = ResultContant.createJSONObject(ErrorType.FAIL);
        }
        this.checkRepeatApply(result, "1");
        return result;
    }

    @Override
    public JSONObject agricInvoiceHandleQuery(JSONObject paramJson) {
        String taxNo = paramJson.getString("taxNo");
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        String batchNo = paramJson.getString("batchNo");
        if (StringUtils.isBlank((CharSequence)batchNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL.getCode(), ResManager.loadKDString((String)"\u6279\u6b21\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"NewEtaxDeductService_23", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        params.put("taxNo", taxNo);
        params.put("reqid", UUID.getReqid());
        AwsFpyService service = AwsFpyService.newInstance();
        JSONObject resultJson = service.postAppJsonByTenant("msg_new_agric_invoice_handle_query", this.orgId, (Map<String, Object>)paramJson, params, taxNo, true);
        if (resultJson == null) {
            resultJson = ResultContant.createJSONObject(ErrorType.ETAX_HANDLING_1.getCode(), ResManager.loadKDString((String)"\u519c\u4ea7\u54c1\u53d1\u7968\u67e5\u8be2\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"NewEtaxDeductService_29", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        LOGGER.info("\u5904\u7406\u519c\u4ea7\u54c1\u53d1\u7968\u8fd4\u56de\u7ed3\u679c:{},{}", (Object)taxNo, (Object)resultJson);
        return resultJson;
    }

    public JSONObject allEPostAppJson(AwsFpyService service, Long orgId, String taxNo, JSONObject bodyJson) {
        int retryTime = InvoiceDownloadConstant.getPageSizeFromConfig(3, "all_e_retry_times");
        int sleepTime = InvoiceDownloadConstant.getPageSizeFromConfig(3000, "all_e_sleep_times");
        return RimRetryPostUtil.retryPost(() -> service.allEPostAppJson(orgId, taxNo, bodyJson), COLLECT_ERRCODE, (int)retryTime, (int)sleepTime);
    }

    public void checkRepeatApply(JSONObject result, String downType) {
        QFilter batchNoFilterLog;
        if (result == null || StringUtils.isBlank((CharSequence)downType)) {
            return;
        }
        JSONObject data = result.getJSONObject("data");
        if (data == null) {
            return;
        }
        String batchNo = data.getString("batchNo");
        if (StringUtils.isBlank((CharSequence)batchNo)) {
            return;
        }
        boolean exists = false;
        if (StringUtils.equals((CharSequence)"2", (CharSequence)downType)) {
            batchNoFilterLog = new QFilter("taskno", "=", (Object)batchNo);
            exists = QueryServiceHelper.exists((String)"rim_down_log", (QFilter[])new QFilter[]{batchNoFilterLog});
        }
        if (StringUtils.equals((CharSequence)"1", (CharSequence)downType)) {
            batchNoFilterLog = new QFilter("batch_no", "=", (Object)batchNo);
            exists = QueryServiceHelper.exists((String)"rim_select_log", (QFilter[])new QFilter[]{batchNoFilterLog});
        }
        if (exists) {
            result.remove((Object)"data");
            result.put("errcode", (Object)ErrorType.DUPLICATE_TASK.getCode());
            String msg = String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u53f7\uff1a%1$s,\u76f8\u540c\u7684\u4efb\u52a1\u91cd\u590d\u8bf7\u6c42\u8fc7\u4e8e\u9891\u7e41\uff0c\u8bf73\u5206\u949f\u540e\u518d\u91cd\u8bd5", (String)"NewEtaxDeductService_56", (String)"imc-rim-common", (Object[])new Object[0]), batchNo);
            result.put("description", (Object)msg);
            return;
        }
    }

    @Override
    public JSONObject batchTaskHandleQuery(JSONObject paramJson) {
        String taxNo = paramJson.getString("taxNo");
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        List batchNos = (List)paramJson.get((Object)"batchNos");
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)batchNos)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL.getCode(), ResManager.loadKDString((String)"\u6279\u6b21\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"NewEtaxDeductService_23", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        JSONObject body = new JSONObject();
        Set newBatchNoSet = batchNos.stream().collect(Collectors.toSet());
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        params.put("taxNo", taxNo);
        params.put("reqid", UUID.getReqid());
        body.put("batchNos", newBatchNoSet);
        LOGGER.info("\u6279\u91cf\u67e5\u8be2\u8fdb\u9879\u5f02\u6b65\u4efb\u52a1\u72b6\u6001\u4efb\u52a1\u8bf7\u6c42\u53c2\u6570:{}", (Object)paramJson);
        AwsFpyService service = AwsFpyService.newInstance();
        JSONObject resultJson = service.postAppJsonByTenant("batch_query_input_async_task", this.orgId, (Map<String, Object>)body, params, taxNo, true);
        if (resultJson == null) {
            resultJson = ResultContant.createJSONObject("2002", ResManager.loadKDString((String)"\u6279\u91cf\u67e5\u8be2\u8fdb\u9879\u5f02\u6b65\u4efb\u52a1\u72b6\u6001\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"NewEtaxDeductService_30", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        LOGGER.info("\u6279\u91cf\u67e5\u8be2\u8fdb\u9879\u5f02\u6b65\u4efb\u52a1\u8fd4\u56de\u7ed3\u679c:{},{}", (Object)taxNo, (Object)resultJson);
        return resultJson;
    }

    private /* synthetic */ JSONObject lambda$downFullInvoice$2(AwsFpyService service, String msgTypeFinal, JSONObject paramJson, Map params, String taxNo) {
        return service.postAppJsonByTenant(msgTypeFinal, this.orgId, (Map<String, Object>)paramJson, (Map<String, Object>)params, taxNo, true);
    }
}

