/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.download;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.earlywarn.kit.StringUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.HolytaxInvoiceTypeEnum;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.InvoiceDownloadConstant;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.invoice.download.InvoiceApplyLogService;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.ImcConfigUtil;
import kd.imc.rim.common.utils.LockUtils;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.common.utils.UUID;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.tuple.Pair;

public abstract class InputOutInvoiceApplyService {
    private static final Log LOGGER = LogFactory.getLog(InputOutInvoiceApplyService.class);

    public void divideObject(DynamicObject initDynamicObject, Long orgId, String taxNo, List<Map<String, Date>> initDateList) {
        String lockKey = "InvoiceDownApplyLock-" + taxNo;
        try (DLock lock = LockUtils.createDLockByMd5((String)lockKey, (String)ResManager.loadKDString((String)"InvoiceDownApplyLock\u9501", (String)"InputOutInvoiceApplyService_0", (String)"imc-rim-common", (Object[])new Object[0]));){
            if (lock.tryLock()) {
                LOGGER.info("\u8fdb\u9500\u9879\u7533\u8bf7:{}", (Object)taxNo);
                List<String> outputDownloads = CommonUtils.getMultiValues(initDynamicObject.getString("output_download"));
                List<String> invoiceTypes = CommonUtils.getMultiValues(initDynamicObject.getString("invoice_type"));
                for (String outputDownload : outputDownloads) {
                    for (String invoiceType : invoiceTypes) {
                        if (!this.checkDownCustom(outputDownload, invoiceType, taxNo)) continue;
                        this.applyInitHistoryData(initDynamicObject, invoiceType, outputDownload, orgId, taxNo, initDateList);
                        this.applyBeforeHistoryData(initDynamicObject, invoiceType, outputDownload, orgId, taxNo);
                        ArrayList<String> invoiceTypeList = new ArrayList<String>(1);
                        invoiceTypeList.add(invoiceType);
                        this.replenishApplyLastData(initDynamicObject, invoiceTypeList, outputDownload, orgId, taxNo);
                        this.applyCurrentData(initDynamicObject, invoiceType, outputDownload, orgId, taxNo);
                    }
                }
            } else {
                LOGGER.info("InvoiceDownApplyLock-tryLock");
            }
        }
        catch (Exception e) {
            LOGGER.error("\u8fdb\u9500\u9879\u7533\u5931\u8d25:" + taxNo, (Throwable)e);
        }
    }

    public void applyBeforeHistoryData(DynamicObject initDynamicObject, String invoiceType, String dataType, Long orgId, String taxNo) {
        int before2MonthApplyDate;
        Calendar cal = Calendar.getInstance();
        Date dateNow = new Date();
        String downDate = RimConfigUtils.getConfig("down_date");
        if (StringUtil.isNotEmpty((CharSequence)downDate)) {
            dateNow = DateUtils.stringToDate(downDate);
        }
        cal.setTime(dateNow);
        Date firstDay = DateUtils.getFirstDateOfMonth(dateNow);
        int day = cal.get(5);
        Date startDate = null;
        Date endDate = null;
        int tryDays = InvoiceDownloadConstant.getPageSizeFromConfig(3, "try_apply_days");
        int outputApplyDate = InvoiceDownloadConstant.getPageSizeFromConfig(2, "output_apply_date");
        String appointDaysStr = RimConfigUtils.getConfig("rim_deduction", "appoint_days");
        List<String> appointDays = CommonUtils.getMultiValues(appointDaysStr);
        if ("2".equals(dataType) && this.checkDays(day, outputApplyDate, tryDays, appointDays)) {
            Date behindMonth = DateUtils.addMonth(firstDay, -1);
            startDate = DateUtils.getFirstDateOfMonth(behindMonth);
            endDate = DateUtils.getLastDateOfMonthZero(behindMonth);
            this.applyHistoryData(initDynamicObject, invoiceType, dataType, orgId, taxNo, startDate, endDate);
        }
        int inputApplyDate = InvoiceDownloadConstant.getPageSizeFromConfig(6, "input_apply_date");
        if ("1".equals(dataType) && this.checkDays(day, inputApplyDate, tryDays, appointDays)) {
            Date behindMonth = DateUtils.addMonth(firstDay, -1);
            startDate = DateUtils.getFirstDateOfMonth(behindMonth);
            endDate = DateUtils.getLastDateOfMonthZero(behindMonth);
            this.applyHistoryData(initDynamicObject, invoiceType, dataType, orgId, taxNo, startDate, endDate);
        }
        if (this.checkDays(day, before2MonthApplyDate = InvoiceDownloadConstant.getPageSizeFromConfig(12, "before2_month_apply_date"), tryDays, appointDays)) {
            Date behind2Month = DateUtils.addMonth(firstDay, -2);
            startDate = DateUtils.getFirstDateOfMonth(behind2Month);
            endDate = DateUtils.getLastDateOfMonthZero(behind2Month);
            this.applyHistoryData(initDynamicObject, invoiceType, dataType, orgId, taxNo, startDate, endDate);
        }
    }

    protected boolean checkDays(int nowDay, int configDay, int tryDay, List<String> appointDays) {
        boolean isDays = nowDay >= configDay && nowDay < configDay + tryDay;
        boolean isAppointDays = appointDays != null && appointDays.contains(String.valueOf(nowDay));
        return isDays || isAppointDays;
    }

    public void applyInitHistoryData(DynamicObject initDynamicObject, String invoiceType, String dataType, Long orgId, String taxNo, List<Map<String, Date>> initDateList) {
        if (!CollectionUtils.isEmpty(initDateList)) {
            String asyncFlag = RimConfigUtils.getConfig("rim_deduction", "init_down_async");
            if (!"0".equals(asyncFlag)) {
                InvoiceApplyLogService service = new InvoiceApplyLogService();
                service.saveInitApplyLog(orgId, taxNo, dataType, invoiceType, initDateList);
                return;
            }
            for (Map<String, Date> stringDateMap : initDateList) {
                this.applyHistoryData(initDynamicObject, invoiceType, dataType, orgId, taxNo, stringDateMap.get("begin"), stringDateMap.get("end"));
            }
        }
    }

    public void applyHistoryData(DynamicObject initDynamicObject, String invoiceType, String dataType, Long orgId, String taxNo, Date firstDay, Date endDate) {
        Pair<Boolean, Long> applyHistoryPair = this.isApplyHistory(initDynamicObject, invoiceType, dataType, taxNo, firstDay, endDate);
        Boolean isApply = (Boolean)applyHistoryPair.getLeft();
        if (isApply.booleanValue()) {
            this.applyInputOutDownInvoice((Long)applyHistoryPair.getRight(), initDynamicObject, invoiceType, dataType, orgId, taxNo, firstDay, endDate);
        }
    }

    public Pair<Boolean, Long> isApplyHistory(DynamicObject initDynamicObject, String invoiceType, String dataType, String taxNo, Date firstDay, Date endDate) {
        Pair<DynamicObject, Integer> logDynamicObjectPair;
        DynamicObject logDynamicObject;
        LOGGER.info("\u5f00\u59cb\u68c0\u67e5\u7533\u8bf7\u5386\u53f2\u53d1\u7968\u662f\u5426\u9700\u8981\u7533\u8bf7,{};invoiceType:{};downType:{};{}-{}", new Object[]{taxNo, invoiceType, dataType, DateUtils.format(firstDay), DateUtils.format(endDate)});
        if (initDynamicObject != null) {
            Date beginDownDate = initDynamicObject.getDate("begin");
            if (firstDay.before(beginDownDate = DateUtils.getFirstDateOfMonth(beginDownDate))) {
                return Pair.of((Object)Boolean.FALSE, null);
            }
        }
        if ((logDynamicObject = (DynamicObject)(logDynamicObjectPair = this.getLogDynamicObject(taxNo, invoiceType, dataType, "3", firstDay, endDate)).getLeft()) != null) {
            boolean isTimeBefore;
            boolean bl = isTimeBefore = logDynamicObject.getDate("apply_date").before(DateUtils.getFirstDateOfMonth(new Date())) || "7".equals(logDynamicObject.getString("download_errcode")) || "10".equals(logDynamicObject.getString("download_errcode"));
            if (isTimeBefore && "7".equals(logDynamicObject.getString("gov_status")) && logDynamicObject.getDate("apply_date").before(DateUtils.getFirstDateOfMonth(new Date()))) {
                return Pair.of((Object)Boolean.TRUE, (Object)logDynamicObject.getLong("id"));
            }
        } else {
            return Pair.of((Object)Boolean.TRUE, null);
        }
        return Pair.of((Object)Boolean.FALSE, null);
    }

    public void againApply(Long logId) {
        try {
            QFilter qFilter = new QFilter("id", "=", (Object)logId);
            DynamicObject logObj = QueryServiceHelper.queryOne((String)"rim_down_log", (String)"id,invoice_type.id AS invoice_type,inout,invoice_startdate,invoice_enddate,org.id AS org,tax_no,apply_date,batch_no,aws_invoice_type", (QFilter[])qFilter.toArray());
            String invoiceType = logObj.getString("aws_invoice_type");
            if (StringUtils.isEmpty((CharSequence)invoiceType)) {
                invoiceType = InputInvoiceTypeEnum.getAwsType(logObj.get("invoice_type"));
            }
            this.applyInputOutDownInvoice(logId, null, invoiceType, logObj.getString("inout"), logObj.getLong("org"), logObj.getString("tax_no"), logObj.getDate("invoice_startdate"), logObj.getDate("invoice_enddate"));
        }
        catch (Exception e) {
            LOGGER.error("\u91cd\u65b0\u7533\u8bf7\u5931\u8d25", (Throwable)e);
        }
    }

    public JSONObject reapply(Long logId) {
        JSONObject result = ResultContant.createSuccessJSONObject();
        try {
            QFilter qFilter = new QFilter("id", "=", (Object)logId);
            DynamicObject logObj = QueryServiceHelper.queryOne((String)"rim_down_log", (String)"id,invoice_type.id AS invoice_type,inout,invoice_startdate,invoice_enddate,org.id AS org,tax_no,apply_date,batch_no,aws_invoice_type", (QFilter[])qFilter.toArray());
            String invoiceType = logObj.getString("aws_invoice_type");
            if (StringUtils.isEmpty((CharSequence)invoiceType)) {
                invoiceType = InputInvoiceTypeEnum.getAwsType(logObj.get("invoice_type"));
            }
            result = this.applyInputOutDownInvoice(null, null, invoiceType, logObj.getString("inout"), logObj.getLong("org"), logObj.getString("tax_no"), logObj.getDate("invoice_startdate"), logObj.getDate("invoice_enddate"));
        }
        catch (Exception e) {
            LOGGER.error("\u91cd\u65b0\u7533\u8bf7\u5931\u8d25", (Throwable)e);
            result = ResultContant.createJSONObject("0201", ResManager.loadKDString((String)"\u5168\u91cf\u4e0b\u8f7d-\u91cd\u65b0\u7533\u8bf7\u5931\u8d25", (String)"InputOutInvoiceApplyService_1", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        return result;
    }

    public void applyCurrentData(DynamicObject initDynamicObject, String invoiceType, String dataType, Long orgId, String taxNo) {
        Calendar cal = Calendar.getInstance();
        Date dateNow = new Date();
        String downDate = RimConfigUtils.getConfig("down_date");
        if (StringUtil.isNotEmpty((CharSequence)downDate)) {
            dateNow = DateUtils.stringToDate(downDate);
        }
        Date lastDate = DateUtils.getLastDateOfMonth(dateNow);
        if (Objects.equals(DateUtils.format(dateNow), DateUtils.format(lastDate))) {
            return;
        }
        cal.setTime(dateNow);
        Date firstDay = DateUtils.getFirstDateOfMonth(dateNow);
        int day = cal.get(5);
        Date endDate = null;
        String[] downFrequencyArray = "5;10;15;20;26".split(";");
        String downFrequency = initDynamicObject.getString("down_frequency");
        String downFrequencyConfig = RimConfigUtils.getConfig("rim_deduction", "down_frequency");
        if (StringUtils.isNotEmpty((CharSequence)downFrequencyConfig) && downFrequencyConfig.contains(";")) {
            downFrequency = downFrequencyConfig;
        }
        if (StringUtils.isNotEmpty((CharSequence)downFrequency)) {
            downFrequencyArray = StringUtils.contains((CharSequence)downFrequency, (CharSequence)",") ? downFrequency.split(",") : downFrequency.split(";");
        }
        ArrayList frequencyList = Lists.newArrayList();
        for (String frequency : downFrequencyArray) {
            if ("-1".equals(frequency)) {
                Date date1 = DateUtils.getLastDateOfMonth(dateNow);
                Calendar cal1 = Calendar.getInstance();
                cal1.setTime(date1);
                frequencyList.add(cal1.get(5) - 1);
                continue;
            }
            try {
                frequencyList.add(Integer.parseInt(frequency));
            }
            catch (NumberFormatException date1) {
                // empty catch block
            }
        }
        if (frequencyList.size() >= 5) {
            if (day < (Integer)frequencyList.get(0)) {
                return;
            }
            int index = 0;
            if (day >= (Integer)frequencyList.get(0) && day < (Integer)frequencyList.get(1)) {
                index = 1;
                endDate = DateUtils.addDay(firstDay, (Integer)frequencyList.get(0) - 1);
            } else if (day >= (Integer)frequencyList.get(1) && day < (Integer)frequencyList.get(2)) {
                index = 2;
                endDate = DateUtils.addDay(firstDay, (Integer)frequencyList.get(1) - 1);
            } else if (day >= (Integer)frequencyList.get(2) && day < (Integer)frequencyList.get(3)) {
                index = 3;
                endDate = DateUtils.addDay(firstDay, (Integer)frequencyList.get(2) - 1);
            } else if (day >= (Integer)frequencyList.get(3) && day < (Integer)frequencyList.get(4)) {
                index = 4;
                endDate = DateUtils.addDay(firstDay, (Integer)frequencyList.get(3) - 1);
            } else if (day >= (Integer)frequencyList.get(4)) {
                index = 5;
                endDate = DateUtils.addDay(firstDay, (Integer)frequencyList.get(4) - 1);
            }
            if (endDate != null) {
                Pair<DynamicObject, Integer> logDynamicObjectPair = this.getLogDynamicObject(taxNo, invoiceType, dataType, "2", firstDay, endDate);
                DynamicObject logDynamicObject = (DynamicObject)logDynamicObjectPair.getLeft();
                Integer count = (Integer)logDynamicObjectPair.getRight();
                if (index <= count) {
                    return;
                }
                if (logDynamicObject != null) {
                    Date downEndDate = logDynamicObject.getDate("invoice_enddate");
                    Date applyDate = logDynamicObject.getDate("apply_date");
                    Calendar applyDateCal = Calendar.getInstance();
                    applyDateCal.setTime(applyDate);
                    int applyDays = applyDateCal.get(6);
                    int nowDays = cal.get(6);
                    int applyYear = applyDateCal.get(1);
                    int nowYear = cal.get(1);
                    if (downEndDate.before(endDate) && (nowYear > applyYear || nowDays - applyDays > 1)) {
                        this.applyInputOutDownInvoice(null, initDynamicObject, invoiceType, dataType, orgId, taxNo, firstDay, endDate);
                    }
                } else {
                    this.applyInputOutDownInvoice(null, initDynamicObject, invoiceType, dataType, orgId, taxNo, firstDay, endDate);
                }
            }
        } else {
            LOGGER.info("\u4e0b\u8f7d\u9891\u7387\u914d\u7f6e\u9519\u8bef:{},{}", (Object)taxNo, (Object)downFrequency);
        }
    }

    public Pair<DynamicObject, Integer> getLogDynamicObject(String taxNo, String invoiceType, String dataType, String syncType, Date startDate, Date endDate) {
        DynamicObjectCollection collection = this.queryLogDynamicObject(taxNo, invoiceType, dataType, syncType, startDate, endDate);
        if (!CollectionUtils.isEmpty((Collection)collection)) {
            Set tasknoSet = collection.stream().map(s -> s.getString("taskno")).collect(Collectors.toSet());
            return Pair.of((Object)collection.get(0), (Object)tasknoSet.size());
        }
        return Pair.of(null, (Object)0);
    }

    public DynamicObjectCollection queryLogDynamicObject(String taxNo, String invoiceType, String dataType, String syncType, Date startDate, Date endDate) {
        QFilter awsTypeFilter = null;
        QFilter invoiceTypeFilter = null;
        String dkType = DeductionConstant.getDkType(taxNo);
        dkType = InvoiceDownloadConstant.convertLqCollect(taxNo, dkType);
        if (StringUtils.isNotEmpty((CharSequence)invoiceType) && (!"4".equals(dkType) || InputInvoiceTypeEnum.HGJKS.getAwsType().equals(invoiceType))) {
            Long invoiceTypeLong = InvoiceDownloadConstant.getInvoiceTypeByAwsType(invoiceType);
            if (InvoiceDownloadConstant.isElectricPaper(invoiceType)) {
                awsTypeFilter = new QFilter("aws_invoice_type", "=", (Object)invoiceType);
            } else if (InputInvoiceTypeEnum.SPECIAL_PAPER.getAwsType().equals(invoiceType)) {
                awsTypeFilter = new QFilter("aws_invoice_type", "!=", (Object)"85");
            } else if (InputInvoiceTypeEnum.ORDINARY_PAPER.getAwsType().equals(invoiceType)) {
                awsTypeFilter = new QFilter("aws_invoice_type", "!=", (Object)"86");
            } else if (InputInvoiceTypeEnum.MOTOR_INVOICE.getAwsType().equals(invoiceType)) {
                awsTypeFilter = new QFilter("aws_invoice_type", "!=", (Object)"87");
            } else if (InputInvoiceTypeEnum.USEDCAR_INVOICE.getAwsType().equals(invoiceType)) {
                awsTypeFilter = new QFilter("aws_invoice_type", "!=", (Object)"88");
            }
            invoiceTypeFilter = new QFilter("invoice_type", "=", (Object)invoiceTypeLong);
        }
        QFilter dataTypeFilter = new QFilter("inout", "=", (Object)dataType);
        QFilter taxNoFilter = new QFilter("tax_no", "=", (Object)taxNo);
        QFilter startFilter = null;
        QFilter endFilter = null;
        QFilter syncTypeFilter = null;
        if ("2".equals(syncType)) {
            startFilter = new QFilter("invoice_startdate", ">=", (Object)startDate);
            endFilter = new QFilter("invoice_enddate", "<=", (Object)DateUtils.getLastDateOfMonth(endDate));
            syncTypeFilter = new QFilter("sync_type", "in", (Object)new String[]{"2", "3"});
        } else {
            syncTypeFilter = new QFilter("sync_type", "=", (Object)"3");
            startFilter = new QFilter("invoice_startdate", "=", (Object)startDate);
            endFilter = new QFilter("invoice_enddate", "=", (Object)endDate);
        }
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"rim_down_log", (String)"id,createtime,taskno,invoice_type,gov_status,invoice_startdate,invoice_enddate,download_errcode,apply_date,aws_invoice_type", (QFilter[])new QFilter[]{invoiceTypeFilter, dataTypeFilter, taxNoFilter, startFilter, endFilter, awsTypeFilter, syncTypeFilter}, (String)"invoice_enddate desc");
        return collection;
    }

    public void replenishApplyLastData(DynamicObject initDynamicObject, List<String> invoiceTypes, String dataType, Long orgId, String taxNo) {
        LOGGER.info("\u5f53\u524d\u53ea\u6709\u4e50\u4f01\u548c\u65b0\u7535\u5b50\u7a0e\u52a1\u5e73\u53f0\u901a\u9053\uff0c\u652f\u6301\u8865\u507f\u4e0b\u8f7d\u4e0a\u4e00\u4e2a\u6708\u7684\u53d1\u7968");
    }

    public abstract JSONObject applyInputOutDownInvoice(Long var1, DynamicObject var2, String var3, String var4, Long var5, String var6, Date var7, Date var8);

    public void dealResult(JSONObject resultJson, DynamicObject initDynamicObject, Long logId, Long orgId, String taxNo) {
        this.dealResult(resultJson, initDynamicObject, logId, orgId, taxNo, null, null);
    }

    public void dealResult(JSONObject resultJson, DynamicObject initDynamicObject, Long logId, Long orgId, String taxNo, String applyInvoiceType, String syncType) {
        if (ResultContant.isSuccess(resultJson).booleanValue()) {
            JSONArray data = resultJson.getJSONArray("data");
            JSONObject datum = data.getJSONObject(0);
            String batchNo = UUID.getBatchNo("DOWN");
            DynamicObject applyData = null;
            if (logId != null) {
                JSONObject jsonObject2;
                applyData = BusinessDataServiceHelper.loadSingle((Object)logId, (String)"rim_down_log");
                String json = applyData.getString("json_tag");
                if (StringUtils.isNotEmpty((CharSequence)json)) {
                    try {
                        jsonObject2 = JSONObject.parseObject((String)json);
                        jsonObject2.put("requestid", applyData.get("requestid"));
                        jsonObject2.put("taskno", applyData.get("taskno"));
                        applyData.set("json_tag", (Object)jsonObject2.toJSONString());
                    }
                    catch (Exception jsonObject2) {}
                } else {
                    jsonObject2 = new JSONObject();
                    jsonObject2.put("requestid", applyData.get("requestid"));
                    jsonObject2.put("taskno", applyData.get("taskno"));
                    applyData.set("json_tag", (Object)jsonObject2.toJSONString());
                }
            } else {
                applyData = BusinessDataServiceHelper.newDynamicObject((String)"rim_down_log");
            }
            applyData.set("createtime", (Object)new Date());
            this.setFileBatchNo(resultJson, logId, applyData);
            String awsType = "";
            awsType = StringUtils.isNotEmpty((CharSequence)datum.getString("invoiceType")) ? datum.getString("invoiceType") : HolytaxInvoiceTypeEnum.getAwsTypeByHolytaxType(datum.getString("fplx"));
            Long invoiceType = InvoiceDownloadConstant.getInvoiceTypeByAwsType(awsType);
            applyData.set("invoice_type", (Object)invoiceType);
            if (StringUtils.isNotEmpty((CharSequence)applyInvoiceType)) {
                applyData.set("aws_invoice_type", (Object)applyInvoiceType);
            } else {
                applyData.set("aws_invoice_type", (Object)awsType);
            }
            String account = resultJson.getString("account");
            if (StringUtils.isNotBlank((CharSequence)account)) {
                applyData.set("account", (Object)account);
            }
            applyData.set("taskno", datum.get((Object)"rwh"));
            Date applyDate = CommonUtils.getJsonValue((Map<String, Object>)datum, Date.class, "sqrq");
            if (applyDate == null) {
                applyDate = new Date();
            }
            applyData.set("apply_date", (Object)applyDate);
            applyData.set("gov_status", (Object)"6");
            applyData.set("apply_step", (Object)1);
            applyData.set("inout", datum.get((Object)"sjlx"));
            applyData.set("requestid", datum.get((Object)"requuid"));
            Date startDate = DateUtils.stringToDate(datum.getString("kprqq"));
            Date endDate = DateUtils.stringToDate(datum.getString("kprqz"));
            applyData.set("invoice_startdate", (Object)startDate);
            applyData.set("invoice_enddate", (Object)endDate);
            if (StringUtils.isEmpty((CharSequence)applyData.getString("batch_no"))) {
                applyData.set("batch_no", (Object)batchNo);
            }
            applyData.set("tax_no", (Object)taxNo);
            applyData.set("org", (Object)orgId);
            applyData.set("download_errcode", (Object)"");
            applyData.set("description", (Object)"");
            if (StringUtils.isNotEmpty((CharSequence)syncType)) {
                applyData.set("sync_type", (Object)syncType);
            } else if (DateUtils.format(new Date(), "yyyyMM").equals(DateUtils.format(startDate, "yyyyMM"))) {
                applyData.set("sync_type", (Object)2);
            } else {
                applyData.set("sync_type", (Object)3);
            }
            applyData.set("modifytime", (Object)new Date());
            if (initDynamicObject != null && (null == initDynamicObject.getDate("end") || initDynamicObject.getDate("end").compareTo(endDate) < 0)) {
                initDynamicObject.set("end", (Object)endDate);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{initDynamicObject});
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{applyData});
            resultJson.put("batchNo", (Object)batchNo);
        }
    }

    public boolean checkCommonReplenishApply(String dataType, String taxNo) {
        if (!"2".equals(dataType) && !"1".equals(dataType)) {
            LOGGER.info("\u4e0b\u8f7d\u7c7b\u578b\u975e\u8fdb\u9879\u3001\u9500\u9879\u5168\u91cf");
            return false;
        }
        String dkType = DeductionConstant.getDkType(taxNo);
        if (!"4".equals(dkType = InvoiceDownloadConstant.convertLqCollect(taxNo, dkType)) && !"5".equals(dkType)) {
            LOGGER.info("\u901a\u9053\u975e\u4e50\u4f01\u3001rpa");
            return false;
        }
        String openReplenishFlag = ImcConfigUtil.getValue("rim_download", "open_replenish_last_month");
        if (!StringUtils.equals((CharSequence)"1", (CharSequence)openReplenishFlag)) {
            LOGGER.info("\u8865\u507f\u5f00\u5173\u672a\u5f00\u542f");
            return false;
        }
        Calendar cal = Calendar.getInstance();
        Date dateNow = new Date();
        String downDate = RimConfigUtils.getConfig("down_date");
        if (StringUtil.isNotEmpty((CharSequence)downDate)) {
            dateNow = DateUtils.stringToDate(downDate);
        }
        cal.setTime(dateNow);
        int day = cal.get(5);
        int repelnishDownDate = InvoiceDownloadConstant.getPageSizeFromConfig(10, "repelnish_down_date");
        int tryDays = InvoiceDownloadConstant.getPageSizeFromConfig(1, "repelnish_try_apply_days");
        String appointDaysStr = RimConfigUtils.getConfig("rim_deduction", "repelnish_appoint_days");
        List<String> appointDays = CommonUtils.getMultiValues(appointDaysStr);
        if (!this.checkDays(day, repelnishDownDate, tryDays, appointDays)) {
            LOGGER.info("\u5f53\u524d\u65e5\u671f\u4e0d\u652f\u6301\u4e0b\u8f7d\uff1a{}", (Object)day);
            return false;
        }
        return true;
    }

    private void setFileBatchNo(JSONObject resultJson, Long logId, DynamicObject applyData) {
        if (resultJson == null || applyData == null) {
            return;
        }
        String fileBatchNo = resultJson.getString("fileBatchNo");
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)fileBatchNo)) {
            String json = applyData.getString("json_tag");
            if (StringUtils.isNotEmpty((CharSequence)json)) {
                try {
                    JSONObject jsonObject = JSONObject.parseObject((String)json);
                    jsonObject.put("fileBatchNo", (Object)fileBatchNo);
                    applyData.set("json_tag", (Object)jsonObject.toJSONString());
                }
                catch (Exception e) {
                    LOGGER.info("rpa\u5168\u91cf\u4e0b\u8f7d--\u5b58\u50a8\u6587\u4ef6\u4e0b\u8f7d\u6279\u6b21\u53f7\u5f02\u5e38, json_tag\u5f02\u5e38\uff0clogId:{}", (Object)logId);
                }
            } else {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("fileBatchNo", (Object)fileBatchNo);
                applyData.set("json_tag", (Object)jsonObject.toJSONString());
            }
        }
    }

    public boolean checkDownCustom(String inout, String invoiceType, String taxNo) {
        if (StringUtils.isEmpty((CharSequence)inout) || StringUtils.isEmpty((CharSequence)invoiceType)) {
            return false;
        }
        if (!"1".equals(inout) && !"2".equals(inout)) {
            return false;
        }
        return (!"2".equals(inout) || !"21".equals(invoiceType) && !"13".equals(invoiceType) && !InputInvoiceTypeEnum.WITHHOLDING.getAwsType().equals(invoiceType) && !InputInvoiceTypeEnum.AIR_ELE_INVOICE.getAwsType().equals(invoiceType) && !InputInvoiceTypeEnum.TRAIN_ELE_INVOICE.getAwsType().equals(invoiceType) && !InputInvoiceTypeEnum.USEDCAR_ELE_INVOICE.getAwsType().equals(invoiceType)) && !"88".equals(invoiceType);
    }

    public Set<String> getNotApplyAwsType(String dataType, String taxNo, Date firstDay, Date endDate, String awsInvoiceType) {
        DynamicObjectCollection logDynamicObjectList = this.queryLogDynamicObject(taxNo, awsInvoiceType, dataType, "3", firstDay, endDate);
        HashSet<String> notApplyAwsTypeSet = new HashSet<String>();
        int downHours = InvoiceDownloadConstant.getPageSizeFromConfig(24, "repelnish_down_hour");
        if (!CollectionUtils.isEmpty((Collection)logDynamicObjectList)) {
            Date now = new Date();
            for (DynamicObject logDynamicObject : logDynamicObjectList) {
                Date createtime;
                if (logDynamicObject == null || (createtime = logDynamicObject.getDate("createtime")) == null) continue;
                boolean isFail = "7".equals(logDynamicObject.getString("gov_status"));
                Date date = DateUtils.addHour(createtime, downHours);
                if (!now.after(createtime) || !now.before(date) || isFail) continue;
                String awsTypeDB = logDynamicObject.getString("aws_invoice_type");
                notApplyAwsTypeSet.addAll(CommonUtils.getMultiValues(awsTypeDB));
            }
        }
        return notApplyAwsTypeSet;
    }

    protected JSONObject convertApplyResult(String rwh, String dataType, String invoiceType, Date begin, Date end) {
        return this.convertApplyResult(rwh, dataType, invoiceType, begin, end, null);
    }

    protected JSONObject convertApplyResult(String rwh, String dataType, String invoiceType, Date begin, Date end, String requuid) {
        JSONArray data = new JSONArray();
        JSONObject applyData = new JSONObject();
        applyData.put("rwh", (Object)rwh);
        applyData.put("requuid", (Object)requuid);
        applyData.put("kprqq", (Object)DateUtils.format(begin));
        applyData.put("sjlx", (Object)dataType);
        applyData.put("invoiceType", (Object)invoiceType);
        applyData.put("kprqz", (Object)DateUtils.format(end));
        data.add((Object)applyData);
        return ResultContant.createSuccessJSONObject(data);
    }
}

