/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.download;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.InvoiceDownloadConstant;
import kd.imc.rim.common.invoice.model.ConvertFieldUtil;
import kd.imc.rim.common.invoice.query.convert.InvoiceConvertService;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DBUtils;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DeductionUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.LqConvertUtil;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.common.utils.TenantUtils;
import kd.imc.rim.common.utils.UUID;
import org.apache.commons.lang3.tuple.Pair;

public abstract class InvoiceDownService {
    private static Log logger = LogFactory.getLog(InvoiceDownService.class);
    protected boolean login = false;
    protected String dkType = "";
    private static final String[] DEDECT_FIELDS = new String[]{"checkFlag", "authenticateFlag", "checkAuthenticateFlag", "scanAuthenticateFlag", "selectTime", "scanAuthenticateTime", "selectAuthenticateTime", "invoiceStatus", "effectiveTaxAmount", "deductionPurpose", "invoiceStatus", "manageStatus", "taxPeriod", "notDeductibleType", "buyerTaxNo", "buyerName", "invoiceSource", "invoiceRiskLevel", "operateTime"};
    private static final String[] AIR_ELE_FIELDS = new String[]{"gngjbz", "gpdh", "sflzfpbz", "kpsxrq", "yxjzrq", "mfxle", "cyr", "hbh", "xm", "zjhm", "qz", "zwdj", "dzkphm", "yzm", "tsxx", "bxf", "xswddh", "tkdw", "sfz", "mdz", "hd", "qfsj", "cyrq", "kpjbkplb"};
    private static final String[] TRAIN_ELE_FIELDS = new String[]{"ywlxmc", "cfz", "ddz", "cccc", "rq", "cfsj1", "tldzkppzmc", "kttz", "xb1", "cx", "xw", "zfje", "ytje", "yppj", "ypcfz", "ypddz", "dzkph"};

    public JSONObject invoiceDown(DynamicObject dynamicObject, RequestContext requestContext) {
        Long orgId = DynamicObjectUtil.getDynamicObjectLongValue(dynamicObject.get("org"));
        return this.invoiceDown(dynamicObject, requestContext, orgId, dynamicObject.getString("tax_no"));
    }

    public abstract JSONObject invoiceDown(DynamicObject var1, RequestContext var2, Long var3, String var4);

    public void applyInvoiceFileNew(DynamicObject downLog, String inout, String taxNo, Long orgId) {
        QFilter inoutFilter;
        if (downLog == null) {
            return;
        }
        String json = downLog.getString("json_tag");
        if (StringUtils.isBlank((CharSequence)json)) {
            return;
        }
        String fileBatchNo = "";
        if (StringUtils.isNotEmpty((CharSequence)json)) {
            try {
                JSONObject jsonObject = JSONObject.parseObject((String)json);
                fileBatchNo = jsonObject.getString("fileBatchNo");
            }
            catch (Exception e) {
                logger.info("\u89e3\u6790json_tag\u51fa\u9519\uff0c\u6279\u6b21\u53f7\uff1a{}", (Object)downLog.getString("batch_no"));
                return;
            }
        }
        if (StringUtils.isBlank((CharSequence)fileBatchNo)) {
            logger.info("\u4e0d\u5b58\u5728\u6570\u7535\u6587\u4ef6\u6279\u6b21\u53f7\uff0c\u4e0d\u9700\u8981\u4e0b\u8f7d\u6587\u4ef6\uff0c\u6279\u6b21\u53f7\uff1a{}", (Object)downLog.getString("batch_no"));
            return;
        }
        try {
            QFilter batchNoFilterLog = new QFilter("taskno", "=", (Object)fileBatchNo);
            boolean exists = QueryServiceHelper.exists((String)"rim_down_log", (QFilter[])new QFilter[]{batchNoFilterLog});
            if (exists) {
                logger.info("\u7533\u8bf7\u65e5\u5fd7\u8868\u5df2\u5b58\u5728\u5bf9\u5e94\u7684\u7533\u8bf7\u4efb\u52a1\u53f7\uff0c\u4e0d\u518d\u91cd\u590d\u7533\u8bf7");
                return;
            }
        }
        catch (Exception e) {
            logger.info("\u5f02\u5e38\uff0c{}", (Object)e);
        }
        String dkType = DeductionConstant.getDkType(taxNo);
        if (!"4".equals(dkType)) {
            return;
        }
        if (!"1".equals(inout) && !"4".equals(inout)) {
            return;
        }
        String batchNo = downLog.getString("batch_no");
        QFilter batchNoFilter = new QFilter("batch_no", "=", (Object)batchNo);
        DynamicObjectCollection accountCollection = QueryServiceHelper.query((String)"rim_down_account", (String)"invoice_code,invoice_no,invoice_date", (QFilter[])new QFilter[]{batchNoFilter, inoutFilter = new QFilter("data_type_tb", "=", (Object)inout)});
        if (CollectionUtils.isEmpty((Collection)accountCollection)) {
            return;
        }
        if (StringUtils.isNotEmpty((CharSequence)fileBatchNo)) {
            String applyBatchNo = this.getDownBatchNo();
            Long invoiceType = DynamicObjectUtil.getDynamicObjectLongValue(downLog.get("invoice_type"));
            DynamicObject fileLog = this.getDownLogDynamicObject(applyBatchNo, fileBatchNo, orgId, taxNo, 0, downLog.getString("sync_type"), invoiceType);
            fileLog.set("gov_status", (Object)"6");
            fileLog.set("download_errcode", (Object)"0");
            String awsInvoiceType = downLog.getString("aws_invoice_type");
            String awsType = InputInvoiceTypeEnum.getAwsType(invoiceType);
            if (StringUtils.isNotBlank((CharSequence)awsInvoiceType) && invoiceType <= 0L) {
                List<String> awsTypeList = CommonUtils.getMultiValues(awsInvoiceType);
                HashSet eleInvocieSet = Sets.newHashSet((Object[])new String[]{"26", "27", "28", "29"});
                awsTypeList = awsTypeList.stream().filter(t -> eleInvocieSet.contains(t)).collect(Collectors.toList());
                awsType = String.join((CharSequence)",", awsTypeList);
            }
            fileLog.set("aws_invoice_type", (Object)awsType);
            String inout2 = "2".equals(inout) ? "8" : "7";
            fileLog.set("inout", (Object)inout2);
            fileLog.set("apply_step", (Object)1);
            fileLog.set("invoice_startdate", downLog.get("invoice_startdate"));
            fileLog.set("invoice_enddate", downLog.get("invoice_enddate"));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{fileLog});
        }
    }

    public boolean isDownFile(String taxNo) {
        String cacheKey = "down_file_taxno_key" + taxNo;
        String cacheValue = CacheHelper.get(cacheKey);
        if (StringUtils.isNotEmpty((CharSequence)cacheValue)) {
            return "true".equals(cacheValue);
        }
        QFilter qFilter = new QFilter("userorg.taxpayer_tax_no", "=", (Object)taxNo);
        DynamicObject downInitObj = QueryServiceHelper.queryOne((String)"rim_down_init", (String)"down_file", (QFilter[])qFilter.toArray());
        if (downInitObj == null) {
            return false;
        }
        boolean isDownFile = downInitObj.getBoolean("down_file");
        int mins = InvoiceDownloadConstant.getPageSizeFromConfig(60, "down_file_mins");
        CacheHelper.put(cacheKey, String.valueOf(isDownFile), mins * 60);
        return isDownFile;
    }

    public boolean checkOffFlag(String type, String taxNo) {
        String offFlag = RimConfigUtils.getConfig("rim_deduction", "down_off_flag_" + type);
        if ("1".equals(offFlag)) {
            logger.info("\u4e0b\u8f7d\u5df2\u914d\u7f6e\u5173\u95ed,\u8bf7\u91cd\u65b0\u914d\u7f6e" + type);
            return true;
        }
        String downOffTaxnos = RimConfigUtils.getConfig("rim_deduction", "down_off_taxnos");
        boolean isDownOff = StringUtils.contains((CharSequence)downOffTaxnos, (CharSequence)taxNo);
        if (isDownOff) {
            logger.info("\u7a0e\u53f7{}\u5df2\u5173\u95ed\u4e0b\u8f7d,\u8bf7\u91cd\u65b0\u914d\u7f6e", (Object)taxNo);
        }
        return isDownOff;
    }

    public void insertHeaderSyncAccount(DynamicObject downLog, Date startDate, JSONArray dataArray) {
        String batchNo = downLog.getString("batch_no");
        String taxNo = downLog.getString("tax_no");
        Long orgId = DynamicObjectUtil.getDynamicObjectLongValue(downLog.get("org"));
        ArrayList<DynamicObject> syncAccountList = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> syncInputTplList = new ArrayList<DynamicObject>(16);
        String addFlag = RimConfigUtils.getConfig("rim_deduction", "add_buyer_info");
        String companyName = TenantUtils.getCompanyNameByTaxNo(taxNo);
        Integer totalNum = 0;
        for (int i = 0; i < dataArray.size(); ++i) {
            JSONObject invoice = dataArray.getJSONObject(i);
            DeductionUtils.addBuyerInfo(invoice, taxNo, companyName, addFlag);
            if (ObjectUtils.isEmpty((Object)invoice.get((Object)"totalAmount"))) {
                BigDecimal totalAmount = BigDecimalUtil.transDecimal(invoice.get((Object)"invoiceAmount")).add(BigDecimalUtil.transDecimal(invoice.get((Object)"totalTaxAmount")));
                invoice.put("totalAmount", (Object)totalAmount);
            }
            DynamicObject account = this.getAccountDynamicObject(invoice, batchNo, "2", "1", startDate, orgId);
            syncAccountList.add(account);
            DynamicObject inputTpl = this.getInputTplDynamicObject(invoice, "1", "1", orgId);
            syncInputTplList.add(inputTpl);
            Integer n = totalNum;
            Integer n2 = totalNum = Integer.valueOf(totalNum + 1);
        }
        if (!CollectionUtils.isEmpty(syncAccountList)) {
            downLog.set("total_num", (Object)totalNum);
            try (TXHandle h = TX.required();){
                try {
                    SaveServiceHelper.save((DynamicObject[])syncAccountList.toArray(new DynamicObject[syncAccountList.size()]));
                    SaveServiceHelper.save((DynamicObject[])syncInputTplList.toArray(new DynamicObject[syncInputTplList.size()]));
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{downLog});
                }
                catch (Throwable e) {
                    h.markRollback();
                    throw e;
                }
            }
        }
    }

    public void insertInputOutDataSyncLog(DynamicObject downLog, JSONObject dataJson, String inout) {
        this.insertInputOutDataToTmp(downLog, dataJson, inout, 0);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{downLog});
    }

    public void insertInputOutDataToTmp(DynamicObject downLog, JSONObject dataJson, String inout, int totalNum) {
        this.insertInputOutDataToTmp(downLog, dataJson, inout, totalNum, "5", "3");
    }

    public void insertInputOutDataToTmp(DynamicObject downLog, JSONObject dataJson, String inout, int totalNum, String status, String dataType) {
        JSONArray fullDataArray = dataJson.getJSONArray("data");
        JSONArray unFinishDataArray = dataJson.getJSONArray("unFinishData");
        String batchNo = downLog.getString("batch_no");
        Long orgId = DynamicObjectUtil.getDynamicObjectLongValue(downLog.get("org"));
        Long invoiceType = DynamicObjectUtil.getDynamicObjectLongValue(downLog.get("invoice_type"));
        if (!CollectionUtils.isEmpty((Collection)fullDataArray)) {
            downLog.set("gov_status", (Object)"8");
            totalNum += fullDataArray.size();
            this.addInvoiceType(invoiceType, dataType, fullDataArray);
            this.insertSyncInputOutDataAccount(fullDataArray, batchNo, status, dataType, orgId, inout);
        }
        if (!CollectionUtils.isEmpty((Collection)unFinishDataArray)) {
            totalNum += unFinishDataArray.size();
            this.addInvoiceType(invoiceType, dataType, unFinishDataArray);
            this.insertSyncInputOutDataAccount(unFinishDataArray, batchNo, "4", "2", orgId, inout);
            downLog.set("gov_status", (Object)"2");
        }
        downLog.set("total_num", (Object)totalNum);
        downLog.set("modifytime", (Object)new Date());
    }

    public void addInvoiceType(Long invoiceType, String dataType, JSONArray invoices) {
        if (!"4".equals(dataType) || CollectionUtils.isEmpty((Collection)invoices)) {
            return;
        }
        String awsType = InputInvoiceTypeEnum.getAwsType(invoiceType);
        for (int i = 0; i < invoices.size(); ++i) {
            invoices.getJSONObject(i).put("invoiceType", (Object)awsType);
        }
    }

    public void insertSyncInputOutDataAccount(JSONArray dataArray, String batchNo, String status, String dataType, Long orgId, String inout) {
        this.insertSyncInputOutDataAccount(dataArray, batchNo, status, dataType, orgId, inout, null);
    }

    public void insertSyncInputOutDataAccount(JSONArray dataArray, String batchNo, String status, String dataType, Long orgId, String inout, DynamicObject downLog) {
        ArrayList<DynamicObject> syncAccountList = new ArrayList<DynamicObject>(8);
        ArrayList<DynamicObject> syncInputTplList = new ArrayList<DynamicObject>(8);
        ArrayList<DynamicObject> purposeList = new ArrayList<DynamicObject>(8);
        String downType = "";
        String taxNo = "";
        if (downLog != null) {
            downType = downLog.getString("inout");
            taxNo = downLog.getString("tax_no");
        }
        boolean flag = InvoiceDownloadConstant.isNotQueryLqStatus(taxNo);
        boolean downPurpose = "5".equals(this.dkType) && !flag && ("1".equals(downType) || "2".equals(downType) || "4".equals(downType));
        for (int i = 0; i < dataArray.size(); ++i) {
            JSONObject invoice = dataArray.getJSONObject(i);
            if (ObjectUtils.isEmpty((Object)invoice)) continue;
            String invoiceStatus = invoice.getString("invoiceStatus");
            Long invoiceType = InputInvoiceTypeEnum.getInvoiceTypeByAwsType(invoice.getString("invoiceType"));
            if (downPurpose && "0".equals(invoiceStatus) && !InputInvoiceTypeEnum.WITHHOLDING.getCode().equals(invoiceType) && !InputInvoiceTypeEnum.HGJKS.getCode().equals(invoiceType)) {
                DynamicObject lqPurposeObj = this.getLqPurposeObj(invoice, invoiceType, orgId, taxNo, inout);
                purposeList.add(lqPurposeObj);
            }
            Pair<String, String> statusPair = this.checkunFinishStatus(inout, status, dataType, invoice);
            DynamicObject account = this.getAccountDynamicObject(invoice, batchNo, (String)statusPair.getLeft(), inout, null, orgId);
            syncAccountList.add(account);
            DynamicObject inputTpl = this.getInputTplDynamicObject(invoice, inout, (String)statusPair.getRight(), orgId);
            syncInputTplList.add(inputTpl);
        }
        if (!CollectionUtils.isEmpty(syncAccountList)) {
            try (TXHandle h = TX.required();){
                try {
                    SaveServiceHelper.save((DynamicObject[])syncAccountList.toArray(new DynamicObject[syncAccountList.size()]));
                    SaveServiceHelper.save((DynamicObject[])syncInputTplList.toArray(new DynamicObject[syncInputTplList.size()]));
                    if (!CollectionUtils.isEmpty(purposeList)) {
                        SaveServiceHelper.save((DynamicObject[])purposeList.toArray(new DynamicObject[purposeList.size()]));
                    }
                }
                catch (Throwable e) {
                    h.markRollback();
                    throw e;
                }
            }
        }
    }

    private DynamicObject getLqPurposeObj(JSONObject invoice, Long invoiceType, Long orgId, String taxNo, String inout) {
        DynamicObject leqiPurpose = BusinessDataServiceHelper.newDynamicObject((String)"rim_leqi_purpose");
        leqiPurpose.set("org", (Object)orgId);
        leqiPurpose.set("handle_status", (Object)"0");
        leqiPurpose.set("invoice_date", (Object)invoice.getDate("invoiceDate"));
        leqiPurpose.set("invoice_code", (Object)invoice.getString("invoiceCode"));
        leqiPurpose.set("invoice_no", (Object)invoice.getString("invoiceNo"));
        leqiPurpose.set("inout", (Object)inout);
        leqiPurpose.set("invoice_type", (Object)invoiceType);
        leqiPurpose.set("electronic_no", (Object)invoice.getString("etaxInvoiceNo"));
        leqiPurpose.set("buyer_tax_no", (Object)taxNo);
        leqiPurpose.set("handle_num", (Object)0);
        leqiPurpose.set("operate_type", (Object)"2");
        return leqiPurpose;
    }

    private Pair<String, String> checkunFinishStatus(String inout, String status, String dataType, JSONObject invoice) {
        if (!("1".equals(inout) && "4".equals(status) && "2".equals(dataType))) {
            return Pair.of((Object)status, (Object)dataType);
        }
        Long invoiceType = InputInvoiceTypeEnum.getInvoiceTypeByAwsType(invoice.getString("invoiceType"));
        if (!InputInvoiceTypeEnum.canDeduction(invoiceType).booleanValue()) {
            return Pair.of((Object)status, (Object)dataType);
        }
        String flag = DeductionConstant.canBeDeductionForTaxInvoiceByInv(invoice);
        if (!"1".equals(flag)) {
            return Pair.of((Object)"5", (Object)"3");
        }
        return Pair.of((Object)status, (Object)dataType);
    }

    public DynamicObject getInputTplDynamicObject(JSONObject invoice, String inout, String dataType, Long orgId) {
        Long invoiceType = InputInvoiceTypeEnum.getInvoiceTypeByAwsType(invoice.getString("invoiceType"));
        String invoiceCode = invoice.getString("invoiceCode");
        String invoiceNo = CommonUtils.getJsonValue((Map<String, Object>)invoice, String.class, "invoiceNo", "jkshm", "customDeclarationNo");
        String serialNo = CommonUtils.getInvoiceCodeNoGroup(invoiceCode, invoiceNo);
        Date invoiceDate = invoice.getDate("invoiceDate");
        if (InputInvoiceTypeEnum.WITHHOLDING.getCode().equals(invoiceType)) {
            serialNo = serialNo + DateUtils.format(invoiceDate, "yyyyMMdd");
        }
        QFilter serialNoFilter = new QFilter("serial_no", "=", (Object)serialNo);
        QFilter dataTypeFilter = new QFilter("inout", "=", (Object)inout);
        QFilter invoiceTypeFilter = new QFilter("invoice_type", "=", (Object)invoiceType);
        DynamicObject inputTplObject = null;
        DynamicObjectCollection inputTplObjects = QueryServiceHelper.query((String)"rim_down_input", (String)"id", (QFilter[])new QFilter[]{serialNoFilter, dataTypeFilter, invoiceTypeFilter}, (String)"createtime");
        if (!CollectionUtils.isEmpty((Collection)inputTplObjects)) {
            inputTplObject = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)inputTplObjects.get(0)).get("id"), (String)"rim_down_input");
            JSONObject oldJson = JSONObject.parseObject((String)inputTplObject.getString("invoice_json_tag"));
            String syncStatus = inputTplObject.getString("sync_status");
            String oldDataType = inputTplObject.getString("data_type");
            String oldfpySerialNo = inputTplObject.getString("fpy_serial_no");
            if ("1".equals(inout) && !"1".equals(syncStatus)) {
                if ("1".equals(oldDataType)) {
                    if ("2".equals(dataType)) {
                        this.updateNewDeductData(invoice, oldJson);
                    } else {
                        this.updateInvoiceStatus(invoice, oldJson);
                    }
                } else if ("2".equals(oldDataType)) {
                    this.updateNewDeductData(oldJson, invoice);
                    invoice = oldJson;
                    if (!"2".equals(dataType)) {
                        dataType = "3";
                    }
                } else {
                    if ("1".equals(dataType)) {
                        this.updateNewDeductData(oldJson, invoice);
                        invoice = oldJson;
                    } else if ("2".equals(dataType)) {
                        this.updateNewDeductData(invoice, oldJson);
                    }
                    dataType = "3";
                }
            }
            if (inputTplObjects.size() > 1) {
                List<Object> ids = inputTplObjects.stream().map(s -> s.get("id")).collect(Collectors.toList());
                ids.remove(inputTplObject.get("id"));
                DBUtils.deleteByIds("rim_down_input", ids);
            }
        } else {
            inputTplObject = BusinessDataServiceHelper.newDynamicObject((String)"rim_down_input");
        }
        inputTplObject.set("serial_no", (Object)serialNo);
        inputTplObject.set("org", (Object)orgId);
        inputTplObject.set("invoice_type", (Object)invoiceType);
        inputTplObject.set("data_type", (Object)dataType);
        inputTplObject.set("inout", (Object)inout);
        inputTplObject.set("handle_num", (Object)0);
        inputTplObject.set("sync_status", (Object)"2");
        if ("1".equals(inout)) {
            invoice.remove((Object)"cipherArea");
        }
        inputTplObject.set("invoice_json_tag", (Object)invoice.toString());
        if (inputTplObject.getDate("createtime") == null) {
            inputTplObject.set("createtime", (Object)new Date());
        }
        inputTplObject.set("modifytime", (Object)new Date());
        return inputTplObject;
    }

    public void updateInvoiceStatus(JSONObject invoiceTag, JSONObject invoiceSrc) {
        if (invoiceTag == null || invoiceSrc == null) {
            return;
        }
        String downResourceTag = invoiceTag.getString("downResource");
        String downResourceSrc = invoiceSrc.getString("downResource");
        if ("inputHeader".equals(downResourceSrc) || "inputInit".equals(downResourceSrc)) {
            CommonUtils.copyData(invoiceTag, invoiceSrc, "invoiceStatus", "invoiceRiskLevel", "invoiceSource");
            if ("inputInit".equals(downResourceSrc)) {
                CommonUtils.copyData(invoiceTag, invoiceSrc, "authenticateFlag", "effectiveTaxAmount");
            }
        }
    }

    public void updateNewDeductData(JSONObject invoiceTag, JSONObject invoiceNew) {
        CommonUtils.copyData(invoiceTag, invoiceNew, DEDECT_FIELDS);
    }

    public DynamicObject getAccountDynamicObject(JSONObject invoice, String batchNo, String status, String inout, Date startDate, Long orgId) {
        DynamicObject accountObject = null;
        Long invoiceType = InputInvoiceTypeEnum.getInvoiceTypeByAwsType(invoice.getString("invoiceType"));
        String invoiceCode = invoice.getString("invoiceCode");
        String invoiceNo = CommonUtils.getJsonValue((Map<String, Object>)invoice, String.class, "invoiceNo", "jkshm", "customDeclarationNo");
        String serialNo = CommonUtils.getInvoiceCodeNoGroup(invoiceCode, invoiceNo);
        Date invoiceDate = invoice.getDate("invoiceDate");
        QFilter invoiceDateFilter = null;
        if (InputInvoiceTypeEnum.WITHHOLDING.getCode().equals(invoiceType) && invoiceDate != null) {
            invoiceDate = DateUtils.trunc(invoiceDate);
            serialNo = serialNo + DateUtils.format(invoiceDate, "yyyyMMdd");
            invoiceDateFilter = new QFilter("invoice_date", ">=", (Object)invoiceDate);
            invoiceDateFilter.and("invoice_date", "<", (Object)DateUtils.addDay(invoiceDate, 1));
        }
        QFilter batchNoFilter = new QFilter("batch_no", "=", (Object)batchNo);
        QFilter serialNoFilter = new QFilter("serial_no", "=", (Object)serialNo);
        QFilter dataTypeFilter = new QFilter("data_type_tb", "=", (Object)inout);
        QFilter invoiceTypeFilter = new QFilter("invoice_type", "=", (Object)invoiceType);
        accountObject = QueryServiceHelper.queryOne((String)"rim_down_account", (String)"id", (QFilter[])new QFilter[]{batchNoFilter, serialNoFilter, dataTypeFilter, invoiceTypeFilter, invoiceDateFilter, invoiceDateFilter});
        accountObject = accountObject != null ? BusinessDataServiceHelper.loadSingle((Object)accountObject.get("id"), (String)"rim_down_account") : BusinessDataServiceHelper.newDynamicObject((String)"rim_down_account");
        accountObject.set("org", (Object)orgId);
        accountObject.set("batch_no", (Object)batchNo);
        accountObject.set("serial_no", (Object)serialNo);
        accountObject.set("data_type_tb", (Object)inout);
        accountObject.set("invoice_type", (Object)invoiceType);
        accountObject.set("invoice_code", (Object)invoiceCode);
        accountObject.set("invoice_no", (Object)invoiceNo);
        Object date = invoice.get((Object)"invoiceDate");
        if (date instanceof Long) {
            accountObject.set("invoice_date", (Object)new Date((Long)date));
        } else {
            accountObject.set("invoice_date", (Object)invoice.getDate("invoiceDate"));
        }
        accountObject.set("invoice_amount", (Object)BigDecimalUtil.transDecimal(invoice.get((Object)"invoiceAmount")));
        BigDecimal totalTaxAmount = BigDecimalUtil.transDecimal(invoice.get((Object)"totalTaxAmount"));
        if (BigDecimal.ZERO.compareTo(totalTaxAmount) == 0) {
            totalTaxAmount = BigDecimalUtil.transDecimal(invoice.get((Object)"skje"));
        }
        accountObject.set("tax_amount", (Object)totalTaxAmount);
        String invoiceStatus = invoice.getString("invoiceStatus");
        accountObject.set("invoice_status", (Object)invoiceStatus);
        accountObject.set("invoice_source", (Object)DeductionUtils.convertInvoiceSource(invoice.getString("invoiceSource")));
        accountObject.set("invoice_risk_level", (Object)DeductionUtils.convertInvoiceRiskLevel(invoice.getString("invoiceRiskLevel")));
        accountObject.set("status", (Object)status);
        if ("1".equals(inout)) {
            accountObject.set("effective_tax_amount", (Object)invoice.getBigDecimal("effectiveTaxAmount"));
            accountObject.set("authenticate_flag", (Object)"0");
            if (StringUtils.isNotEmpty((CharSequence)invoice.getString("checkFlag")) && "1".equals(invoice.getString("checkFlag"))) {
                accountObject.set("authenticate_flag", (Object)"1");
            }
            if (StringUtils.isNotEmpty((CharSequence)invoice.getString("checkAuthenticateFlag")) && "1".equals(invoice.getString("checkAuthenticateFlag"))) {
                accountObject.set("authenticate_flag", (Object)"2");
            }
            if (StringUtils.isNotEmpty((CharSequence)invoice.getString("scanAuthenticateFlag")) && "1".equals(invoice.getString("scanAuthenticateFlag"))) {
                accountObject.set("authenticate_flag", (Object)"3");
            }
            if (StringUtils.isNotEmpty((CharSequence)invoice.getString("authenticateFlag"))) {
                accountObject.set("authenticate_flag", (Object)invoice.getString("authenticateFlag"));
            }
            accountObject.set("select_time", StringUtils.isEmpty((CharSequence)invoice.getString("selectTime")) ? null : DateUtils.stringToDate(invoice.getString("selectTime"), "yyyy-MM-dd"));
            accountObject.set("select_authenticate_time", StringUtils.isEmpty((CharSequence)invoice.getString("selectAuthenticateTime")) ? null : DateUtils.stringToDate(invoice.getString("selectAuthenticateTime")));
            accountObject.set("scan_authenticate_time", StringUtils.isEmpty((CharSequence)invoice.getString("scanAuthenticateTime")) ? null : DateUtils.stringToDate(invoice.getString("scanAuthenticateTime")));
            accountObject.set("tax_period", StringUtils.isEmpty((CharSequence)invoice.getString("taxPeriod")) ? null : DateUtils.stringToDate(invoice.getString("taxPeriod"), "yyyyMM"));
            String deductionPurpose = invoice.getString("deductionPurpose");
            accountObject.set("deduction_purpose", (Object)deductionPurpose);
            if ("2".equals(deductionPurpose)) {
                accountObject.set("not_deductible_type", (Object)invoice.getString("notDeductibleType"));
            }
            accountObject.set("manage_status", (Object)invoice.getString("manageStatus"));
            if ("2".equals(status) && startDate != null) {
                String taxPeriod = invoice.getString("taxPeriod");
                if (Integer.parseInt(accountObject.getString("authenticate_flag")) > 1 && StringUtils.isNotEmpty((CharSequence)taxPeriod) && DateUtils.isOverdue(DateUtils.stringToDate(taxPeriod, "yyyyMM"), startDate)) {
                    accountObject.set("status", (Object)"3");
                }
            }
        } else if ("9".equals(inout)) {
            accountObject.set("effective_tax_amount", (Object)invoice.getBigDecimal("effectiveTaxAmount"));
        } else if ("8".equals(inout)) {
            // empty if block
        }
        if (accountObject.getDate("createtime") == null) {
            accountObject.set("createtime", (Object)new Date());
        }
        accountObject.set("modifytime", (Object)new Date());
        return accountObject;
    }

    public JSONObject downLoadInvoices(JSONObject bodyParam, Long orgId) {
        return null;
    }

    public String getDownBatchNo() {
        return UUID.getBatchNo("DOWN");
    }

    public DynamicObject getDownLogDynamicObject(String batchNo, String taskNo, Long orgId, String taxNo, Integer totalNum, String syncType) {
        return this.getDownLogDynamicObject(batchNo, taskNo, orgId, taxNo, totalNum, syncType, 0L);
    }

    public DynamicObject getDownLogDynamicObject(String batchNo, String taskNo, Long orgId, String taxNo, Integer totalNum, String syncType, Long invoiceType) {
        DynamicObject downLogDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"rim_down_log");
        downLogDynamicObject.set("batch_no", (Object)batchNo);
        downLogDynamicObject.set("taskno", (Object)taskNo);
        downLogDynamicObject.set("org", (Object)orgId);
        downLogDynamicObject.set("tax_no", (Object)taxNo);
        downLogDynamicObject.set("sync_type", (Object)syncType);
        downLogDynamicObject.set("invoice_type", (Object)invoiceType);
        downLogDynamicObject.set("gov_status", (Object)"3");
        downLogDynamicObject.set("inout", (Object)"3");
        downLogDynamicObject.set("total_num", (Object)totalNum);
        downLogDynamicObject.set("apply_date", (Object)new Date());
        downLogDynamicObject.set("createtime", (Object)new Date());
        downLogDynamicObject.set("modifytime", (Object)new Date());
        return downLogDynamicObject;
    }

    public String getLockKey(Object lockKey) {
        return "rim.collectinvoicedata-" + lockKey;
    }

    public void setDescription(DynamicObject downLog, JSONObject resultJson) {
        if (resultJson != null) {
            String description = resultJson.getString("description");
            this.setDescription(downLog, description);
        }
    }

    public void setDescription(DynamicObject downLog, String description) {
        if (StringUtils.isNotEmpty((CharSequence)description) && description.length() > 100) {
            description = description.substring(0, 100);
        }
        downLog.set("description", (Object)description);
    }

    protected void cacheLoginFail(String loginKey, int failTimes) {
        int loginFailTimes = InvoiceDownloadConstant.getPageSizeFromConfig(3600, "e_login_fail_times");
        CacheHelper.put(loginKey, String.valueOf(failTimes), loginFailTimes);
    }

    public JSONArray convertLqInvoice(Long invoiceType, String awsType, JSONArray invoiceArray, String inout) {
        JSONArray downData = new JSONArray();
        invoiceArray.forEach(f -> {
            JSONObject lqInvoice = (JSONObject)f;
            if (InvoiceDownloadConstant.isElectricPaper(awsType)) {
                lqInvoice.put("etaxInvoiceNo", lqInvoice.get((Object)"fphm"));
                lqInvoice.remove((Object)"fphm");
            }
            String type = null;
            String fpztbz = CommonUtils.getJsonValue((Map<String, Object>)lqInvoice, String.class, "sflzfp", "fpztbz", "sflzfpbz");
            if ("Y".equalsIgnoreCase(fpztbz) || "0".equals(fpztbz) || "3".equals(fpztbz) || "2".equals(fpztbz)) {
                type = "0";
            } else if ("N".equalsIgnoreCase(fpztbz) || "1".equals(fpztbz) || "4".equals(fpztbz)) {
                type = "1";
            }
            lqInvoice.put("type", (Object)type);
            if (InputInvoiceTypeEnum.AIR_ELE_INVOICE.getCode().equals(invoiceType)) {
                InvoiceDownService.converAirEleInvocie(lqInvoice);
            } else if (InputInvoiceTypeEnum.TRAIN_ELE_INVOICE.getCode().equals(invoiceType)) {
                InvoiceDownService.converTrainEleInvocie(lqInvoice);
            } else if (InputInvoiceTypeEnum.TOLL_ELECTRON.getCode().equals(invoiceType)) {
                InvoiceDownService.convertToll(lqInvoice);
            }
            this.mergeData(lqInvoice, "xhfdz", "xsfdh");
            this.mergeData(lqInvoice, "gmfdz", "gmfdh");
            this.mergeData(lqInvoice, "xsfkhh", "xsfzh");
            this.mergeData(lqInvoice, "gmfkhh", "gmfzh");
            Object entity = ConvertFieldUtil.convertCheckEntityByInvoiceType(invoiceType, lqInvoice, "hwxx");
            JSONObject invoice = JSONObject.parseObject((String)JSONObject.toJSONString((Object)entity));
            invoice.put("invoiceType", (Object)InputInvoiceTypeEnum.getAwsType(invoiceType));
            String specialTypeMark = invoice.getString("specialTypeMark");
            invoice.put("specialTypeMark", (Object)LqConvertUtil.converSpecialTypeMark(specialTypeMark, awsType));
            CommonUtils.copyData(invoice, lqInvoice, "tdyslxDm");
            if ("2".equals(inout)) {
                CommonUtils.copyData(invoice, lqInvoice, "jzfwtdys", "jzfwtdysList", "hwysfwtdysList", "bdcxsfwtdysList", "bdcjyzltdysList", "dsccstdys", "lkysfwtdysList", "ylfwzytdys", "ylfwzytdysList", "ylfwzysftdysList", "ylfwmztdys", "ylfwmztdysList", "tljhlhsgjtdys", "esctdys", "txftdysList");
            }
            downData.add((Object)invoice);
        });
        return downData;
    }

    private void mergeData(JSONObject lqInvoice, String tagKey, String sourceKey) {
        if (lqInvoice == null || StringUtils.isBlank((CharSequence)tagKey) || StringUtils.isBlank((CharSequence)sourceKey)) {
            return;
        }
        String tagValue = lqInvoice.getString(tagKey);
        String sourceValue = lqInvoice.getString(sourceKey);
        if (StringUtils.isNotBlank((CharSequence)tagValue) && StringUtils.isNotBlank((CharSequence)sourceValue)) {
            lqInvoice.put(tagKey, (Object)(tagValue + ' ' + sourceValue));
        }
    }

    public static void converTrainEleInvocie(JSONObject lqInvoice) {
        String ywlxmc;
        JSONArray hwxx;
        if (lqInvoice == null) {
            return;
        }
        JSONObject tdys = lqInvoice.getJSONObject("tdys");
        if (tdys != null) {
            InvoiceConvertService.putAll((Map<String, Object>)lqInvoice, (Map<String, Object>)tdys);
        }
        if (!CollectionUtils.isEmpty((Collection)(hwxx = lqInvoice.getJSONArray("hwxx")))) {
            block6: for (int i = 0; i < hwxx.size(); ++i) {
                JSONObject item = hwxx.getJSONObject(i);
                String xmmc = item.getString("xmmc");
                if (StringUtils.isBlank((CharSequence)xmmc)) continue;
                switch (xmmc) {
                    case "\u7968\u4ef7": {
                        CommonUtils.copyData(lqInvoice, item, "sl1");
                        continue block6;
                    }
                }
            }
        }
        if ("1".equals(ywlxmc = lqInvoice.getString("ywlxmc"))) {
            lqInvoice.put("ywlxmc", (Object)"\u9000");
        } else if ("0".equals(ywlxmc)) {
            lqInvoice.put("ywlxmc", (Object)"\u552e");
        }
    }

    public static void converAirEleInvocie(JSONObject lqInvoice) {
        String gngjbz;
        if (lqInvoice == null) {
            return;
        }
        JSONObject tdys = lqInvoice.getJSONObject("tdys");
        JSONArray hwxx = lqInvoice.getJSONArray("hwxx");
        if (tdys != null) {
            JSONArray tdysmx = tdys.getJSONArray("tdysmx");
            if (!CollectionUtils.isEmpty((Collection)tdysmx)) {
                for (int i = 0; i < tdysmx.size(); ++i) {
                    JSONObject mx = tdysmx.getJSONObject(i);
                    mx.put("qfsj", (Object)InvoiceDownService.getAirTime(mx.getString("qfsj")));
                }
            }
            lqInvoice.put("hwxx", (Object)tdysmx);
            InvoiceConvertService.putAll((Map<String, Object>)lqInvoice, (Map<String, Object>)tdys);
            if (!CollectionUtils.isEmpty((Collection)tdysmx)) {
                InvoiceConvertService.putAll((Map<String, Object>)lqInvoice, (Map<String, Object>)tdysmx.getJSONObject(0));
            }
        }
        String qfsj = lqInvoice.getString("qfsj");
        lqInvoice.put("qfsj", (Object)InvoiceDownService.getAirTime(qfsj));
        BigDecimal ticketPrice = null;
        BigDecimal fuelSurcharge = null;
        BigDecimal airportConstructionFee = null;
        BigDecimal otherTotalTaxAmount = null;
        BigDecimal taxRate = null;
        if (!CollectionUtils.isEmpty((Collection)hwxx)) {
            block13: for (int i = 0; i < hwxx.size(); ++i) {
                JSONObject item = hwxx.getJSONObject(i);
                String xmmc = item.getString("xmmc");
                if (StringUtils.isBlank((CharSequence)xmmc)) continue;
                switch (xmmc) {
                    case "\u7968\u4ef7": {
                        ticketPrice = item.getBigDecimal("je");
                        taxRate = item.getBigDecimal("sl1");
                        continue block13;
                    }
                    case "\u71c3\u6cb9\u9644\u52a0\u8d39": {
                        fuelSurcharge = item.getBigDecimal("je");
                        continue block13;
                    }
                    case "\u6c11\u822a\u53d1\u5c55\u57fa\u91d1": {
                        airportConstructionFee = item.getBigDecimal("je");
                        continue block13;
                    }
                    case "\u5176\u4ed6\u7a0e\u8d39": {
                        otherTotalTaxAmount = item.getBigDecimal("je");
                        continue block13;
                    }
                }
            }
            if (ticketPrice != null) {
                lqInvoice.put("ticketPrice", ticketPrice);
            }
            if (fuelSurcharge != null) {
                lqInvoice.put("fuelSurcharge", fuelSurcharge);
            }
            if (airportConstructionFee != null) {
                lqInvoice.put("airportConstructionFee", airportConstructionFee);
            }
            if (otherTotalTaxAmount != null) {
                lqInvoice.put("otherTotalTaxAmount", otherTotalTaxAmount);
            }
            if (taxRate != null) {
                lqInvoice.put("taxRate", taxRate);
            }
        }
        if ("D".equalsIgnoreCase(gngjbz = lqInvoice.getString("gngjbz"))) {
            lqInvoice.put("gngjbz", (Object)"1");
        } else if ("I".equalsIgnoreCase(gngjbz)) {
            lqInvoice.put("gngjbz", (Object)"2");
        }
    }

    private static String getAirTime(String qfsj) {
        String newTime = qfsj;
        if (!StringUtils.isEmpty((CharSequence)qfsj)) {
            if (qfsj.indexOf(46) != -1) {
                qfsj = qfsj.substring(0, qfsj.indexOf(46));
            }
            if (qfsj.length() > 10) {
                try {
                    Date date = DateUtils.stringToDate(qfsj, "yyyy-MM-dd HH:mm:ss");
                    newTime = DateUtils.format(date, "HH:mm:ss");
                }
                catch (Exception e) {
                    logger.info("\u6570\u7535\u822a\u7a7a\u8d77\u98de\u65e5\u671f\u683c\u5f0f\u9519\u8bef:{}", (Object)e.getMessage());
                }
            }
        }
        return newTime;
    }

    public static void convertToll(JSONObject lqInvoice) {
        JSONArray hwxx = lqInvoice.getJSONArray("hwxx");
        if ("07".equals(lqInvoice.getString("tspz")) && !CollectionUtils.isEmpty((Collection)hwxx)) {
            for (int i = 0; i < hwxx.size(); ++i) {
                hwxx.getJSONObject(i).put("zeroTaxRateFlag", (Object)"2");
            }
        }
    }

    public boolean checkTaskStop(String dkType, JSONObject result) {
        if (StringUtils.isEmpty((CharSequence)dkType) || ObjectUtils.isEmpty((Object)result)) {
            return false;
        }
        String errorCode = result.getString("errcode");
        String errors = RimConfigUtils.getConfig("rim_down", "down_stop_codes_" + dkType);
        if (StringUtils.isNotEmpty((CharSequence)errors) && StringUtils.isNotEmpty((CharSequence)errorCode)) {
            List<String> multiValues = CommonUtils.getMultiValues(errors);
            return multiValues.contains(errorCode);
        }
        return false;
    }

    public void saveFailStatus(DynamicObject downLog, JSONObject resultJson) {
        if (resultJson != null) {
            if (ErrorType.NEED_LOGIN.getCode().equals(resultJson.getString("errcode"))) {
                downLog.set("download_errcode", (Object)"12");
            } else {
                downLog.set("download_errcode", (Object)"16");
            }
            this.setDescription(downLog, resultJson);
            if (this.checkTaskStop(this.dkType, resultJson)) {
                downLog.set("gov_status", (Object)"7");
                downLog.set("download_errcode", (Object)"7");
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{downLog});
        }
    }

    public boolean existTask(String taxNo, Date startDate, Date endDate, long longType, String syncType, boolean rpaAsync) {
        int hours;
        Date date;
        Date createtime;
        QFilter taxFilter = new QFilter("tax_no", "=", (Object)taxNo).and("sync_type", "=", (Object)syncType);
        if (startDate != null) {
            taxFilter.and("invoice_startdate", "=", (Object)startDate);
        }
        if (endDate != null) {
            taxFilter.and("invoice_enddate", "=", (Object)endDate);
        }
        if (longType > 0L) {
            taxFilter.and("invoice_type", "=", (Object)longType);
        } else {
            taxFilter.and("invoice_type", "=", (Object)0L);
        }
        DynamicObjectCollection queryDownLogs = QueryServiceHelper.query((String)"rim_down_log", (String)"id,gov_status,createtime, json_tag", (QFilter[])taxFilter.toArray(), (String)"createtime desc", (int)15);
        if (CollectionUtils.isEmpty((Collection)queryDownLogs)) {
            return false;
        }
        Date nowDate = new Date();
        DynamicObject dynamicObject = null;
        for (DynamicObject queryDownLog : queryDownLogs) {
            if (rpaAsync) {
                String jsonTag = queryDownLog.getString("json_tag");
                if (!kd.imc.rim.common.utils.StringUtils.isNotBlank((CharSequence)jsonTag)) continue;
                try {
                    JSONObject jsonObject = JSONObject.parseObject((String)jsonTag);
                    JSONObject searchOpt = jsonObject.getJSONObject("searchOpt");
                    if (searchOpt == null) continue;
                    if ("8".equals(syncType)) {
                        boolean sameConditionFlag = false;
                        if (InputInvoiceTypeEnum.HGJKS.getCode().equals(longType)) {
                            sameConditionFlag = "0".equals(searchOpt.getString("deductFlag"));
                        } else {
                            boolean bl = sameConditionFlag = "0".equals(searchOpt.getString("deductFlag")) && "-1".equals(searchOpt.getString("invoiceStatus"));
                        }
                        if (sameConditionFlag) {
                            if ("6".equals(queryDownLog.getString("gov_status"))) {
                                return true;
                            }
                            if (dynamicObject == null) {
                                dynamicObject = queryDownLog;
                            }
                        }
                    }
                    if (!"9".equals(syncType) && !"10".equals(syncType) || !"1".equals(searchOpt.getString("deductFlag")) && !"2".equals(searchOpt.getString("deductFlag")) || !"-1".equals(searchOpt.getString("deductionPurpose"))) continue;
                    if ("6".equals(queryDownLog.getString("gov_status"))) {
                        return true;
                    }
                    if (dynamicObject != null) continue;
                    dynamicObject = queryDownLog;
                }
                catch (Exception e) {
                    logger.info("\u65e5\u5fd7\u8868json_tag\u5b57\u7b26\u4e32\u5b58\u50a8\u5f02\u5e38", (Object)e);
                }
                continue;
            }
            if (!"6".equals(queryDownLog.getString("gov_status"))) continue;
            return true;
        }
        if (rpaAsync && dynamicObject == null) {
            logger.info("rpa\u8868\u5934\u4efb\u52a1\uff0c\u6ca1\u6709\u7533\u8bf7\u4e2d\u7684\u8bb0\u5f55");
            return false;
        }
        Date date2 = createtime = dynamicObject != null ? dynamicObject.getDate("createtime") : ((DynamicObject)queryDownLogs.get(0)).getDate("createtime");
        return createtime != null && nowDate.compareTo(date = DateUtils.addHour(createtime, hours = InvoiceDownloadConstant.getPageSizeFromConfig(12, "taxperiod_down_hours"))) <= 0;
    }
}

