/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.download;

import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.InvoiceDownloadConstant;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.helper.ImcSaveServiceHelper;
import kd.imc.rim.common.invoice.deduction.UpdatePeriodInvoiceTask;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.LqConvertUtil;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.common.utils.StringUtils;
import kd.imc.rim.common.utils.TenantUtils;

public class LeqiPurposeServiceTask
implements Callable<Boolean> {
    private static final Log LOGGER = LogFactory.getLog(LeqiPurposeServiceTask.class);
    private RequestContext rc;
    private Object id;

    public LeqiPurposeServiceTask(RequestContext rc, Object id) {
        this.rc = rc;
        this.id = id;
    }

    private void dealSingle(RequestContext rc, DynamicObject dynamicObject) {
        if (!"0".equals(dynamicObject.getString("handle_status"))) {
            return;
        }
        long orgId = DynamicObjectUtil.getDynamicObjectLongValue(dynamicObject.get("org"));
        long invoiceType = DynamicObjectUtil.getDynamicObjectLongValue(dynamicObject.get("invoice_type"));
        String taxNo = dynamicObject.getString("buyer_tax_no");
        if (StringUtils.isEmpty((CharSequence)taxNo)) {
            taxNo = TenantUtils.getTaxNoByOrgId(orgId);
        }
        if (StringUtils.isEmpty((CharSequence)taxNo)) {
            this.update(dynamicObject, ResManager.loadKDString((String)"\u53d1\u7968\u6ca1\u6709\u8d2d\u65b9\u7a0e\u53f7\u4e14\u6240\u5c5e\u7ec4\u7ec7\u672a\u914d\u7f6e\u7a0e\u53f7", (String)"LeqiPurposeServiceTask_0", (String)"imc-rim-common", (Object[])new Object[0]));
            return;
        }
        String dkType = DeductionConstant.getDkType(taxNo);
        if (!"5".equals(dkType = InvoiceDownloadConstant.convertLqCollect(taxNo, dkType))) {
            this.update(dynamicObject, String.format(ResManager.loadKDString((String)"\u7a0e\u53f7[%1$s]\u6536\u7968\u901a\u9053\u975e\u4e50\u4f01\u5e73\u53f0,\u8bf7\u786e\u8ba4\u8be5\u7a0e\u53f7\u662f\u5426\u4f7f\u7528\u4e50\u4f01\u6536\u7968\u901a\u9053", (String)"LeqiPurposeServiceTask_1", (String)"imc-rim-common", (Object[])new Object[0]), taxNo));
            return;
        }
        try {
            JSONObject param = new JSONObject();
            String invoiceCode = dynamicObject.getString("invoice_code");
            if (StringUtils.isNotEmpty((CharSequence)invoiceCode)) {
                param.put("fpdm", (Object)invoiceCode);
            }
            param.put("fphm", dynamicObject.get("invoice_no"));
            String electronicNo = dynamicObject.getString("electronic_no");
            String lqInvoiceType = InputInvoiceTypeEnum.getLqInvoiceType(invoiceType);
            if (StringUtils.isNotEmpty((CharSequence)electronicNo)) {
                if (InputInvoiceTypeEnum.SPECIAL_PAPER.getCode().equals(invoiceType)) {
                    lqInvoiceType = "85";
                    param.put("fphm", (Object)electronicNo);
                    param.remove((Object)"fpdm");
                } else if (InputInvoiceTypeEnum.ORDINARY_PAPER.getCode().equals(invoiceType)) {
                    lqInvoiceType = "86";
                    param.put("fphm", (Object)electronicNo);
                    param.remove((Object)"fpdm");
                } else if (InputInvoiceTypeEnum.MOTOR_INVOICE.getCode().equals(invoiceType)) {
                    lqInvoiceType = "87";
                    param.put("fphm", (Object)electronicNo);
                    param.remove((Object)"fpdm");
                } else if (InputInvoiceTypeEnum.USEDCAR_INVOICE.getCode().equals(invoiceType)) {
                    lqInvoiceType = "88";
                    param.put("fphm", (Object)electronicNo);
                    param.remove((Object)"fpdm");
                }
            }
            if (StringUtils.isEmpty((CharSequence)lqInvoiceType)) {
                this.update(dynamicObject, ResManager.loadKDString((String)"\u4e50\u4f01\u4e0d\u652f\u6301\u7684\u53d1\u7968\u7c7b\u578b", (String)"LeqiPurposeServiceTask_2", (String)"imc-rim-common", (Object[])new Object[0]));
                return;
            }
            Date invoiceDate = dynamicObject.getDate("invoice_date");
            if (invoiceDate == null) {
                this.update(dynamicObject, ResManager.loadKDString((String)"\u53d1\u7968\u65e5\u671f\u4e3a\u7a7a", (String)"LeqiPurposeServiceTask_3", (String)"imc-rim-common", (Object[])new Object[0]));
                return;
            }
            param.put("kprq", (Object)DateUtils.format(invoiceDate, "yyyyMMdd"));
            param.put("fplx", (Object)lqInvoiceType);
            param.put("api_type", (Object)"FPZTXXCX");
            param.put("nsrsbh", (Object)taxNo);
            JSONObject useResult = LqConvertUtil.invokeService(param);
            int handleNum = dynamicObject.getInt("handle_num");
            dynamicObject.set("handle_num", (Object)(++handleNum));
            if (ResultContant.isSuccess(useResult).booleanValue()) {
                JSONObject data = useResult.getJSONObject("data");
                String operateType = dynamicObject.getString("operate_type");
                if ("2".equals(operateType)) {
                    this.updateDownInvoice(dynamicObject, data);
                } else {
                    this.updateInvoice(dynamicObject.getString("serial_no"), dynamicObject.getString("invoice_code"), dynamicObject.getString("invoice_no"), data, orgId);
                }
                if (data != null) {
                    dynamicObject.set("fpyt", (Object)data.getString("fpyt"));
                    dynamicObject.set("rzzt", (Object)data.getString("rzzt"));
                    dynamicObject.set("fpzt", (Object)data.getString("fpzt"));
                }
                this.update(dynamicObject, "1", useResult.getString("errcode"), useResult.getString("description"), JSONObject.toJSONString((Object)useResult));
            } else {
                if (useResult == null) {
                    useResult = ResultContant.createJSONObject(ErrorType.STATUS_TIMEOUT);
                }
                String handleStatus = "0";
                if (handleNum > 5) {
                    handleStatus = "2";
                }
                this.update(dynamicObject, handleStatus, useResult.getString("errcode"), useResult.getString("description"), JSONObject.toJSONString((Object)useResult));
            }
        }
        catch (Exception e) {
            LOGGER.error("\u4e50\u4f01\u7528\u9014\u4e0b\u8f7d\u9519\u8bef" + taxNo, (Throwable)e);
        }
    }

    private void updateDownInvoice(DynamicObject dynamicObject, JSONObject invoiceJson) {
        if (invoiceJson == null) {
            return;
        }
        String serialNo = CommonUtils.getInvoiceCodeNoGroup(dynamicObject.getString("invoice_code"), dynamicObject.getString("invoice_no"));
        String inout = dynamicObject.getString("inout");
        Long invoiceType = DynamicObjectUtil.getDynamicObjectLongValue(dynamicObject.get("invoice_type"));
        QFilter serialNoFilter = new QFilter("serial_no", "=", (Object)serialNo);
        QFilter dataTypeFilter = new QFilter("inout", "=", (Object)inout);
        QFilter invoiceTypeFilter = new QFilter("invoice_type", "=", (Object)invoiceType);
        DynamicObject inputTplObject = BusinessDataServiceHelper.loadSingle((String)"rim_down_input", (String)"id,invoice_json_tag,sync_status,modifytime,handle_num", (QFilter[])new QFilter[]{serialNoFilter, dataTypeFilter, invoiceTypeFilter});
        if (inputTplObject == null) {
            return;
        }
        inputTplObject.set("sync_status", (Object)"2");
        inputTplObject.set("modifytime", (Object)new Date());
        String invoiceStatus = LqConvertUtil.getInvoiceStatus(invoiceJson.getString("fpzt"), invoiceJson.getString("hzsdbs"));
        String riskLevel = LqConvertUtil.getRiskLevel(invoiceJson.getString("ycpzzt"));
        JSONObject dataJson = JSONObject.parseObject((String)inputTplObject.getString("invoice_json_tag"));
        dataJson.put("invoiceStatus", (Object)invoiceStatus);
        dataJson.put("invoiceRiskLevel", (Object)riskLevel);
        CommonUtils.copyData(dataJson, invoiceJson, "fpyt", "rzzt", "xfsyt");
        inputTplObject.set("invoice_json_tag", (Object)dataJson.toString());
        inputTplObject.set("handle_num", (Object)0);
        ImcSaveServiceHelper.save((DynamicObject)inputTplObject);
    }

    private void updateInvoice(String serialNo, String invoiceCode, String invoiceNo, JSONObject invoiceJson, Long orgId) {
        QFilter noFilter;
        if (invoiceJson == null) {
            return;
        }
        String updateFlag = RimConfigUtils.getConfig("rim_deduction", "leqi_ytcx_update");
        if ("0".equals(updateFlag)) {
            return;
        }
        if (StringUtils.isNotEmpty((CharSequence)serialNo)) {
            noFilter = new QFilter("serial_no", "=", (Object)serialNo);
        } else {
            String flag = RimConfigUtils.getConfig("rim_deduction", "leqi_ytcx_invoiceno");
            if (!"1".equals(flag)) {
                return;
            }
            noFilter = new QFilter("invoice_code", "=", (Object)StringUtils.trimToEmpty((String)invoiceCode)).and("invoice_no", "=", (Object)invoiceNo);
        }
        List idList = QueryServiceHelper.queryPrimaryKeys((String)"rim_invoice", (QFilter[])new QFilter[]{noFilter}, null, (int)10);
        if (CollectionUtils.isEmpty((Collection)idList)) {
            return;
        }
        String invoiceStatus = LqConvertUtil.getInvoiceStatus(invoiceJson.getString("fpzt"), invoiceJson.getString("hzsdbs"));
        String riskLevel = LqConvertUtil.getRiskLevel(invoiceJson.getString("ycpzzt"));
        invoiceJson.put("invoiceStatus", (Object)invoiceStatus);
        invoiceJson.put("invoiceRiskLevel", (Object)riskLevel);
        String fpyt = invoiceJson.getString("fpyt");
        String deductionPurpose = LqConvertUtil.getDeductionPurpose(fpyt);
        String authenticateFlag = null;
        if ("0".equals(fpyt)) {
            authenticateFlag = "0";
        }
        if (StringUtils.isNotEmpty((CharSequence)deductionPurpose)) {
            authenticateFlag = "0";
            if ("4".equals(fpyt)) {
                authenticateFlag = "2";
            } else if (StringUtils.isNotEmpty((CharSequence)deductionPurpose)) {
                authenticateFlag = "1";
            }
            invoiceJson.put("deductionPurpose", (Object)deductionPurpose);
            String skssq = invoiceJson.getString("skssq");
            if (StringUtils.isNotEmpty((CharSequence)skssq)) {
                authenticateFlag = "2";
                invoiceJson.put("taxPeriod", (Object)skssq);
            }
        }
        invoiceJson.put("authenticateFlag", (Object)authenticateFlag);
        UpdatePeriodInvoiceTask updateTask = new UpdatePeriodInvoiceTask(RequestContext.get(), idList.get(0), orgId, invoiceJson);
        try {
            updateTask.call();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void update(DynamicObject object, String description) {
        this.update(object, "2", ErrorType.PARAM_NULL.getCode(), description, null);
    }

    private void update(DynamicObject object, String handleStatus, String errcode, String description, String responseBody) {
        object.set("handle_status", (Object)handleStatus);
        String response = String.format("[%s]%s", errcode, description);
        object.set("response", (Object)response);
        object.set("modifytime", (Object)new Date());
        ImcSaveServiceHelper.save((DynamicObject)object);
    }

    @Override
    public Boolean call() throws Exception {
        try (DLock dLock = DLock.create((String)("leqipurpose" + this.id), (String)"leqipurpose.lock");){
            if (dLock.tryLock()) {
                RequestContext.copyAndSet((RequestContext)this.rc);
                MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"rim_leqi_purpose");
                DynamicObject data = BusinessDataServiceHelper.loadSingle((Object)this.id, (DynamicObjectType)mainEntityType);
                this.dealSingle(this.rc, data);
            }
        }
        return Boolean.TRUE;
    }
}

