/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.download;

import com.alibaba.fastjson.JSONArray;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.rim.common.invoice.download.RpaFileDownApplyService;
import org.apache.commons.collections.MapUtils;

public class RpaFileDownRetryTask
implements Callable<Boolean> {
    private static final Log LOGGER = LogFactory.getLog(RpaFileDownRetryTask.class);
    private RequestContext rc;
    private String taxNo;
    private List<String> invoiceNoList;
    private Long invoiceTypeParam;
    private Date invoiceStartdate;
    private Date invoiceEnddate;
    private int reapplyTimes;

    public RpaFileDownRetryTask(RequestContext rc, String taxNo, List<String> invoiceNoList, Long invoiceType, Date invoiceStartdate, Date invoiceEnddate, int reapplyTimes) {
        this.rc = rc;
        this.taxNo = taxNo;
        this.invoiceNoList = invoiceNoList;
        this.invoiceTypeParam = invoiceType;
        this.invoiceStartdate = invoiceStartdate;
        this.invoiceEnddate = invoiceEnddate;
        this.reapplyTimes = reapplyTimes;
    }

    @Override
    public Boolean call() throws Exception {
        RequestContext.copyAndSet((RequestContext)this.rc);
        RpaFileDownApplyService rpaFileDownApplyService = new RpaFileDownApplyService();
        Map<String, JSONArray> applyFiles = rpaFileDownApplyService.replenishApplyData(this.taxNo, this.invoiceNoList, this.invoiceTypeParam);
        if (MapUtils.isNotEmpty(applyFiles)) {
            rpaFileDownApplyService.applyTaxFile(applyFiles, this.invoiceStartdate, this.invoiceEnddate, this.reapplyTimes);
        } else {
            LOGGER.info("\u91cd\u65b0\u7533\u8bf7\u6587\u4ef6\u4e0b\u8f7d\uff0c\u7ec4\u88c5\u53c2\u6570\u4e3a\u7a7a\uff0c\u4e0d\u7533\u8bf7");
        }
        return Boolean.TRUE;
    }
}

