/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.download.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.InvoiceDownloadConstant;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.invoice.deduction.DeductService;
import kd.imc.rim.common.invoice.deduction.DeductServiceFactory;
import kd.imc.rim.common.invoice.download.InvoiceDownService;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.utils.ListUtils;
import kd.imc.rim.common.utils.LockUtils;
import kd.imc.rim.common.utils.UUID;

public class HeaderInvoiceDownServiceImpl
extends InvoiceDownService {
    private static Log logger = LogFactory.getLog(HeaderInvoiceDownServiceImpl.class);
    protected static final String SYNC_TYPE_HEAD = "1";
    protected static final String SYNC_TYPE_TAXPERIOD = "4";
    protected static final String CURRENT_PERIOD_DOWM = "9";
    protected static final String HIS_PERIOD_DOWM = "10";

    public HeaderInvoiceDownServiceImpl() {
        this.dkType = "2";
    }

    @Override
    public JSONObject invoiceDown(DynamicObject downInit, RequestContext requestContext, Long orgId, String taxNo) {
        logger.info("\u5f00\u59cb\u4e0b\u8f7d\u589e\u91cf\u53d1\u7968\u6216\u8005\u6309\u5c5e\u671f\u4e0b\u8f7d\u53d1\u7968{}", (Object)taxNo);
        Date startDate = downInit.getDate("begin");
        if (this.checkOffFlag(this.dkType, taxNo)) {
            return ResultContant.createJSONObject(ErrorType.NEED_LOGIN.getCode(), ResManager.loadKDString((String)"\u4e0b\u8f7d\u5df2\u914d\u7f6e\u5173\u95ed,\u8bf7\u91cd\u65b0\u914d\u7f6e", (String)"HeaderInvoiceDownServiceImpl_0", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        String key = this.getLockKey(taxNo);
        int waitSeconds = InvoiceDownloadConstant.getPageSizeFromConfig(10, "down_wait_seconds");
        return (JSONObject)LockUtils.lock((String)key, (String)"HeaderInvoiceDownServiceImpl.lock", (int)waitSeconds, () -> this.down(taxNo, orgId, startDate, requestContext), () -> ResultContant.createJSONObject("0223", ResManager.loadKDString((String)"\u4e0a\u9501\u8d85\u65f6", (String)"HeaderInvoiceDownServiceImpl_1", (String)"imc-rim-common", (Object[])new Object[0])));
    }

    protected JSONObject down(String taxNo, Long orgId, Date startDate, RequestContext requestContext) {
        if (orgId == 0L) {
            orgId = requestContext.getOrgId();
        }
        JSONObject postData = new JSONObject();
        postData.put("taxNo", (Object)taxNo);
        postData.put("synctype", (Object)"06");
        String batchNo = this.getDownBatchNo();
        DeductService deductService = DeductServiceFactory.newInstanceForDeduct("2", orgId);
        JSONObject resultJson = null;
        try {
            while (true) {
                postData.put("requestId", (Object)UUID.randomUUID());
                resultJson = deductService.queryInvoices(postData);
                if (!ResultContant.isSuccess(resultJson).booleanValue()) break;
                this.insertHeaderSyncLog(orgId, taxNo, startDate, batchNo, SYNC_TYPE_HEAD, resultJson);
                if ("Y".equals(resultJson.getString("continueFlag"))) {
                    batchNo = this.getDownBatchNo();
                    continue;
                }
                break;
            }
        }
        catch (MsgException e1) {
            resultJson = ResultContant.createJSONObject(e1.getErrorCode(), e1.getErrorMsg());
            logger.info("\u8868\u5934\u4e0b\u8f7d\u5931\u8d25:{},{}", (Object)taxNo, (Object)resultJson);
        }
        catch (Exception e) {
            logger.error("\u8868\u5934\u4e0b\u8f7d\u5931\u8d25:" + taxNo, (Throwable)e);
            resultJson = ResultContant.createJSONObject(ErrorType.FAIL.getCode(), ResManager.loadKDString((String)"\u8868\u5934\u4e0b\u8f7d\u5931\u8d25", (String)"HeaderInvoiceDownServiceImpl_2", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        return resultJson;
    }

    protected void insertHeaderSyncLog(Long orgId, String taxNo, Date startDate, String batchNo, String syncType, JSONObject dataJson) {
        this.insertHeaderSyncLog(orgId, taxNo, startDate, batchNo, syncType, dataJson, null, null);
    }

    protected void insertHeaderSyncLog(Long orgId, String taxNo, Date startDate, String batchNo, String syncType, JSONObject dataJson, Date beginDate, Date endDate) {
        JSONArray dataArray = dataJson.getJSONArray("data");
        if (CollectionUtils.isEmpty((Collection)dataArray)) {
            return;
        }
        logger.info("\u8868\u5934\u4e0b\u8f7d\u5165\u540c\u6b65\u53f0\u8d26\u65e5\u5fd7\u8868:{},\u4e0b\u8f7d\u7c7b\u578b{},\u53d1\u7968\u6570\u91cf:{}", new Object[]{taxNo, syncType, dataArray.size()});
        String taskNo = dataJson.getString("taskNo");
        JSONArray tollInvoices = new JSONArray();
        for (int i = 0; i < dataArray.size(); ++i) {
            JSONObject invoice = dataArray.getJSONObject(i);
            String invoiceType = invoice.getString("invoiceType");
            if (!"15".equals(invoiceType)) continue;
            tollInvoices.add((Object)invoice);
        }
        if (!CollectionUtils.isEmpty((Collection)tollInvoices)) {
            String tollBatchNo = this.getDownBatchNo();
            DynamicObject syncLogs1 = this.getDownLogDynamicObject(tollBatchNo, taskNo, orgId, taxNo, tollInvoices.size(), syncType);
            syncLogs1.set("invoice_startdate", (Object)beginDate);
            syncLogs1.set("invoice_enddate", (Object)endDate);
            this.insertHeaderSyncAccount(syncLogs1, startDate, tollInvoices);
            dataArray.removeAll((Collection)tollInvoices);
        }
        if (CollectionUtils.isEmpty((Collection)dataArray)) {
            if (SYNC_TYPE_HEAD.equals(syncType)) {
                this.returnReceipt(taxNo, taskNo, orgId);
            }
            return;
        }
        Integer pageSize = 1000;
        Integer totalDownNum = dataArray.size();
        if (totalDownNum > pageSize) {
            int page = totalDownNum % pageSize == 0 ? totalDownNum / pageSize : totalDownNum / pageSize + 1;
            JSONArray subDataArray = null;
            for (int i = 0; i < page; ++i) {
                subDataArray = i != page - 1 ? ListUtils.subJSONArray(dataArray, i * pageSize, (i + 1) * pageSize) : ListUtils.subJSONArray(dataArray, i * pageSize, totalDownNum);
                batchNo = this.getDownBatchNo();
                DynamicObject syncLogs2 = this.getDownLogDynamicObject(batchNo, taskNo, orgId, taxNo, subDataArray.size(), syncType);
                syncLogs2.set("invoice_startdate", (Object)beginDate);
                syncLogs2.set("invoice_enddate", (Object)endDate);
                this.insertHeaderSyncAccount(syncLogs2, startDate, subDataArray);
            }
        } else {
            DynamicObject syncLogs3 = this.getDownLogDynamicObject(batchNo, taskNo, orgId, taxNo, dataArray.size(), syncType);
            syncLogs3.set("invoice_startdate", (Object)beginDate);
            syncLogs3.set("invoice_enddate", (Object)endDate);
            this.insertHeaderSyncAccount(syncLogs3, startDate, dataArray);
        }
        if (SYNC_TYPE_HEAD.equals(syncType)) {
            this.returnReceipt(taxNo, taskNo, orgId);
        }
    }

    private void returnReceipt(String taxNo, String taskNo, Long orgId) {
        JSONObject postData = new JSONObject();
        postData.put("taxNo", (Object)taxNo);
        postData.put("synctype", (Object)"07");
        postData.put("synccondition", (Object)taskNo);
        DeductService deductService = DeductServiceFactory.newInstanceForDeduct("2", orgId);
        JSONObject resultJson = deductService.queryInvoices(postData);
        logger.info("\u589e\u91cf\u56de\u6267\u8fd4\u56de:{}", (Object)resultJson);
    }
}

