/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.download.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.invoice.download.InputOutInvoiceApplyService;
import kd.imc.rim.common.invoice.download.InvoiceDownService;
import kd.imc.rim.common.invoice.download.LqIncrementDownResultDealTask;
import kd.imc.rim.common.invoice.download.impl.LqInputOutInvoiceApplyServiceImpl;
import kd.imc.rim.common.invoice.download.impl.NewEtaxInOutInvoiceDownServiceImpl;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.LockUtils;
import kd.imc.rim.common.utils.LqConvertUtil;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.file.utils.CompressHelper;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class LqInOutInvoiceDownServiceImpl
extends InvoiceDownService {
    private static final Log LOGGER = LogFactory.getLog(LqInOutInvoiceDownServiceImpl.class);

    public LqInOutInvoiceDownServiceImpl() {
        this.dkType = "5";
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public JSONObject invoiceDown(DynamicObject dynamicObject, RequestContext requestContext, Long orgId, String taxNo) {
        JSONObject result;
        block56: {
            result = null;
            LOGGER.info("\u4e50\u4f01-\u53d1\u7968\u4e0b\u8f7d\u5f00\u59cb\uff1a{}\uff0c{}", (Object)taxNo, dynamicObject.get("batch_no"));
            Long invoiceType = DynamicObjectUtil.getDynamicObjectLongValue(dynamicObject.get("invoice_type"));
            if (this.checkOffFlag(this.dkType, taxNo)) {
                return ResultContant.createJSONObject(ErrorType.FAIL.getCode(), ResManager.loadKDString((String)"\u4e0b\u8f7d\u5df2\u914d\u7f6e\u5173\u95ed,\u8bf7\u91cd\u65b0\u914d\u7f6e", (String)"LqInOutInvoiceDownServiceImpl_0", (String)"imc-rim-common", (Object[])new Object[0]));
            }
            String batchNo = dynamicObject.getString("taskno");
            String awsType = dynamicObject.getString("aws_invoice_type");
            JSONObject param = new JSONObject();
            if (StringUtils.isEmpty((String)batchNo)) {
                return ResultContant.createJSONObject(ErrorType.FAIL.getCode(), ResManager.loadKDString((String)"\u6279\u6b21\u53f7\u4e3a\u7a7a", (String)"LqInOutInvoiceDownServiceImpl_7", (String)"imc-rim-common", (Object[])new Object[0]));
            }
            boolean isGetUse = true;
            if (InputInvoiceTypeEnum.HGJKS.getCode().equals(invoiceType)) {
                param.put("api_type", (Object)"PLHGJKSXZSQFK");
                param.put("pclsh", (Object)batchNo);
                isGetUse = false;
            } else if (InputInvoiceTypeEnum.WITHHOLDING.getCode().equals(invoiceType)) {
                param.put("api_type", (Object)"PLZZSDKDJWSPZXZSQFK");
                param.put("kjywrsbh", (Object)taxNo);
                param.put("pclsh", (Object)batchNo);
                isGetUse = false;
            } else {
                param.put("lsh", (Object)batchNo);
                param.put("api_type", (Object)"PLFPXZSQFK");
            }
            String preStatus = dynamicObject.getString("gov_status");
            param.put("nsrsbh", (Object)taxNo);
            param.put("packageno", (Object)"1");
            String lockkey = "rim.lqinoutCollectinvoicedata-" + dynamicObject.get("id");
            try (DLock lock = LockUtils.createDLockByMd5((String)lockkey, (String)ResManager.loadKDString((String)"\u4e0b\u8f7d\u4e50\u4f01\u53d1\u7968", (String)"LqInOutInvoiceDownServiceImpl_5", (String)"imc-rim-common", (Object[])new Object[0]));){
                if (lock.tryLock()) {
                    result = this.invokeService(param);
                    LOGGER.info("\u4e50\u4f01-\u53d1\u7968\u4e0b\u8f7d\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)result);
                    String inout = dynamicObject.getString("inout");
                    if (ResultContant.isSuccess(result).booleanValue()) {
                        int totalPages;
                        JSONObject data = result.getJSONObject("data");
                        if (data == null) {
                            result = ResultContant.createJSONObject("0201", ResManager.loadKDString((String)"result data\u8282\u70b9\u4e3a\u7a7a", (String)"LqInOutInvoiceDownServiceImpl_2", (String)"imc-rim-common", (Object[])new Object[0]));
                            this.setDescription(dynamicObject, result);
                            JSONObject jSONObject = result;
                            return jSONObject;
                        }
                        try {
                            totalPages = data.getInteger("packagecount");
                        }
                        catch (Exception e) {
                            totalPages = 1;
                        }
                        dynamicObject.set("gov_status", (Object)"8");
                        dynamicObject.set("download_errcode", (Object)"3");
                        dynamicObject.set("total_num", (Object)0);
                        this.setDescription(dynamicObject, (String)null);
                        String cljg = data.getString("cljg");
                        if ("1".equals(cljg)) {
                            String sjl = data.getString("sjl");
                            if (StringUtils.isEmpty((String)sjl)) {
                                dynamicObject.set("gov_status", (Object)"9");
                                dynamicObject.set("download_errcode", (Object)"4");
                            }
                            String dataResult = "";
                            try {
                                dataResult = CompressHelper.decodeBase64AndGZip((String)sjl);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            LOGGER.info("\u89e3\u5bc6\u6570\u636e\u6d41\uff1a{}", (Object)dataResult);
                            if (StringUtils.isNotEmpty((String)dataResult)) {
                                JSONArray invoiceArray = JSONArray.parseArray((String)dataResult);
                                LqIncrementDownResultDealTask dealTask = new LqIncrementDownResultDealTask();
                                if (isGetUse) {
                                    dealTask.supUseDataResult(invoiceArray, awsType, taxNo);
                                }
                                result = ResultContant.createSuccessJSONObject();
                                JSONArray downData = this.convertLqInvoice(invoiceType, awsType, invoiceArray, inout);
                                try {
                                    NewEtaxInOutInvoiceDownServiceImpl downService = new NewEtaxInOutInvoiceDownServiceImpl(false);
                                    if (InputInvoiceTypeEnum.isEleInvoice(invoiceType).booleanValue() && downService.isDownFile(taxNo)) {
                                        ThreadPools.executeOnceIncludeRequestContext((String)"LqIncrementDownResultDealTask-downFile1", () -> {
                                            RequestContext.copyAndSet((RequestContext)requestContext);
                                            dealTask.applyDownFile(downData, invoiceType, taxNo);
                                        });
                                    }
                                }
                                catch (Exception e) {
                                    LOGGER.info("applyDownFile error: ", (Object)e);
                                }
                                result.put("data", (Object)downData);
                                this.insertInputOutDataSyncLog(dynamicObject, result, inout);
                                this.downSurplusInvoice(dynamicObject, param, totalPages, taxNo, inout, isGetUse, invoiceType);
                            }
                        } else if ("2".equals(cljg)) {
                            dynamicObject.set("gov_status", (Object)"9");
                            dynamicObject.set("download_errcode", (Object)"4");
                        } else if ("3".equals(cljg)) {
                            dynamicObject.set("gov_status", (Object)"7");
                            dynamicObject.set("download_errcode", (Object)"6");
                            result = ResultContant.createJSONObject(ErrorType.FAIL.getCode(), ResManager.loadKDString((String)"\u53d1\u7968\u5f52\u96c6\u5931\u8d25", (String)"LqInOutInvoiceDownServiceImpl_6", (String)"imc-rim-common", (Object[])new Object[0]));
                        }
                    } else {
                        this.setDescription(dynamicObject, result);
                        if (result != null && this.checkSerialNo(result.getString("description"))) {
                            if ("3".equals(dynamicObject.getString("sync_type"))) {
                                Date invoiceStartdate = dynamicObject.getDate("invoice_startdate");
                                Date invoiceEnddate = dynamicObject.getDate("invoice_enddate");
                                Date firstDateOfMonth = DateUtils.getFirstDateOfMonth(invoiceStartdate);
                                Date lastDateOfMonth = DateUtils.getLastDateOfMonth(invoiceStartdate);
                                if (DateUtils.format(firstDateOfMonth).equals(DateUtils.format(invoiceStartdate)) && DateUtils.format(lastDateOfMonth).equals(DateUtils.format(invoiceEnddate))) {
                                    LqInputOutInvoiceApplyServiceImpl applyService = new LqInputOutInvoiceApplyServiceImpl();
                                    long id = dynamicObject.getLong("id");
                                    if (StringUtils.isNotBlank((String)awsType) && awsType.contains(",")) {
                                        List<String> awsTypeList = CommonUtils.getMultiValues(awsType);
                                        for (String awsTypeParam : awsTypeList) {
                                            if (StringUtils.isBlank((String)awsTypeParam)) continue;
                                            Pair<Boolean, Long> applyHistory = applyService.isApplyHistory(null, awsTypeParam, inout, taxNo, invoiceStartdate, invoiceEnddate);
                                            if (!((Boolean)applyHistory.getLeft()).booleanValue()) {
                                                LOGGER.error("\u5df2\u5b58\u5728\u6570\u636e\uff0c\u4e0d\u518d\u7533\u8bf7, id:{}, awsType: {}", (Object)id, (Object)awsTypeParam);
                                                continue;
                                            }
                                            try {
                                                QFilter qFilter = new QFilter("id", "=", (Object)id);
                                                DynamicObject logObj = QueryServiceHelper.queryOne((String)"rim_down_log", (String)"id,invoice_type.id AS invoice_type,inout,invoice_startdate,invoice_enddate,org.id AS org,tax_no,apply_date,batch_no,aws_invoice_type", (QFilter[])qFilter.toArray());
                                                ((InputOutInvoiceApplyService)applyService).applyInputOutDownInvoice(null, null, awsTypeParam, logObj.getString("inout"), logObj.getLong("org"), logObj.getString("tax_no"), logObj.getDate("invoice_startdate"), logObj.getDate("invoice_enddate"));
                                            }
                                            catch (Exception e) {
                                                LOGGER.error("rpa\u5207\u6362\u4e50\u4f01\uff0c\u91cd\u65b0\u7533\u8bf7\u5931\u8d25", (Throwable)e);
                                            }
                                        }
                                        dynamicObject.set("gov_status", (Object)"7");
                                        dynamicObject.set("download_errcode", (Object)"10");
                                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
                                        JSONObject jSONObject = ResultContant.createJSONObject(ErrorType.FAIL.getCode(), ResManager.loadKDString((String)"rpa\u5207\u6362\u4e50\u4f01-\u65e7\u4efb\u52a1\u53f7\uff0c\u91cd\u65b0\u7533\u8bf7\u4e2d", (String)"NewEtaxInOutInvoiceDownServiceImpl_5", (String)"imc-rim-common", (Object[])new Object[0]));
                                        return jSONObject;
                                    }
                                    applyService.againApply(id);
                                    JSONObject jSONObject = ResultContant.createJSONObject(ErrorType.FAIL.getCode(), ResManager.loadKDString((String)"\u65e7\u4efb\u52a1\u53f7\uff0c\u91cd\u65b0\u7533\u8bf7\u4e2d", (String)"NewEtaxInOutInvoiceDownServiceImpl_4", (String)"imc-rim-common", (Object[])new Object[0]));
                                    return jSONObject;
                                }
                            }
                            dynamicObject.set("gov_status", (Object)"7");
                            dynamicObject.set("download_errcode", (Object)"10");
                        }
                    }
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
                    break block56;
                }
                result = ResultContant.createJSONObject(ErrorType.FAIL.getCode(), ResManager.loadKDString((String)"\u8be5\u6279\u6b21\u6b63\u5728\u5728\u4e0b\u8f7d\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"LqInOutInvoiceDownServiceImpl_3", (String)"imc-rim-common", (Object[])new Object[0]));
            }
            catch (Exception e) {
                LOGGER.error("\u4e0b\u8f7d\u5168\u91cf\u53d1\u7968\u5931\u8d25" + taxNo, (Throwable)e);
                dynamicObject.set("gov_status", (Object)preStatus);
                this.setDescription(dynamicObject, e.getMessage());
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
                return ResultContant.createJSONObject(ErrorType.FAIL.getCode(), ResManager.loadKDString((String)"\u4e0b\u8f7d\u5168\u91cf\u53d1\u7968\u5931\u8d25", (String)"LqInOutInvoiceDownServiceImpl_4", (String)"imc-rim-common", (Object[])new Object[0]));
            }
        }
        return result;
    }

    private boolean checkSerialNo(String description) {
        if (StringUtils.isBlank((String)description)) {
            return false;
        }
        switch (description) {
            case "\u6279\u6b21\u6d41\u6c34\u53f7\u4e0d\u5b58\u5728": 
            case "\u6279\u6b21\u6d41\u6c34\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e": {
                return true;
            }
        }
        String config = RimConfigUtils.getConfig("rim_down", "lq_again_apply_msg");
        if (StringUtils.isNotBlank((String)config)) {
            return config.contains(description);
        }
        return false;
    }

    private JSONObject invokeService(JSONObject param) {
        return LqConvertUtil.invokeService(param);
    }

    @Override
    public void insertInputOutDataSyncLog(DynamicObject downLog, JSONObject dataJson, String downDataType) {
        JSONArray fullDataArray = dataJson.getJSONArray("data");
        String batchNo = downLog.getString("batch_no");
        Long orgId = DynamicObjectUtil.getDynamicObjectLongValue(downLog.get("org"));
        int totalNum = downLog.getInt("total_num");
        if (!CollectionUtils.isEmpty((Collection)fullDataArray)) {
            totalNum += fullDataArray.size();
            this.insertSyncInputOutDataAccount(fullDataArray, batchNo, "5", "3", orgId, downDataType, downLog);
        }
        downLog.set("total_num", (Object)totalNum);
    }

    private void downSurplusInvoice(DynamicObject dynamicObject, JSONObject paramJson, int page, String taxNo, String inout, boolean isGetRisk, Long invoiceType) {
        if (page <= 1) {
            return;
        }
        Long orgId = DynamicObjectUtil.getDynamicObjectLongValue(dynamicObject.get("org"));
        String awsType = dynamicObject.getString("aws_invoice_type");
        for (int currentPage = 2; currentPage <= page; ++currentPage) {
            String cljg;
            JSONObject data;
            paramJson.put("packageno", (Object)currentPage);
            JSONObject result = this.invokeService(paramJson);
            if (!ResultContant.isSuccess(result).booleanValue() || ObjectUtils.isEmpty((Object)(data = result.getJSONObject("data"))) || !"1".equals(cljg = data.getString("cljg"))) continue;
            String sjl = data.getString("sjl");
            String dataResult = "";
            try {
                dataResult = CompressHelper.decodeBase64AndGZip((String)sjl);
            }
            catch (Exception exception) {
                // empty catch block
            }
            LOGGER.info("\u89e3\u5bc6\u6570\u636e\u6d41\uff1a{}", (Object)dataResult);
            if (!StringUtils.isNotEmpty((String)dataResult)) continue;
            JSONArray invoiceArray = JSONArray.parseArray((String)dataResult);
            LqIncrementDownResultDealTask dealTask = new LqIncrementDownResultDealTask();
            if (isGetRisk) {
                dealTask.supUseDataResult(invoiceArray, awsType, taxNo);
            }
            JSONObject resultJson = ResultContant.createSuccessJSONObject();
            JSONArray downData = this.convertLqInvoice(invoiceType, awsType, invoiceArray, inout);
            try {
                NewEtaxInOutInvoiceDownServiceImpl downService = new NewEtaxInOutInvoiceDownServiceImpl(false);
                if (InputInvoiceTypeEnum.isEleInvoice(invoiceType).booleanValue() && downService.isDownFile(taxNo)) {
                    RequestContext requestContext = RequestContext.get();
                    ThreadPools.executeOnceIncludeRequestContext((String)"LqIncrementDownResultDealTask-downFile2", () -> {
                        RequestContext.copyAndSet((RequestContext)requestContext);
                        dealTask.applyDownFile(downData, invoiceType, taxNo);
                    });
                }
            }
            catch (Exception e) {
                LOGGER.info("applyDownFile error: ", (Object)e);
            }
            resultJson.put("data", (Object)downData);
            this.insertInputOutDataSyncLog(dynamicObject, resultJson, inout);
        }
    }
}

