/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.download.impl;

import com.alibaba.fastjson.JSONObject;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.earlywarn.kit.StringUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.InvoiceDownloadConstant;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.invoice.download.InputOutInvoiceApplyService;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.LqConvertUtil;
import kd.imc.rim.common.utils.RimConfigUtils;

public class LqInputOutInvoiceApplyServiceImpl
extends InputOutInvoiceApplyService {
    private static final Log LOGGER = LogFactory.getLog(LqInputOutInvoiceApplyServiceImpl.class);

    @Override
    public void replenishApplyLastData(DynamicObject initDynamicObject, List<String> invoiceTypes, String dataType, Long orgId, String taxNo) {
        if (CollectionUtils.isEmpty(invoiceTypes)) {
            return;
        }
        String awsInvoiceType = invoiceTypes.get(0);
        if (StringUtils.isBlank((CharSequence)awsInvoiceType)) {
            return;
        }
        if (!this.checkCommonReplenishApply(dataType, taxNo)) {
            LOGGER.info("rpa-\u4e0b\u8f7d\u7c7b\u578b\u975e\u8fdb\u9879\u3001\u9500\u9879\u5168\u91cf,\u8865\u507f\u5f00\u5173\u672a\u5f00\u542f\uff0c\u6216\u901a\u9053\u975e\u4e50\u4f01\u3001rpa");
            return;
        }
        Calendar cal = Calendar.getInstance();
        Date dateNow = new Date();
        String downDate = RimConfigUtils.getConfig("down_date");
        if (StringUtil.isNotEmpty((CharSequence)downDate)) {
            try {
                dateNow = DateUtils.stringToDate(downDate);
            }
            catch (Exception e) {
                LOGGER.info("\u4e50\u4f01-\u8865\u507f\u4e0b\u8f7d-\u914d\u7f6e\u7684\u65e5\u671f\u683c\u5f0f\u6709\u8bef: {}", (Object)downDate);
            }
        }
        cal.setTime(dateNow);
        Date firstDay = DateUtils.getFirstDateOfMonth(dateNow);
        Date behindMonth = DateUtils.addMonth(firstDay, -1);
        Date startDate = DateUtils.getFirstDateOfMonth(behindMonth);
        Date endDate = DateUtils.getLastDateOfMonthZero(behindMonth);
        Set<String> notApplyAwsTypeSet = this.getNotApplyAwsType(dataType, taxNo, startDate, endDate, awsInvoiceType);
        if (!CollectionUtils.isEmpty(notApplyAwsTypeSet) && notApplyAwsTypeSet.contains(awsInvoiceType)) {
            LOGGER.info("\u4e50\u4f01-\u8865\u507f\u4e0b\u8f7d-\u5b58\u5728\u91cd\u590d\u6570\u636e\uff0c\u9700\u8981\u7533\u8bf7\u7684\u7968\u79cd\u4e3a\u7a7a");
            return;
        }
        this.applyInputOutDownInvoice(null, null, awsInvoiceType, dataType, orgId, taxNo, startDate, endDate);
    }

    @Override
    public JSONObject applyInputOutDownInvoice(Long logId, DynamicObject initDynamicObject, String invoiceType, String dataType, Long orgId, String taxNo, Date begin, Date end) {
        JSONObject dataInfo;
        JSONObject result;
        JSONObject param = new JSONObject();
        LOGGER.info("applyInputOutDownInvoice invoiceType:{}", (Object)invoiceType);
        Long type = InvoiceDownloadConstant.getInvoiceTypeByAwsType(invoiceType);
        param.put("nsrsbh", (Object)taxNo);
        if (InputInvoiceTypeEnum.HGJKS.getCode().equals(type)) {
            param.put("tfrqq", (Object)DateUtils.format(begin, "yyyyMMdd"));
            param.put("tfrqz", (Object)DateUtils.format(end, "yyyyMMdd"));
            param.put("hgjkslx", (Object)"1");
            param.put("api_type", (Object)"PLHGJKSXZSQ");
        } else if (InputInvoiceTypeEnum.WITHHOLDING.getCode().equals(type)) {
            param.put("kjywrsbh", (Object)taxNo);
            param.put("tfrqq", (Object)DateUtils.format(begin, "yyyyMMdd"));
            param.put("tfrqz", (Object)DateUtils.format(end, "yyyyMMdd"));
            param.put("api_type", (Object)"PLZZSDKDJWSPZXZSQ");
        } else {
            String lqType = InvoiceDownloadConstant.getLqTypeByAwsType(invoiceType);
            param.put("kprqq", (Object)DateUtils.format(begin, "yyyyMMdd"));
            param.put("kprqz", (Object)DateUtils.format(end, "yyyyMMdd"));
            param.put("fplx", (Object)lqType);
            param.put("sjlx", (Object)dataType);
            param.put("api_type", (Object)"PLFPXZSQ");
        }
        try {
            result = LqConvertUtil.invokeService(param);
        }
        catch (MsgException e1) {
            result = ResultContant.createJSONObject(e1.getErrorCode(), e1.getErrorMsg());
            LOGGER.info("\u4e50\u4f01\u8fdb\u9500\u9879\u7533\u8bf7\u5931\u8d25:{},{}", (Object)taxNo, (Object)result);
        }
        catch (Exception e2) {
            result = ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u8fdb\u9500\u9879\u7533\u8bf7\u5931\u8d25", (String)"LqInputOutInvoiceApplyServiceImpl_0", (String)"imc-rim-common", (Object[])new Object[0]));
            LOGGER.error("\u4e50\u4f01\u8fdb\u9500\u9879\u7533\u8bf7\u5931\u8d25:" + taxNo, (Throwable)e2);
        }
        LOGGER.info("\u4e50\u4f01\u8fdb\u9500\u9879\u7533\u8bf7\u7ed3\u679c:{},{}", (Object)taxNo, (Object)result);
        if (ResultContant.isSuccess(result).booleanValue() && (dataInfo = result.getJSONObject("data")) != null) {
            String lsh = CommonUtils.getJsonValue((Map<String, Object>)dataInfo, String.class, "lsh", "pclsh");
            if (StringUtils.isEmpty((CharSequence)lsh)) {
                LOGGER.info("\u4e50\u4f01\u8fdb\u9500\u9879\u7533\u8bf7\u5931\u8d25:{},{}", (Object)taxNo, (Object)"\u6d41\u6c34\u53f7\u4e3a\u7a7a!");
                result = ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u8fdb\u9500\u9879\u7533\u8bf7\u5931\u8d25", (String)"LqInputOutInvoiceApplyServiceImpl_0", (String)"imc-rim-common", (Object[])new Object[0]));
                return result;
            }
            result = this.convertApplyResult(lsh, dataType, InputInvoiceTypeEnum.getAwsType(type), begin, end);
            this.dealResult(result, initDynamicObject, logId, orgId, taxNo, invoiceType, null);
        }
        return result;
    }
}

