/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.download.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.InvoiceDownloadConstant;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.invoice.deduction.DeductService;
import kd.imc.rim.common.invoice.deduction.impl.NewEtaxDeductService;
import kd.imc.rim.common.invoice.download.InvoiceDownService;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.DeductionUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.LockUtils;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.common.utils.TenantUtils;

public class NewEtaxAsynHeadDownServiceImpl
extends InvoiceDownService {
    private static Log LOGGER = LogFactory.getLog(NewEtaxAsynHeadDownServiceImpl.class);

    @Override
    public JSONObject invoiceDown(DynamicObject downLog, RequestContext requestContext, Long orgId, String taxNo) {
        JSONObject searchOpt;
        LOGGER.info("rpa-\u5f02\u6b65\u8868\u5934\u4e0b\u8f7d\u8fdb\u9879\u5173\u952e\u8981\u7d20\uff0c\u83b7\u53d6\u4e0b\u8f7d\u7ed3\u679c{}-{}", (Object)taxNo, downLog.get("batch_no"));
        String taskNo = downLog.getString("taskno");
        Long invoiceType = DynamicObjectUtil.getDynamicObjectLongValue(downLog.get("invoice_type"));
        if (orgId == 0L) {
            orgId = requestContext.getOrgId();
        }
        String json = downLog.getString("json_tag");
        JSONObject param = new JSONObject();
        if (StringUtils.isBlank((CharSequence)json)) {
            LOGGER.error("json\u6570\u636e\u9519\u8bef, json\u6570\u636e\u4e3a\u7a7a" + taxNo);
            return ResultContant.createJSONObject(ErrorType.FAIL.getCode(), ResManager.loadKDString((String)"json\u6570\u636e\u9519\u8bef", (String)"InvoiceTableDownServiceImpl_0", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        try {
            param = JSONObject.parseObject((String)json);
        }
        catch (Exception e) {
            LOGGER.error("json\u6570\u636e\u9519\u8bef" + taxNo, (Throwable)e);
            return ResultContant.createJSONObject(ErrorType.FAIL.getCode(), ResManager.loadKDString((String)"json\u6570\u636e\u9519\u8bef", (String)"InvoiceTableDownServiceImpl_0", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        int applyStep = downLog.getInt("apply_step");
        int pageSize = InvoiceDownloadConstant.getPageSizeFromConfig(500, "etax_head_down_pagesize");
        param.put("currentPage", (Object)1);
        if (applyStep > 0) {
            param.put("currentPage", (Object)applyStep);
        }
        if ((searchOpt = param.getJSONObject("searchOpt")) == null) {
            return ResultContant.createJSONObject("0201", ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef", (String)"NewEtaxDeductService_1", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        if (StringUtils.isNotBlank((CharSequence)searchOpt.getString("pageSize"))) {
            try {
                pageSize = Integer.getInteger(searchOpt.getString("pageSize"));
            }
            catch (Exception e) {
                LOGGER.info("searchOpt\u4e2d\u7684pageSize\u8f6c\u6362\u4e3aint\u7c7b\u578b\u5f02\u5e38");
            }
        }
        param.put("pageSize", (Object)pageSize);
        param.put("taxNo", (Object)taxNo);
        param.put("batchNo", (Object)taskNo);
        String key = "rim.NewEtaxAsynHeadDownServiceImpl-" + taxNo;
        String preGovStatus = downLog.getString("gov_status");
        JSONObject resultJson = ResultContant.createSuccessJSONObject();
        Date now = new Date();
        try (DLock lock = LockUtils.createDLockByMd5((String)key, (String)"NewEtaxAsynHeadDownServiceImpl.lock");){
            if (lock.tryLock()) {
                resultJson = this.downLoadInvoices(param, orgId);
                if (resultJson != null && ResultContant.isSuccess(resultJson).booleanValue()) {
                    if (applyStep < 2) {
                        downLog.set("total_num", (Object)0);
                    }
                    downLog.set("modifytime", (Object)now);
                    this.setDescription(downLog, "");
                    downLog.set("download_errcode", (Object)"3");
                    JSONArray invoices = resultJson.getJSONArray("data");
                    if (invoices == null) {
                        invoices = new JSONArray();
                    }
                    int totalPage = resultJson.getIntValue("totalPage");
                    downLog.set("gov_status", (Object)"8");
                    if (!CollectionUtils.isEmpty((Collection)invoices)) {
                        this.insertHeaderAsyncAccount(downLog, null, invoices, downLog.getInt("total_num"));
                        boolean downSurplusInvoice = this.downSurplusInvoice(downLog, param, param.getIntValue("currentPage") + 1, totalPage, null);
                        if (downSurplusInvoice) {
                            downLog.set("apply_step", (Object)1);
                            this.setDescription(downLog, "");
                        } else {
                            downLog.set("gov_status", (Object)"6");
                        }
                    } else {
                        downLog.set("gov_status", (Object)"9");
                        downLog.set("download_errcode", (Object)"4");
                        this.setDescription(downLog, "");
                    }
                } else {
                    Set<String> etaxAsynErrcodes = DeductionUtils.getEtaxHeadAsynRetryErrcodes("etax_head_asyn_retrycode");
                    if (resultJson != null) {
                        if (!etaxAsynErrcodes.contains(resultJson.getString("errcode"))) {
                            downLog.set("gov_status", (Object)"5");
                        }
                        if (ErrorType.ETAX_HANDLING_1.getCode().equals(resultJson.getString("errcode"))) {
                            downLog.set("download_errcode", (Object)"15");
                        }
                        if ("1404".equals(resultJson.getString("errcode"))) {
                            downLog.set("download_errcode", (Object)"14");
                        }
                    }
                    this.setDescription(downLog, resultJson);
                    String dkType = DeductionConstant.getDkType(taxNo);
                    if (this.checkTaskStop(dkType, resultJson)) {
                        downLog.set("gov_status", (Object)"5");
                    }
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{downLog});
            } else {
                resultJson = ResultContant.createJSONObject(ErrorType.FAIL.getCode(), ResManager.loadKDString((String)"\u8be5\u6279\u6b21\u6b63\u5728\u5728\u4e0b\u8f7d\u4e2d,\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"NewEtaxDownServiceImpl_2", (String)"imc-rim-common", (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            LOGGER.error(downLog.get("batch_no") + "rpa-\u5f02\u6b65\u4e0b\u8f7d\u53d1\u7968\u5931\u8d25", (Throwable)e);
            if (e instanceof MsgException) {
                resultJson = ResultContant.createJSONObject(((MsgException)e).getErrorCode(), ((MsgException)e).getErrorMsg());
            } else if (e instanceof KDException) {
                KDException kdException = (KDException)e;
                resultJson = ResultContant.createJSONObject(kdException.getErrorCode().getCode(), kdException.getErrorCode().getMessage());
            } else {
                resultJson = ResultContant.createJSONObject(ErrorType.FAIL.getCode(), ResManager.loadKDString((String)"\u4e0b\u8f7d\u5931\u8d25", (String)"NewEtaxDownServiceImpl_1", (String)"imc-rim-common", (Object[])new Object[0]));
            }
            this.setDescription(downLog, e.getMessage());
            downLog.set("gov_status", (Object)preGovStatus);
            downLog.set("modifytime", (Object)now);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{downLog});
        }
        return resultJson;
    }

    public void insertHeaderAsyncAccount(DynamicObject downLog, Date startDate, JSONArray dataArray, int totalNum) {
        if (CollectionUtils.isEmpty((Collection)dataArray)) {
            return;
        }
        String batchNo = downLog.getString("batch_no");
        String taxNo = downLog.getString("tax_no");
        Long orgId = DynamicObjectUtil.getDynamicObjectLongValue(downLog.get("org"));
        ArrayList<DynamicObject> syncAccountList = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> syncInputTplList = new ArrayList<DynamicObject>(16);
        String addFlag = RimConfigUtils.getConfig("rim_deduction", "add_buyer_info");
        String companyName = TenantUtils.getCompanyNameByTaxNo(taxNo);
        for (int i = 0; i < dataArray.size(); ++i) {
            JSONObject invoice = dataArray.getJSONObject(i);
            DeductionUtils.addBuyerInfo(invoice, taxNo, companyName, addFlag);
            if (ObjectUtils.isEmpty((Object)invoice.get((Object)"totalAmount"))) {
                BigDecimal totalAmount = BigDecimalUtil.transDecimal(invoice.get((Object)"invoiceAmount")).add(BigDecimalUtil.transDecimal(invoice.get((Object)"totalTaxAmount")));
                invoice.put("totalAmount", (Object)totalAmount);
            }
            DynamicObject account = this.getAccountDynamicObject(invoice, batchNo, "2", "1", startDate, orgId);
            syncAccountList.add(account);
            DynamicObject inputTpl = this.getInputTplDynamicObject(invoice, "1", "1", orgId);
            syncInputTplList.add(inputTpl);
            ++totalNum;
        }
        if (!CollectionUtils.isEmpty(syncAccountList)) {
            downLog.set("total_num", (Object)totalNum);
            try (TXHandle h = TX.required();){
                try {
                    SaveServiceHelper.save((DynamicObject[])syncAccountList.toArray(new DynamicObject[syncAccountList.size()]));
                    SaveServiceHelper.save((DynamicObject[])syncInputTplList.toArray(new DynamicObject[syncInputTplList.size()]));
                }
                catch (Throwable e) {
                    h.markRollback();
                    throw e;
                }
            }
        }
    }

    public boolean downSurplusInvoice(DynamicObject downLog, JSONObject param, int startPage, int totalPage, DeductService deductService) {
        if (totalPage <= 1) {
            return true;
        }
        Long orgId = DynamicObjectUtil.getDynamicObjectLongValue(downLog.get("org"));
        JSONObject resultJson = null;
        for (int currentPage = startPage; currentPage <= totalPage; ++currentPage) {
            param.put("currentPage", (Object)currentPage);
            resultJson = this.downLoadInvoices(param, orgId);
            if (resultJson == null || !ResultContant.isSuccess(resultJson).booleanValue()) {
                downLog.set("apply_step", (Object)currentPage);
                this.setDescription(downLog, resultJson);
                return false;
            }
            this.insertHeaderAsyncAccount(downLog, null, resultJson.getJSONArray("data"), downLog.getInt("total_num"));
        }
        return true;
    }

    @Override
    public JSONObject downLoadInvoices(JSONObject bodyParam, Long orgId) {
        if (TenantUtils.isSmallScaleTaxpayer(bodyParam.getString("taxNo"))) {
            return ResultContant.createJSONObject(ErrorType.SMALL_SCALE_TAXPAYER_DOWN);
        }
        NewEtaxDeductService newEtaxDeductService = new NewEtaxDeductService(orgId);
        return newEtaxDeductService.getDownInvoiceHeadResult(bodyParam);
    }
}

