/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.download.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.earlywarn.kit.StringUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.InvoiceDownloadConstant;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.invoice.deduction.impl.NewEtaxDeductService;
import kd.imc.rim.common.invoice.download.InputOutInvoiceApplyService;
import kd.imc.rim.common.invoice.download.InvoiceApplyLogService;
import kd.imc.rim.common.invoice.download.impl.NewEtaxInOutInvoiceDownServiceImpl;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.LockUtils;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.common.utils.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class NewEtaxInputOutInvoiceApplyServiceImpl
extends InputOutInvoiceApplyService {
    private static final Log LOGGER = LogFactory.getLog(NewEtaxInputOutInvoiceApplyServiceImpl.class);

    @Override
    public void divideObject(DynamicObject initDynamicObject, Long orgId, String taxNo, List<Map<String, Date>> initDateList) {
        String lockKey = "InvoiceDownApplyLock-" + taxNo;
        try (DLock lock = LockUtils.createDLockByMd5((String)lockKey, (String)"NewEtaxInputOutInvoiceApply-lock");){
            if (lock.tryLock()) {
                LOGGER.info("\u8fdb\u9500\u9879\u7533\u8bf7:{}", (Object)taxNo);
                List<String> dataTypes = CommonUtils.getMultiValues(initDynamicObject.getString("output_download"));
                List<String> invoiceTypes = CommonUtils.getMultiValues(initDynamicObject.getString("invoice_type"));
                for (String dataType : dataTypes) {
                    if (!"1".equals(dataType) && !"2".equals(dataType)) continue;
                    this.batchApplyInitHistoryData(initDynamicObject, invoiceTypes, dataType, orgId, taxNo, initDateList);
                    this.batchApplyBeforeHistoryData(initDynamicObject, invoiceTypes, dataType, orgId, taxNo);
                    this.batchApplyCurrentData(initDynamicObject, invoiceTypes, dataType, orgId, taxNo);
                    this.replenishApplyLastData(initDynamicObject, invoiceTypes, dataType, orgId, taxNo);
                    this.batchApplyTodayData(initDynamicObject, invoiceTypes, dataType, orgId, taxNo);
                }
            } else {
                LOGGER.info("InvoiceDownApplyLock-tryLock");
            }
        }
        catch (Exception e) {
            LOGGER.error("\u8fdb\u9500\u9879\u7533\u5931\u8d25:" + taxNo, (Throwable)e);
        }
    }

    @Override
    public void replenishApplyLastData(DynamicObject initDynamicObject, List<String> invoiceTypes, String dataType, Long orgId, String taxNo) {
        if (!this.checkCommonReplenishApply(dataType, taxNo)) {
            LOGGER.info("rpa-\u4e0b\u8f7d\u7c7b\u578b\u975e\u8fdb\u9879\u3001\u9500\u9879\u5168\u91cf,\u8865\u507f\u5f00\u5173\u672a\u5f00\u542f\uff0c\u6216\u901a\u9053\u975e\u4e50\u4f01\u3001rpa");
            return;
        }
        HashSet<String> checkInvoiceTypes = new HashSet<String>(invoiceTypes.size());
        for (String invoiceType : invoiceTypes) {
            if (!this.checkDownCustom(dataType, invoiceType, taxNo)) continue;
            checkInvoiceTypes.add(invoiceType);
        }
        if (CollectionUtils.isEmpty(checkInvoiceTypes)) {
            LOGGER.info("rpa-\u8865\u507f\u4e0b\u8f7d-\u7968\u79cd\u4e0d\u652f\u6301\u4e0b\u8f7d");
            return;
        }
        Calendar cal = Calendar.getInstance();
        Date dateNow = new Date();
        String downDate = RimConfigUtils.getConfig("down_date");
        if (StringUtil.isNotEmpty((CharSequence)downDate)) {
            dateNow = DateUtils.stringToDate(downDate);
        }
        cal.setTime(dateNow);
        Date firstDay = DateUtils.getFirstDateOfMonth(dateNow);
        Date behindMonth = DateUtils.addMonth(firstDay, -1);
        Date startDate = DateUtils.getFirstDateOfMonth(behindMonth);
        Date endDate = DateUtils.getLastDateOfMonthZero(behindMonth);
        String awsInvoiceType = String.join((CharSequence)",", checkInvoiceTypes);
        Set<String> notApplyAwsTypeSet = this.getNotApplyAwsType(dataType, taxNo, startDate, endDate, awsInvoiceType);
        Set checkAwsTypeList = checkInvoiceTypes.stream().filter(t -> !notApplyAwsTypeSet.contains(t)).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(checkAwsTypeList)) {
            LOGGER.info("rpa-\u8865\u507f\u4e0b\u8f7d-\u5b58\u5728\u91cd\u590d\u6570\u636e\uff0c\u9700\u8981\u7533\u8bf7\u7684\u7968\u79cd\u4e3a\u7a7a");
            return;
        }
        String checkAwsTypeStr = String.join((CharSequence)",", checkAwsTypeList);
        LOGGER.info("rpa-\u8865\u507f\u4e0b\u8f7d-\u9700\u8981\u91cd\u65b0\u7533\u8bf7\u7684\u7968\u79cd\uff1a{}", (Object)checkAwsTypeStr);
        ArrayList<JSONObject> applyList = new ArrayList<JSONObject>(checkAwsTypeList.size());
        String newAwsType = this.handleCustom(applyList, dataType, checkAwsTypeStr, startDate, endDate);
        if (StringUtils.isNotBlank((CharSequence)newAwsType)) {
            JSONObject applyJson = this.newApplyParam(dataType, newAwsType, startDate, endDate);
            applyList.add(applyJson);
        }
        if (CollectionUtils.isEmpty(applyList)) {
            return;
        }
        this.batchApply(applyList, initDynamicObject, orgId, taxNo);
    }

    private void batchApplyBeforeHistoryData(DynamicObject initDynamicObject, List<String> invoiceTypes, String dataType, Long orgId, String taxNo) {
        String newAwsType;
        Date behind2Month;
        Pair<Boolean, String> applyHistoryPair;
        JSONObject applyJson;
        String newAwsType2;
        Pair<Boolean, String> applyHistoryPair2;
        DynamicObjectCollection logcollect;
        Date behindMonth;
        Calendar cal = Calendar.getInstance();
        Date dateNow = new Date();
        String downDate = RimConfigUtils.getConfig("down_date");
        if (StringUtil.isNotEmpty((CharSequence)downDate)) {
            dateNow = DateUtils.stringToDate(downDate);
        }
        cal.setTime(dateNow);
        Date firstDay = DateUtils.getFirstDateOfMonth(dateNow);
        int day = cal.get(5);
        Date startDate = null;
        Date endDate = null;
        int outputApplyDate = InvoiceDownloadConstant.getPageSizeFromConfig(2, "new_output_apply_date");
        int inputApplyDate = InvoiceDownloadConstant.getPageSizeFromConfig(6, "new_input_apply_date");
        int before2MonthApplyDate = InvoiceDownloadConstant.getPageSizeFromConfig(12, "before2_month_apply_date");
        int tryDays = InvoiceDownloadConstant.getPageSizeFromConfig(3, "try_apply_days");
        String appointDaysStr = RimConfigUtils.getConfig("rim_deduction", "appoint_days");
        List<String> appointDays = CommonUtils.getMultiValues(appointDaysStr);
        ArrayList<JSONObject> applyList = new ArrayList<JSONObject>(invoiceTypes.size());
        ArrayList<String> checkInvoiceTypes = new ArrayList<String>(invoiceTypes.size());
        for (String invoiceType : invoiceTypes) {
            if (!this.checkDownCustom(dataType, invoiceType, taxNo)) continue;
            checkInvoiceTypes.add(invoiceType);
        }
        if (CollectionUtils.isEmpty(checkInvoiceTypes)) {
            return;
        }
        LOGGER.info("\u7968\u79cd\u5408\u5e76-\u5f00\u59cb\u7533\u8bf7batchApplyBeforeHistoryData-\u5386\u53f2\u53d1\u7968,{};invoiceType:{};downType:{}", new Object[]{taxNo, ((Object)checkInvoiceTypes).toString(), dataType});
        ArrayList<Object> deleteIdList = new ArrayList<Object>(16);
        String awsInvoiceType = String.join((CharSequence)",", checkInvoiceTypes);
        String downType = "2";
        if ("2".equals(dataType) && this.checkDays(day, outputApplyDate, tryDays, appointDays)) {
            behindMonth = DateUtils.addMonth(firstDay, -1);
            startDate = DateUtils.getFirstDateOfMonth(behindMonth);
            logcollect = this.queryLogDynamicObject(taxNo, awsInvoiceType, dataType, "2", startDate, endDate = DateUtils.getLastDateOfMonthZero(behindMonth));
            if (!CollectionUtils.isEmpty((Collection)logcollect)) {
                this.discardTasksAndUpdate(logcollect, orgId, taxNo, awsInvoiceType, deleteIdList, downType);
            }
            if (((Boolean)(applyHistoryPair2 = this.isApplyHistoryMerge(initDynamicObject, awsInvoiceType, dataType, taxNo, startDate, endDate, deleteIdList)).getLeft()).booleanValue() && StringUtils.isNotBlank((CharSequence)(newAwsType2 = this.handleCustom(applyList, dataType, (String)applyHistoryPair2.getRight(), startDate, endDate)))) {
                applyJson = this.newApplyParam(dataType, newAwsType2, startDate, endDate);
                applyList.add(applyJson);
            }
        }
        if ("1".equals(dataType) && this.checkDays(day, inputApplyDate, tryDays, appointDays)) {
            behindMonth = DateUtils.addMonth(firstDay, -1);
            startDate = DateUtils.getFirstDateOfMonth(behindMonth);
            logcollect = this.queryLogDynamicObject(taxNo, awsInvoiceType, dataType, "2", startDate, endDate = DateUtils.getLastDateOfMonthZero(behindMonth));
            if (!CollectionUtils.isEmpty((Collection)logcollect)) {
                this.discardTasksAndUpdate(logcollect, orgId, taxNo, awsInvoiceType, deleteIdList, downType);
            }
            if (((Boolean)(applyHistoryPair2 = this.isApplyHistoryMerge(initDynamicObject, awsInvoiceType, dataType, taxNo, startDate, endDate, deleteIdList)).getLeft()).booleanValue() && StringUtils.isNotBlank((CharSequence)(newAwsType2 = this.handleCustom(applyList, dataType, (String)applyHistoryPair2.getRight(), startDate, endDate)))) {
                applyJson = this.newApplyParam(dataType, newAwsType2, startDate, endDate);
                applyList.add(applyJson);
            }
        }
        if (this.checkDays(day, before2MonthApplyDate, tryDays, appointDays) && ((Boolean)(applyHistoryPair = this.isApplyHistoryMerge(initDynamicObject, awsInvoiceType, dataType, taxNo, startDate = DateUtils.getFirstDateOfMonth(behind2Month = DateUtils.addMonth(firstDay, -2)), endDate = DateUtils.getLastDateOfMonthZero(behind2Month), deleteIdList)).getLeft()).booleanValue() && StringUtils.isNotBlank((CharSequence)(newAwsType = this.handleCustom(applyList, dataType, (String)applyHistoryPair.getRight(), startDate, endDate)))) {
            JSONObject applyJson2 = this.newApplyParam(dataType, newAwsType, startDate, endDate);
            applyList.add(applyJson2);
        }
        if (CollectionUtils.isEmpty(applyList)) {
            return;
        }
        this.batchApply(applyList, initDynamicObject, orgId, taxNo);
        if (!deleteIdList.isEmpty()) {
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"rim_down_log"), (Object[])deleteIdList.toArray());
        }
    }

    private String handleCustom(List<JSONObject> applyList, String dataType, String awsInvoiceType, Date startDate, Date endDate) {
        if (StringUtils.isBlank((CharSequence)awsInvoiceType)) {
            return awsInvoiceType;
        }
        if (!awsInvoiceType.contains("21")) {
            return awsInvoiceType;
        }
        JSONObject applyJson = this.newApplyParam(dataType, "21", startDate, endDate);
        applyList.add(applyJson);
        List newAwsTypeList = CommonUtils.getMultiValues(awsInvoiceType).stream().filter(t -> !"21".equals(t)).collect(Collectors.toList());
        return CollectionUtils.isEmpty(newAwsTypeList) ? "" : String.join((CharSequence)",", newAwsTypeList);
    }

    private void batchApplyInitHistoryData(DynamicObject initDynamicObject, List<String> invoiceTypes, String dataType, Long orgId, String taxNo, List<Map<String, Date>> initDateList) {
        if (CollectionUtils.isEmpty(initDateList)) {
            return;
        }
        ArrayList<Map<String, Date>> initDateListNew = new ArrayList<Map<String, Date>>(1);
        InvoiceApplyLogService service = new InvoiceApplyLogService();
        for (Map<String, Date> stringDateMap : initDateList) {
            String newAwsType;
            Date begin = stringDateMap.get("begin");
            Date end = stringDateMap.get("end");
            ArrayList<JSONObject> applyList = new ArrayList<JSONObject>(invoiceTypes.size());
            ArrayList<String> checkInvoiceTypes = new ArrayList<String>(invoiceTypes.size());
            for (String invoiceType : invoiceTypes) {
                if (!this.checkDownCustom(dataType, invoiceType, taxNo)) continue;
                checkInvoiceTypes.add(invoiceType);
            }
            if (CollectionUtils.isEmpty(checkInvoiceTypes)) continue;
            LOGGER.info("\u7968\u79cd\u5408\u5e76-\u5f00\u59cb\u7533\u8bf7\u5386\u53f2\u53d1\u7968,{};invoiceType:{};downType:{};{}-{}", new Object[]{taxNo, ((Object)checkInvoiceTypes).toString(), dataType, DateUtils.format(begin), DateUtils.format(end)});
            String awsInvoiceType = String.join((CharSequence)",", checkInvoiceTypes);
            String asyncFlag = RimConfigUtils.getConfig("rim_deduction", "init_down_async");
            if (!"0".equals(asyncFlag)) {
                initDateListNew.clear();
                initDateListNew.add(stringDateMap);
                service.saveInitApplyLog(orgId, taxNo, dataType, awsInvoiceType, initDateListNew);
                continue;
            }
            ArrayList<Object> deleteIdList = new ArrayList<Object>(16);
            Pair<Boolean, String> applyHistoryPair = this.isApplyHistoryMerge(initDynamicObject, awsInvoiceType, dataType, taxNo, begin, end, deleteIdList);
            if (((Boolean)applyHistoryPair.getLeft()).booleanValue() && StringUtils.isNotBlank((CharSequence)(newAwsType = this.handleCustom(applyList, dataType, (String)applyHistoryPair.getRight(), begin, end)))) {
                JSONObject applyJson = this.newApplyParam(dataType, newAwsType, begin, end);
                applyList.add(applyJson);
            }
            this.batchApply(applyList, initDynamicObject, orgId, taxNo);
            if (deleteIdList.isEmpty()) continue;
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"rim_down_log"), (Object[])deleteIdList.toArray());
        }
    }

    public void batchApplyTodayData(DynamicObject initDynamicObject, List<String> invoiceTypes, String dataType, Long orgId, String taxNo) {
        String asyncFlag = RimConfigUtils.getConfig("rim_deduction", "down_today");
        if ("1".equals(asyncFlag)) {
            Date startDate;
            Date endDate = startDate = DateUtils.trunc(new Date());
            ArrayList<JSONObject> applyList = new ArrayList<JSONObject>(invoiceTypes.size());
            QFilter startFilter = new QFilter("invoice_startdate", ">=", (Object)startDate);
            QFilter endFilter = new QFilter("invoice_enddate", "<=", (Object)endDate);
            QFilter syncTypeFilter = new QFilter("sync_type", "=", (Object)"7");
            QFilter taxNoFilter = new QFilter("tax_no", "=", (Object)taxNo);
            QFilter dataTypeFilter = new QFilter("inout", "=", (Object)dataType);
            QFilter statusFilter = new QFilter("gov_status", "=", (Object)"6");
            DeleteServiceHelper.delete((String)"rim_down_log", (QFilter[])new QFilter[]{taxNoFilter, syncTypeFilter, dataTypeFilter, startFilter, endFilter, statusFilter});
            HashSet<String> invoiceTypeSet = new HashSet<String>(8);
            for (String invoiceType : invoiceTypes) {
                if (!this.checkDownCustom(dataType, invoiceType, taxNo)) continue;
                invoiceTypeSet.add(invoiceType);
            }
            boolean haveHgjks = invoiceTypeSet.contains(InputInvoiceTypeEnum.HGJKS.getAwsType());
            if (haveHgjks) {
                invoiceTypeSet.remove(InputInvoiceTypeEnum.HGJKS.getAwsType());
                JSONObject applyJson = this.newApplyParam(dataType, InputInvoiceTypeEnum.HGJKS.getAwsType(), startDate, endDate);
                applyJson.put("syncType", (Object)"7");
                applyList.add(applyJson);
            }
            if (!invoiceTypeSet.isEmpty()) {
                String invoiceTypeStrings = String.join((CharSequence)",", invoiceTypeSet);
                JSONObject applyJson = this.newApplyParam(dataType, invoiceTypeStrings, startDate, endDate);
                applyJson.put("syncType", (Object)"7");
                applyList.add(applyJson);
            }
            if (CollectionUtils.isEmpty(applyList)) {
                return;
            }
            this.batchApply(applyList, initDynamicObject, orgId, taxNo);
        }
    }

    public Pair<Boolean, String> isApplyHistoryMerge(DynamicObject initDynamicObject, String invoiceType, String dataType, String taxNo, Date firstDay, Date endDate, List<Object> deleteIdList) {
        LOGGER.info("rpa-\u5f00\u59cb\u68c0\u67e5\u7533\u8bf7\u5386\u53f2\u53d1\u7968\u662f\u5426\u9700\u8981\u7533\u8bf7, {};invoiceType:{};downType:{};{}-{}", new Object[]{taxNo, invoiceType, dataType, DateUtils.format(firstDay), DateUtils.format(endDate)});
        if (initDynamicObject != null) {
            Date beginDownDate = initDynamicObject.getDate("begin");
            if (firstDay.before(beginDownDate = DateUtils.getFirstDateOfMonth(beginDownDate))) {
                return Pair.of((Object)Boolean.FALSE, (Object)"");
            }
        }
        DynamicObjectCollection logDynamicObjectList = this.queryLogDynamicObject(taxNo, invoiceType, dataType, "3", firstDay, endDate);
        Set awsTypeParamSet = CommonUtils.getMultiValues(invoiceType).stream().collect(Collectors.toSet());
        HashSet<String> notApplyAwsTypeSet = new HashSet<String>();
        if (!CollectionUtils.isEmpty((Collection)logDynamicObjectList)) {
            for (DynamicObject logDynamicObject : logDynamicObjectList) {
                if (logDynamicObject == null) continue;
                String awsInvoiceType = logDynamicObject.getString("aws_invoice_type");
                if ("7".equals(logDynamicObject.getString("gov_status"))) {
                    awsTypeParamSet.addAll(CommonUtils.getMultiValues(awsInvoiceType));
                    deleteIdList.add(logDynamicObject.get("id"));
                    continue;
                }
                notApplyAwsTypeSet.addAll(CommonUtils.getMultiValues(awsInvoiceType));
            }
            Set checkAwsTypeList = awsTypeParamSet.stream().filter(t -> !notApplyAwsTypeSet.contains(t)).collect(Collectors.toSet());
            if (CollectionUtils.isEmpty(checkAwsTypeList)) {
                LOGGER.info("rpa-\u4e0d\u9700\u8981\u91cd\u65b0\u7533\u8bf7\uff0c\u7533\u8bf7\u8bb0\u5f55\u5df2\u5b58\u5728");
                return Pair.of((Object)Boolean.FALSE, (Object)"");
            }
            String checkAwsTypeStr = String.join((CharSequence)",", checkAwsTypeList);
            LOGGER.info("rpa-\u9700\u8981\u91cd\u65b0\u7533\u8bf7\u7684\u7968\u79cd\uff1a{}", (Object)checkAwsTypeStr);
            return Pair.of((Object)Boolean.TRUE, (Object)checkAwsTypeStr);
        }
        LOGGER.info("rpa-\u4e4b\u524d\u5bf9\u5e94\u6708\u4efd\u65e0\u7533\u8bf7\u6570\u636e\uff0c\u6240\u6709\u7968\u79cd\u90fd\u8fdb\u884c\u7533\u8bf7");
        return Pair.of((Object)Boolean.TRUE, (Object)invoiceType);
    }

    public void batchApplyCurrentData(DynamicObject initDynamicObject, List<String> invoiceTypes, String dataType, Long orgId, String taxNo) {
        ArrayList<JSONObject> applyList = new ArrayList<JSONObject>(invoiceTypes.size());
        int days = InvoiceDownloadConstant.getPageSizeFromConfig(3, "newetax_inputout_days");
        if (days < 1) {
            days = 3;
        }
        Calendar cal = Calendar.getInstance();
        Date dateNow = new Date();
        String downDate = RimConfigUtils.getConfig("down_date");
        if (StringUtil.isNotEmpty((CharSequence)downDate)) {
            dateNow = DateUtils.stringToDate(downDate);
        }
        cal.setTime(dateNow);
        Date lastDate = DateUtils.getLastDateOfMonthZero(dateNow);
        String lastDateApply = RimConfigUtils.getConfig("rim_deduction", "rpa_last_date_apply");
        boolean isLastDate = "1".equals(lastDateApply) && DateUtils.format(lastDate).equals(DateUtils.format(dateNow));
        int day = cal.get(5);
        if (days > 1 && day % days != 0 && day != 1 && !isLastDate) {
            return;
        }
        if (days > 31) {
            return;
        }
        Date endDate = DateUtils.trunc(dateNow);
        endDate = DateUtils.addDay(endDate, -1);
        Date firstMonthDate = DateUtils.getFirstDateOfMonth(endDate);
        if (isLastDate) {
            Date startDay = firstMonthDate;
            endDate = lastDate;
        }
        HashSet<String> invoiceTypeSet = new HashSet<String>(8);
        for (String invoiceType : invoiceTypes) {
            if (!this.checkDownCustom(dataType, invoiceType, taxNo)) continue;
            invoiceTypeSet.add(invoiceType);
        }
        boolean haveHgjks = invoiceTypeSet.contains(InputInvoiceTypeEnum.HGJKS.getAwsType());
        if (haveHgjks) {
            invoiceTypeSet.remove(InputInvoiceTypeEnum.HGJKS.getAwsType());
        }
        ArrayList<Object> deleteIdList = new ArrayList<Object>(16);
        String invoiceTypesString = String.join((CharSequence)",", invoiceTypeSet);
        if (haveHgjks) {
            this.addCurrentDateTask(dataType, orgId, taxNo, applyList, endDate, firstMonthDate, deleteIdList, InputInvoiceTypeEnum.HGJKS.getAwsType());
        }
        if (StringUtils.isNotEmpty((CharSequence)invoiceTypesString)) {
            this.addCurrentDateTask(dataType, orgId, taxNo, applyList, endDate, firstMonthDate, deleteIdList, invoiceTypesString);
        }
        if (CollectionUtils.isEmpty(applyList)) {
            return;
        }
        this.batchApply(applyList, initDynamicObject, orgId, taxNo);
        if (!deleteIdList.isEmpty()) {
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"rim_down_log"), (Object[])deleteIdList.toArray());
        }
    }

    private void addCurrentDateTask(String dataType, Long orgId, String taxNo, List<JSONObject> applyList, Date endDate, Date firstMonthDate, List<Object> deleteIdList, String invoiceTypesString) {
        DynamicObjectCollection logcollect = this.queryLogDynamicObject(taxNo, invoiceTypesString, dataType, "2", firstMonthDate, endDate);
        if (logcollect == null || logcollect.isEmpty()) {
            JSONObject applyJson = this.newApplyParam(dataType, invoiceTypesString, firstMonthDate, endDate);
            applyList.add(applyJson);
        } else {
            if (this.discardTasksAndUpdate(logcollect, orgId, taxNo, invoiceTypesString, deleteIdList, "1").booleanValue()) {
                logcollect = this.queryLogDynamicObject(taxNo, null, dataType, "2", firstMonthDate, endDate);
            }
            List<Map<String, Date>> dateRangeList = this.mergeDateRanges(logcollect, endDate, deleteIdList, invoiceTypesString);
            for (Map<String, Date> dateRange : dateRangeList) {
                applyList.add(this.newApplyParam(dataType, invoiceTypesString, dateRange.get("startDate"), dateRange.get("endDate")));
            }
        }
    }

    private Boolean discardTasksAndUpdate(DynamicObjectCollection logcollect, Long orgId, String taxNo, String invoiceTypesString, List<Object> deleteIdList, String downType) {
        JSONObject discardParam = new JSONObject();
        discardParam.put("taxNo", (Object)taxNo);
        ArrayList<String> batchNos = new ArrayList<String>(logcollect.size());
        HashMap<String, DynamicObject> idMap = new HashMap<String, DynamicObject>(logcollect.size());
        int downHours = InvoiceDownloadConstant.getPageSizeFromConfig(24, "repelnish_down_hour");
        Date now = new Date();
        for (DynamicObject obj : logcollect) {
            String awsInvoiceType = obj.getString("aws_invoice_type");
            String govStatus = obj.getString("gov_status");
            Date createtime = obj.getDate("createtime");
            if (StringUtils.equals((CharSequence)"2", (CharSequence)downType)) {
                List<String> awsTypes = CommonUtils.getMultiValues(awsInvoiceType);
                List<String> paramInvoiceTypes = CommonUtils.getMultiValues(invoiceTypesString);
                boolean ignoreTask = false;
                for (String awsType : awsTypes) {
                    if (paramInvoiceTypes.contains(awsType)) continue;
                    ignoreTask = true;
                    break;
                }
                if (ignoreTask || !"6".equals(govStatus) || this.isWholeMonth(obj)) continue;
                batchNos.add(obj.getString("taskno"));
                idMap.put(obj.getString("taskno"), obj);
                continue;
            }
            if (awsInvoiceType != null && !this.isContainsAllInvoiceTypes(invoiceTypesString, awsInvoiceType) || !"6".equals(govStatus) || this.isWholeMonth(obj) || createtime != null && now.before(DateUtils.addHour(createtime, downHours))) continue;
            batchNos.add(obj.getString("taskno"));
            idMap.put(obj.getString("taskno"), obj);
        }
        if (CollectionUtils.isEmpty(batchNos)) {
            return false;
        }
        discardParam.put("batchNos", batchNos);
        NewEtaxDeductService service = new NewEtaxDeductService(orgId);
        JSONObject discardResult = service.discardTasks(discardParam);
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(batchNos.size());
        if (ResultContant.isSuccess(discardResult).booleanValue()) {
            JSONArray array = discardResult.getJSONArray("data");
            ArrayList<String> rtnBatchNos = new ArrayList<String>(batchNos.size());
            for (int i = 0; i < array.size(); ++i) {
                JSONObject item = array.getJSONObject(i);
                rtnBatchNos.add(item.getString("batchNo"));
                String status = item.getString("status");
                if (!"02".equals(status) && !"04".equals(status) && !"05".equals(status)) continue;
                DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"rim_down_log");
                Object id = ((DynamicObject)idMap.get(item.get((Object)"batchNo"))).get("id");
                deleteIdList.add(id);
                obj.set("id", id);
                obj.set("gov_status", (Object)"7");
                updateList.add(obj);
            }
            batchNos.removeAll(rtnBatchNos);
            if (!CollectionUtils.isEmpty(batchNos)) {
                for (String batchNo : batchNos) {
                    DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"rim_down_log");
                    Object id = ((DynamicObject)idMap.get(batchNo)).get("id");
                    deleteIdList.add(id);
                    obj.set("id", id);
                    obj.set("gov_status", (Object)"5");
                    updateList.add(obj);
                }
            }
        }
        if (updateList.size() > 0) {
            SaveServiceHelper.update((DynamicObject[])updateList.toArray(new DynamicObject[0]));
        }
        return updateList.size() > 0;
    }

    private boolean isWholeMonth(DynamicObject obj) {
        if (obj == null) {
            return false;
        }
        Date startdate = obj.getDate("invoice_startdate");
        Date enddate = obj.getDate("invoice_enddate");
        if (startdate != null && enddate != null) {
            Date startdateNew = DateUtils.trunc(startdate);
            Date enddateNew = DateUtils.trunc(enddate);
            return DateUtils.trunc(DateUtils.getFirstDateOfMonth(startdate)).equals(startdateNew) && DateUtils.trunc(DateUtils.getLastDateOfMonth(enddate)).equals(enddateNew);
        }
        return false;
    }

    private boolean isContainsAllInvoiceTypes(String awsInvoiceType, String invoiceTypesString) {
        if (StringUtils.isEmpty((CharSequence)awsInvoiceType) || StringUtils.isEmpty((CharSequence)invoiceTypesString)) {
            return true;
        }
        List<String> awsTypes = CommonUtils.getMultiValues(awsInvoiceType);
        List<String> invoiceTypes = CommonUtils.getMultiValues(invoiceTypesString);
        return awsTypes.containsAll(invoiceTypes);
    }

    private List<Map<String, Date>> mergeDateRanges(DynamicObjectCollection logcollect, Date endDate, List<Object> deleteIdList, String invoiceTypesString) {
        if (logcollect == null || logcollect.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Map<String, Date>> dateRangs = new ArrayList<Map<String, Date>>(logcollect.size());
        for (DynamicObject obj : logcollect) {
            String status = obj.getString("gov_status");
            String awsInvoiceType = obj.getString("aws_invoice_type");
            if (!this.isContainsAllInvoiceTypes(awsInvoiceType, invoiceTypesString)) continue;
            if ("1".equals(status) || "8".equals(status) || "6".equals(status) || "9".equals(status)) {
                HashMap<String, Date> map = new HashMap<String, Date>(2);
                map.put("startDate", obj.getDate("invoice_startdate"));
                Date invoiceEnddate = obj.getDate("invoice_enddate");
                if (invoiceEnddate.compareTo(endDate) > 0) {
                    map.put("endDate", endDate);
                } else {
                    map.put("endDate", invoiceEnddate);
                }
                dateRangs.add(map);
                continue;
            }
            if (!"5".equals(status) && !"7".equals(status)) continue;
            deleteIdList.add(obj.get("id"));
        }
        if (dateRangs.isEmpty()) {
            HashMap<String, Date> map = new HashMap<String, Date>(2);
            map.put("startDate", DateUtils.getFirstDateOfMonth(endDate));
            map.put("endDate", endDate);
            dateRangs.add(map);
            return dateRangs;
        }
        List<Map<String, Date>> missingDateRanges = DateUtils.findMissingDateRanges(dateRangs, endDate);
        if (CollectionUtils.isEmpty(missingDateRanges)) {
            return missingDateRanges;
        }
        if (InputInvoiceTypeEnum.HGJKS.getAwsType().equals(invoiceTypesString)) {
            HashMap<String, Date> map = new HashMap<String, Date>(2);
            map.put("startDate", DateUtils.getFirstDateOfMonth(endDate));
            map.put("endDate", endDate);
            dateRangs.add(map);
            return dateRangs;
        }
        int repeatDays = InvoiceDownloadConstant.getPageSizeFromConfig(3, "newetax_repeat_days");
        if (repeatDays < 0) {
            repeatDays = 3;
        }
        if (missingDateRanges.size() == 1) {
            Map<String, Date> map = missingDateRanges.get(0);
            this.addDayToLast(repeatDays, map);
            return missingDateRanges;
        }
        missingDateRanges.sort(Comparator.comparing(range -> (Date)range.get("startDate")));
        this.addDayToLast(repeatDays, missingDateRanges.get(missingDateRanges.size() - 1));
        return DateUtils.mergeDateRanges(missingDateRanges);
    }

    private void addDayToLast(int repeatDays, Map<String, Date> map) {
        if (map == null) {
            return;
        }
        Date startDate = map.get("startDate");
        Date endDate = map.get("endDate");
        if (startDate == null || endDate == null) {
            return;
        }
        Date firstDate = DateUtils.getFirstDateOfMonth(endDate);
        if ((startDate = DateUtils.addDay(startDate, 1 - repeatDays)).before(firstDate)) {
            startDate = firstDate;
        }
        map.put("startDate", startDate);
    }

    public void batchApply(List<JSONObject> batchParams, DynamicObject initDynamicObject, Long orgId, String taxNo) {
        if (CollectionUtils.isEmpty(batchParams)) {
            return;
        }
        String requuid = UUID.randomUUID();
        for (JSONObject applyJson : batchParams) {
            applyJson.put("serialNo", (Object)requuid);
            this.applyInputOutDownInvoiceNew(initDynamicObject, orgId, taxNo, applyJson);
        }
    }

    public JSONObject newApplyParam(String dataType, String invoiceType, Date startTime, Date endTime) {
        JSONObject applyJson = new JSONObject();
        applyJson.put("dataType", (Object)Integer.valueOf(dataType));
        String billType = "0";
        if (StringUtils.isBlank((CharSequence)invoiceType)) {
            invoiceType = "-1";
        }
        if (InputInvoiceTypeEnum.HGJKS.getAwsType().equals(invoiceType)) {
            billType = "1";
        }
        applyJson.put("invoiceType", (Object)invoiceType);
        if ("0".equals(billType)) {
            String[] types;
            HashSet<Integer> invoiceTypeSet = new HashSet<Integer>(1);
            for (String type : types = invoiceType.split(",")) {
                int typeInt = BigDecimalUtil.transDecimal(type).intValue();
                if (typeInt <= 0) continue;
                invoiceTypeSet.add(typeInt);
            }
            applyJson.put("invoiceTypes", invoiceTypeSet);
            int invoiceStatus = -1;
            applyJson.put("invoiceStatus", (Object)invoiceStatus);
        }
        applyJson.put("billType", (Object)billType);
        applyJson.put("startTime", (Object)DateUtils.format(startTime));
        applyJson.put("startDate", (Object)DateUtils.format(startTime));
        applyJson.put("endTime", (Object)DateUtils.format(endTime));
        applyJson.put("endDate", (Object)DateUtils.format(endTime));
        return applyJson;
    }

    public JSONObject applyInputOutDownInvoiceNew(DynamicObject initDynamicObject, Long orgId, String taxNo, JSONObject param) {
        JSONObject data;
        JSONObject result;
        NewEtaxDeductService deductService = new NewEtaxDeductService(orgId);
        param.put("taxNo", (Object)taxNo);
        if (!InvoiceDownloadConstant.isSyncDown(taxNo)) {
            NewEtaxInOutInvoiceDownServiceImpl downService = new NewEtaxInOutInvoiceDownServiceImpl(false);
            if (this.downEleFileFlag(param) && downService.isDownFile(taxNo)) {
                param.put("applyFileFlag", (Object)true);
                param.put("snapshotMark", (Object)true);
                HashSet<Integer> fileTypes = new HashSet<Integer>(1);
                fileTypes.add(-1);
                param.put("fileTypes", fileTypes);
            }
            result = deductService.applyFullInvoice(param);
        } else {
            data = new JSONObject();
            data.put("batchNo", (Object)UUID.getBatchNoByTaxNo(taxNo));
            result = ResultContant.createSuccessJSONObject(data);
        }
        if (result != null && ResultContant.isSuccess(result).booleanValue()) {
            String account;
            data = result.getJSONObject("data");
            String rwh = data.getString("batchNo");
            String fileBatchNo = data.getString("fileBatchNo");
            Date startTime = Optional.ofNullable(param.getDate("startTime")).orElseGet(() -> DateUtils.stringToDate(param.getString("startTaxPeriod"), "yyyyMM"));
            Date endTime = Optional.ofNullable(param.getDate("endTime")).orElseGet(() -> DateUtils.stringToDate(param.getString("endTaxPeriod"), "yyyyMM"));
            JSONObject resultJson = this.convertApplyResult(rwh, param.getString("dataType"), param.getString("invoiceType"), startTime, endTime, param.getString("serialNo"));
            if (StringUtils.isNotBlank((CharSequence)fileBatchNo)) {
                resultJson.put("fileBatchNo", (Object)fileBatchNo);
            }
            if (StringUtils.isNotBlank((CharSequence)(account = result.getString("account")))) {
                resultJson.put("account", (Object)account);
            }
            this.dealResult(resultJson, initDynamicObject, param.getLong("logId"), orgId, taxNo, param.getString("invoiceType"), param.getString("syncType"));
            result.put("batchNo", (Object)resultJson.getString("batchNo"));
        }
        return result;
    }

    private boolean downEleFileFlag(JSONObject param) {
        int dataType = param.getIntValue("dataType");
        if (1 != dataType) {
            return false;
        }
        Object invoiceTypes = param.get((Object)"invoiceTypes");
        if (invoiceTypes != null) {
            HashSet<Integer> supportDownFileSet = new HashSet<Integer>(4);
            supportDownFileSet.add(-1);
            supportDownFileSet.add(26);
            supportDownFileSet.add(27);
            supportDownFileSet.add(28);
            supportDownFileSet.add(29);
            Set invoiceTypeSet = (Set)invoiceTypes;
            Iterator iterator = invoiceTypeSet.iterator();
            while (iterator.hasNext()) {
                int invoiceType = (Integer)iterator.next();
                if (!supportDownFileSet.contains(invoiceType)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public JSONObject applyInputOutDownInvoice(Long logId, DynamicObject initDynamicObject, String invoiceType, String dataType, Long orgId, String taxNo, Date begin, Date end) {
        JSONObject applyJson = this.newApplyParam(dataType, invoiceType, begin, end);
        applyJson.put("logId", (Object)logId);
        applyJson.put("serialNo", (Object)UUID.randomUUID());
        return this.applyInputOutDownInvoiceNew(initDynamicObject, orgId, taxNo, applyJson);
    }

    @Override
    public boolean checkDownCustom(String inout, String invoiceType, String taxNo) {
        if (InvoiceDownloadConstant.isElectricPaper(invoiceType) || InputInvoiceTypeEnum.WITHHOLDING.getAwsType().equals(invoiceType)) {
            return false;
        }
        return super.checkDownCustom(inout, invoiceType, taxNo);
    }
}

