/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.download.impl;

import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.Callable;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.invoice.download.InvoiceDealService;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.LockUtils;

public class OutputInvoiceDealService
extends InvoiceDealService
implements Callable<Boolean> {
    private static final Log LOGGER = LogFactory.getLog(OutputInvoiceDealService.class);
    private RequestContext rc;
    private Object id;

    public OutputInvoiceDealService(RequestContext rc, Object id) {
        this.rc = rc;
        this.id = id;
    }

    @Override
    public void dealSingle(RequestContext requestContext, DynamicObject data) {
        Integer handleNum;
        Integer n = handleNum = Integer.valueOf(data.getInt("handle_num"));
        Integer n2 = handleNum = Integer.valueOf(handleNum + 1);
        data.set("handle_num", (Object)handleNum);
        String serialNo = data.getString("serial_no");
        String inout = data.getString("inout");
        String key = "rim.dealoutputinvoice-" + serialNo;
        try (DLock lock = LockUtils.createDLockByMd5((String)key, (String)"OutputInvoiceDealService.lock");){
            if (lock.tryLock()) {
                Long invoiceType = DynamicObjectUtil.getDynamicObjectLongValue(data.get("invoice_type"));
                String invoiceJsonStr = data.getString("invoice_json_tag");
                JSONObject invoiceJson = JSONObject.parseObject((String)invoiceJsonStr);
                JSONObject rusultJson = null;
                if ("2".equals(inout)) {
                    String salerTaxNo = invoiceJson.getString("salerTaxNo");
                    Long configOrg = this.getOrgIdByTaxNo(salerTaxNo);
                    long orgId = DynamicObjectUtil.getDynamicObjectLongValue(data.get("org"));
                    if (configOrg != null && configOrg > 0L) {
                        orgId = configOrg;
                    } else if (orgId <= 0L) {
                        orgId = requestContext.getOrgId();
                    }
                    invoiceJson.put("orgid", (Object)orgId);
                    invoiceJson.put("invoiceAmount", (Object)CommonUtils.getJsonValue((Map<String, Object>)invoiceJson, String.class, "amount", "invoiceMoney", "invoiceAmount"));
                    Date invalidDate = invoiceJson.getDate("invalidDate");
                    if (invalidDate != null) {
                        invoiceJson.put("invalidDate", (Object)DateUtils.format(invalidDate, "yyyy-MM-dd"));
                    }
                    rusultJson = this.saveOutputInvoice(invoiceJson);
                } else if ("8".equals(inout)) {
                    rusultJson = this.saveOutputInvoiceFile(invoiceJson);
                }
                LOGGER.info("\u4fdd\u5b58\u9500\u9879\u7ed3\u679c\uff1a{},{},{}", new Object[]{serialNo, rusultJson, inout});
                if (rusultJson != null && "0000".equals(rusultJson.getString("errorCode"))) {
                    data.set("sync_status", (Object)"1");
                }
                if (!"1".equals(data.getString("sync_status")) && handleNum > 3) {
                    data.set("sync_status", (Object)"0");
                }
                data.set("modifytime", (Object)new Date());
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{data});
                this.updateDownAccount(data.getString("sync_status"), serialNo, serialNo, inout, invoiceType);
            }
        }
        catch (Throwable e) {
            if (!"1".equals(data.getString("sync_status")) && handleNum > 3) {
                data.set("sync_status", (Object)"0");
            }
            data.set("modifytime", (Object)new Date());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{data});
            LOGGER.error("InputInvoiceDownDealTask-error:" + serialNo, e);
        }
    }

    private JSONObject saveOutputInvoiceFile(JSONObject param) {
        Object result = DispatchServiceHelper.invokeBizService((String)"imc", (String)"sim", (String)"InvoiceAddServiceImpl", (String)"addInvoiceFile", (Object[])new Object[]{param});
        if (StringUtils.isBlank((Object)result)) {
            return null;
        }
        return JSONObject.parseObject((String)((String)result));
    }

    private JSONObject saveOutputInvoice(JSONObject param) {
        Object result = DispatchServiceHelper.invokeBizService((String)"imc", (String)"sim", (String)"InvoiceAddServiceImpl", (String)"addInvoice", (Object[])new Object[]{param});
        if (StringUtils.isBlank((Object)result)) {
            return null;
        }
        return JSONObject.parseObject((String)((String)result));
    }

    @Override
    public Boolean call() throws Exception {
        RequestContext.copyAndSet((RequestContext)this.rc);
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"rim_down_input");
        DynamicObject data = BusinessDataServiceHelper.loadSingle((Object)this.id, (DynamicObjectType)mainEntityType);
        this.dealSingle(this.rc, data);
        return Boolean.TRUE;
    }
}

