/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.fpzs;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.rim.common.constant.BussinSysBillStatusEnum;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.expense.domain.ExpenseCoverDTO;
import kd.imc.rim.common.expense.domain.ExpenseDTO;
import kd.imc.rim.common.expense.domain.ExpenseInvoiceDTO;
import kd.imc.rim.common.expense.domain.ExpenseVoucherDTO;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.service.InvoiceLog;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.SysParamUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class FpzsCommonService {
    private static final Log logger = LogFactory.getLog(FpzsCommonService.class);

    public static ExpenseDTO getApiExpenseDTO(Map<String, Object> param) {
        String json = SerializationUtils.toJsonString(param);
        logger.info("getApiExpenseDTO-param:" + json);
        JSONObject jsonObj = JSONObject.parseObject((String)json);
        jsonObj.put("entityId", (Object)jsonObj.getString("billType"));
        if (StringUtils.isBlank((String)jsonObj.getString("billId"))) {
            throw new MsgException(ErrorType.PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u6765\u6e90\u7cfb\u7edf\u5355\u636e\u552f\u4e00ID\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FpzsCommonService_0", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((String)jsonObj.getString("billNo"))) {
            throw new MsgException(ErrorType.PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u6765\u6e90\u7cfb\u7edf\u5355\u636e\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FpzsCommonService_1", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((String)jsonObj.getString("bussinSysCode"))) {
            throw new MsgException(ErrorType.PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u6765\u6e90\u7cfb\u7edf\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FpzsCommonService_2", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((String)jsonObj.getString("billType"))) {
            throw new MsgException(ErrorType.PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u5355\u636e\u63a7\u5236\u89c4\u5219\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FpzsCommonService_3", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        return FpzsCommonService.getNewExpenseDTO((Map<String, Object>)jsonObj);
    }

    public static ExpenseDTO getNewExpenseDTO(Map<String, Object> param) {
        JSONObject coverData;
        JSONArray voucherInfo;
        ArrayList<ExpenseVoucherDTO> subList;
        String json = SerializationUtils.toJsonString(param);
        logger.info("getNewExpenseDTO-param:" + json);
        JSONObject jsonObj = JSONObject.parseObject((String)json);
        String billId = jsonObj.getString("billId");
        if (StringUtils.isBlank((String)billId)) {
            throw new MsgException(ErrorType.PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u6765\u6e90\u7cfb\u7edf\u5355\u636e\u552f\u4e00ID\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FpzsCommonService_0", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        String billNo = jsonObj.getString("billNo");
        String billType = jsonObj.getString("billType");
        String entityId = jsonObj.getString("entityId");
        String viewPage = jsonObj.getString("viewPage");
        String resource = FpzsCommonService.getResource(jsonObj);
        String status = jsonObj.getString("status");
        String billUser = jsonObj.getString("billUser");
        String batch = jsonObj.getString("batch");
        String updateInvoiceOrg = jsonObj.getString("updateInvoiceOrg");
        if (StringUtils.isEmpty((String)billUser)) {
            billUser = RequestContext.get().getUserId();
        }
        Long orgId = jsonObj.getLong("orgId");
        ExpenseDTO dto = new ExpenseDTO();
        Boolean isAllowRepeat = jsonObj.getBoolean("isAllowRepeat");
        if (isAllowRepeat != null) {
            dto.setAllowRepeat(isAllowRepeat);
        }
        dto.setExpenseId(billId);
        dto.setExpenseNum(billNo);
        dto.setExpenseType(billType);
        dto.setResource(resource);
        dto.setEntityId(entityId);
        dto.setViewPage(viewPage);
        dto.setStatus(status);
        dto.setBillUser(billUser);
        dto.setOrgId(orgId);
        dto.setOriginalId(jsonObj.getString("originalId"));
        dto.setOriginalType(jsonObj.getString("originalType"));
        if (StringUtils.isNotEmpty((String)dto.getOriginalId()) && StringUtils.isEmpty((String)dto.getOriginalType())) {
            dto.setOriginalType(dto.getEntityId());
        }
        dto.setBatch(batch);
        FpzsCommonService.setBotpBillList(jsonObj, dto);
        if (StringUtils.equals((String)updateInvoiceOrg, (String)"1")) {
            dto.setUpdateInvoiceOrg(true);
        }
        if (dto.getOrgId() == null || dto.getOrgId() < 0L) {
            dto.setOrgId(RequestContext.get().getOrgId());
        }
        dto.setOriginalId(jsonObj.getString("originalId"));
        dto.setOriginalType(jsonObj.getString("originalType"));
        if (StringUtils.isNotEmpty((String)dto.getOriginalId()) && StringUtils.isEmpty((String)dto.getOriginalType())) {
            dto.setOriginalType(dto.getEntityId());
        }
        dto.setBussinSysBillStatus(jsonObj.getString("bussinSysBillStatus"));
        dto.setApplyOrgId(jsonObj.getLong("applyOrgId"));
        dto.setBussinSysOrgCode(jsonObj.getString("bussinSysOrgCode"));
        dto.setBussinSysBillOrgCode(jsonObj.getString("bussinSysBillOrgCode"));
        dto.setBillTotalAmount(jsonObj.getBigDecimal("billTotalAmount"));
        dto.setBillTotalTaxAmount(jsonObj.getBigDecimal("billTotalTaxAmount"));
        dto.setCurrencyId(jsonObj.getLong("currencyId"));
        dto.setCountry(jsonObj.getLong("countryId"));
        dto.setPaymentTerms(jsonObj.getString("paymentTerms"));
        dto.setPaymentMethod(jsonObj.getString("paymentMethod"));
        dto.setDueDate(jsonObj.getDate("dueDate"));
        dto.setBussinSysUserId(jsonObj.getString("bussinSysUserId"));
        dto.setUserLoginId(jsonObj.getString("userLoginId"));
        dto.setExpenseTime(jsonObj.getDate("createTime"));
        dto.setUpdateTime(jsonObj.getDate("updateTime"));
        dto.setFullPayFlag(jsonObj.getString("fullPayFlag"));
        dto.setCreatorName(jsonObj.getString("userName"));
        dto.setInvoiceUpdateType(jsonObj.getString("invoiceUpdateType"));
        dto.setAttachmentUpdateType(jsonObj.getString("attachmentUpdateType"));
        JSONArray invoiceData = jsonObj.getJSONArray("invoiceData");
        if (invoiceData != null) {
            boolean updateDeductionPurpose = false;
            if (dto.getOrgId() != null && dto.getOrgId() > 0L) {
                updateDeductionPurpose = SysParamUtil.getSysParamByOrgId(dto.getOrgId(), "update_deduction_purpose");
                logger.info("\u7ec4\u7ec7id: {}, \u5355\u636e\u662f\u5426\u53ef\u62b5\u6263\u5199\u5165\u62b5\u6263\u7528\u9014\uff1a{}", (Object)dto.getOrgId(), (Object)updateDeductionPurpose);
            }
            subList = new ArrayList<ExpenseVoucherDTO>(invoiceData.size());
            List serialNoList = invoiceData.stream().map(t -> (JSONObject)t).filter(t -> StringUtils.isNotBlank((String)t.getString("serialNo"))).map(t -> t.getString("serialNo")).collect(Collectors.toList());
            HashMap<String, Boolean> SerialNoMap = new HashMap<String, Boolean>(invoiceData.size());
            if (!CollectionUtils.isEmpty(serialNoList)) {
                QFilter filter = new QFilter("serial_no", "in", serialNoList);
                DynamicObjectCollection collection = QueryServiceHelper.query((String)"rim_invoice", (String)"invoice_type,serial_no", (QFilter[])new QFilter[]{filter});
                for (DynamicObject object : collection) {
                    if (!StringUtils.isNotBlank((String)object.getString("serial_no")) || object.getLong("invoice_type") <= 0L) continue;
                    long invoiceType = DynamicObjectUtil.getDynamicObjectLongValue(object.getLong("invoice_type"));
                    SerialNoMap.put(object.getString("serial_no"), InputInvoiceTypeEnum.canTransportDeduction(invoiceType));
                }
            }
            for (int i = 0; i < invoiceData.size(); ++i) {
                String deductionFlag;
                JSONObject invoice = invoiceData.getJSONObject(i);
                ExpenseInvoiceDTO invoiceDto = new ExpenseInvoiceDTO();
                Boolean allowRepeat = invoice.getBoolean("isAllowRepeat");
                if (allowRepeat == null) {
                    allowRepeat = Boolean.FALSE;
                }
                invoiceDto.setAllowRepeat(allowRepeat);
                BigDecimal billAmount = CommonUtils.getJsonValue((Map<String, Object>)invoice, BigDecimal.class, "billAmount", "amount");
                invoiceDto.setExpenseAmount(billAmount);
                invoiceDto.setSerialNo(invoice.getString("serialNo"));
                String deductionPurpose = invoice.getString("deductionPurpose");
                invoiceDto.setDeductionPurpose(deductionPurpose);
                String notDeductibleType = invoice.getString("notDeductibleType");
                if ("2".equals(deductionPurpose)) {
                    if (StringUtils.isNotBlank((String)notDeductibleType) && DeductionConstant.NOT_DEDUCTIBLE_TYPE_LIST.contains(notDeductibleType)) {
                        invoiceDto.setNotDeductibleType(notDeductibleType);
                    } else {
                        invoiceDto.setNotDeductibleType("5");
                    }
                }
                if ("true".equals(deductionFlag = invoice.getString("deductionFlag")) || "1".equals(deductionFlag)) {
                    invoiceDto.setDeductionFlag("1");
                } else if ("false".equals(deductionFlag) || "0".equals(deductionFlag)) {
                    invoiceDto.setDeductionFlag("0");
                }
                logger.info("\u5355\u636e\u662f\u5426\u53ef\u62b5\u6263\u5199\u5165\u62b5\u6263\u7528\u9014: \u53d1\u7968\u6d41\u6c34\u53f7: {}, \u4f20\u5165\u7684\u62b5\u6263\u6807\u8bc6deductionFlag\uff1a{}, \u62b5\u6263\u7528\u9014\uff1a{}", new Object[]{invoiceDto.getSerialNo(), invoice.getString("deductionFlag"), invoiceDto.getDeductionPurpose()});
                Boolean canTransportDeduction = false;
                if (StringUtils.isNotBlank((String)invoice.getString("serialNo")) && SerialNoMap.containsKey(invoice.getString("serialNo"))) {
                    canTransportDeduction = (Boolean)SerialNoMap.get(invoice.getString("serialNo"));
                }
                if (!canTransportDeduction.booleanValue() && updateDeductionPurpose && StringUtils.isBlank((String)invoiceDto.getDeductionPurpose()) && StringUtils.isNotBlank((String)deductionFlag)) {
                    invoiceDto.setDeductionFlag("1");
                    logger.info("\u5355\u636e\u662f\u5426\u53ef\u62b5\u6263\u5199\u5165\u62b5\u6263\u7528\u9014 \u53c2\u6570\u751f\u6548, dto\u7684\u62b5\u6263\u6807\u8bc6\uff1a{}", (Object)invoiceDto.getDeductionFlag());
                    if ("true".equals(deductionFlag) || "1".equals(deductionFlag)) {
                        invoiceDto.setDeductionPurpose("1");
                    } else if ("false".equals(deductionFlag) || "0".equals(deductionFlag)) {
                        invoiceDto.setDeductionPurpose("2");
                        if (StringUtils.isNotBlank((String)notDeductibleType) && DeductionConstant.NOT_DEDUCTIBLE_TYPE_LIST.contains(notDeductibleType)) {
                            invoiceDto.setNotDeductibleType(notDeductibleType);
                        } else {
                            invoiceDto.setNotDeductibleType("5");
                        }
                    }
                }
                invoiceDto.setDeductionAmount(invoice.getBigDecimal("deductionTaxAmount"));
                invoiceDto.setEffectiveTaxAmount(invoice.getBigDecimal("effectiveTaxAmount"));
                invoiceDto.setOutputAmount(invoice.getBigDecimal("outputAmount"));
                invoiceDto.setRemark(invoice.getString("remark"));
                invoiceDto.setEntryId(invoice.getString("entryId"));
                invoiceDto.setOriginalState(invoice.getString("originalState"));
                invoiceDto.setOrgId(invoice.getLong("invoiceOrgId"));
                invoiceDto.setExtInfo(invoice.getJSONObject("extInfo"));
                invoiceDto.setInvoiceResource(invoice.getString("invoiceResource"));
                invoiceDto.setInvFolderNo(invoice.getString("invFolderNo"));
                invoiceDto.setInitialInvAmount(invoice.getBigDecimal("initialInvAmount"));
                invoiceDto.setFinalInvAmount(invoice.getBigDecimal("finalInvAmount"));
                invoiceDto.setBillTaxAmount(invoice.getBigDecimal("billTaxAmount"));
                String availabilityRemainAmount = invoice.getString("availabilityRemainAmount");
                if ("Y".equalsIgnoreCase(availabilityRemainAmount)) {
                    invoiceDto.setAvailabilityRemainAmount("1");
                } else if ("N".equalsIgnoreCase(availabilityRemainAmount)) {
                    invoiceDto.setAvailabilityRemainAmount("0");
                }
                invoiceDto.setRolloutTaxAmount(invoice.getBigDecimal("rolloutTaxAmount"));
                invoiceDto.setRolloutReason(invoice.getString("rolloutReason"));
                invoiceDto.setAccountItemCode(invoice.getString("accountItemCode"));
                invoiceDto.setAccountItemDescript(invoice.getString("accountItemDescript"));
                subList.add((ExpenseVoucherDTO)((Object)invoiceDto));
            }
            dto.setInvoiceList(subList);
        }
        dto.setAttachList(jsonObj);
        if (BussinSysBillStatusEnum.BILL_POSTED_TO_ACCOUNTS.getCode().equals(dto.getBussinSysBillStatus()) && (voucherInfo = jsonObj.getJSONArray("voucherInfo")) != null) {
            subList = new ArrayList(voucherInfo.size());
            for (int i = 0; i < voucherInfo.size(); ++i) {
                ExpenseVoucherDTO voucherDTO = new ExpenseVoucherDTO();
                JSONObject voucher = voucherInfo.getJSONObject(i);
                voucherDTO.setResource(resource);
                voucherDTO.setAccountTime(voucher.getString("bookDate"));
                voucherDTO.setBusinessDate(voucher.getString("businessDate"));
                voucherDTO.setVouchId(voucher.getString("voucherId"));
                voucherDTO.setVouchNo(voucher.getString("voucherNo"));
                String accountPeriod = voucher.getString("accountPeriod");
                if (StringUtils.isNotEmpty((String)accountPeriod)) {
                    Date accountDate = DateUtils.matchyyyyMM(accountPeriod = accountPeriod.replaceAll("-", "")) ? DateUtils.stringToDate(accountPeriod, "yyyyMM") : DateUtils.stringToDate(accountPeriod, "yyyyMMdd");
                    voucherDTO.setAccountDate(DateUtils.format(accountDate));
                }
                subList.add(voucherDTO);
            }
            dto.setVoucherList(subList);
        }
        if ((coverData = jsonObj.getJSONObject("coverData")) != null) {
            ArrayList<ExpenseCoverDTO> coverList = new ArrayList<ExpenseCoverDTO>(1);
            ExpenseCoverDTO expenseCoverDTO = new ExpenseCoverDTO();
            expenseCoverDTO.setCoverNo(coverData.getString("coveNo"));
            expenseCoverDTO.setBase64(coverData.getString("base64"));
            expenseCoverDTO.setLocalUrl(coverData.getString("coverFileURL"));
            expenseCoverDTO.setSnapshotUrl(coverData.getString("snapshotUrl"));
            String type = coverData.getString("coveType");
            if (type != null && (type.equalsIgnoreCase("pdf") || "1".equals(type))) {
                expenseCoverDTO.setFileType(1);
            } else {
                expenseCoverDTO.setFileType(2);
            }
            String internal = coverData.getString("internal");
            boolean isInternal = "Y".equalsIgnoreCase(internal) || "1".equals(internal);
            expenseCoverDTO.setInternal(isInternal);
            coverList.add(expenseCoverDTO);
            dto.setCoverDTOList(coverList);
            jsonObj.remove((Object)"coverData");
            jsonObj.put("coverMsg", (Object)String.format(ResManager.loadKDString((String)"\u5c01\u9762\u6570\u91cf%1$s,base64: %2$s", (String)"AbstractFpzsService_0", (String)"imc-rim-common", (Object[])new Object[0]), coverList.size(), StringUtils.length((String)expenseCoverDTO.getBase64())));
            FpzsCommonService.saveExpenseLog(String.valueOf(param.get("rim_operate_method")), billId, billNo, jsonObj.toJSONString());
        } else {
            FpzsCommonService.saveExpenseLog(String.valueOf(param.get("rim_operate_method")), billId, billNo, json);
        }
        return dto;
    }

    public static void setBotpBillList(JSONObject jsonObj, ExpenseDTO dto) {
        try {
            JSONArray botpBillArray = jsonObj.getJSONArray("botpBillList");
            if (botpBillArray != null) {
                ArrayList<Map<String, String>> botpBillList = new ArrayList<Map<String, String>>(botpBillArray.size());
                for (int i = 0; i < botpBillArray.size(); ++i) {
                    JSONObject rowIdObject = botpBillArray.getJSONObject(i);
                    HashMap<String, String> resultMap = new HashMap<String, String>(2);
                    resultMap.put("billId", rowIdObject.getString("billId"));
                    resultMap.put("entityId", rowIdObject.getString("entityId"));
                    botpBillList.add(resultMap);
                }
                dto.setBotpBillList(botpBillList);
            }
        }
        catch (Exception e) {
            logger.info("\u5904\u7406botp\u5173\u8054\u5173\u7cfb\u51fa\u9519");
        }
    }

    public static void saveExpenseLog(String logType, String billId, String billNo, String content) {
        try (TXHandle h = TX.requiresNew();){
            try {
                InvoiceLog.insertExpenseLog(logType, billId, billNo, content);
            }
            catch (Throwable e) {
                h.markRollback();
            }
        }
    }

    public static String getResource(JSONObject param) {
        if (param == null) {
            return " ";
        }
        String bussinSysCode = param.getString("bussinSysCode");
        if (StringUtils.isNotBlank((String)bussinSysCode)) {
            return bussinSysCode;
        }
        return param.getString("resource");
    }
}

