/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.model;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.util.TypeUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.invoice.checknew.model.CheckParam;
import kd.imc.rim.common.invoice.download.InvoiceDownService;
import kd.imc.rim.common.invoice.download.excel.TaxInvoiceConvertUtil;
import kd.imc.rim.common.invoice.model.annotation.CheckConvert;
import kd.imc.rim.common.invoice.model.annotation.NullValidate;
import kd.imc.rim.common.invoice.model.annotation.RecognitionConvert;
import kd.imc.rim.common.invoice.model.annotation.TransportDeductionConvert;
import kd.imc.rim.common.invoice.model.type.ElectricInvoice;
import kd.imc.rim.common.invoice.model.type.MotorInvoice;
import kd.imc.rim.common.invoice.model.type.OrdinaryInvoice;
import kd.imc.rim.common.invoice.model.type.SpecialInvoice;
import kd.imc.rim.common.invoice.model.type.TollInvoice;
import kd.imc.rim.common.invoice.model.type.UsedCarInvoice;
import kd.imc.rim.common.invoice.query.GoodsCodeQueryService;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.InvoiceConvertUtils;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.common.utils.StringRegUtils;

public class ConvertFieldUtil {
    public static final String RECOGNITION = "1";
    public static final String CHECK = "2";
    private static Log logger = LogFactory.getLog(ConvertFieldUtil.class);

    public static Map<String, String[]> getFieldRecognitionRelation(Class clazz) {
        LinkedHashMap relationMap = Maps.newLinkedHashMap();
        if (clazz != null) {
            String[] keys;
            String name;
            RecognitionConvert fieldAnnotation;
            Field[] fields;
            Class superClazz = clazz.getSuperclass();
            if (superClazz != null) {
                for (Field f : fields = superClazz.getDeclaredFields()) {
                    fieldAnnotation = f.getDeclaredAnnotation(RecognitionConvert.class);
                    name = f.getName();
                    if (fieldAnnotation != null) {
                        keys = fieldAnnotation.keys();
                        relationMap.put(name, keys);
                        continue;
                    }
                    relationMap.put(name, new String[]{name});
                }
            }
            for (Field f : fields = clazz.getDeclaredFields()) {
                fieldAnnotation = f.getDeclaredAnnotation(RecognitionConvert.class);
                name = f.getName();
                if (fieldAnnotation != null) {
                    keys = fieldAnnotation.keys();
                    relationMap.put(name, keys);
                    continue;
                }
                relationMap.put(name, new String[]{name});
            }
        }
        return relationMap;
    }

    public static Map<String, String[]> getFieldCheckRelation(Class clazz) {
        LinkedHashMap relationMap = Maps.newLinkedHashMap();
        if (clazz != null) {
            String[] keys;
            String name;
            CheckConvert fieldAnnotation;
            Field[] fields;
            Class superClazz = clazz.getSuperclass();
            if (superClazz != null) {
                for (Field f : fields = superClazz.getDeclaredFields()) {
                    fieldAnnotation = f.getDeclaredAnnotation(CheckConvert.class);
                    name = f.getName();
                    if (fieldAnnotation != null) {
                        keys = fieldAnnotation.keys();
                        relationMap.put(name, keys);
                        continue;
                    }
                    relationMap.put(name, new String[]{name});
                }
            }
            for (Field f : fields = clazz.getDeclaredFields()) {
                fieldAnnotation = f.getDeclaredAnnotation(CheckConvert.class);
                name = f.getName();
                if (fieldAnnotation != null) {
                    keys = fieldAnnotation.keys();
                    relationMap.put(name, keys);
                    continue;
                }
                relationMap.put(name, new String[]{name});
            }
        }
        return relationMap;
    }

    public static Map<String, String> getFieldTransportDeductionRelation(Class clazz) {
        LinkedHashMap relationMap = Maps.newLinkedHashMap();
        if (clazz != null) {
            String name;
            TransportDeductionConvert fieldAnnotation;
            Field[] fields;
            Class superClazz = clazz.getSuperclass();
            if (superClazz != null) {
                for (Field f : fields = superClazz.getDeclaredFields()) {
                    fieldAnnotation = f.getDeclaredAnnotation(TransportDeductionConvert.class);
                    name = f.getName();
                    if (fieldAnnotation == null) continue;
                    relationMap.put(fieldAnnotation.key(), name);
                }
            }
            for (Field f : fields = clazz.getDeclaredFields()) {
                fieldAnnotation = f.getDeclaredAnnotation(TransportDeductionConvert.class);
                name = f.getName();
                if (fieldAnnotation == null) continue;
                relationMap.put(fieldAnnotation.key(), name);
            }
        }
        return relationMap;
    }

    public static CheckParam getInvoiceCheckPart(JSONObject invoiceInfo) {
        if (invoiceInfo == null) {
            return null;
        }
        try {
            Long invoiceType = InputInvoiceTypeEnum.getInvoiceTypeByAwsType(invoiceInfo.getString("invoiceType"));
            String invoiceCode = invoiceInfo.getString("invoiceCode");
            String invoiceNo = invoiceInfo.getString("invoiceNo");
            Date invoiceDate = invoiceInfo.getDate("invoiceDate");
            String checkCode = invoiceInfo.getString("checkCode");
            if (checkCode == null || InputInvoiceTypeEnum.SPECIAL_PAPER.getCode().equals(invoiceType) || InputInvoiceTypeEnum.SPECIAL_ELECTRON.getCode().equals(invoiceType) || InputInvoiceTypeEnum.AIR_ELE_INVOICE.getCode().equals(invoiceType) || InputInvoiceTypeEnum.TRAIN_ELE_INVOICE.getCode().equals(invoiceType)) {
                checkCode = "";
            }
            BigDecimal checkAmount = invoiceInfo.getBigDecimal("invoiceAmount");
            boolean isUsedCar = InputInvoiceTypeEnum.USEDCAR_INVOICE.getCode().equals(invoiceType);
            boolean isElectric = InputInvoiceTypeEnum.needReplaceAmountType(invoiceType);
            if (isUsedCar || isElectric) {
                checkAmount = invoiceInfo.getBigDecimal("totalAmount");
            }
            CheckParam checkParam = new CheckParam(invoiceCode, invoiceNo, invoiceType, invoiceDate, checkAmount, checkCode, null);
            if (kd.bos.util.StringUtils.isNotEmpty((String)invoiceInfo.getString("etaxInvoiceNo"))) {
                checkParam.setEtaxInvoiceNo(invoiceInfo.getString("etaxInvoiceNo"));
            }
            return checkParam;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static CheckParam getInvoiceCheckPart(Object invoiceEntity) {
        if (invoiceEntity == null) {
            return null;
        }
        if (invoiceEntity instanceof OrdinaryInvoice) {
            OrdinaryInvoice ordinaryInvoice = (OrdinaryInvoice)invoiceEntity;
            return new CheckParam(ordinaryInvoice.getInvoiceCode(), ordinaryInvoice.getInvoiceNo(), ordinaryInvoice.getInvoiceType(), ordinaryInvoice.getInvoiceDate(), ordinaryInvoice.getInvoiceAmount(), ordinaryInvoice.getCheckCode(), null);
        }
        if (invoiceEntity instanceof SpecialInvoice) {
            SpecialInvoice specialInvoice = (SpecialInvoice)invoiceEntity;
            return new CheckParam(specialInvoice.getInvoiceCode(), specialInvoice.getInvoiceNo(), specialInvoice.getInvoiceType(), specialInvoice.getInvoiceDate(), specialInvoice.getInvoiceAmount(), specialInvoice.getCheckCode(), null);
        }
        if (invoiceEntity instanceof TollInvoice) {
            TollInvoice tollInvoice = (TollInvoice)invoiceEntity;
            return new CheckParam(tollInvoice.getInvoiceCode(), tollInvoice.getInvoiceNo(), tollInvoice.getInvoiceType(), tollInvoice.getInvoiceDate(), tollInvoice.getInvoiceAmount(), tollInvoice.getCheckCode(), null);
        }
        if (invoiceEntity instanceof MotorInvoice) {
            MotorInvoice motorInvoice = (MotorInvoice)invoiceEntity;
            return new CheckParam(motorInvoice.getInvoiceCode(), motorInvoice.getInvoiceNo(), motorInvoice.getInvoiceType(), motorInvoice.getInvoiceDate(), motorInvoice.getInvoiceAmount(), motorInvoice.getCheckCode(), null);
        }
        if (invoiceEntity instanceof UsedCarInvoice) {
            UsedCarInvoice usedCarInvoice = (UsedCarInvoice)invoiceEntity;
            return new CheckParam(usedCarInvoice.getInvoiceCode(), usedCarInvoice.getInvoiceNo(), usedCarInvoice.getInvoiceType(), usedCarInvoice.getInvoiceDate(), usedCarInvoice.getTotalAmount(), null, null);
        }
        if (invoiceEntity instanceof ElectricInvoice) {
            ElectricInvoice electricInvoice = (ElectricInvoice)invoiceEntity;
            return new CheckParam("", electricInvoice.getInvoiceNo(), null, electricInvoice.getInvoiceDate(), electricInvoice.getTotalAmount(), null, null);
        }
        return null;
    }

    public static Object convertCheckEntityByInvoiceType(Long invoiceType, JSONObject checkResult, String itemsKey) {
        if (invoiceType == null || checkResult == null) {
            return null;
        }
        Class entityClazz = InputInvoiceTypeEnum.getClazzByCode(invoiceType);
        JSONObject invoice = ConvertFieldUtil.convert(entityClazz, checkResult, CHECK);
        ConvertFieldUtil.setType(invoice);
        ConvertFieldUtil.setProxyMark(invoice);
        String totalTaxAmount = invoice.getString("totalTaxAmount");
        BigDecimal finalVal = BigDecimalUtil.transDecimal(totalTaxAmount);
        invoice.put("totalTaxAmount", (Object)finalVal);
        ConvertFieldUtil.setProxySalerInfoByRemark(invoice);
        String type = invoice.getString("type");
        Class itemClazz = InputInvoiceTypeEnum.getItemClazzByCode(invoiceType);
        JSONArray itemsArray = checkResult.getJSONArray(itemsKey);
        if (itemClazz != null && itemsArray != null) {
            JSONArray itemsConvertArray = new JSONArray();
            for (int j = 0; j < itemsArray.size(); ++j) {
                JSONObject invoiceItem = ConvertFieldUtil.convert(itemClazz, itemsArray.getJSONObject(j), CHECK);
                ConvertFieldUtil.dealItemInfo(invoiceItem);
                itemsConvertArray.add((Object)invoiceItem);
            }
            ConvertFieldUtil.setDisCountType(itemsConvertArray, type);
            invoice.put("items", (Object)itemsConvertArray);
        }
        if (invoice.get((Object)"invoiceType") == null) {
            invoice.put("invoiceType", (Object)invoiceType);
        }
        return JSONObject.toJavaObject((JSON)invoice, (Class)entityClazz);
    }

    private static void setType(JSONObject invoice) {
        BigDecimal totalAmount = invoice.getBigDecimal("totalAmount");
        invoice.put("type", (Object)"0");
        if (totalAmount != null && totalAmount.compareTo(BigDecimal.ZERO) < 0) {
            invoice.put("type", (Object)RECOGNITION);
        }
    }

    private static void setProxyMark(JSONObject invoice) {
        String proxyMark = invoice.getString("proxyMark");
        if (kd.bos.util.StringUtils.isEmpty((String)proxyMark)) {
            String salerName = invoice.getString("salerName");
            String remark = invoice.getString("remark");
            if (remark != null && (remark.contains("\u4ee3\u5f00\u53d1\u7968\u7a0e\u52a1\u673a\u6784\u540d\u79f0") || remark.contains("\u4ee3\u5f00\u53d1\u7968\u7a0e\u52a1\u673a\u6784\u4ee3\u7801"))) {
                invoice.put("proxyMark", (Object)RECOGNITION);
                return;
            }
            if (kd.bos.util.StringUtils.isEmpty((String)salerName)) {
                invoice.put("proxyMark", (Object)"0");
            } else if (salerName.contains("\u56fd\u5bb6\u7a0e\u52a1") || salerName.contains("\u4ee3\u5f00")) {
                invoice.put("proxyMark", (Object)RECOGNITION);
            } else {
                invoice.put("proxyMark", (Object)"0");
            }
        }
    }

    public static void setProxySalerInfoByRemark(JSONObject invoice) {
        String proxyMark = invoice.getString("proxyMark");
        String salerTaxNo = "";
        String salerName = "";
        if (RECOGNITION.equals(proxyMark)) {
            String remark = invoice.getString("remark");
            boolean proxyTaxInstitute = false;
            if (kd.bos.util.StringUtils.isNotEmpty((String)remark)) {
                int endIndex;
                if ((remark = StringRegUtils.chineseCharToEnglishChar(remark)).contains("\u4ee3\u5f00\u4f01\u4e1a\u540d\u79f0")) {
                    salerTaxNo = StringUtils.substringBetween((String)remark, (String)"\u4ee3\u5f00\u4f01\u4e1a\u7a0e\u53f7:", (String)"\u4ee3\u5f00\u4f01\u4e1a\u540d\u79f0");
                    salerTaxNo = StringRegUtils.filterChar(salerTaxNo);
                    salerName = StringUtils.substringAfterLast((String)remark, (String)"\u4ee3\u5f00\u4f01\u4e1a\u540d\u79f0").replaceAll(":", "");
                    endIndex = StringRegUtils.getEndIndex(salerName);
                    salerName = salerName.substring(0, endIndex);
                    if (kd.bos.util.StringUtils.isNotEmpty((String)salerTaxNo) && kd.bos.util.StringUtils.isNotEmpty((String)salerName)) {
                        if (salerName.contains("\u56fd\u5bb6\u7a0e\u52a1")) {
                            proxyTaxInstitute = true;
                        }
                        salerTaxNo = salerTaxNo.trim();
                        salerName = salerName.length() > 80 ? salerName.substring(0, 80) : salerName.trim();
                    }
                }
                if (remark.contains("\u4ee3\u5f00\u53d1\u7968\u7a0e\u52a1\u673a\u6784\u540d\u79f0")) {
                    proxyTaxInstitute = true;
                    salerTaxNo = StringUtils.substringBetween((String)remark, (String)"\u4ee3\u5f00\u53d1\u7968\u7a0e\u52a1\u673a\u6784\u4ee3\u7801", (String)"\u4ee3\u5f00\u53d1\u7968\u7a0e\u52a1\u673a\u6784\u540d\u79f0");
                    salerTaxNo = StringRegUtils.filterAllChar(salerTaxNo);
                    salerName = StringUtils.substringAfterLast((String)remark, (String)"\u4ee3\u5f00\u53d1\u7968\u7a0e\u52a1\u673a\u6784\u540d\u79f0");
                    endIndex = StringRegUtils.getEndIndex(salerName);
                    salerName = salerName.substring(0, endIndex).replaceAll(":", "");
                    if (kd.bos.util.StringUtils.isNotEmpty((String)salerTaxNo) && kd.bos.util.StringUtils.isNotEmpty((String)salerName)) {
                        salerTaxNo = salerTaxNo.trim();
                        salerName = salerName.length() > 80 ? salerName.substring(0, 80) : salerName.trim();
                    }
                }
            }
            String proxyMarkRemakeStr = RimConfigUtils.getConfig("rim_recog_check", "proxymarkremake");
            String originalSalerTaxNo = invoice.getString("originalSalerTaxNo");
            String originalSalerName = invoice.getString("originalSalerName");
            if (proxyTaxInstitute) {
                proxyMarkRemakeStr = "0";
            }
            if (!RECOGNITION.equals(proxyMarkRemakeStr)) {
                if (kd.bos.util.StringUtils.isNotEmpty((String)originalSalerTaxNo) && kd.bos.util.StringUtils.isNotEmpty((String)originalSalerName)) {
                    invoice.put("salerTaxNo", (Object)originalSalerTaxNo);
                    invoice.put("salerName", (Object)originalSalerName);
                }
            } else if (kd.bos.util.StringUtils.isNotEmpty((String)salerName)) {
                invoice.put("salerTaxNo", (Object)salerTaxNo);
                invoice.put("salerName", (Object)salerName);
            }
            invoice.put("proxySalerTaxNo", (Object)salerTaxNo);
            invoice.put("proxySalerName", (Object)salerName);
        }
    }

    public static void setDisCountType(JSONArray invoiceItemArray, String type) {
        for (int i = 0; i < invoiceItemArray.size(); ++i) {
            JSONObject item = invoiceItemArray.getJSONObject(i);
            if (RECOGNITION.equals(type)) {
                item.put("discountType", (Object)0);
                continue;
            }
            if (invoiceItemArray.size() == 1) {
                item.put("discountType", (Object)0);
                continue;
            }
            if (i != invoiceItemArray.size() - 1) {
                if (kd.bos.util.StringUtils.isNotEmpty((String)item.getString("detailAmount")) && item.getBigDecimal("detailAmount").compareTo(BigDecimal.ZERO) < 0) {
                    item.put("discountType", (Object)1);
                    continue;
                }
                if (kd.bos.util.StringUtils.isNotEmpty((String)invoiceItemArray.getJSONObject(i + 1).getString("detailAmount")) && invoiceItemArray.getJSONObject(i + 1).getBigDecimal("detailAmount").compareTo(BigDecimal.ZERO) < 0) {
                    item.put("discountType", (Object)2);
                    continue;
                }
                item.put("discountType", (Object)0);
                continue;
            }
            if (kd.bos.util.StringUtils.isNotEmpty((String)item.getString("detailAmount")) && item.getBigDecimal("detailAmount").compareTo(BigDecimal.ZERO) < 0) {
                item.put("discountType", (Object)1);
                continue;
            }
            item.put("discountType", (Object)0);
        }
    }

    public static void convertRecognitionEntity(List entityList, JSONArray recognitionArray, String ... itemsKey) {
        if (recognitionArray == null || recognitionArray.size() == 0) {
            return;
        }
        for (int i = 0; i < recognitionArray.size(); ++i) {
            Long invoiceType;
            Class entityClazz;
            JSONObject invoiceInfo = recognitionArray.getJSONObject(i);
            if (invoiceInfo == null || (entityClazz = InputInvoiceTypeEnum.getClazzByCode(invoiceType = invoiceInfo.getLong("invoiceType"))) == null) continue;
            JSONObject invoice = ConvertFieldUtil.convert(entityClazz, invoiceInfo, RECOGNITION);
            ConvertFieldUtil.setProxyMark(invoice);
            ConvertFieldUtil.setProxySalerInfoByRemark(invoice);
            Set keySet = invoice.keySet();
            keySet.forEach(f -> {
                if (f.contains("Amount") && invoice.get(f) != null && !"".equals(invoice.get(f))) {
                    invoice.put(f, (Object)BigDecimalUtil.transDecimal(invoice.get(f)));
                }
            });
            JSONArray itemsArray = null;
            if (itemsKey != null) {
                for (int j = 0; j < itemsKey.length && (itemsArray = invoiceInfo.getJSONArray(itemsKey[j])) == null; ++j) {
                }
            }
            Class itemClazz = InputInvoiceTypeEnum.getItemClazzByCode(invoiceType);
            if (InputInvoiceTypeEnum.AIR_INVOICE.getCode().equals(invoiceType)) {
                String internationalFlag;
                String string = internationalFlag = kd.bos.util.StringUtils.isEmpty((String)invoiceInfo.getString("international_flag")) ? invoiceInfo.getString("internationalFlag") : invoiceInfo.getString("international_flag");
                if (RECOGNITION.equals(internationalFlag) || CHECK.equals(internationalFlag)) {
                    invoice.put("internationalFlag", (Object)internationalFlag);
                } else {
                    invoice.put("internationalFlag", (Object)RECOGNITION);
                    if ("\u56fd\u9645(I)".equals(internationalFlag)) {
                        invoice.put("internationalFlag", (Object)CHECK);
                    }
                }
                if (invoiceInfo.getJSONArray("flights") != null && invoiceInfo.getJSONArray("flights").size() > 0) {
                    itemsArray = invoiceInfo.getJSONArray("flights");
                }
            }
            if (InputInvoiceTypeEnum.TRAIN_INVOICE.getCode().equals(invoiceType) && kd.bos.util.StringUtils.isNotEmpty((String)invoiceInfo.getString("date_of_issue"))) {
                invoice.put("invoiceDate", (Object)invoiceInfo.getString("date_of_issue"));
            }
            if (InputInvoiceTypeEnum.AIR_ELE_INVOICE.getCode().equals(invoiceType)) {
                String issuingStatus = invoiceInfo.getString("issuingStatus");
                if (kd.bos.util.StringUtils.isNotEmpty((String)issuingStatus)) {
                    String invoiceStateByCN = TaxInvoiceConvertUtil.getInvoiceStateByCN(issuingStatus);
                    invoice.put("issuingStatus", (Object)invoiceStateByCN);
                    invoice.put("invoiceStatus", (Object)invoiceStateByCN);
                }
                if (InputInvoiceTypeEnum.AIR_ELE_INVOICE.getCode().equals(invoiceType)) {
                    try {
                        if (BigDecimalUtil.transDecimal(invoice.get((Object)"ticketPrice")).compareTo(BigDecimal.ZERO) <= 0 && BigDecimalUtil.transDecimal(invoice.get((Object)"invoiceAmount")).compareTo(BigDecimal.ZERO) > 0) {
                            invoice.put("ticketPrice", (Object)invoice.getBigDecimal("invoiceAmount"));
                            BigDecimal totalAmount = invoice.getBigDecimal("totalAmount");
                            BigDecimal taxAmount = CommonUtils.getJsonValue((Map<String, Object>)invoice, BigDecimal.class, "taxAmount", "totalTaxAmount");
                            BigDecimal invoiceAmount = totalAmount.subtract(taxAmount);
                            invoice.put("invoiceAmount", (Object)invoiceAmount);
                        }
                    }
                    catch (Exception e) {
                        logger.error("\u6570\u7535\u98de\u673a\u7968\uff0c\u8bbe\u7f6e\u4e0d\u542b\u7a0e\u91d1\u989d\u62a5\u9519, \u53d1\u7968\u53f7\u7801\uff1a" + invoiceInfo.getString("invoiceNo"), (Throwable)e);
                    }
                }
            }
            if (InputInvoiceTypeEnum.OVERSEA_INVOICE.getCode().equals(invoiceType)) {
                for (int j = 1; j < 6; ++j) {
                    String taxRate = invoice.getString("taxRate" + j);
                    if (kd.bos.util.StringUtils.isEmpty((String)taxRate) || !taxRate.contains("%")) continue;
                    taxRate = taxRate.replace("%", "");
                    invoice.put("taxRate" + j, (Object)BigDecimalUtil.transDecimal(taxRate).divide(new BigDecimal("100")));
                }
            }
            if (itemClazz != null && itemsArray != null) {
                JSONArray itemsConvertArray = new JSONArray();
                for (int j = 0; j < itemsArray.size(); ++j) {
                    JSONObject invoiceItem = ConvertFieldUtil.convert(itemClazz, itemsArray.getJSONObject(j), RECOGNITION);
                    ConvertFieldUtil.dealItemInfo(invoiceItem);
                    itemsConvertArray.add((Object)invoiceItem);
                }
                invoice.put("items", (Object)itemsConvertArray);
            }
            Object entity = JSONObject.toJavaObject((JSON)invoice, (Class)entityClazz);
            entityList.add(entity);
        }
    }

    private static void dealItemInfo(JSONObject invoiceItem) {
        String taxRate = invoiceItem.getString("taxRate");
        if (kd.bos.util.StringUtils.isNotEmpty((String)taxRate) && (taxRate.contains("\u514d\u7a0e") || taxRate.contains("\u4e0d\u5f81") || taxRate.equals("\u96f6\u7a0e\u7387"))) {
            invoiceItem.put("taxRate", (Object)"0");
            if (taxRate.contains("\u514d\u7a0e")) {
                invoiceItem.put("zeroTaxRateFlag", (Object)RECOGNITION);
            } else if (taxRate.contains("\u4e0d\u5f81")) {
                invoiceItem.put("zeroTaxRateFlag", (Object)CHECK);
            } else if (taxRate.contains("\u96f6\u7a0e\u7387")) {
                invoiceItem.put("zeroTaxRateFlag", (Object)"3");
            }
        }
        Set keySet = invoiceItem.keySet();
        keySet.stream().forEach(f -> {
            if (f.contains("Amount") || "unitPrice".equals(f)) {
                invoiceItem.put(f, (Object)BigDecimalUtil.transDecimal(invoiceItem.get(f)));
            }
        });
        String goodsCode = invoiceItem.getString("goodsCode");
        String goodsName = invoiceItem.getString("goodsName");
        if (kd.bos.util.StringUtils.isNotEmpty((String)taxRate) && taxRate.contains("%")) {
            taxRate = taxRate.replace("%", "");
            invoiceItem.put("taxRate", (Object)BigDecimalUtil.transDecimal(taxRate).divide(new BigDecimal("100")));
        }
        if (kd.bos.util.StringUtils.isEmpty((String)goodsCode) && kd.bos.util.StringUtils.isNotEmpty((String)goodsName)) {
            invoiceItem.put("goodsCode", (Object)GoodsCodeQueryService.getGoodsCodeByName((String)goodsName));
        }
    }

    public static JSONObject convert(Class entityClazz, JSONObject invoiceInfo, String convertType) {
        JSONObject invoice = new JSONObject();
        Map<Object, Object> relationMap = Maps.newHashMap();
        if (RECOGNITION.equals(convertType)) {
            relationMap = ConvertFieldUtil.getFieldRecognitionRelation(entityClazz);
        } else if (CHECK.equals(convertType)) {
            relationMap = ConvertFieldUtil.getFieldCheckRelation(entityClazz);
        }
        for (Map.Entry entries : invoiceInfo.entrySet()) {
            String key = (String)entries.getKey();
            Object value = entries.getValue();
            for (Map.Entry<Object, Object> entry : relationMap.entrySet()) {
                String[] annotationKeys = (String[])entry.getValue();
                List<String> list = Arrays.asList(annotationKeys);
                if (!list.contains(key)) continue;
                String key1 = (String)entry.getKey();
                Object modelValue = invoice.get(entry.getKey());
                boolean isEmpty = modelValue == null || kd.bos.util.StringUtils.isEmpty((String)modelValue.toString());
                if (!isEmpty) continue;
                Field f = null;
                try {
                    f = entityClazz.getDeclaredField(key1);
                }
                catch (Exception e) {
                    try {
                        f = entityClazz.getSuperclass().getDeclaredField(key1);
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        // empty catch block
                    }
                }
                if (f == null) continue;
                Class<Date> type = f.getType();
                if (type.isAssignableFrom(Date.class) && value instanceof String) {
                    try {
                        String valueDate = (String)value;
                        if (!kd.bos.util.StringUtils.isEmpty((String)valueDate) && valueDate.indexOf(46) != -1) {
                            valueDate = valueDate.substring(0, valueDate.indexOf(46));
                        }
                        invoice.put((String)entry.getKey(), (Object)TypeUtils.castToDate((Object)valueDate));
                    }
                    catch (Exception e) {
                        logger.info("\u65e5\u671f\u8f6c\u6362\u5f02\u5e38[{}]", value);
                    }
                    continue;
                }
                invoice.put((String)entry.getKey(), value);
            }
        }
        return invoice;
    }

    public static boolean checkNullValidate(JSONObject recognitionInfo, Class clazz) {
        if (recognitionInfo == null) {
            return false;
        }
        Long invoiceType = recognitionInfo.getLong("invoiceType");
        Map<String, List<String>> result = ConvertFieldUtil.getNeedCheckList(invoiceType, clazz);
        List<String> needCheckList = result.get("result");
        List<String> superList = result.get("super");
        if (CollectionUtils.isEmpty(needCheckList)) {
            return true;
        }
        List collect = needCheckList.stream().filter(f -> ObjectUtils.isEmpty((Object)recognitionInfo.get(f))).collect(Collectors.toList());
        if (InvoiceConvertUtils.isVatInvoiceType(invoiceType)) {
            collect.removeAll(superList);
        }
        return CollectionUtils.isEmpty(collect);
    }

    private static Map<String, List<String>> getNeedCheckList(Long invoiceType, Class clazz) {
        HashMap resultMap = Maps.newHashMap();
        ArrayList result = Lists.newArrayList();
        ArrayList superResult = Lists.newArrayList();
        if (clazz != null) {
            String[] exclude;
            boolean isContains;
            NullValidate fieldAnnotation;
            Field[] fields;
            Class superClazz = clazz.getSuperclass();
            if (superClazz != null) {
                for (Field f : fields = superClazz.getDeclaredFields()) {
                    fieldAnnotation = f.getDeclaredAnnotation(NullValidate.class);
                    if (fieldAnnotation == null || (isContains = Arrays.asList(exclude = fieldAnnotation.exclude()).contains(String.valueOf(invoiceType)))) continue;
                    result.add(f.getName());
                    superResult.add(f.getName());
                }
            }
            for (Field f : fields = clazz.getDeclaredFields()) {
                fieldAnnotation = f.getDeclaredAnnotation(NullValidate.class);
                if (fieldAnnotation == null || (isContains = Arrays.asList(exclude = fieldAnnotation.exclude()).contains(String.valueOf(invoiceType)))) continue;
                result.add(f.getName());
            }
        }
        resultMap.put("super", superResult);
        resultMap.put("result", result);
        return resultMap;
    }

    public static int checkCustomOrFinancialByTitle(JSONObject invoiceInfo) {
        if (invoiceInfo == null || invoiceInfo.size() == 0) {
            return 0;
        }
        String title = invoiceInfo.getString("title");
        if (kd.bos.util.StringUtils.isEmpty((String)title)) {
            return 0;
        }
        String checkCustom = ".*\u6d77\u5173.*\u4e13\u7528\u7f34\u6b3e\u4e66";
        if (Pattern.matches(checkCustom, title)) {
            return 21;
        }
        String checkFinancial = ".*\u7968\u636e[(]?\u7535\u5b50[)]?";
        if (Pattern.matches(checkFinancial, title)) {
            return 25;
        }
        return 0;
    }

    public static void getStandardInvoice(JSONObject invoiceInfo) {
        String pixel;
        String remark;
        String checkCode = invoiceInfo.getString("checkCode");
        if (StringUtils.isNotEmpty((CharSequence)checkCode) && checkCode.length() > 6) {
            invoiceInfo.put("checkCode", (Object)checkCode.substring(checkCode.length() - 6));
        }
        String invoiceNo = invoiceInfo.getString("invoiceNo");
        Long invoiceType = invoiceInfo.getLong("invoiceType");
        if (!InputInvoiceTypeEnum.OVERSEA_RECEIPT.getCode().equals(invoiceType) && !InputInvoiceTypeEnum.OVERSEA_INVOICE.getCode().equals(invoiceType) && !InputInvoiceTypeEnum.isEleInvoice(invoiceType).booleanValue() && kd.bos.util.StringUtils.isNotEmpty((String)invoiceNo) && invoiceNo.length() > 32) {
            invoiceNo = invoiceNo.substring(0, 8);
            invoiceInfo.put("invoiceNo", (Object)invoiceNo);
        }
        if (StringUtils.isNotEmpty((CharSequence)(remark = invoiceInfo.getString("remark")))) {
            invoiceInfo.put("remark", (Object)StringRegUtils.filterChar(remark));
        }
        if (StringUtils.isNotEmpty((CharSequence)(pixel = invoiceInfo.getString("invoiceInfo")))) {
            pixel = pixel.replace("[", "").replace("]", "");
            invoiceInfo.put("pixel", (Object)pixel);
        }
    }

    public static void mixLqPartField(JSONObject cyjgObj, Long invoiceType) {
        if (cyjgObj == null) {
            return;
        }
        String kjlx = cyjgObj.getString("kjlx");
        if (RECOGNITION.equals(kjlx)) {
            cyjgObj.put("kjlx", (Object)"0");
        } else if (CHECK.equals(kjlx)) {
            cyjgObj.put("kjlx", (Object)RECOGNITION);
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)cyjgObj.getString("gmfkhh")) || kd.bos.util.StringUtils.isNotEmpty((String)cyjgObj.getString("gmfzh"))) {
            cyjgObj.put("gmfkhh", (Object)(ConvertFieldUtil.getSafeStr(cyjgObj.getString("gmfkhh")) + ConvertFieldUtil.getSafeStr(cyjgObj.getString("gmfzh"))));
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)cyjgObj.getString("xsfkhh")) || kd.bos.util.StringUtils.isNotEmpty((String)cyjgObj.getString("xsfzh"))) {
            cyjgObj.put("xsfkhh", (Object)(ConvertFieldUtil.getSafeStr(cyjgObj.getString("xsfkhh")) + ConvertFieldUtil.getSafeStr(cyjgObj.getString("xsfzh"))));
        }
        if (InputInvoiceTypeEnum.AIR_ELE_INVOICE.getCode().equals(invoiceType)) {
            InvoiceDownService.converAirEleInvocie(cyjgObj);
        } else if (InputInvoiceTypeEnum.TRAIN_ELE_INVOICE.getCode().equals(invoiceType)) {
            InvoiceDownService.converTrainEleInvocie(cyjgObj);
            if (kd.bos.util.StringUtils.isNotEmpty((String)cyjgObj.getString("gmfdz")) || kd.bos.util.StringUtils.isNotEmpty((String)cyjgObj.getString("gmflxdh"))) {
                cyjgObj.put("gmfdz", (Object)(ConvertFieldUtil.getSafeStr(cyjgObj.getString("gmfdz")) + ConvertFieldUtil.getSafeStr(cyjgObj.getString("gmflxdh"))));
            }
            if (kd.bos.util.StringUtils.isNotEmpty((String)cyjgObj.getString("xsfdz")) || kd.bos.util.StringUtils.isNotEmpty((String)cyjgObj.getString("xsflxdh"))) {
                cyjgObj.put("xsfdz", (Object)(ConvertFieldUtil.getSafeStr(cyjgObj.getString("xsfdz")) + ConvertFieldUtil.getSafeStr(cyjgObj.getString("xsflxdh"))));
            }
        } else if (InputInvoiceTypeEnum.TOLL_ELECTRON.getCode().equals(invoiceType)) {
            InvoiceDownService.convertToll(cyjgObj);
        } else if (InputInvoiceTypeEnum.ORDINARY_ROLL.getCode().equals(invoiceType)) {
            JSONArray hwxx = cyjgObj.getJSONArray("hwxx");
            if (!CollectionUtils.isEmpty((Collection)hwxx)) {
                for (int i = 0; i < hwxx.size(); ++i) {
                    hwxx.getJSONObject(i).put("hwhyslwfwmc", hwxx.getJSONObject(i).get((Object)"xm"));
                    hwxx.getJSONObject(i).put("dj", hwxx.getJSONObject(i).get((Object)"hsdj"));
                    hwxx.getJSONObject(i).put("je", hwxx.getJSONObject(i).get((Object)"hsje"));
                }
            }
        } else if (InputInvoiceTypeEnum.USEDCAR_INVOICE.getCode().equals(invoiceType)) {
            cyjgObj.put("fphm", (Object)cyjgObj.getString("zzfphm"));
            cyjgObj.put("jshj", (Object)BigDecimalUtil.transDecimal(cyjgObj.get((Object)"cjhj")));
        }
    }

    public static String getSafeStr(String val) {
        if (val == null) {
            return "";
        }
        return val;
    }
}

