/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.query;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.MetadataUtil;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;

public class AttachQueryService {
    private static Log LOGGER = LogFactory.getLog(AttachQueryService.class);
    private static final String mainFields = "id, attach_name, create_time, remark, attach_url, icon_url, snapshot_url, attach_type, attach_hash_value,update_time,attach_no";

    public DynamicObjectCollection queryByFilter(QFilter qFilter, String orderBys, int top) {
        return QueryServiceHelper.query((String)"rim_attach", (String)mainFields, (QFilter[])new QFilter[]{qFilter}, (String)orderBys, (int)top);
    }

    public DynamicObject[] loadByFilterOrderBy(QFilter qFilter, String orderBys) {
        return BusinessDataServiceHelper.load((String)"rim_attach", (String)mainFields, (QFilter[])new QFilter[]{qFilter}, (String)orderBys);
    }

    public DynamicObjectCollection findByFilter(QFilter qFilter) {
        return QueryServiceHelper.query((String)"rim_attach_relation", (String)"attach_id", (QFilter[])new QFilter[]{qFilter});
    }

    public JSONArray queryFpzsAttach(String expenseId, String entityId, String resource, boolean queryDb) {
        String key = this.getAttachKey(expenseId, entityId, resource);
        String cacheStr = CacheHelper.get(key);
        JSONArray attachCacheArray = new JSONArray();
        if (!StringUtils.isEmpty((CharSequence)cacheStr)) {
            attachCacheArray = JSONArray.parseArray((String)cacheStr);
        }
        if (!queryDb) {
            return attachCacheArray;
        }
        HashSet<String> idSet = new HashSet<String>(2);
        idSet.add(expenseId);
        String awsExpenseId = null;
        if (StringUtils.isNotEmpty((CharSequence)entityId) && !expenseId.startsWith(entityId)) {
            awsExpenseId = entityId + '_' + expenseId;
            idSet.add(awsExpenseId);
        }
        QFilter expesneFilter = new QFilter("expense_id", "in", idSet);
        DynamicObjectCollection relationCollection = QueryServiceHelper.query((String)"rim_attach_relation", (String)"attach_id,expense_id,relation_id", (QFilter[])new QFilter[]{expesneFilter}, (String)"id");
        LOGGER.info("\u67e5\u8be2\u53d1\u7968\u52a9\u624b\uff0c\u6761\u4ef6\uff1a{}\uff0c\u7ed3\u679c\uff1a{}", (Object)expesneFilter, (Object)relationCollection);
        List<Long> attachIdList = new ArrayList<Long>(relationCollection.size());
        HashMap<Long, String> serialMap = new HashMap<Long, String>(relationCollection.size());
        for (DynamicObject relation : relationCollection) {
            Long id = BigDecimalUtil.transDecimal(relation.getString("attach_id")).longValue();
            if (id <= 0L) continue;
            attachIdList.add(id);
            String serialNo = relation.getString("relation_id");
            if (StringUtils.isEmpty((CharSequence)serialNo)) continue;
            serialMap.put(id, serialNo);
        }
        ArrayList attIndex = com.google.common.collect.Lists.newArrayList(attachIdList);
        List cacheAttachIds = attachCacheArray.stream().map(v -> ((JSONObject)v).getLong("attachId")).collect(Collectors.toList());
        attIndex.addAll(cacheAttachIds);
        LOGGER.info("\u9644\u4ef6\u987a\u5e8f\uff1a" + attIndex);
        if (!attachIdList.isEmpty()) {
            if (!CollectionUtils.isEmpty(cacheAttachIds)) {
                attachIdList = attachIdList.stream().filter(e -> !cacheAttachIds.contains(e)).collect(Collectors.toList());
            }
            QFilter idFilter = new QFilter("id", "in", attachIdList);
            JSONArray attaches = this.queryFpzsAttach(idFilter);
            attaches.forEach(e -> ((JSONObject)e).put("serialNo", (Object)serialMap.getOrDefault((Long)((JSONObject)e).get((Object)"attachId"), "")));
            attachCacheArray.addAll((Collection)attaches);
        }
        attachCacheArray.sort((o1, o2) -> attIndex.indexOf(((JSONObject)o1).getLong("attachId")) - attIndex.indexOf(((JSONObject)o2).getLong("attachId")));
        LOGGER.info("\u9644\u4ef6\u4fe1\u606f\uff1a" + attachCacheArray);
        return attachCacheArray;
    }

    public JSONArray queryFpzsAttach(List<Object> attachIds) {
        QFilter filter = new QFilter("attach_no", "in", attachIds);
        return this.queryFpzsAttach(filter);
    }

    private JSONArray queryFpzsAttach(QFilter filter) {
        JSONArray attaches = new JSONArray();
        String fields = MetadataUtil.getFields((String)"rim_attach");
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"rim_attach", (String)fields, (QFilter[])new QFilter[]{filter});
        int i = 0;
        for (DynamicObject att : collection) {
            ++i;
            Long id = att.getLong("id");
            JSONObject dataJson = new JSONObject();
            dataJson.put("attachId", att.get("id"));
            dataJson.put("attachUrl", att.get("attach_url"));
            dataJson.put("attachType", att.get("attach_type"));
            dataJson.put("attachNo", (Object)(att.getString("attach_no") + i));
            dataJson.put("attachNo_1", (Object)att.getString("attach_no"));
            dataJson.put("attachName", att.get("attach_name"));
            dataJson.put("remark", att.get("remark"));
            dataJson.put("snapshotUrl", att.get("snapshot_url"));
            dataJson.put("originalFileName", att.get("original_name"));
            dataJson.put("fileExtension", att.get("file_extension"));
            dataJson.put("attachIcon", att.get("icon_url"));
            dataJson.put("attachSize", att.get("size"));
            dataJson.put("attachCategory", att.get("attach_category"));
            dataJson.put("createTime", (Object)DateUtils.format(att.getDate("create_time"), "yyyy-MM-dd HH:mm:ss"));
            attaches.add((Object)dataJson);
        }
        return attaches;
    }

    public void addFpzsAttach(String expenseId, String entityId, String resource, JSONArray array) {
        if (CollectionUtils.isEmpty((Collection)array)) {
            return;
        }
        String key = this.getAttachKey(expenseId, entityId, resource);
        String cacheStr = CacheHelper.get(key);
        if (StringUtils.isEmpty((CharSequence)cacheStr)) {
            this.cacheFpzsAttach(expenseId, entityId, resource, array);
        } else {
            JSONObject obj;
            int i;
            JSONArray attachCacheArray = JSONArray.parseArray((String)cacheStr);
            ArrayList attIndex = com.google.common.collect.Lists.newArrayListWithExpectedSize((int)(attachCacheArray.size() + array.size()));
            HashMap<String, JSONObject> map = new HashMap<String, JSONObject>(array.size());
            HashMap<String, JSONObject> map2 = new HashMap<String, JSONObject>(attachCacheArray.size());
            for (i = 0; i < attachCacheArray.size(); ++i) {
                obj = attachCacheArray.getJSONObject(i);
                attIndex.add(obj.getLong("attachId"));
                String attachId = obj.getString("attachId");
                JSONObject newValue = (JSONObject)map.get(attachId);
                if (newValue != null) {
                    attachCacheArray.set(i, (Object)newValue);
                }
                map2.put(attachId, obj);
            }
            for (i = 0; i < array.size(); ++i) {
                obj = array.getJSONObject(i);
                attIndex.add(obj.getLong("attachId"));
                map.put(obj.getString("attachId"), obj);
            }
            for (Map.Entry entry : map.entrySet()) {
                if (map2.containsKey(entry.getKey())) continue;
                attachCacheArray.add(entry.getValue());
            }
            attachCacheArray.sort((o1, o2) -> attIndex.indexOf(((JSONObject)o1).getLong("attachId")) - attIndex.indexOf(((JSONObject)o2).getLong("attachId")));
            this.cacheFpzsAttach(expenseId, entityId, resource, attachCacheArray);
        }
    }

    public void deleteFpzsAttach(String expenseId, String entityId, String resource, List<String> attachIds) {
        String key = this.getAttachKey(expenseId, entityId, resource);
        String cacheStr = CacheHelper.get(key);
        if (!StringUtils.isEmpty((CharSequence)cacheStr)) {
            JSONArray attachCacheArray = JSONArray.parseArray((String)cacheStr);
            Iterator it = attachCacheArray.iterator();
            while (it.hasNext()) {
                JSONObject value = (JSONObject)it.next();
                if (!attachIds.contains(value.getString("attachId"))) continue;
                it.remove();
            }
            this.cacheFpzsAttach(expenseId, entityId, resource, attachCacheArray);
        }
        QFilter awsExpenseFilter = null;
        if (StringUtils.isNotEmpty((CharSequence)entityId) && !expenseId.startsWith(entityId)) {
            String awsExpenseId = entityId + '_' + expenseId;
            awsExpenseFilter = new QFilter("expense_id", "=", (Object)awsExpenseId);
        }
        QFilter expesneFilter = new QFilter("expense_id", "=", (Object)expenseId).or(awsExpenseFilter);
        QFilter idFilter = new QFilter("attach_id", "in", attachIds);
        DeleteServiceHelper.delete((String)"rim_attach_relation", (QFilter[])new QFilter[]{expesneFilter, idFilter});
    }

    public void cacheFpzsAttach(String expenseId, String entityId, String resource, JSONArray array) {
        String key = this.getAttachKey(expenseId, entityId, resource);
        if (CollectionUtils.isEmpty((Collection)array)) {
            CacheHelper.remove(key);
        } else {
            String dateStr = DateUtils.format(new Date(), "yyyy-MM-dd HH:mm:ss");
            for (int i = 0; i < array.size(); ++i) {
                JSONObject obj = array.getJSONObject(i);
                obj.put("attachNo_1", (Object)obj.getString("attachNo"));
                if (obj.getString("attachNo").contains("_")) {
                    obj.put("attachNo", (Object)(obj.getString("attachNo") + i));
                    array.set(i, (Object)obj);
                }
                if (obj.get((Object)"createTime") != null) continue;
                if (obj.getDate("uploadDate") != null) {
                    obj.put("createTime", (Object)DateUtils.format(obj.getDate("uploadDate"), "yyyy-MM-dd HH:mm:ss"));
                } else {
                    obj.put("createTime", (Object)dateStr);
                }
                array.set(i, (Object)obj);
            }
            CacheHelper.put(key, array.toJSONString(), 7200);
        }
    }

    public String getAttachUrl(DynamicObject attachObj) {
        String attachType = attachObj.getString("attach_type");
        String snapshotUrl = attachObj.getString("snapshot_url");
        String iconUrl = attachObj.getString("icon_url");
        String attachUrl = attachObj.getString("attach_url");
        return this.getAttachUrl(attachType, snapshotUrl, iconUrl, attachUrl);
    }

    public String getAttachUrl(String attachType, String snapshotUrl, String iconUrl, String attachUrl) {
        if ("2".equals(attachType) && !StringUtils.isEmpty((CharSequence)attachUrl)) {
            return attachUrl;
        }
        if (!StringUtils.isEmpty((CharSequence)snapshotUrl)) {
            return snapshotUrl;
        }
        return iconUrl;
    }

    private String getAttachKey(String expenseId, String entityId, String resource) {
        if (StringUtils.isNotEmpty((CharSequence)entityId)) {
            return "CACHE_INVOICE_ATTACH" + expenseId + StringUtils.trimToEmpty((String)entityId);
        }
        return "CACHE_INVOICE_ATTACH" + expenseId + StringUtils.trimToEmpty((String)resource);
    }

    public JSONObject getAttachsByInvoiceSerialNo(List<String> serialNoList) {
        JSONObject result = new JSONObject();
        QFilter attachFilter = new QFilter("relation_id", "in", serialNoList);
        QFilter typeFilter = new QFilter("relation_type", "=", (Object)"3");
        DynamicObjectCollection collect = QueryServiceHelper.query((String)"rim_attach_relation", (String)"id,attach_id,relation_id", (QFilter[])new QFilter[]{attachFilter, typeFilter});
        if (!CollectionUtils.isEmpty((Collection)collect)) {
            ArrayList attachIdList = new ArrayList(collect.size());
            collect.forEach(obj -> attachIdList.add(BigDecimalUtil.transDecimal(obj.get("attach_id")).longValue()));
            DynamicObject[] attachList = BusinessDataServiceHelper.load((Object[])attachIdList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"rim_attach"));
            HashMap<String, DynamicObject> attachMap = new HashMap<String, DynamicObject>(serialNoList.size());
            for (DynamicObject attach : attachList) {
                attachMap.put(attach.get("id").toString(), attach);
            }
            for (DynamicObject relation : collect) {
                String serialNo = relation.getString("relation_id");
                String attachId = relation.getString("attach_id");
                DynamicObject att = (DynamicObject)attachMap.get(attachId);
                if (att == null) continue;
                JSONArray array = result.getJSONArray(serialNo);
                if (array == null) {
                    array = new JSONArray();
                }
                array.add((Object)this.coverInvoiceAttach(att, serialNo));
                result.put(serialNo, (Object)array);
            }
        }
        return result;
    }

    public DynamicObject[] getAttachsByInvoiceSerialNo(String serialNo) {
        ArrayList typeList = Lists.newArrayList();
        typeList.add("2");
        typeList.add("3");
        QFilter attachFilter = new QFilter("relation_id", "=", (Object)serialNo);
        QFilter typeFilter = new QFilter("relation_type", "in", (Object)typeList);
        DynamicObjectCollection collect = QueryServiceHelper.query((String)"rim_attach_relation", (String)"id,attach_id", (QFilter[])new QFilter[]{attachFilter, typeFilter});
        if (!CollectionUtils.isEmpty((Collection)collect)) {
            HashSet attachIdList = new HashSet(collect.size());
            collect.forEach(obj -> attachIdList.add(BigDecimalUtil.transDecimal(obj.get("attach_id")).longValue()));
            return BusinessDataServiceHelper.load((Object[])attachIdList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"rim_attach"));
        }
        return null;
    }

    public JSONArray getAttachsMapByInvoiceSerialNo(String serialNo) {
        Object[] attachs = this.getAttachsByInvoiceSerialNo(serialNo);
        if (!ObjectUtils.isEmpty((Object[])attachs)) {
            JSONArray array = new JSONArray();
            for (Object obj : attachs) {
                array.add((Object)this.coverInvoiceAttach((DynamicObject)obj, serialNo));
            }
            return array;
        }
        return null;
    }

    private JSONObject coverInvoiceAttach(DynamicObject obj, String serialNo) {
        JSONObject json = new JSONObject();
        json.put("id", (Object)obj.getLong("id"));
        json.put("attachNo", (Object)obj.getString("attach_no"));
        json.put("localUrl", (Object)obj.getString("attach_url"));
        json.put("snapshotUrl", (Object)obj.getString("snapshot_url"));
        json.put("attachName", (Object)obj.getString("attach_name"));
        json.put("attachCategory", (Object)obj.getString("attach_category_id"));
        try {
            json.put("attachCategoryNo", obj.getDynamicObject("attach_category").get("number"));
            ILocaleString local = obj.getDynamicObject("attach_category").getLocaleString("name");
            json.put("attachCategoryName", (Object)local.getLocaleValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
        json.put("fileType", (Object)obj.getString("attach_type"));
        json.put("attachRemark", (Object)obj.getString("remark"));
        json.put("createTime", (Object)obj.getDate("create_time"));
        json.put("fileExtension", obj.get("file_extension"));
        json.put("serialNo", (Object)serialNo);
        return json;
    }

    public void cacheFpzsPushAttachs(String billId, String entityId, String resource, JSONArray attachCacheArray) {
        String key = this.getAttachKey(billId, entityId, resource);
        CacheHelper.remove(key);
        if (!CollectionUtils.isEmpty((Collection)attachCacheArray)) {
            this.cacheFpzsAttach(billId, entityId, resource, attachCacheArray);
        }
    }
}

